--

\set VERBOSITY terse

--

create function pg_temp.tmp1(n text) returns text
  language plluau immutable strict
  as $$ return (require "pllua.paths")[n]() $$;

-- some of the dirs might not actually exist, so we test only the
-- important ones. We can't actually test that the dir exists or what
-- the contents are, since many pg versions reject pg_stat_file on
-- absolute paths; so just check that we got some string that looks
-- like a path.
select u.n, f.path ~ '^(?:[[:alpha:]]:)?/'
  from unnest(array['bin','lib','libdir','pkglib','share'])
         with ordinality as u(n,ord),
       pg_temp.tmp1(u.n) f(path)
 order by u.ord;

--end
