%define themename hot-dog
%define set_theme %{_sbindir}/plymouth-set-default-theme
Name:           plymouth-theme-%{themename}
Version:        0.5
Release:        1%{?dist}
Summary:        Plymouth Happy Hot Dog Theme

Group:          System Environment/Base
License:        CC-BY-SA
URL:            http://wwoods.fedorapeople.org/hot-dog/
Source0:        %{name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
Requires:       plymouth-plugin-two-step >= 0.7.0
Requires:       plymouth-scripts

%description
This package contains the Happy Hot Dog boot splash theme for Plymouth.
The mustard indicates progress.

%prep
%setup -q

%build
# nada

%install
targetdir=$RPM_BUILD_ROOT/%{_datadir}/plymouth/themes/%{themename}
rm -rf $RPM_BUILD_ROOT
install -d -m 0755 $targetdir
install -m 0644 %{themename}.plymouth *.png $targetdir

%post
export LIB=%{_lib}
if [ $1 -eq 1 ]; then
    %{set_theme} %{themename}
fi
if [ "$(%{set_theme})" == "%{themename}" ]; then
    %{_libexecdir}/plymouth/plymouth-generate-initrd &>/dev/null
    source /etc/sysconfig/kernel &>/dev/null || :
    /sbin/new-kernel-pkg --package ${DEFAULTKERNEL:-kernel} --mkinitrd --depmod --dracut --update $(uname -r)
fi

%postun
export LIB=%{_lib}
# if uninstalling, reset to boring meatless default theme
if [ $1 -eq 0 ]; then
    if [ "$(%{set_theme})" == "%{themename}" ]; then
        %{set_theme} --reset
        %{_libexecdir}/plymouth/plymouth-generate-initrd &>/dev/null
        source /etc/sysconfig/kernel &>/dev/null || :
        /sbin/new-kernel-pkg --package ${DEFAULTKERNEL:-kernel} --mkinitrd --depmod --dracut --update $(uname -r)
    fi
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc README
%dir %{_datadir}/plymouth/themes/%{themename}
%{_datadir}/plymouth/themes/%{themename}/*.png
%{_datadir}/plymouth/themes/%{themename}/%{themename}.plymouth

%changelog
* Thu Nov 03 2011 Will Woods <wwoods@redhat.com> - 0.5-1
- Update README with more links and proper credit for the Hot Dog Creator
- Well more like "The original artist", the Hot Dog is his own Creator
- He is a perfect being who exists beyond Time and Space
- He is a being of pure Delight and Deliciousness
- He transcends the false Beefy/Vegetarian dichotomy
- He tastes really good with mustard
- OBEY THE HOT-DOG, FLOAT WITH HIM INTO ETERNITY
- Various bugfixes

* Sun Oct 02 2011 Will Woods <wwoods@redhat.com> - 0.4-1
- LIVE FROM MILAN IT'S HOT DOG TIME
- Fixed license field
- Updated README
- Rebuild with -funroll-loops
- Hot dog seems much happier

* Tue Mar 15 2011 Will Woods <wwoods@redhat.com> - 0.3-1
- Fix %%post to enable the Beefy Miracle immediately after installation
- Package removal restores bland, meatless default theme
- Package removal does NOT format hard drive or render the user blind/sterile
- Mustard now also indicates victory

* Mon Nov 02 2009 Will Woods <wwoods@redhat.com> - 0.2-1
- Fixed missing progress-01.png

* Fri Oct 30 2009 Will Woods <wwoods@redhat.com> - 0.1-1
- Initial packaging. The mustard indicates progress.
