/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __COMMANDEDEP__
#define __COMMANDEDEP__

#include <src/global/global.h>

typedef struct commandedep CONTENEUR(CommandeDep);

#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/actionflux.h>
#include <src/donnees/commandes/localisationfichier.h>

struct commandedep
{
	STOCKAGE(LocalisationFichier) localisation;
	//Localisation de la dpendance dans le source.
	STOCKAGE(Flux) pertinence;
	//Flux donnant la pertinence de la dpendance.
	//Cette valeur doit tre positive.
	//Si la valeur donne est invalide ou absente,
	//zro est pris par dfaut.
	//Ce flux est de type FLUX_PERTINENCE.
	STOCKAGE(Flux) destination;
	//Flux prcisant la destination.
	//Si la valeur est incorrecte, produire une erreur.
	//Ce flux est de type FLUX_REFERENCE.
	STOCKAGE(Flux) irreductible;
	//Flux prcisant le texte  placer en cas
	//d'irrductibilit de la dpendance.
	//Ce flux est de type FLUX_TEXTE_IRREDUCTIBLE.
	STOCKAGE(Flux) reductible;
	//Flux prcisant le texte  placer en cas
	//de rductibilit de la dpendance.
	//Ce flux est de type FLUX_TEXTE_REDUCTIBLE.
};
/* Commande dsigne pour indiquer une dpendance entre ides.
 */

Resultat commandedep_initialisation(TRAVAIL(CommandeDep) commandedep);
/* Cre une commande de dpendance vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandedep_definition_localisationfichier(TRAVAIL(CommandeDep) commandedep , TRAVAIL(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande dep dans le source.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandedep_definition_pertinence(TRAVAIL(CommandeDep) commandedep , TRAVAIL(Flux) pertinence);
/* Assigne une pertinence  une commande de dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandedep_definition_destination(TRAVAIL(CommandeDep) commandedep , TRAVAIL(Flux) destination);
/* Assigne une destination  la commande de dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandedep_definition_irreductible(TRAVAIL(CommandeDep) commandedep , TRAVAIL(Flux) irreductible);
/* Assigne le texte  placer en cas d'irrductibilit de la dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandedep_definition_reductible(TRAVAIL(CommandeDep) commandedep , TRAVAIL(Flux) reductible);
/* Assigne le texte  placer en cas de rductibilit de la dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandedep_lecture_localisationfichier(TRAVAIL(CommandeDep) commandedep , REFERENCE(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande dep dans le source.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 */

Resultat commandedep_lecture_pertinence(TRAVAIL(CommandeDep) commandedep , REFERENCE(Flux) pertinence);
/* Assigne une pertinence  une commande de dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 */

Resultat commandedep_lecture_destination(TRAVAIL(CommandeDep) commandedep , REFERENCE(Flux) destination);
/* Assigne une destination  la commande de dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 */

Resultat commandedep_lecture_irreductible(TRAVAIL(CommandeDep) commandedep , REFERENCE(Flux) irreductible);
/* Assigne le texte  placer en cas d'irrductibilit de la dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 */

Resultat commandedep_lecture_reductible(TRAVAIL(CommandeDep) commandedep , REFERENCE(Flux) reductible);
/* Assigne le texte  placer en cas de rductibilit de la dpendance.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL.
 */

Resultat commandedep_parcours(TRAVAIL(CommandeDep) commandedep , TRAVAIL(ActionFlux) action , TRAVAIL(General) general);
/* Ralise un parcours des flux inclus dans la commande spcifie.
 * Renvoie les mmes erreurs que flux_parcours,
 * ainsi que RESULTAT_ERREUR si commande est NULL,
 * rien ne se passe si action est NULL.
 */

Resultat commandedep_copie(TRAVAIL(CommandeDep) commandedep , TRAVAIL(CommandeDep) copie);
/* Cre une copie de la commande dep.
 * Renvoie RESULTAT_ERREUR si commandedep est NULL, et
 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Si la copie est non vide, elle est au pralable supprime.
 */

Resultat commandedep_destruction(TRAVAIL(CommandeDep) commandedep);
/* Dtruit une commande de dpendance.
 */

#endif
