/* NVTV test backend -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: back_test.c,v 1.3 2004/01/28 17:01:04 dthierbach Exp $
 *
 * Contents:
 *
 * Backend for testing
 *
 */

#include "local.h" /* before everything else */

#include "backend.h"
#include "back_direct.h"
#include "back_test.h"

#if 0
/* Setting dev to NULL will make card_direct operations ignore it */
  
static CardInfo test_card = {
  name: "<Test card>", dev: NULL, reg_base:0xff000000, pio_base:0x300,
  arch: "No Architecture", chips: NULL, next: NULL
};
#endif

static CardInfo test_card_list [] = {
  {name:"nv04", pci_id:0x0020, type:CARD_NVIDIA},
  {name:"nv05", pci_id:0x0028, type:CARD_NVIDIA},
  {name:"nv0a", pci_id:0x00a0, type:CARD_NVIDIA},
  {name:"nv10", pci_id:0x0100, type:CARD_NVIDIA},
  {name:"nv11", pci_id:0x0110, type:CARD_NVIDIA},
  {name:"nv15", pci_id:0x0150, type:CARD_NVIDIA},
  {name:"nv17", pci_id:0x0170, type:CARD_NVIDIA},
  {name:"nv18", pci_id:0x0181, type:CARD_NVIDIA},
  {name:"nv1a", pci_id:0x01a0, type:CARD_NVIDIA},
  {name:"nv1f", pci_id:0x01f0, type:CARD_NVIDIA},
  {name:"nv20", pci_id:0x0200, type:CARD_NVIDIA},
  {name:"nv25", pci_id:0x0250, type:CARD_NVIDIA},
  {name:"nv28", pci_id:0x0280, type:CARD_NVIDIA},
  {name:"nv2a", pci_id:0x02a0, type:CARD_NVIDIA},
  {name:"nv30", pci_id:0x0300, type:CARD_NVIDIA},
  {name:"nv31", pci_id:0x0310, type:CARD_NVIDIA},
  {name:"nv32", pci_id:0x0320, type:CARD_NVIDIA},
  {name:"nv34", pci_id:0x0340, type:CARD_NVIDIA},
  {name:"nv35", pci_id:0x0350, type:CARD_NVIDIA},
  {name:"nv36", pci_id:0x0360, type:CARD_NVIDIA},
  {name:"xbox", pci_id:0x02a0, type:CARD_XBOX},
  {name:"i810", pci_id:0x7121, type:CARD_I810},
  {name:"i830", pci_id:0x3577, type:CARD_I810},
  {name:"i845", pci_id:0x2562, type:CARD_I810},
  {name:"i855", pci_id:0x3582, type:CARD_I810},
  {name:"i865", pci_id:0x2572, type:CARD_I810},
  {name:"tdfx", pci_id:0x0005, type:CARD_TDFX}, 
  {name:NULL},
};

CardPtr back_test_init (char *id)
{
  CardPtr p;

  back_access = &bdir_func;
  for (p = test_card_list; p->name; p++) {
    if (strcmp (id, p->name) == 0) break;
  }
  if (!p->name) return NULL;
  p->dev = NULL;
  p->arch = "Test Architecture";
  p->chips = NULL;
  p->next  = NULL;
  p->reg_base = 0xff000000;
  p->pio_base = 0x300;
  return p;
}

