# Copyright 2014, 2015, 2016, 2017, 2018, 2019 Simon Lydell
# License: MIT. (See LICENSE.)

# <https://tc39.es/ecma262/#sec-lexical-grammar>

# Don’t worry, you don’t need to know CoffeeScript. It is only used for its
# readable regex syntax. Everything else is done in JavaScript in index.js.

module.exports = ///
  ( # <string>
    ([ ' " ])
    (?:
      (?! \2 )[^ \\ \n \r ]
      |
      \\(?: \r\n | [\s\S] )
    )*
    (\2)?
    |
    `
    (?:
      [^ ` \\ $ ]
      |
      \\[\s\S]
      |
      \$(?!\{)
      |
      \$\{
      (?:
        [^{}]
        |
        \{ [^}]* \}?
      )*
      \}?
    )*
    (`)?
  )
  |
  ( # <comment>
    //.*
  )
  |
  ( # <comment>
    /\*
    (?:
      [^*]
      |
      \*(?!/)
    )*
    ( \*/ )?
  )
  |
  ( # <regex>
    /(?!\*)
    (?:
      \[
      (?:
        (?![ \] \\ ]).
        |
        \\.
      )*
      \]
      |
      (?![ / \] \\ ]).
      |
      \\.
    )+
    /
    (?:
      (?!
        \s*
        (?:
          \b
          |
          [ \u0080-\uFFFF $ \\ ' " ~ ( { ]
          |
          [ + \- ! ](?!=)
          |
          \.?\d
        )
      )
      |
      [ g m i y u s ]{1,6} \b
      (?!
        [ \u0080-\uFFFF $ \\ ]
        |
        \s*
        (?:
          [ + \- * % & | ^ < > ! = ? ( { ]
          |
          /(?! [ / * ] )
        )
      )
    )
  )
  |
  ( # <number>
    0[xX][ \d a-f A-F ]+
    |
    0[oO][0-7]+
    |
    0[bB][01]+
    |
    (?:
      \d*\.\d+
      |
      \d+\.? # Support one trailing dot for integers only.
    )
    (?: [eE][+-]?\d+ )?
  )
  |
  ( # <name>
    # See <http://mathiasbynens.be/notes/javascript-identifiers>.
    (?!\d)
    (?:
      (?!\s)[ $ \w \u0080-\uFFFF ]
      |
      \\u[ \d a-f A-F ]{4}
      |
      \\u\{[ \d a-f A-F ]+\}
    )+
  )
  |
  ( # <punctuator>
    -- | \+\+
    |
    && | \|\|
    |
    =>
    |
    \.{3}
    |
    (?:
      [ + \- / % & | ^ ]
      |
      \*{1,2}
      |
      <{1,2} | >{1,3}
      |
      !=? | ={1,2}
    )=?
    |
    [ ? ~ . , : ; [ \] ( ) { } ]
  )
  |
  ( # <whitespace>
    \s+
  )
  |
  ( # <invalid>
    ^$ # Empty.
    |
    [\s\S] # Catch-all rule for anything not matched by the above.
  )
///g
