#ifndef _PDU_ICMPV6_H
#define _PDU_ICMPV6_H 1

/* pdu-icmpv6.h
 
   Structures and symbols for ICMPv6 messages

   Copyright (C) 2007 Eloy Paris, Darrin Miller
   Copyright (C) 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* ICMPv6 Types */
#define ICMPV6_DEST_UNREACH	1	/* Destination Unreachable	*/
#define ICMPV6_TOOBIG		2	/* Packet Too Big		*/
#define ICMPV6_TIME_EXCEEDED	3	/* Time Exceeded		*/
#define ICMPV6_PARAMETERPROB	4	/* Parameter Problem		*/
#define ICMPV6_ECHO		128	/* Echo Request			*/
#define ICMPV6_ECHOREPLY	129	/* Echo Reply			*/
#define ND_ROUTER_SOLICIT	133	/* ND Router Solicitation	*/
#define ND_ROUTER_ADVERT	134	/* ND Router Advertisement	*/
#define ND_NEIGHBOR_SOLICIT	135	/* ND Neighbor Solicitation	*/
#define ND_NEIGHBOR_ADVERT	136	/* ND Neighbor Advertisement	*/
#define ICMPV6_REDIRECT		137	/* ICMPv6 Redirect for ND	*/
#define ICMPV6_ROUTER_RENUMBER	138	/* Router Renumbering		*/

/* Codes for UNREACH */
#define ICMPV6_NO_ROUTE		0	/* no route to destination	*/
#define ICMPV6_COMM_PROHIBITED	1	/* communication with destination
					   administratively prohibited	*/
#define ICMPV6_ADDRESS_UNREACH	3	/* address unrechable		*/
#define ICMPV6_PORT_UNREACH	4	/* port unrechable		*/

/* Codes for TIME_EXCEEDED. */
#define ICMPV6_EXC_TTL		0	/* TTL count exceeded           */
#define ICMPV6_EXC_FRAGTIME	1	/* Fragment Reass time exceeded */

struct ipv6_pseudo_hdr {
    ip6_addr_t saddr;
    ip6_addr_t daddr;
    uint32_t len;
    uint16_t zero1;
    uint8_t zero2;
    uint8_t nxt;
};

/* Type-length-value encoded options are used in some IPv6 extension headers */
struct tlv_option {
    numspec_t *type;
    struct payload data;
};

/* Type-length-value encoded otions are used in ICMPv6 messages */
struct tlv_options {
    int noptions;
    struct tlv_option *options;
};

/*********************************************************************/
/*			  "On the wire" data                         */
/*********************************************************************/

struct icmpv6_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
};

struct icmpv6unreachable_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t unused;
};

struct icmpv6toobig_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t mtu;
};

struct icmpv6timeexceed_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t unused;
};

struct icmpv6parmproblem_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t pointer;
};

struct icmpv6echo_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint16_t id;
    uint16_t seq;
};

struct icmpv6redirect_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t reserved;
    ip6_addr_t target;
    ip6_addr_t dest;
};

struct nd_neighbor_solicit_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t reserved;
    ip6_addr_t target;
};

struct nd_neighbor_advert_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
#ifdef WORDS_BIGENDIAN
    unsigned reserved2:24;
    unsigned r:1;
    unsigned s:1;
    unsigned o:1;
    unsigned reserved1:5;
#else
    unsigned reserved1:5;
    unsigned o:1;
    unsigned s:1;
    unsigned r:1;
    unsigned reserved2:24;
#endif
    ip6_addr_t target;
};

/* Neighbor Discovery Router Solicit header */
struct nd_router_solicit_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t reserved;
};

/* Neighbor Discovery Router Advertisement header */
struct nd_router_advert_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint8_t cur_hop_limit;
#ifdef WORDS_BIGENDIAN
    unsigned m:1;
    unsigned o:1;
    unsigned h:1;
    unsigned prf:2;
    unsigned reserved:3;
#else
    unsigned reserved:3;
    unsigned prf:2;
    unsigned h:1;
    unsigned o:1;
    unsigned m:1;
#endif
    uint16_t router_lifetime;
    uint32_t reachable_time;
    uint32_t retrans_timer;
};

/* Router Renumbering header */
struct icmpv6_router_renumber_hdr {
    uint8_t type;
    uint8_t code;
    uint16_t sum;
    uint32_t sequence_number;
    uint8_t segment_number;
#ifdef WORDS_BIGENDIAN
    unsigned t:1;
    unsigned r:1;
    unsigned a:1;
    unsigned s:1;
    unsigned p:1;
    unsigned flag_reserved:3;
#else
    unsigned flag_reserved:3;
    unsigned p:1;
    unsigned s:1;
    unsigned a:1;
    unsigned r:1;
    unsigned t:1;
#endif
    uint16_t max_delay;
    uint32_t reserved;
};

#endif /* _PDU_ICMPV6_H */
