/* -*- mia-c++  -*-
 *
 * This file is part of MIA - a toolbox for medical image analysis 
 * Copyright (c) Leipzig, Madrid 1999-2017 Gert Wollny
 *
 * MIA is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MIA; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <mia/core/mitestimages.hh>

NS_MIA_BEGIN

const SImageSize mi_test_size = {256, 256}; 


const float moving_init_data[] = {
	5,12,21,28,35,43,51,59,67,75,82,90,97,106,113,121,
	129,136,144,151,160,167,175,183,190,198,206,214,221,229,237,244,
	252,245,236,229,221,214,216,219,213,207,201,195,189,183,178,172,
	167,161,156,150,145,140,134,129,123,118,113,108,103,98,94,88,
	83,79,74,70,65,61,56,51,51,59,67,75,82,90,97,105,
	113,121,129,136,144,152,159,167,175,183,190,198,206,213,221,229,
	237,244,252,244,237,229,221,213,205,198,190,183,175,167,159,152,
	144,136,128,120,113,105,98,90,89,90,92,93,93,94,94,95,
	96,95,96,96,96,96,96,96,95,95,94,93,93,92,92,91,
	97,105,113,121,129,136,144,151,159,167,175,183,191,198,205,213,
	221,229,237,245,252,244,237,229,221,213,206,198,191,182,175,167,
	159,151,144,136,128,121,112,106,97,90,82,74,66,59,51,44,
	47,52,56,60,64,70,74,78,83,89,93,98,103,108,113,119,
	123,129,134,139,145,150,156,161,167,172,178,184,189,195,201,207,
	213,219,215,210,207,214,220,213,207,200,193,186,180,173,166,159,
	153,146,139,133,125,119,112,105,98,91,85,78,71,64,58,51,
	5,12,20,28,35,43,51,59,66,74,82,90,97,105,112,121,
	128,136,143,152,159,167,174,183,190,198,206,214,221,229,237,244,
	252,245,237,229,221,216,216,211,205,198,193,187,181,175,169,164,
	158,152,147,141,136,131,125,120,115,110,104,99,94,89,84,79,
	74,70,65,60,56,51,46,43,51,59,67,74,82,90,97,105,
	113,120,129,136,143,152,159,166,174,182,190,198,205,214,221,229,
	236,244,251,243,236,228,220,213,205,197,189,181,174,166,158,150,
	143,135,127,120,112,104,98,100,101,102,103,104,104,105,106,106,
	107,107,107,108,107,107,107,107,107,107,106,105,104,104,102,102,
	101,105,113,121,128,136,143,151,159,167,175,182,190,198,205,213,
	221,228,236,244,251,243,235,228,220,212,204,197,189,182,173,166,
	158,151,143,135,127,119,112,104,96,88,81,74,65,58,51,43,
	37,41,46,50,55,59,64,69,74,79,83,88,94,99,104,108,
	114,120,124,130,135,141,146,152,157,163,169,174,180,187,192,198,
	204,210,215,217,211,212,219,213,207,200,193,186,180,172,166,159,
	153,146,139,132,125,119,112,105,98,91,85,78,72,65,58,51,
	5,13,20,28,35,44,51,59,67,75,82,90,98,106,113,121,
	128,136,144,151,159,167,175,182,190,198,205,213,221,228,237,244,
	252,244,237,229,221,215,209,203,197,191,185,179,173,167,161,156,
	150,144,138,133,128,122,117,112,106,101,96,91,86,81,75,71,
	66,61,56,51,47,42,38,44,51,58,67,75,82,90,98,106,
	113,121,128,136,144,152,159,167,175,183,191,199,207,214,222,229,
	237,245,250,242,234,227,219,211,203,196,189,180,173,165,157,150,
	142,134,126,119,112,108,110,111,112,114,114,116,116,117,118,118,
	118,119,119,119,119,119,119,119,119,118,118,117,116,115,114,113,
	112,111,114,122,129,137,145,152,160,168,176,183,191,199,206,214,
	222,230,237,245,250,243,235,227,220,212,204,197,189,181,174,166,
	159,151,143,135,128,120,112,104,97,89,81,74,65,57,50,42,
	35,33,37,41,46,51,55,60,65,70,75,80,85,89,95,100,
	105,110,116,121,127,132,138,143,149,155,161,166,172,178,184,190,
	196,202,207,214,218,213,219,214,207,200,193,186,179,173,166,159,
	153,146,139,133,126,119,112,105,99,92,85,78,71,65,57,52,
	5,12,20,28,35,43,51,59,67,75,82,89,98,105,113,120,
	129,136,143,151,159,167,175,183,190,198,205,213,221,228,236,244,
	251,244,237,229,221,214,205,197,190,183,177,171,165,159,153,147,
	141,136,130,124,119,114,109,103,98,93,88,82,77,72,67,62,
	57,52,47,43,38,34,36,44,52,60,68,76,83,91,99,106,
	114,122,130,137,145,153,161,168,176,184,191,199,207,215,222,230,
	238,245,250,242,234,227,219,211,204,196,188,180,172,164,156,148,
	141,133,126,120,119,120,121,122,123,124,126,127,128,128,128,129,
	129,130,130,130,130,130,130,130,130,130,129,129,127,127,126,125,
	124,123,121,123,130,138,145,153,161,168,176,183,191,199,207,214,
	222,230,238,245,250,242,235,227,219,211,204,196,188,180,173,165,
	157,149,142,134,127,119,111,104,96,88,81,73,66,58,50,42,
	34,27,27,32,36,41,45,50,55,60,65,70,75,80,85,91,
	96,101,107,112,118,123,129,134,140,145,151,157,163,169,175,180,
	187,193,199,205,212,218,219,213,207,200,193,187,180,173,166,160,
	153,146,139,132,126,119,112,105,98,92,85,78,71,65,58,51,
	5,12,20,28,35,43,51,59,66,74,82,89,98,105,113,120,
	128,137,144,152,159,167,175,182,190,198,206,213,222,229,236,243,
	251,244,236,229,221,213,205,197,189,182,174,166,158,151,145,139,
	134,128,122,116,111,105,100,95,89,84,79,74,69,63,58,53,
	48,43,38,34,29,29,36,45,52,60,67,75,83,91,99,106,
	114,122,130,137,146,153,161,169,176,184,192,200,207,216,223,231,
	239,246,249,241,234,226,218,210,203,195,187,180,172,164,156,148,
	140,133,127,128,130,131,132,134,135,136,137,138,139,139,140,141,
	141,141,142,142,142,142,142,141,141,141,140,140,139,138,137,136,
	136,134,133,132,133,139,146,153,161,169,177,184,192,200,207,216,
	223,231,239,246,249,242,234,226,219,211,203,195,188,180,173,165,
	157,149,142,134,126,118,111,103,96,88,80,73,65,57,49,42,
	34,27,20,23,27,32,37,41,46,51,56,62,66,72,77,83,
	87,93,99,103,109,115,120,125,132,137,143,148,155,161,168,174,
	180,186,192,199,205,212,219,217,211,205,198,191,185,178,172,165,
	158,151,145,138,131,125,118,111,104,97,90,84,75,68,61,54,
	5,13,20,28,36,44,51,59,66,75,82,90,97,105,113,120,
	129,136,144,151,159,167,174,182,190,198,205,213,221,229,235,243,
	251,244,236,228,220,213,205,197,189,182,174,166,158,151,142,135,
	128,120,114,108,102,97,92,86,81,75,70,65,60,54,49,45,
	39,34,30,25,22,29,37,45,52,60,68,76,84,91,99,107,
	115,123,131,138,146,153,161,169,177,184,192,200,208,216,224,231,
	239,247,248,241,233,225,217,209,202,194,186,179,171,163,155,148,
	140,136,137,139,141,142,144,145,147,148,148,149,150,151,152,152,
	153,153,154,154,154,153,153,153,153,153,152,151,150,150,149,148,
	148,146,145,144,142,143,147,154,162,170,178,185,193,201,209,216,
	223,231,239,247,249,241,233,225,218,210,202,195,187,179,172,164,
	157,149,141,133,126,118,110,103,95,87,80,72,64,56,49,42,
	34,26,19,15,18,23,27,32,37,42,47,52,57,62,67,73,
	78,84,90,96,101,107,113,119,125,132,138,144,151,158,165,172,
	179,186,192,198,205,212,219,216,217,212,206,199,193,187,180,173,
	166,159,153,146,139,132,126,118,111,104,97,90,82,75,68,61,
	5,13,20,27,36,43,51,59,66,74,82,89,98,106,113,120,
	128,136,144,151,159,167,174,183,190,198,206,213,220,227,235,243,
	251,244,235,228,220,213,205,197,189,182,174,166,158,150,143,135,
	127,120,111,104,96,89,83,78,72,67,61,56,51,46,41,36,
	31,26,21,18,22,30,38,45,53,61,68,76,84,92,100,107,
	116,124,132,139,147,155,162,170,177,185,193,201,209,217,225,232,
	240,248,247,240,232,224,217,209,200,193,186,178,170,162,155,148,
	146,147,149,150,152,154,156,157,158,159,160,161,162,163,163,164,
	164,165,165,165,165,165,165,165,164,164,163,163,162,162,161,160,
	159,158,156,155,153,152,153,157,163,171,178,186,194,202,209,217,
	225,232,240,248,248,240,232,224,217,209,202,194,186,179,171,164,
	156,148,141,133,125,117,110,102,94,87,79,71,64,56,49,41,
	33,26,18,11,9,14,18,23,28,33,38,43,49,54,60,66,
	71,78,85,91,98,104,111,118,125,132,138,145,151,159,165,172,
	178,185,192,198,205,211,218,214,213,217,214,207,201,195,188,181,
	174,168,161,154,147,140,133,126,119,112,104,97,89,82,75,67,
	9,16,24,31,38,46,52,60,67,75,82,90,97,106,113,120,
	129,136,143,152,159,167,175,182,190,198,206,212,220,228,236,243,
	251,243,236,228,220,212,205,197,189,181,174,166,159,151,143,135,
	127,119,111,103,96,88,80,73,65,59,53,48,43,37,32,27,
	22,17,14,16,23,30,38,45,54,61,69,77,84,92,101,108,
	116,124,132,140,148,156,163,170,178,187,194,202,209,217,225,233,
	240,248,247,239,231,223,216,208,200,192,184,177,169,161,156,155,
	157,159,160,162,163,165,167,168,169,171,172,173,174,174,175,175,
	176,176,177,177,177,177,177,176,177,176,175,175,174,174,173,171,
	170,169,168,167,165,163,162,162,165,171,179,187,195,203,210,217,
	225,233,240,248,247,240,232,224,217,208,201,194,186,178,170,163,
	156,148,140,132,125,117,109,102,94,87,79,71,64,56,49,41,
	33,25,18,10,4,4,9,15,21,26,32,38,45,51,58,65,
	71,78,84,91,98,105,111,118,125,131,138,144,152,158,165,171,
	178,184,191,198,205,211,218,214,208,211,217,215,209,202,196,189,
	182,175,168,161,155,148,141,134,127,120,111,105,97,89,82,74,
	15,23,31,38,45,53,59,67,75,81,89,96,103,110,117,125,
	132,139,145,153,160,167,175,183,190,198,205,213,220,228,236,244,
	251,243,236,228,220,212,204,197,189,181,174,166,159,151,143,135,
	127,119,110,103,95,87,80,72,64,57,49,42,35,29,24,19,
	14,9,8,15,23,31,39,46,54,62,70,78,85,94,101,109,
	117,125,132,140,148,156,164,171,179,188,195,203,210,218,226,233,
	241,249,246,238,230,222,215,207,199,191,183,176,168,164,164,166,
	168,170,171,173,175,177,178,180,181,182,183,183,185,186,186,187,
	188,188,188,188,188,188,188,188,188,187,187,187,186,184,184,183,
	182,181,180,179,177,175,173,172,170,173,180,188,196,203,211,219,
	226,233,241,249,246,238,231,224,216,208,200,193,185,177,169,162,
	155,147,139,132,124,116,109,101,93,86,79,71,63,56,48,40,
	33,25,18,12,6,2,5,11,18,25,32,39,45,52,58,65,
	72,78,85,92,98,105,112,118,125,131,138,145,151,158,165,171,
	178,185,191,198,205,211,218,214,207,204,209,215,215,210,203,196,
	190,183,176,169,162,155,148,141,134,127,119,111,104,96,89,81,
	22,29,37,45,52,59,66,74,81,88,96,103,110,117,124,132,
	139,146,153,160,167,174,181,188,194,200,207,214,220,228,237,244,
	251,244,236,227,220,213,205,197,189,182,174,166,158,150,142,134,
	127,119,111,103,95,87,79,72,64,56,48,40,33,25,18,11,
	5,3,8,16,23,31,39,47,55,63,71,79,86,94,102,109,
	117,125,133,141,149,156,164,172,180,188,196,204,211,219,226,234,
	242,250,245,237,230,222,214,206,198,190,183,175,172,173,175,177,
	180,181,183,185,186,188,190,191,192,193,194,195,197,198,198,199,
	199,199,199,201,200,200,199,200,199,199,198,198,197,196,196,195,
	193,193,192,190,188,186,185,183,181,179,183,189,197,204,212,220,
	227,235,242,250,245,238,230,222,215,207,199,192,184,176,169,161,
	154,146,138,131,123,115,108,100,93,85,78,71,62,55,49,43,
	37,31,25,20,15,9,8,12,18,25,32,38,45,52,59,65,
	71,78,85,92,98,105,112,119,124,131,138,145,152,158,165,172,
	178,185,191,198,205,211,218,214,208,201,202,208,215,216,211,204,
	198,191,183,177,170,163,156,148,141,134,125,118,111,103,96,89,
	29,36,44,51,59,66,73,81,88,96,103,110,117,125,131,139,
	146,153,161,167,174,181,188,194,200,207,215,217,220,229,237,244,
	251,243,235,228,220,212,205,197,189,181,173,165,158,149,142,134,
	126,119,110,102,95,87,79,71,64,55,47,40,32,24,16,8,
	3,5,11,17,24,32,40,48,55,63,72,79,87,95,103,110,
	118,126,134,142,150,157,165,173,180,189,197,205,212,220,228,235,
	243,251,244,236,228,221,213,205,197,190,182,180,182,184,186,188,
	191,193,194,196,198,199,202,203,203,205,206,207,207,208,209,210,
	210,210,211,212,212,211,211,211,211,211,210,209,209,208,208,207,
	205,204,203,201,200,198,197,195,193,191,189,191,198,205,213,220,
	228,236,243,251,245,237,229,221,214,206,198,191,183,175,168,160,
	153,145,137,130,122,115,107,99,92,85,79,74,68,62,57,52,
	47,42,36,31,25,19,15,14,19,26,32,39,45,52,59,65,
	72,78,85,92,98,105,112,119,125,131,138,145,152,159,165,172,
	178,185,191,198,205,212,218,215,208,201,197,200,206,213,216,212,
	206,199,191,184,177,170,163,155,148,141,132,125,118,110,102,96,
	35,43,50,57,65,73,80,87,95,102,110,116,124,131,139,146,
	153,160,167,174,182,189,196,201,209,215,216,213,222,228,237,244,
	251,243,235,228,220,213,205,197,189,181,173,165,157,150,142,134,
	126,118,110,102,94,87,78,71,63,55,47,39,31,23,15,9,
	8,12,18,24,30,37,43,49,56,64,72,80,88,96,103,111,
	119,127,135,143,151,158,166,173,182,190,197,206,214,221,229,236,
	244,251,243,235,227,220,212,204,196,190,189,191,193,195,197,200,
	202,204,206,207,209,211,213,214,215,216,217,218,219,220,221,221,
	222,222,223,223,223,223,223,223,223,223,222,221,220,220,219,218,
	216,216,214,213,211,210,208,206,205,203,201,199,200,206,214,222,
	229,237,244,251,244,236,228,220,213,205,198,190,183,175,167,160,
	153,145,137,130,122,114,108,103,98,93,88,84,78,73,68,63,
	57,52,47,41,36,30,25,20,20,26,33,39,46,52,59,65,
	73,79,86,92,99,106,112,119,126,132,139,145,152,159,165,172,
	179,185,191,198,205,211,218,214,208,201,195,193,198,205,212,215,
	212,206,199,192,185,178,170,163,155,147,140,133,125,116,109,102,
	42,49,56,64,72,80,86,94,101,109,116,123,131,139,145,153,
	160,167,174,181,188,195,202,209,215,216,210,214,221,229,237,244,
	251,243,236,228,220,213,204,196,188,180,173,165,157,149,141,133,
	125,118,110,102,94,86,78,70,63,54,46,39,31,23,15,13,
	16,22,28,34,39,45,50,56,61,68,75,81,89,96,104,112,
	120,128,136,144,151,159,167,174,183,190,198,206,214,222,230,237,
	246,250,242,234,227,219,211,203,197,197,199,202,204,206,209,211,
	213,215,217,218,220,222,224,225,226,228,229,230,230,231,232,232,
	233,233,234,234,235,234,234,235,234,234,233,233,232,232,231,229,
	228,227,226,225,223,221,220,218,217,214,212,210,209,210,215,223,
	230,237,245,250,242,235,227,219,212,205,197,189,182,173,166,159,
	151,144,137,132,127,123,118,113,108,103,99,94,89,84,79,74,
	68,63,57,52,47,41,35,29,25,27,33,39,46,53,60,66,
	73,80,86,93,99,106,112,118,126,132,139,146,152,158,165,172,
	179,185,191,198,205,211,218,215,208,201,195,189,191,197,204,211,
	215,213,207,200,193,185,177,170,162,154,146,139,132,123,116,109,
	48,56,63,71,79,86,94,100,108,116,123,131,138,145,152,160,
	167,174,181,188,196,202,209,216,216,210,206,214,221,228,236,244,
	251,243,235,228,220,211,203,195,188,180,172,164,156,149,141,133,
	125,117,109,101,93,86,78,70,62,54,46,38,30,22,18,20,
	26,32,38,43,49,55,60,66,71,76,82,87,93,100,106,113,
	121,129,136,144,152,160,168,175,184,191,199,207,215,223,231,238,
	246,249,241,233,226,218,210,204,205,207,210,213,216,218,219,222,
	224,226,228,230,231,233,235,236,237,239,240,241,242,242,243,244,
	244,244,245,245,244,244,244,244,244,244,244,244,243,243,242,241,
	240,239,237,236,234,233,231,230,228,226,224,222,220,218,218,224,
	231,239,246,249,241,234,226,219,211,203,196,188,180,173,166,159,
	155,151,146,142,138,134,129,124,120,116,110,104,100,95,90,85,
	79,73,68,63,58,52,46,40,34,31,34,40,47,53,60,67,
	73,80,86,93,99,106,113,119,125,132,139,145,152,159,165,172,
	179,185,192,198,205,212,218,215,208,201,195,188,185,189,197,204,
	211,215,214,208,200,193,185,177,169,162,154,146,139,130,123,115,
	55,62,70,77,85,93,101,107,115,123,130,137,145,153,159,166,
	174,181,189,196,202,208,216,216,209,202,206,213,221,229,237,244,
	251,244,235,227,219,212,203,196,188,180,172,164,157,148,140,132,
	124,117,109,100,93,85,77,69,61,53,45,38,30,23,24,30,
	36,42,47,53,59,65,70,76,81,86,91,97,103,108,113,118,
	124,131,138,145,153,161,169,176,184,192,200,208,216,224,232,239,
	247,248,240,232,224,217,212,213,216,218,221,224,227,229,231,233,
	235,238,239,241,243,244,246,247,249,250,250,249,249,248,248,247,
	246,246,246,245,245,245,245,246,246,246,247,247,247,247,246,246,
	246,246,246,246,246,245,243,241,239,238,235,233,231,229,226,227,
	232,240,247,248,240,233,225,217,210,203,195,188,182,178,174,170,
	167,162,157,153,149,145,140,135,130,126,121,116,111,106,100,95,
	90,84,79,73,67,62,57,51,44,38,37,41,47,54,61,67,
	73,80,87,93,99,106,113,119,126,132,139,146,153,159,165,172,
	179,185,192,199,205,212,218,214,207,201,195,188,182,183,189,196,
	202,210,215,214,207,200,192,184,176,168,161,153,145,137,130,123,
	61,69,76,83,92,100,106,114,122,129,136,144,152,159,166,173,
	181,188,196,202,209,216,216,209,202,198,205,213,221,229,237,244,
	251,243,235,226,219,212,203,196,188,180,172,164,156,148,140,132,
	124,116,108,100,92,84,77,69,60,52,45,37,29,28,33,39,
	45,51,57,63,69,75,80,86,91,96,102,107,112,118,123,128,
	133,138,142,149,156,162,170,178,186,193,201,209,217,225,232,240,
	248,247,239,231,224,219,221,224,226,229,232,235,238,240,242,244,
	246,248,248,247,246,245,245,244,242,242,241,239,238,238,237,236,
	236,235,235,234,234,234,234,234,234,235,235,235,237,237,238,239,
	240,241,243,244,245,245,246,246,247,248,246,245,243,241,238,235,
	236,241,248,247,239,232,224,217,210,205,201,197,193,190,186,181,
	178,173,169,165,160,155,151,146,141,137,131,127,122,116,111,105,
	100,95,90,84,78,72,67,61,55,49,43,42,48,54,61,67,
	74,81,87,94,100,107,113,120,126,133,139,146,153,159,166,172,
	179,185,192,199,205,212,218,214,208,201,195,188,181,177,181,188,
	195,202,210,215,213,207,199,191,183,175,168,160,153,145,136,130,
	67,75,82,91,98,105,114,121,128,136,143,151,159,165,173,180,
	188,195,202,208,216,216,210,203,195,198,206,214,221,229,236,244,
	251,243,234,226,219,211,203,195,187,179,171,164,155,147,139,131,
	123,116,108,100,92,84,76,68,60,52,44,36,31,36,43,49,
	55,60,66,73,79,84,90,95,101,107,112,117,122,128,132,138,
	143,148,153,157,162,166,173,180,187,194,202,211,218,226,233,241,
	249,245,238,230,226,228,231,234,238,240,243,246,246,247,246,245,
	244,243,241,240,238,235,234,234,231,230,229,227,226,226,225,224,
	224,224,222,223,222,223,222,223,223,224,224,224,225,225,226,228,
	229,230,231,232,233,235,237,239,240,242,243,245,247,249,249,247,
	244,244,250,246,238,231,226,222,219,216,212,209,205,201,197,193,
	188,184,180,175,171,166,162,157,152,147,142,138,132,127,122,116,
	111,106,100,95,89,83,77,71,65,59,53,48,49,55,61,67,
	74,81,87,94,100,107,114,120,127,133,140,146,153,159,166,173,
	179,186,193,199,206,212,218,215,208,201,194,188,181,175,175,180,
	188,195,203,211,216,213,206,198,190,183,175,167,159,151,144,136,
	74,81,89,97,104,113,120,127,135,143,150,157,165,172,179,187,
	194,201,208,216,216,210,202,195,190,198,206,213,221,228,236,245,
	250,242,234,226,218,210,203,195,187,179,171,163,155,147,139,131,
	123,115,107,99,91,83,75,67,59,51,44,37,39,46,52,58,
	64,70,76,82,88,94,100,105,111,117,122,127,132,137,142,148,
	153,158,163,167,172,177,181,186,190,196,204,212,219,227,234,242,
	251,244,237,233,236,239,242,245,246,246,246,246,244,241,239,236,
	234,232,230,228,227,224,223,221,220,218,217,216,215,214,213,212,
	212,212,211,211,211,210,211,212,212,212,212,213,213,214,215,216,
	217,218,220,220,222,224,225,227,229,231,233,236,238,240,242,245,
	248,250,251,246,243,241,237,234,231,227,223,219,216,212,208,203,
	199,195,191,186,182,178,173,168,164,159,153,148,143,137,132,127,
	122,117,111,105,100,94,87,81,76,70,63,57,53,56,61,68,
	75,81,88,94,101,108,114,120,127,134,140,147,154,159,166,173,
	180,185,192,198,206,212,218,215,208,201,194,188,181,174,170,173,
	180,188,196,203,211,216,212,205,197,189,182,174,166,158,150,143,
	80,88,96,104,111,118,126,134,142,150,157,164,171,179,187,194,
	200,208,215,216,210,203,195,188,190,198,206,213,222,229,237,245,
	250,242,234,226,218,210,202,194,186,178,170,162,154,147,139,131,
	123,114,106,98,90,82,74,67,58,50,44,43,49,56,62,68,
	74,80,86,92,98,103,109,115,121,126,132,137,142,147,153,158,
	163,168,173,178,183,187,191,196,200,205,209,214,221,229,236,244,
	251,243,240,242,245,246,247,247,244,241,238,235,233,230,228,225,
	223,221,219,217,215,213,211,210,209,207,206,205,204,203,203,202,
	201,201,200,200,199,199,200,200,200,200,201,201,202,202,203,204,
	205,207,208,209,210,212,213,216,217,219,222,224,226,228,231,234,
	238,245,251,247,248,247,245,245,242,238,234,231,227,223,219,215,
	210,206,202,198,193,188,183,179,174,170,164,159,154,149,143,138,
	133,127,121,116,110,104,98,92,86,80,74,68,61,57,62,68,
	75,82,88,94,101,108,114,121,128,134,140,147,153,160,166,173,
	180,186,193,199,206,213,219,214,207,201,194,188,181,175,168,167,
	173,181,188,196,204,212,215,211,204,196,189,180,172,164,157,149,
	87,94,102,109,117,125,133,141,148,156,163,171,179,186,193,200,
	207,214,217,210,203,195,188,183,190,198,206,213,222,230,237,245,
	250,241,234,226,217,210,202,193,186,178,170,162,154,146,138,130,
	122,114,106,98,89,82,74,66,58,50,46,52,59,65,71,77,
	83,90,95,101,107,113,119,125,130,136,142,147,152,158,163,168,
	173,178,182,188,192,197,202,206,210,215,220,224,227,232,237,245,
	250,246,248,248,246,242,239,236,232,230,227,225,222,219,217,214,
	212,210,208,206,204,202,200,199,197,196,195,194,192,191,191,190,
	189,189,188,188,188,188,188,188,188,188,189,190,190,191,192,193,
	194,195,196,198,199,201,202,204,206,208,210,213,215,218,223,230,
	238,246,250,242,238,240,243,247,246,246,246,242,238,234,230,226,
	222,217,213,209,204,199,195,190,185,180,175,170,165,159,154,148,
	143,137,132,126,120,114,109,103,96,90,84,78,71,64,64,69,
	76,82,89,95,102,108,115,122,128,135,141,147,154,161,167,173,
	179,187,193,199,206,212,219,214,208,201,194,188,181,175,168,163,
	166,174,181,189,197,205,212,215,210,203,196,187,179,171,163,155,
	92,101,109,116,124,131,139,147,155,163,170,178,185,193,198,207,
	213,217,211,203,196,189,181,182,190,198,206,214,222,229,238,246,
	249,241,234,225,217,210,201,193,185,177,169,161,153,145,137,129,
	121,113,106,97,89,81,73,65,57,51,54,62,68,74,80,87,
	93,99,105,111,117,123,129,134,140,146,152,157,163,167,173,178,
	183,188,193,198,203,207,212,216,220,225,230,234,238,242,246,249,
	250,246,242,238,235,232,228,225,222,219,216,213,211,208,206,203,
	201,199,197,195,193,191,189,187,186,185,184,183,182,180,180,179,
	178,178,177,177,177,177,176,176,176,177,178,178,179,179,180,181,
	182,183,185,186,188,189,191,193,195,197,199,203,209,217,224,232,
	240,247,249,241,234,231,232,235,239,242,245,246,247,246,241,237,
	233,229,224,220,215,211,206,201,196,191,186,180,175,170,165,160,
	154,148,143,137,131,125,119,113,107,101,94,88,82,75,69,71,
	76,83,90,96,102,109,116,122,129,135,141,148,154,161,167,174,
	180,187,193,200,206,213,219,213,207,201,194,188,181,174,168,161,
	161,167,174,182,190,198,206,214,215,210,202,194,186,177,170,162,
	99,107,115,122,130,138,145,154,161,169,176,184,191,198,205,213,
	218,212,204,196,189,182,175,183,190,198,206,214,222,230,238,246,
	249,241,233,225,217,209,201,193,185,177,169,160,152,144,136,128,
	121,112,104,96,89,80,73,65,58,58,63,70,77,83,90,96,
	102,109,114,120,126,132,138,144,150,156,161,166,172,177,183,188,
	193,197,203,208,212,217,222,226,231,235,240,244,248,249,245,248,
	248,240,233,228,224,221,218,214,212,208,205,202,200,197,195,192,
	190,188,186,184,182,180,178,176,175,174,173,171,170,169,168,168,
	166,166,166,166,165,166,165,165,165,166,166,166,167,168,169,170,
	171,172,173,174,176,178,180,182,184,188,195,203,211,218,226,233,
	241,248,247,240,232,226,223,224,227,231,234,238,242,245,248,249,
	245,240,236,230,226,222,217,212,207,201,197,191,186,181,175,170,
	165,159,152,147,141,135,129,123,117,111,104,98,91,85,79,73,
	77,84,90,97,103,109,116,122,128,135,142,148,155,161,168,174,
	180,187,194,200,206,213,220,214,207,201,194,187,181,174,167,161,
	156,160,168,176,184,191,199,207,215,215,209,200,192,184,176,169,
	105,113,121,129,136,144,151,160,168,175,182,191,197,205,212,218,
	212,205,197,189,182,175,175,182,191,199,207,214,222,231,239,247,
	248,241,233,224,216,209,200,192,184,176,168,160,152,144,136,127,
	120,112,103,95,88,80,72,63,61,66,73,80,86,92,99,105,
	111,118,124,130,136,142,147,153,159,166,171,177,181,187,193,198,
	203,208,213,218,223,228,232,237,242,246,248,246,244,240,242,249,
	246,238,231,223,216,211,207,204,201,197,194,192,189,186,184,181,
	179,177,174,172,170,169,167,165,164,163,161,160,159,158,156,156,
	155,155,154,155,154,154,154,154,154,154,155,155,156,156,157,158,
	159,161,162,162,164,166,168,173,181,189,197,204,211,219,227,234,
	242,249,246,238,231,223,217,214,216,220,223,227,231,235,239,244,
	248,249,245,242,237,232,227,222,218,212,207,203,197,192,187,181,
	175,169,163,158,152,146,140,133,127,121,115,108,101,95,88,82,
	79,84,90,97,104,110,116,122,129,136,142,148,155,161,168,174,
	181,188,194,200,206,213,220,213,207,200,194,187,181,174,167,161,
	155,155,161,168,177,185,193,200,208,216,214,206,199,190,183,175,
	111,119,127,135,142,151,158,166,174,181,189,195,203,211,219,213,
	205,198,191,183,175,168,175,183,191,199,207,214,223,231,239,247,
	248,240,232,224,216,208,200,192,183,176,167,160,152,143,135,127,
	119,111,103,95,87,79,71,66,68,75,82,89,95,102,108,115,
	121,127,133,139,145,151,157,163,169,175,180,186,191,197,202,208,
	213,218,223,228,233,238,242,246,247,246,242,238,234,236,243,250,
	246,237,229,221,213,205,198,193,189,187,184,181,178,175,173,171,
	168,166,163,162,159,158,156,154,152,151,150,148,148,147,145,144,
	143,143,143,143,143,143,142,142,142,143,143,144,144,145,146,146,
	147,149,150,151,153,160,167,175,182,190,198,205,213,220,228,236,
	243,251,244,237,230,222,214,207,206,209,212,216,220,224,229,233,
	237,241,245,248,246,243,239,233,228,223,218,213,208,202,197,191,
	186,180,174,168,162,156,150,144,138,132,125,118,112,105,99,92,
	86,85,91,97,104,110,116,124,130,136,143,149,156,162,168,174,
	181,187,194,201,207,214,219,213,207,200,194,188,181,174,167,160,
	154,149,153,162,170,178,186,194,201,210,217,213,206,197,190,182,
	117,125,133,141,149,157,165,173,180,188,195,203,210,218,214,206,
	199,191,183,176,169,167,175,183,191,199,207,215,223,231,240,247,
	248,240,231,223,215,207,199,192,183,175,167,158,150,143,134,126,
	119,110,102,94,86,78,71,71,77,84,91,98,105,111,117,124,
	130,136,142,149,155,160,167,173,179,184,190,195,201,207,212,218,
	223,228,233,238,243,246,246,245,241,237,232,228,229,235,243,251,
	244,236,228,220,212,205,197,189,182,176,173,170,167,164,162,160,
	157,155,153,151,149,147,145,143,141,140,139,137,137,135,134,133,
	133,132,132,132,131,131,131,131,131,132,132,132,133,134,135,135,
	137,138,141,146,154,162,169,176,184,191,199,207,214,222,230,237,
	245,251,243,236,228,221,213,206,198,199,202,205,209,213,217,221,
	226,230,235,239,244,247,246,244,239,235,229,224,219,213,207,201,
	196,191,185,179,173,167,161,154,148,142,135,129,122,115,109,102,
	96,90,92,98,104,110,117,124,130,137,143,150,156,162,169,175,
	181,188,194,201,207,214,219,213,206,200,193,187,181,174,167,161,
	154,147,148,155,163,171,179,187,195,203,211,217,212,203,196,188,
	123,131,140,147,155,163,171,178,187,194,201,209,217,215,207,200,
	192,185,177,170,162,167,175,183,191,200,208,216,224,232,240,248,
	247,239,230,223,215,206,198,190,183,175,166,158,150,142,134,125,
	118,109,101,93,85,77,75,79,87,93,100,107,113,119,126,133,
	140,145,152,158,164,170,176,182,188,194,199,205,211,216,222,227,
	233,237,243,246,248,245,240,236,231,226,222,222,229,236,245,250,
	242,235,227,219,211,203,195,188,179,171,165,160,156,153,151,149,
	147,144,142,139,137,136,134,132,130,129,127,126,125,125,123,122,
	122,121,121,120,119,119,120,120,120,120,120,121,121,122,123,124,
	126,132,140,147,155,163,170,178,186,193,200,208,216,223,231,238,
	246,250,242,235,227,219,212,205,197,190,190,194,198,202,206,210,
	215,219,224,229,233,238,242,245,247,245,240,234,229,223,218,213,
	207,201,194,189,183,177,171,164,158,152,145,139,132,126,119,112,
	106,99,95,99,105,111,118,125,131,137,144,150,156,163,169,176,
	182,188,195,201,208,214,219,212,206,200,193,186,180,173,167,160,
	154,147,143,148,156,164,172,180,188,196,204,213,216,210,202,194,
	129,137,145,153,161,169,177,185,193,200,208,215,217,209,201,193,
	186,178,170,163,160,167,176,184,192,200,208,216,224,232,240,248,
	247,238,230,223,214,205,197,190,181,173,165,157,149,141,133,125,
	117,109,100,92,84,79,82,88,95,102,109,116,122,129,135,142,
	148,155,161,167,174,180,186,192,197,203,209,215,220,225,231,237,
	242,246,249,246,240,235,230,226,220,216,216,223,230,238,246,249,
	241,234,225,218,210,201,194,186,177,170,162,155,148,143,140,138,
	136,133,131,128,126,125,123,121,119,118,116,115,114,113,112,111,
	110,110,109,109,108,108,109,109,108,108,109,109,110,110,113,119,
	126,133,141,148,156,164,172,179,187,194,202,210,217,225,232,239,
	247,248,240,233,226,218,211,203,196,188,182,183,187,191,195,199,
	203,208,213,218,222,227,232,237,242,246,248,245,240,234,229,223,
	217,212,205,200,193,187,181,175,169,162,155,149,142,135,128,122,
	115,108,102,99,106,112,119,125,132,138,144,151,157,163,169,176,
	182,189,195,202,208,214,219,212,206,200,193,186,180,174,167,160,
	153,146,140,142,150,157,166,174,182,190,198,207,215,216,208,201,
	135,143,151,160,167,175,183,191,198,206,213,217,211,202,194,186,
	180,172,164,157,160,168,176,184,192,200,208,216,224,232,240,249,
	246,238,230,222,213,205,197,189,181,173,165,156,149,140,132,124,
	116,108,100,91,84,84,90,97,104,110,117,125,132,138,144,151,
	157,164,170,177,183,189,195,201,207,213,219,224,230,235,241,246,
	251,246,241,235,230,226,220,216,211,210,215,223,231,239,248,248,
	240,232,224,217,208,200,192,185,177,169,161,153,146,138,131,126,
	124,122,120,118,116,113,112,110,108,107,105,104,103,101,101,100,
	99,98,98,97,97,97,97,97,97,97,98,98,100,105,112,120,
	127,135,143,150,157,165,173,181,188,196,203,211,218,226,234,241,
	248,247,240,232,225,217,210,202,194,187,180,175,176,180,185,189,
	193,198,202,207,211,216,222,226,231,236,241,247,248,244,239,234,
	228,222,215,210,204,198,192,185,179,172,166,159,153,146,139,132,
	125,118,111,105,106,113,119,125,133,138,145,151,158,164,170,177,
	183,189,195,202,208,215,219,213,205,199,193,186,179,173,167,160,
	154,147,140,137,143,151,159,167,175,183,192,200,208,217,215,207,
	142,149,157,165,173,181,189,196,204,212,218,212,204,196,188,180,
	173,165,158,153,160,168,176,184,192,200,208,217,225,233,241,249,
	245,238,229,221,213,204,196,189,181,172,164,156,148,140,131,123,
	115,107,99,91,86,92,98,106,113,120,126,134,140,146,154,160,
	167,174,180,186,192,198,204,211,216,222,228,234,240,245,250,245,
	242,236,230,225,221,215,210,206,204,209,217,225,232,240,249,247,
	239,231,223,215,207,199,191,184,175,167,160,152,144,136,129,121,
	114,111,109,107,104,102,101,99,97,96,94,93,92,90,90,89,
	88,87,87,86,86,86,86,86,86,86,87,91,98,105,113,120,
	129,136,144,151,159,167,174,182,190,197,204,212,219,227,234,243,
	250,246,239,231,223,216,208,201,194,186,178,172,168,169,173,177,
	182,186,191,196,200,206,210,215,221,226,231,236,242,246,246,243,
	238,232,226,220,214,208,202,195,189,182,176,169,163,156,149,142,
	135,128,121,114,109,113,120,126,132,139,145,151,158,164,171,177,
	183,190,196,202,208,215,218,212,206,199,193,186,180,173,167,160,
	154,147,140,134,136,144,152,161,169,177,186,194,202,211,218,213,
	147,155,164,171,179,188,195,203,210,218,214,205,198,190,182,174,
	167,159,151,152,160,168,176,184,192,200,208,217,225,234,242,250,
	245,237,229,220,212,204,196,188,180,172,163,155,147,139,131,122,
	114,107,98,91,93,101,107,114,121,128,135,142,149,156,163,169,
	176,182,188,195,201,207,214,219,225,232,238,243,249,246,243,237,
	232,226,221,216,211,206,201,198,202,210,218,226,233,241,250,246,
	238,230,222,213,206,198,190,182,174,166,158,150,143,135,127,119,
	111,104,98,96,94,91,89,88,87,85,83,82,81,80,78,77,
	77,76,75,75,74,74,74,74,75,78,84,91,99,107,115,122,
	129,137,144,152,160,168,176,183,191,198,205,214,221,228,235,244,
	251,245,238,230,222,215,207,200,193,185,178,170,163,160,162,166,
	171,175,180,185,189,195,200,204,210,215,221,226,231,237,242,246,
	246,242,237,231,224,218,212,206,199,192,186,180,172,166,159,152,
	145,138,131,124,117,115,120,126,133,139,146,152,158,164,170,177,
	183,189,196,202,208,214,218,212,206,199,192,186,179,173,166,160,
	153,146,140,133,131,138,146,154,163,171,179,188,196,204,212,219,
	153,161,170,177,185,194,200,208,217,215,207,199,192,183,175,167,
	160,152,145,152,160,168,176,185,193,201,209,217,226,234,242,250,
	245,237,227,220,211,204,195,187,179,171,163,155,147,138,130,122,
	114,106,97,94,101,109,116,123,130,137,144,151,158,165,172,178,
	184,191,197,204,210,216,223,229,235,241,246,246,244,239,233,227,
	222,217,212,206,201,196,193,196,203,211,219,227,235,243,251,244,
	236,228,220,212,205,197,189,181,173,165,157,149,141,134,125,117,
	110,102,94,88,83,80,78,77,75,74,72,71,69,68,67,66,
	65,64,64,63,63,63,63,65,70,77,85,92,100,108,116,124,
	131,138,146,153,161,169,176,184,191,199,206,215,222,229,237,244,
	251,244,237,229,222,214,206,199,192,184,177,170,162,154,152,155,
	159,164,169,174,178,183,189,194,199,204,210,215,220,226,232,238,
	243,247,246,241,235,229,222,216,209,203,196,190,182,176,169,162,
	155,148,141,133,126,120,120,127,133,139,145,153,159,165,171,178,
	184,190,196,202,209,215,218,211,206,199,192,186,179,173,166,160,
	153,146,140,133,127,131,139,147,156,164,173,182,190,198,206,215,
	159,167,175,183,191,199,206,214,216,209,201,193,185,177,169,161,
	154,146,144,152,160,169,177,185,193,201,210,218,225,235,243,251,
	244,235,227,219,211,203,195,187,178,170,162,154,146,137,129,121,
	113,104,97,103,110,118,124,131,139,146,153,160,167,174,180,187,
	193,200,206,213,219,225,232,238,244,246,246,241,235,229,223,218,
	212,207,202,197,191,187,189,196,205,213,220,228,236,244,251,243,
	235,227,219,212,203,195,187,180,172,164,156,148,140,132,124,116,
	109,101,93,85,77,71,68,66,64,63,61,59,58,57,56,55,
	55,54,53,52,52,52,56,63,71,78,86,93,101,109,117,124,
	132,139,147,155,162,170,177,184,192,200,207,215,222,229,238,245,
	251,243,236,229,221,214,206,199,191,184,176,169,162,154,147,145,
	149,154,158,163,168,173,178,183,189,194,199,204,210,216,221,227,
	234,240,245,247,245,239,233,226,219,212,205,199,192,185,178,171,
	164,157,150,143,135,128,123,127,133,139,146,153,159,165,171,177,
	184,190,196,202,208,215,218,211,205,199,192,186,180,173,166,160,
	153,146,140,133,126,126,132,141,150,158,167,175,184,192,200,209,
	165,173,181,189,196,204,213,217,211,202,195,187,179,171,163,155,
	147,141,145,153,160,169,177,185,193,202,210,218,226,235,243,251,
	243,235,227,218,210,202,194,185,177,169,161,152,145,136,129,120,
	112,104,104,111,119,126,133,140,147,155,162,169,176,182,189,196,
	202,209,215,222,229,235,241,246,247,243,238,231,226,220,214,209,
	203,197,192,187,181,182,190,197,206,213,221,229,237,245,250,242,
	234,226,218,210,202,194,186,178,171,162,154,147,139,131,123,115,
	108,100,92,84,77,69,61,56,53,51,50,48,47,46,45,44,
	43,42,42,41,42,48,56,64,72,79,86,94,102,110,117,125,
	132,140,147,155,163,170,178,186,193,200,208,215,223,230,238,245,
	250,243,236,228,220,214,206,198,191,184,176,169,161,154,147,140,
	139,143,148,153,157,162,168,173,178,183,189,194,200,206,211,217,
	223,229,235,242,248,248,242,236,229,223,216,210,202,195,188,181,
	174,166,160,153,145,137,130,127,133,140,146,153,159,165,171,178,
	184,190,196,203,209,215,217,211,205,199,192,186,179,173,166,159,
	153,145,139,133,126,121,126,135,143,152,160,168,177,186,194,203,
	170,179,187,194,202,210,218,212,205,197,188,180,173,164,156,149,
	141,137,144,152,161,169,177,185,193,202,210,219,227,235,244,251,
	242,234,226,218,210,202,193,185,177,169,160,153,144,136,127,120,
	111,107,112,120,127,134,141,149,156,163,170,177,184,191,198,205,
	211,217,224,231,238,244,247,246,240,234,228,222,216,211,205,199,
	194,188,182,177,175,183,191,198,207,214,222,230,238,246,249,241,
	233,225,217,210,201,194,186,178,170,161,153,146,138,130,122,115,
	106,98,91,83,76,68,60,52,45,42,39,37,36,35,34,33,
	32,31,31,34,42,49,57,64,72,80,87,94,102,110,118,125,
	133,140,148,156,163,171,178,186,193,200,208,216,223,230,238,245,
	250,243,235,228,220,213,206,198,191,183,176,168,161,154,147,139,
	134,134,137,142,147,152,157,163,168,173,179,185,190,196,202,207,
	214,219,226,232,238,245,248,245,239,232,225,218,211,204,197,191,
	183,176,169,161,154,146,139,133,133,140,146,152,159,165,171,178,
	184,190,197,203,209,215,217,211,204,198,192,186,179,173,166,159,
	153,146,139,133,126,119,120,128,137,145,154,162,171,179,188,196,
	176,185,193,200,208,216,215,207,199,191,182,174,166,158,150,143,
	136,137,145,152,161,169,177,186,194,202,211,219,227,236,244,251,
	242,234,226,217,209,201,193,184,176,168,160,151,143,136,127,119,
	112,113,120,128,136,143,150,158,165,172,179,186,193,200,207,213,
	220,227,233,240,246,248,243,237,231,225,219,213,207,201,194,190,
	184,178,173,169,175,183,191,199,207,215,223,231,239,247,248,240,
	232,224,216,209,201,193,185,177,169,161,153,145,137,129,122,114,
	106,98,91,83,75,67,59,51,43,36,30,27,25,24,23,21,
	20,21,27,34,42,49,57,64,72,80,88,95,103,110,118,126,
	133,141,148,156,163,171,178,185,193,201,208,216,223,231,238,245,
	250,243,235,228,220,213,206,198,190,183,175,168,161,154,146,139,
	132,127,127,132,137,142,147,152,158,163,168,174,181,186,192,198,
	203,210,217,223,229,235,242,247,247,241,234,227,220,213,207,199,
	192,185,177,170,162,155,147,139,135,140,146,152,160,166,172,178,
	184,190,197,203,210,216,217,211,204,198,192,185,179,173,166,160,
	152,146,139,133,126,119,115,122,130,139,148,156,165,173,181,190,
	182,190,198,205,214,216,209,201,193,185,176,169,160,152,144,137,
	131,137,145,153,161,169,178,186,194,202,211,219,227,235,244,250,
	242,234,225,217,209,201,192,184,175,168,160,151,142,135,127,119,
	115,121,128,136,144,151,159,166,173,181,188,194,201,208,215,223,
	229,236,243,248,247,240,234,228,221,215,209,204,198,191,185,179,
	174,169,164,167,176,183,191,200,208,215,223,231,240,247,248,240,
	231,223,216,208,200,192,185,177,169,160,152,145,137,129,121,114,
	106,98,90,82,74,67,59,51,43,36,28,20,16,13,11,10,
	13,19,27,35,42,50,57,65,72,80,88,95,103,111,118,126,
	133,141,148,156,163,171,179,186,193,200,208,216,223,231,238,246,
	250,242,235,228,220,212,206,198,191,183,176,168,161,153,146,139,
	131,124,120,122,127,132,137,142,148,153,159,165,170,176,182,188,
	194,200,206,213,219,226,232,239,245,248,243,236,230,223,215,208,
	201,194,186,178,171,164,156,148,142,140,147,153,159,166,172,178,
	184,190,197,203,210,216,217,211,205,198,192,185,179,172,166,159,
	152,146,139,132,126,119,112,116,124,133,142,150,159,167,175,184,
	188,195,203,211,218,212,204,196,187,179,171,162,154,146,138,131,
	129,137,145,153,161,170,178,186,194,202,211,219,228,236,245,250,
	242,233,225,217,208,200,192,184,175,167,160,151,142,134,126,120,
	122,129,137,144,152,160,167,175,182,189,196,203,211,218,225,231,
	239,246,248,244,238,232,226,219,213,206,200,194,188,182,176,170,
	165,159,160,168,176,183,192,200,208,216,223,232,240,248,247,239,
	231,223,216,208,200,192,184,176,168,161,153,145,137,129,122,113,
	105,98,90,82,74,67,59,51,43,35,28,20,12,6,2,5,
	11,20,27,34,43,50,57,65,72,80,88,95,103,110,118,125,
	133,141,148,156,164,171,179,186,193,201,208,216,223,231,239,246,
	250,242,235,227,220,213,205,197,190,183,175,168,161,154,146,139,
	131,124,117,114,117,122,127,132,138,143,149,155,160,166,173,178,
	184,191,197,203,210,217,223,229,236,244,249,246,239,231,224,217,
	210,203,195,187,180,172,164,157,149,143,147,153,159,166,172,178,
	184,191,197,203,210,216,217,210,204,198,191,185,178,172,166,159,
	153,146,139,132,126,118,112,111,119,127,135,144,153,161,170,179,
	193,200,209,217,214,206,197,190,181,173,165,156,149,141,132,126,
	130,137,145,153,161,170,178,186,194,203,211,220,228,237,245,250,
	241,233,225,217,209,200,191,183,175,167,160,150,143,134,126,124,
	130,137,145,153,161,168,175,183,190,198,205,212,219,226,233,240,
	246,248,242,236,229,223,216,210,203,197,191,184,179,172,167,161,
	154,152,161,168,176,184,192,200,208,216,224,232,241,248,247,239,
	231,223,216,208,200,192,183,176,168,160,152,145,137,129,121,113,
	106,98,90,82,74,66,58,51,43,36,28,20,12,7,4,7,
	11,19,27,35,42,50,58,65,73,80,88,95,103,111,118,126,
	133,141,149,156,164,171,178,186,194,201,209,216,224,231,239,246,
	250,242,234,227,220,213,205,198,190,182,175,168,160,153,146,138,
	131,123,116,110,108,112,117,123,127,133,139,144,150,157,163,169,
	175,181,188,194,200,207,214,220,228,234,241,247,246,241,233,226,
	219,211,204,196,188,181,173,165,158,150,147,153,159,166,172,179,
	184,191,197,203,210,216,217,210,204,198,192,186,179,172,165,159,
	152,146,139,133,126,119,112,107,113,121,129,138,147,155,164,173,
	199,206,214,216,209,200,192,184,176,167,159,151,143,134,127,122,
	129,137,146,154,162,170,178,186,195,203,212,221,228,237,245,249,
	241,233,224,216,207,199,191,183,175,167,159,150,142,134,128,130,
	138,146,153,161,169,176,184,191,199,205,213,221,228,234,242,247,
	246,240,233,227,220,214,207,201,195,188,181,175,169,163,157,151,
	147,152,160,168,177,185,192,200,208,216,224,232,241,248,247,239,
	231,223,215,207,199,191,183,176,168,160,153,145,136,129,121,113,
	106,97,90,82,75,66,59,51,43,36,28,20,15,14,15,16,
	18,19,27,35,42,50,58,65,73,80,88,96,103,111,119,126,
	133,141,148,156,163,171,178,186,194,201,208,216,224,231,239,247,
	250,242,234,227,220,212,205,197,190,183,175,168,160,153,146,138,
	131,124,116,109,103,101,106,112,117,123,129,135,141,146,153,159,
	165,172,178,185,191,198,205,211,218,224,231,239,246,247,242,235,
	228,221,213,205,197,190,182,174,166,158,152,154,159,166,172,178,
	184,191,197,204,210,216,217,210,204,198,192,185,179,172,165,159,
	153,146,139,133,125,119,112,106,107,115,124,132,140,149,158,167,
	204,211,218,211,202,194,186,178,170,162,153,145,137,128,121,122,
	129,138,146,154,162,170,178,187,195,203,212,220,228,237,246,249,
	241,232,224,216,208,199,191,183,175,166,158,150,142,134,132,138,
	146,154,162,169,177,185,192,200,207,215,222,229,236,243,248,244,
	238,232,225,218,211,205,198,192,185,179,172,166,160,154,147,142,
	145,153,160,168,177,184,192,200,208,217,224,233,241,248,247,239,
	231,223,215,207,199,191,183,176,168,160,152,144,136,129,121,113,
	105,97,90,82,74,66,59,51,43,36,28,22,24,25,26,27,
	28,28,31,35,42,50,58,65,72,80,88,95,103,111,119,126,
	133,141,149,156,163,171,178,186,194,201,209,216,223,230,238,246,
	250,242,234,227,220,213,205,198,190,182,175,168,161,153,146,138,
	131,124,116,109,101,96,96,102,108,114,119,125,131,137,143,150,
	156,162,168,175,181,188,195,202,208,216,223,230,237,244,247,243,
	237,229,222,214,206,198,190,183,174,166,159,155,160,166,173,179,
	185,191,197,204,210,216,216,210,204,198,191,184,178,172,165,160,
	152,146,139,133,125,118,112,105,101,109,118,126,135,144,153,161,
	209,217,214,205,197,189,180,172,164,156,147,139,131,122,116,122,
	130,138,146,154,162,170,179,188,196,204,213,220,229,238,246,249,
	240,232,224,215,207,199,191,183,175,166,158,149,142,135,138,146,
	154,162,170,177,185,193,201,208,215,223,230,238,244,247,244,237,
	230,223,216,209,202,195,189,182,176,170,163,157,151,145,138,138,
	145,152,161,168,176,185,193,201,209,217,225,232,240,248,247,239,
	231,223,215,208,199,191,183,175,168,160,152,144,136,129,121,113,
	106,97,90,82,74,67,59,51,43,35,32,33,35,36,37,38,
	39,40,40,42,43,50,58,66,73,80,88,96,103,110,118,126,
	134,141,148,156,163,171,178,186,194,201,209,216,224,231,238,246,
	249,242,235,227,220,212,205,198,190,183,175,168,161,153,146,138,
	131,124,116,109,102,94,89,92,97,103,110,116,121,127,133,140,
	146,152,158,166,172,179,186,193,200,207,214,221,228,236,243,247,
	245,237,230,222,214,207,199,191,183,175,167,160,160,166,173,178,
	185,191,198,204,210,216,216,210,204,198,191,185,179,172,165,159,
	152,145,139,132,125,119,112,105,99,103,112,120,129,138,146,156,
	215,216,208,200,192,183,175,166,158,150,142,134,125,117,114,122,
	130,138,146,154,162,171,179,188,196,203,213,221,229,238,247,249,
	241,232,223,215,207,199,190,183,174,166,157,150,142,139,146,154,
	162,170,177,185,193,201,209,216,224,231,238,245,246,243,235,228,
	222,214,207,201,194,186,180,173,167,160,154,148,142,135,131,137,
	145,152,161,169,176,185,193,201,209,217,224,232,240,248,246,238,
	230,223,215,207,199,191,183,175,168,160,152,144,136,128,121,113,
	105,97,90,82,74,66,59,51,43,40,43,44,45,47,48,50,
	51,51,52,52,52,53,59,65,73,80,88,96,103,111,118,125,
	133,141,149,156,163,171,179,186,193,201,209,216,224,231,239,246,
	250,242,235,227,220,212,205,198,190,182,175,168,160,153,146,138,
	131,123,116,109,102,94,86,83,88,94,100,105,112,117,124,130,
	137,143,150,156,163,169,177,184,191,198,205,212,219,227,234,242,
	246,245,238,231,223,215,207,199,191,183,175,167,162,166,173,179,
	185,191,198,204,210,217,216,210,204,198,191,184,179,172,165,158,
	152,145,139,132,125,119,112,105,99,98,106,114,124,132,141,150,
	220,212,203,195,186,178,169,161,153,144,136,128,119,113,114,121,
	130,138,146,154,163,171,179,187,196,204,212,221,230,237,246,248,
	240,232,223,215,206,198,190,182,174,165,157,149,143,146,154,162,
	170,178,186,193,201,210,217,224,232,239,246,246,241,234,227,220,
	213,206,198,192,185,178,171,164,157,151,145,139,132,127,129,137,
	145,153,161,169,177,185,193,201,209,217,224,232,240,248,246,239,
	231,223,215,207,199,191,183,175,168,160,152,144,136,129,121,113,
	105,97,90,82,74,66,58,51,50,52,53,55,56,58,60,61,
	62,63,63,64,65,65,65,67,73,80,88,96,103,111,118,126,
	133,141,148,156,163,171,178,186,194,201,208,216,224,231,239,246,
	250,242,235,227,220,212,205,198,190,183,175,168,160,153,146,138,
	131,124,117,109,102,94,86,81,79,84,90,96,102,108,114,120,
	127,134,140,147,154,160,168,174,181,188,196,203,211,218,225,233,
	240,246,246,239,231,223,215,208,200,191,183,175,168,166,173,178,
	185,191,198,204,211,216,216,210,204,197,191,184,178,172,165,158,
	152,145,139,132,125,119,112,105,98,93,100,108,118,126,135,145,
	215,206,198,190,181,172,164,155,147,139,131,122,114,108,114,122,
	130,139,146,154,163,171,179,187,196,205,213,221,230,238,247,248,
	239,231,223,214,206,198,190,181,174,165,157,149,145,153,161,170,
	178,186,194,201,209,217,225,232,240,246,247,240,233,226,219,211,
	204,197,190,183,176,169,162,155,149,143,136,130,123,121,129,137,
	145,153,161,169,177,185,193,201,209,217,224,233,241,249,246,239,
	231,223,215,207,199,191,183,175,168,160,152,144,136,128,120,113,
	106,97,90,82,74,66,60,59,61,63,65,66,68,69,70,72,
	73,74,74,75,75,75,76,76,77,81,88,95,103,111,118,126,
	133,140,148,156,163,171,178,186,193,200,208,216,223,231,238,246,
	250,242,235,228,220,212,205,198,190,183,175,168,160,153,145,138,
	131,124,116,109,102,95,87,80,74,74,80,86,92,98,104,111,
	117,124,131,137,144,151,159,165,172,180,187,194,201,209,217,225,
	232,240,246,245,240,232,224,216,208,200,191,183,175,169,172,178,
	186,192,198,204,210,217,216,210,204,197,191,184,178,172,166,158,
	152,145,139,132,125,118,112,105,98,92,94,103,112,120,130,139,
	210,201,192,184,175,167,158,150,142,133,125,116,108,106,114,122,
	130,138,146,155,163,171,180,188,196,205,213,221,230,239,247,247,
	239,231,223,215,206,198,190,181,173,165,157,151,153,161,169,177,
	186,194,201,209,217,225,233,241,246,246,240,232,225,217,210,203,
	196,188,181,174,167,161,154,146,140,133,127,120,116,121,130,137,
	145,153,161,169,177,185,193,201,209,217,225,233,241,249,247,239,
	230,222,215,207,199,191,183,176,168,159,152,144,136,128,121,113,
	105,97,90,82,74,68,67,70,72,74,76,77,79,80,81,82,
	84,85,85,85,86,87,87,87,87,87,90,95,103,111,118,125,
	133,141,148,156,163,171,178,186,193,201,208,216,223,231,238,246,
	250,242,235,228,221,212,206,198,190,183,175,168,161,153,146,138,
	131,124,117,109,102,95,87,80,72,67,71,76,83,89,95,102,
	108,115,122,129,135,142,149,156,163,170,178,186,193,201,208,216,
	224,231,239,245,246,240,232,224,215,208,199,191,182,175,172,178,
	186,192,198,204,211,217,217,210,203,197,191,184,178,172,165,159,
	152,145,139,132,125,118,112,105,98,92,89,97,106,114,124,133,
	204,196,187,179,170,161,153,145,136,128,119,111,104,107,114,122,
	130,139,147,155,163,171,180,188,196,205,213,222,230,239,248,247,
	238,230,223,214,206,198,190,181,172,165,157,154,160,169,177,185,
	194,201,209,217,225,233,241,247,247,239,231,223,216,209,201,194,
	187,180,173,165,158,152,145,138,131,124,118,112,113,121,129,137,
	145,153,161,169,177,185,193,201,209,217,225,233,241,249,246,239,
	231,223,214,207,199,191,183,176,168,160,152,144,136,128,121,113,
	106,97,89,82,76,76,78,81,83,85,87,88,90,92,93,93,
	95,96,97,97,97,98,98,98,98,98,97,99,103,110,118,125,
	133,141,148,156,163,171,178,185,193,201,208,216,223,231,238,245,
	250,242,236,228,221,212,205,198,191,183,176,168,161,153,146,138,
	132,124,117,109,102,95,87,80,72,65,62,67,73,79,85,92,
	99,106,113,120,126,133,140,147,154,162,169,177,184,192,199,207,
	215,223,230,238,246,246,240,232,224,216,207,198,190,182,175,178,
	186,192,198,204,210,217,217,210,203,197,191,184,178,172,165,158,
	152,145,139,132,126,119,112,106,98,92,86,92,101,109,118,128,
	199,191,182,173,165,156,148,139,131,122,114,106,100,106,114,122,
	131,139,147,156,164,171,179,188,197,205,213,222,230,239,247,247,
	238,230,222,214,206,198,189,181,172,164,158,160,168,176,184,193,
	201,209,217,225,233,241,247,246,238,231,223,216,208,201,193,186,
	178,172,164,157,150,142,136,130,122,115,109,105,113,121,129,137,
	145,153,162,169,177,185,193,201,209,217,225,233,241,249,247,239,
	231,223,215,207,199,191,183,175,168,160,152,144,136,129,120,113,
	105,98,90,84,85,87,89,92,94,96,98,99,100,102,103,105,
	106,107,108,109,109,109,109,109,109,109,109,108,109,112,118,126,
	133,140,148,156,163,170,178,186,193,201,209,216,223,230,238,246,
	250,242,235,228,220,213,206,198,191,183,176,169,161,153,146,139,
	131,124,117,109,102,94,87,80,73,65,58,58,63,70,76,83,
	89,96,103,110,117,124,131,138,145,152,160,168,175,183,190,198,
	206,214,222,230,238,246,247,241,232,224,215,206,198,190,181,179,
	186,192,198,204,210,217,217,210,204,197,191,184,178,172,165,159,
	152,145,139,132,125,118,112,105,98,91,85,86,95,103,113,122,
	194,186,177,168,159,151,142,133,125,117,108,100,98,106,115,123,
	131,139,147,156,164,172,180,188,197,205,214,222,230,239,248,247,
	238,230,222,214,205,197,189,180,173,164,161,167,175,184,192,201,
	209,216,224,233,240,248,247,238,230,223,215,208,199,192,185,177,
	171,163,156,149,141,134,128,120,114,107,101,105,113,121,129,137,
	145,153,161,169,177,185,193,201,209,217,225,233,241,249,247,239,
	231,223,215,207,199,191,184,175,168,160,152,144,136,129,121,113,
	105,98,91,93,96,98,100,103,105,107,109,111,112,113,114,116,
	117,117,118,119,120,121,120,120,120,120,120,120,119,119,119,125,
	133,140,148,155,163,170,178,185,193,201,208,215,223,230,237,246,
	250,243,236,228,220,213,206,198,191,184,176,169,162,154,147,139,
	131,124,117,110,102,94,87,80,73,65,58,53,54,61,67,74,
	80,87,93,101,108,115,122,129,136,144,152,159,167,174,183,190,
	198,206,214,222,230,238,246,247,240,232,223,214,206,197,189,182,
	186,192,198,204,210,217,217,210,203,197,191,184,178,172,165,159,
	152,144,139,132,125,119,112,105,98,92,85,81,90,98,107,117,
	188,180,172,163,154,145,137,128,120,111,103,96,98,106,115,123,
	131,139,147,155,163,172,181,189,197,205,214,222,231,240,248,246,
	238,230,222,213,205,197,189,180,172,166,166,175,183,191,200,208,
	216,224,232,241,246,247,239,231,223,215,207,199,192,184,177,169,
	162,154,147,140,133,126,119,112,105,98,97,105,113,121,130,137,
	145,153,161,169,177,185,193,201,209,217,225,233,240,249,247,239,
	231,223,215,207,199,191,183,176,168,160,153,144,136,128,121,113,
	106,98,101,104,106,109,111,113,116,117,120,121,123,125,126,127,
	128,129,130,130,131,132,132,132,131,131,131,131,130,129,128,128,
	132,140,148,155,162,170,178,185,192,200,208,215,223,230,237,246,
	251,243,235,228,221,213,205,198,192,184,177,169,162,154,147,139,
	132,125,117,110,103,95,87,80,73,66,58,51,47,52,58,65,
	72,78,85,92,99,106,114,121,128,136,143,151,158,166,174,182,
	189,198,205,213,221,229,238,247,248,240,231,222,214,205,197,188,
	186,191,198,204,211,217,216,210,203,197,191,184,177,171,165,158,
	152,145,139,132,125,119,112,106,98,91,85,78,84,93,103,111,
	184,175,167,158,149,140,132,123,115,106,98,92,98,107,115,122,
	131,139,147,155,164,172,180,189,197,205,214,222,230,239,248,246,
	238,230,221,214,204,197,188,180,172,168,173,181,190,198,207,215,
	223,232,240,247,247,239,231,223,215,207,199,192,184,176,168,161,
	154,147,139,132,124,117,110,104,96,90,98,105,113,121,129,138,
	145,154,162,169,177,185,193,201,209,217,225,233,241,249,246,239,
	231,223,215,207,199,192,183,175,168,160,153,144,137,129,121,113,
	108,109,112,114,117,120,122,124,127,129,130,132,134,136,137,138,
	139,140,141,142,142,142,143,143,143,142,142,141,141,140,140,139,
	137,141,147,155,162,170,178,185,192,200,208,215,222,230,237,245,
	251,243,235,228,221,213,206,199,191,184,177,169,162,154,147,140,
	132,124,117,110,103,95,88,81,73,66,58,51,44,44,48,55,
	62,69,76,83,90,97,104,112,120,126,135,142,150,157,166,173,
	181,189,197,205,213,221,230,239,246,247,239,231,222,213,204,196,
	188,192,198,205,210,217,216,210,204,197,191,184,177,171,165,158,
	151,145,139,132,125,119,111,105,98,92,85,78,79,87,97,107,
	179,170,162,153,144,135,127,118,110,101,93,91,99,107,114,123,
	131,139,147,156,164,172,180,189,197,205,214,223,231,240,248,246,
	238,230,221,213,204,197,188,180,173,172,180,188,197,206,214,222,
	231,239,247,247,238,231,223,215,208,200,191,184,176,168,160,153,
	146,138,131,124,116,109,102,95,88,89,97,106,113,121,129,137,
	145,154,162,169,177,185,193,201,209,217,225,233,241,249,246,239,
	231,223,215,207,199,192,184,176,168,160,153,145,137,129,122,116,
	116,119,122,125,128,131,133,135,138,139,141,143,145,146,148,149,
	150,151,152,152,153,153,153,154,154,153,153,153,152,151,151,150,
	148,147,149,155,163,170,178,185,192,200,207,215,222,230,237,245,
	251,243,236,229,221,214,207,199,191,184,177,169,162,154,147,140,
	132,125,117,110,103,95,88,81,74,67,59,51,44,38,40,46,
	53,59,67,74,81,89,95,103,110,118,125,134,141,149,157,165,
	173,181,189,197,205,214,222,230,239,246,246,238,229,221,212,203,
	194,192,198,204,210,217,216,210,204,197,191,184,178,172,165,158,
	151,145,139,132,125,118,112,105,98,92,85,78,74,82,92,101,
	174,165,157,148,139,131,122,113,105,96,88,91,99,106,114,123,
	131,139,148,156,164,173,181,189,198,206,214,223,231,240,248,246,
	238,229,221,212,205,196,188,180,175,179,187,196,205,213,221,230,
	238,246,247,239,232,223,215,208,200,191,183,176,168,160,152,145,
	137,130,123,116,108,100,94,86,83,89,97,106,113,121,129,137,
	145,153,161,169,177,185,193,201,209,217,225,233,241,248,247,239,
	231,223,216,208,200,192,183,176,168,161,152,145,137,129,124,124,
	127,130,134,136,139,141,144,146,149,151,153,155,155,157,159,160,
	161,162,163,164,164,165,165,165,165,165,165,164,163,163,162,160,
	159,158,157,158,163,169,177,185,192,199,206,214,222,229,236,244,
	251,244,237,228,221,215,206,199,192,184,177,170,162,154,147,140,
	133,125,117,110,103,95,88,81,73,67,59,52,45,37,33,37,
	43,50,58,65,72,80,87,94,102,109,117,125,133,141,148,156,
	164,172,181,189,197,205,214,223,231,240,246,245,236,228,220,210,
	202,194,198,204,210,217,216,210,204,197,191,184,178,172,166,159,
	152,145,139,132,125,119,112,105,98,92,85,78,71,77,86,96,
	169,160,152,143,134,125,117,108,99,91,84,90,99,107,115,123,
	131,139,147,155,164,173,181,189,198,206,215,224,232,240,249,246,
	238,229,221,212,205,196,188,181,179,186,194,203,212,220,229,237,
	246,247,241,232,224,216,208,200,192,184,176,168,160,152,145,137,
	129,122,114,107,99,92,85,78,81,89,97,105,113,121,129,137,
	145,153,161,169,177,185,192,200,209,216,225,232,240,248,247,239,
	231,223,215,208,200,192,184,176,168,161,152,144,137,131,131,134,
	137,141,144,147,149,152,154,157,159,161,163,165,167,169,170,171,
	173,174,174,175,175,175,176,176,176,176,176,175,175,174,173,172,
	171,169,168,166,166,170,177,184,191,199,207,214,221,228,236,244,
	251,244,237,229,223,214,206,199,192,184,177,170,163,155,148,140,
	133,125,118,111,103,96,89,81,74,67,59,52,44,37,30,30,
	35,42,49,56,64,71,78,85,93,100,108,116,124,132,140,148,
	156,164,173,181,190,198,206,215,223,232,241,248,245,236,227,218,
	208,199,198,204,211,217,216,210,204,197,191,185,178,172,165,158,
	152,144,138,132,125,119,112,105,98,91,85,78,72,72,81,91,
	164,156,147,138,129,120,112,103,94,86,83,91,99,107,115,123,
	131,139,148,156,164,173,181,190,198,207,215,224,232,240,249,245,
	238,229,221,213,205,196,188,182,184,193,201,210,218,227,236,244,
	248,241,233,224,217,208,200,193,184,176,168,160,152,144,137,129,
	121,114,106,98,91,84,76,74,81,89,97,105,113,121,130,137,
	145,153,161,169,177,185,193,200,209,217,224,232,240,248,247,239,
	231,223,215,208,200,192,184,177,169,161,153,145,139,138,141,145,
	148,151,154,157,160,163,166,168,170,172,175,176,177,179,181,183,
	184,184,185,186,186,187,187,188,187,187,187,186,186,185,184,183,
	182,180,179,177,175,174,177,184,191,199,206,213,221,228,236,243,
	251,245,237,230,222,214,207,200,192,185,178,170,163,155,148,140,
	133,125,118,111,104,96,89,82,74,67,60,52,45,38,30,24,
	26,33,39,47,54,62,69,76,84,92,100,108,115,124,132,140,
	148,157,165,173,181,190,199,207,216,224,233,242,249,243,234,226,
	216,206,200,204,211,217,217,210,203,197,191,184,178,171,165,158,
	151,145,138,132,125,119,112,105,98,91,85,78,71,67,76,86,
	159,151,142,133,124,116,107,98,89,81,83,91,99,107,115,123,
	131,139,148,156,164,173,182,189,198,207,215,224,232,240,249,245,
	237,229,221,212,204,196,188,184,191,200,208,217,226,234,243,248,
	242,234,226,217,209,201,193,185,177,168,160,152,144,136,129,121,
	113,106,98,90,83,75,70,73,81,88,97,105,113,120,129,137,
	145,153,161,169,177,184,193,201,209,217,224,232,240,248,247,239,
	232,224,216,208,200,192,184,177,169,161,153,146,145,148,151,155,
	159,162,165,168,171,174,177,179,181,183,186,187,189,191,192,193,
	195,195,196,197,197,198,199,199,198,198,198,197,197,196,195,194,
	193,191,190,188,186,184,183,185,191,198,206,214,221,228,236,243,
	251,245,238,230,223,215,208,200,193,185,178,170,163,156,149,141,
	134,126,119,112,104,97,90,82,74,67,60,52,45,37,30,23,
	20,24,31,38,46,53,61,68,76,84,92,99,107,116,123,132,
	140,149,157,165,174,182,191,200,208,217,226,234,243,248,241,232,
	223,214,204,204,210,216,216,210,204,197,191,184,178,171,165,158,
	152,145,138,132,126,119,112,105,99,92,84,78,71,64,72,81,
	155,146,137,128,119,111,102,93,84,77,83,91,99,107,115,124,
	132,139,148,156,164,173,181,189,198,207,215,224,232,240,249,245,
	237,229,220,212,204,196,189,189,198,207,216,224,233,242,248,244,
	235,227,219,210,201,193,185,177,169,161,153,145,137,129,121,113,
	105,98,90,82,75,67,66,73,81,89,97,105,113,120,129,137,
	145,153,161,169,176,184,192,200,208,216,224,231,239,248,247,240,
	232,224,216,208,200,192,185,177,169,161,154,152,155,158,162,165,
	169,173,176,179,181,184,187,189,192,194,196,198,200,202,203,204,
	205,207,208,208,209,209,209,210,210,209,209,208,208,207,206,205,
	204,203,201,199,197,195,193,192,192,198,206,214,220,228,236,243,
	250,245,238,231,224,216,208,201,194,186,178,171,163,156,149,142,
	135,127,120,112,104,97,90,82,75,68,60,53,46,39,31,23,
	16,15,22,30,37,45,52,60,68,76,83,91,99,108,116,124,
	132,140,149,157,166,174,183,192,201,209,218,227,236,245,248,239,
	230,221,210,206,210,216,217,210,203,197,191,184,178,171,165,159,
	151,145,138,132,126,118,111,105,98,92,84,78,71,64,66,75,
	150,141,132,123,114,105,97,88,80,76,83,91,100,107,115,123,
	131,140,148,156,165,173,181,190,198,207,215,224,232,241,249,246,
	236,229,220,212,204,196,190,195,205,214,222,231,239,247,245,237,
	228,220,212,203,194,186,178,169,162,153,145,137,129,121,113,105,
	97,90,82,74,66,61,65,73,81,89,96,105,113,121,129,137,
	145,153,160,168,176,184,192,200,208,216,224,232,240,248,247,239,
	232,224,216,208,201,193,185,177,169,161,158,161,165,169,173,176,
	179,183,186,189,192,195,198,200,203,205,206,209,211,212,214,215,
	216,218,219,220,220,220,220,221,221,220,220,220,219,218,217,216,
	214,213,212,210,208,206,204,202,200,198,204,213,220,227,235,242,
	250,246,239,231,223,216,209,201,194,186,179,172,164,156,149,142,
	134,127,120,112,105,97,90,83,75,68,60,53,47,38,31,24,
	16,11,13,21,28,36,44,51,59,67,75,83,91,99,108,116,
	124,133,141,150,158,167,175,184,193,202,210,220,229,238,247,246,
	238,228,217,209,210,217,217,211,204,197,191,184,177,171,165,158,
	152,145,138,132,125,119,111,105,98,92,85,78,72,65,62,71,
	146,136,127,118,109,101,92,83,75,76,83,91,99,108,115,123,
	131,140,148,156,165,173,181,190,198,206,215,224,232,241,250,245,
	236,229,220,212,204,196,193,202,211,220,229,237,246,246,239,230,
	221,213,205,196,187,179,170,162,154,145,137,129,121,114,105,97,
	89,82,74,66,59,58,64,72,81,89,96,104,113,121,128,137,
	145,152,160,168,176,184,192,200,208,216,224,232,240,247,248,240,
	232,224,216,209,201,193,185,177,170,165,167,171,175,179,183,187,
	190,193,197,200,203,206,208,211,213,215,217,219,222,224,225,226,
	227,229,230,231,231,231,232,232,232,232,231,231,230,229,228,227,
	226,225,223,221,219,217,215,213,210,208,205,212,219,227,235,242,
	249,246,239,232,224,216,209,202,194,187,179,172,165,157,149,141,
	135,128,120,113,105,98,90,83,75,68,60,54,46,39,32,24,
	17,10,6,12,20,28,35,43,51,59,66,75,83,91,99,108,
	116,125,133,142,151,159,167,176,185,195,203,213,222,231,240,247,
	244,235,225,214,212,217,216,210,204,198,191,184,178,171,165,158,
	151,145,139,132,125,119,112,105,99,92,85,78,71,64,57,66,
	141,131,123,113,105,96,87,79,71,76,83,91,99,107,116,124,
	132,140,149,156,165,173,182,190,198,206,215,223,232,241,250,245,
	237,229,220,212,204,197,199,208,217,227,235,244,247,241,232,223,
	214,206,198,189,180,171,163,155,147,139,130,122,114,106,98,90,
	82,74,66,58,52,57,64,72,81,89,96,104,112,121,128,137,
	144,152,160,168,176,184,192,200,208,216,223,232,239,247,248,240,
	232,225,217,209,201,193,186,178,173,173,177,181,185,189,193,197,
	200,204,207,210,214,217,219,222,224,226,229,231,233,234,236,238,
	239,240,241,242,242,242,243,243,242,242,242,241,241,240,240,239,
	237,236,234,232,230,228,226,223,221,218,216,214,219,227,234,241,
	249,246,239,232,224,217,209,202,195,187,180,172,165,158,149,142,
	135,127,121,113,106,98,91,83,76,69,62,54,46,39,32,25,
	17,10,4,4,11,19,26,35,43,50,58,67,75,83,92,100,
	108,117,125,134,143,152,160,170,178,187,196,206,214,223,233,242,
	247,241,231,221,214,216,216,210,203,197,191,184,178,172,165,158,
	152,144,139,132,125,119,112,105,98,92,84,78,71,64,57,61,
	136,127,118,109,100,91,82,74,68,75,83,91,99,107,116,124,
	132,140,149,157,165,173,181,190,198,206,216,224,232,241,250,245,
	236,228,221,212,203,199,206,215,224,233,242,247,242,234,225,216,
	208,199,190,182,172,164,156,148,140,131,122,114,106,98,90,82,
	74,66,58,51,50,56,65,73,80,89,96,104,111,121,128,136,
	144,152,160,168,175,184,192,199,207,215,223,231,239,247,248,241,
	233,225,217,209,202,194,186,180,179,183,187,191,195,200,204,207,
	211,214,217,221,224,227,229,232,235,237,240,242,244,246,247,248,
	249,248,247,247,246,246,246,246,248,249,249,248,246,246,246,248,
	248,247,245,243,241,239,237,234,232,229,226,223,222,227,234,241,
	248,247,240,232,224,217,209,202,195,188,181,173,165,158,151,143,
	136,128,121,114,107,100,93,86,78,71,64,57,50,43,36,28,
	21,13,6,1,5,12,19,27,35,42,50,59,67,75,84,92,
	100,109,118,127,135,144,153,162,171,180,188,198,207,216,226,235,
	244,246,238,228,218,217,217,210,204,197,191,184,178,171,165,158,
	152,145,139,132,125,118,112,105,99,92,85,78,71,64,58,56,
	132,123,113,105,96,87,78,69,68,75,83,91,99,107,115,123,
	132,140,148,157,165,174,181,191,199,206,215,224,233,241,250,245,
	236,228,220,212,205,203,212,222,231,240,246,244,236,227,218,209,
	201,192,183,175,166,158,149,140,132,123,115,107,99,91,83,75,
	67,59,50,45,48,56,64,72,80,88,97,104,112,120,128,137,
	144,151,160,167,175,184,191,199,207,215,223,231,238,246,249,241,
	233,226,218,210,202,194,187,185,188,193,197,201,206,210,214,218,
	222,225,228,231,235,238,241,243,245,246,246,246,246,245,244,243,
	242,241,240,239,239,239,238,238,238,238,238,239,239,241,241,242,
	243,245,247,250,248,246,246,245,242,240,237,234,231,229,234,240,
	248,247,240,232,225,218,210,203,195,188,181,173,166,158,151,144,
	138,131,125,119,112,106,99,93,86,80,73,66,59,51,44,37,
	30,22,14,7,4,10,16,23,30,37,44,51,59,67,76,84,
	93,101,110,119,128,136,146,155,164,173,181,191,200,209,218,228,
	237,246,245,235,224,219,217,210,204,198,191,185,178,172,165,158,
	152,145,139,132,125,118,112,105,98,92,85,78,71,64,58,52,
	128,118,109,100,92,82,74,66,67,75,83,91,99,107,116,124,
	132,140,148,157,165,174,182,190,199,207,216,224,232,241,250,245,
	237,228,220,211,205,209,219,228,237,245,246,239,230,221,212,202,
	194,185,177,168,159,151,142,133,125,116,108,100,92,83,75,67,
	59,51,42,42,48,56,64,72,80,87,96,104,112,120,128,136,
	144,151,160,167,175,183,191,199,207,214,223,231,238,246,249,241,
	234,226,218,210,202,195,191,193,198,203,208,212,216,220,224,228,
	232,235,239,242,246,248,249,248,247,244,242,240,238,236,234,233,
	231,230,229,229,228,227,227,227,227,227,227,228,229,229,230,231,
	233,234,236,238,240,242,244,245,246,249,248,244,241,238,237,240,
	247,248,241,234,226,218,211,204,196,189,183,176,170,164,158,153,
	147,140,134,128,122,115,108,102,95,89,82,74,67,59,52,46,
	38,30,22,14,7,10,16,23,29,35,42,48,55,62,69,77,
	85,94,103,112,120,129,138,147,156,166,174,183,193,202,212,221,
	231,241,246,241,231,222,217,210,204,198,192,185,178,171,165,158,
	152,145,139,132,125,119,112,105,99,92,85,79,71,64,58,51,
	123,114,105,96,87,78,69,62,67,75,83,91,99,107,116,124,
	132,140,148,157,165,174,182,190,199,207,216,224,233,241,250,245,
	237,228,220,211,207,216,225,234,243,247,241,232,223,214,205,196,
	187,179,170,161,152,143,134,126,118,110,101,93,84,76,68,60,
	51,43,37,40,48,56,63,71,80,88,96,104,112,119,128,135,
	143,152,159,167,174,183,191,198,207,214,222,230,238,246,250,242,
	234,226,218,210,203,197,198,203,208,213,218,222,226,230,235,239,
	242,244,246,246,245,244,241,238,236,233,231,229,227,225,223,222,
	220,219,218,218,217,217,216,215,216,215,217,217,217,218,219,221,
	222,223,225,227,229,231,233,236,239,242,244,247,248,246,244,243,
	247,249,241,234,227,220,213,206,201,195,191,185,180,174,168,162,
	156,150,144,138,131,124,117,111,104,97,90,83,76,69,61,54,
	47,38,31,23,15,10,16,22,29,35,42,48,54,61,67,74,
	81,88,95,104,113,122,130,140,149,158,168,177,186,195,205,214,
	224,234,244,246,237,227,219,211,205,198,191,185,178,171,165,158,
	152,146,139,132,125,118,112,106,99,91,85,79,72,65,58,51,
	119,109,100,91,82,73,64,60,67,75,83,91,99,108,116,124,
	132,140,148,157,165,173,182,190,199,207,215,224,233,242,250,245,
	236,227,220,213,213,221,231,241,247,244,235,226,217,208,199,190,
	181,173,162,154,145,137,129,119,111,102,94,86,77,69,60,53,
	44,36,33,40,48,56,64,71,79,88,96,104,111,119,128,135,
	143,151,159,167,175,182,190,198,206,214,222,229,237,245,250,242,
	234,226,218,211,204,203,208,213,218,223,227,232,236,241,245,248,
	249,247,243,240,237,234,231,228,225,223,220,217,216,214,212,211,
	209,208,208,206,206,205,205,204,204,205,205,206,206,207,208,210,
	211,212,214,216,217,220,222,225,228,231,234,237,240,244,246,247,
	249,249,242,235,231,226,221,216,211,205,201,195,190,184,178,172,
	166,160,153,147,140,134,127,120,113,106,99,93,85,77,70,62,
	55,47,39,32,24,15,16,22,28,35,42,48,54,61,67,73,
	80,87,93,99,107,114,123,132,142,151,161,170,179,189,198,208,
	217,227,238,246,244,234,223,213,205,198,191,185,178,172,165,158,
	152,146,139,132,125,118,112,105,98,92,84,78,71,64,58,51,
	114,105,96,88,78,69,60,59,67,75,83,91,100,108,116,124,
	132,141,149,157,165,173,182,190,199,207,215,224,233,241,250,245,
	237,228,220,213,219,228,237,245,246,238,229,220,211,202,192,183,
	174,166,156,147,139,131,122,112,104,95,86,78,70,61,53,45,
	37,30,32,40,48,55,64,71,79,87,95,103,111,119,127,136,
	143,151,158,166,175,183,190,197,206,214,221,229,237,245,250,242,
	234,227,219,211,208,213,217,223,228,232,237,242,246,248,247,244,
	240,237,233,230,227,223,220,217,214,211,210,207,205,203,201,200,
	199,197,196,196,194,194,193,193,193,193,193,194,195,196,197,198,
	200,202,203,205,207,210,212,214,217,220,223,226,230,234,237,242,
	247,251,248,245,241,236,231,226,221,215,210,204,199,193,187,182,
	175,169,162,156,149,143,136,130,123,116,108,101,94,85,79,71,
	63,56,48,40,32,23,18,21,27,34,41,47,54,60,66,73,
	79,86,92,99,105,112,119,125,135,144,153,163,172,181,191,201,
	211,221,232,242,247,240,229,218,208,198,192,185,179,172,165,158,
	153,146,139,133,125,119,112,105,98,92,85,78,71,64,58,52,
	110,101,92,84,74,65,57,59,67,75,83,92,100,107,115,124,
	132,141,149,157,165,174,182,190,199,207,216,224,233,241,250,245,
	236,228,220,216,224,234,243,247,241,232,222,213,204,195,185,177,
	167,159,150,141,133,124,115,106,97,88,80,71,63,54,46,37,
	30,26,31,39,47,55,63,71,79,87,95,103,111,119,127,135,
	143,150,158,166,173,181,189,198,206,213,221,228,237,244,251,243,
	235,227,219,213,217,222,227,232,238,242,246,246,245,243,238,234,
	230,226,223,219,216,212,210,207,204,202,198,196,194,192,191,189,
	188,187,185,184,184,183,183,183,182,183,184,184,184,185,186,187,
	189,191,192,194,196,198,201,203,206,209,213,216,220,225,231,238,
	245,251,245,246,251,246,241,236,231,226,220,214,209,203,197,191,
	185,178,172,165,159,152,146,139,132,125,117,109,102,94,87,79,
	72,64,56,48,40,32,24,22,27,34,40,47,53,60,66,72,
	79,86,92,99,105,112,118,124,131,137,146,156,165,175,184,194,
	204,214,225,235,245,246,235,224,213,202,193,186,179,172,165,159,
	153,146,139,132,126,119,112,105,98,91,84,78,71,65,58,52,
	107,97,88,79,70,61,53,60,67,76,83,91,100,108,116,124,
	132,141,149,157,165,174,182,190,199,207,216,224,233,241,250,244,
	237,228,220,221,230,240,247,245,235,225,216,207,198,189,180,170,
	161,152,143,134,126,117,107,99,90,82,73,64,56,47,39,31,
	24,24,31,39,47,55,62,70,79,87,94,103,111,119,127,134,
	142,150,158,166,174,181,189,197,205,212,221,229,236,244,251,243,
	235,228,220,221,227,232,237,242,245,247,246,241,236,232,228,224,
	220,216,212,208,205,202,198,196,193,189,187,185,183,181,180,178,
	177,175,175,173,173,172,172,172,171,172,172,172,173,174,175,176,
	178,180,181,183,185,187,190,192,195,199,202,207,214,222,230,237,
	245,251,244,238,242,247,248,245,241,235,230,224,219,212,206,200,
	194,188,181,175,168,162,154,147,140,133,126,118,111,103,95,88,
	80,72,65,56,48,40,32,26,27,33,40,46,53,59,65,73,
	79,85,92,98,104,111,118,124,130,137,143,150,159,169,178,187,
	197,208,218,229,240,247,241,230,219,208,197,187,178,172,165,159,
	153,146,139,132,125,119,112,105,99,91,85,78,72,65,58,51,
	102,93,84,75,66,57,52,59,67,76,83,92,100,108,116,124,
	132,141,149,157,165,174,182,191,199,208,216,224,233,241,250,244,
	236,228,222,226,236,244,247,238,229,220,210,201,192,183,174,164,
	155,146,136,128,119,110,101,92,84,75,66,58,49,40,32,24,
	19,23,31,39,47,55,62,70,78,86,94,102,110,118,126,134,
	142,149,158,165,173,181,189,197,204,212,220,228,236,243,251,244,
	236,228,226,231,236,241,246,251,246,241,236,232,227,222,218,213,
	209,205,202,198,195,191,188,185,182,180,177,175,172,170,168,167,
	165,164,163,162,161,161,161,160,160,161,160,161,162,163,164,165,
	167,169,170,172,175,177,179,182,186,193,199,207,214,221,229,236,
	243,251,244,237,233,236,242,247,247,244,240,234,228,222,216,210,
	203,197,191,184,177,170,163,156,149,142,134,127,120,112,104,96,
	88,80,72,64,56,48,39,31,28,33,39,46,52,59,66,72,
	78,85,91,97,104,111,117,123,131,137,143,149,156,163,172,181,
	191,201,212,223,234,245,247,236,225,214,203,192,181,172,166,159,
	153,146,139,132,125,119,112,106,98,92,85,78,71,64,58,51,
	98,89,80,71,62,53,52,60,67,75,83,91,100,108,116,124,
	132,141,149,157,165,174,182,191,199,207,216,224,233,241,250,244,
	237,228,224,232,241,247,242,233,223,213,204,195,185,176,167,158,
	149,139,131,122,112,103,95,86,77,68,60,51,42,33,25,17,
	15,23,31,38,46,54,62,70,78,86,93,102,110,118,125,133,
	141,149,157,165,173,180,188,196,204,212,220,228,236,243,251,245,
	236,231,234,240,246,248,246,242,237,231,226,221,217,212,207,203,
	199,195,191,188,184,181,178,175,172,169,166,164,162,160,157,156,
	154,153,152,151,151,150,149,149,149,149,150,151,151,152,153,154,
	156,157,159,161,164,167,171,176,183,191,198,205,213,221,228,236,
	243,250,245,237,230,228,231,237,243,246,247,244,238,232,225,219,
	212,206,200,193,187,180,172,165,158,151,143,136,128,120,113,105,
	96,88,80,72,64,56,47,39,33,33,39,45,53,59,65,71,
	78,84,91,97,104,110,116,123,130,137,143,150,156,162,168,176,
	186,196,206,217,228,239,247,242,231,220,209,198,187,176,166,159,
	153,146,139,132,126,119,112,105,99,92,85,78,71,64,58,52,
	95,85,76,67,57,49,51,60,68,75,84,92,100,107,116,124,
	132,141,149,158,165,174,182,191,199,207,216,224,233,242,250,244,
	236,228,228,237,246,246,237,227,217,209,198,189,180,170,161,152,
	143,133,124,115,106,97,88,79,70,61,53,44,35,27,18,11,
	15,23,30,38,46,54,62,70,78,85,93,101,109,117,125,133,
	141,148,156,164,173,180,188,196,204,211,219,227,234,242,250,244,
	237,238,243,247,245,242,237,232,227,222,217,211,206,202,197,193,
	189,184,181,177,174,170,167,164,161,158,156,153,150,149,147,145,
	144,142,141,141,140,139,138,138,138,138,138,139,140,141,142,143,
	144,146,148,151,154,160,168,175,183,190,198,204,212,220,228,235,
	242,250,246,238,231,223,223,227,232,238,243,247,247,242,235,229,
	222,216,209,202,196,188,181,174,167,159,152,144,136,129,120,113,
	105,97,89,80,72,63,55,47,38,33,38,45,51,58,65,70,
	77,83,90,97,103,110,117,123,130,136,143,149,156,162,168,175,
	182,189,200,211,221,232,244,248,237,226,215,204,193,182,171,160,
	153,146,139,132,125,119,112,105,98,92,85,79,71,64,58,52,
	90,81,72,63,53,45,51,59,68,75,84,92,99,108,116,124,
	132,141,149,157,165,174,182,190,199,207,216,224,232,242,250,245,
	236,229,234,243,248,241,231,221,212,202,192,183,174,164,155,146,
	137,127,118,109,100,90,81,72,64,55,46,37,28,19,11,7,
	14,22,30,38,45,53,61,69,77,85,93,102,109,117,125,133,
	141,148,156,164,172,180,187,195,203,211,219,227,234,242,250,245,
	242,245,247,245,239,233,228,222,217,212,207,202,196,192,187,183,
	179,175,171,167,163,160,157,153,150,147,145,142,140,138,136,134,
	133,132,130,129,129,128,127,127,127,127,128,128,129,130,131,132,
	134,136,139,145,151,159,167,175,182,190,197,205,212,219,227,234,
	241,249,246,239,231,224,219,218,223,228,234,240,246,248,244,238,
	231,225,218,211,205,197,190,183,175,167,160,153,145,137,129,121,
	113,105,97,88,80,71,63,54,45,38,38,45,51,57,63,70,
	77,83,89,96,103,109,116,123,129,135,142,148,155,162,168,175,
	181,188,195,205,216,227,238,248,243,232,221,209,198,187,175,164,
	154,146,139,132,126,119,112,105,98,91,84,78,72,65,58,51,
	87,77,68,59,50,43,51,59,67,75,84,92,100,108,116,124,
	132,141,149,157,165,174,182,190,199,207,216,224,232,242,250,245,
	237,231,239,248,244,235,225,216,206,196,187,177,168,158,149,140,
	131,121,112,103,93,84,75,66,58,49,40,31,22,13,5,6,
	14,21,30,38,45,53,61,69,77,85,93,101,109,117,126,133,
	141,149,157,164,172,179,187,194,203,211,218,226,234,242,250,246,
	247,247,242,236,230,224,218,213,207,202,197,192,187,181,177,173,
	169,164,160,157,153,150,146,142,140,137,134,131,129,127,125,123,
	121,120,119,118,118,117,116,116,116,116,117,117,118,119,120,122,
	125,130,136,144,152,158,166,174,181,189,196,204,212,219,226,233,
	241,248,247,240,233,225,218,213,213,219,225,231,237,243,248,246,
	240,233,227,219,213,206,198,191,184,177,169,161,153,145,137,129,
	120,113,105,96,87,79,71,62,53,45,38,44,50,57,64,70,
	76,83,89,96,102,109,115,122,128,135,141,147,154,161,168,174,
	181,187,194,201,210,221,232,244,248,237,226,214,204,192,181,170,
	158,148,139,133,126,119,112,105,99,91,85,78,72,65,58,51,
	83,73,64,55,46,43,51,59,67,75,84,92,100,108,116,125,
	133,141,149,157,165,174,183,190,199,207,216,224,232,241,250,245,
	237,235,245,249,239,229,220,210,201,191,181,172,162,153,143,134,
	125,115,106,96,87,78,69,60,52,42,33,24,16,7,0,6,
	14,22,30,39,48,55,63,72,81,89,97,105,113,121,129,137,
	144,152,160,168,175,182,190,198,206,213,220,227,234,241,249,250,
	245,239,232,226,220,214,209,203,198,193,188,182,177,172,167,163,
	159,154,150,146,142,139,136,132,129,126,124,121,118,116,115,112,
	110,109,108,107,106,106,105,105,105,105,105,106,106,108,110,114,
	121,128,135,143,151,158,165,173,180,188,195,203,210,218,225,233,
	240,248,248,241,233,226,218,211,206,209,215,221,228,233,240,247,
	247,242,236,229,222,214,207,200,193,185,177,169,161,153,145,137,
	129,121,112,104,95,86,78,69,61,52,43,43,50,56,63,69,
	76,82,89,96,102,108,115,121,128,134,141,147,154,160,167,173,
	180,186,193,200,207,216,227,238,249,243,232,221,209,198,187,175,
	163,153,141,133,126,119,112,105,98,92,85,78,72,64,58,51,
	79,70,60,51,42,44,51,59,67,75,84,92,99,108,116,124,
	132,141,149,158,165,174,183,190,198,207,216,224,232,241,250,245,
	237,240,248,243,234,224,214,204,195,185,176,166,156,147,138,128,
	119,110,100,91,81,72,64,54,46,36,28,20,12,5,2,11,
	20,28,37,45,54,63,71,79,88,96,104,112,120,128,137,145,
	152,160,168,175,183,190,198,205,212,219,226,234,241,248,251,247,
	239,232,225,219,212,206,199,194,188,183,177,172,167,162,158,153,
	149,144,140,136,132,129,125,122,118,115,113,110,108,106,103,102,
	100,98,97,96,96,95,94,94,94,94,94,95,96,98,104,112,
	120,127,134,142,149,157,165,172,180,187,194,202,209,217,224,231,
	239,247,249,241,234,227,219,212,205,201,206,211,218,225,231,237,
	244,247,244,238,231,223,216,208,201,193,185,177,169,162,153,145,
	137,129,120,112,103,94,85,77,68,59,49,45,49,55,62,68,
	75,82,89,95,101,108,114,121,127,134,141,147,154,160,167,173,
	180,186,193,200,206,214,221,233,243,247,237,226,214,203,191,180,
	169,158,146,134,126,119,112,106,99,92,85,79,71,65,57,51,
	75,66,56,47,39,44,52,60,67,76,84,92,100,108,116,124,
	132,141,149,158,165,174,182,190,199,208,216,224,232,241,250,245,
	238,244,248,238,228,219,208,199,190,180,170,161,151,141,132,122,
	113,104,94,85,76,68,60,52,45,36,28,20,13,4,8,17,
	26,35,44,52,61,70,78,86,94,103,111,119,128,136,144,152,
	160,168,175,183,191,199,206,213,221,228,235,242,247,246,248,247,
	240,232,224,216,208,201,194,187,180,173,168,162,157,152,148,143,
	138,134,130,126,122,118,115,111,108,104,102,100,97,94,92,91,
	89,87,86,85,84,84,83,83,83,83,83,84,90,96,104,111,
	119,126,134,141,149,156,164,171,179,186,194,201,208,216,223,230,
	238,246,250,242,234,227,220,212,205,198,197,202,208,215,222,229,
	235,242,246,245,239,232,224,217,209,201,193,185,177,170,161,153,
	145,136,128,119,110,101,93,84,75,66,57,49,49,55,61,68,
	75,81,88,95,101,107,113,120,127,133,140,147,153,160,166,172,
	180,186,193,199,206,213,220,227,238,249,243,231,220,208,197,186,
	174,162,151,139,129,120,112,106,99,92,85,78,72,65,58,51,
	72,62,53,43,36,43,52,59,68,76,84,92,100,108,116,124,
	132,141,148,158,165,174,182,190,199,208,216,224,233,241,249,245,
	241,249,243,233,223,214,203,194,184,174,165,155,145,136,127,117,
	109,101,92,84,76,68,60,52,44,37,29,20,12,7,14,24,
	32,42,50,59,68,77,85,93,102,110,118,127,135,143,151,159,
	167,175,183,191,199,206,214,221,229,236,243,247,244,242,247,248,
	240,232,225,217,209,202,194,186,179,171,164,157,149,143,138,133,
	128,124,120,115,112,108,104,101,98,94,92,89,86,84,81,79,
	78,76,75,74,73,73,72,72,72,72,75,81,88,95,103,110,
	118,125,133,141,148,155,163,170,178,186,193,200,208,216,222,230,
	238,245,250,243,235,228,221,213,206,198,192,193,199,206,212,219,
	226,233,240,246,246,240,233,226,218,210,202,194,186,178,170,161,
	153,144,135,127,117,109,101,91,82,73,64,55,51,54,61,68,
	74,81,87,94,101,107,113,120,127,133,140,146,152,159,166,172,
	178,186,192,199,206,213,219,222,233,244,247,237,225,213,202,190,
	179,167,156,144,133,122,112,105,99,92,85,79,71,64,58,51,
	69,59,49,40,36,43,52,59,68,76,83,91,100,108,116,124,
	133,141,149,158,165,174,182,191,199,207,216,224,233,241,249,246,
	246,246,238,228,218,208,198,188,179,169,160,150,141,133,125,116,
	108,100,92,84,76,69,61,53,44,36,29,21,13,12,21,30,
	39,48,56,66,74,83,91,100,109,118,126,134,142,151,158,167,
	175,183,190,199,206,214,222,229,236,243,247,245,239,240,247,249,
	241,233,225,218,210,202,195,187,180,172,164,156,149,141,134,127,
	121,115,109,105,102,97,93,90,87,84,81,78,76,73,71,69,
	67,65,64,63,62,62,61,60,62,66,72,80,87,95,102,110,
	117,125,132,139,146,154,162,170,177,185,192,199,206,214,222,229,
	237,244,251,244,237,229,221,215,207,199,192,187,190,197,203,210,
	217,224,232,239,245,246,241,233,226,218,210,201,194,185,177,169,
	160,151,143,134,125,116,108,99,90,81,71,62,54,54,60,67,
	73,80,87,94,100,107,113,119,126,132,139,146,152,159,165,172,
	178,186,192,199,206,212,219,218,228,239,249,241,230,218,207,196,
	184,172,160,149,138,126,115,106,99,91,85,79,72,64,58,51,
	65,55,46,37,36,44,52,60,68,76,84,92,99,108,116,124,
	133,141,148,157,165,174,182,190,199,207,215,224,232,241,249,246,
	250,243,233,223,213,203,194,184,175,166,157,149,141,133,125,117,
	109,101,93,85,77,69,61,53,45,37,29,21,14,18,27,37,
	45,54,63,72,81,90,98,106,115,124,133,141,149,158,166,174,
	182,190,199,206,214,222,230,237,244,247,244,237,233,238,246,249,
	241,234,226,218,210,203,195,188,180,173,165,157,150,142,134,127,
	119,111,104,98,92,87,83,80,76,73,71,68,65,62,61,58,
	56,55,53,53,51,51,49,51,56,64,72,79,86,94,101,109,
	117,124,131,139,146,154,161,169,177,184,191,199,206,214,221,229,
	236,244,251,244,237,230,222,215,207,200,193,185,183,187,194,201,
	208,216,223,230,238,245,248,242,234,226,218,210,202,193,185,176,
	168,159,150,141,132,123,114,105,96,87,77,68,59,56,60,66,
	73,80,86,93,99,106,112,118,125,132,139,145,152,158,165,171,
	178,184,191,198,205,211,218,215,222,234,245,245,235,223,212,200,
	189,177,166,153,142,130,119,107,99,92,85,78,71,65,58,51,
	61,52,43,34,36,44,51,59,67,75,83,91,100,108,116,124,
	132,140,149,157,165,174,182,190,199,207,215,223,232,241,249,248,
	246,237,228,218,208,199,190,181,173,165,157,149,141,133,126,117,
	109,101,93,85,77,69,61,53,46,37,30,22,18,24,33,43,
	51,60,70,78,88,96,105,113,122,131,139,147,157,165,173,181,
	190,197,206,213,222,230,237,245,248,243,236,230,229,237,246,250,
	242,235,226,219,211,204,196,188,181,173,165,158,150,142,136,127,
	120,112,104,97,89,82,74,70,66,63,60,57,55,52,49,47,
	45,44,43,42,41,39,42,48,55,63,70,78,85,92,100,108,
	116,123,130,138,145,152,160,168,176,183,190,198,206,212,220,228,
	235,243,250,246,238,231,224,216,208,201,194,186,179,179,185,193,
	200,207,215,222,230,237,244,250,241,234,226,218,210,200,192,184,
	175,166,158,149,140,131,121,112,103,94,84,75,66,59,60,66,
	72,79,86,91,98,105,112,118,125,132,138,145,151,158,164,171,
	177,184,191,198,204,212,218,214,217,228,241,247,240,228,216,205,
	193,182,170,158,146,135,123,112,100,92,85,78,72,65,57,51,
	58,49,39,30,35,43,51,59,68,75,84,92,100,108,116,124,
	132,140,149,157,165,173,182,190,198,206,215,223,232,241,249,251,
	244,233,224,215,206,197,189,181,173,165,157,149,142,134,126,117,
	109,101,94,86,78,69,62,54,46,38,30,22,22,30,39,49,
	58,67,76,85,94,103,111,120,128,138,146,154,164,172,180,188,
	197,205,213,221,228,237,245,250,243,235,228,224,229,236,245,251,
	243,236,228,220,212,205,197,189,182,174,166,158,151,143,135,128,
	120,113,105,97,90,82,75,67,59,54,50,47,44,41,38,36,
	35,33,32,30,30,33,39,47,54,62,69,77,84,91,99,107,
	115,122,129,137,145,152,159,167,175,182,189,197,204,211,219,227,
	234,241,249,247,239,231,224,217,210,202,195,187,179,175,177,184,
	191,199,206,214,221,229,237,245,249,242,234,226,218,208,200,191,
	182,174,164,156,147,137,128,120,110,101,91,82,73,63,59,65,
	72,78,85,91,98,104,111,118,124,131,137,144,151,158,164,170,
	177,184,191,197,204,211,218,215,214,223,235,246,244,233,221,210,
	198,186,175,163,151,140,128,116,104,93,85,78,72,64,58,51,
	55,46,36,28,36,43,51,59,68,76,84,92,100,108,116,124,
	132,140,148,157,165,173,182,190,198,206,215,223,232,240,249,247,
	239,230,222,214,206,198,189,181,174,165,157,149,141,134,125,117,
	110,102,94,86,78,70,62,54,46,38,31,24,27,36,45,55,
	64,73,81,91,100,109,118,126,135,144,153,161,170,179,187,195,
	204,212,220,229,236,245,249,242,235,227,220,221,229,236,244,251,
	244,236,229,221,213,205,198,190,182,174,167,159,151,144,136,129,
	121,113,106,98,90,83,76,68,60,53,45,39,34,30,28,26,
	24,22,21,21,24,31,38,46,54,61,69,76,84,91,98,107,
	114,121,128,136,143,151,158,166,174,181,188,196,203,211,218,226,
	233,241,248,247,240,232,225,218,210,203,195,188,180,173,168,175,
	183,190,197,205,213,221,229,237,245,247,242,234,225,216,207,199,
	190,181,172,163,154,144,135,126,117,107,98,88,79,69,61,64,
	71,78,84,91,97,104,111,117,123,130,137,143,150,157,163,170,
	176,183,190,197,203,210,217,216,212,218,230,242,246,237,226,214,
	202,190,179,168,156,144,132,120,109,98,86,78,71,64,58,52,
	52,42,33,28,35,43,51,59,68,76,83,91,100,108,116,124,
	132,140,149,157,165,173,181,190,198,207,215,223,232,241,249,247,
	238,230,222,214,206,198,190,182,174,166,158,150,142,134,126,118,
	110,103,95,86,78,70,62,55,47,39,31,27,33,42,51,61,
	70,79,88,98,106,115,125,133,142,151,160,168,177,186,194,203,
	210,219,227,236,244,248,243,236,227,219,214,220,228,236,243,251,
	245,237,229,221,213,206,198,191,183,176,168,160,152,145,137,129,
	121,114,107,100,91,84,76,68,61,54,46,38,31,25,19,15,
	13,12,12,16,22,30,38,45,53,60,68,75,83,90,97,105,
	113,120,128,135,142,150,158,165,173,180,187,195,202,210,218,224,
	232,240,247,248,241,234,226,218,211,204,196,188,181,174,167,166,
	174,181,189,197,205,213,221,229,237,245,246,241,232,224,215,206,
	197,188,180,170,161,152,142,133,124,115,105,95,86,76,66,64,
	70,77,84,90,96,103,110,117,123,130,136,143,150,156,163,169,
	176,183,190,196,203,210,216,215,209,214,225,237,247,242,230,219,
	207,195,183,172,160,148,136,125,113,101,89,79,72,64,58,51,
	49,39,29,28,36,43,52,60,67,75,84,92,99,108,116,124,
	132,140,149,157,165,173,182,190,198,206,215,224,234,243,250,246,
	238,230,222,214,206,198,190,182,174,166,158,151,142,134,126,118,
	110,103,95,87,79,71,63,55,47,39,32,31,38,47,57,66,
	76,85,94,103,112,121,131,140,148,157,167,175,183,192,201,210,
	218,226,234,242,247,243,235,228,219,212,213,220,227,235,242,250,
	246,238,230,222,214,206,199,191,184,176,169,161,153,146,138,130,
	123,115,108,100,92,85,77,69,62,55,47,39,32,24,17,10,
	4,2,6,14,21,29,37,44,52,59,66,74,82,89,96,105,
	112,119,127,134,142,149,156,164,172,179,186,194,201,208,216,224,
	231,239,246,249,242,235,226,219,212,205,197,189,182,175,167,160,
	165,173,181,189,197,205,213,221,229,238,246,247,239,231,222,213,
	204,196,186,177,168,159,149,140,130,120,112,101,92,83,73,65,
	69,76,83,89,96,103,109,116,123,129,136,143,149,156,162,169,
	175,182,189,196,203,210,216,216,209,211,221,232,244,245,235,224,
	212,200,188,176,165,152,140,128,117,105,93,81,72,64,58,51,
	45,36,27,28,35,43,52,60,68,76,84,92,100,108,116,124,
	132,141,149,157,165,173,181,190,198,208,216,228,237,246,251,246,
	238,230,222,215,206,198,190,183,174,166,158,151,143,134,126,119,
	111,103,95,87,79,71,63,55,47,40,33,35,44,53,62,72,
	81,91,100,109,118,127,136,145,155,164,172,181,190,199,207,216,
	225,233,242,246,244,236,228,220,212,206,210,218,226,234,242,249,
	246,238,231,223,215,207,199,192,184,177,169,162,154,147,139,131,
	123,116,108,101,94,86,78,70,63,55,48,41,33,25,17,10,
	4,4,7,13,20,28,36,43,51,58,65,73,81,88,95,103,
	111,118,126,133,141,148,155,163,171,178,185,193,200,208,216,223,
	230,238,245,250,243,236,228,220,213,206,198,190,183,176,168,161,
	159,165,173,180,188,197,205,213,221,230,239,245,246,238,229,221,
	211,202,193,184,174,166,156,146,137,127,118,108,99,88,79,69,
	70,76,82,89,96,102,109,115,122,128,135,142,148,155,161,168,
	174,181,188,195,202,209,216,217,210,208,216,227,239,246,240,227,
	215,204,192,180,168,156,144,132,120,109,97,86,74,65,58,51,
	43,33,23,28,36,43,52,60,68,75,83,91,100,108,116,124,
	132,140,149,156,165,173,181,191,200,211,221,231,241,247,250,247,
	238,231,223,214,206,199,190,183,175,167,159,151,143,135,127,119,
	111,103,95,87,79,71,63,55,48,41,36,40,50,59,68,78,
	87,97,106,115,124,133,142,151,161,170,179,188,196,205,214,223,
	231,240,246,244,238,229,221,213,205,204,210,218,225,233,241,249,
	247,239,232,224,216,208,201,193,186,178,170,162,155,148,140,132,
	124,117,109,102,94,87,79,72,64,56,49,41,33,26,19,13,
	13,15,16,17,22,27,35,42,50,57,65,73,80,87,95,102,
	110,117,125,132,140,147,155,162,170,177,184,192,199,207,214,222,
	229,237,244,251,244,237,228,221,214,207,199,192,184,177,169,162,
	155,157,164,172,180,189,197,206,214,222,231,239,247,246,236,227,
	219,209,200,191,181,172,163,153,143,134,124,114,105,94,85,75,
	71,75,82,88,95,101,108,115,121,128,134,141,148,154,161,168,
	174,181,188,195,202,208,216,217,210,206,211,223,235,246,244,232,
	220,208,196,184,173,161,148,137,125,113,101,90,77,66,58,51,
	39,31,21,28,35,44,52,60,67,75,84,92,100,108,116,124,
	132,140,148,157,165,173,184,194,204,214,225,236,244,247,248,247,
	239,231,223,214,206,199,192,183,174,167,160,151,143,135,127,119,
	111,103,96,87,80,72,64,56,48,41,37,46,55,64,74,83,
	93,102,111,121,130,139,149,158,167,176,185,194,203,211,220,229,
	238,245,246,239,231,223,214,206,200,202,209,217,225,232,240,248,
	247,240,233,225,217,210,202,194,186,178,171,163,156,149,141,133,
	125,117,110,102,95,87,80,72,65,57,50,42,35,27,22,21,
	24,25,28,28,30,32,35,41,49,56,64,71,79,86,94,101,
	109,116,123,131,139,146,154,162,169,176,183,191,198,206,213,221,
	228,236,243,251,245,238,230,222,215,208,200,193,185,178,170,163,
	155,152,156,164,172,181,189,198,206,215,223,232,241,249,243,234,
	226,216,206,197,188,178,169,159,150,140,130,120,111,101,91,81,
	74,75,81,88,94,101,107,114,121,127,134,140,147,154,160,167,
	174,181,187,194,201,208,215,217,211,205,207,219,231,243,246,236,
	224,212,200,188,176,164,152,141,129,117,105,94,81,69,58,51,
	37,27,20,28,35,44,51,60,68,75,84,92,100,108,116,124,
	132,140,148,157,167,177,187,198,208,218,230,240,246,246,247,247,
	239,231,223,215,207,199,191,184,175,167,160,151,143,136,128,120,
	112,104,97,88,80,72,64,57,49,42,41,50,60,70,79,88,
	98,108,117,126,136,145,154,164,173,182,191,200,209,218,227,236,
	244,246,241,233,224,215,207,199,196,201,208,216,224,232,239,247,
	248,241,233,225,218,211,202,194,187,179,172,164,157,150,142,134,
	126,118,111,103,96,88,81,73,65,58,51,43,35,30,30,32,
	34,36,38,39,40,41,42,44,48,55,62,70,78,85,93,100,
	108,115,122,130,138,145,153,161,167,174,182,190,197,204,213,221,
	228,235,242,250,246,239,231,223,216,209,201,193,186,179,171,164,
	157,149,149,156,165,173,182,190,199,208,216,225,234,243,248,241,
	232,223,213,204,195,185,176,166,155,146,136,126,117,107,97,87,
	77,75,80,87,94,100,107,113,120,127,134,140,147,154,160,166,
	173,180,187,194,201,208,214,218,211,204,204,215,226,239,246,240,
	228,216,205,192,181,168,156,145,133,121,109,97,85,73,61,51,
	34,25,20,28,36,44,51,60,67,75,84,92,99,107,115,123,
	132,140,150,159,170,181,191,202,212,223,233,243,247,243,247,248,
	240,231,223,216,208,200,191,183,176,168,160,151,144,136,129,120,
	112,105,97,89,81,74,65,57,49,44,46,56,65,75,85,94,
	104,113,123,132,141,151,160,170,178,188,197,206,215,225,233,242,
	247,243,235,226,217,208,200,193,193,200,208,216,223,231,238,247,
	249,242,234,226,219,211,203,196,188,180,173,165,157,150,143,135,
	127,120,112,104,97,89,82,74,66,59,52,45,38,38,40,43,
	45,47,49,50,52,52,53,54,55,57,62,69,76,84,91,100,
	107,114,121,129,136,144,152,159,166,174,182,189,196,204,212,220,
	227,234,241,249,247,240,232,224,217,210,202,194,187,180,172,165,
	158,150,144,148,157,166,174,183,191,201,209,218,227,236,246,246,
	239,230,220,210,201,192,182,172,162,152,142,132,122,112,102,92,
	82,76,79,86,93,99,106,112,120,126,133,139,146,153,159,166,
	172,180,186,193,200,207,214,218,211,204,201,210,222,235,245,244,
	232,220,208,196,184,172,160,148,136,125,112,101,88,77,64,53,
	32,21,20,27,35,44,51,60,68,75,83,91,99,107,115,123,
	132,142,152,163,173,184,194,206,216,226,236,245,246,241,247,248,
	240,231,224,216,208,200,192,184,176,168,160,152,144,137,129,120,
	113,105,97,88,81,73,66,58,51,43,51,61,70,80,90,99,
	109,118,128,137,147,156,166,175,184,194,203,212,222,231,239,246,
	245,237,228,219,211,202,193,188,192,199,207,215,222,230,237,245,
	250,242,235,227,220,212,204,197,189,181,174,166,159,151,144,136,
	129,120,113,105,98,90,83,75,67,60,53,45,45,48,51,53,
	56,58,59,61,63,64,64,64,65,65,65,69,76,83,91,99,
	105,113,121,128,135,143,151,158,165,172,180,188,195,203,211,218,
	225,232,240,248,248,241,233,226,218,211,203,196,188,181,173,166,
	158,151,143,141,149,158,167,175,184,193,202,211,220,229,239,246,
	244,236,226,217,207,197,187,178,168,158,148,138,128,118,108,97,
	87,79,79,86,92,99,105,112,119,126,132,139,145,152,159,165,
	172,179,186,194,200,207,214,219,212,205,200,206,218,230,242,247,
	236,224,212,200,188,176,164,152,140,127,116,104,92,80,68,57,
	29,19,20,28,36,43,51,60,68,75,83,91,100,107,116,124,
	134,145,156,167,178,188,198,209,220,230,239,248,243,239,247,248,
	240,232,224,216,208,200,192,184,176,168,160,153,145,137,129,121,
	113,105,98,90,82,74,66,58,51,46,56,65,76,85,95,105,
	114,124,134,143,153,162,172,181,190,199,209,218,227,237,245,249,
	240,230,222,213,204,196,188,184,191,199,206,214,221,229,236,244,
	251,243,236,228,221,213,205,198,190,183,175,167,160,152,145,137,
	130,122,114,106,99,91,84,76,68,61,54,53,55,58,61,64,
	66,68,70,72,74,75,75,75,76,75,75,75,77,82,90,97,
	104,112,120,127,135,142,150,157,164,172,179,186,194,202,209,216,
	224,231,240,247,249,242,234,227,219,212,205,197,189,181,174,167,
	159,152,144,138,142,150,160,169,177,186,195,204,214,223,232,242,
	246,242,233,223,213,204,194,184,174,164,154,144,134,123,113,103,
	93,83,78,85,91,98,104,111,118,124,131,138,144,152,158,165,
	171,178,185,192,199,207,213,219,213,205,199,202,214,226,238,246,
	240,228,216,204,191,180,168,155,143,131,119,107,95,83,71,60,
	27,17,20,28,36,44,51,60,67,75,83,92,100,108,117,127,
	138,148,159,170,180,191,202,212,223,233,243,248,240,238,246,248,
	240,232,224,216,208,200,192,184,176,169,161,153,145,137,130,122,
	114,106,98,90,82,74,66,59,52,51,61,70,81,91,100,110,
	119,129,139,149,157,167,177,186,196,205,214,224,233,242,250,242,
	234,225,215,206,197,188,181,182,190,198,205,213,221,229,235,243,
	251,244,236,228,221,214,206,198,191,183,176,168,161,153,145,138,
	131,123,115,108,100,92,85,77,70,63,60,63,66,69,72,74,
	77,79,81,83,84,86,87,86,87,86,87,86,84,85,89,96,
	103,111,119,126,134,141,148,156,163,170,178,185,193,201,208,215,
	223,231,238,246,250,243,235,228,220,213,205,198,190,183,175,168,
	160,152,145,138,137,143,152,161,170,179,189,197,207,216,225,235,
	244,246,239,229,220,210,200,190,180,170,160,149,139,129,119,109,
	99,88,79,84,91,97,104,111,117,124,131,137,144,150,157,164,
	171,178,185,192,199,205,212,219,213,206,199,198,210,223,235,245,
	244,232,220,207,195,183,171,158,146,135,122,111,99,86,74,63,
	23,14,20,28,36,44,52,60,67,75,83,91,100,109,119,130,
	141,152,163,173,184,195,205,215,226,237,247,245,237,238,246,249,
	241,232,225,216,208,200,193,185,177,169,161,154,145,137,130,122,
	114,106,99,91,83,75,67,59,52,56,65,75,86,95,105,115,
	124,134,144,153,163,173,182,191,201,211,219,230,239,248,246,236,
	227,219,209,200,191,182,175,182,189,197,204,212,220,228,235,242,
	250,245,238,230,222,215,207,199,192,184,176,169,162,154,146,139,
	131,123,116,108,101,93,86,78,71,67,69,72,76,79,82,86,
	88,90,92,94,95,97,98,98,98,97,98,97,95,95,94,97,
	103,110,117,125,132,140,147,155,162,170,177,185,192,200,207,214,
	222,229,237,244,251,244,236,229,221,214,206,199,191,184,177,169,
	161,153,146,139,133,136,145,154,163,172,182,191,200,209,219,229,
	239,246,246,236,226,215,206,195,186,175,166,155,145,135,124,114,
	104,93,83,84,90,96,103,110,117,123,130,137,143,150,157,163,
	170,177,184,191,197,205,212,219,214,206,199,195,206,219,231,243,
	248,236,223,210,199,187,175,162,150,138,126,114,102,90,78,67,
	21,13,21,28,36,44,52,60,67,75,83,92,101,112,123,133,
	144,155,166,176,187,198,208,219,230,240,250,242,233,237,246,249,
	241,233,225,217,209,201,193,185,178,170,162,154,145,138,130,123,
	115,107,99,91,83,75,67,60,53,60,69,80,90,100,109,119,
	129,139,149,158,168,178,188,197,207,216,225,235,244,247,240,231,
	222,212,204,194,185,176,174,181,189,196,204,211,219,227,234,242,
	249,246,238,231,223,215,208,200,193,185,177,170,162,154,147,140,
	132,124,117,109,102,94,87,79,74,74,79,83,86,91,93,96,
	99,101,103,105,106,107,108,109,109,108,108,108,106,106,104,103,
	104,109,116,123,131,139,146,153,161,168,176,184,191,198,206,214,
	221,228,236,243,251,246,238,230,222,215,207,200,193,185,178,170,
	162,155,147,140,133,131,138,147,156,165,175,184,194,203,213,222,
	232,242,250,242,231,222,212,201,192,181,171,161,150,140,129,119,
	109,98,88,85,89,96,102,109,116,123,129,136,143,149,156,163,
	169,176,183,190,198,205,212,219,213,206,199,193,202,215,227,240,
	247,239,226,214,201,189,178,166,153,141,129,117,105,93,81,69,
	19,13,20,28,36,44,51,60,68,76,84,93,104,115,126,137,
	148,158,169,179,190,201,211,223,233,244,249,239,229,238,246,249,
	242,233,225,217,209,201,194,186,178,170,162,154,146,138,130,123,
	115,107,100,91,84,76,68,60,57,64,74,84,95,104,114,124,
	134,144,153,163,173,183,192,202,212,222,231,240,247,243,234,225,
	216,207,197,188,179,170,172,179,188,195,203,210,218,226,233,241,
	249,247,239,231,224,216,209,201,194,186,178,171,163,156,149,141,
	133,126,118,111,103,95,88,81,80,84,89,93,96,101,103,107,
	109,112,114,116,117,118,119,119,120,120,119,119,118,117,115,113,
	111,111,114,123,130,137,145,153,160,167,174,182,190,197,204,212,
	219,227,234,242,249,247,239,231,223,216,209,201,194,186,179,171,
	164,156,148,141,133,128,131,141,150,159,168,178,187,197,206,216,
	226,236,246,247,237,227,217,206,196,187,176,166,156,145,135,124,
	114,103,93,86,88,95,102,108,115,122,129,135,142,148,155,162,
	169,176,183,190,197,204,211,218,214,207,200,193,199,212,224,236,
	246,242,229,217,206,193,181,169,156,145,132,120,108,95,83,72,
	16,12,20,28,36,43,51,60,68,76,85,96,107,118,129,140,
	150,161,172,182,193,204,215,226,236,247,246,235,229,237,245,250,
	241,234,226,218,210,202,194,186,178,170,163,155,147,139,131,123,
	115,108,100,92,84,76,69,61,61,69,79,89,99,109,118,128,
	139,149,158,168,178,188,197,207,217,227,236,245,246,239,229,219,
	210,200,191,182,173,168,172,179,186,194,202,210,217,225,233,240,
	248,248,240,233,225,217,210,202,195,187,180,172,164,157,150,142,
	134,127,119,112,104,96,89,86,90,94,99,103,107,111,114,117,
	120,122,125,126,128,129,130,131,131,131,130,130,129,127,125,123,
	121,119,118,122,129,136,144,151,159,166,174,181,188,196,204,211,
	219,226,233,240,248,248,240,232,225,217,210,202,194,187,180,172,
	165,157,149,142,135,127,124,133,143,153,162,171,181,191,200,210,
	220,230,240,249,243,233,223,212,202,192,182,171,161,151,140,129,
	119,108,97,88,87,94,101,108,114,121,128,134,141,148,155,161,
	168,175,182,189,196,204,210,218,214,207,200,193,196,207,221,233,
	244,246,233,221,209,196,184,172,159,147,135,123,111,99,87,75,
	14,12,20,27,36,44,51,60,68,77,88,99,110,120,132,142,
	153,164,174,185,197,208,218,228,239,249,243,232,229,236,245,250,
	242,234,226,218,210,202,194,187,179,171,163,156,148,140,131,124,
	116,108,100,92,85,77,69,62,63,73,83,93,103,113,123,133,
	143,153,163,173,183,192,202,212,222,232,241,247,243,233,223,214,
	205,195,186,176,168,165,171,179,186,193,201,209,216,224,232,239,
	247,249,241,233,226,218,211,203,196,188,181,173,165,158,151,143,
	135,127,119,113,106,97,90,95,100,105,109,114,117,121,125,128,
	131,133,135,137,139,140,141,142,142,142,142,141,140,138,136,134,
	132,129,126,123,128,135,143,150,158,165,172,180,187,195,202,210,
	217,225,232,239,247,248,241,234,226,218,211,203,195,188,181,174,
	166,158,150,143,136,128,121,127,136,146,156,165,175,185,195,204,
	214,224,234,245,246,238,228,218,208,198,187,176,166,156,145,134,
	124,113,102,92,87,93,100,107,113,120,127,133,140,147,154,161,
	167,174,181,189,196,203,210,217,214,208,201,193,192,205,217,229,
	241,248,237,224,212,199,187,175,163,150,139,126,114,102,90,78,
	12,12,20,28,35,44,51,60,69,80,90,101,112,123,134,145,
	155,167,178,188,199,210,220,231,242,248,240,229,229,237,245,250,
	243,235,226,218,211,203,195,187,180,172,163,156,148,140,132,124,
	116,109,101,93,86,77,70,64,66,77,87,97,107,117,127,137,
	148,157,167,177,187,197,207,217,227,236,245,245,237,228,218,209,
	199,190,180,171,163,162,169,177,185,193,200,208,215,223,231,238,
	246,250,242,235,227,219,212,204,197,189,182,174,166,159,152,143,
	136,128,121,114,106,99,99,104,110,115,119,124,127,131,135,138,
	141,144,146,148,150,151,153,153,153,153,153,151,151,149,147,145,
	142,140,137,134,130,134,141,149,156,164,171,179,187,194,201,208,
	216,224,231,239,246,249,242,235,227,220,212,205,197,189,183,175,
	167,159,152,144,137,129,122,122,130,140,149,159,169,178,188,198,
	209,219,229,239,246,244,234,223,213,202,192,182,171,160,149,139,
	128,117,107,96,88,92,99,106,113,120,126,133,140,146,153,160,
	167,174,180,188,196,203,210,217,215,208,201,194,190,201,213,226,
	238,247,240,227,215,202,190,178,165,153,141,129,117,104,92,81,
	10,12,20,28,36,44,51,60,71,82,93,104,115,126,137,147,
	158,169,181,191,202,213,223,234,245,245,237,226,228,237,245,251,
	242,234,227,219,212,203,196,188,180,172,164,156,148,140,133,125,
	117,109,101,93,86,78,70,66,71,81,91,101,111,121,131,142,
	152,162,172,182,192,202,212,221,232,241,246,242,232,223,213,204,
	194,184,175,166,159,161,169,176,184,192,199,207,215,222,230,238,
	245,251,244,235,227,220,212,206,198,190,183,175,167,160,153,145,
	137,129,122,115,107,105,109,114,119,124,129,134,138,141,145,149,
	152,155,157,159,161,162,163,164,164,164,164,163,161,160,158,156,
	153,150,147,144,140,138,141,147,155,162,170,178,185,193,200,207,
	215,222,230,238,245,251,243,235,228,221,213,205,198,191,184,176,
	168,160,153,145,138,130,122,119,123,133,143,152,162,173,183,193,
	203,213,223,233,244,248,239,228,217,207,197,186,176,165,154,143,
	133,122,111,100,90,92,99,105,112,118,125,132,139,146,152,159,
	166,173,180,187,195,202,209,216,215,208,201,194,188,197,210,222,
	236,246,243,230,218,205,193,181,168,156,144,131,119,107,94,83,
	7,12,20,28,36,43,52,62,73,84,95,106,117,129,140,151,
	161,172,183,194,205,216,227,237,248,244,234,224,227,236,244,251,
	243,235,227,219,212,203,196,188,180,172,165,157,149,141,133,126,
	117,110,102,94,86,79,71,68,74,85,95,105,115,125,135,146,
	155,166,176,186,196,206,216,226,236,245,247,238,228,218,208,199,
	189,179,170,161,155,161,168,176,183,191,198,206,214,221,229,236,
	244,251,244,236,229,221,213,206,199,191,184,176,169,161,154,146,
	138,131,123,116,111,112,118,124,129,134,139,144,148,152,156,159,
	162,165,168,170,172,173,174,174,175,176,175,173,173,171,169,167,
	164,161,158,154,150,147,144,147,154,161,169,176,184,191,198,206,
	213,221,229,237,244,251,244,236,229,222,215,206,199,192,185,177,
	169,162,154,147,139,131,124,117,118,127,137,146,157,167,177,187,
	197,208,218,228,238,247,244,233,223,212,202,191,180,169,159,148,
	138,126,116,105,93,92,98,104,111,117,124,131,138,144,151,159,
	165,172,179,187,194,201,208,216,216,209,202,194,188,195,207,220,
	232,244,245,233,220,208,196,183,171,158,146,134,122,110,97,85,
	6,12,20,28,36,43,53,65,76,87,97,109,120,131,142,152,
	164,175,185,196,208,218,229,240,247,242,231,222,227,235,243,251,
	243,235,228,220,212,204,196,188,180,173,165,157,150,141,134,126,
	118,110,103,95,87,79,72,69,78,88,98,108,119,129,139,150,
	159,170,180,190,200,210,221,231,240,247,243,233,223,213,203,194,
	184,174,165,156,152,159,167,175,183,190,198,205,212,220,228,235,
	243,251,245,237,230,222,215,207,200,192,185,177,170,162,155,147,
	140,132,124,118,116,121,128,133,138,143,149,154,158,162,166,169,
	173,176,178,180,183,184,184,185,186,186,186,185,183,182,180,177,
	175,172,168,165,161,157,152,149,153,161,168,175,183,190,197,205,
	213,220,228,235,242,250,246,238,231,223,215,208,200,193,186,178,
	171,163,156,148,140,133,126,118,114,122,131,142,152,162,172,182,
	192,202,213,223,234,244,249,237,228,217,206,196,184,174,163,152,
	142,131,120,109,98,92,97,104,110,117,124,131,137,144,150,158,
	165,171,179,186,193,201,208,215,216,209,202,195,187,192,204,217,
	230,242,248,236,223,211,198,186,173,161,149,136,124,112,100,88,
	5,13,20,28,36,44,56,67,78,89,101,111,122,133,145,155,
	167,178,188,199,210,221,232,242,246,239,228,223,227,235,243,251,
	244,235,228,220,212,205,197,190,182,173,165,157,150,141,134,127,
	119,111,103,95,88,80,72,71,81,91,102,112,123,133,143,154,
	164,174,183,194,204,214,224,235,244,249,239,228,219,208,198,189,
	180,169,160,150,151,158,166,174,182,189,197,204,211,219,226,234,
	242,250,246,239,231,223,216,209,201,193,185,178,171,163,155,148,
	141,133,125,121,124,130,136,143,147,153,158,164,168,172,176,180,
	184,186,189,191,193,195,196,197,197,197,197,196,194,192,191,189,
	186,183,179,175,172,167,162,157,154,160,166,174,182,189,196,204,
	212,219,226,234,241,249,247,239,232,224,217,209,202,194,187,179,
	172,164,157,149,142,134,127,119,113,116,125,136,147,156,167,177,
	187,197,208,218,228,239,249,243,232,222,210,200,189,179,167,156,
	146,135,124,113,102,94,96,103,110,116,123,130,137,144,150,157,
	164,171,179,185,193,200,208,215,217,210,202,195,188,190,201,214,
	227,240,249,238,226,213,201,189,176,164,151,139,127,114,102,90,
	5,12,20,28,36,46,58,69,80,91,103,113,125,135,147,158,
	169,180,191,202,212,223,234,245,245,237,226,221,227,235,243,251,
	244,236,229,220,213,204,197,190,181,174,166,159,151,142,135,127,
	119,112,104,96,88,81,74,74,84,95,106,116,127,137,147,157,
	167,177,188,198,208,218,228,239,247,244,235,224,215,204,194,184,
	174,165,155,146,150,157,165,173,180,188,196,203,210,218,226,234,
	241,248,247,240,232,224,217,209,202,195,187,179,172,164,157,149,
	142,134,127,125,132,139,145,152,157,163,168,173,178,182,186,190,
	194,197,199,202,204,205,207,208,208,208,208,207,205,203,202,200,
	197,193,190,186,181,176,173,167,161,160,165,173,181,188,195,202,
	210,218,225,232,240,248,248,240,233,226,218,210,203,195,188,180,
	173,165,158,151,143,135,128,120,113,111,120,131,141,151,161,172,
	182,192,203,213,224,234,245,245,237,226,215,204,194,183,172,161,
	150,139,128,117,106,95,95,102,109,116,123,129,136,143,149,156,
	163,170,177,185,192,199,207,215,217,210,203,195,189,189,198,211,
	224,237,248,241,229,216,204,191,179,166,154,141,129,117,105,92,
	5,12,20,28,37,49,60,71,82,93,105,116,127,138,149,160,
	171,182,193,204,214,225,236,247,245,234,223,221,227,235,242,250,
	244,237,229,221,214,206,198,191,182,174,166,159,151,143,135,128,
	120,112,104,97,89,81,75,78,88,99,109,120,130,140,150,160,
	171,181,192,202,213,222,233,243,249,239,230,220,210,200,190,180,
	170,160,150,144,149,157,164,172,180,187,195,202,209,218,225,233,
	240,247,248,241,233,225,218,210,203,195,188,180,173,165,158,150,
	143,135,130,134,141,148,154,160,166,172,178,183,188,192,196,200,
	204,207,210,213,215,217,218,218,218,219,219,218,217,215,212,211,
	207,204,201,196,192,187,182,176,171,166,166,171,178,187,194,201,
	209,217,224,231,239,247,249,242,234,227,220,212,204,196,189,182,
	174,167,159,152,144,136,128,121,114,108,115,125,136,145,156,166,
	177,187,198,209,219,230,241,246,241,230,219,208,197,186,176,165,
	154,143,132,121,109,98,95,101,108,115,122,128,135,142,149,155,
	163,170,177,184,191,199,207,214,218,210,203,196,189,187,196,209,
	221,234,246,244,231,219,206,194,181,168,156,143,131,119,107,95,
	5,12,20,29,39,51,62,73,84,96,107,118,129,140,151,162,
	173,184,195,206,216,228,239,246,243,232,221,220,226,234,242,250,
	245,237,229,221,213,205,197,191,182,174,167,159,151,144,136,128,
	121,113,105,97,89,82,74,80,92,102,112,123,133,143,154,165,
	174,185,195,206,216,226,236,247,245,236,226,216,206,196,186,176,
	165,155,145,143,148,156,164,171,179,186,194,201,208,216,224,231,
	239,246,249,242,234,227,219,212,204,196,189,181,174,166,159,151,
	144,137,136,142,150,156,163,169,175,181,187,192,197,202,206,211,
	214,218,221,223,225,227,229,230,230,230,230,228,227,226,224,221,
	218,214,211,207,202,196,192,186,181,175,169,170,178,185,193,200,
	207,215,223,230,237,245,251,244,235,228,220,214,205,198,190,183,
	176,168,160,152,145,138,130,122,114,107,111,120,130,141,151,162,
	172,183,194,204,215,225,236,246,245,234,224,213,202,191,180,169,
	157,146,135,125,113,102,96,100,107,114,121,127,134,141,148,155,
	162,169,176,184,191,198,206,213,219,211,204,197,189,185,193,206,
	219,231,244,246,233,220,208,196,183,171,158,146,133,121,109,97,
	5,12,20,30,41,53,64,75,86,98,109,120,131,142,153,164,
	175,186,197,208,219,230,241,246,240,230,219,219,225,234,242,250,
	245,237,229,222,215,207,199,191,183,175,167,160,152,144,136,128,
	121,113,106,98,90,82,75,84,94,105,115,126,136,147,157,167,
	178,188,199,209,219,229,240,248,243,232,222,212,202,192,182,172,
	161,151,142,140,147,155,163,170,178,185,193,200,208,215,223,231,
	238,245,250,242,235,228,220,212,204,198,190,183,174,167,160,152,
	145,140,143,150,158,164,171,178,184,190,196,201,207,212,217,221,
	225,229,231,234,237,238,240,240,242,241,241,239,238,236,234,231,
	229,225,221,217,212,207,201,196,190,184,177,173,177,184,191,199,
	206,214,221,229,237,244,251,244,236,229,222,214,207,199,191,184,
	177,169,161,153,146,139,132,124,116,108,107,115,126,136,146,157,
	168,178,189,200,211,221,232,243,248,239,227,217,206,195,184,173,
	162,150,139,128,117,106,97,99,106,113,120,127,133,140,147,154,
	161,168,176,183,190,198,206,213,220,212,204,197,189,184,190,204,
	216,229,242,248,236,224,211,198,185,172,160,148,135,123,111,99,
	5,13,21,32,43,54,66,77,89,100,111,122,132,144,155,167,
	177,188,199,210,221,232,243,246,238,228,217,217,225,233,241,249,
	246,238,230,222,214,206,199,191,183,176,168,160,152,145,137,129,
	121,114,107,99,91,83,79,87,97,108,118,128,140,150,160,171,
	181,191,202,212,223,233,244,246,239,228,218,208,198,188,178,168,
	158,147,139,139,146,153,161,169,177,184,192,199,207,214,222,230,
	237,245,251,243,236,229,222,214,206,199,191,184,176,169,161,154,
	146,145,151,158,166,173,180,187,193,200,206,211,216,222,227,231,
	235,239,242,244,245,246,247,248,250,250,248,246,247,247,245,243,
	239,235,231,227,222,217,211,206,199,193,186,180,175,182,190,198,
	205,213,220,228,235,242,250,245,237,230,223,216,208,201,193,186,
	178,170,162,155,147,140,132,125,117,110,105,110,120,132,142,152,
	163,174,184,195,206,217,228,239,247,243,231,220,209,198,188,176,
	165,154,143,132,121,109,99,98,105,112,119,126,133,139,146,153,
	160,167,174,182,190,197,204,212,219,212,204,197,190,183,188,201,
	215,226,240,250,238,225,213,200,187,175,162,150,137,125,112,101,
	5,12,23,33,45,56,68,79,90,101,112,124,134,146,157,168,
	179,190,201,212,223,234,245,246,236,225,216,217,225,233,242,249,
	246,239,230,223,215,207,199,192,184,176,169,161,153,145,138,130,
	123,114,106,99,92,84,82,90,100,111,121,132,142,153,163,174,
	184,195,205,216,226,237,246,245,236,225,215,204,194,184,174,164,
	153,143,136,138,145,153,160,168,176,183,191,198,206,213,221,228,
	236,244,251,244,238,230,223,215,207,200,192,185,178,170,162,155,
	149,151,159,166,173,181,188,195,202,208,215,221,226,231,237,241,
	246,249,251,248,245,243,242,241,240,240,240,241,243,244,246,248,
	248,245,242,237,232,226,220,215,209,201,195,188,181,181,189,196,
	204,211,219,226,233,241,249,247,239,232,224,216,209,202,194,186,
	179,172,164,156,148,141,133,126,118,111,104,105,116,127,138,148,
	159,169,180,191,202,213,224,234,246,246,234,224,213,202,191,179,
	168,157,146,136,124,112,101,98,105,112,119,125,132,139,146,153,
	160,167,174,181,189,197,204,211,219,212,205,197,190,183,186,199,
	212,224,237,250,240,227,215,202,189,177,164,151,139,127,114,103,
	5,13,24,35,47,58,69,81,92,103,114,125,136,148,159,170,
	181,192,203,214,225,236,245,245,234,224,216,217,225,233,241,249,
	246,239,231,223,216,208,200,192,185,177,169,161,154,146,138,130,
	123,115,107,100,92,84,84,92,103,113,124,135,145,155,166,177,
	187,198,208,219,229,240,246,243,232,222,211,201,190,180,170,160,
	150,140,133,137,145,152,159,167,175,182,190,197,205,212,220,227,
	234,242,250,246,239,231,224,216,209,201,193,186,179,171,163,156,
	153,158,166,174,181,189,196,203,211,217,223,229,236,241,245,246,
	246,243,240,237,235,233,231,229,229,228,229,230,232,234,237,240,
	243,247,247,246,242,236,230,224,217,210,203,196,188,184,188,194,
	202,210,217,225,233,240,247,248,241,233,226,218,210,203,195,188,
	180,173,165,157,150,143,135,127,119,112,105,101,112,122,133,144,
	154,166,176,187,198,209,220,231,242,248,239,228,217,206,194,183,
	172,160,149,138,127,115,104,98,104,111,117,124,131,138,144,152,
	159,166,173,180,189,196,204,211,218,214,206,198,191,183,184,197,
	209,222,235,248,242,229,216,204,191,179,166,154,141,129,116,104,
	5,14,26,37,48,60,71,83,94,104,115,127,138,149,160,171,
	183,194,205,216,227,238,246,243,232,222,214,216,224,232,240,248,
	247,239,231,224,216,208,200,193,186,178,170,162,154,146,139,131,
	124,116,108,101,93,85,85,94,105,116,126,137,148,158,169,179,
	190,200,211,221,232,243,248,239,229,218,208,198,187,177,167,157,
	147,136,129,136,144,150,158,166,174,181,188,196,203,211,219,226,
	234,241,249,247,239,232,224,217,209,202,194,187,180,172,165,158,
	157,164,173,181,189,197,204,211,219,226,232,239,245,247,247,242,
	238,234,230,226,224,222,220,219,218,218,218,219,221,223,226,229,
	232,236,241,246,247,245,239,233,227,220,212,205,197,189,188,194,
	201,209,216,224,231,239,247,249,242,234,227,219,211,204,197,189,
	182,174,166,159,152,144,136,128,121,113,106,99,107,118,128,140,
	151,162,172,183,195,206,216,227,239,248,242,231,220,209,197,186,
	175,163,152,141,130,119,107,100,103,110,117,123,130,137,144,151,
	158,165,173,180,187,195,202,211,218,214,206,198,191,184,183,194,
	207,220,233,246,243,231,219,206,193,181,168,155,143,130,118,105,
	5,16,27,38,49,60,72,84,95,105,117,128,140,150,161,173,
	184,195,206,217,228,239,246,241,231,220,213,216,224,232,240,248,
	248,240,232,224,217,209,201,193,186,178,170,163,155,147,139,132,
	124,116,109,101,93,86,87,97,108,118,129,139,150,161,171,182,
	192,203,214,224,235,244,247,236,226,215,205,195,185,173,164,153,
	143,132,129,135,142,149,157,165,173,180,187,195,203,210,217,225,
	233,241,248,248,240,233,226,218,210,203,196,188,181,173,166,159,
	163,171,180,189,197,205,212,220,227,234,241,247,248,243,238,232,
	228,223,219,216,213,211,209,208,207,207,207,208,210,212,215,218,
	222,227,231,236,242,246,246,242,236,228,221,213,205,197,191,192,
	200,208,215,222,230,238,245,251,243,236,228,220,213,206,198,190,
	183,175,167,160,152,145,137,130,122,114,107,99,104,114,125,136,
	146,158,169,180,191,202,213,224,235,246,245,234,223,212,201,189,
	178,167,155,144,133,122,110,101,102,109,116,123,129,136,143,150,
	157,164,172,180,188,195,202,210,217,214,207,199,192,185,182,192,
	206,218,232,244,246,233,220,207,195,182,170,157,144,132,120,107,
	7,17,28,40,51,62,73,85,95,107,119,130,142,152,164,175,
	186,197,208,219,230,241,248,240,229,218,212,215,224,231,239,248,
	248,240,232,225,217,209,202,194,186,178,170,163,155,148,140,132,
	125,117,109,101,94,88,89,99,110,121,132,142,152,163,174,184,
	195,206,216,227,238,246,244,234,223,213,203,191,181,171,161,150,
	140,129,128,134,141,148,156,164,172,179,186,194,202,209,216,224,
	231,239,246,249,241,234,227,220,212,205,197,189,182,175,167,162,
	170,178,187,195,203,211,220,228,235,242,247,246,240,234,228,223,
	218,213,209,205,202,200,198,197,196,195,195,197,199,201,204,208,
	212,216,221,227,232,239,244,247,244,237,229,221,213,205,196,191,
	199,206,214,221,229,236,243,251,244,237,229,222,214,206,199,191,
	184,176,169,161,153,146,138,131,123,116,108,100,101,110,121,132,
	143,154,165,176,187,198,210,221,231,243,246,238,226,215,203,192,
	181,169,158,147,135,124,113,103,102,108,115,122,129,136,142,149,
	157,164,171,178,187,194,202,209,217,214,207,200,192,184,181,191,
	204,217,230,243,247,234,222,209,196,184,171,159,146,133,121,109,
	8,18,29,41,52,63,75,86,97,109,120,131,143,154,165,176,
	187,199,209,221,232,243,248,238,227,217,211,216,223,231,239,247,
	248,241,233,225,217,210,202,194,187,179,171,163,156,149,141,133,
	125,117,110,102,94,89,90,101,112,123,133,144,155,166,176,187,
	198,208,219,229,240,249,242,231,221,210,200,189,178,168,157,147,
	136,125,126,133,141,148,156,163,170,178,186,193,201,208,215,223,
	231,238,245,250,242,235,228,220,213,206,198,190,183,176,168,168,
	175,184,193,202,210,219,227,235,243,247,244,238,232,226,219,213,
	208,202,199,194,192,188,187,186,185,185,186,187,188,191,194,197,
	201,206,211,217,223,230,236,243,248,245,237,229,220,212,203,195,
	197,205,212,220,228,234,243,250,246,238,231,223,215,208,201,193,
	185,178,170,162,155,147,139,132,124,117,109,101,99,107,118,128,
	140,151,162,173,184,195,206,217,228,240,246,240,229,218,207,195,
	183,172,161,150,138,127,116,104,101,108,114,121,128,135,142,148,
	156,163,170,178,185,193,201,209,217,216,208,200,192,185,180,189,
	201,215,228,241,248,237,224,210,198,185,172,160,147,135,122,110,
	8,20,30,42,54,65,76,87,98,110,121,132,143,155,166,177,
	189,200,211,221,233,244,248,237,226,215,209,215,223,231,239,246,
	249,242,233,225,218,210,203,195,187,179,172,164,156,149,141,133,
	125,118,111,103,95,89,92,104,114,125,135,147,157,168,178,189,
	200,210,221,232,242,248,239,229,218,208,197,186,176,165,155,144,
	133,124,124,132,140,147,154,162,169,177,184,192,200,207,215,222,
	229,237,245,251,244,237,229,221,214,206,199,192,185,177,170,172,
	181,190,199,208,217,225,234,242,247,245,238,230,222,217,210,204,
	198,193,188,185,181,178,176,175,174,174,174,176,177,180,183,187,
	191,196,202,208,214,221,228,235,242,250,245,236,228,219,210,201,
	198,203,211,219,226,234,241,248,247,240,232,224,217,209,202,194,
	186,179,171,164,156,149,141,133,126,118,111,103,98,103,114,125,
	136,147,159,169,181,192,204,214,226,237,246,243,232,220,209,198,
	186,175,164,152,140,129,118,106,100,107,113,120,127,134,141,148,
	155,162,170,178,185,193,201,208,216,216,208,200,193,185,180,187,
	200,213,226,239,249,238,226,212,199,186,173,161,149,136,123,112,
	10,21,32,43,55,66,77,89,99,112,123,134,145,156,167,179,
	190,201,211,223,234,245,247,236,225,214,207,215,223,230,238,246,
	249,241,234,226,218,210,203,196,188,180,172,165,158,149,142,134,
	126,119,111,104,96,90,95,106,116,127,138,149,159,169,180,191,
	202,213,223,234,245,245,236,226,215,205,195,184,174,163,152,142,
	131,123,123,131,139,146,153,161,169,176,183,191,199,206,213,221,
	227,235,243,251,245,238,230,222,215,207,200,193,185,178,173,177,
	187,196,205,215,224,232,240,247,245,237,230,222,214,207,200,195,
	189,184,179,175,171,168,166,164,163,163,163,165,167,170,173,177,
	181,187,192,198,205,212,219,226,234,243,248,243,235,225,217,208,
	200,202,209,217,225,232,239,247,248,241,233,226,218,211,203,195,
	188,180,172,165,157,149,142,135,127,119,112,104,97,99,110,121,
	133,144,155,167,177,189,201,211,222,234,246,246,234,223,212,200,
	189,178,167,155,143,132,121,109,100,106,112,120,127,133,140,147,
	154,162,169,177,184,192,200,208,216,216,209,201,193,185,179,185,
	198,212,225,238,250,238,226,213,201,188,175,162,150,137,124,113,
	11,21,33,44,56,67,78,90,101,113,124,135,146,157,168,180,
	191,201,213,224,235,245,246,235,224,213,207,214,222,230,237,246,
	250,242,234,226,219,211,203,196,189,181,173,165,158,150,142,135,
	127,119,112,104,97,90,97,107,119,129,140,150,161,172,182,193,
	204,215,226,237,247,244,234,224,213,203,192,182,171,160,149,139,
	129,121,123,130,138,145,153,160,168,175,182,190,197,205,212,220,
	227,234,242,250,246,239,231,223,216,209,201,194,187,179,176,183,
	193,202,211,220,230,239,247,246,238,230,222,213,206,199,192,186,
	180,174,169,164,160,157,155,153,152,152,152,153,155,159,162,166,
	171,177,182,189,195,203,211,218,227,235,243,247,242,232,223,214,
	204,201,208,216,223,230,238,246,249,242,235,227,219,212,204,197,
	189,182,174,166,158,150,144,136,128,120,113,105,98,97,108,118,
	130,141,152,164,175,187,198,209,220,231,243,247,237,226,215,203,
	192,180,168,157,145,134,123,110,100,105,111,119,126,133,139,146,
	153,161,168,176,183,191,199,207,215,217,209,202,194,186,179,184,
	197,210,223,237,250,241,228,215,201,189,176,163,151,138,126,113,
	12,22,34,45,57,68,79,91,102,114,125,136,147,158,170,180,
	192,203,214,225,237,247,245,234,222,212,206,214,222,229,237,245,
	250,242,235,227,219,211,204,197,189,181,174,166,159,151,143,135,
	128,120,113,105,98,90,99,109,120,131,142,152,162,173,184,195,
	206,217,227,238,247,243,233,222,211,201,190,179,169,158,147,137,
	126,119,122,129,137,144,152,159,166,174,182,189,196,204,211,219,
	226,233,242,249,247,239,232,225,217,210,203,195,188,181,178,188,
	198,207,217,226,236,244,247,240,231,223,215,206,198,191,184,177,
	171,165,159,155,150,147,144,142,141,141,141,143,144,148,152,156,
	161,167,173,180,187,195,202,210,219,227,236,245,246,239,229,219,
	210,204,207,215,222,230,237,244,251,243,236,228,220,213,206,198,
	190,183,175,167,160,152,144,137,129,121,114,106,99,97,105,116,
	127,138,150,161,172,184,195,206,218,229,241,247,239,228,217,205,
	194,182,170,159,147,136,125,112,101,104,111,118,125,132,139,145,
	153,160,167,174,182,190,199,206,215,217,209,202,194,186,179,183,
	196,209,222,236,248,241,229,216,203,190,177,165,152,140,127,114,
	12,23,35,46,57,69,80,92,103,115,125,136,148,159,170,181,
	193,204,215,226,237,247,244,233,221,211,206,213,221,229,237,244,
	251,243,236,228,220,212,205,197,189,182,174,167,160,152,144,137,
	129,121,113,106,99,92,99,110,121,132,143,154,164,175,186,197,
	208,218,229,240,246,242,231,220,209,199,188,177,167,156,145,135,
	124,115,120,128,135,143,151,158,165,173,180,188,195,202,210,218,
	225,232,240,248,249,241,233,226,218,211,204,196,189,182,182,193,
	202,212,222,232,241,247,243,234,225,216,208,199,191,183,176,169,
	162,155,150,145,140,137,132,131,130,130,131,132,135,137,141,146,
	152,158,165,172,179,187,194,203,212,221,230,239,246,245,235,226,
	215,207,206,213,221,228,236,244,251,244,237,229,222,215,207,199,
	191,184,177,169,161,154,146,138,130,123,115,108,100,96,102,114,
	125,136,147,159,170,181,193,204,215,226,238,246,242,230,219,208,
	196,184,173,161,149,138,126,115,103,104,110,117,124,131,138,144,
	152,159,166,174,182,190,198,206,214,218,210,202,194,187,180,182,
	195,208,221,234,247,243,230,217,204,191,178,166,153,140,128,115,
	14,24,35,47,58,70,81,92,104,115,126,137,149,160,172,183,
	193,205,216,227,238,248,242,232,221,210,205,213,221,229,237,244,
	251,243,236,228,220,213,205,198,190,182,175,167,159,151,144,137,
	129,122,114,106,99,94,101,111,122,133,144,155,166,176,187,198,
	209,220,230,241,247,240,229,218,208,197,186,176,165,154,143,133,
	122,113,120,127,135,142,149,157,164,172,179,187,194,202,209,216,
	224,231,239,247,249,242,234,227,220,212,205,198,190,183,186,197,
	207,216,227,236,245,246,238,228,219,210,201,192,184,176,167,160,
	153,146,140,135,130,126,122,120,119,119,119,121,124,127,132,137,
	142,149,156,163,170,179,187,196,205,214,224,233,242,249,241,231,
	221,210,205,212,219,226,235,242,250,246,238,230,223,216,208,200,
	193,185,178,170,163,155,147,140,132,124,116,109,101,96,99,111,
	122,133,145,156,167,179,190,202,213,224,236,246,244,233,221,209,
	198,186,174,163,152,140,128,116,105,103,109,116,123,130,137,143,
	150,158,166,173,182,190,197,205,213,218,211,203,195,187,179,180,
	194,207,220,233,246,243,230,217,205,192,179,166,153,141,129,116,
	14,25,36,48,59,70,81,93,105,116,127,138,149,161,173,183,
	194,205,217,227,239,250,242,231,220,208,205,213,220,228,236,244,
	251,245,237,229,221,213,205,198,191,183,175,168,161,153,145,137,
	130,123,115,107,100,96,102,113,124,135,146,156,167,178,189,200,
	210,222,232,242,248,238,228,216,206,195,184,174,163,152,142,131,
	120,113,119,126,133,141,148,156,163,171,178,185,193,200,208,215,
	223,230,237,245,251,243,235,229,221,213,206,199,191,185,190,200,
	210,220,231,241,246,242,233,223,214,204,195,186,177,168,160,153,
	145,137,131,125,120,116,112,109,108,108,109,110,113,116,121,127,
	133,140,147,155,163,172,180,189,199,208,217,227,237,247,245,236,
	225,215,207,210,218,225,233,241,248,247,239,232,224,217,210,202,
	194,187,179,171,164,156,148,140,133,126,118,110,102,96,97,109,
	120,131,143,154,165,177,188,200,212,223,234,244,246,234,223,211,
	199,187,176,164,153,141,129,118,107,103,109,115,122,129,136,143,
	150,158,165,172,181,189,197,204,212,219,211,203,196,187,179,179,
	193,206,219,232,245,243,231,219,206,193,180,167,154,142,129,117,
	15,26,37,48,60,71,83,94,106,117,127,139,150,162,173,184,
	195,206,217,228,240,251,241,230,219,208,206,213,220,228,236,244,
	251,244,237,229,222,214,206,198,191,183,176,168,161,153,146,138,
	130,123,115,108,101,97,103,114,125,136,147,157,168,179,190,201,
	212,223,233,243,248,237,226,216,205,194,183,173,161,150,140,129,
	118,113,118,125,132,140,147,155,163,170,177,185,192,199,207,214,
	222,229,236,244,251,244,237,230,222,215,208,200,192,188,193,204,
	214,224,235,244,247,238,227,218,208,199,189,180,171,162,153,145,
	137,129,122,116,110,106,102,99,97,97,97,99,103,106,111,118,
	124,131,139,147,155,164,173,183,192,202,212,222,232,242,247,240,
	230,220,210,209,217,224,232,239,247,249,241,233,226,218,211,203,
	195,188,180,172,165,157,149,142,134,126,119,111,104,97,95,106,
	117,129,140,152,164,175,186,197,210,221,233,243,247,235,224,213,
	201,189,177,165,154,143,131,119,108,103,108,115,122,128,135,142,
	150,157,164,172,180,188,196,203,211,219,211,204,196,189,180,179,
	192,206,218,231,244,244,233,220,206,194,181,168,155,142,130,117,
	15,26,37,49,60,72,83,94,105,117,128,139,150,162,173,184,
	196,206,218,229,240,251,240,230,218,207,206,212,220,228,236,243,
	250,245,238,230,222,215,207,199,191,184,177,169,161,153,146,139,
	131,124,116,108,101,98,104,115,126,137,147,158,169,180,191,202,
	213,224,234,245,247,236,226,215,204,193,182,171,160,150,139,128,
	117,113,117,124,131,139,147,154,162,168,176,184,191,198,206,213,
	220,228,235,242,250,245,238,231,224,217,209,201,194,191,197,207,
	217,228,238,247,244,234,224,214,203,194,184,175,165,156,146,138,
	130,121,114,107,101,95,91,88,86,86,86,89,92,96,102,109,
	115,123,131,139,149,158,167,177,187,197,207,216,227,238,246,245,
	234,223,213,209,216,223,230,238,246,250,242,235,227,219,212,204,
	197,189,181,173,166,158,151,143,135,129,120,113,105,98,94,104,
	116,127,139,150,161,173,184,196,208,219,231,242,249,237,226,214,
	202,191,179,168,155,144,133,121,109,102,107,114,121,127,135,141,
	148,156,164,172,180,187,195,203,212,219,212,205,196,188,181,179,
	191,204,218,230,244,244,233,221,207,194,182,169,155,143,131,118,
	16,26,37,49,60,71,83,94,105,117,129,140,151,162,173,185,
	196,207,219,230,241,250,240,230,218,207,205,211,219,227,235,242,
	250,245,238,230,222,215,207,199,192,185,177,170,162,154,147,139,
	132,124,117,109,101,98,104,115,126,138,148,159,171,181,192,203,
	213,224,235,246,245,235,225,213,203,192,181,170,159,149,138,127,
	116,111,115,123,130,138,145,153,160,167,174,183,190,197,204,213,
	219,226,234,241,249,246,239,232,224,217,210,202,195,192,200,210,
	221,232,242,250,241,230,220,209,199,189,179,170,160,150,140,132,
	123,114,106,98,92,86,81,78,75,75,75,78,81,86,92,99,
	107,115,124,133,142,151,161,171,181,191,202,213,223,233,244,248,
	238,227,215,208,214,221,229,237,244,251,244,236,229,221,213,205,
	198,190,183,175,167,160,153,145,137,130,121,114,106,98,94,102,
	114,125,137,148,160,172,183,195,206,218,229,241,249,239,227,215,
	204,193,180,168,157,146,133,122,111,101,106,113,120,127,134,140,
	147,155,163,171,179,187,195,203,211,219,212,205,196,189,181,179,
	191,204,217,230,243,245,234,221,208,195,181,169,156,143,131,118,
	16,26,38,49,60,72,84,94,105,118,129,140,151,163,174,185,
	196,208,219,230,241,249,240,229,217,207,205,211,220,227,234,241,
	249,246,238,230,223,216,208,200,192,185,178,170,163,155,147,140,
	132,125,117,110,102,99,105,116,127,138,148,160,171,182,193,203,
	214,226,236,247,244,234,223,213,202,191,180,169,158,148,137,126,
	115,109,115,122,129,137,144,152,160,167,174,181,189,196,204,211,
	219,226,233,240,248,248,240,233,226,218,211,204,196,192,202,212,
	223,234,244,247,238,227,216,206,196,186,175,165,155,145,135,126,
	117,108,99,90,83,77,71,67,65,64,64,67,71,77,83,91,
	99,108,117,126,136,146,156,166,177,187,198,208,219,230,241,249,
	241,230,219,208,213,220,228,236,243,251,245,237,230,222,215,207,
	199,191,184,176,169,162,154,145,138,130,123,115,107,99,94,101,
	113,124,136,147,158,170,182,193,205,216,228,240,247,240,229,217,
	205,193,182,170,158,146,135,124,111,100,105,112,119,126,133,140,
	147,155,162,170,177,187,194,202,211,218,213,206,197,189,181,179,
	190,203,216,229,243,245,234,221,208,195,182,169,157,144,131,119,
	16,27,38,49,61,72,84,94,106,118,129,140,151,163,175,186,
	197,208,219,231,242,248,239,228,218,206,205,211,219,226,234,241,
	249,246,239,231,224,216,209,201,193,186,178,171,163,156,148,141,
	133,125,118,111,103,99,106,116,127,138,149,160,171,182,193,203,
	215,226,237,248,244,234,223,212,201,190,179,168,158,147,136,125,
	114,107,114,121,129,136,143,150,158,165,173,180,187,195,202,210,
	218,225,232,239,247,249,241,235,227,219,212,204,197,194,203,214,
	225,236,246,244,235,224,213,203,193,182,171,161,151,141,131,121,
	111,102,92,83,75,68,62,57,54,52,54,57,61,68,75,83,
	92,101,111,121,131,141,152,162,173,183,194,204,215,226,238,249,
	244,233,222,210,213,219,226,234,242,249,247,239,231,223,216,209,
	201,193,185,177,170,163,155,147,139,132,124,116,108,101,95,100,
	111,123,134,146,157,169,181,192,204,215,227,239,246,241,229,217,
	206,194,182,170,159,148,136,124,113,101,104,111,118,125,132,139,
	146,154,161,169,177,185,193,201,210,218,213,206,198,190,182,179,
	189,203,216,229,242,245,235,221,208,195,182,170,157,144,131,119,
	16,27,38,49,61,72,84,95,106,118,129,140,151,163,175,186,
	196,207,219,231,242,248,239,228,218,206,205,211,218,226,234,241,
	248,247,240,232,224,216,209,202,194,186,178,171,164,156,148,141,
	134,126,119,111,104,98,106,117,128,138,150,161,171,183,193,205,
	216,226,237,247,244,233,222,211,201,190,179,168,157,146,135,124,
	113,105,113,120,128,135,142,149,157,164,172,179,186,194,201,209,
	216,223,231,238,246,250,243,236,228,221,214,205,199,197,205,216,
	226,238,247,244,233,222,211,200,190,179,169,158,148,137,127,116,
	106,97,86,77,68,60,53,47,43,41,43,46,52,59,68,77,
	86,95,106,116,127,138,147,158,170,181,191,202,213,224,235,246,
	245,235,224,213,212,218,225,233,240,248,247,239,232,225,217,210,
	202,194,187,179,171,164,156,148,141,133,126,118,110,102,96,98,
	110,121,133,145,157,168,179,191,203,215,226,238,246,242,230,219,
	207,196,183,172,160,148,137,125,113,102,104,110,118,125,131,138,
	146,153,161,168,176,185,193,201,209,217,214,206,198,190,182,179,
	189,202,216,229,242,245,235,222,208,195,182,170,157,144,132,119,
	16,27,38,50,60,72,84,95,106,118,129,141,152,163,174,186,
	197,208,220,231,241,247,239,228,217,206,205,210,218,225,233,241,
	248,247,240,232,225,217,210,202,195,187,179,171,165,157,149,142,
	134,127,120,112,104,97,106,118,128,139,150,161,172,183,193,204,
	215,226,237,246,244,233,222,211,200,189,179,168,156,145,135,124,
	112,105,112,119,126,134,141,148,156,163,171,178,186,193,200,207,
	215,222,230,237,244,251,244,237,229,222,215,207,200,199,207,217,
	228,239,246,242,231,220,210,199,188,177,167,155,145,134,124,113,
	103,92,82,72,62,53,44,38,33,30,32,37,44,52,61,70,
	80,91,102,112,123,134,144,155,166,178,188,199,211,222,233,244,
	246,237,226,214,211,217,224,232,239,247,249,241,233,226,219,211,
	203,195,188,180,173,165,158,149,142,134,127,118,111,103,96,97,
	109,121,132,144,156,167,178,190,202,213,225,237,245,243,231,219,
	208,196,184,172,161,149,138,126,114,102,103,110,117,123,130,138,
	144,153,160,168,176,184,192,200,208,217,214,206,199,191,183,179,
	189,202,216,229,242,246,235,222,208,196,182,170,157,144,131,119,
	16,27,38,50,61,72,84,95,107,118,129,141,152,163,174,186,
	197,208,220,231,242,247,239,228,217,206,204,210,217,225,233,240,
	248,248,240,233,225,218,210,202,195,188,180,173,165,158,150,143,
	135,127,120,113,105,98,106,117,128,139,150,161,172,183,195,205,
	216,227,238,246,244,233,222,211,200,190,178,168,156,146,135,124,
	113,107,111,118,126,133,140,147,155,162,169,177,185,192,199,207,
	214,221,229,235,243,251,245,238,230,223,216,209,201,200,207,218,
	229,240,247,241,230,219,209,198,187,176,164,154,143,132,121,111,
	100,89,78,67,57,47,38,29,23,20,21,28,37,46,56,65,
	77,87,98,109,120,131,142,153,164,175,186,197,209,220,231,242,
	246,238,227,215,209,216,223,230,238,246,250,243,235,227,220,212,
	204,197,189,181,174,166,159,151,143,135,128,119,111,105,97,97,
	109,120,132,143,155,167,178,189,201,213,224,236,245,243,231,220,
	208,196,184,173,161,150,138,126,114,103,102,109,116,123,130,137,
	144,152,159,167,175,183,191,200,207,216,215,207,199,191,183,179,
	188,202,215,229,242,246,235,222,209,196,182,170,157,144,131,119,
	16,26,38,50,61,72,84,95,106,118,129,140,151,163,174,186,
	197,208,219,230,242,247,240,228,217,206,203,209,217,224,232,240,
	247,248,241,234,226,219,210,203,196,188,180,173,166,158,150,143,
	136,128,121,113,106,99,106,117,128,139,150,161,172,183,193,205,
	216,227,237,245,243,232,222,210,200,189,179,167,157,145,134,124,
	113,107,110,117,124,132,139,146,154,161,169,176,183,190,198,206,
	212,220,228,235,242,249,246,239,231,224,217,209,202,200,208,218,
	230,241,249,241,230,219,208,197,186,175,164,153,142,131,120,109,
	98,87,77,66,55,44,33,23,15,8,13,21,31,42,53,63,
	74,85,96,107,118,129,141,152,163,174,185,197,208,219,230,241,
	248,239,228,216,208,214,221,229,236,244,251,243,236,229,221,213,
	206,198,190,183,175,167,159,152,144,136,129,121,113,105,98,98,
	108,119,131,143,154,166,177,188,201,213,224,236,246,244,232,220,
	209,197,185,174,162,149,138,127,115,104,101,108,115,122,129,136,
	143,150,158,166,174,182,191,199,207,215,215,207,199,191,183,179,
	188,202,215,229,241,245,235,222,209,196,183,170,157,144,131,119,
	16,26,38,49,61,72,84,95,107,118,129,139,151,163,174,186,
	196,208,219,230,241,247,239,229,217,206,204,209,217,224,231,239,
	246,249,241,234,227,219,211,204,196,189,182,174,166,159,151,144,
	136,129,121,114,107,100,106,117,128,139,150,161,172,183,194,205,
	216,226,238,246,243,233,222,211,200,189,178,167,157,146,135,124,
	113,106,109,116,123,131,138,145,153,160,167,174,182,189,197,204,
	211,219,226,234,241,248,248,240,232,225,218,211,203,198,207,218,
	230,240,250,241,230,219,208,197,185,175,164,153,142,131,120,108,
	97,87,75,65,53,43,32,21,10,4,11,19,29,40,51,62,
	73,84,96,107,117,129,139,151,162,173,185,196,207,218,230,241,
	250,240,228,217,206,213,220,228,235,243,250,245,238,230,223,214,
	207,199,191,184,177,169,161,153,145,138,130,122,114,107,99,98,
	108,119,131,143,154,165,176,189,201,212,224,236,247,244,232,221,
	209,197,186,174,162,150,138,127,115,104,100,107,114,121,128,135,
	143,150,157,166,174,181,190,198,207,215,216,208,200,192,183,180,
	189,202,215,228,241,246,235,221,209,195,182,169,157,143,131,119,
	16,26,38,49,60,72,83,94,106,117,129,140,151,162,174,185,
	196,208,219,230,241,246,240,229,218,206,203,209,217,224,231,238,
	246,249,242,235,227,219,212,204,197,189,182,175,167,159,152,144,
	137,130,122,115,107,101,106,117,128,139,149,160,171,182,193,204,
	216,227,237,247,244,234,222,211,200,189,178,168,157,146,135,124,
	113,106,108,115,123,130,137,144,152,160,166,174,182,188,196,203,
	211,218,225,233,240,247,249,242,233,226,219,212,205,198,207,218,
	229,239,248,242,230,219,209,198,186,176,165,154,142,132,121,110,
	98,87,76,65,55,44,33,23,14,8,11,20,30,40,51,62,
	73,84,95,107,118,129,140,151,162,173,185,196,207,219,230,240,
	249,240,229,217,207,211,219,227,234,242,249,246,239,231,223,215,
	208,201,193,185,177,170,162,154,146,139,131,123,115,108,100,99,
	108,119,131,142,154,166,177,189,201,212,224,235,247,243,232,221,
	209,197,186,173,162,150,139,126,114,104,100,106,113,120,127,134,
	141,150,157,165,173,181,189,198,206,214,217,209,201,193,184,180,
	188,202,215,228,242,246,234,221,208,195,183,169,156,143,131,119,
	15,26,38,49,60,71,83,95,106,116,128,140,151,162,173,185,
	196,207,218,229,240,246,241,229,218,207,203,208,216,223,231,238,
	245,250,242,235,228,220,213,204,198,190,183,175,168,160,153,145,
	138,130,123,115,108,102,105,116,127,138,149,160,171,182,193,204,
	215,226,236,248,244,234,223,212,201,190,179,168,157,146,135,124,
	114,106,107,114,121,129,136,143,151,158,165,173,180,187,195,202,
	209,216,224,232,239,246,250,242,234,227,221,213,206,199,207,217,
	228,239,247,242,231,220,209,198,188,177,165,155,144,133,122,112,
	100,89,79,68,58,48,38,30,22,19,20,26,35,44,54,64,
	75,86,97,108,119,130,141,151,162,174,185,197,208,219,230,241,
	247,240,228,217,208,210,218,225,233,240,248,248,240,232,225,217,
	209,202,194,186,179,171,163,156,148,140,132,124,117,109,101,100,
	108,119,131,142,154,165,177,189,201,212,224,236,247,243,232,221,
	209,197,186,173,162,150,138,126,115,103,98,105,113,119,126,134,
	141,148,156,164,172,181,189,197,205,213,217,209,201,194,185,181,
	189,202,216,229,242,246,234,221,208,195,182,169,156,143,130,118,
	15,26,37,48,59,71,83,94,105,116,128,139,150,161,173,184,
	195,206,218,229,240,246,241,230,218,207,203,208,215,223,230,237,
	245,250,243,236,228,220,213,206,198,190,184,175,168,161,154,146,
	138,131,123,116,109,103,105,116,127,138,149,160,171,182,193,204,
	214,226,236,247,244,234,223,212,202,191,180,169,158,147,136,125,
	114,105,106,113,120,127,135,142,150,157,164,172,179,186,194,201,
	208,216,223,230,238,245,251,243,236,229,222,214,207,200,205,215,
	226,238,246,244,233,222,211,200,190,179,168,157,147,136,125,114,
	104,93,83,72,63,54,45,38,32,29,30,35,41,49,59,69,
	78,89,100,110,121,132,143,153,164,176,187,198,209,220,231,242,
	246,238,227,216,208,209,216,224,232,239,246,249,241,234,226,219,
	211,203,195,188,180,172,164,157,149,141,133,126,118,110,102,100,
	108,120,131,142,154,166,178,190,201,213,224,236,246,244,232,220,
	209,197,185,173,161,150,138,126,115,103,99,105,112,118,126,133,
	140,148,156,164,171,180,189,197,205,213,218,210,201,193,185,181,
	189,202,216,229,243,246,234,221,207,194,181,168,156,143,130,117,
	14,25,37,48,59,70,82,93,104,115,127,138,149,161,172,184,
	195,206,217,228,239,246,242,230,219,208,203,208,216,222,230,238,
	244,251,243,236,228,221,213,206,199,191,184,176,169,161,154,147,
	139,132,125,117,109,103,104,115,126,138,148,159,170,181,191,203,
	213,224,235,246,244,235,224,214,203,192,181,170,158,148,137,127,
	115,105,105,112,119,126,134,141,149,156,164,170,178,185,192,200,
	207,214,222,228,236,243,251,244,237,230,223,216,208,201,203,214,
	225,236,245,246,235,224,213,202,192,182,171,160,149,138,128,118,
	108,97,88,78,69,61,53,47,43,40,40,44,50,57,65,74,
	83,93,103,114,124,135,146,156,167,178,188,199,210,222,233,244,
	246,237,226,215,206,207,215,222,230,238,245,250,243,234,226,219,
	212,204,197,189,181,174,166,158,150,143,135,127,120,111,104,99,
	108,120,132,143,155,166,178,190,202,213,224,236,245,243,232,220,
	208,196,185,173,161,150,138,126,114,102,98,104,111,118,125,132,
	140,147,154,163,171,179,188,196,204,212,218,210,202,193,185,181,
	190,203,216,230,243,246,233,220,207,194,180,168,155,142,129,117,
	13,24,36,47,58,69,81,92,103,114,127,138,149,160,172,182,
	194,205,216,227,238,246,242,231,220,209,203,207,215,222,230,237,
	245,251,244,237,228,221,215,206,199,192,184,177,169,162,154,147,
	140,132,125,118,110,104,103,114,125,136,147,158,168,180,190,201,
	213,223,234,245,245,236,225,214,203,192,182,171,160,149,138,128,
	117,106,105,111,118,125,133,140,147,155,162,169,177,184,191,199,
	205,213,221,227,236,242,250,246,239,231,224,216,209,202,202,212,
	223,233,243,248,238,227,216,205,195,184,174,164,153,142,132,122,
	113,103,94,85,77,69,62,56,53,51,51,54,59,65,72,80,
	89,99,108,118,128,138,149,159,170,180,191,202,213,224,235,244,
	247,235,225,213,204,206,214,221,229,237,244,251,244,236,228,221,
	213,205,198,190,183,174,167,159,151,144,136,128,120,113,106,98,
	109,121,132,144,155,167,178,190,202,213,226,237,246,243,231,219,
	208,196,184,173,161,149,138,126,114,102,98,103,110,118,124,131,
	139,146,154,162,170,178,187,195,204,212,219,210,202,194,186,181,
	190,204,217,231,244,245,233,220,206,194,180,167,154,141,128,116,
	13,23,34,46,58,68,80,91,102,114,126,137,148,160,171,182,
	193,205,215,226,238,246,242,232,221,210,203,207,215,222,229,237,
	244,251,244,237,229,222,214,207,200,192,185,178,170,162,155,148,
	140,133,126,118,111,105,102,113,124,135,146,157,168,179,189,200,
	211,222,233,244,246,237,226,216,205,194,183,172,162,151,139,129,
	118,107,105,110,117,125,132,139,146,154,161,168,176,183,190,198,
	205,212,219,227,234,241,249,247,240,232,225,218,210,203,200,209,
	219,230,241,250,241,230,219,209,198,188,178,168,158,148,138,128,
	119,110,101,93,85,78,72,66,64,63,63,65,69,74,80,88,
	96,105,114,123,133,143,153,163,173,184,195,205,216,226,237,247,
	245,233,222,211,200,204,212,220,228,235,243,250,245,238,230,222,
	215,207,199,191,184,175,168,161,152,145,137,129,122,114,106,101,
	110,122,133,145,156,168,179,191,203,215,225,238,247,242,231,219,
	207,195,183,172,160,148,136,125,113,101,97,102,109,117,124,131,
	138,146,154,161,170,177,186,194,203,212,219,211,202,194,186,180,
	191,205,218,231,244,245,232,219,205,192,179,166,153,140,127,115,
	12,22,33,45,57,67,79,90,102,113,125,136,147,158,170,181,
	192,203,215,226,237,245,244,233,222,211,203,206,214,221,228,236,
	243,251,245,237,230,223,216,208,200,193,185,178,171,163,156,148,
	141,134,127,118,111,104,101,111,123,133,145,155,167,177,188,199,
	210,221,232,242,247,239,228,217,206,195,184,174,163,152,141,131,
	120,109,105,108,116,124,131,138,146,153,160,167,175,181,189,197,
	203,211,218,226,233,240,248,248,241,233,226,219,212,205,198,206,
	216,227,238,248,244,233,223,213,203,193,183,173,163,153,144,134,
	125,117,109,101,94,87,82,77,75,74,74,76,79,83,89,96,
	103,112,120,129,138,147,157,167,177,187,199,208,219,229,240,249,
	242,230,220,209,200,204,212,219,226,234,241,249,246,239,231,223,
	216,208,200,192,185,177,169,161,153,146,138,130,122,115,107,103,
	111,122,134,146,157,169,180,192,204,215,226,239,250,241,230,218,
	206,194,182,171,159,148,136,124,113,101,96,101,109,116,123,130,
	137,144,152,160,169,177,185,194,203,212,220,212,203,194,186,180,
	192,205,219,232,244,244,231,218,205,191,179,165,152,140,127,114,
	11,21,32,44,56,67,78,90,101,112,124,135,146,157,169,180,
	191,203,214,225,236,245,245,234,223,211,203,206,213,221,228,236,
	243,250,245,238,231,223,216,208,201,193,186,179,171,164,156,149,
	142,134,127,120,111,105,101,110,122,133,144,154,165,176,187,198,
	209,220,230,241,248,240,229,218,208,197,185,175,165,153,143,132,
	121,111,105,108,115,122,130,137,145,152,159,166,173,181,188,195,
	203,210,217,225,232,239,247,249,242,235,227,221,213,206,198,204,
	213,224,235,245,246,238,227,217,207,197,188,178,168,159,150,141,
	132,124,117,109,103,97,92,88,86,84,85,86,89,93,98,105,
	112,119,127,135,144,153,162,172,182,192,202,212,223,233,243,247,
	238,227,216,206,199,202,210,217,225,233,240,248,247,240,232,224,
	217,209,201,194,186,178,171,163,155,148,140,132,124,116,108,105,
	113,124,136,147,159,170,181,193,205,216,228,239,249,241,229,217,
	205,193,182,170,158,147,135,124,112,100,94,101,108,115,122,129,
	137,143,151,160,168,177,185,193,202,211,220,212,204,195,186,180,
	193,206,220,233,244,244,230,217,204,191,178,165,151,138,126,113,
	10,20,32,43,55,66,77,88,100,111,123,134,145,156,168,179,
	190,202,213,223,235,245,246,235,224,213,204,206,213,220,227,235,
	242,250,246,238,231,224,217,209,202,194,186,179,172,164,157,150,
	142,135,128,120,113,106,100,109,121,131,142,152,163,175,185,196,
	207,218,228,240,248,242,230,220,209,198,187,177,167,156,144,134,
	123,113,105,107,113,121,129,136,144,151,158,165,172,180,187,194,
	201,209,216,223,230,238,246,250,243,236,229,221,214,206,199,201,
	210,220,230,240,246,242,232,222,212,202,193,184,174,165,157,149,
	140,132,125,118,112,107,103,99,97,96,95,97,99,103,109,114,
	120,127,135,142,151,160,169,178,188,197,207,217,227,237,246,244,
	234,224,213,203,197,201,208,216,223,231,239,247,249,241,234,226,
	218,210,202,195,187,179,171,164,156,149,141,134,125,117,109,106,
	114,125,136,148,160,171,183,194,206,218,229,241,246,239,228,216,
	204,192,181,169,157,146,134,122,111,99,93,100,107,114,121,129,
	136,143,151,159,168,176,184,193,202,210,218,213,204,196,187,180,
	194,207,221,234,246,243,229,216,203,190,176,164,151,137,125,112,
	9,19,31,42,54,65,76,87,98,110,122,133,144,155,166,178,
	189,201,211,222,233,245,247,236,225,214,205,206,213,220,227,235,
	242,249,246,239,232,224,217,209,202,194,187,180,172,165,158,150,
	143,136,128,120,113,106,101,107,118,129,140,151,162,173,184,194,
	205,216,227,238,248,244,233,222,211,201,190,179,169,157,146,136,
	125,114,106,106,113,120,128,135,142,149,157,164,171,179,186,193,
	200,208,215,222,230,236,244,251,244,237,230,222,215,208,201,199,
	206,216,226,236,245,247,237,227,218,208,199,190,181,173,164,156,
	148,140,133,127,122,117,113,110,108,107,107,108,110,114,118,123,
	129,136,143,150,157,166,175,184,193,202,212,222,232,242,247,241,
	231,221,210,199,194,200,207,215,223,230,238,245,250,242,234,227,
	219,211,204,196,189,180,173,165,157,149,142,134,126,118,111,107,
	115,127,138,150,161,173,184,196,207,219,231,243,246,238,226,214,
	203,192,180,167,156,145,133,121,109,98,92,100,107,113,121,128,
	135,143,151,158,167,175,184,192,201,210,218,212,204,196,187,182,
	195,208,222,235,247,241,228,215,202,189,175,163,150,137,124,111,
	8,18,30,41,52,64,75,86,98,109,120,131,143,154,165,176,
	188,199,210,221,232,243,247,237,227,216,206,205,212,220,227,234,
	242,249,247,240,232,225,217,210,203,195,188,181,173,166,159,151,
	144,136,129,122,114,107,101,106,117,128,139,150,160,171,181,192,
	203,214,225,236,247,244,235,224,214,203,192,181,170,159,149,138,
	128,117,107,105,112,120,127,134,141,148,156,163,171,178,185,192,
	200,207,214,221,229,235,243,250,245,238,231,223,216,209,201,198,
	201,211,222,231,241,249,242,233,224,215,206,197,188,180,171,164,
	157,149,142,136,131,127,123,120,118,118,118,119,121,124,128,133,
	138,144,151,158,166,174,182,191,200,208,217,227,237,245,246,236,
	226,216,205,196,191,199,206,214,221,229,236,244,251,243,236,228,
	220,213,205,197,190,182,174,166,158,151,143,135,127,120,112,107,
	118,129,140,151,164,174,186,198,209,220,232,244,246,236,225,213,
	202,190,178,166,154,143,131,120,108,97,91,99,106,112,120,128,
	135,142,150,158,166,175,183,192,201,209,218,213,204,196,187,183,
	196,210,223,236,248,240,227,214,200,187,174,161,148,135,122,110,
	7,17,28,40,51,63,74,85,97,108,119,130,142,153,164,175,
	186,198,209,220,231,242,248,239,228,216,206,205,212,219,227,234,
	240,248,248,240,233,225,218,210,203,196,188,182,174,166,159,152,
	144,137,129,122,115,107,101,104,115,126,137,147,159,170,180,191,
	201,212,223,234,245,245,237,226,215,205,194,183,173,162,152,140,
	129,119,109,105,110,119,126,133,140,148,155,162,169,177,184,191,
	198,205,213,220,228,235,242,249,246,239,232,224,218,211,203,197,
	197,206,217,226,235,245,246,240,230,221,212,204,195,188,180,173,
	165,158,152,147,142,137,134,131,130,129,129,130,132,135,138,143,
	148,153,160,166,174,181,189,197,206,215,224,233,243,247,241,231,
	221,212,202,190,190,197,205,212,221,228,235,243,251,245,237,229,
	221,214,206,198,191,183,175,167,160,152,143,137,129,121,112,108,
	120,131,142,154,165,177,188,200,211,222,233,244,245,234,223,211,
	200,188,177,165,153,142,130,118,107,95,91,98,105,112,120,127,
	134,141,149,157,166,174,183,191,200,209,217,214,205,197,188,185,
	197,211,224,238,250,239,226,212,199,186,173,160,147,134,121,109,
	5,15,27,38,50,61,73,84,96,107,117,129,140,151,162,173,
	185,196,207,218,230,241,247,241,230,218,207,205,212,219,226,233,
	241,248,248,240,233,226,218,211,203,196,189,182,175,167,159,152,
	145,138,130,123,116,108,101,102,113,124,135,145,157,167,178,189,
	199,209,221,231,242,246,240,229,218,207,196,186,176,164,153,144,
	132,122,111,106,110,118,125,132,139,147,154,161,168,175,183,190,
	197,205,212,219,226,234,241,248,248,240,233,226,219,211,204,197,
	191,201,211,220,230,239,247,245,237,228,220,211,203,196,188,181,
	174,168,162,157,152,148,144,142,140,140,141,141,143,145,148,153,
	158,163,168,175,182,189,197,204,213,222,231,239,247,245,236,226,
	216,207,196,186,189,196,203,211,219,227,234,242,250,246,238,230,
	222,215,207,200,192,184,176,169,161,153,145,137,130,122,114,112,
	122,133,144,156,167,179,190,201,213,224,235,245,244,233,221,210,
	199,187,175,164,152,140,128,117,105,93,91,97,104,111,119,126,
	133,141,148,157,165,173,182,191,200,208,216,214,206,197,188,187,
	198,212,225,239,250,238,225,211,197,185,171,158,145,132,119,107,
	5,14,26,37,49,60,71,83,94,105,116,127,139,150,161,172,
	183,195,205,216,228,239,247,242,231,220,209,205,211,218,226,233,
	240,248,248,241,234,226,219,212,205,197,189,183,175,168,160,153,
	146,138,131,124,116,109,101,100,111,122,133,143,154,165,175,186,
	197,208,218,229,240,246,242,231,220,210,199,188,178,167,157,146,
	135,125,114,107,109,117,124,131,138,146,152,160,167,175,182,189,
	196,203,211,218,225,232,239,247,249,242,234,227,220,212,206,198,
	191,195,205,214,223,233,241,246,244,236,227,219,211,204,197,190,
	183,178,172,167,162,159,156,153,152,151,152,152,154,156,159,163,
	167,173,178,184,191,197,204,212,220,229,238,246,247,239,230,220,
	211,201,191,183,187,195,202,210,218,225,233,241,248,247,239,231,
	224,216,208,200,193,185,178,170,162,154,146,138,131,123,115,115,
	124,135,147,158,170,181,192,203,214,227,238,249,242,231,219,208,
	196,185,173,161,150,138,126,115,103,92,90,96,104,111,118,125,
	132,140,147,156,164,173,181,190,198,207,216,215,206,197,189,188,
	200,214,227,241,249,236,223,209,196,183,170,157,144,131,118,106,
	5,13,24,35,47,58,70,81,92,103,114,125,137,148,159,170,
	182,192,204,215,226,237,246,244,233,222,211,206,211,218,225,233,
	240,247,249,242,234,227,219,213,205,198,191,183,176,168,161,154,
	146,139,131,124,117,110,102,99,109,119,131,141,152,162,173,183,
	195,206,216,227,238,245,244,233,223,212,202,191,181,170,160,149,
	138,128,117,108,108,115,123,131,138,145,151,159,166,174,181,188,
	195,202,210,217,224,232,239,246,250,243,235,228,221,213,206,199,
	192,192,199,208,217,226,235,243,248,243,235,227,220,213,205,199,
	193,187,182,177,173,169,166,164,163,162,162,163,165,167,169,173,
	177,182,187,193,199,206,213,220,228,236,244,247,242,233,224,214,
	205,195,185,182,186,194,201,209,217,224,231,239,247,248,241,233,
	225,217,209,202,194,186,179,171,163,155,148,140,132,124,116,117,
	127,138,150,161,172,183,194,205,217,229,240,249,239,229,217,205,
	194,182,170,159,148,136,125,113,101,90,89,95,103,110,117,125,
	132,139,147,155,164,172,181,189,198,207,216,215,207,198,189,189,
	202,215,229,242,248,234,221,207,195,181,168,155,142,129,116,104,
	5,12,22,34,46,57,68,79,90,101,113,124,135,146,157,168,
	180,191,202,213,224,235,245,245,235,224,213,206,210,218,225,232,
	239,246,250,243,235,227,220,213,206,198,191,183,176,169,161,154,
	147,139,132,124,117,110,103,99,107,117,129,139,149,160,171,181,
	192,203,214,224,235,245,247,236,225,215,205,194,184,173,163,152,
	141,131,120,110,107,115,121,129,136,144,151,158,165,173,179,187,
	194,202,209,216,223,231,238,245,251,244,236,229,222,215,208,200,
	193,189,192,201,210,219,227,235,244,250,243,236,228,221,215,208,
	202,197,192,187,183,180,177,175,174,173,173,174,175,178,179,184,
	187,192,197,202,208,214,221,229,236,244,247,243,235,226,217,208,
	199,189,180,178,185,192,200,208,216,223,231,238,246,249,242,234,
	226,218,210,203,195,188,180,172,164,157,149,141,132,124,117,119,
	130,141,153,163,174,186,197,208,220,231,243,247,238,226,215,204,
	192,180,169,157,145,134,122,111,99,89,88,95,103,109,117,124,
	132,139,147,155,163,172,180,189,198,206,215,215,207,198,190,191,
	204,217,231,244,245,232,219,206,193,180,166,153,140,127,115,103,
	5,12,21,32,43,55,66,77,88,100,111,122,133,145,156,167,
	178,189,200,211,222,233,243,247,237,226,215,207,210,217,224,231,
	239,246,250,243,235,227,220,213,205,198,191,183,176,169,162,155,
	147,140,133,125,118,111,104,98,104,114,126,136,146,157,168,179,
	190,200,210,221,231,242,249,240,229,218,208,197,187,176,166,155,
	145,134,124,114,107,114,120,129,135,143,150,157,164,172,179,186,
	193,201,208,214,222,229,237,243,251,245,238,230,223,216,208,201,
	195,188,186,195,203,212,220,229,237,244,248,244,237,230,224,218,
	212,207,202,198,194,191,189,187,185,184,185,184,186,188,191,193,
	197,202,206,212,217,223,230,237,244,247,243,236,228,219,210,201,
	193,183,175,176,183,191,199,207,214,222,230,237,245,250,243,235,
	227,219,212,204,196,189,181,173,165,157,150,142,134,126,120,122,
	133,144,155,166,178,189,200,211,223,234,245,245,235,224,212,201,
	189,178,166,156,144,132,120,109,97,88,87,94,101,109,116,123,
	131,138,146,154,163,171,179,189,197,206,216,216,207,199,190,192,
	205,219,232,246,243,231,217,204,191,178,164,152,139,126,113,101,
	5,12,19,30,41,53,64,75,86,98,109,120,131,143,154,165,
	176,187,198,209,220,231,242,250,239,228,217,208,210,217,224,231,
	238,245,250,243,236,228,221,213,207,199,192,184,177,170,163,156,
	148,140,133,126,119,112,104,98,101,112,122,133,143,154,165,176,
	187,197,208,219,229,239,249,243,233,222,211,201,191,180,169,159,
	148,138,128,117,109,113,120,128,134,141,148,156,163,171,178,185,
	192,199,207,214,221,228,236,242,250,246,238,231,224,217,209,202,
	195,188,183,188,196,204,212,221,228,235,243,247,245,239,233,227,
	222,218,212,208,205,202,200,197,196,195,196,196,197,199,201,204,
	208,212,216,221,227,232,239,245,247,243,236,228,220,211,203,195,
	186,177,169,175,183,191,198,206,213,221,229,235,243,251,244,236,
	228,221,213,206,197,189,182,174,166,158,150,143,135,128,121,125,
	136,147,158,170,180,192,203,214,225,237,247,244,232,221,210,198,
	187,176,164,152,140,130,118,107,95,86,87,94,101,108,115,122,
	130,137,146,154,162,171,179,188,197,206,214,216,207,199,191,194,
	207,221,234,248,242,229,216,202,189,175,163,149,137,124,111,99,
	5,12,19,29,40,51,62,73,84,96,107,118,130,140,151,163,
	174,185,196,207,218,229,240,250,241,231,219,209,210,217,224,231,
	238,246,251,244,237,229,221,214,207,200,193,185,178,170,163,156,
	149,141,134,126,119,111,105,98,100,109,120,130,141,152,162,173,
	183,194,205,216,226,236,247,245,235,225,214,204,194,183,173,163,
	152,142,132,121,110,112,119,127,134,141,148,155,162,170,177,184,
	191,198,205,213,220,227,234,241,249,247,239,232,225,218,211,204,
	196,189,181,181,188,196,205,212,220,228,235,241,246,246,243,237,
	232,227,222,219,215,212,210,208,207,207,207,207,208,210,212,215,
	218,222,227,231,237,242,248,249,242,235,227,220,212,204,196,187,
	179,170,167,173,181,189,197,205,212,219,227,235,242,250,245,237,
	230,222,214,207,199,191,183,174,167,159,152,144,136,128,121,129,
	139,150,161,173,184,195,206,217,228,239,247,241,230,219,207,195,
	184,173,161,149,138,127,115,104,93,83,86,93,101,108,115,122,
	129,137,145,153,161,170,179,187,196,205,214,216,208,199,192,196,
	209,223,236,247,240,226,214,200,187,174,161,148,135,122,109,97,
	5,11,19,27,38,49,60,71,82,93,105,116,127,138,150,160,
	172,183,194,205,216,227,238,249,243,233,222,211,210,216,223,230,
	238,244,251,245,237,229,222,215,207,200,193,186,178,171,164,156,
	149,142,134,127,120,113,106,99,98,106,117,128,138,149,159,170,
	180,190,201,212,222,233,243,247,239,228,218,208,197,187,177,166,
	156,145,136,126,115,113,118,126,133,139,146,154,161,169,176,182,
	190,197,204,211,219,226,233,241,248,248,241,233,226,219,212,204,
	198,190,183,176,181,188,197,204,211,219,226,233,239,244,247,247,
	242,238,234,230,226,224,221,220,218,218,218,218,219,221,223,226,
	229,232,237,241,246,248,245,240,233,227,219,212,205,196,188,180,
	172,163,165,172,180,188,196,203,211,218,226,233,241,249,246,238,
	230,223,215,207,200,192,184,176,168,160,152,145,137,129,123,133,
	143,154,165,176,187,198,208,220,232,242,248,238,227,215,204,192,
	181,170,159,147,136,124,113,101,90,79,85,93,100,107,114,121,
	129,136,144,153,161,169,179,187,196,205,213,217,208,200,193,198,
	211,225,239,246,238,224,211,198,185,172,159,146,133,120,107,95,
	5,11,20,27,36,47,58,69,80,92,103,114,125,136,147,158,
	169,180,192,203,214,224,236,247,245,235,224,213,211,216,223,230,
	237,245,251,245,237,229,222,215,207,200,193,186,178,171,164,157,
	150,142,135,128,121,114,106,99,97,103,114,124,135,145,156,166,
	177,188,198,209,219,229,240,248,243,232,222,211,201,191,181,171,
	160,150,139,129,120,114,117,124,131,139,146,153,160,168,175,181,
	189,196,203,210,218,225,233,240,247,249,242,235,227,220,213,206,
	199,191,184,177,176,181,188,196,203,210,217,224,230,235,241,246,
	248,247,244,240,237,234,232,231,229,229,229,229,230,232,234,237,
	240,243,245,246,246,242,236,231,224,217,211,204,197,189,180,172,
	164,159,164,171,179,187,195,202,210,218,225,232,240,248,248,239,
	231,224,216,208,200,193,185,177,169,162,154,146,138,130,127,136,
	146,158,169,179,190,202,212,223,234,245,245,234,223,212,201,190,
	179,167,156,145,133,122,110,98,87,78,84,92,98,106,113,121,
	128,135,144,151,161,168,177,187,196,204,214,217,209,200,193,200,
	214,227,241,246,235,222,209,196,183,170,157,144,131,118,104,93,
	4,11,19,26,34,45,56,67,79,90,101,112,123,134,145,156,
	167,178,189,200,212,222,232,244,246,237,226,215,211,216,223,229,
	236,244,251,245,237,230,223,216,208,201,194,186,179,172,165,157,
	150,143,136,129,122,114,107,99,95,99,110,121,131,142,152,163,
	174,184,194,205,215,225,236,246,246,236,226,215,205,195,185,175,
	164,154,144,134,124,116,117,124,131,138,145,153,160,167,174,181,
	188,195,203,209,217,224,232,239,245,250,243,236,228,221,214,207,
	200,192,185,178,172,173,180,187,194,201,207,214,220,226,231,235,
	240,244,249,248,246,244,243,242,240,239,239,240,241,243,245,247,
	250,250,246,242,237,232,227,221,215,209,202,195,188,181,173,165,
	157,156,163,170,178,186,193,200,208,217,224,231,239,247,249,241,
	233,225,217,209,201,194,186,178,170,163,155,147,139,131,131,140,
	151,161,172,183,194,205,216,227,239,249,243,231,220,209,198,187,
	175,164,153,141,130,118,107,96,84,78,83,90,98,105,112,120,
	128,135,143,151,159,168,177,186,195,204,213,218,209,200,194,203,
	216,230,244,246,233,220,207,194,181,167,154,141,128,116,102,90,
	6,12,19,27,34,43,54,65,76,87,98,109,120,132,143,154,
	165,175,186,198,209,220,230,241,247,240,230,218,212,216,222,229,
	237,244,251,245,238,230,223,216,209,202,194,187,180,173,165,158,
	151,143,136,129,122,115,107,100,94,96,107,118,127,138,149,159,
	170,180,190,201,212,222,232,242,246,240,230,220,209,199,189,179,
	169,158,148,138,128,118,116,123,129,137,144,151,158,166,173,180,
	187,194,202,209,216,223,230,238,244,251,244,236,229,223,215,208,
	201,193,186,179,171,168,172,179,186,192,198,205,210,216,221,226,
	230,234,238,241,244,246,246,246,247,250,250,248,247,246,245,244,
	242,239,235,232,227,222,217,212,206,200,193,186,179,172,165,157,
	151,154,161,169,177,185,192,200,207,215,223,231,238,246,249,241,
	234,226,218,210,203,195,187,179,171,164,156,148,140,132,133,144,
	155,165,176,187,198,209,220,231,242,248,239,228,217,206,194,183,
	172,161,150,138,127,116,104,93,82,78,83,90,97,105,112,119,
	126,134,143,150,159,167,176,185,194,204,212,218,210,201,194,205,
	219,232,244,244,231,217,204,191,177,165,152,139,126,113,100,88,
	8,12,19,27,35,42,51,62,74,85,96,107,118,129,140,151,
	162,173,184,196,206,217,228,239,248,243,232,221,214,215,222,229,
	235,243,250,245,238,231,224,217,209,202,195,187,180,173,166,159,
	152,144,137,130,123,115,109,101,94,93,104,114,124,135,146,156,
	166,177,187,197,208,218,228,238,246,244,234,224,214,203,193,184,
	173,163,153,143,133,123,117,122,128,136,143,150,157,165,172,179,
	186,193,200,208,215,222,229,236,243,251,245,238,230,223,216,209,
	202,195,187,180,172,166,163,170,177,183,189,194,200,206,211,216,
	220,224,228,231,233,236,238,239,240,240,241,241,239,238,236,234,
	231,228,225,221,217,212,207,202,196,190,184,178,171,164,157,150,
	146,152,160,168,176,183,192,199,206,214,222,230,237,245,250,242,
	235,227,219,212,204,196,189,180,172,165,157,149,141,134,137,148,
	159,170,180,191,202,213,223,235,246,245,236,224,213,202,190,180,
	169,157,147,135,123,112,101,90,79,76,82,89,97,104,111,119,
	126,134,142,150,159,167,176,185,194,203,212,218,210,201,195,208,
	221,235,246,242,228,215,202,189,176,162,149,137,124,111,98,86,
	10,11,19,27,35,42,49,60,72,83,93,104,115,126,137,148,
	159,170,182,193,204,214,225,236,247,245,234,224,216,215,222,228,
	235,242,250,246,239,231,224,217,210,203,195,188,181,174,166,159,
	152,145,137,130,123,116,109,101,94,91,100,110,121,131,141,152,
	163,173,182,193,203,214,224,234,244,248,239,228,218,208,197,188,
	178,168,158,148,138,128,120,121,128,135,142,149,156,164,170,178,
	185,192,199,207,214,221,228,235,242,250,246,239,231,224,217,210,
	202,196,188,182,174,167,160,161,167,174,180,185,191,196,201,205,
	209,213,217,220,222,224,227,228,229,230,230,229,228,227,225,223,
	221,218,214,211,207,202,197,193,187,181,175,169,162,155,148,141,
	144,152,160,167,175,182,190,198,205,213,221,229,236,244,251,244,
	236,228,220,213,205,197,189,182,173,165,157,150,141,136,142,153,
	164,174,185,196,206,217,227,238,246,242,231,220,209,198,187,176,
	165,154,142,132,120,109,98,87,76,75,82,89,96,103,111,118,
	126,133,141,150,158,167,176,185,193,203,212,219,209,201,198,210,
	224,237,248,239,226,212,199,186,173,160,147,134,121,109,95,83,
	12,11,19,27,35,42,49,58,69,80,91,102,113,124,136,146,
	157,168,179,190,201,211,223,234,244,246,237,227,218,215,221,228,
	236,243,250,246,239,232,224,217,210,203,196,189,181,174,167,159,
	153,146,138,131,124,117,109,102,95,90,96,106,117,127,138,148,
	159,169,179,189,200,210,220,230,240,249,243,233,223,213,202,193,
	183,173,163,153,143,134,124,120,127,134,141,148,155,163,170,177,
	184,191,199,206,214,220,227,235,242,249,247,240,233,226,218,212,
	204,197,189,182,175,168,161,156,158,164,170,176,181,185,190,195,
	198,203,206,209,211,213,216,216,217,219,219,218,217,216,214,212,
	210,207,204,200,196,192,187,182,177,172,166,159,153,146,139,136,
	143,151,159,166,174,182,189,197,204,212,220,228,235,243,251,245,
	236,229,221,213,206,198,190,183,175,166,158,151,142,137,147,157,
	167,178,189,200,211,221,232,243,246,238,227,217,206,195,183,172,
	161,151,139,128,117,106,94,83,74,75,82,88,96,103,110,118,
	125,133,140,149,158,166,175,184,193,202,211,219,210,201,200,213,
	227,240,249,235,223,209,197,183,170,157,144,131,118,106,93,80,
	15,12,19,27,34,42,49,57,67,77,88,99,110,122,133,143,
	154,165,176,186,198,209,220,230,241,246,240,229,219,214,221,228,
	235,242,249,247,239,232,225,218,211,204,196,189,181,175,167,160,
	153,146,138,131,124,117,110,103,95,90,92,103,113,123,134,144,
	155,165,175,185,195,205,215,226,236,246,246,237,227,217,207,198,
	188,177,168,158,149,139,129,121,126,133,140,148,155,162,169,176,
	183,191,198,205,212,219,226,233,240,248,248,241,234,227,219,212,
	205,198,190,184,176,169,162,154,151,154,160,166,170,176,180,184,
	188,192,195,198,200,203,205,205,206,207,207,207,206,205,203,202,
	199,197,194,189,186,182,177,172,167,162,156,150,144,137,131,135,
	141,150,157,165,173,181,189,196,203,210,218,226,234,242,250,245,
	238,230,222,215,207,199,191,183,175,167,160,151,143,142,152,162,
	172,184,194,204,215,226,236,246,245,234,223,213,202,191,180,169,
	158,147,135,124,113,102,91,79,71,74,81,88,95,102,110,117,
	125,132,140,148,157,166,175,183,193,202,211,219,210,201,203,216,
	230,243,247,233,220,207,194,180,168,155,142,128,116,103,90,78,
	16,12,19,27,34,42,49,57,65,75,85,97,107,118,129,140,
	151,162,173,185,195,206,216,227,238,246,243,232,222,215,221,228,
	235,242,249,247,240,233,226,219,211,204,197,189,182,175,168,160,
	153,146,139,132,125,118,111,104,96,89,88,98,109,119,129,140,
	150,160,170,181,191,201,211,221,231,241,248,242,232,222,212,202,
	193,183,173,164,153,144,135,125,126,132,140,147,154,161,168,175,
	183,190,197,204,211,218,225,233,240,247,249,242,235,228,220,213,
	206,199,191,185,177,169,162,155,149,146,150,156,161,165,170,174,
	178,181,184,187,190,191,193,194,195,196,196,196,195,194,193,191,
	188,185,183,179,176,172,167,163,157,152,147,141,135,128,128,134,
	141,149,156,164,171,179,187,195,202,210,218,225,233,241,249,246,
	239,231,223,216,208,200,192,184,176,168,161,153,145,147,157,167,
	177,188,198,208,220,230,240,247,241,230,219,208,198,187,176,165,
	154,143,132,121,110,98,87,76,68,72,80,87,94,102,109,117,
	124,132,140,148,156,165,174,183,192,201,210,219,211,202,206,219,
	233,245,243,230,217,204,190,178,165,152,139,126,113,100,87,75,
	19,13,19,27,34,42,49,57,64,72,82,93,104,115,126,137,
	148,159,171,182,192,203,214,224,235,245,246,236,225,216,220,228,
	234,241,249,248,241,233,226,219,211,204,197,191,183,176,168,161,
	154,147,140,133,125,118,111,104,97,89,86,94,105,115,125,136,
	146,156,166,176,187,196,206,216,227,236,246,245,237,227,217,208,
	199,189,178,169,159,150,141,131,128,132,139,146,153,160,167,174,
	182,189,196,203,210,217,224,231,238,246,250,243,236,229,221,214,
	206,199,192,185,178,171,163,156,149,143,140,146,151,155,160,163,
	167,170,173,176,179,181,182,183,184,184,185,185,183,183,182,180,
	177,175,172,169,165,162,157,152,148,142,137,132,126,122,126,133,
	140,148,155,163,170,178,186,194,201,209,217,224,232,240,247,247,
	239,232,224,216,209,201,193,185,176,169,161,153,147,152,162,172,
	183,194,204,214,224,235,245,247,236,226,215,204,193,183,172,161,
	150,139,128,117,106,94,83,72,65,72,79,87,94,101,109,116,
	123,131,139,147,156,165,173,182,192,201,210,219,211,202,209,222,
	236,248,241,227,214,201,188,174,162,149,136,123,110,97,84,72,
	21,12,20,27,34,42,49,56,64,71,80,91,101,112,123,134,
	145,156,167,177,189,200,210,221,232,243,247,239,228,219,220,227,
	234,241,248,248,241,234,227,220,213,205,198,191,183,176,169,162,
	155,148,140,133,126,119,112,104,97,90,84,90,100,111,121,131,
	141,151,161,171,182,192,202,211,221,231,241,246,242,232,222,213,
	203,194,185,174,165,156,146,137,130,130,138,145,152,159,166,174,
	181,188,195,202,209,216,224,231,237,245,251,244,236,229,223,215,
	207,200,193,186,179,172,165,158,150,143,136,135,140,145,149,153,
	157,160,163,166,168,169,171,173,173,173,174,173,173,172,171,169,
	167,164,161,158,155,151,147,142,138,133,127,122,117,117,124,131,
	139,147,154,162,169,177,185,193,200,208,215,223,231,239,247,248,
	241,233,225,217,210,202,194,186,178,170,162,154,151,158,167,177,
	188,198,208,219,229,240,248,243,232,221,211,199,189,178,167,156,
	146,134,123,113,101,90,79,68,65,71,79,86,93,101,108,115,
	123,131,139,147,155,164,173,182,192,201,210,219,211,204,212,225,
	239,247,237,224,211,198,185,171,158,146,133,120,107,94,81,69,
	24,14,19,26,35,42,49,57,64,71,79,88,98,109,120,131,
	142,153,164,174,186,197,207,217,228,239,246,242,232,222,221,227,
	234,241,247,248,241,234,227,219,213,205,198,191,184,176,169,162,
	155,148,141,134,127,119,112,105,98,91,84,87,96,107,116,127,
	137,147,156,167,177,187,197,206,216,226,236,245,247,238,228,219,
	209,200,190,180,171,161,152,142,134,130,137,144,152,159,166,173,
	180,187,194,201,209,216,223,230,237,244,251,245,238,230,223,216,
	209,202,195,188,180,173,166,159,151,143,136,130,130,134,138,142,
	146,149,152,154,157,159,160,162,162,163,162,162,162,161,160,158,
	156,153,150,147,144,141,137,132,127,123,117,112,110,115,123,130,
	138,146,154,161,169,176,184,192,199,206,215,222,230,238,246,249,
	242,234,226,218,211,202,194,187,179,171,163,155,155,163,173,183,
	193,203,214,224,234,245,246,237,227,216,206,195,184,174,163,152,
	141,130,120,108,98,87,76,65,64,71,78,85,92,100,108,114,
	122,130,138,147,155,164,173,182,191,200,209,219,211,207,215,229,
	242,245,234,221,208,195,181,169,155,142,130,117,104,91,78,66,
	26,16,19,27,35,42,50,56,64,72,79,87,96,106,117,128,
	139,150,161,171,183,193,204,215,225,236,245,246,235,225,221,227,
	234,240,247,249,241,234,227,220,212,205,198,191,184,177,169,162,
	156,149,141,134,126,119,113,105,99,91,84,84,91,101,111,122,
	132,142,152,162,172,182,191,201,211,221,231,241,247,243,234,224,
	214,205,195,186,177,167,158,149,140,133,136,144,151,158,165,172,
	179,186,193,200,208,215,222,229,236,243,250,246,239,231,224,217,
	210,203,195,188,181,174,166,159,152,144,137,130,124,124,128,131,
	135,138,141,143,145,147,148,150,150,151,151,151,151,150,148,147,
	145,143,140,137,133,130,126,122,118,113,108,104,107,115,122,130,
	137,144,152,160,168,175,183,191,198,206,214,221,230,237,245,250,
	242,235,227,219,211,203,195,188,180,172,164,157,159,168,178,189,
	199,209,219,229,239,249,243,233,222,212,201,190,180,169,158,147,
	136,126,115,104,93,82,72,61,63,70,78,85,92,100,107,114,
	122,130,138,146,154,163,172,181,191,200,209,218,212,209,219,232,
	245,244,231,218,204,191,178,165,152,139,127,113,101,88,75,63,
	29,19,19,27,35,42,49,57,64,71,79,86,94,103,114,125,
	136,147,157,169,179,189,200,211,222,232,243,249,239,228,221,226,
	233,240,247,249,241,234,228,220,213,206,198,191,184,177,170,163,
	156,149,142,134,127,120,113,106,99,92,84,82,87,97,108,118,
	127,137,147,157,167,176,186,196,206,215,226,235,244,249,239,229,
	220,211,201,192,183,174,164,155,146,137,136,143,150,157,164,171,
	178,185,192,200,207,214,221,227,235,242,249,246,240,232,225,218,
	210,203,196,189,182,174,167,160,153,146,138,131,124,119,118,121,
	124,128,130,133,135,137,137,139,139,140,140,140,140,138,137,136,
	134,132,129,126,123,119,116,112,107,103,98,98,106,114,121,129,
	136,144,151,159,167,174,182,190,198,205,213,221,228,237,244,251,
	243,235,228,221,212,205,196,188,181,173,165,159,164,174,184,194,
	204,214,224,234,244,246,238,228,217,207,196,185,175,164,153,143,
	132,121,111,100,89,78,67,59,63,70,77,85,92,100,107,114,
	122,130,137,146,155,163,172,182,190,200,209,218,212,210,222,235,
	246,241,227,214,201,188,175,162,149,136,124,110,98,85,71,60,
	31,21,20,27,35,42,49,57,64,71,79,86,93,102,111,121,
	132,143,154,165,175,186,197,208,218,229,239,248,243,232,222,225,
	232,239,246,249,242,235,228,221,214,207,199,193,185,178,171,163,
	156,150,142,135,128,121,114,106,99,92,85,80,83,92,102,112,
	122,131,142,152,162,171,181,191,200,210,220,229,239,248,244,236,
	227,217,208,198,189,180,171,162,153,144,137,142,149,156,163,170,
	177,184,191,199,206,213,220,227,235,242,249,248,241,233,226,219,
	211,204,197,191,182,176,168,161,154,147,139,132,125,118,112,111,
	113,116,119,122,123,125,126,128,128,129,129,129,128,127,126,125,
	123,121,119,115,112,108,105,102,97,92,90,98,105,113,120,128,
	135,143,150,158,166,174,182,189,197,204,212,220,227,236,243,251,
	245,237,229,222,213,205,197,189,182,174,166,161,171,180,190,200,
	210,219,230,240,247,242,232,222,212,201,190,180,170,159,149,138,
	128,117,106,95,84,73,63,58,62,69,77,84,92,98,106,114,
	121,129,137,144,154,163,172,181,190,199,209,218,212,213,226,238,
	246,237,224,210,198,184,171,158,145,133,120,107,94,81,68,57,
	34,24,20,27,35,42,49,57,64,71,79,86,93,100,108,117,
	128,139,150,161,172,183,194,204,214,225,236,245,246,235,225,226,
	232,239,246,250,242,236,228,221,214,207,200,193,185,178,171,164,
	157,150,143,135,129,122,114,107,100,92,85,79,77,87,98,108,
	117,127,137,146,156,166,176,185,195,205,214,224,233,242,248,241,
	232,223,213,204,196,186,177,168,159,150,141,142,148,155,162,169,
	176,183,191,198,205,213,219,226,233,240,248,248,241,234,226,219,
	212,205,198,191,184,177,169,162,155,148,140,133,126,119,111,104,
	103,105,108,110,112,114,115,116,117,117,117,117,117,116,115,113,
	112,109,108,105,102,98,95,92,87,84,89,97,104,112,119,127,
	134,141,150,158,165,173,180,188,196,204,211,219,227,235,242,250,
	245,237,230,222,214,206,198,190,182,175,166,168,178,187,197,206,
	216,225,235,245,246,237,227,216,206,196,185,175,165,154,144,133,
	123,111,101,91,79,69,58,56,61,69,76,84,91,98,106,113,
	121,129,136,144,153,162,171,180,190,199,208,217,213,216,230,242,
	247,234,220,207,194,181,168,155,142,129,116,104,91,78,66,54,
	37,26,20,27,34,42,49,57,64,71,79,86,93,101,108,115,
	125,136,147,157,169,179,190,200,211,221,232,242,251,239,229,227,
	232,239,246,250,243,236,229,221,214,207,200,193,186,178,172,164,
	157,150,143,136,129,122,115,108,100,93,86,79,75,82,92,102,
	112,122,132,141,151,161,171,180,190,199,208,218,227,236,245,246,
	239,230,221,211,202,193,184,175,166,157,148,144,147,154,162,169,
	176,183,190,197,204,212,218,225,232,240,247,249,242,235,228,220,
	213,206,199,192,184,177,170,163,155,148,141,134,127,120,112,105,
	98,95,97,99,102,103,104,105,106,106,106,106,106,105,104,102,
	101,98,96,94,91,88,84,81,78,81,88,95,103,111,118,126,
	133,140,148,156,164,171,179,187,195,203,210,218,226,234,241,249,
	246,238,230,222,214,207,199,191,183,175,167,173,182,192,202,212,
	222,231,241,248,242,232,221,212,202,191,180,170,160,149,139,128,
	118,107,96,86,75,64,55,54,62,69,76,83,90,98,105,113,
	120,128,136,145,153,162,171,180,190,199,208,217,213,220,234,247,
	243,230,216,204,190,178,164,152,138,126,113,100,87,75,62,51,
	40,30,21,27,34,42,49,57,64,72,79,86,93,101,108,115,
	122,132,143,154,164,175,186,197,207,217,227,238,250,243,233,229,
	232,238,246,250,243,236,229,222,214,208,200,193,186,179,171,165,
	157,151,143,137,129,122,115,108,101,94,87,80,74,77,87,96,
	107,117,126,135,145,156,165,174,184,193,203,213,221,231,239,246,
	245,236,227,217,208,200,191,182,173,164,155,148,147,154,161,168,
	175,183,189,196,203,210,217,225,232,238,246,250,243,236,229,221,
	214,207,200,193,185,178,171,164,156,149,142,136,127,121,113,106,
	99,92,88,88,90,91,93,94,95,95,95,96,95,95,93,92,
	89,88,85,83,80,77,74,71,73,79,87,95,102,110,118,125,
	132,140,148,155,163,171,178,186,194,202,210,217,225,233,240,248,
	247,239,231,224,215,207,200,192,184,176,173,180,190,199,209,218,
	228,238,246,246,236,226,216,205,195,186,175,165,154,143,133,123,
	112,102,91,81,70,59,51,54,61,68,75,83,90,97,105,112,
	119,128,136,143,152,161,171,180,189,199,208,217,214,224,237,250,
	240,226,213,200,187,173,161,148,135,122,110,97,84,71,59,51,
	43,33,23,27,35,42,49,57,64,71,79,86,93,100,108,115,
	122,130,139,150,161,171,182,193,203,214,223,234,245,246,237,230,
	232,238,245,251,243,236,229,223,215,208,201,193,186,180,172,165,
	158,151,144,137,129,122,115,108,101,95,87,80,73,72,82,91,
	101,111,121,130,140,150,159,168,178,188,197,206,215,225,234,242,
	247,243,234,225,216,207,197,189,180,171,163,154,150,153,160,167,
	174,181,188,195,203,209,217,224,231,238,245,251,244,237,229,223,
	215,207,200,193,186,179,172,165,157,151,143,137,129,122,114,107,
	99,92,85,80,79,81,82,83,83,84,84,84,83,83,82,81,
	79,77,75,72,70,67,64,65,71,79,86,94,102,109,117,124,
	131,139,147,154,162,170,178,186,193,201,209,216,224,232,239,247,
	247,239,232,224,216,208,201,192,185,177,179,188,196,206,215,225,
	234,244,247,240,230,220,210,200,190,180,169,159,148,138,128,118,
	107,97,87,76,65,54,48,53,61,68,75,82,90,97,104,111,
	120,127,135,144,153,161,170,179,189,198,207,217,216,228,241,248,
	235,222,209,196,183,170,157,144,132,119,106,93,80,68,59,51,
	46,36,26,27,35,42,49,57,64,71,79,86,93,100,107,115,
	122,129,137,146,157,167,178,189,199,210,220,230,241,249,242,232,
	232,239,245,251,244,237,230,222,215,208,201,194,187,179,173,166,
	158,152,145,137,130,123,116,109,102,95,88,81,74,68,76,86,
	96,105,115,124,134,144,153,162,172,182,191,200,209,218,228,237,
	245,249,240,231,222,213,205,196,187,178,170,161,154,152,159,166,
	173,180,187,195,202,209,216,223,230,237,244,251,245,238,230,223,
	216,209,201,194,187,180,172,165,158,152,144,137,129,122,115,108,
	100,93,86,79,72,69,71,72,72,73,72,72,73,71,71,69,
	68,66,64,61,59,55,57,63,70,78,85,93,100,108,116,123,
	131,139,146,154,161,169,177,185,192,200,208,215,223,231,239,247,
	248,240,233,225,217,210,201,193,185,180,185,194,203,213,222,231,
	241,247,243,233,223,214,204,194,184,174,164,153,143,133,123,112,
	102,92,81,71,60,50,46,53,60,67,75,81,89,97,104,111,
	119,127,135,143,152,161,170,179,189,197,207,216,220,232,244,244,
	231,218,205,192,179,166,153,140,128,115,102,89,77,67,58,51,
	49,39,29,28,34,41,49,57,64,71,79,86,93,101,107,115,
	122,129,136,143,153,163,174,185,195,205,216,226,237,247,245,236,
	232,238,245,251,245,237,230,223,216,209,201,194,187,180,172,166,
	159,151,145,138,131,123,116,109,102,95,88,81,74,67,72,81,
	90,99,109,119,129,138,147,156,166,175,185,193,203,212,221,229,
	238,246,246,237,229,220,212,203,194,185,177,169,161,154,158,166,
	172,180,187,194,201,209,216,222,230,237,244,251,245,238,231,224,
	217,210,202,195,188,180,174,166,159,152,144,137,131,123,116,109,
	102,94,86,79,72,65,60,61,61,62,62,61,61,60,59,58,
	56,55,53,50,48,48,54,62,70,77,84,92,100,108,115,123,
	130,138,145,153,161,168,176,183,191,199,207,215,223,231,238,246,
	249,241,234,226,218,210,202,194,186,184,192,201,210,219,228,238,
	246,245,237,227,217,208,198,188,178,168,158,148,138,128,117,107,
	96,86,76,65,55,45,45,52,60,67,74,81,89,96,103,111,
	119,126,135,143,152,161,169,179,188,197,207,216,224,236,247,240,
	227,214,202,188,175,162,150,136,124,111,98,85,75,67,59,51,
	52,42,33,28,34,42,50,56,64,71,78,86,93,101,107,115,
	122,128,136,143,150,159,169,180,191,201,212,222,232,242,246,240,
	234,238,244,251,245,237,229,223,216,209,201,194,187,180,173,166,
	159,152,145,138,131,124,117,110,103,96,89,82,74,67,67,75,
	84,94,103,113,122,131,140,150,160,169,178,187,196,205,214,223,
	232,241,250,244,236,227,218,210,202,193,184,177,169,161,159,165,
	172,179,186,193,200,207,214,221,229,235,243,250,246,239,232,225,
	217,210,203,196,188,181,174,167,160,153,145,138,131,124,117,110,
	102,94,87,80,73,65,58,52,51,50,51,50,49,49,48,47,
	45,44,42,40,40,46,54,61,69,76,84,91,99,106,114,122,
	130,137,145,153,161,168,175,183,191,198,207,214,222,229,238,246,
	250,242,234,226,218,210,202,195,188,190,199,207,216,225,235,245,
	247,240,230,221,211,201,191,182,171,162,152,142,132,122,111,101,
	91,81,70,60,49,40,44,52,59,66,74,81,89,96,103,111,
	119,126,134,143,151,160,169,179,188,198,206,217,227,241,247,236,
	223,210,197,184,171,158,145,132,119,107,94,84,75,66,59,51,
	55,45,36,28,34,42,49,56,64,71,78,86,93,101,107,115,
	121,129,136,143,149,157,166,176,186,196,207,218,228,238,247,243,
	236,237,244,251,245,238,231,223,216,209,202,195,188,181,174,167,
	159,152,145,138,131,124,117,110,103,96,89,82,75,68,64,69,
	79,88,98,107,116,125,134,144,153,163,171,181,190,199,208,216,
	225,234,243,248,243,235,226,217,209,201,192,184,176,169,162,165,
	171,178,185,192,200,207,213,221,228,235,243,249,247,240,232,225,
	218,211,203,197,189,182,175,168,161,154,146,139,132,124,118,110,
	103,95,88,81,74,67,58,51,44,41,40,39,39,38,37,36,
	34,33,32,32,38,46,53,60,68,75,83,91,98,106,113,120,
	128,137,144,151,159,167,174,182,190,197,205,214,221,229,237,245,
	251,243,235,227,219,211,203,195,191,197,206,215,224,233,242,247,
	242,233,224,214,205,195,185,176,166,156,146,136,126,116,106,95,
	85,75,65,54,44,38,44,52,59,66,74,81,88,96,103,110,
	118,126,134,143,151,160,169,178,188,197,206,219,232,244,245,232,
	219,205,193,180,167,153,141,128,115,103,92,83,75,67,59,51,
	59,49,39,30,35,42,49,56,64,71,78,85,93,101,108,115,
	122,129,136,143,149,157,164,172,182,192,203,213,223,234,244,246,
	239,237,245,251,245,238,231,224,216,209,203,195,188,181,174,167,
	160,153,146,139,131,125,118,111,104,96,90,82,75,69,61,63,
	72,82,92,101,110,119,128,138,147,156,165,174,183,192,201,209,
	218,227,236,244,246,242,234,225,216,208,200,192,184,176,168,166,
	171,178,185,192,199,206,213,220,227,234,241,248,247,240,233,226,
	219,211,204,197,190,183,176,169,161,154,147,140,132,125,118,111,
	103,97,89,82,74,67,59,52,45,37,33,29,28,27,26,24,
	23,22,24,30,37,45,53,60,67,75,82,90,97,105,113,119,
	127,136,143,150,159,166,173,181,189,197,204,213,220,228,237,244,
	251,244,235,228,220,212,204,197,196,205,214,222,231,240,246,244,
	236,227,217,207,198,188,179,169,160,150,140,130,120,110,100,89,
	79,69,59,49,38,37,44,52,58,65,73,80,88,95,103,110,
	117,126,134,142,151,160,169,178,188,198,210,223,237,247,241,227,
	214,201,188,175,162,150,136,124,111,101,92,83,75,67,58,51,
	62,52,42,33,35,42,49,56,64,71,78,85,93,100,108,114,
	121,128,136,142,150,157,163,170,178,188,199,208,219,229,239,246,
	243,237,245,251,245,238,231,224,217,210,202,196,189,181,175,167,
	160,153,146,139,132,125,118,111,104,96,90,83,76,69,62,60,
	66,76,85,95,104,113,122,131,140,149,158,167,176,185,194,203,
	212,220,229,237,245,247,241,232,224,216,208,200,192,184,176,170,
	171,177,184,192,198,206,213,219,226,233,240,248,248,241,233,227,
	219,213,205,198,191,184,177,169,162,155,148,140,133,126,119,112,
	104,97,89,82,75,68,61,54,46,39,31,24,19,16,15,13,
	12,15,22,29,36,44,51,59,66,75,81,89,97,105,112,119,
	127,135,142,150,158,165,173,180,188,196,204,212,220,228,236,243,
	251,244,236,228,221,212,204,198,204,213,221,230,238,245,245,237,
	228,219,210,201,191,181,172,163,153,144,134,124,114,104,94,84,
	74,63,53,43,33,36,43,51,58,65,72,80,87,95,102,110,
	118,125,133,142,151,160,169,178,188,201,214,227,241,248,236,223,
	210,197,183,171,158,145,132,120,109,100,92,83,75,67,59,51,
	65,55,46,37,36,42,49,57,64,71,78,86,93,100,107,114,
	121,129,136,143,150,156,163,170,177,184,194,204,214,224,235,244,
	247,240,245,251,245,238,231,224,217,210,203,196,189,182,175,168,
	161,154,147,139,132,125,118,111,104,97,90,83,76,69,62,58,
	60,69,79,87,97,106,116,125,134,142,151,160,169,178,187,196,
	204,212,221,230,238,245,247,240,232,224,216,208,200,193,185,177,
	174,176,183,191,198,205,211,219,226,233,240,247,249,241,234,228,
	220,214,206,199,192,184,177,170,163,156,149,141,134,127,120,112,
	105,97,91,83,76,69,61,54,46,39,32,24,17,10,4,3,
	6,13,21,28,36,44,50,58,66,74,81,89,96,104,111,119,
	127,135,142,149,157,165,172,180,188,196,203,211,219,227,235,242,
	250,245,237,229,222,213,204,203,212,220,229,237,245,246,239,230,
	221,213,203,194,185,175,166,156,146,137,127,118,108,98,88,78,
	68,57,47,37,31,35,43,50,57,65,72,80,87,94,102,109,
	117,125,133,142,150,159,169,180,193,206,219,232,246,244,231,218,
	205,192,179,166,154,141,128,117,108,99,92,83,75,67,59,51,
	69,59,49,40,36,42,49,57,64,71,79,85,93,101,108,114,
	122,129,136,142,149,156,163,170,177,183,191,199,209,220,230,241,
	248,243,244,251,246,238,231,224,217,210,203,196,189,181,175,168,
	161,154,147,140,133,126,119,112,105,97,90,83,77,69,62,56,
	55,63,73,81,91,100,109,118,127,136,145,154,163,171,180,188,
	197,206,214,222,230,239,245,247,240,232,224,216,208,201,193,186,
	179,176,182,190,197,204,211,218,225,232,239,247,249,242,235,228,
	221,214,206,199,192,185,178,171,164,157,149,142,135,128,121,113,
	106,98,91,84,77,69,62,55,47,40,33,25,17,10,4,3,
	6,13,20,27,35,42,50,58,65,72,80,87,95,103,110,118,
	125,133,141,148,156,164,171,179,187,195,203,210,219,227,234,242,
	250,245,238,230,222,214,206,211,219,228,237,245,247,241,232,223,
	214,205,196,187,178,168,159,150,140,130,120,111,102,92,81,72,
	61,51,41,31,29,36,42,50,57,64,72,79,87,94,101,109,
	116,124,133,141,150,160,171,185,198,211,224,237,248,240,227,214,
	201,188,175,162,150,136,126,117,108,100,91,83,75,66,59,51,
	72,62,53,43,36,42,49,57,64,71,78,85,93,101,108,115,
	122,129,136,142,149,156,163,170,177,183,190,197,206,215,225,236,
	244,247,244,251,246,239,231,225,218,210,204,196,189,182,174,168,
	161,154,146,140,133,127,119,112,105,98,91,84,77,70,63,56,
	51,56,66,75,85,93,102,111,120,129,138,147,156,164,173,182,
	190,198,206,215,223,231,239,247,247,240,232,224,216,209,201,194,
	187,181,183,189,196,203,210,217,225,232,239,246,250,243,236,229,
	222,214,207,200,193,186,179,171,164,157,149,143,135,128,121,114,
	106,99,92,84,77,70,63,55,48,41,33,26,18,13,12,12,
	14,16,21,27,34,41,50,57,65,72,79,86,94,102,110,118,
	125,132,140,148,156,163,171,179,186,195,202,210,218,226,233,242,
	249,246,238,230,223,215,212,219,227,236,244,249,242,234,225,215,
	207,198,189,180,171,161,152,143,133,124,114,104,95,85,75,65,
	55,45,35,27,28,35,42,50,56,65,72,79,87,94,101,109,
	117,124,133,142,151,164,176,190,203,216,229,242,246,235,222,209,
	196,183,170,158,145,134,125,117,108,100,91,83,75,67,58,51,
	75,66,57,47,38,43,49,57,64,71,78,86,93,101,108,115,
	122,128,136,143,150,157,163,170,177,183,190,197,204,211,220,230,
	241,250,244,250,246,239,231,224,218,211,204,196,189,183,175,168,
	162,154,147,140,133,127,120,112,105,99,92,84,78,71,63,56,
	50,50,59,69,78,87,96,104,113,122,131,139,148,157,165,173,
	182,191,199,208,216,224,232,240,247,246,240,233,225,217,210,203,
	195,188,183,189,196,202,210,217,224,231,238,245,251,243,236,229,
	222,215,208,201,194,186,179,172,165,157,151,143,136,128,121,114,
	107,100,92,85,78,70,63,56,49,42,34,27,24,23,24,24,
	26,27,29,32,36,42,49,56,63,71,79,86,94,101,109,117,
	124,132,140,147,155,163,171,178,186,194,201,209,217,225,233,241,
	249,247,239,231,223,217,220,227,235,244,250,243,234,226,217,208,
	199,191,182,173,164,154,145,136,126,117,107,98,88,79,69,59,
	49,39,29,24,27,34,42,49,57,64,71,79,87,94,102,109,
	117,124,133,144,156,169,182,194,208,221,234,245,243,230,218,204,
	191,178,166,153,143,134,126,116,108,100,91,83,75,67,59,51,
	79,70,60,50,41,42,49,57,64,71,78,85,93,100,108,114,
	121,129,135,142,150,156,163,170,177,184,190,197,204,210,217,225,
	235,245,247,251,246,238,232,225,218,210,203,197,190,183,176,169,
	161,154,147,141,134,127,119,113,106,98,91,84,78,71,64,57,
	50,45,53,62,70,79,88,97,106,115,124,133,141,150,158,166,
	175,183,192,199,207,216,223,232,239,246,246,241,233,226,218,211,
	204,198,190,189,195,202,209,216,223,230,237,244,251,244,237,230,
	223,216,209,201,194,187,180,173,165,158,152,144,137,130,123,115,
	108,100,93,86,79,72,64,57,49,42,36,33,33,34,35,36,
	37,39,40,42,44,48,51,56,63,70,78,86,93,101,108,116,
	124,132,140,147,154,162,170,178,186,194,201,209,217,225,232,240,
	248,247,239,231,223,221,227,235,243,248,243,235,226,218,210,201,
	192,184,175,166,157,147,138,129,120,110,101,91,81,72,62,52,
	43,33,24,21,27,35,42,49,57,63,71,79,86,93,101,108,
	116,125,136,149,161,174,187,199,213,226,239,247,238,225,212,199,
	187,173,162,152,143,134,125,117,108,100,91,83,75,66,59,52,
	83,73,63,54,45,43,49,57,64,72,79,85,92,100,107,115,
	122,128,136,142,149,156,163,170,177,184,190,197,203,210,216,223,
	231,241,250,251,246,239,232,225,218,211,204,197,190,183,175,169,
	162,155,148,141,134,127,120,113,106,99,92,85,78,71,64,57,
	50,43,47,55,64,73,81,90,99,108,117,125,134,142,151,159,
	167,175,184,191,199,208,215,223,231,238,245,246,241,234,227,219,
	213,206,199,192,195,201,208,216,223,229,237,244,251,244,238,231,
	223,216,209,202,195,188,180,174,166,159,152,145,137,130,122,115,
	108,101,94,86,79,72,65,57,50,45,44,45,44,45,46,47,
	48,49,51,53,55,58,61,63,66,71,78,85,93,100,108,116,
	124,131,139,146,153,161,170,177,185,192,200,208,216,224,232,240,
	248,248,240,232,226,228,236,244,247,243,235,226,218,211,202,193,
	184,176,167,158,149,140,131,122,113,103,94,84,74,65,56,46,
	36,27,19,20,27,34,41,49,56,64,72,78,86,93,101,109,
	119,130,142,154,167,179,192,205,218,231,244,246,233,219,207,194,
	182,170,160,152,143,134,125,117,108,99,91,83,75,67,58,51,
	87,77,68,58,49,44,49,57,64,71,78,86,93,100,107,115,
	122,129,136,143,149,156,163,170,177,183,190,197,203,210,217,223,
	230,236,245,251,247,239,232,225,218,211,204,197,190,183,176,169,
	162,155,148,141,134,127,120,113,107,100,93,85,78,71,64,57,
	50,43,41,48,57,66,74,83,92,100,109,118,126,134,143,151,
	159,168,176,184,192,200,207,215,222,230,238,244,247,243,236,229,
	222,215,208,201,198,201,208,215,222,229,237,244,251,245,238,231,
	224,217,210,203,196,189,181,174,167,159,152,145,138,131,123,116,
	109,102,94,87,80,72,65,58,56,56,56,56,55,56,57,58,
	60,61,62,64,66,69,71,74,76,79,83,88,94,100,107,115,
	122,130,138,146,153,161,169,177,184,192,199,207,216,223,231,239,
	247,248,241,233,231,237,244,247,242,235,227,218,211,202,194,185,
	177,168,160,151,142,133,124,115,106,96,87,77,68,58,49,39,
	30,20,14,19,27,34,41,49,56,64,71,78,86,94,104,114,
	124,136,147,160,172,185,198,211,223,236,248,240,227,215,202,190,
	179,169,161,152,143,134,125,116,108,99,92,83,76,67,58,52,
	90,81,71,62,53,45,49,57,64,71,79,85,93,100,108,114,
	121,128,136,143,150,156,163,170,176,183,191,197,203,210,217,224,
	230,236,243,250,247,239,232,225,218,211,204,197,190,184,176,169,
	163,156,148,141,134,127,120,113,106,100,93,86,78,71,64,58,
	51,43,38,42,50,58,67,76,84,93,102,110,119,127,135,143,
	151,160,168,176,183,191,199,207,215,222,229,237,244,247,244,238,
	231,224,217,211,204,203,208,214,222,229,236,243,250,246,239,231,
	224,217,210,203,196,189,181,175,167,160,153,146,139,131,124,117,
	109,102,95,88,80,73,70,68,68,67,67,67,67,67,68,69,
	71,72,74,75,77,80,82,84,87,91,94,97,101,105,110,116,
	122,130,137,145,152,160,168,176,184,192,199,207,215,223,231,238,
	246,248,240,235,239,245,247,242,234,226,219,211,203,195,186,177,
	169,160,152,143,134,125,116,107,98,89,80,71,61,52,43,33,
	23,14,12,19,26,34,41,48,56,63,71,80,90,99,110,120,
	130,141,153,165,177,190,203,216,228,242,247,235,222,210,198,188,
	179,169,160,151,143,134,126,116,108,100,92,83,75,67,59,51,
	94,84,75,66,57,48,50,56,64,71,79,86,93,100,108,115,
	121,128,136,143,150,156,163,170,177,183,190,197,203,210,216,223,
	229,236,243,250,248,241,233,225,218,212,205,197,190,184,176,169,
	162,155,149,142,134,127,120,114,107,100,93,86,79,72,64,58,
	51,44,37,37,43,52,60,69,77,85,94,103,111,119,127,135,
	144,152,160,168,175,184,191,199,206,214,221,228,236,242,247,246,
	240,233,227,220,213,208,207,214,221,228,236,243,250,246,239,232,
	225,218,211,203,197,189,182,175,168,160,154,146,139,132,125,117,
	110,103,96,88,84,81,80,79,79,78,78,78,78,79,80,81,
	81,83,85,87,88,90,93,96,99,102,105,108,112,116,119,123,
	129,133,138,146,153,160,168,175,183,191,199,207,215,222,230,238,
	246,249,241,240,246,246,241,234,226,219,210,203,195,187,178,169,
	161,152,144,135,127,118,109,100,91,82,73,64,55,45,36,26,
	16,9,11,19,26,34,41,49,57,66,75,85,96,105,115,126,
	136,147,159,170,184,196,209,222,234,246,242,230,217,207,197,188,
	179,169,160,151,143,134,126,117,108,100,91,83,75,67,59,51,
	98,89,80,70,61,52,50,56,64,71,79,86,93,100,107,115,
	122,128,136,143,150,156,163,170,177,183,190,197,203,209,216,223,
	229,235,243,250,251,245,236,227,218,212,204,198,190,183,177,170,
	163,156,149,142,135,127,120,114,107,100,93,86,79,72,65,58,
	51,44,37,32,36,44,53,61,70,78,87,95,103,111,119,128,
	136,144,152,160,167,175,182,190,198,205,213,220,227,234,241,246,
	247,242,235,229,223,217,212,214,221,227,235,242,249,247,240,233,
	226,218,211,204,197,190,183,176,168,161,154,147,140,132,126,118,
	110,104,99,94,93,92,91,91,90,90,89,89,90,90,91,92,
	93,94,96,97,99,102,104,107,109,112,116,119,122,126,130,134,
	139,143,147,152,157,163,170,176,183,191,199,207,214,222,230,238,
	246,249,245,247,247,240,233,225,217,210,202,194,186,178,170,162,
	153,145,137,128,119,110,101,93,84,75,65,56,47,38,28,19,
	9,4,11,19,26,35,43,52,61,71,81,91,102,111,122,132,
	142,153,165,176,189,202,214,227,240,246,237,226,215,206,196,187,
	178,169,160,152,143,134,125,117,108,100,91,83,75,66,59,51,
	103,93,83,74,65,56,51,57,64,72,79,86,93,100,107,115,
	122,128,136,143,150,156,163,170,177,183,190,197,203,210,216,223,
	229,235,243,250,248,246,241,232,222,213,205,198,190,184,177,170,
	163,156,149,142,135,128,121,114,107,100,94,86,79,73,65,58,
	51,44,37,31,30,37,46,54,62,71,79,87,96,104,112,120,
	128,135,144,151,159,166,174,182,189,196,204,211,217,224,231,238,
	245,247,245,239,232,226,220,215,221,228,235,242,249,247,240,233,
	226,220,212,204,198,190,183,176,169,162,154,147,140,133,126,119,
	113,110,107,106,105,104,103,102,101,100,101,101,101,101,102,103,
	104,105,107,108,111,113,115,117,120,123,126,130,133,137,141,144,
	149,152,158,163,167,172,177,183,188,194,199,207,215,223,230,238,
	245,251,249,246,238,231,224,216,209,201,193,186,178,170,162,153,
	146,137,129,120,112,103,94,85,77,67,58,49,40,30,21,11,
	2,4,12,21,29,38,48,58,68,78,88,98,108,117,128,138,
	148,159,170,183,195,208,220,233,246,244,231,221,215,206,196,187,
	178,169,160,152,143,134,125,117,108,100,91,83,75,67,59,51,
	107,97,87,78,69,60,52,57,64,71,79,86,93,100,107,115,
	122,129,136,143,150,157,163,170,177,184,190,197,204,210,216,223,
	229,235,243,250,246,247,247,238,228,218,209,200,192,184,177,170,
	163,156,149,142,135,128,121,114,107,100,93,86,79,72,65,59,
	52,45,38,31,27,29,38,47,55,63,72,80,88,96,104,112,
	120,127,136,143,151,158,166,173,180,188,195,202,209,215,222,229,
	236,243,248,247,241,236,230,223,222,227,235,241,248,248,241,234,
	226,219,212,205,198,191,183,176,169,162,155,148,141,133,127,124,
	122,121,119,117,116,115,114,113,112,113,112,112,112,113,114,114,
	116,117,118,120,122,124,126,129,131,135,137,140,144,148,152,155,
	159,164,168,172,178,183,187,193,198,203,209,216,221,227,233,241,
	248,250,243,237,230,223,216,208,200,193,185,177,169,161,154,146,
	138,129,121,112,104,95,86,77,69,60,51,41,32,23,14,5,
	0,7,16,26,35,45,55,64,74,84,94,104,114,124,134,144,
	155,165,176,189,201,214,226,239,248,239,226,217,216,205,197,187,
	179,169,160,152,143,134,125,117,108,99,92,83,75,67,59,51,
	110,101,92,83,74,65,56,57,64,72,79,86,94,101,107,115,
	122,129,137,142,149,157,164,170,177,183,190,197,204,210,217,223,
	229,235,242,249,246,245,247,243,233,224,214,205,196,187,178,170,
	163,157,149,142,135,129,121,114,107,100,93,86,80,72,65,58,
	52,45,39,31,24,23,31,39,47,55,64,72,80,88,95,104,
	112,119,127,134,142,150,157,165,172,179,186,193,200,207,214,220,
	227,234,240,246,249,245,239,234,228,228,234,241,248,248,241,234,
	227,220,212,206,198,191,184,177,169,163,156,149,144,140,138,135,
	133,131,130,129,127,126,125,124,124,123,123,123,124,124,125,126,
	127,128,129,131,133,136,137,140,142,145,149,151,155,158,163,166,
	170,173,179,183,188,192,198,202,208,213,219,225,231,236,243,246,
	247,250,242,235,227,219,211,203,195,187,180,172,164,155,147,138,
	130,122,115,106,98,90,82,73,65,56,48,39,30,22,13,5,
	5,14,23,33,42,52,61,71,81,91,101,110,120,131,140,150,
	161,172,183,195,207,220,232,245,245,233,220,215,216,205,197,187,
	178,169,160,152,142,134,125,117,108,99,92,83,75,67,59,51,
	114,105,96,87,79,69,60,58,65,72,79,86,93,100,107,115,
	122,128,136,143,150,157,164,170,177,184,190,197,204,210,216,223,
	229,236,242,249,246,241,244,247,240,231,220,212,202,193,183,174,
	164,156,149,142,135,128,122,115,108,100,93,87,80,73,65,58,
	52,45,38,31,24,21,23,31,39,48,56,63,71,79,87,96,
	104,112,118,126,133,141,148,155,163,170,177,183,191,197,204,211,
	217,224,230,235,242,248,247,243,238,233,235,240,247,248,241,235,
	227,220,213,205,198,191,185,177,171,165,161,157,154,151,149,147,
	145,143,141,140,139,137,136,136,135,135,135,135,135,136,136,137,
	139,140,140,143,145,147,148,150,153,156,159,162,166,169,173,176,
	181,185,189,193,198,203,208,212,218,224,229,235,240,245,248,244,
	244,251,243,235,227,219,210,202,195,187,178,170,162,154,146,138,
	130,122,114,105,97,88,81,72,64,56,47,39,31,22,14,6,
	13,21,31,40,50,59,69,78,88,98,107,117,127,137,147,157,
	167,178,189,201,213,225,238,247,239,227,214,215,215,205,196,187,
	178,169,160,151,142,134,125,117,108,99,92,83,75,66,59,51,
	119,109,100,91,82,74,64,59,65,71,79,86,93,100,108,115,
	122,129,136,143,150,157,163,170,177,183,190,197,204,210,216,223,
	229,236,242,249,246,239,239,246,247,237,227,218,209,199,190,181,
	171,162,153,144,135,128,122,115,108,101,94,87,80,73,66,59,
	52,46,39,32,25,19,15,23,32,40,48,56,63,72,80,87,
	95,103,110,118,125,132,139,147,154,161,167,174,182,189,195,201,
	208,214,221,227,233,239,245,247,246,242,239,241,247,249,242,235,
	228,220,214,207,199,193,186,181,177,173,171,168,164,162,160,158,
	156,154,153,151,150,149,148,147,147,147,147,147,146,147,148,148,
	149,151,152,154,156,158,160,162,164,168,170,173,176,180,183,187,
	191,195,200,204,208,213,218,223,228,234,239,245,249,247,241,238,
	244,251,243,235,227,219,211,203,195,187,178,171,163,155,147,138,
	130,122,114,105,98,89,81,73,64,56,48,39,31,22,14,12,
	19,28,38,47,56,66,76,85,95,104,114,124,133,143,154,163,
	173,184,195,207,219,232,243,245,233,221,208,215,215,205,196,187,
	178,169,160,151,143,134,125,116,108,99,92,82,75,67,59,51,
	123,114,105,95,87,78,69,61,64,71,79,86,93,100,108,115,
	122,129,136,143,150,157,163,170,177,183,190,197,203,210,217,223,
	229,236,243,249,246,239,236,241,248,244,234,225,215,205,197,187,
	178,169,159,151,141,133,124,115,108,101,94,87,80,73,66,59,
	52,46,39,31,25,18,12,16,24,32,40,48,56,64,72,79,
	87,95,102,109,116,123,131,138,146,153,160,166,172,179,186,192,
	198,204,211,217,223,229,235,240,245,247,245,244,247,249,242,235,
	228,222,215,207,201,198,194,191,187,185,182,178,176,173,171,169,
	167,165,164,162,161,160,159,158,157,158,158,158,157,158,159,160,
	161,162,164,165,167,169,171,174,175,178,181,184,187,190,194,198,
	202,206,210,214,219,224,229,233,238,244,248,247,243,236,232,236,
	244,251,243,236,228,219,212,204,195,187,179,171,163,155,147,138,
	131,122,113,105,97,88,81,73,64,56,48,39,31,23,15,18,
	27,36,44,54,64,73,82,92,102,111,121,130,140,150,160,170,
	180,191,202,213,225,238,247,240,227,215,207,215,215,205,196,187,
	178,169,160,151,143,134,125,116,108,99,92,83,75,66,58,51,
	127,118,109,100,91,82,73,64,65,71,79,86,93,100,108,115,
	122,129,136,143,150,157,163,170,177,184,190,197,203,210,216,223,
	230,236,243,250,246,240,234,235,244,249,241,230,221,212,203,194,
	185,176,167,157,148,139,130,122,113,105,96,88,81,73,66,60,
	53,46,39,32,25,18,11,8,15,24,32,39,47,55,63,71,
	78,86,93,100,107,115,122,129,137,143,150,156,163,170,177,183,
	189,195,201,207,213,219,224,230,235,241,245,247,249,249,242,236,
	229,225,220,216,212,209,205,201,198,195,192,189,187,184,183,180,
	178,176,175,174,172,171,171,170,170,169,169,169,169,170,170,171,
	172,173,175,176,178,180,182,185,187,190,191,195,198,201,205,209,
	212,216,220,225,229,234,238,244,246,246,244,238,232,227,227,236,
	243,251,243,236,228,220,212,204,195,187,179,171,163,155,147,139,
	131,123,114,106,98,89,81,72,64,56,48,39,31,23,19,25,
	34,44,52,62,71,80,89,99,108,118,127,136,147,157,167,176,
	187,197,208,220,232,244,247,234,222,209,206,215,215,206,196,187,
	178,169,160,151,142,133,125,116,108,99,91,83,75,66,59,51,
	132,123,114,105,96,87,78,69,66,71,79,86,93,101,108,115,
	121,129,136,143,149,157,164,170,176,183,190,197,204,211,217,223,
	230,236,243,250,246,240,233,231,238,246,246,237,228,219,210,201,
	192,182,173,164,155,147,137,129,120,111,102,94,85,77,68,61,
	54,47,39,32,25,18,11,4,8,16,24,32,39,47,55,62,
	69,77,84,92,99,106,113,120,127,134,141,148,154,160,167,173,
	179,185,192,197,204,209,215,220,225,231,236,242,247,251,248,243,
	239,235,231,227,223,220,216,212,209,206,204,201,198,196,193,192,
	190,188,186,185,184,182,182,181,180,181,180,180,181,181,181,182,
	183,184,185,188,189,191,193,195,198,200,204,206,209,212,216,220,
	224,227,231,235,240,243,246,247,244,239,234,228,223,221,228,236,
	243,251,243,236,227,220,212,203,195,187,179,171,163,155,147,138,
	130,123,114,106,98,90,81,72,64,56,48,39,31,23,24,32,
	41,50,60,69,78,87,97,106,116,125,135,144,154,164,174,184,
	194,204,215,226,238,250,239,227,215,204,205,215,215,205,196,187,
	178,169,160,151,142,133,124,116,108,100,90,83,75,67,59,51,
	137,127,118,109,100,91,82,73,67,71,79,86,93,100,108,115,
	122,129,136,143,150,157,164,170,177,184,190,197,203,210,216,223,
	230,236,243,250,247,240,233,229,232,241,250,244,235,225,216,207,
	198,189,180,171,162,153,145,136,127,118,110,101,92,84,76,67,
	59,51,42,34,27,20,12,5,2,8,15,23,31,39,46,54,
	60,69,76,83,91,98,104,111,118,125,132,138,145,151,158,164,
	170,176,182,189,195,200,207,212,219,225,232,239,246,250,245,248,
	249,245,241,238,234,230,227,223,220,217,214,212,209,207,205,203,
	201,199,198,196,195,194,193,192,192,192,192,191,192,193,193,194,
	195,195,196,198,201,202,205,206,209,211,215,217,220,223,227,230,
	234,238,242,246,249,248,243,239,234,229,223,218,215,219,227,235,
	243,251,244,236,228,220,212,204,195,187,179,172,163,155,147,139,
	131,123,114,106,98,90,81,73,64,56,48,39,31,26,31,40,
	49,57,67,76,85,94,104,113,122,132,142,151,161,170,180,190,
	200,210,221,233,245,245,233,221,209,200,205,215,215,205,197,187,
	178,169,160,151,142,133,124,116,108,100,91,83,74,67,59,56,
	141,131,122,114,105,96,87,78,70,72,79,86,93,100,108,115,
	122,129,137,143,150,157,164,171,178,184,190,197,203,210,216,223,
	230,236,243,250,246,240,233,226,225,234,244,249,241,232,223,214,
	205,196,187,179,169,161,152,143,134,125,117,109,100,91,83,75,
	66,58,50,42,34,25,18,9,1,3,9,17,24,31,38,46,
	53,60,68,75,82,89,95,102,109,116,124,130,136,143,150,156,
	163,169,175,183,189,197,203,210,217,225,231,238,246,250,243,239,
	243,248,248,246,244,241,238,235,231,228,225,223,221,218,216,214,
	212,210,209,208,207,206,205,204,204,203,203,203,204,204,204,205,
	206,208,208,210,212,213,215,218,220,222,225,228,231,234,238,241,
	245,247,247,246,242,238,233,228,224,219,214,208,211,219,226,234,
	243,251,244,236,228,220,212,204,196,188,180,172,163,155,147,139,
	131,123,114,107,98,90,81,73,65,56,48,39,32,32,39,48,
	57,65,75,84,93,102,111,120,130,139,149,159,168,177,187,197,
	207,217,228,240,247,239,227,214,202,197,206,215,214,205,196,187,
	178,169,160,151,142,133,124,116,108,99,91,83,75,67,59,62,
	145,136,127,118,109,101,92,83,74,73,79,86,94,101,108,115,
	122,129,137,143,151,158,164,170,178,184,191,197,204,210,217,223,
	230,236,243,250,246,239,232,226,222,227,237,246,247,239,230,221,
	212,203,194,186,176,168,159,150,142,133,124,116,107,99,91,83,
	74,65,57,50,42,33,26,18,9,6,9,16,23,30,37,43,
	50,58,64,71,78,85,92,99,106,113,119,127,134,141,148,155,
	161,168,175,182,190,196,203,210,218,225,232,239,246,250,243,237,
	234,236,240,244,247,247,246,245,242,239,237,234,231,230,227,225,
	223,222,220,219,218,217,216,215,215,214,214,214,215,215,216,217,
	218,219,220,221,223,225,226,229,231,234,236,238,241,244,245,246,
	246,244,240,236,232,227,223,218,213,208,203,204,211,219,227,235,
	243,251,245,236,228,220,212,204,196,188,180,172,163,155,147,139,
	131,123,114,106,97,90,81,73,64,56,48,40,34,38,47,56,
	64,73,82,91,100,110,119,128,137,147,156,165,175,185,194,203,
	214,224,235,245,244,233,221,208,196,197,206,215,214,206,196,187,
	177,169,159,151,142,133,125,116,108,100,91,82,74,67,59,66,
	150,141,132,123,114,105,97,87,78,75,79,87,94,101,108,115,
	122,129,137,143,151,157,164,171,177,185,191,197,204,210,217,223,
	230,236,244,250,246,239,232,225,220,220,230,239,247,245,237,228,
	219,210,201,193,184,175,166,158,149,141,132,124,115,107,99,90,
	82,74,66,58,49,42,34,26,18,10,10,16,23,30,37,44,
	50,57,64,71,78,85,92,99,106,113,119,127,133,140,147,154,
	161,168,175,182,190,196,203,210,217,224,231,238,245,251,244,236,
	229,227,229,233,237,240,243,245,246,248,248,245,242,240,238,236,
	235,233,231,230,229,228,228,227,226,226,226,226,226,227,227,228,
	229,230,231,232,234,236,238,240,242,245,247,250,249,247,244,240,
	237,233,229,225,221,217,213,208,203,198,197,203,211,219,227,235,
	243,251,245,237,228,221,213,204,196,188,180,172,164,155,147,139,
	131,123,114,106,98,89,81,73,65,56,48,40,39,46,55,64,
	72,81,90,99,108,117,126,135,144,154,163,172,182,192,201,211,
	221,231,241,247,238,226,214,201,191,196,206,215,215,205,196,187,
	177,169,159,151,142,133,125,116,108,99,91,83,75,67,62,71,
	155,145,136,128,118,110,101,92,84,77,80,87,94,101,108,115,
	123,129,136,144,150,157,164,171,178,185,191,197,204,210,217,224,
	230,237,243,250,246,239,232,225,219,215,223,232,241,248,244,235,
	226,217,209,200,191,182,173,165,157,148,140,131,123,114,106,98,
	90,82,74,66,58,50,42,34,26,19,14,16,22,29,37,44,
	50,57,64,71,78,85,92,99,105,113,119,126,133,140,147,154,
	161,168,175,182,189,196,203,210,217,224,231,238,245,251,244,236,
	229,222,220,222,226,229,232,235,238,241,243,246,248,250,248,246,
	245,244,243,242,240,239,238,238,238,238,237,238,237,238,238,240,
	241,242,243,243,244,245,245,246,246,245,244,241,239,236,233,230,
	226,222,218,214,210,206,201,197,192,190,195,203,211,220,226,235,
	243,251,244,237,228,221,213,204,196,188,180,172,164,156,147,139,
	131,122,114,106,98,90,81,73,64,56,48,43,46,54,63,71,
	80,89,98,107,116,125,134,142,152,161,171,180,189,198,208,218,
	228,238,248,243,231,219,207,195,188,196,206,215,215,205,196,187,
	177,168,160,151,142,133,125,116,108,99,91,83,75,66,66,76,
	159,149,141,132,124,115,106,97,89,80,80,87,94,102,109,116,
	123,130,137,143,150,158,164,171,178,185,192,198,204,210,217,224,
	230,237,244,250,246,239,231,225,218,213,216,225,234,243,247,243,
	234,225,216,207,199,190,181,173,164,156,148,139,131,122,114,105,
	98,90,82,74,66,58,50,42,35,27,20,18,22,29,36,43,
	51,57,64,71,78,85,92,98,105,112,120,126,133,140,147,154,
	161,168,175,182,189,196,203,210,218,224,231,238,245,251,244,237,
	230,223,215,213,215,218,221,224,227,230,233,235,238,240,242,244,
	246,246,246,246,246,247,249,249,248,247,246,246,245,246,246,248,
	248,249,249,247,247,245,243,240,238,236,233,231,227,225,222,219,
	215,211,207,204,199,195,191,186,184,187,195,203,211,219,226,235,
	242,251,244,236,229,220,213,204,196,188,179,171,163,155,147,139,
	131,122,114,106,98,90,81,73,64,56,48,46,54,62,71,79,
	88,97,106,114,124,133,141,150,159,169,178,187,196,206,216,225,
	235,245,247,236,224,212,200,188,188,197,206,216,215,205,196,186,
	177,168,160,151,142,133,125,116,107,99,91,83,75,67,70,80,
	164,154,146,137,129,119,111,102,94,85,82,87,94,101,108,116,
	123,130,137,143,151,157,164,171,178,184,191,197,204,211,217,223,
	230,237,244,250,246,239,231,225,218,212,209,218,227,236,245,247,
	241,232,223,215,205,197,189,180,172,164,155,147,138,130,122,114,
	106,98,90,82,74,66,59,51,43,36,28,22,23,29,36,43,
	50,57,64,70,78,85,91,99,105,112,120,126,133,140,147,154,
	161,168,175,181,189,196,203,210,217,224,231,238,245,251,244,237,
	230,223,216,209,206,208,210,213,216,219,221,224,226,229,231,233,
	234,236,237,239,240,240,241,242,242,243,243,243,242,242,242,241,
	240,239,238,236,235,233,231,229,227,225,223,220,217,214,210,207,
	204,200,196,193,189,185,181,177,180,187,195,203,211,219,227,235,
	242,251,244,236,229,220,212,204,196,188,180,172,163,155,147,139,
	131,123,114,106,98,90,81,73,65,56,50,54,62,71,79,87,
	96,105,114,122,131,140,149,158,167,176,185,195,204,213,223,233,
	242,248,240,229,217,206,194,182,188,197,207,216,214,204,195,186,
	177,168,159,150,141,133,124,116,107,99,91,83,74,69,75,86,
	169,160,151,142,133,124,116,107,98,90,84,86,93,101,108,115,
	122,130,137,144,151,157,164,171,178,185,191,198,205,211,218,224,
	230,237,243,250,246,239,232,225,218,212,206,211,219,228,237,246,
	248,240,230,221,213,205,196,188,179,171,163,155,146,138,131,122,
	114,106,98,90,82,75,67,59,52,44,37,29,26,29,36,43,
	50,57,64,70,78,85,92,99,105,112,119,126,133,140,147,153,
	161,168,175,182,189,196,203,210,217,224,231,238,245,251,245,237,
	230,223,216,209,202,199,199,203,205,209,211,213,215,217,220,222,
	223,224,226,227,228,229,230,230,230,231,232,232,231,231,230,229,
	228,228,226,225,223,222,220,218,216,213,211,208,206,203,200,197,
	193,189,186,182,178,174,170,172,180,187,195,203,211,219,227,234,
	242,251,245,237,229,220,212,204,196,188,179,171,164,155,147,139,
	131,123,114,106,97,90,81,72,65,57,55,62,70,79,88,96,
	105,113,121,130,139,148,157,165,175,184,193,202,212,221,230,240,
	247,244,233,222,210,199,186,179,187,197,206,216,214,204,195,186,
	177,168,159,151,142,133,124,116,107,99,91,83,75,72,81,90,
	174,165,156,147,138,129,120,112,104,95,87,87,94,101,108,116,
	123,130,137,144,151,158,164,172,179,185,191,198,204,211,218,225,
	231,238,244,251,245,238,232,225,218,211,204,204,212,221,230,239,
	246,246,238,230,221,212,205,196,187,179,171,163,154,146,138,130,
	122,114,106,99,90,83,76,68,61,53,46,39,32,30,36,44,
	50,57,64,70,78,85,92,98,105,112,119,126,133,140,147,154,
	161,168,175,182,189,196,203,210,216,224,231,238,245,251,244,237,
	229,223,216,209,201,195,192,192,194,197,200,202,204,206,208,210,
	212,213,214,216,217,218,218,219,220,220,220,219,220,220,219,218,
	217,216,214,213,212,210,209,206,204,202,199,197,195,192,189,186,
	182,179,175,171,167,163,165,171,179,188,195,203,211,219,227,235,
	243,251,244,236,228,220,212,203,195,188,180,171,164,156,147,138,
	130,122,114,106,97,89,81,72,64,59,63,71,79,87,95,104,
	112,121,129,138,147,156,164,174,182,191,200,210,219,228,237,246,
	245,237,226,215,203,191,180,178,188,197,206,217,213,204,195,186,
	177,168,159,150,142,133,124,115,107,99,91,83,74,76,85,96,
	179,169,161,152,143,134,126,118,109,100,92,89,95,102,109,116,
	122,130,137,144,151,158,165,172,179,185,192,198,205,212,218,224,
	231,238,244,251,245,239,232,225,217,210,204,199,205,214,223,231,
	240,246,246,237,229,221,212,203,195,187,179,171,163,155,146,138,
	130,122,115,107,99,92,83,77,69,62,55,47,40,35,36,43,
	50,57,64,71,78,85,92,98,105,112,119,126,133,140,147,154,
	161,168,174,182,189,195,203,210,216,224,231,238,245,251,245,237,
	230,223,216,209,202,195,189,184,183,186,188,191,192,195,197,198,
	200,202,203,204,205,206,207,208,208,208,208,208,208,208,208,207,
	206,205,204,202,201,199,197,195,193,191,188,185,183,181,177,174,
	171,167,164,160,157,157,164,172,180,187,195,203,211,219,227,235,
	243,251,244,237,228,220,212,204,196,188,179,171,164,156,147,139,
	130,122,114,105,97,89,81,72,65,64,72,80,87,96,104,113,
	121,130,138,146,155,163,173,181,190,199,208,217,227,236,244,247,
	239,229,219,208,196,184,174,179,188,198,207,216,213,204,195,186,
	176,167,159,150,141,133,124,115,108,99,90,83,76,81,91,101,
	184,175,166,157,149,140,131,123,114,106,97,91,94,102,109,116,
	123,130,137,144,152,158,165,172,179,185,192,199,205,212,218,224,
	230,237,244,251,246,238,231,224,218,211,203,197,198,207,215,223,
	232,241,247,244,237,228,220,211,203,195,187,179,171,163,155,147,
	139,131,123,116,108,100,93,85,78,70,64,56,49,42,38,44,
	50,57,64,71,78,85,92,98,105,112,119,126,133,140,146,154,
	161,168,174,182,189,196,203,210,217,223,230,238,245,251,244,237,
	230,223,216,209,202,195,187,180,175,174,177,180,181,184,186,187,
	189,191,192,193,194,195,195,196,196,197,197,197,197,197,196,195,
	194,193,192,190,189,188,186,184,182,180,178,175,172,169,166,163,
	160,156,153,149,150,156,164,172,180,187,195,203,211,219,227,234,
	243,251,244,236,228,220,212,204,195,187,179,171,163,155,147,138,
	130,122,114,105,97,89,81,72,67,72,80,88,95,104,112,120,
	129,138,146,155,163,172,181,189,198,207,216,225,234,243,247,242,
	232,221,211,200,189,177,171,178,188,198,208,217,213,204,195,186,
	176,167,158,150,141,132,124,116,108,99,90,83,79,86,96,107,
	189,180,171,162,154,145,137,128,120,111,103,94,95,102,109,116,
	123,131,137,145,152,158,165,172,179,186,192,199,205,212,219,225,
	231,237,244,251,245,238,231,224,217,211,204,197,191,199,208,216,
	225,233,242,247,244,236,227,219,211,203,195,187,179,171,163,155,
	147,139,131,124,116,109,101,94,87,80,73,65,58,51,45,44,
	50,57,64,71,78,85,91,98,105,112,120,126,133,140,147,154,
	161,168,175,181,189,196,203,210,217,224,231,238,245,251,245,237,
	230,223,216,209,202,195,188,180,173,167,167,169,170,172,174,176,
	177,179,180,181,182,183,184,184,185,185,185,186,185,185,184,183,
	183,182,181,180,178,177,175,173,171,169,166,163,161,158,155,152,
	149,146,142,142,148,156,164,172,179,187,195,204,211,219,227,235,
	243,251,244,235,228,220,212,204,195,187,180,171,163,155,147,138,
	130,122,113,105,96,89,80,73,73,81,89,96,104,113,121,129,
	137,146,154,162,171,180,188,197,206,215,224,232,241,247,243,234,
	224,214,204,193,181,170,169,178,188,198,208,217,212,204,195,186,
	176,167,158,149,141,132,124,116,107,98,90,82,82,92,101,112,
	194,185,176,168,159,150,142,134,125,117,108,99,97,102,109,116,
	123,130,137,144,151,159,165,172,179,186,192,199,206,212,219,225,
	232,238,245,251,244,237,230,224,217,210,203,196,190,191,200,209,
	217,226,234,243,249,244,236,227,219,211,203,195,187,179,171,163,
	156,148,140,133,125,117,110,103,96,89,81,74,67,60,53,47,
	50,58,64,71,78,85,92,98,106,113,119,126,133,140,147,154,
	161,168,175,182,189,195,203,210,217,223,230,238,246,251,244,237,
	230,223,215,209,202,194,187,181,173,166,158,157,159,161,163,165,
	166,168,169,170,171,172,173,173,174,174,174,174,174,173,172,172,
	172,170,169,168,166,165,163,161,159,157,155,152,149,147,144,141,
	138,135,135,141,149,157,164,171,180,188,195,204,211,219,227,236,
	244,251,245,235,228,220,211,203,195,187,179,171,163,154,146,138,
	130,122,113,105,96,88,80,76,82,90,97,105,113,122,130,138,
	146,154,162,170,179,188,197,205,214,223,232,240,246,244,235,227,
	217,207,196,185,174,165,170,179,189,199,208,217,212,203,194,185,
	176,167,158,149,141,132,123,115,107,99,90,84,87,97,107,117,
	199,190,181,173,164,156,147,139,130,122,114,105,99,102,109,116,
	123,130,138,145,152,159,165,172,179,186,192,199,206,212,219,225,
	232,239,246,251,244,237,230,223,216,210,203,196,189,185,193,201,
	210,218,227,235,243,249,243,235,227,219,211,203,195,188,179,172,
	164,157,149,141,134,126,119,112,104,97,90,83,76,70,62,55,
	51,58,64,71,78,85,92,98,106,113,120,126,133,140,147,154,
	161,168,174,182,190,196,203,210,217,224,231,238,245,251,244,237,
	230,223,215,208,201,195,188,180,172,166,158,152,149,150,152,153,
	155,156,158,159,160,161,162,162,162,162,162,162,162,162,161,161,
	160,159,158,156,155,154,152,150,148,146,144,141,139,137,133,130,
	127,127,133,141,149,156,164,172,180,188,196,204,211,219,227,235,
	244,251,243,235,228,219,211,203,195,187,179,171,162,154,146,138,
	129,121,113,105,96,88,81,83,91,98,106,114,122,130,138,146,
	154,163,171,179,188,196,205,213,222,231,239,246,245,237,228,218,
	209,199,189,178,167,161,171,180,189,198,209,218,212,203,194,185,
	176,167,159,149,141,132,123,115,107,99,91,86,92,102,112,123,
	204,195,187,178,170,161,153,144,135,127,119,110,102,103,109,116,
	123,130,137,144,152,159,166,173,180,187,193,199,206,212,219,226,
	232,239,245,251,245,237,230,223,216,210,203,196,189,182,185,194,
	202,210,219,227,235,243,248,243,235,228,219,211,203,196,188,180,
	173,165,157,150,143,135,128,121,113,106,99,92,85,79,72,65,
	58,58,64,72,79,85,92,99,106,113,120,126,133,140,147,154,
	161,168,175,182,189,196,203,210,217,224,231,238,245,251,244,236,
	229,222,216,208,201,194,187,179,172,165,158,151,144,141,140,142,
	143,145,146,147,148,149,150,150,150,151,151,151,151,151,150,149,
	149,148,146,145,144,143,141,139,137,135,133,130,128,125,122,120,
	120,126,134,141,149,156,164,172,181,188,196,204,211,219,227,236,
	244,251,243,235,227,219,211,203,195,187,178,171,162,154,146,137,
	129,121,113,105,97,88,85,93,100,107,115,123,131,139,147,154,
	163,171,179,188,196,205,213,221,229,239,246,245,238,229,220,210,
	201,191,181,171,158,161,171,180,189,199,209,218,212,203,194,184,
	176,167,158,149,140,132,123,115,107,98,91,88,98,107,118,128,
	210,201,192,184,175,166,158,149,141,133,124,116,108,105,110,116,
	123,131,138,145,152,159,166,173,179,186,193,199,207,213,219,226,
	233,239,246,250,243,237,229,223,216,209,203,195,188,181,178,186,
	194,202,211,219,227,235,243,248,243,235,228,219,212,205,196,189,
	181,174,166,159,151,144,137,129,122,115,108,101,94,88,81,74,
	68,61,65,71,78,85,92,99,106,113,120,127,134,141,148,155,
	161,168,175,182,189,196,203,210,217,224,231,238,245,251,244,236,
	230,222,215,208,201,194,187,180,173,165,159,151,144,136,132,131,
	132,133,135,136,136,137,138,139,139,140,140,140,139,139,139,138,
	137,136,135,134,133,131,129,128,125,124,121,119,116,113,111,112,
	118,126,134,141,149,157,165,173,181,188,196,204,212,220,228,236,
	244,251,243,235,227,219,211,203,195,186,178,170,162,154,146,137,
	129,120,113,104,96,90,94,102,109,116,124,132,140,147,156,163,
	171,180,188,196,204,213,221,230,238,246,245,238,230,221,212,203,
	193,184,174,163,153,161,170,180,190,199,209,218,212,203,193,184,
	176,167,158,149,140,132,123,115,107,98,91,94,104,114,123,134,
	214,205,197,189,180,172,163,155,147,138,130,121,113,107,110,117,
	124,131,138,145,152,159,166,173,180,186,193,200,207,214,220,226,
	232,239,246,250,243,237,230,223,215,209,202,195,188,181,175,178,
	187,195,203,211,219,227,235,243,247,243,236,228,220,212,206,198,
	190,182,175,168,160,153,146,138,131,124,117,110,103,97,90,84,
	77,70,67,72,79,86,93,100,106,113,120,127,134,141,147,154,
	161,168,175,183,189,196,203,210,217,224,231,238,245,251,244,236,
	229,222,215,208,201,194,187,180,172,165,158,151,143,136,129,124,
	122,122,124,125,125,126,126,127,128,127,128,128,127,127,127,126,
	125,125,123,122,121,120,118,116,114,113,110,107,105,102,104,110,
	118,126,134,141,149,157,165,173,181,188,196,204,212,220,228,236,
	244,251,243,235,226,219,210,203,194,186,178,170,161,153,145,137,
	128,121,112,104,97,95,103,110,118,125,133,141,148,156,164,172,
	180,188,196,204,212,221,229,238,245,246,239,231,222,213,204,196,
	185,176,166,155,152,162,171,181,190,199,209,218,211,203,193,184,
	175,166,158,149,140,131,123,115,107,99,92,99,109,119,128,139,
	220,211,203,194,186,177,169,160,152,144,136,127,119,111,111,117,
	124,132,139,145,153,160,166,173,180,187,193,200,206,214,220,226,
	233,239,246,250,243,237,229,222,215,209,202,194,188,181,174,171,
	178,187,195,203,211,219,227,235,243,247,244,237,229,221,213,206,
	198,191,183,176,169,162,155,148,140,133,126,120,113,106,99,93,
	86,80,73,73,79,86,93,100,106,113,121,127,134,141,148,155,
	162,169,176,183,190,197,203,210,217,225,231,238,245,250,243,237,
	229,222,215,208,201,194,187,180,172,165,158,151,143,136,129,122,
	116,112,112,113,114,114,115,116,116,116,116,116,116,116,115,115,
	114,112,112,111,110,108,107,104,103,101,98,96,93,96,103,111,
	118,126,134,141,150,158,165,173,181,189,197,204,212,220,228,236,
	244,251,243,235,226,218,210,202,194,186,178,169,161,153,145,137,
	128,120,112,104,99,105,112,119,127,134,142,149,157,165,173,181,
	188,197,205,213,221,229,238,246,246,240,231,222,214,205,196,188,
	178,168,158,148,153,162,172,181,190,200,210,219,212,202,193,183,
	175,166,157,149,140,131,123,114,106,99,95,105,115,125,134,144,
	215,216,208,200,191,182,174,166,158,150,141,132,125,117,113,117,
	124,131,138,146,153,160,166,174,180,187,194,200,207,214,220,227,
	233,240,246,250,243,236,229,222,215,208,201,194,187,181,173,167,
	171,178,186,195,203,211,218,227,235,242,247,244,238,230,223,215,
	207,200,192,185,178,171,164,156,149,143,135,129,122,115,108,102,
	96,90,83,78,80,86,93,100,107,114,121,127,134,141,148,155,
	162,169,176,183,190,197,204,211,218,225,232,239,246,250,243,236,
	228,222,214,207,200,193,186,179,172,165,157,150,143,136,128,122,
	114,108,102,101,102,103,103,104,105,105,105,105,105,104,104,103,
	103,101,100,99,98,96,95,93,91,90,87,85,89,95,103,111,
	119,127,135,142,150,158,165,173,182,190,196,204,213,221,229,236,
	244,250,243,235,226,218,210,202,194,186,177,169,161,153,144,136,
	128,120,112,105,108,115,122,129,136,144,151,158,166,174,181,190,
	198,205,214,222,230,238,246,247,240,231,222,214,206,197,189,180,
	170,160,150,146,154,163,172,181,191,201,210,219,211,202,193,184,
	175,166,157,148,140,132,123,115,106,98,101,110,120,130,140,150,
	209,217,213,205,197,188,180,172,163,155,147,139,131,123,116,117,
	125,132,139,146,152,159,167,174,181,187,194,200,207,214,220,227,
	234,240,247,249,243,236,229,222,215,208,200,194,188,180,174,167,
	164,170,178,186,195,202,210,218,226,234,242,246,245,239,231,223,
	216,208,201,194,187,179,172,165,159,152,145,138,131,125,118,112,
	106,99,93,87,84,86,93,100,107,114,120,128,135,142,148,155,
	162,169,176,184,190,197,204,211,218,225,232,239,246,250,243,236,
	229,221,215,207,200,193,186,179,172,165,158,150,143,136,128,121,
	114,107,99,93,91,91,92,93,93,93,93,93,93,92,92,92,
	91,90,88,87,87,85,84,82,80,78,77,81,88,96,103,111,
	118,127,135,142,151,158,166,174,182,189,197,205,213,221,229,237,
	245,250,242,234,226,218,210,202,194,185,177,169,161,152,143,136,
	127,119,111,111,117,124,131,138,145,153,160,168,175,183,191,199,
	206,214,222,231,239,246,248,240,232,223,214,206,198,189,180,171,
	162,152,143,145,154,163,173,182,192,201,210,219,210,201,192,183,
	174,166,157,148,140,131,123,115,106,98,107,117,126,136,145,156,
	204,212,218,210,202,194,186,178,169,161,153,145,137,128,120,119,
	124,132,138,145,152,160,167,174,181,187,194,201,208,214,221,227,
	233,240,247,249,242,235,228,221,214,208,201,194,187,180,173,166,
	159,163,170,178,186,194,202,210,217,225,233,241,246,245,239,232,
	224,217,210,203,196,189,181,174,168,161,154,148,141,134,128,121,
	115,109,103,96,91,89,94,101,107,114,121,128,135,142,148,156,
	163,169,176,184,190,197,204,211,218,225,232,239,246,250,242,235,
	229,221,214,207,200,193,186,179,172,164,157,150,143,135,128,121,
	114,106,99,92,85,81,81,81,81,82,82,82,82,81,81,80,
	80,78,78,76,75,74,72,70,68,69,73,81,88,97,104,112,
	119,127,135,143,151,158,166,174,182,190,198,205,213,221,230,237,
	246,250,242,234,226,218,209,200,192,185,177,168,160,152,143,135,
	127,119,114,120,127,134,140,148,155,162,169,176,184,192,200,208,
	215,222,231,239,246,248,240,232,223,215,207,198,189,180,172,163,
	154,144,139,145,155,164,173,182,192,201,210,219,210,201,193,184,
	174,165,157,148,139,131,122,115,107,103,113,122,132,142,151,162,
	198,206,215,216,208,200,191,183,175,167,159,150,142,134,126,122,
	125,132,139,146,153,160,167,174,181,188,194,201,208,215,221,228,
	235,241,248,248,241,235,228,221,214,207,200,194,187,179,173,166,
	159,156,162,170,178,186,194,201,209,216,225,232,240,245,246,241,
	234,226,219,212,205,198,191,183,177,170,163,157,150,144,138,131,
	125,118,113,106,100,95,95,101,107,115,122,128,135,142,149,156,
	163,170,177,184,190,198,204,211,218,226,233,239,246,249,242,235,
	228,221,214,207,200,193,186,179,171,164,157,149,142,135,127,120,
	113,106,99,92,84,77,72,70,70,70,70,70,70,70,70,69,
	68,67,66,65,63,62,60,59,60,66,74,81,88,97,104,112,
	119,127,135,143,151,159,166,175,183,191,198,205,214,222,230,238,
	246,249,241,233,225,217,209,201,193,185,176,168,159,152,142,135,
	127,120,122,129,136,143,150,157,164,171,179,186,193,200,208,217,
	224,231,239,247,247,239,232,223,214,206,198,190,181,172,163,155,
	146,137,138,145,155,164,174,182,192,202,211,219,210,201,192,183,
	174,165,157,147,139,131,123,114,106,108,119,128,138,148,157,167,
	193,201,210,217,213,205,197,189,181,172,164,156,148,140,132,125,
	126,132,139,146,154,161,167,175,181,188,195,201,208,215,221,228,
	235,241,248,248,241,234,227,220,214,206,200,193,186,179,173,166,
	159,151,155,162,170,177,185,193,201,208,216,223,231,238,244,246,
	243,236,228,221,214,208,200,193,186,180,173,167,160,154,147,141,
	134,128,122,116,110,104,100,102,108,115,122,129,135,143,150,156,
	163,170,177,184,191,197,205,212,219,226,233,240,247,249,242,235,
	228,221,213,207,199,192,185,178,171,163,156,150,142,135,127,120,
	113,106,98,91,84,77,69,63,60,59,58,58,58,58,58,57,
	57,56,55,53,52,51,49,52,58,66,74,82,88,97,104,112,
	120,127,136,144,151,159,167,174,183,191,198,206,214,222,231,238,
	246,249,240,232,224,217,209,200,192,183,175,167,159,151,142,135,
	127,126,132,139,146,152,159,166,173,181,188,195,203,210,218,225,
	233,241,248,246,239,230,223,214,206,198,189,181,172,163,155,146,
	137,132,138,147,156,165,174,183,193,202,212,219,209,200,191,183,
	174,165,156,148,139,131,122,114,108,115,125,134,144,154,163,173,
	188,196,204,212,218,211,202,194,186,178,170,162,154,146,138,130,
	128,132,139,146,153,160,168,174,181,188,195,202,208,215,222,228,
	235,242,249,248,240,233,227,220,213,206,199,192,186,179,172,165,
	159,151,148,153,161,169,176,184,192,199,207,215,222,229,237,243,
	247,245,238,231,223,217,210,202,196,189,183,176,170,163,157,150,
	144,138,132,126,120,114,109,105,108,115,122,129,136,143,150,157,
	163,170,177,184,191,198,205,212,219,226,234,241,248,249,242,235,
	227,220,213,206,199,192,185,178,171,163,156,149,142,134,127,120,
	113,105,98,91,84,77,69,61,54,49,47,47,47,46,46,46,
	45,44,43,42,41,41,44,51,59,66,74,82,90,97,105,112,
	121,128,137,144,151,160,167,175,183,191,199,207,215,223,231,239,
	247,248,240,232,224,216,208,200,191,183,175,167,158,150,142,134,
	131,135,142,148,155,162,169,176,183,190,197,204,212,219,227,235,
	242,250,245,237,230,222,214,206,198,189,181,172,164,155,147,139,
	130,130,138,147,157,165,174,183,193,203,212,218,209,200,191,182,
	174,165,156,147,139,130,122,114,112,121,130,140,150,159,169,179,
	182,190,198,206,214,217,208,200,192,184,176,168,160,152,144,136,
	130,133,140,147,154,161,168,175,181,189,195,202,208,215,222,228,
	235,242,249,247,240,234,227,220,213,206,199,192,185,179,172,165,
	158,151,144,146,152,160,168,176,183,191,198,206,213,220,228,235,
	242,247,247,239,232,226,219,212,205,198,192,186,178,173,167,160,
	154,148,142,136,129,125,119,113,111,115,123,129,136,143,150,157,
	164,171,178,185,192,199,206,212,220,227,233,241,248,248,241,234,
	227,220,212,206,199,191,184,177,170,163,155,148,141,134,127,119,
	112,105,98,91,83,75,68,61,54,46,40,37,35,35,34,34,
	33,33,31,30,32,37,44,52,60,67,74,82,90,97,106,113,
	121,129,137,144,152,160,168,176,183,191,199,208,215,223,231,239,
	247,248,239,231,223,216,207,199,191,183,175,166,158,150,142,137,
	139,145,151,158,165,171,178,185,192,200,206,214,221,229,236,244,
	247,244,237,229,221,213,204,197,189,181,172,163,155,147,139,130,
	125,131,139,147,156,166,175,185,194,203,212,218,208,200,191,182,
	173,164,156,147,139,130,122,114,118,127,136,146,156,165,175,185,
	176,184,192,200,209,216,214,206,198,190,182,174,166,158,150,142,
	134,134,140,147,154,161,168,175,182,189,195,202,210,216,222,229,
	235,242,249,247,240,233,226,219,213,205,199,192,185,178,171,164,
	157,150,144,139,144,152,160,167,174,183,189,197,204,211,219,227,
	234,240,247,246,241,235,228,221,214,207,201,195,189,182,176,170,
	164,158,152,146,141,134,129,123,118,117,123,130,137,144,151,158,
	164,171,179,185,192,199,206,213,220,227,234,241,248,248,241,234,
	227,219,212,205,198,191,184,176,169,162,155,148,141,133,126,119,
	112,105,98,90,83,75,68,61,54,46,38,32,26,24,23,22,
	22,21,20,22,29,37,44,52,60,67,75,83,91,99,106,114,
	122,130,137,144,152,160,168,176,184,192,200,208,216,223,231,240,
	248,247,239,231,223,215,207,199,191,182,174,166,157,150,143,143,
	149,155,161,168,175,181,188,195,202,209,216,223,231,238,245,247,
	242,235,228,220,212,204,196,188,180,172,163,155,147,138,130,122,
	123,131,139,148,157,166,176,185,194,203,212,217,208,199,190,182,
	173,164,155,147,139,130,122,117,124,133,143,152,162,172,180,191,
	170,179,187,194,203,211,218,212,204,196,188,180,172,164,156,148,
	140,136,140,147,154,161,168,176,182,189,196,203,210,217,223,229,
	236,243,250,247,240,232,225,219,212,205,198,191,184,178,171,164,
	157,150,143,136,137,143,151,158,166,173,181,189,195,202,210,217,
	225,231,238,245,247,243,237,231,224,218,211,204,198,192,186,179,
	173,168,161,156,149,145,139,133,127,122,123,130,137,144,151,158,
	165,172,179,186,193,200,207,213,220,228,234,241,248,247,240,234,
	226,219,212,204,198,190,184,176,169,162,155,148,140,133,126,119,
	111,104,97,90,82,75,68,60,53,45,38,30,23,17,13,10,
	10,11,15,22,30,38,45,53,61,68,76,83,91,99,106,114,
	121,129,138,145,153,161,169,176,185,193,201,209,217,224,233,240,
	248,247,239,230,223,214,206,198,191,181,173,165,158,149,147,153,
	159,165,171,178,184,191,198,204,212,218,226,233,240,246,246,241,
	234,226,219,211,203,195,187,180,171,163,154,147,138,130,121,118,
	124,131,140,149,157,167,176,185,195,204,213,217,208,199,190,181,
	173,164,155,147,138,130,122,122,130,139,149,158,168,178,187,196,
	165,173,181,189,197,205,213,218,210,202,194,186,178,170,162,155,
	147,140,141,147,154,162,169,176,183,189,196,203,210,217,223,230,
	237,243,250,246,239,232,225,218,211,205,198,191,184,177,170,163,
	156,149,143,136,130,135,142,149,157,164,172,179,187,194,201,208,
	215,222,228,235,243,246,246,240,234,227,221,214,208,202,196,190,
	183,177,171,165,160,154,149,143,138,132,129,131,137,145,151,158,
	165,172,179,186,193,200,207,214,221,228,235,242,249,247,240,233,
	226,219,212,205,197,190,183,176,169,161,154,147,139,132,125,118,
	111,104,97,89,82,74,67,60,52,44,38,30,22,15,8,2,
	2,8,15,23,30,38,46,53,61,68,76,84,91,99,107,115,
	122,130,138,146,154,161,169,177,185,193,201,210,217,225,233,241,
	249,246,237,230,222,214,205,197,189,181,173,165,156,152,157,163,
	169,175,181,188,194,201,208,214,221,228,235,243,246,245,239,232,
	224,217,209,202,194,186,179,171,163,154,146,138,130,122,115,117,
	124,132,140,149,158,167,176,186,195,205,214,217,208,199,190,181,
	172,164,155,147,138,130,123,127,136,145,155,164,174,184,193,203,
	159,168,175,183,192,200,208,215,216,208,200,192,184,176,168,161,
	153,145,143,147,155,162,169,175,183,190,197,203,211,217,224,230,
	237,244,251,246,239,231,224,218,211,204,197,190,184,177,170,163,
	156,149,142,135,128,128,133,141,148,156,163,170,178,184,191,199,
	206,213,220,227,233,239,245,247,243,237,231,224,218,212,206,199,
	193,187,181,176,170,165,159,154,148,143,137,135,138,145,152,159,
	166,172,179,186,193,201,208,214,221,229,235,242,249,246,239,232,
	225,218,211,204,197,189,183,176,168,161,154,147,140,133,125,118,
	110,103,96,89,81,73,66,59,52,44,37,30,22,15,9,6,
	7,10,16,24,31,39,46,54,62,69,77,85,92,100,108,115,
	123,131,139,147,154,162,170,178,186,194,202,210,218,225,234,242,
	250,245,237,228,221,214,205,197,188,180,172,164,158,160,167,173,
	179,185,191,198,204,211,217,224,230,237,244,247,244,237,230,222,
	215,208,200,193,185,178,169,161,153,145,137,129,121,113,111,117,
	125,133,141,149,159,167,176,187,196,205,214,216,208,198,189,181,
	172,163,155,146,138,130,127,133,143,152,162,171,180,190,199,208,
	153,161,169,178,185,193,201,210,216,214,206,198,190,183,175,167,
	159,151,145,148,155,162,169,177,184,190,197,204,211,218,224,231,
	238,245,251,245,239,231,224,217,210,204,196,190,183,176,169,163,
	156,148,142,135,128,122,125,132,140,147,154,161,168,175,183,189,
	197,204,210,217,224,230,237,244,247,245,240,234,228,221,215,209,
	204,198,192,186,180,174,169,164,159,154,148,143,141,146,153,159,
	166,173,181,188,194,201,208,215,222,229,236,243,250,246,238,232,
	225,218,211,204,196,189,182,175,168,160,153,146,139,131,124,117,
	110,102,95,88,80,73,66,59,52,44,36,29,22,18,17,17,
	18,19,20,25,32,39,47,55,62,70,77,85,92,100,108,115,
	123,131,139,147,155,163,171,179,186,194,202,210,218,226,234,242,
	250,244,236,228,221,212,204,196,188,179,171,165,166,171,177,183,
	189,195,201,208,214,221,227,234,240,245,247,242,235,228,221,213,
	206,198,191,183,176,168,160,152,145,136,129,120,112,107,110,117,
	126,134,142,150,160,168,177,187,196,205,215,216,207,198,189,180,
	171,163,155,146,138,130,131,139,149,158,168,177,187,196,205,215,
	147,156,164,171,179,187,195,203,211,218,213,205,197,189,181,173,
	165,158,150,149,155,162,170,177,183,190,198,204,211,218,225,232,
	238,245,251,244,238,231,224,217,210,203,196,190,183,176,169,162,
	155,148,141,134,128,120,117,123,131,138,145,152,159,166,173,180,
	187,194,201,208,214,220,228,235,240,245,247,244,238,231,225,219,
	213,207,202,196,191,185,179,174,169,164,158,153,149,148,153,160,
	167,174,180,187,195,202,209,215,223,230,237,243,251,245,238,231,
	224,217,210,203,196,188,182,174,167,160,152,145,138,131,123,116,
	109,102,95,87,80,73,66,58,50,43,36,31,28,28,28,28,
	29,31,31,32,36,41,48,55,63,70,78,86,93,101,109,117,
	124,132,140,148,156,163,172,179,187,195,203,211,219,227,235,243,
	251,244,236,228,220,211,204,195,187,179,171,171,176,181,187,193,
	199,205,211,217,224,231,237,243,247,246,240,233,226,218,211,204,
	196,189,181,174,166,159,152,143,136,128,120,111,104,104,111,118,
	126,134,142,151,160,169,178,187,196,206,216,215,206,197,189,180,
	171,163,154,146,137,132,137,146,155,165,175,183,192,202,211,219,
	141,149,157,166,173,182,189,197,205,213,218,211,203,195,187,180,
	172,164,157,152,155,163,170,177,184,191,198,204,211,219,225,231,
	238,246,251,244,237,230,224,216,209,202,196,189,182,175,168,161,
	154,148,141,134,128,120,114,115,122,129,136,143,150,157,164,171,
	178,184,191,198,204,211,218,224,231,237,243,247,246,241,235,230,
	223,217,212,206,201,195,190,185,179,174,169,164,159,155,155,161,
	167,175,182,188,195,202,209,216,223,230,238,244,251,245,237,231,
	223,217,210,202,195,188,181,173,166,160,152,145,138,131,124,115,
	108,101,94,87,79,72,65,57,50,43,40,39,39,39,40,41,
	41,41,43,44,45,46,51,56,63,71,79,87,94,102,110,118,
	126,133,141,149,156,164,172,180,188,196,204,211,220,228,235,243,
	251,243,236,227,219,211,203,195,186,179,176,180,186,192,198,204,
	209,215,221,228,234,240,246,248,243,237,230,223,216,209,202,194,
	187,180,172,165,157,149,143,134,126,118,111,103,99,104,111,119,
	126,135,143,152,161,170,178,188,197,207,216,215,206,197,188,180,
	171,162,154,145,137,135,143,152,162,171,180,190,199,208,217,213,
	135,144,151,159,167,175,183,191,199,207,214,217,209,201,194,186,
	179,171,163,156,157,163,170,177,184,191,198,205,212,219,225,232,
	238,245,251,244,237,230,223,216,209,202,195,188,182,175,168,161,
	154,147,140,133,127,119,113,108,112,119,127,134,141,148,155,161,
	169,176,182,189,196,202,208,215,221,227,234,240,245,247,245,240,
	234,228,222,216,211,205,200,195,190,184,180,174,169,165,162,162,
	168,175,182,189,196,203,210,217,224,231,238,245,251,244,237,230,
	223,216,209,201,194,187,180,173,165,158,152,144,138,130,123,115,
	108,100,93,86,78,71,64,57,53,51,50,50,51,51,51,52,
	53,53,54,56,57,58,59,62,66,72,80,88,95,103,110,118,
	126,134,142,149,157,165,173,181,189,197,205,212,221,229,237,244,
	250,243,234,226,218,210,202,194,186,182,185,191,197,202,208,214,
	220,225,231,238,244,248,246,240,233,227,220,213,206,199,192,185,
	178,170,163,156,148,140,133,125,117,109,102,95,98,104,112,120,
	128,135,144,152,161,171,179,189,198,207,216,214,206,197,188,179,
	170,162,154,145,138,140,150,159,168,178,187,196,205,215,215,207,
	130,138,146,153,162,169,177,185,193,200,208,216,215,207,200,193,
	185,177,170,162,159,163,170,177,185,192,199,206,212,219,226,233,
	239,247,250,243,236,229,222,215,208,201,194,187,180,174,167,160,
	153,146,139,133,126,119,112,105,105,110,117,125,132,139,146,152,
	159,166,172,179,186,192,198,204,211,218,224,229,236,242,246,247,
	243,238,232,227,222,216,211,206,200,195,190,185,180,175,171,168,
	170,176,182,190,197,204,210,218,225,232,239,246,250,243,236,229,
	222,215,208,201,193,186,179,171,165,158,151,142,136,129,122,113,
	107,99,92,85,78,71,66,63,63,63,63,63,63,63,63,65,
	65,66,67,67,69,70,71,73,74,78,81,89,96,104,112,120,
	128,135,143,151,159,166,175,182,190,198,206,214,222,230,238,246,
	249,241,233,225,217,209,200,192,188,191,196,202,207,213,219,224,
	230,236,242,248,248,242,236,230,223,215,209,203,196,188,182,175,
	168,160,153,146,138,131,123,115,107,100,92,91,98,105,113,120,
	128,136,145,153,163,171,180,189,198,208,216,214,205,196,188,178,
	170,162,154,145,140,147,157,166,175,184,193,203,212,216,210,201,
	123,132,140,147,155,163,171,178,186,194,202,210,216,214,206,199,
	192,184,177,169,162,164,170,178,185,192,199,206,212,219,226,234,
	240,247,249,243,235,228,221,214,207,200,194,187,180,173,166,159,
	152,145,138,131,124,118,111,104,98,101,108,115,122,129,136,142,
	150,156,163,170,176,182,188,195,201,207,214,220,226,232,238,243,
	247,248,242,238,232,226,221,216,211,206,201,196,191,187,182,177,
	175,177,184,191,198,205,212,219,226,233,240,247,249,242,235,228,
	221,213,206,199,192,185,178,171,164,157,149,142,134,128,120,113,
	105,98,90,84,79,77,76,75,75,75,75,74,75,75,76,76,
	77,78,79,79,80,82,83,85,87,88,91,93,98,106,114,122,
	129,137,145,153,161,168,176,184,192,200,208,216,224,232,240,248,
	247,239,231,223,214,207,198,194,197,203,208,213,219,225,231,236,
	242,248,248,243,237,230,224,218,212,205,198,192,185,178,171,164,
	157,150,142,135,128,120,113,105,98,90,85,92,99,107,114,122,
	130,138,146,154,163,172,180,190,199,208,217,214,205,195,187,178,
	170,162,153,145,145,154,163,173,181,191,200,209,215,212,203,195,
	118,125,133,141,149,157,164,172,180,188,196,203,211,217,213,206,
	198,191,183,175,168,166,171,178,185,192,199,207,214,220,227,234,
	241,248,248,241,234,227,220,214,206,199,192,186,179,172,165,158,
	150,144,137,130,124,117,110,103,96,93,100,106,112,119,126,133,
	140,146,153,159,166,172,179,185,191,198,203,210,216,221,227,233,
	238,244,249,249,242,236,231,227,222,217,212,207,203,198,193,188,
	184,182,186,193,200,207,213,221,227,234,242,249,247,240,233,226,
	219,211,205,197,190,183,176,169,161,154,147,140,133,126,118,111,
	104,97,92,90,90,89,88,88,88,88,87,87,88,88,89,89,
	90,91,92,92,94,95,96,98,99,101,103,105,107,110,116,124,
	131,139,147,155,163,170,178,186,194,202,210,218,226,235,242,250,
	244,237,229,220,212,204,201,204,209,215,220,225,231,236,242,248,
	247,243,237,232,225,220,213,206,200,194,187,181,174,167,160,152,
	146,139,131,124,117,110,102,94,87,82,87,94,101,109,117,124,
	132,139,147,155,164,173,182,191,200,208,217,213,204,195,186,178,
	170,161,153,146,152,161,170,179,188,197,206,214,214,205,196,188,
	111,119,127,134,143,151,158,166,174,181,189,197,205,212,219,212,
	205,197,190,182,175,169,172,178,186,193,200,206,213,220,228,235,
	242,249,247,240,233,226,219,212,204,198,192,184,177,170,164,157,
	150,143,136,129,122,115,108,101,94,89,90,97,103,110,117,124,
	131,137,143,149,156,162,169,175,181,187,193,199,205,211,217,223,
	228,233,239,244,249,246,242,238,232,227,223,218,213,209,204,200,
	196,191,190,195,201,208,216,223,230,237,245,251,245,238,231,224,
	216,209,202,195,188,180,173,166,159,152,144,137,131,123,116,111,
	107,105,104,103,103,102,101,101,101,101,100,101,101,101,102,102,
	103,104,104,105,107,108,109,111,112,114,116,118,120,122,124,129,
	135,142,150,158,165,173,181,189,197,205,213,221,229,237,246,250,
	242,234,226,218,211,209,212,217,222,227,232,238,244,248,246,243,
	237,232,226,219,214,208,201,195,188,183,176,168,162,155,148,142,
	134,127,120,113,105,99,91,83,78,81,89,96,104,111,119,126,
	133,141,149,156,165,173,182,191,200,209,218,213,204,195,187,178,
	169,161,153,149,158,167,177,185,194,204,213,216,208,199,191,182,
	105,113,121,129,136,144,152,160,167,175,183,191,198,206,213,218,
	211,203,196,189,182,174,173,179,186,193,200,207,214,221,229,235,
	242,250,246,239,233,225,218,212,204,197,190,183,176,169,162,155,
	148,141,134,127,120,113,106,99,93,86,83,87,93,100,107,114,
	121,127,134,140,146,152,159,165,171,177,183,189,195,200,206,212,
	217,223,228,234,239,244,247,246,244,238,234,229,224,220,215,211,
	207,203,198,198,205,211,219,226,232,239,246,249,242,236,228,221,
	214,207,199,193,185,178,171,164,156,149,142,135,128,124,121,120,
	118,118,116,116,115,115,114,114,113,113,114,114,114,114,115,115,
	116,117,118,119,120,121,123,124,126,127,130,131,134,135,138,141,
	143,148,153,161,169,176,184,192,201,208,216,224,233,241,249,247,
	239,230,222,216,216,220,225,230,234,240,244,247,245,242,236,231,
	225,220,213,207,201,195,189,183,177,170,163,157,150,143,136,130,
	123,115,109,102,94,87,80,73,76,83,91,99,106,113,121,128,
	136,143,150,159,166,175,184,192,201,210,219,212,203,194,186,177,
	169,160,152,156,165,174,183,192,201,210,216,211,201,192,183,175,
	99,106,115,123,130,138,145,153,161,168,176,184,191,199,207,214,
	218,211,203,196,189,181,176,179,187,194,201,208,215,222,229,237,
	244,250,245,239,232,224,217,210,203,196,189,182,175,168,161,154,
	147,140,133,127,119,112,105,99,91,84,78,78,84,91,97,104,
	111,118,124,130,136,142,148,154,161,167,173,178,184,190,196,201,
	207,212,218,223,228,233,238,243,246,246,245,240,236,231,227,223,
	218,214,210,207,208,214,221,228,236,242,249,246,239,232,225,218,
	211,204,197,189,182,175,168,160,153,146,141,139,137,135,134,132,
	132,131,130,129,128,128,128,127,126,126,127,127,127,127,128,128,
	129,130,131,132,133,135,135,137,139,141,143,145,146,149,151,154,
	156,159,162,167,172,180,188,196,204,212,220,228,235,243,251,243,
	235,227,222,224,228,233,238,243,246,246,244,240,235,229,224,218,
	212,207,201,195,189,183,177,171,164,158,151,145,138,132,125,118,
	111,104,97,89,82,75,69,72,79,86,93,100,108,116,123,130,
	138,145,153,160,168,176,184,193,202,211,219,212,203,194,185,177,
	169,160,154,163,172,181,190,199,208,216,213,204,195,186,177,168,
	92,100,108,116,123,131,139,147,154,162,170,177,185,193,199,208,
	214,217,210,203,195,188,180,181,187,194,201,208,215,223,230,236,
	245,251,244,238,231,223,217,210,202,195,188,181,174,167,160,152,
	146,139,132,125,118,111,104,97,90,83,76,71,74,81,88,94,
	101,108,114,120,126,132,138,144,150,156,163,168,174,179,185,191,
	196,201,207,212,217,222,228,232,237,242,245,247,247,243,238,234,
	230,226,222,218,216,218,224,231,238,246,251,243,236,229,222,215,
	208,201,194,186,179,171,165,160,156,154,152,151,149,148,147,146,
	145,144,143,142,141,141,140,140,140,140,140,140,140,141,141,142,
	143,143,144,145,146,149,150,151,152,154,156,158,160,162,164,167,
	169,172,175,178,181,186,192,200,208,215,224,231,239,247,247,239,
	232,229,233,237,242,246,246,246,242,237,232,227,222,217,211,205,
	200,194,189,183,176,170,164,158,151,146,139,132,126,119,113,106,
	99,92,84,78,71,65,67,74,81,89,96,103,111,118,126,133,
	140,148,155,163,170,178,185,194,203,212,219,211,202,193,185,177,
	168,160,161,170,179,188,197,206,214,214,206,198,189,180,171,162,
	86,94,102,110,117,125,133,141,148,155,163,171,179,186,193,200,
	208,215,217,209,202,195,187,183,187,194,202,209,216,223,230,237,
	245,251,245,237,230,222,215,208,201,194,187,180,173,166,158,152,
	145,137,131,124,116,109,102,95,88,81,74,67,67,71,78,85,
	91,97,104,109,116,122,128,134,140,146,152,157,163,169,175,180,
	185,191,196,201,206,212,217,222,226,231,235,240,244,248,249,246,
	241,237,233,229,226,223,227,234,242,249,247,240,234,226,220,212,
	204,197,190,184,178,175,173,171,169,167,165,164,162,161,160,158,
	158,157,156,155,154,154,154,154,154,153,154,153,154,154,155,155,
	156,157,158,159,160,162,163,165,166,168,170,172,174,176,178,180,
	183,185,188,191,194,197,200,205,212,219,227,235,243,251,244,237,
	237,242,245,246,246,244,239,234,229,224,219,214,209,204,198,192,
	187,182,176,170,164,158,152,146,140,133,126,120,113,107,100,94,
	87,80,73,66,60,62,69,76,83,91,98,105,113,121,128,135,
	142,150,158,165,172,180,188,195,203,212,219,210,202,193,185,176,
	168,161,168,177,186,195,204,213,216,209,200,191,182,173,165,155,
	80,88,96,103,111,119,126,134,141,149,156,164,171,180,187,194,
	201,209,215,216,209,202,195,188,188,195,202,209,217,224,231,238,
	245,250,243,235,229,222,214,207,200,193,186,179,172,164,157,151,
	143,136,129,122,115,108,101,94,87,80,73,65,58,62,68,75,
	81,87,93,100,106,112,118,124,129,135,141,147,153,158,164,169,
	175,180,185,190,195,201,205,210,215,219,225,228,232,237,242,246,
	248,247,244,241,238,234,232,237,244,251,244,237,229,223,215,209,
	203,198,194,192,189,188,185,184,182,180,178,177,175,174,173,172,
	171,170,169,168,168,167,167,167,167,166,166,167,168,168,168,169,
	170,171,171,172,173,175,176,178,179,181,183,185,188,189,192,194,
	197,199,202,204,208,211,214,217,220,225,232,240,247,249,245,245,
	246,247,244,240,235,231,226,222,217,212,207,201,196,191,186,179,
	174,169,163,157,151,145,140,134,127,121,114,108,102,95,88,81,
	75,68,61,54,57,63,72,78,86,94,101,108,116,123,130,137,
	145,153,160,167,174,181,189,197,204,213,218,210,201,193,184,176,
	167,167,175,184,193,202,211,217,211,202,193,184,175,166,157,149,
	73,82,89,97,105,113,120,128,135,143,150,158,165,173,179,187,
	195,202,209,215,215,209,202,195,190,195,202,209,217,224,232,239,
	246,250,242,235,228,221,213,207,199,192,185,177,170,163,156,149,
	142,135,127,121,114,107,99,92,85,78,71,64,57,53,58,65,
	71,77,83,89,96,102,108,113,119,125,131,137,142,147,153,158,
	164,169,174,180,185,189,194,199,204,209,213,217,221,226,231,234,
	239,242,246,247,246,244,242,242,248,249,241,234,228,222,217,214,
	212,209,206,204,202,200,198,196,194,193,191,189,188,187,185,184,
	184,182,182,181,180,181,180,180,179,179,180,180,180,181,181,182,
	183,184,184,185,187,188,189,191,193,194,196,198,200,203,204,207,
	210,212,215,217,221,224,227,230,233,237,240,245,251,247,247,244,
	240,235,231,227,222,218,213,208,204,199,194,189,184,178,173,167,
	162,156,151,145,139,133,127,121,115,108,103,96,90,83,76,70,
	63,56,50,52,59,66,73,80,88,96,103,110,117,125,133,140,
	147,155,162,169,176,183,191,199,206,214,217,209,201,192,184,176,
	168,173,182,191,200,209,216,213,204,195,186,177,168,160,151,142,
	67,75,83,91,98,105,113,121,128,136,143,151,158,165,173,180,
	188,194,202,209,216,215,208,202,195,197,202,210,218,225,232,240,
	247,249,242,235,227,220,212,206,198,191,184,177,169,162,155,148,
	141,134,127,120,112,105,98,90,84,77,70,63,55,49,48,55,
	61,67,73,79,85,91,98,103,108,114,120,126,132,137,142,148,
	153,158,163,168,173,178,183,187,192,197,202,206,210,215,219,223,
	227,230,234,238,242,245,245,247,251,247,242,238,235,232,229,227,
	224,221,219,217,214,213,211,209,206,206,204,202,201,200,198,197,
	197,196,195,194,193,193,193,193,193,193,193,193,193,194,194,195,
	196,197,198,199,200,201,203,205,206,207,210,212,213,216,218,221,
	223,226,228,231,234,237,240,243,245,246,247,249,249,242,236,231,
	226,222,218,214,210,205,200,196,190,185,180,176,170,165,160,154,
	149,144,138,132,127,120,115,108,102,96,90,84,77,71,64,58,
	51,45,47,54,61,69,76,83,91,99,105,113,120,127,134,142,
	149,157,164,171,178,186,194,201,208,215,216,208,200,191,183,175,
	173,181,189,198,207,215,214,206,197,188,179,171,162,153,144,135,
	61,68,76,84,91,99,107,114,122,129,137,144,151,159,166,174,
	181,188,195,202,210,216,215,208,201,198,203,211,218,225,232,240,
	248,248,241,234,227,219,212,204,198,191,183,176,169,161,154,147,
	140,133,126,119,111,104,96,90,82,75,68,61,54,47,42,45,
	51,57,63,70,75,81,87,93,98,104,110,116,121,126,132,137,
	142,147,152,157,162,167,172,176,180,185,190,195,199,203,207,211,
	216,220,223,226,230,234,240,247,250,245,248,250,247,244,242,239,
	237,234,232,229,227,225,223,221,220,218,216,215,214,212,212,211,
	209,209,209,207,207,206,206,206,206,206,206,207,207,208,208,209,
	209,210,211,212,214,215,217,218,220,222,223,225,227,229,232,234,
	236,239,242,244,245,246,247,246,243,241,243,250,245,237,229,222,
	216,210,205,201,196,192,187,183,177,173,167,162,157,152,147,142,
	137,131,125,120,114,108,102,96,90,84,78,71,65,59,53,46,
	39,42,49,56,64,72,78,86,93,101,107,115,122,129,137,144,
	152,158,166,173,181,188,195,202,209,217,215,207,199,191,183,175,
	179,188,197,206,213,215,207,198,190,182,173,164,155,146,137,129,
	55,62,69,77,85,93,101,108,115,123,130,138,145,152,160,167,
	174,181,188,196,202,210,215,215,208,203,205,211,218,226,233,240,
	248,248,241,233,226,219,212,204,197,190,183,174,168,160,153,146,
	139,132,125,117,110,103,96,89,81,74,66,60,53,45,38,36,
	41,47,53,59,65,71,77,82,88,94,99,105,110,115,121,126,
	131,136,141,147,151,156,161,166,170,174,179,183,188,191,196,200,
	204,209,213,220,227,235,242,249,247,240,239,241,244,247,249,249,
	248,245,243,242,240,237,236,234,232,231,229,228,226,225,224,223,
	223,222,221,221,220,220,220,219,219,219,220,220,220,221,221,222,
	223,223,225,226,227,228,230,232,233,235,237,239,241,242,244,245,
	247,248,248,245,242,239,236,234,233,238,246,249,242,234,225,217,
	209,202,195,188,183,179,174,170,165,160,155,150,145,140,135,130,
	124,119,113,107,101,96,90,84,78,72,66,59,53,46,41,34,
	37,44,52,59,66,73,80,88,96,103,110,116,124,131,139,146,
	154,160,168,175,182,189,197,204,211,218,213,205,198,190,182,180,
	186,195,204,212,216,209,200,191,183,174,166,157,148,139,131,123,
	49,56,63,71,79,86,94,101,108,116,123,131,137,146,152,160,
	167,174,181,188,196,203,209,216,216,209,205,211,219,226,233,241,
	248,248,240,232,225,218,211,203,196,188,181,174,167,159,152,145,
	138,130,123,116,109,102,95,87,80,73,65,58,51,43,36,29,
	31,37,43,49,55,61,66,72,77,84,89,94,99,105,110,115,
	121,126,131,135,140,145,149,154,159,163,167,172,177,183,188,194,
	201,208,215,223,229,238,244,251,244,236,230,229,231,234,237,239,
	241,244,246,247,246,246,246,245,244,243,242,241,239,238,237,236,
	236,235,234,234,233,233,232,232,232,232,233,233,233,234,235,236,
	236,237,238,239,240,242,243,244,245,246,247,248,248,247,244,242,
	240,237,235,232,229,226,224,227,233,241,249,245,238,230,222,214,
	206,197,190,182,175,168,161,156,151,147,142,137,132,127,122,117,
	111,105,100,94,89,83,77,71,65,59,54,47,41,35,30,32,
	40,47,54,62,68,76,83,91,98,104,112,119,126,134,141,148,
	155,162,169,176,184,191,198,206,213,219,211,204,197,189,183,186,
	194,203,211,216,210,201,193,184,176,167,159,150,141,133,124,116,
	42,49,57,64,72,79,86,94,102,109,116,124,131,138,146,153,
	160,167,174,181,189,196,203,210,215,216,210,212,219,226,234,242,
	249,247,239,232,224,217,210,203,195,188,180,173,166,158,152,144,
	137,129,122,115,108,100,93,86,79,71,64,57,50,42,36,28,
	24,27,33,39,45,51,56,61,67,73,78,84,89,94,100,105,
	110,115,119,124,129,134,138,143,149,155,161,167,175,182,190,196,
	204,211,218,225,233,240,247,248,241,234,226,221,220,222,225,227,
	230,232,233,236,238,240,242,244,245,245,245,245,246,246,247,247,
	248,248,247,247,247,246,245,246,246,246,246,247,247,247,248,248,
	248,249,250,250,249,248,246,245,243,241,239,238,236,233,231,229,
	226,224,221,218,216,217,221,229,237,245,250,243,234,227,219,210,
	202,195,187,179,171,163,155,148,140,134,129,124,120,114,109,104,
	99,94,88,82,77,71,65,59,53,47,41,35,29,24,28,35,
	43,49,57,63,71,78,85,92,99,107,114,121,128,135,142,150,
	157,164,172,179,187,193,200,207,214,217,210,203,195,188,186,193,
	201,210,215,212,203,194,186,177,169,160,151,143,134,126,118,109,
	35,43,50,58,65,73,80,88,95,102,109,117,124,132,138,146,
	153,160,167,175,181,188,195,202,209,215,217,213,219,226,234,242,
	249,246,238,231,224,216,209,202,195,187,179,172,165,158,151,143,
	136,129,122,114,106,99,92,84,77,70,63,56,48,42,34,26,
	19,17,23,29,34,40,45,51,57,62,67,73,78,83,88,94,
	99,104,108,114,119,126,134,141,148,156,163,169,177,184,192,199,
	206,213,221,228,236,243,250,246,239,231,224,216,211,210,212,215,
	217,219,221,223,225,227,229,231,232,234,235,237,238,239,240,241,
	242,242,242,243,244,244,244,245,244,244,244,243,243,243,242,241,
	240,239,238,237,236,234,233,232,230,228,226,225,223,220,218,216,
	213,211,208,207,210,217,224,232,240,249,247,239,231,223,215,207,
	199,191,184,175,167,159,151,144,135,128,119,111,106,101,96,92,
	86,81,75,70,64,59,53,47,41,35,29,23,17,23,30,37,
	45,52,59,66,74,81,87,94,101,108,115,123,130,137,145,151,
	159,166,173,181,187,195,202,209,216,216,209,202,194,189,193,201,
	209,216,213,205,197,187,180,170,162,153,145,136,128,119,111,102,
	28,36,43,51,58,66,73,81,88,96,103,110,117,124,132,139,
	146,153,160,167,174,181,188,195,202,208,215,217,220,227,234,242,
	250,246,238,231,224,216,209,202,194,186,179,172,164,157,150,142,
	135,127,120,113,105,99,91,84,76,69,62,54,47,40,33,25,
	18,12,12,19,24,30,35,41,46,52,57,62,68,74,79,85,
	92,99,107,114,121,128,135,143,150,158,165,171,179,187,194,201,
	208,216,223,231,238,245,250,243,236,229,221,213,206,200,200,202,
	205,207,209,211,213,214,216,218,220,221,223,224,225,226,227,227,
	228,229,230,231,231,231,231,231,232,231,230,231,230,229,228,228,
	227,226,225,224,222,221,220,218,217,214,213,211,209,207,205,203,
	200,197,198,205,212,220,228,236,244,251,243,235,228,220,212,204,
	196,189,180,172,165,157,149,141,132,124,117,108,101,92,85,79,
	74,68,63,57,52,46,40,34,28,22,17,13,18,25,32,40,
	47,54,61,68,75,82,89,97,104,111,117,125,133,139,147,154,
	161,168,175,182,189,196,204,211,218,214,207,200,193,195,201,209,
	216,214,206,198,189,180,172,164,155,146,138,129,121,112,103,96,
	22,30,37,44,51,59,67,74,81,89,96,103,110,118,124,132,
	138,146,153,160,167,174,181,188,195,201,208,214,220,227,235,243,
	250,246,238,231,223,216,208,201,193,186,178,171,164,157,149,141,
	134,126,119,112,104,97,90,83,75,68,61,53,46,39,31,24,
	17,9,6,8,13,19,25,31,38,44,50,57,64,71,79,86,
	93,101,108,116,123,130,137,145,152,159,167,174,181,189,196,203,
	211,218,226,233,240,248,248,241,233,226,218,211,203,196,190,190,
	192,195,197,199,200,202,204,205,207,209,210,211,212,213,214,215,
	216,217,217,217,218,218,218,218,218,218,218,217,217,216,215,215,
	214,213,212,210,209,208,207,205,203,202,200,198,196,193,191,189,
	189,193,200,208,215,224,231,239,247,248,240,232,225,217,209,201,
	193,185,177,169,161,154,146,137,129,121,113,106,97,89,82,73,
	66,58,51,45,39,34,28,22,16,11,9,14,21,28,35,42,
	49,56,63,71,78,84,92,98,105,113,119,126,134,141,148,155,
	162,170,176,184,191,198,205,213,219,214,206,199,198,204,211,216,
	213,207,198,190,182,173,165,156,148,139,131,122,113,105,97,89,
	15,23,30,38,45,53,60,68,74,81,89,97,103,111,117,125,
	131,139,145,153,160,167,174,182,189,197,205,212,220,228,235,243,
	250,245,238,230,222,215,207,200,193,185,178,171,163,156,148,140,
	133,126,118,111,104,96,88,82,74,67,60,52,44,37,30,23,
	15,8,2,2,8,15,22,29,36,44,51,59,66,74,81,88,
	95,103,110,117,124,132,140,147,154,162,169,177,184,191,198,205,
	214,220,228,236,243,250,245,238,231,223,215,208,201,194,186,181,
	180,182,184,186,188,190,192,193,194,196,197,199,199,201,202,202,
	203,203,204,205,205,205,205,205,205,205,204,204,204,203,202,202,
	201,200,199,197,196,195,194,192,190,188,187,185,182,180,178,181,
	188,195,204,211,219,227,235,242,250,245,237,229,221,213,205,198,
	190,182,174,166,159,151,143,134,126,118,111,103,95,86,79,71,
	63,55,47,38,31,23,17,11,5,3,8,15,23,30,37,44,
	51,57,65,73,80,86,93,100,107,115,122,128,136,143,150,157,
	164,171,178,186,192,199,207,213,219,212,204,201,207,213,217,212,
	205,198,191,183,174,166,157,149,140,132,124,115,106,99,90,82,
	9,16,23,31,39,46,53,60,67,75,82,90,97,106,113,121,
	129,136,143,151,158,166,174,181,190,197,205,212,220,228,236,243,
	251,245,238,230,222,214,207,200,192,185,177,170,162,155,148,140,
	132,125,117,110,103,95,87,81,73,65,59,51,44,37,30,25,
	20,15,9,5,8,16,23,30,38,45,53,60,68,75,82,89,
	98,105,112,120,126,135,142,149,156,163,171,178,185,193,201,208,
	215,223,230,238,245,250,243,235,228,221,213,206,198,191,184,176,
	171,170,172,174,175,177,179,180,182,183,184,186,187,188,188,189,
	190,191,191,191,192,192,192,192,192,192,191,191,190,190,189,188,
	187,187,186,184,183,181,180,179,177,175,173,171,169,169,176,183,
	191,199,206,214,222,230,237,246,250,242,234,226,218,210,202,195,
	187,179,171,163,155,147,140,131,124,116,108,100,92,84,76,68,
	60,52,44,36,28,20,13,4,1,6,13,19,26,32,39,46,
	53,60,67,74,81,88,95,102,109,116,124,130,137,145,151,158,
	165,172,179,186,194,201,207,215,217,210,206,209,216,216,210,203,
	196,189,182,174,166,158,150,142,133,125,116,108,99,91,83,75,
	4,13,20,28,35,44,51,59,66,74,82,90,97,105,112,119,
	128,135,143,150,158,166,173,182,189,197,205,213,220,228,235,244,
	251,245,237,230,222,214,207,200,192,185,177,169,162,154,147,139,
	132,124,117,110,102,94,87,80,73,67,60,54,49,44,39,34,
	28,23,18,13,12,17,25,32,40,47,54,61,69,76,84,91,
	99,106,114,121,129,136,143,151,159,166,173,180,188,195,203,210,
	217,225,232,240,247,248,241,233,226,219,211,204,196,188,181,173,
	166,161,160,161,162,165,166,168,169,170,172,173,174,175,176,176,
	177,177,178,179,179,179,179,179,179,179,178,177,177,177,176,175,
	174,174,172,171,170,168,167,166,164,162,160,159,163,171,178,186,
	194,201,209,217,225,232,241,249,247,239,231,223,216,207,200,192,
	184,176,168,160,152,145,137,128,121,113,105,97,89,81,73,66,
	57,49,41,34,26,18,10,7,11,16,21,27,32,37,42,49,
	56,63,69,76,83,90,96,104,111,117,124,132,139,146,152,160,
	167,174,181,188,195,202,209,216,216,210,211,217,214,207,201,194,
	188,180,173,166,160,152,143,135,126,118,109,101,92,84,76,67,
	5,13,20,28,35,43,51,59,66,75,82,90,98,105,113,120,
	128,135,143,150,158,166,174,182,190,197,205,212,220,228,235,244,
	251,244,237,229,222,215,207,199,192,184,176,169,161,154,147,139,
	131,124,117,110,103,97,91,85,79,74,69,64,58,53,48,42,
	38,33,28,23,18,19,26,34,41,48,56,63,71,78,85,92,
	100,108,115,123,130,138,145,152,160,167,175,182,190,197,204,212,
	220,227,235,243,250,246,239,231,223,216,209,201,193,186,178,171,
	164,156,150,148,150,152,154,156,157,158,159,161,161,162,163,164,
	165,165,165,167,166,166,166,165,166,166,165,165,164,164,163,162,
	161,160,159,157,156,156,154,153,151,149,151,158,166,174,181,190,
	196,204,212,220,228,235,244,251,244,236,228,220,212,205,197,189,
	181,174,166,158,149,142,134,126,118,111,103,94,86,79,71,63,
	55,47,39,31,24,16,13,17,22,27,32,37,42,47,52,58,
	64,69,74,80,87,93,100,106,113,120,126,133,141,147,154,161,
	168,175,182,190,196,203,210,217,216,215,217,212,205,199,192,185,
	178,171,165,158,151,143,135,127,119,111,102,94,85,77,69,60,
	5,13,20,28,35,43,51,58,66,74,82,90,98,106,113,120,
	128,135,143,150,158,166,174,182,189,197,204,212,220,228,236,244,
	251,244,237,229,221,214,207,199,192,183,176,168,161,153,146,140,
	134,127,122,115,109,104,99,94,88,82,77,72,67,61,56,51,
	47,42,37,32,27,22,27,35,43,50,57,65,72,79,87,94,
	102,109,117,124,132,139,147,154,162,169,176,184,192,199,207,214,
	222,229,236,244,251,244,237,229,221,213,206,199,191,184,176,168,
	161,154,146,139,138,140,141,143,144,145,147,148,149,149,150,151,
	152,152,152,153,153,153,153,153,153,153,152,151,151,150,150,149,
	148,147,146,145,143,142,140,139,140,146,153,161,168,176,184,192,
	200,208,216,223,231,239,246,249,242,234,226,218,210,202,194,186,
	179,171,163,155,147,139,131,124,116,108,100,92,84,77,69,61,
	53,45,37,29,21,19,22,27,33,37,43,48,53,58,62,68,
	74,79,84,90,96,101,107,113,119,124,130,137,144,150,157,164,
	170,177,184,191,198,205,211,218,217,216,210,202,196,189,183,176,
	170,163,156,148,141,135,128,120,112,103,95,87,78,70,62,54,
	5,12,20,28,36,44,51,59,67,75,82,90,98,105,112,121,
	128,135,143,151,159,166,174,181,189,197,205,212,220,228,235,244,
	251,244,237,229,221,214,206,198,191,184,177,171,164,158,152,146,
	141,135,130,124,118,113,107,102,96,91,86,81,75,70,65,60,
	55,50,46,40,36,31,30,36,43,51,58,65,73,81,88,96,
	103,111,119,126,133,140,148,156,163,171,178,186,193,201,208,216,
	224,231,239,246,249,242,235,227,219,212,203,197,189,181,174,166,
	159,152,144,136,128,127,128,131,132,133,134,135,136,137,138,138,
	139,140,140,140,140,140,140,140,140,140,139,139,138,137,137,136,
	135,134,133,132,131,130,129,133,140,148,156,164,171,179,187,195,
	202,210,218,226,233,241,249,246,238,231,223,215,207,199,191,184,
	176,168,161,153,144,137,129,121,113,105,97,89,82,74,66,58,
	51,43,34,27,24,29,33,38,43,48,53,58,63,68,73,79,
	84,89,95,100,105,111,117,123,128,134,140,146,152,158,164,170,
	176,182,188,194,201,208,214,219,215,208,202,195,188,181,174,168,
	162,154,148,141,134,127,120,113,105,98,90,81,73,65,58,51,
	5,12,21,28,36,44,52,59,67,75,82,90,97,105,113,120,
	129,135,143,151,159,166,174,181,189,197,205,212,220,228,236,243,
	251,244,236,229,221,215,209,203,196,190,184,178,173,166,160,154,
	149,143,138,132,126,121,116,110,105,100,95,89,84,79,74,69,
	64,59,54,50,45,40,37,38,45,52,60,67,75,82,90,98,
	105,112,119,128,135,143,150,157,165,173,181,188,195,203,210,218,
	225,233,241,248,247,240,233,225,217,209,202,194,187,179,172,164,
	157,149,141,134,126,120,118,118,119,120,122,123,123,124,125,125,
	126,126,127,127,127,128,128,127,127,127,127,127,125,124,124,123,
	122,121,120,119,118,120,127,135,142,150,158,166,174,182,190,197,
	204,212,220,228,235,244,251,244,235,228,220,212,204,197,189,181,
	174,166,157,150,142,135,126,119,111,103,95,87,79,72,64,56,
	48,40,33,31,34,39,44,49,54,59,64,69,74,79,84,89,
	95,100,105,110,116,121,127,132,138,144,150,155,161,167,174,179,
	186,191,197,204,210,215,217,219,212,205,198,191,184,178,171,164,
	157,150,143,136,130,122,116,109,102,95,87,80,73,65,57,51,
	5,12,20,28,36,44,51,59,67,74,82,90,97,106,113,121,
	128,137,143,150,158,166,174,181,189,197,205,212,220,228,236,243,
	251,244,237,229,221,217,215,210,204,198,192,186,180,175,169,163,
	157,152,146,141,136,129,124,119,114,108,103,98,93,88,83,79,
	74,69,64,59,54,50,45,42,45,53,61,69,76,83,91,99,
	106,113,121,129,137,144,151,159,167,174,182,190,197,204,212,220,
	227,235,242,250,245,238,230,223,216,208,200,192,185,177,169,162,
	154,146,139,131,124,116,110,107,107,108,109,110,111,111,112,113,
	114,114,114,115,115,115,115,115,115,114,113,113,112,111,111,110,
	109,109,108,110,115,122,130,138,145,154,161,169,176,184,192,200,
	207,215,223,231,238,246,249,241,233,226,218,210,202,194,186,179,
	171,163,155,147,140,132,124,116,108,100,93,85,77,69,62,54,
	46,39,37,40,45,50,54,59,65,69,74,79,84,89,94,99,
	105,110,115,120,126,132,137,143,148,154,160,165,172,178,183,189,
	195,201,208,213,215,214,214,218,211,204,197,190,183,176,170,163,
	156,149,142,136,129,122,115,108,102,95,87,80,73,66,58,51,
	5,13,20,28,36,44,51,59,67,75,82,89,97,105,113,121,
	129,137,143,150,158,166,174,182,189,197,205,213,220,228,236,243,
	251,244,236,229,221,213,215,218,212,206,200,195,188,182,177,171,
	166,160,155,149,143,138,133,128,123,118,112,107,102,97,92,87,
	83,78,73,68,64,59,55,50,49,55,62,70,77,84,92,100,
	108,115,122,130,138,145,153,161,168,176,184,191,199,206,213,221,
	229,237,244,251,243,236,229,221,213,206,198,191,182,175,167,160,
	152,145,137,129,122,114,106,99,96,95,96,97,98,99,100,100,
	101,101,101,102,102,102,102,102,102,101,101,100,99,99,98,97,
	96,98,102,109,117,125,133,140,148,156,163,171,179,186,194,202,
	210,218,225,233,241,249,246,238,231,223,216,208,200,192,185,177,
	169,161,153,146,138,129,122,114,106,98,91,83,75,67,60,52,
	44,43,47,52,56,61,65,70,75,80,84,90,95,99,104,110,
	115,120,126,131,137,142,147,153,158,164,170,175,182,188,193,199,
	205,211,215,214,211,210,215,217,210,203,196,190,183,175,169,162,
	155,148,141,135,128,121,115,108,101,94,87,80,73,66,58,51,
	5,13,20,28,36,43,51,59,67,74,82,90,98,105,113,121,
	129,136,144,151,158,166,173,182,189,197,205,212,220,228,236,243,
	251,244,236,229,221,214,207,213,218,214,209,203,197,191,186,180,
	174,169,163,157,153,147,142,136,131,126,121,116,111,106,101,96,
	91,87,82,77,72,68,63,59,55,57,63,70,78,86,93,101,
	109,116,124,131,139,147,154,162,170,177,185,192,200,208,215,223,
	231,239,246,250,242,234,226,219,211,204,196,189,181,173,166,158,
	150,143,135,127,119,112,104,96,89,85,83,84,86,87,87,88,
	88,88,89,89,90,89,89,89,89,89,88,87,87,86,85,86,
	90,96,104,112,119,128,135,143,151,158,166,174,181,189,197,204,
	212,220,228,236,243,251,245,237,229,221,213,206,198,190,183,175,
	167,159,151,143,135,127,120,112,104,96,89,81,73,65,58,51,
	49,53,57,62,66,71,76,81,86,90,95,100,105,109,115,120,
	125,131,136,141,147,152,157,163,169,174,180,185,191,197,203,209,
	214,215,212,207,205,209,216,216,209,202,195,189,181,175,168,161,
	154,147,141,134,127,121,114,107,100,93,87,80,73,65,58,51,
	5,12,20,28,36,44,51,59,67,74,82,90,98,105,113,121,
	128,136,143,151,159,166,174,182,190,197,205,213,220,228,236,243,
	251,244,237,229,221,213,206,205,211,216,216,211,205,200,194,188,
	182,177,172,166,161,155,150,145,139,134,130,124,119,115,109,105,
	100,96,91,86,82,77,72,68,64,61,65,72,79,87,95,102,
	110,117,125,133,140,148,155,163,171,178,186,194,201,209,217,224,
	232,240,248,248,240,233,225,217,210,202,194,187,179,172,164,156,
	149,141,133,125,118,110,102,94,87,80,75,72,73,74,74,75,
	76,75,76,76,76,76,77,76,76,75,75,74,74,74,77,83,
	91,99,106,114,122,129,137,145,152,160,168,175,184,192,199,207,
	214,222,230,238,246,250,242,234,226,219,211,204,196,188,180,172,
	164,157,149,141,133,125,118,110,103,95,86,79,71,63,57,56,
	60,64,69,73,77,81,86,91,96,101,105,110,115,120,125,130,
	135,141,146,151,156,162,167,173,178,183,189,195,201,207,213,216,
	214,210,203,200,204,211,217,215,208,201,195,188,181,174,167,160,
	154,147,140,134,127,120,113,106,100,92,86,79,72,65,58,52,
	5,13,20,28,36,44,51,59,66,74,82,89,97,105,113,120,
	128,136,144,152,160,166,174,182,189,197,205,212,220,228,236,243,
	251,244,237,229,221,213,205,197,203,209,214,218,213,207,202,196,
	191,185,179,175,169,164,158,154,148,143,138,133,129,123,119,113,
	109,104,100,95,91,86,82,77,73,69,66,72,80,88,95,103,
	111,118,126,134,141,149,157,164,172,179,188,195,203,210,218,225,
	233,241,249,246,239,231,223,216,208,201,193,186,178,170,162,154,
	146,139,131,124,116,108,100,93,85,77,70,63,61,61,61,62,
	63,63,64,63,63,64,64,63,63,63,62,62,64,70,78,85,
	93,101,109,116,124,132,139,147,155,163,170,178,186,194,201,209,
	217,225,232,240,248,248,240,232,224,217,209,201,193,185,178,170,
	162,154,147,139,131,124,116,108,101,92,85,78,69,62,62,66,
	70,75,79,83,88,92,97,101,106,111,116,121,126,130,135,140,
	146,151,156,162,166,172,177,183,189,194,199,205,211,216,216,211,
	206,200,195,198,204,212,218,214,207,201,194,188,181,174,167,160,
	153,146,140,133,126,120,113,106,99,93,86,79,72,65,58,51,
	4,12,20,28,36,44,52,59,67,74,82,89,98,105,113,120,
	128,137,143,152,159,166,174,182,189,197,205,212,220,228,236,243,
	251,245,237,229,221,213,206,198,195,200,206,212,216,215,210,204,
	199,194,189,183,177,172,167,162,157,152,146,141,137,132,128,123,
	118,113,109,104,100,95,91,87,82,78,74,74,81,89,97,104,
	112,120,127,135,142,150,158,165,173,181,189,196,204,211,219,227,
	235,242,250,246,238,230,222,214,207,199,191,184,176,168,160,152,
	144,137,129,121,114,106,98,91,83,75,67,59,53,49,49,50,
	50,51,51,51,51,51,51,51,50,50,51,57,64,72,80,88,
	95,103,111,118,126,134,141,149,157,165,172,180,188,196,204,211,
	219,227,234,242,250,246,238,230,222,214,206,199,191,184,176,168,
	160,153,145,137,129,122,114,106,99,91,83,75,68,69,73,77,
	81,85,89,94,99,103,107,112,116,121,126,131,136,141,146,150,
	156,161,166,172,176,182,187,193,199,203,209,215,217,213,207,202,
	196,190,192,199,206,213,219,213,207,199,193,186,180,173,166,159,
	152,146,139,133,125,119,112,105,98,92,85,79,71,64,58,51,
	5,12,20,27,36,43,51,59,66,74,82,90,97,105,113,121,
	128,136,144,151,160,167,174,183,190,198,205,213,221,229,236,244,
	252,244,237,228,222,213,205,198,190,193,198,204,210,215,219,214,
	208,203,198,193,187,182,177,171,166,161,157,152,147,142,137,132,
	127,123,118,114,110,105,101,97,93,89,84,80,82,90,98,105,
	113,121,129,136,144,152,160,167,174,182,191,198,205,213,222,229,
	236,244,252,245,237,229,221,213,205,198,191,183,175,167,159,152,
	144,136,129,121,113,106,98,89,82,75,66,59,51,43,37,37,
	38,39,39,39,38,39,39,39,38,43,51,59,66,74,82,90,
	97,105,113,121,129,136,144,151,160,167,174,183,190,198,205,213,
	221,229,236,244,252,244,236,229,222,214,206,198,190,182,174,167,
	160,152,144,136,128,120,112,105,98,90,82,74,76,80,84,88,
	92,97,100,105,110,114,118,123,128,132,137,142,146,152,156,162,
	167,172,177,182,187,192,198,203,208,214,219,215,210,204,199,193,
	187,186,193,200,207,213,221,214,207,200,193,186,179,173,166,159,
	153,146,139,132,126,118,112,105,99,92,85,78,71,65,58,51
};


const float reference_init_data[] = {
	6,13,22,29,36,44,52,60,68,76,83,91,98,107,114,122,
	130,137,145,152,161,168,176,184,191,199,207,215,222,230,238,245,
	255,246,237,230,222,215,217,220,214,208,202,196,190,184,179,173,
	168,162,157,151,146,141,135,130,124,119,114,109,104,99,95,89,
	84,80,75,71,66,62,57,52,52,60,68,76,83,91,98,106,
	114,122,130,137,145,153,160,168,176,184,191,199,207,214,222,230,
	238,245,255,245,238,230,222,214,206,199,191,184,176,168,160,153,
	145,137,129,121,114,106,99,91,90,91,93,94,94,95,95,96,
	97,96,97,97,97,97,97,97,96,96,95,94,94,93,93,92,
	98,106,114,122,130,137,145,152,160,168,176,184,192,199,206,214,
	222,230,238,246,253,245,238,230,222,214,207,199,192,183,176,168,
	160,152,145,137,129,122,113,107,98,91,83,75,67,60,52,45,
	48,53,57,61,65,71,75,79,84,90,94,99,104,109,114,120,
	124,130,135,140,146,151,157,162,168,173,179,185,190,196,202,208,
	214,220,216,211,208,215,221,214,208,201,194,187,181,174,167,160,
	154,147,140,134,126,120,113,106,99,92,86,79,72,65,59,52,
	6,13,21,29,36,44,52,60,67,75,83,91,98,106,113,122,
	129,137,144,153,160,168,175,184,191,199,207,215,222,230,238,245,
	255,246,238,230,222,218,218,212,206,199,194,188,183,176,170,165,
	160,154,148,143,137,132,126,122,116,111,106,100,95,91,85,81,
	76,71,66,61,57,52,47,44,52,60,68,75,83,91,98,106,
	114,121,130,137,144,153,160,167,175,183,191,199,206,215,222,230,
	237,245,253,245,238,230,222,215,207,199,191,183,176,168,160,152,
	145,137,129,122,114,106,99,101,102,103,104,105,105,106,107,107,
	108,108,108,109,108,108,108,108,108,108,107,106,105,105,103,103,
	102,106,114,122,129,137,144,152,160,168,176,183,191,199,206,214,
	222,229,237,245,253,245,237,230,222,214,206,199,191,184,175,168,
	160,153,145,137,129,121,114,106,98,90,83,76,67,60,53,45,
	39,43,48,52,57,61,66,71,76,81,85,90,96,101,106,110,
	116,122,126,132,137,143,148,154,159,165,171,176,182,189,194,200,
	206,212,217,219,212,214,221,214,208,201,194,187,181,173,167,160,
	154,147,140,133,126,120,113,106,99,92,86,79,73,66,59,52,
	6,14,21,29,36,45,52,60,68,76,83,91,99,107,114,122,
	129,137,145,152,160,168,176,183,191,199,206,214,222,229,238,245,
	253,245,238,230,222,216,210,204,198,192,186,180,174,168,162,157,
	151,146,140,134,129,124,118,113,108,102,97,92,87,82,77,72,
	67,62,57,53,48,43,39,45,52,59,68,76,83,91,99,107,
	114,122,129,137,145,153,160,168,176,184,191,199,207,215,222,230,
	237,246,253,245,237,230,222,214,206,199,192,183,176,168,160,153,
	145,137,129,122,114,109,111,113,113,115,115,117,117,118,119,119,
	119,120,120,120,120,120,120,120,120,119,119,118,117,116,115,114,
	113,112,114,122,129,137,145,152,160,168,176,184,191,199,206,214,
	223,230,238,245,253,245,238,230,222,215,206,199,191,183,176,168,
	161,153,145,137,130,122,114,106,99,91,83,76,67,59,52,44,
	37,35,39,43,48,53,57,62,67,72,77,82,87,91,97,102,
	107,112,118,123,129,134,140,145,151,157,163,168,174,180,186,192,
	198,204,209,216,220,214,221,215,208,201,194,187,180,174,167,160,
	154,147,140,134,127,120,113,106,100,93,86,79,72,66,58,53,
	6,13,21,29,36,44,52,60,68,76,83,90,99,106,114,121,
	130,137,144,152,160,168,176,184,191,199,206,214,222,229,237,245,
	253,245,238,230,222,215,206,199,192,184,178,172,166,160,154,148,
	143,137,132,126,120,115,110,105,99,94,89,84,78,73,68,63,
	58,53,48,44,39,35,37,44,52,60,68,76,83,91,99,106,
	114,122,130,137,145,153,161,168,176,184,191,199,207,215,222,230,
	238,245,253,245,237,230,222,214,207,199,191,184,176,168,160,152,
	144,137,129,122,120,121,122,124,124,125,127,128,129,129,129,131,
	130,131,131,131,131,131,131,131,131,131,130,130,128,128,127,126,
	125,124,122,122,129,137,145,153,161,168,176,183,191,199,207,214,
	222,230,238,245,253,245,238,230,222,214,207,199,191,183,176,168,
	160,152,145,137,130,121,114,106,99,90,83,75,68,60,52,44,
	36,29,30,35,39,44,48,53,58,63,68,73,78,83,88,94,
	99,104,110,115,121,126,132,137,143,148,154,160,166,172,178,183,
	190,196,202,208,215,221,221,214,208,201,194,188,180,174,167,161,
	153,147,140,133,127,120,113,106,99,93,86,79,72,66,59,52,
	6,13,21,29,36,44,52,60,67,75,83,90,99,106,114,121,
	129,138,145,153,160,168,176,183,191,199,207,214,223,230,237,245,
	253,245,237,230,223,215,207,199,191,184,176,168,160,153,146,140,
	135,129,124,118,112,107,101,96,91,85,80,75,70,65,59,55,
	49,44,40,35,30,29,36,45,52,60,67,75,83,90,99,106,
	114,122,129,137,145,153,160,168,176,183,191,199,206,215,222,230,
	238,245,253,245,238,230,222,214,207,199,191,184,176,168,160,152,
	144,137,129,129,131,132,133,135,136,138,138,139,140,140,141,142,
	142,142,143,143,143,143,143,142,142,142,141,141,140,139,138,137,
	136,135,133,132,131,137,145,152,160,168,176,183,191,199,206,215,
	222,230,238,245,253,245,238,230,223,215,207,199,191,184,176,168,
	160,152,145,137,129,121,114,106,99,91,83,76,68,60,52,44,
	36,29,21,26,30,35,40,44,49,54,60,65,69,75,80,86,
	90,96,102,106,112,118,123,128,135,140,146,151,158,164,170,176,
	182,188,194,201,207,214,221,218,211,205,198,191,185,178,172,165,
	158,151,145,138,131,125,118,111,104,97,90,84,76,69,62,55,
	6,14,21,29,37,45,52,60,67,76,83,91,98,106,114,121,
	130,137,145,152,160,168,175,183,191,199,206,214,222,230,237,245,
	253,245,237,230,222,215,207,199,191,184,176,168,160,153,144,137,
	130,122,115,109,104,98,93,88,82,76,71,66,61,56,50,46,
	41,35,31,26,21,29,37,45,52,59,67,75,83,91,98,106,
	114,122,130,137,145,152,160,168,176,183,191,199,206,215,222,230,
	237,245,253,245,238,230,222,214,207,199,191,184,176,168,160,153,
	145,137,139,140,142,143,145,146,148,149,150,150,151,152,153,153,
	154,154,155,154,155,154,154,154,153,153,153,152,151,150,150,148,
	148,147,145,144,143,141,144,152,160,168,176,184,191,199,207,214,
	222,229,238,245,253,246,237,230,222,214,206,199,191,183,176,168,
	161,153,145,137,129,121,114,106,99,90,83,75,67,59,52,45,
	37,29,22,17,22,26,31,35,41,46,50,56,61,66,71,77,
	82,88,93,99,104,109,115,121,127,134,140,146,153,160,167,174,
	181,188,194,201,208,215,221,217,219,212,205,199,193,186,179,173,
	165,159,153,145,139,132,126,118,111,104,97,90,83,76,69,62,
	6,14,21,28,37,44,52,60,67,75,83,90,99,107,114,121,
	129,137,145,152,160,168,175,184,191,199,207,214,222,229,237,245,
	253,245,237,230,222,215,207,199,191,184,176,168,160,152,145,137,
	129,122,113,106,98,91,85,79,74,68,63,57,52,47,42,37,
	32,27,22,17,22,29,37,44,52,60,67,75,83,90,99,106,
	114,122,130,138,145,153,161,168,175,183,191,199,207,214,223,230,
	237,246,253,245,238,230,222,215,206,198,191,184,176,168,160,153,
	147,148,151,152,153,155,157,158,159,160,161,162,163,164,164,165,
	165,165,166,166,166,165,165,165,165,164,164,163,162,162,161,160,
	159,158,156,155,153,152,151,153,161,168,176,183,191,199,207,215,
	222,230,237,246,253,245,238,229,222,214,207,199,191,183,176,168,
	160,152,145,137,130,121,114,106,98,91,83,75,67,60,52,44,
	36,29,21,13,13,18,22,27,32,37,42,47,52,57,62,68,
	73,79,86,93,100,106,113,120,127,134,140,147,153,161,167,174,
	181,187,194,200,207,214,221,214,216,220,214,206,200,194,187,180,
	173,167,160,154,146,139,132,125,119,112,104,97,90,83,76,68,
	10,17,25,32,39,47,53,61,68,76,83,91,98,107,114,121,
	130,137,144,153,160,168,176,183,191,199,207,214,222,230,238,245,
	253,245,238,230,222,214,207,199,191,183,176,168,161,153,145,138,
	129,121,114,106,99,91,83,75,67,60,55,49,44,39,33,29,
	23,18,14,14,22,29,37,44,52,60,67,75,83,90,99,106,
	114,122,129,137,145,153,161,168,175,184,192,198,207,214,222,230,
	237,245,253,246,238,229,222,215,207,199,191,183,176,168,160,156,
	158,160,162,163,165,166,168,169,170,171,173,174,175,175,175,176,
	176,177,177,178,177,178,177,177,176,177,176,175,174,174,173,172,
	170,169,168,167,165,163,161,160,161,168,175,183,192,199,207,214,
	222,230,237,245,253,246,238,230,222,214,206,199,192,183,176,168,
	161,153,145,137,129,122,114,106,98,91,83,75,68,60,52,45,
	37,28,22,13,6,9,13,18,24,28,34,38,46,52,59,66,
	72,79,86,92,100,106,113,120,127,133,140,146,154,160,167,174,
	180,187,194,201,208,214,221,214,209,215,221,215,207,201,195,188,
	181,174,167,160,154,147,140,133,126,119,111,105,97,90,83,75,
	16,24,32,39,46,54,60,68,76,82,90,97,104,111,118,126,
	133,140,146,154,161,168,176,184,191,199,207,215,222,230,238,245,
	253,245,238,230,222,214,206,199,191,183,176,168,161,153,145,137,
	130,122,113,106,98,90,83,76,67,60,52,44,37,30,25,20,
	15,10,6,13,21,29,37,44,52,60,68,76,83,91,99,106,
	114,122,130,137,145,153,160,168,175,184,192,199,207,214,222,230,
	237,245,253,246,237,230,222,214,206,199,191,183,176,168,165,167,
	169,171,173,174,176,178,179,181,182,183,184,185,185,187,187,187,
	188,189,189,188,188,189,188,188,188,188,187,186,186,185,183,183,
	182,180,179,178,177,175,173,171,170,168,175,183,191,199,207,214,
	222,229,237,245,253,245,237,230,223,215,206,199,191,184,175,168,
	161,153,145,137,130,122,114,107,99,91,83,76,68,60,53,44,
	37,29,22,13,6,1,5,12,18,25,32,39,45,52,59,66,
	73,79,85,93,99,106,113,120,127,133,140,147,153,160,167,173,
	180,187,194,200,208,214,221,214,207,207,214,220,215,209,201,195,
	188,181,175,168,161,154,147,140,133,126,119,111,105,97,90,82,
	23,30,38,46,53,60,67,75,82,89,97,104,111,118,125,133,
	140,147,154,161,168,175,182,189,195,202,209,216,222,230,238,245,
	253,246,238,229,222,215,207,199,191,184,176,168,160,153,145,137,
	130,122,114,106,98,91,83,75,68,60,52,44,37,29,21,13,
	6,2,5,14,21,28,37,45,52,60,68,76,83,91,99,106,
	113,121,129,137,145,152,160,168,176,183,191,199,207,214,222,229,
	237,245,253,245,238,230,222,214,207,199,191,184,176,174,177,178,
	180,183,184,186,188,189,190,192,193,194,195,196,197,198,199,199,
	200,200,200,200,201,200,200,199,200,199,198,197,197,196,195,194,
	193,191,191,190,188,186,184,182,180,178,176,184,191,199,206,215,
	223,230,237,245,253,245,237,230,222,214,206,199,192,183,175,168,
	160,153,145,137,130,121,114,106,98,90,83,76,68,60,52,44,
	37,29,22,17,11,5,4,11,18,25,32,39,45,52,59,65,
	72,79,86,93,99,106,113,120,126,133,140,147,154,160,167,174,
	180,188,194,201,208,214,221,214,208,201,206,213,220,216,209,202,
	196,188,181,175,168,161,154,147,140,133,125,118,111,104,97,90,
	30,37,45,52,60,67,74,82,89,97,104,111,118,126,132,140,
	147,154,162,168,175,182,189,195,202,209,217,219,222,230,238,245,
	253,245,237,230,222,214,207,199,191,183,175,168,161,152,145,137,
	129,122,114,106,99,91,83,75,68,60,52,44,37,29,21,13,
	6,5,10,16,22,29,37,44,52,60,67,76,83,91,99,106,
	114,122,129,137,145,153,160,168,175,183,192,199,207,215,222,230,
	237,245,253,245,237,229,222,214,207,199,192,184,183,186,188,190,
	192,194,196,197,199,201,202,204,205,205,207,208,209,209,209,210,
	211,211,211,211,212,212,211,211,211,210,210,209,208,208,207,206,
	205,203,202,201,199,197,195,194,192,190,187,185,191,199,206,215,
	222,230,238,245,253,245,238,230,222,215,206,198,191,183,175,168,
	160,153,145,137,129,121,114,106,98,91,83,76,68,59,54,49,
	44,38,32,27,22,16,10,12,18,25,32,38,46,52,59,66,
	72,79,86,93,99,106,113,120,126,133,140,147,153,160,167,174,
	180,187,194,201,207,215,221,215,207,201,199,206,212,219,217,210,
	203,196,189,182,175,168,161,154,147,140,132,125,119,111,103,97,
	36,44,51,58,66,74,81,88,96,103,111,117,125,132,140,147,
	154,161,168,175,183,190,197,203,211,217,218,214,223,229,238,245,
	253,245,237,230,222,215,207,199,191,184,176,168,160,153,145,138,
	129,122,114,107,98,91,83,75,68,60,52,45,36,29,21,13,
	9,14,20,26,31,37,43,48,53,60,67,76,83,91,99,106,
	113,122,129,138,145,153,161,168,175,184,191,199,207,215,222,230,
	237,245,253,246,237,230,222,214,207,199,191,192,195,197,199,201,
	203,205,207,209,210,212,213,215,216,217,218,219,220,221,221,222,
	222,223,222,223,223,223,223,223,222,222,222,221,220,218,218,217,
	216,214,213,212,210,208,207,205,203,201,199,197,194,199,207,214,
	222,230,238,245,253,246,238,230,222,214,207,199,192,183,175,168,
	160,153,144,137,129,122,114,106,98,91,84,79,74,69,64,58,
	54,48,43,37,32,25,20,15,18,25,32,39,45,52,59,65,
	72,79,85,93,99,106,113,120,127,133,140,146,154,161,167,174,
	181,188,194,201,208,214,221,214,208,201,194,198,204,212,218,217,
	210,203,196,189,182,175,168,161,154,146,140,133,125,117,110,103,
	43,50,57,65,73,81,87,95,102,110,117,124,132,140,146,154,
	161,168,175,182,189,196,204,211,217,218,211,215,222,230,238,245,
	253,245,238,230,222,215,206,199,191,183,176,168,160,153,145,137,
	129,122,114,106,99,91,83,75,68,60,52,44,37,29,21,14,
	19,24,30,36,42,47,53,58,64,68,74,79,84,91,98,106,
	114,122,130,137,145,152,160,168,175,184,191,199,207,214,222,230,
	237,246,253,245,237,230,222,215,206,199,201,203,206,208,210,213,
	214,216,218,220,221,223,224,226,227,228,230,231,231,232,232,234,
	233,234,234,234,234,235,234,234,234,234,233,232,232,231,230,229,
	227,226,225,223,222,220,218,216,214,213,211,208,206,203,206,214,
	223,230,237,245,253,246,238,230,222,214,206,199,191,184,176,168,
	161,153,145,137,130,122,114,109,104,99,94,90,85,79,74,69,
	63,58,52,47,41,36,30,25,19,25,32,39,45,52,59,65,
	73,79,86,93,99,107,113,120,127,133,140,147,154,160,167,174,
	181,187,194,201,207,214,221,214,207,201,194,190,198,204,211,218,
	217,211,203,196,190,182,175,169,161,153,146,139,132,124,117,110,
	49,57,64,72,80,87,95,101,109,117,124,132,139,146,153,161,
	168,175,182,189,197,204,211,218,218,211,207,215,222,229,237,245,
	253,245,237,230,222,214,206,198,191,183,175,168,160,152,145,137,
	129,122,114,106,98,91,83,76,67,60,52,44,37,29,22,22,
	28,34,40,45,51,57,63,68,74,79,84,89,95,100,105,110,
	115,121,130,137,144,152,160,168,175,183,191,199,207,214,222,230,
	237,245,253,245,237,230,222,214,206,209,212,214,217,220,222,223,
	225,228,229,231,233,234,236,237,239,239,241,242,243,243,244,244,
	245,245,245,246,246,246,245,245,245,244,244,243,243,242,241,240,
	238,237,236,234,233,231,229,227,226,224,221,219,217,215,212,215,
	222,230,237,245,253,245,238,229,222,214,207,199,191,184,175,168,
	160,152,145,138,133,129,124,119,114,109,104,100,94,90,84,79,
	74,68,62,57,52,46,40,34,28,25,32,38,45,52,59,66,
	72,80,86,93,100,106,113,119,127,133,140,147,153,160,167,174,
	181,187,194,200,208,214,221,215,208,201,194,187,190,197,204,211,
	218,218,211,204,197,190,183,175,168,161,153,146,139,131,124,116,
	56,63,71,78,86,94,102,108,116,124,131,138,146,154,160,167,
	175,182,190,197,204,210,218,218,210,203,207,214,222,230,238,245,
	253,246,237,230,222,215,206,199,191,183,176,168,161,153,145,137,
	129,122,114,106,98,91,83,76,68,59,52,45,37,29,26,32,
	38,44,50,56,61,67,73,78,84,89,94,99,105,110,115,120,
	125,130,135,139,145,153,160,168,176,184,191,199,207,214,222,230,
	237,245,253,246,238,230,222,215,217,221,223,225,228,231,233,235,
	237,239,241,243,244,246,247,248,250,251,252,253,252,251,250,250,
	250,249,248,249,249,248,249,249,249,250,250,251,252,252,252,251,
	250,248,248,245,244,242,241,239,237,235,233,230,228,226,223,220,
	222,230,238,245,253,245,237,230,222,215,206,199,191,183,176,168,
	161,157,153,148,143,139,135,130,125,120,116,110,104,100,94,89,
	84,78,72,67,62,56,50,44,38,32,32,39,45,52,59,66,
	72,79,86,93,99,106,113,120,126,133,140,146,153,161,167,174,
	181,188,194,201,208,215,221,215,207,201,194,187,183,189,197,203,
	210,218,218,211,204,197,190,182,175,167,160,153,145,138,131,124,
	62,70,77,84,93,101,107,115,123,130,137,145,153,160,167,174,
	182,189,197,204,211,218,217,210,203,199,206,214,222,230,238,245,
	253,245,238,229,222,215,207,199,192,184,176,168,161,152,145,137,
	129,122,114,107,99,91,83,75,68,60,52,44,36,30,35,42,
	48,54,59,65,72,77,83,88,94,99,105,110,115,120,126,130,
	135,140,145,150,154,159,163,168,176,183,191,199,207,215,222,230,
	237,245,253,245,237,230,223,226,229,231,234,237,239,242,244,247,
	248,250,252,252,251,249,247,246,245,244,242,242,241,240,239,239,
	238,238,238,237,238,237,238,238,238,239,239,240,240,241,243,243,
	245,246,248,249,251,252,253,250,248,246,244,242,239,236,234,232,
	228,230,237,245,253,245,238,229,222,214,207,199,191,184,180,176,
	172,168,163,158,154,150,145,140,135,130,125,121,115,110,105,99,
	94,88,82,77,71,65,60,54,48,41,35,39,46,52,59,66,
	72,79,86,93,99,106,113,119,126,133,140,147,154,160,167,174,
	181,187,194,201,208,215,221,214,207,201,194,187,181,182,190,196,
	203,210,217,218,211,204,196,189,182,174,168,160,153,146,137,131,
	68,76,83,92,99,106,115,122,129,137,144,152,160,166,174,181,
	189,196,204,210,218,217,211,204,196,199,207,215,222,230,237,245,
	253,246,237,229,222,214,207,199,191,183,176,168,161,152,145,137,
	129,121,114,106,98,91,83,75,67,60,52,45,37,38,45,51,
	57,63,69,75,81,87,93,99,103,109,115,120,126,130,136,140,
	145,151,155,160,165,169,174,178,182,187,191,198,206,215,222,230,
	237,245,253,245,238,231,234,237,239,243,246,247,250,253,251,249,
	247,244,242,241,239,238,236,234,233,233,231,230,229,228,227,227,
	226,226,226,226,225,226,226,227,226,227,227,229,229,230,231,232,
	233,235,236,238,239,241,242,244,247,249,251,252,250,248,246,243,
	240,236,238,245,253,245,237,230,222,214,207,203,199,195,191,187,
	182,179,173,169,165,160,155,150,146,140,136,130,125,120,114,109,
	103,98,92,87,81,75,69,64,57,52,46,38,45,52,59,66,
	72,79,86,93,99,106,113,120,126,133,140,147,154,160,167,174,
	181,187,194,201,208,214,221,214,208,201,194,187,180,175,182,190,
	196,203,210,218,218,210,204,196,188,182,174,167,159,152,145,137,
	75,82,90,98,105,114,121,128,136,144,151,158,166,173,180,188,
	195,203,210,218,217,211,203,196,191,199,207,214,222,229,237,245,
	253,245,237,230,222,214,207,199,191,184,175,168,160,153,145,138,
	130,122,114,106,98,91,83,75,68,59,52,45,42,49,55,61,
	67,73,79,85,91,97,102,108,114,119,125,130,136,140,145,151,
	156,161,166,171,175,180,185,189,193,197,201,206,210,215,222,230,
	237,245,253,245,239,241,245,248,251,252,250,247,245,242,240,237,
	235,233,231,230,228,226,225,223,222,220,219,218,217,217,216,215,
	215,214,214,215,214,214,214,214,215,216,217,217,218,219,219,220,
	222,224,225,226,228,229,231,233,235,237,239,242,244,247,249,252,
	251,248,245,246,253,245,237,230,225,221,217,214,210,206,202,198,
	193,189,184,180,175,170,165,161,156,151,146,140,136,130,125,120,
	114,108,102,97,91,85,79,73,67,61,55,49,46,52,59,65,
	72,80,86,93,99,106,113,120,127,133,140,147,153,160,167,174,
	181,188,195,201,208,214,221,215,208,200,194,187,180,174,175,182,
	189,197,203,210,218,218,210,203,195,188,181,174,166,159,151,144,
	81,89,97,105,112,119,127,135,143,151,158,165,172,180,188,195,
	202,210,217,218,211,204,196,189,191,199,207,214,223,230,238,245,
	253,245,237,230,222,214,207,198,191,184,175,168,160,153,145,137,
	129,122,114,107,99,90,83,76,68,60,52,46,52,59,65,70,
	77,83,89,95,100,106,112,118,124,129,135,140,146,151,156,162,
	166,171,176,181,185,191,194,199,204,208,212,216,221,225,228,232,
	237,245,253,246,250,252,250,247,244,241,238,235,233,231,229,226,
	224,222,220,218,217,215,213,212,210,209,208,207,206,205,205,204,
	204,204,203,203,203,203,203,203,204,205,205,206,206,207,208,209,
	210,212,213,215,217,218,220,222,224,226,229,231,233,236,239,241,
	244,247,250,252,253,246,243,240,236,232,229,224,221,216,212,208,
	204,199,195,190,185,181,176,171,167,161,156,151,146,140,134,129,
	123,119,113,107,101,95,89,83,76,71,64,58,51,52,58,65,
	72,79,85,93,99,106,113,120,126,134,140,147,154,160,167,174,
	181,187,194,200,208,214,221,215,208,201,194,187,180,173,168,174,
	182,189,196,203,211,218,217,210,202,195,188,180,172,165,158,150,
	88,95,103,110,118,126,134,142,149,157,164,172,180,187,194,202,
	209,216,219,211,204,196,189,184,191,199,207,214,222,230,237,245,
	253,245,238,230,222,214,207,199,191,183,176,168,160,152,145,137,
	130,122,114,107,99,91,83,75,68,60,52,54,62,68,74,80,
	86,93,99,105,111,116,122,128,134,139,145,151,156,161,167,171,
	177,182,187,191,196,201,206,209,214,218,222,227,231,235,239,243,
	246,250,253,249,246,242,239,236,233,230,227,225,222,220,217,215,
	212,211,209,206,205,204,202,201,199,198,196,196,195,194,193,192,
	192,192,191,191,191,191,192,192,192,193,194,194,195,196,197,198,
	199,200,202,204,205,207,208,211,212,215,217,219,222,225,227,230,
	233,236,239,246,253,249,252,250,246,243,239,235,231,227,223,218,
	214,209,205,200,196,191,187,182,176,172,167,161,155,150,144,139,
	134,128,123,117,111,105,99,92,86,81,74,67,61,55,59,65,
	72,79,86,92,99,107,113,119,127,134,140,147,154,160,167,173,
	181,187,195,201,208,215,221,214,207,201,194,187,181,174,167,168,
	175,182,189,196,204,211,218,216,209,202,195,187,179,172,164,156,
	93,102,110,117,125,132,140,148,156,164,171,179,186,194,200,209,
	215,219,212,204,197,190,182,183,191,199,207,214,222,229,238,246,
	253,245,238,230,222,215,207,199,191,184,176,168,160,152,144,137,
	129,122,114,106,98,91,83,76,68,60,58,64,70,77,83,90,
	96,102,108,115,120,126,132,138,143,149,155,161,166,171,176,181,
	187,192,196,201,206,211,215,220,225,229,233,237,242,246,250,253,
	248,245,253,246,238,232,228,225,222,219,216,214,211,208,206,204,
	202,199,197,195,194,192,191,189,188,186,185,184,183,183,182,182,
	180,181,180,180,180,180,181,180,181,181,182,182,183,185,185,187,
	188,189,191,192,194,196,198,200,202,203,206,208,211,214,216,219,
	222,229,237,245,253,245,241,245,248,253,250,245,241,238,233,229,
	225,221,215,212,207,202,196,191,186,181,177,171,166,160,155,149,
	143,138,132,126,121,115,108,103,96,90,84,77,71,64,58,65,
	72,79,86,92,99,106,113,120,126,133,140,146,153,160,167,174,
	180,188,194,201,207,214,221,214,208,201,194,188,180,174,167,161,
	168,175,182,189,197,204,211,219,216,209,201,194,186,178,171,163,
	100,108,116,123,131,139,146,155,162,170,177,185,192,200,207,215,
	220,213,205,197,190,183,176,184,191,199,206,214,222,230,238,245,
	253,245,238,230,222,214,207,199,191,183,176,168,160,152,145,137,
	129,122,114,106,98,91,83,76,67,60,67,74,80,87,93,99,
	106,112,118,125,130,136,142,148,153,159,165,171,176,182,186,192,
	197,202,207,212,217,222,226,231,235,239,244,249,253,249,246,242,
	238,245,253,245,237,230,222,215,211,208,205,203,199,197,195,193,
	190,189,186,184,183,181,179,178,176,175,174,173,172,172,170,170,
	169,169,169,168,168,169,169,169,170,169,170,171,172,173,174,175,
	176,178,179,181,182,184,186,188,190,193,195,198,199,203,207,214,
	222,230,238,245,253,245,237,234,238,242,245,249,253,248,244,240,
	235,231,226,221,217,212,207,202,197,192,187,181,176,170,165,159,
	153,148,142,136,130,124,118,112,106,99,93,86,80,73,66,66,
	72,79,86,93,99,106,113,120,127,134,140,147,154,161,167,174,
	180,188,194,201,208,215,221,214,208,201,194,188,180,174,167,160,
	161,168,175,183,190,197,205,212,219,215,208,200,192,185,177,170,
	106,114,122,130,137,145,152,161,169,176,183,192,199,207,214,220,
	213,206,198,190,183,176,176,183,192,199,207,214,222,230,238,246,
	253,245,238,230,222,215,207,199,191,183,176,168,161,153,145,137,
	129,122,114,106,99,91,83,76,68,69,76,83,89,96,103,109,
	115,122,127,134,139,146,152,157,164,169,175,180,186,191,197,202,
	208,212,218,222,227,232,236,242,246,250,252,247,243,239,235,231,
	238,246,253,246,238,230,222,214,206,199,194,191,189,186,184,181,
	179,177,175,173,171,169,168,166,165,164,162,161,161,160,159,159,
	158,157,157,157,157,157,158,158,158,159,159,160,161,162,162,164,
	165,166,168,169,171,173,174,177,179,182,184,186,191,199,207,215,
	222,230,238,245,253,246,238,230,227,231,235,238,242,247,251,251,
	246,241,237,232,227,223,217,213,207,202,197,191,186,180,175,169,
	164,158,151,146,140,134,128,121,116,109,103,96,90,83,76,70,
	73,79,86,93,99,106,113,120,126,134,140,147,153,160,167,174,
	181,187,194,201,208,214,221,214,208,201,194,187,181,173,167,160,
	154,162,169,176,184,191,198,205,213,220,214,206,199,191,184,176,
	112,120,128,136,143,152,159,167,175,182,190,197,205,213,221,214,
	206,199,192,184,177,169,176,184,191,199,207,214,222,229,238,246,
	253,246,237,230,222,214,207,199,192,183,176,168,160,152,145,137,
	129,122,114,106,99,90,83,75,72,78,86,92,99,106,112,118,
	125,131,138,143,149,156,162,167,174,179,185,190,196,201,207,212,
	217,223,228,233,237,243,247,252,250,245,241,236,232,228,224,230,
	237,245,253,245,238,230,222,214,207,199,191,184,177,175,173,170,
	167,165,164,162,160,158,157,155,154,152,151,150,149,148,147,147,
	147,146,145,145,145,146,146,146,147,147,147,148,149,150,151,153,
	153,155,156,158,160,162,163,165,168,170,175,183,191,199,206,214,
	222,230,237,245,253,245,238,230,222,220,224,228,232,236,241,245,
	250,252,248,243,238,232,228,223,218,212,207,201,196,190,185,179,
	173,168,162,155,149,143,137,131,124,118,112,105,99,92,85,79,
	73,79,86,93,100,106,113,120,126,133,140,147,154,161,167,174,
	180,187,195,201,207,215,222,215,207,201,194,187,181,174,167,161,
	154,155,161,169,177,184,192,199,206,214,221,213,206,198,191,183,
	118,126,134,142,150,158,166,174,181,189,197,205,212,220,215,207,
	200,192,184,178,170,168,176,184,191,199,207,215,222,230,238,245,
	253,245,238,229,222,215,206,199,191,184,176,168,160,153,145,137,
	129,122,114,106,99,90,83,76,82,88,95,101,108,115,121,127,
	134,140,147,153,160,165,171,178,183,189,195,200,206,212,217,222,
	227,233,238,243,248,253,249,244,239,234,230,225,221,217,223,230,
	237,246,253,245,238,230,222,214,206,199,192,183,175,168,162,159,
	156,154,152,151,149,147,145,144,142,141,140,139,137,137,136,136,
	135,135,134,134,134,134,135,135,135,135,136,136,138,139,140,141,
	142,144,145,146,148,150,152,154,160,168,176,183,191,199,206,214,
	222,230,237,245,253,245,237,230,222,215,213,218,221,226,230,234,
	239,244,248,253,248,243,238,232,227,222,217,211,206,201,195,189,
	184,177,171,165,159,153,147,141,134,127,122,115,108,101,95,87,
	81,79,86,92,99,107,113,119,126,133,140,147,153,160,167,174,
	180,188,194,201,207,214,221,214,208,200,195,188,181,174,167,160,
	154,147,155,163,170,177,185,192,200,207,215,220,212,204,197,189,
	124,132,141,148,156,164,172,179,188,195,203,211,219,216,208,201,
	193,186,178,171,163,168,175,183,191,199,207,214,222,230,238,245,
	253,246,237,229,223,214,206,198,191,183,175,168,160,152,145,137,
	130,121,114,106,98,90,83,83,90,97,104,110,117,125,131,138,
	143,150,156,163,169,175,182,187,193,199,205,211,216,222,227,233,
	237,243,248,253,248,243,238,233,229,224,220,215,211,214,222,230,
	237,246,253,245,238,229,223,215,206,199,191,183,175,168,160,152,
	146,143,141,139,138,136,134,132,131,130,129,128,126,125,125,124,
	124,124,123,123,123,123,123,123,123,124,125,126,127,128,128,129,
	131,133,134,136,138,140,145,153,161,168,175,183,191,199,207,215,
	222,230,238,245,253,245,238,230,222,214,206,207,211,215,220,224,
	229,234,238,243,247,253,248,243,238,232,227,221,216,210,205,199,
	193,187,181,176,169,163,156,150,144,137,131,124,117,110,104,97,
	90,83,86,93,99,106,113,119,127,134,140,147,154,160,167,173,
	181,187,194,201,208,215,221,214,208,200,194,188,181,174,167,161,
	154,147,148,155,163,171,178,186,193,201,208,216,218,211,203,195,
	130,138,146,154,162,170,178,186,194,202,210,217,218,210,202,194,
	187,179,171,164,161,168,176,184,191,199,207,214,222,230,237,245,
	253,245,238,230,222,214,206,199,191,183,176,168,160,153,145,137,
	129,122,114,106,99,91,85,92,99,107,113,120,126,134,140,146,
	153,160,166,173,179,185,191,197,203,209,215,220,226,232,237,243,
	248,253,247,243,238,232,227,223,218,213,209,205,207,215,222,230,
	237,246,253,245,238,230,222,214,207,199,191,184,176,168,161,153,
	145,137,130,127,126,124,123,121,120,118,117,116,115,115,113,112,
	112,112,112,111,111,112,111,112,112,113,114,115,115,116,117,118,
	119,121,123,124,129,137,145,152,161,168,175,184,191,199,206,214,
	222,230,237,246,253,245,238,229,222,214,207,199,201,205,209,213,
	218,223,227,233,237,242,247,253,248,243,237,232,226,220,215,209,
	203,197,191,185,179,172,166,159,153,147,140,134,127,120,113,106,
	99,92,86,93,99,106,113,119,127,134,140,147,154,160,167,174,
	180,187,194,201,207,215,221,215,207,201,194,187,180,173,167,160,
	154,147,141,149,157,164,172,179,187,194,202,210,218,217,209,202,
	136,144,152,161,168,176,184,192,200,208,215,219,212,203,195,187,
	181,173,165,158,160,168,176,183,191,199,207,214,222,229,237,245,
	253,245,238,230,222,215,206,198,192,184,176,168,160,153,145,137,
	129,121,114,107,98,91,94,102,108,115,122,129,136,143,149,156,
	163,169,175,182,188,194,200,207,212,219,224,230,236,242,247,253,
	248,243,237,232,227,222,218,212,208,203,199,199,207,214,222,230,
	237,245,253,246,238,230,222,214,207,199,191,184,175,168,161,152,
	145,137,130,122,115,113,111,110,108,107,106,105,103,103,102,101,
	101,100,100,100,100,100,100,100,101,101,102,103,103,104,105,107,
	109,109,114,122,129,137,145,152,161,168,176,184,191,199,207,215,
	222,230,238,245,253,245,238,230,222,214,207,199,191,194,199,203,
	208,212,217,222,228,233,237,243,248,252,247,242,236,230,225,219,
	212,206,201,195,188,182,176,169,163,156,149,143,136,130,122,115,
	108,102,94,93,99,106,112,120,126,133,140,147,154,160,167,174,
	180,187,194,200,208,214,221,214,208,201,194,187,181,174,167,160,
	153,146,140,142,150,157,165,173,180,188,196,203,211,219,216,208,
	143,150,158,166,174,182,190,198,206,214,220,213,205,197,189,181,
	174,166,159,153,160,168,176,183,191,199,206,214,222,230,238,245,
	253,245,238,230,222,214,207,199,191,184,176,168,161,153,145,137,
	130,122,114,107,98,96,103,110,117,124,131,139,145,152,159,166,
	172,179,185,191,198,204,210,216,222,228,235,240,246,251,249,243,
	238,232,227,222,217,212,207,202,197,193,192,199,207,214,222,230,
	238,245,253,245,237,230,222,214,207,199,192,183,176,168,160,152,
	145,137,129,121,114,106,100,99,97,95,94,93,93,92,90,90,
	90,89,89,89,89,88,89,89,90,90,91,92,92,93,95,95,
	99,106,114,122,129,138,145,152,160,168,176,184,192,199,207,215,
	222,230,237,245,253,245,237,230,222,214,207,199,191,184,188,193,
	198,202,207,212,216,222,228,232,238,243,248,252,246,240,234,228,
	222,217,210,204,197,191,185,179,172,165,159,152,145,139,131,125,
	117,111,104,96,100,106,113,120,127,133,140,147,154,160,167,174,
	181,187,195,201,208,215,221,214,208,201,194,187,180,174,167,160,
	154,147,140,136,143,151,158,166,173,181,190,197,205,213,220,214,
	148,156,165,172,180,189,197,205,212,220,215,206,199,191,183,175,
	168,160,152,152,160,168,175,183,191,199,206,214,222,230,237,245,
	253,246,238,229,222,214,207,199,192,184,176,168,160,153,145,137,
	129,122,114,106,98,105,112,120,126,133,140,147,155,162,168,175,
	182,188,195,201,207,213,220,226,232,238,244,250,250,245,239,233,
	228,222,217,212,206,201,197,192,186,184,191,199,207,215,222,230,
	237,245,253,245,238,230,222,215,206,199,191,184,176,168,160,153,
	144,138,129,121,114,106,98,91,86,84,82,82,81,80,79,79,
	78,78,77,77,77,77,77,78,77,78,79,80,81,81,83,90,
	98,106,114,121,130,137,145,152,160,168,176,183,191,199,207,214,
	222,230,238,245,253,245,238,230,222,215,206,198,191,183,177,182,
	187,192,196,201,207,212,217,222,228,233,239,245,250,250,244,238,
	232,226,220,214,207,201,194,187,181,175,168,161,154,148,140,133,
	126,119,112,105,99,106,113,120,126,134,140,146,154,160,167,173,
	181,187,194,201,208,215,221,215,207,200,194,187,180,174,168,160,
	154,147,140,133,136,145,152,160,168,175,183,191,199,207,214,220,
	154,162,171,178,186,195,202,210,219,216,208,200,193,184,176,168,
	161,153,145,153,160,168,176,184,192,199,207,215,222,229,238,245,
	253,245,237,230,222,214,206,199,191,183,175,168,160,152,145,137,
	130,122,114,106,107,114,121,128,135,142,150,157,163,171,177,184,
	190,197,204,210,216,223,229,236,242,248,252,246,240,234,229,223,
	218,213,207,202,197,192,186,181,176,184,192,199,207,214,222,230,
	237,245,253,245,238,230,222,214,207,199,191,183,176,168,160,152,
	145,137,129,121,114,107,99,91,83,75,71,70,70,69,68,67,
	66,66,65,66,65,65,65,66,66,67,67,68,70,75,83,90,
	98,107,114,122,129,137,144,152,160,168,176,184,192,199,206,215,
	222,230,237,246,253,246,238,230,222,214,207,199,191,183,176,172,
	176,182,187,192,197,202,207,212,218,224,228,235,240,246,252,248,
	241,236,229,223,216,210,204,198,191,184,177,170,164,156,150,142,
	136,128,121,113,106,106,113,120,126,134,140,147,154,161,167,174,
	181,188,194,201,207,215,221,214,208,201,194,187,181,174,167,160,
	154,146,140,133,130,138,145,153,161,169,177,185,193,200,208,216,
	160,168,176,184,192,201,208,216,218,210,202,194,186,178,171,162,
	155,147,145,152,160,168,176,184,191,199,207,214,222,229,238,245,
	253,245,237,230,222,214,207,199,191,183,176,168,160,153,145,137,
	129,122,114,108,115,123,130,137,144,152,159,166,173,179,186,193,
	200,207,213,219,226,232,239,245,252,248,242,237,231,224,219,214,
	208,202,196,192,186,181,176,171,176,184,191,198,207,214,222,229,
	237,245,253,245,238,230,222,215,207,199,192,184,176,168,160,152,
	145,137,129,122,114,106,98,91,83,76,68,60,58,57,56,55,
	55,54,54,54,54,55,54,55,55,55,56,59,67,75,83,91,
	98,106,114,122,130,137,145,152,160,168,176,183,191,199,206,215,
	222,230,237,246,253,245,238,230,222,214,206,199,192,183,176,168,
	167,171,176,181,186,192,197,202,208,213,219,225,231,236,242,249,
	251,245,239,233,226,220,213,206,200,193,187,179,173,165,159,152,
	144,137,130,123,115,107,113,120,127,133,140,147,153,161,167,174,
	180,188,194,201,207,214,221,214,208,201,194,187,180,173,167,161,
	153,146,140,133,126,131,139,147,155,162,171,179,187,194,202,210,
	166,174,182,190,198,206,215,219,212,203,196,188,180,172,164,156,
	148,141,145,153,160,168,176,183,191,199,207,214,223,230,237,246,
	253,245,237,230,222,214,207,199,191,183,175,168,160,152,144,138,
	129,122,114,116,123,131,139,146,153,161,167,175,182,189,195,202,
	209,215,223,229,236,242,249,251,245,238,233,227,220,215,209,204,
	198,192,186,181,176,171,166,168,176,183,191,199,207,214,222,230,
	238,245,253,245,238,229,222,214,207,199,191,184,175,168,160,152,
	144,137,129,122,114,106,98,91,83,76,68,60,52,46,45,44,
	44,43,43,43,43,43,43,43,43,44,52,59,68,76,83,91,
	98,106,114,122,129,137,145,153,161,168,176,183,191,199,206,215,
	222,230,238,245,253,246,238,230,222,214,207,199,191,183,176,168,
	160,161,165,171,176,182,187,192,198,204,209,215,220,227,232,239,
	245,251,248,242,235,229,223,216,209,202,195,188,182,175,168,160,
	153,146,138,132,124,116,113,119,127,133,140,147,153,160,167,173,
	181,187,194,201,208,214,221,214,208,201,194,187,181,174,167,161,
	153,147,140,133,126,125,132,141,149,157,164,171,180,188,196,204,
	171,180,188,196,204,212,220,213,206,198,189,181,174,166,157,150,
	142,137,144,152,160,168,175,184,191,199,206,215,222,230,238,245,
	253,245,238,230,222,214,207,199,191,183,175,168,161,152,144,137,
	130,122,117,125,132,140,147,155,162,169,177,184,191,198,204,212,
	219,226,232,239,246,252,248,242,235,230,223,217,211,205,199,194,
	188,182,177,171,166,160,161,168,176,183,191,199,207,214,222,229,
	238,246,253,245,237,229,222,215,207,199,191,184,176,168,160,152,
	145,137,129,121,114,106,98,91,83,75,68,60,52,44,36,32,
	32,31,31,31,31,31,31,32,37,45,52,60,68,75,83,90,
	98,106,114,121,130,137,145,152,160,168,176,183,191,199,206,215,
	222,229,238,245,253,245,238,230,223,214,206,199,192,183,176,168,
	160,152,156,160,166,171,177,182,187,194,199,205,211,217,223,229,
	235,241,248,251,245,239,231,225,218,212,205,197,191,184,176,170,
	162,155,147,140,133,125,118,120,126,133,140,147,154,161,167,174,
	181,188,194,201,208,214,221,214,208,201,194,188,181,174,167,160,
	153,146,140,133,127,120,126,134,142,150,158,166,174,182,190,197,
	177,186,194,202,210,218,216,208,200,192,183,176,167,159,152,144,
	136,137,145,152,160,168,176,184,191,199,206,215,222,229,237,245,
	253,246,237,229,222,214,206,198,191,184,175,168,161,153,145,137,
	129,122,126,133,141,148,156,164,171,178,185,192,200,207,214,221,
	228,234,241,248,252,245,239,232,226,219,214,207,201,195,190,183,
	178,172,167,161,155,152,161,168,176,184,191,199,207,215,222,230,
	238,246,253,245,238,229,222,214,206,199,191,183,176,168,161,153,
	145,137,130,122,114,106,98,90,83,75,68,60,52,44,37,29,
	21,21,20,20,19,19,21,29,36,45,52,60,67,75,83,91,
	98,106,114,122,129,137,145,153,161,168,176,184,192,199,207,214,
	222,230,238,245,253,245,238,230,222,215,207,199,191,184,175,168,
	161,152,145,150,156,161,167,172,178,183,189,195,201,207,213,219,
	226,232,238,245,252,248,241,235,227,221,213,207,199,193,185,179,
	171,163,156,149,141,134,126,119,127,134,140,146,154,160,167,173,
	181,188,194,201,207,214,221,214,208,201,194,188,180,174,167,160,
	154,146,140,133,126,119,120,128,136,144,152,160,168,175,183,191,
	183,191,200,207,216,218,210,202,194,186,178,170,161,153,145,138,
	130,137,145,153,160,168,176,183,191,199,206,215,222,230,237,246,
	253,245,238,230,222,215,207,198,191,183,176,168,161,152,145,137,
	129,127,134,142,149,157,165,172,179,187,194,202,208,216,223,230,
	236,244,251,249,242,235,229,223,216,210,204,198,192,186,179,173,
	168,162,156,151,146,153,160,168,176,184,191,199,207,214,222,229,
	238,246,253,246,237,230,222,215,207,199,191,183,176,168,160,152,
	145,138,129,122,114,106,99,91,83,75,68,60,52,44,36,29,
	21,13,9,8,8,14,21,29,37,45,52,60,67,75,83,91,
	99,106,114,122,130,137,145,152,160,168,176,183,191,199,206,215,
	222,229,238,245,253,245,238,230,222,215,207,199,191,184,176,168,
	160,152,145,140,146,151,157,162,168,174,179,186,192,197,203,210,
	216,222,229,236,242,249,250,244,237,230,223,215,208,201,194,186,
	179,172,164,157,150,142,134,126,126,133,140,147,154,161,167,174,
	180,187,194,201,208,215,221,214,207,200,194,188,181,174,167,161,
	153,147,140,134,126,120,114,121,129,138,146,153,162,169,177,185,
	189,197,205,213,220,213,205,197,188,180,172,163,156,148,139,132,
	129,137,144,152,160,168,176,184,191,199,207,214,223,230,238,245,
	253,245,238,230,222,214,206,199,191,184,176,168,160,153,145,137,
	130,135,143,151,158,166,173,181,189,196,204,210,218,225,232,239,
	246,253,246,239,233,226,220,213,207,200,194,188,182,176,170,164,
	158,153,146,141,145,153,160,168,176,183,191,199,206,215,222,230,
	238,246,253,245,237,229,222,214,206,199,191,183,176,168,160,153,
	145,137,129,122,114,107,98,91,83,75,67,59,52,44,37,29,
	21,13,6,0,6,13,22,29,36,45,52,60,68,75,83,91,
	98,106,114,122,130,137,145,152,161,168,176,183,191,199,207,214,
	222,230,238,245,253,246,237,230,222,215,207,199,192,183,176,168,
	160,153,145,137,136,141,147,152,157,164,170,176,181,188,194,200,
	207,213,219,226,232,239,247,252,246,239,232,225,218,211,203,196,
	188,181,174,165,159,151,143,135,127,133,140,147,154,161,167,174,
	181,187,194,201,207,214,221,214,207,201,194,187,180,174,167,160,
	153,147,140,133,127,119,112,116,124,132,139,148,156,163,172,180,
	194,202,211,219,215,207,198,191,182,174,166,158,150,142,134,126,
	130,137,145,153,160,168,176,183,191,199,206,215,223,229,237,245,
	253,246,238,229,222,214,207,199,191,183,176,168,161,152,145,137,
	135,143,151,159,167,174,182,190,197,205,212,219,227,234,241,248,
	251,244,237,231,224,217,210,204,197,190,184,178,172,166,160,154,
	148,142,136,137,145,152,161,168,175,184,191,199,207,215,222,230,
	237,245,253,245,238,230,222,215,207,199,191,183,176,168,160,153,
	144,137,130,122,114,106,98,91,83,76,67,60,52,44,37,29,
	21,14,10,11,11,13,21,29,37,44,52,60,68,75,83,91,
	98,106,113,121,129,137,145,152,160,168,176,184,191,198,206,214,
	222,230,237,245,253,245,237,230,222,214,207,199,191,184,175,168,
	160,153,145,138,130,131,137,143,148,154,160,166,172,178,185,191,
	198,204,210,217,223,231,237,244,251,248,241,234,226,219,212,204,
	197,190,182,175,167,159,151,143,136,133,140,147,153,160,167,173,
	181,187,194,201,208,215,221,214,208,200,195,187,181,174,167,160,
	154,147,140,133,126,119,113,110,118,126,133,142,150,158,166,174,
	200,208,216,218,210,201,193,185,177,169,161,152,144,135,128,121,
	129,137,145,152,161,168,175,183,191,199,206,215,222,230,238,246,
	253,245,237,230,222,214,207,199,191,184,176,168,160,153,145,137,
	144,152,159,167,175,182,190,198,206,213,221,228,235,242,250,249,
	242,235,228,221,215,207,201,195,188,181,175,168,162,156,150,144,
	139,133,129,137,145,152,160,168,175,183,191,199,206,215,222,229,
	237,245,253,245,237,229,222,215,207,198,191,183,175,168,160,153,
	144,137,130,122,114,107,98,91,83,75,68,60,52,44,37,29,
	21,22,22,22,22,22,21,29,37,44,52,60,68,76,83,91,
	98,106,114,122,129,137,145,153,161,168,176,183,191,199,206,214,
	222,229,238,245,253,246,238,230,222,214,207,199,192,183,176,168,
	160,152,145,137,129,122,127,132,139,144,150,156,162,168,175,182,
	188,194,201,207,215,222,228,235,242,249,250,243,235,228,220,213,
	206,198,191,183,175,167,159,152,143,135,140,147,153,161,168,174,
	181,187,194,200,208,214,221,214,208,201,194,187,180,173,167,160,
	153,147,140,134,127,120,113,107,112,119,128,136,143,152,160,168,
	205,213,220,212,203,195,187,179,171,163,154,146,138,129,121,122,
	129,137,145,153,161,168,175,184,192,199,207,215,222,230,238,246,
	253,246,238,230,222,214,207,199,191,184,176,168,160,152,145,144,
	152,160,168,176,184,192,199,207,215,222,229,237,244,252,247,240,
	233,226,219,212,205,199,191,185,179,171,165,159,152,147,141,135,
	128,122,130,137,145,153,161,168,176,183,191,199,206,215,222,229,
	237,245,253,245,238,230,222,215,207,199,191,183,176,168,160,152,
	145,137,129,122,114,106,98,91,83,75,68,60,52,44,36,32,
	32,33,33,34,33,33,33,33,37,44,52,60,67,75,83,91,
	99,106,114,122,130,137,145,152,160,168,175,183,191,199,207,215,
	222,230,238,246,253,245,237,230,222,215,207,198,191,184,175,168,
	161,153,145,137,129,122,117,123,129,134,140,147,153,159,166,172,
	178,185,192,198,205,212,219,226,233,240,247,252,244,236,230,222,
	214,206,199,192,183,175,168,160,152,144,140,147,154,160,167,174,
	181,187,194,201,208,215,221,214,207,201,194,188,181,174,167,160,
	154,147,140,134,126,120,113,106,105,114,122,130,138,147,155,162,
	210,219,215,206,199,190,182,173,165,157,149,141,132,124,116,122,
	130,137,145,152,160,168,176,183,192,199,206,215,222,230,237,245,
	253,245,238,230,222,214,206,199,191,183,176,168,160,153,144,152,
	160,168,176,184,192,200,207,215,223,230,238,245,252,246,238,231,
	224,217,210,203,196,189,182,175,169,163,156,149,144,137,131,124,
	119,122,130,137,145,152,161,168,176,184,191,199,206,215,222,229,
	238,245,253,245,238,230,222,214,206,199,191,184,175,168,160,153,
	145,137,130,122,114,106,98,91,83,75,67,60,52,44,42,44,
	44,44,45,44,45,45,45,44,44,45,52,60,68,75,83,90,
	98,106,114,122,129,137,145,153,160,168,176,183,191,199,206,214,
	222,230,238,246,253,245,237,229,222,215,207,199,191,183,176,168,
	160,153,145,137,129,122,114,113,119,125,131,137,143,150,156,162,
	169,176,182,189,196,203,210,217,224,231,238,246,253,246,238,230,
	223,215,208,200,192,184,176,168,160,152,143,147,153,160,167,174,
	180,187,194,201,207,215,221,214,207,201,195,188,181,174,167,161,
	154,147,140,134,126,119,113,106,100,107,116,124,132,140,148,157,
	216,218,209,201,193,184,176,167,160,151,143,135,126,118,114,121,
	129,137,145,152,161,168,176,183,191,199,207,214,222,230,237,245,
	253,246,237,230,222,214,207,199,191,183,176,168,160,153,152,160,
	168,176,184,193,200,208,216,224,232,239,247,252,244,237,229,222,
	215,207,201,194,187,180,173,166,159,154,147,140,133,127,121,115,
	114,122,130,137,145,153,160,168,176,184,191,199,206,214,222,230,
	238,245,253,246,238,229,222,215,207,199,191,183,176,168,160,153,
	145,137,129,121,114,107,98,91,83,75,68,59,52,53,54,54,
	55,55,56,57,57,57,56,56,55,54,54,60,68,75,83,91,
	99,106,113,122,130,137,145,152,160,168,176,183,191,199,207,214,
	222,229,237,246,253,246,237,230,222,214,207,198,191,184,175,168,
	160,152,145,137,129,121,113,106,109,115,122,127,133,140,146,153,
	160,167,173,180,187,194,201,208,216,222,230,238,245,252,246,239,
	231,223,216,208,200,192,184,176,168,160,152,147,153,160,167,174,
	181,187,194,201,208,214,221,214,208,201,194,187,180,174,167,161,
	153,146,140,133,126,120,113,106,100,102,110,118,127,135,143,151,
	221,213,204,196,187,179,171,162,154,145,138,129,121,113,114,121,
	129,138,145,152,160,168,176,183,191,199,207,215,222,230,238,245,
	253,245,237,230,223,215,206,199,192,183,175,168,161,153,160,168,
	176,184,193,201,208,216,224,232,240,248,251,243,236,228,221,213,
	207,199,192,184,178,171,163,157,150,143,137,131,124,117,111,106,
	114,122,129,137,144,152,161,168,175,183,191,199,207,215,222,230,
	238,246,253,245,238,230,222,214,207,199,191,184,176,168,160,153,
	144,137,129,122,114,106,98,91,83,75,67,62,64,64,66,66,
	67,68,67,68,68,68,68,67,67,67,66,65,67,76,83,91,
	98,106,114,121,129,137,145,153,160,168,176,183,191,199,207,215,
	222,230,237,245,253,245,237,229,223,215,207,199,191,183,175,168,
	160,153,145,137,129,122,114,106,99,105,111,117,124,130,137,144,
	150,157,164,171,178,185,192,199,207,214,221,228,235,243,251,247,
	240,232,224,217,209,201,192,185,176,169,160,151,154,160,167,174,
	180,187,194,201,208,214,221,214,208,201,194,187,181,174,167,160,
	154,147,140,133,126,120,113,106,99,96,104,112,121,129,137,146,
	216,207,199,191,182,174,165,157,148,140,132,124,115,107,114,122,
	129,137,145,152,161,168,175,184,191,199,207,214,222,230,237,246,
	253,245,237,229,222,214,207,199,191,184,175,168,160,160,168,176,
	184,193,201,209,216,224,233,240,249,251,242,234,227,219,213,204,
	197,190,182,176,169,162,155,148,141,134,128,121,115,108,102,106,
	114,121,129,137,145,152,160,168,175,183,191,199,206,215,222,230,
	238,245,253,246,238,230,222,214,207,199,191,183,176,168,161,152,
	145,137,129,122,114,107,98,90,83,75,72,73,75,76,77,78,
	78,79,79,79,79,79,79,79,78,77,76,76,75,75,83,91,
	99,106,114,121,130,137,145,152,160,168,175,184,191,198,207,214,
	222,230,238,245,253,245,238,230,222,214,207,199,191,184,175,168,
	161,152,145,137,130,121,114,106,98,95,102,108,115,121,128,135,
	141,148,155,162,169,176,183,190,198,204,212,219,227,234,243,250,
	248,240,233,225,217,209,201,193,185,176,167,159,154,160,167,174,
	181,187,194,200,208,214,221,214,208,201,194,187,181,174,167,160,
	153,146,140,133,126,120,113,106,99,92,99,107,115,123,132,140,
	211,202,193,185,176,168,160,151,143,135,126,117,109,106,114,122,
	130,137,145,152,160,168,175,184,191,199,207,214,222,230,237,245,
	253,245,237,229,222,215,206,199,191,183,176,168,160,168,176,184,
	192,201,209,217,225,233,241,248,250,242,234,226,219,211,203,196,
	188,182,174,167,160,152,146,139,132,125,119,112,105,99,98,106,
	114,121,130,137,144,152,160,168,176,183,191,199,207,214,222,230,
	237,245,253,246,238,230,222,214,207,199,191,184,175,168,160,152,
	145,137,130,121,114,106,99,91,83,82,84,85,86,87,88,89,
	89,90,91,91,90,91,91,90,89,89,88,87,86,86,84,90,
	98,106,114,121,130,137,144,153,160,168,176,183,192,199,206,215,
	222,230,238,245,253,245,238,230,222,214,207,199,191,183,175,168,
	160,153,145,137,129,122,114,106,99,90,92,98,105,112,119,125,
	132,138,146,152,159,166,174,181,188,196,203,211,219,226,234,242,
	250,248,241,233,225,216,208,200,192,184,175,167,159,160,167,174,
	180,188,194,201,207,215,221,214,207,201,194,187,181,174,167,160,
	154,147,140,133,126,119,113,106,99,93,92,101,109,117,126,134,
	205,197,188,180,171,162,155,146,138,129,121,112,104,107,114,121,
	129,137,145,153,161,168,175,183,191,199,206,215,222,229,238,245,
	253,245,238,230,222,214,206,199,191,183,175,168,167,175,184,191,
	200,209,216,225,233,241,249,249,241,233,226,218,210,202,195,187,
	180,172,165,158,151,144,137,130,122,116,109,103,96,90,99,106,
	114,122,129,138,144,153,161,168,176,183,192,199,206,215,222,230,
	237,245,253,245,238,230,222,215,206,199,191,183,176,168,161,153,
	145,137,129,122,114,106,99,91,92,94,95,96,98,99,100,101,
	101,101,102,102,102,102,102,102,101,100,100,98,97,96,95,93,
	98,106,114,122,129,137,145,152,161,168,176,183,191,198,206,215,
	222,230,237,246,253,245,238,230,222,214,207,199,191,184,176,168,
	160,152,145,137,129,121,114,107,99,90,83,89,96,103,109,116,
	122,130,137,144,150,158,166,172,180,188,195,203,210,218,225,234,
	241,249,249,240,233,225,217,209,200,192,184,175,167,161,167,174,
	181,187,194,201,208,214,221,214,208,200,194,187,180,174,168,160,
	153,146,140,133,126,119,113,106,99,92,87,96,104,112,120,129,
	200,192,183,174,166,157,149,140,132,123,115,107,99,106,114,122,
	130,137,145,153,161,168,176,184,191,199,207,215,222,230,238,245,
	253,245,238,230,222,215,206,199,191,183,176,168,174,182,191,199,
	208,216,224,233,241,249,249,240,233,225,217,210,202,194,186,179,
	171,164,156,149,142,135,128,121,114,106,100,93,87,91,98,107,
	114,121,129,137,145,153,161,168,176,183,191,199,206,215,222,230,
	238,246,253,245,238,229,222,214,206,199,192,183,175,168,160,153,
	144,137,129,122,114,107,99,102,104,105,106,108,109,110,111,112,
	113,113,113,113,114,113,113,113,113,112,111,110,109,108,106,105,
	103,106,114,122,129,137,145,153,160,168,176,183,191,199,207,214,
	222,230,238,246,253,245,237,230,222,214,207,199,191,184,175,168,
	160,152,145,137,130,122,114,107,99,90,83,80,87,93,100,107,
	114,120,127,135,142,149,156,163,171,179,186,194,201,210,217,225,
	233,241,248,249,241,233,224,216,208,200,191,182,174,166,167,174,
	180,187,194,201,208,215,221,214,208,201,195,187,180,174,167,161,
	154,146,140,133,127,120,113,107,99,93,86,90,98,106,115,123,
	195,187,178,170,160,152,143,135,126,118,110,101,98,106,114,122,
	130,137,145,152,160,168,176,184,192,199,206,215,222,229,237,245,
	253,246,238,230,222,214,206,199,191,183,176,174,182,190,199,208,
	215,224,233,240,249,249,240,233,224,216,209,201,193,185,178,170,
	162,155,147,140,133,126,119,112,104,98,91,84,83,90,99,107,
	114,122,129,137,145,153,160,168,176,183,191,199,207,214,222,230,
	238,246,253,245,237,230,222,215,206,199,192,183,176,168,160,153,
	145,137,130,122,114,109,111,113,114,116,118,119,120,122,122,124,
	124,124,125,125,125,125,124,124,124,123,123,121,120,119,118,116,
	115,113,114,122,130,137,144,153,160,168,175,183,191,199,206,215,
	222,230,237,245,253,245,238,230,223,214,207,199,191,184,175,168,
	160,152,144,137,130,122,113,106,99,91,83,75,77,84,91,97,
	104,111,118,126,133,140,148,155,163,170,177,185,193,201,209,217,
	224,233,241,249,249,240,233,224,216,208,199,191,182,173,167,174,
	180,188,194,201,208,214,221,215,207,201,194,187,180,174,167,160,
	154,147,140,133,126,119,113,106,99,92,86,84,93,101,109,118,
	189,181,173,164,155,146,138,129,121,113,104,96,98,106,114,121,
	129,137,145,152,160,168,176,183,191,198,206,214,222,230,238,245,
	253,245,238,230,222,214,207,199,191,183,176,181,189,198,207,215,
	223,232,240,249,249,241,232,224,217,209,201,193,185,177,169,161,
	154,147,139,132,124,117,109,102,95,89,81,75,83,91,98,106,
	114,121,130,137,145,152,160,168,176,184,191,198,207,214,222,230,
	237,245,253,245,238,230,222,215,207,199,191,183,176,168,161,152,
	145,137,129,122,118,120,122,124,126,128,130,130,132,133,134,134,
	135,136,137,137,136,137,136,136,135,135,134,133,132,130,129,128,
	126,124,122,121,129,137,144,153,160,168,175,184,191,199,207,215,
	222,230,237,245,253,245,238,230,223,214,206,199,191,184,176,168,
	160,153,144,137,129,122,114,106,99,91,83,75,68,75,81,89,
	95,102,109,116,124,132,138,146,154,162,169,177,185,193,200,208,
	217,225,232,241,249,248,240,232,223,215,207,198,189,181,172,173,
	180,188,195,201,208,215,222,215,207,200,194,187,181,174,167,161,
	154,146,140,134,126,120,113,106,99,93,86,79,87,96,105,112,
	185,176,168,159,150,141,133,124,116,107,99,91,98,107,114,121,
	130,138,144,152,161,168,176,183,191,199,207,214,222,230,237,245,
	253,245,238,230,222,214,207,199,191,184,180,189,197,206,214,222,
	231,240,248,250,241,233,224,217,208,200,193,185,176,168,161,153,
	145,138,130,122,116,108,100,93,87,79,72,75,83,90,98,107,
	114,121,130,137,145,153,160,168,176,183,192,199,206,215,222,230,
	237,245,253,245,237,230,222,214,207,199,191,183,176,168,161,152,
	144,137,129,126,129,131,134,136,137,139,140,142,143,145,145,146,
	147,147,147,148,148,148,148,147,147,146,145,145,143,142,140,139,
	137,135,133,131,129,137,145,153,160,168,176,183,191,199,207,214,
	222,229,237,246,253,245,237,230,222,214,207,199,192,183,176,168,
	160,152,144,137,130,122,114,106,99,90,83,75,67,66,73,79,
	87,93,101,108,116,123,131,138,145,153,161,168,176,185,192,201,
	208,217,225,233,241,249,248,239,231,222,214,206,197,188,180,174,
	180,188,194,201,207,214,221,215,208,201,194,187,181,174,167,161,
	154,146,140,133,126,120,113,107,99,92,86,79,82,90,99,108,
	180,171,163,154,145,137,128,119,111,103,94,91,99,106,113,121,
	129,137,145,153,160,168,176,184,191,199,207,215,223,230,238,245,
	253,245,238,230,222,215,207,199,191,183,187,196,204,213,222,230,
	239,248,250,241,233,225,216,208,200,192,185,176,168,161,152,145,
	137,129,122,114,106,100,92,84,78,70,68,75,83,90,99,106,
	114,121,129,137,144,152,161,168,176,183,191,199,207,215,222,230,
	238,245,253,245,238,230,222,214,207,199,191,184,176,168,160,152,
	145,137,135,138,140,142,145,147,149,150,152,153,155,156,157,158,
	159,158,159,159,160,159,159,158,158,158,156,155,155,154,151,150,
	148,146,144,143,140,138,145,152,160,168,175,184,191,198,207,214,
	222,230,237,246,253,245,238,230,222,214,207,199,191,184,176,168,
	161,152,144,137,129,122,114,106,98,91,83,75,68,59,63,70,
	77,84,92,99,107,114,122,129,137,145,152,160,168,176,184,193,
	200,209,217,225,233,241,250,247,239,231,222,213,204,195,187,178,
	180,188,195,201,208,214,222,215,207,201,194,188,180,174,167,160,
	154,147,140,134,126,120,112,106,99,93,86,79,77,85,94,102,
	175,166,158,149,140,132,123,115,106,97,88,91,98,106,114,121,
	130,137,145,152,160,168,176,183,192,199,207,215,223,230,238,245,
	253,245,238,230,222,214,206,199,191,186,195,203,212,221,229,238,
	247,251,243,233,226,217,209,200,192,184,175,168,160,152,144,136,
	128,121,113,105,97,91,83,75,68,62,68,75,83,91,98,106,
	114,121,130,137,145,153,160,168,175,183,191,198,207,214,222,229,
	237,245,253,245,238,230,222,214,207,199,191,183,176,168,160,152,
	145,143,147,148,152,154,156,158,160,162,163,165,166,167,168,169,
	169,170,171,171,171,171,171,170,170,169,168,167,166,164,163,162,
	160,158,156,154,151,148,146,152,161,168,176,184,191,199,207,215,
	222,230,237,246,253,245,237,229,222,214,206,199,192,184,176,168,
	161,153,145,137,129,122,114,106,98,90,83,76,67,60,55,61,
	68,76,83,90,98,105,113,121,129,136,144,151,160,168,175,184,
	192,200,209,217,225,234,242,251,247,238,230,221,211,203,194,185,
	181,188,195,201,207,214,221,215,207,201,194,187,180,174,167,160,
	153,147,140,133,127,119,113,106,99,93,86,79,72,80,88,97,
	170,162,153,144,135,126,118,109,100,92,83,90,99,106,114,122,
	129,137,145,153,160,168,176,184,191,199,207,215,222,230,237,245,
	253,245,237,230,222,214,207,199,191,192,202,211,219,228,236,245,
	252,243,235,226,218,210,201,192,185,176,167,160,151,143,135,128,
	120,113,104,97,89,82,74,67,60,60,67,75,83,91,98,106,
	114,122,129,137,145,152,160,168,176,183,191,199,206,214,222,230,
	237,246,253,245,237,230,223,214,206,199,191,184,176,168,160,153,
	152,155,157,160,163,165,167,170,171,173,175,177,177,179,180,181,
	181,181,182,182,183,183,182,182,181,180,179,178,177,176,175,173,
	171,169,168,165,162,160,158,155,161,168,176,184,191,199,206,215,
	222,230,237,246,253,245,237,229,222,214,206,199,191,184,176,168,
	160,152,145,137,130,122,114,107,98,90,83,75,67,60,53,52,
	60,67,75,81,89,96,105,112,120,128,135,144,152,160,168,176,
	185,193,201,209,218,226,235,243,252,245,237,228,219,210,201,193,
	184,187,194,201,207,215,221,214,208,201,194,188,180,174,167,160,
	153,147,140,134,126,120,113,106,99,93,86,79,73,75,83,92,
	165,157,148,139,130,122,113,105,96,87,83,91,99,107,114,122,
	129,137,144,153,160,168,176,184,191,199,207,215,222,230,237,245,
	253,246,237,230,222,214,206,199,191,200,208,218,227,235,244,252,
	245,236,227,218,210,202,193,185,176,168,160,152,144,135,128,119,
	112,104,96,88,81,73,65,58,52,60,67,75,83,91,98,106,
	114,122,129,138,145,152,160,168,176,183,191,199,207,215,222,230,
	238,245,253,245,237,230,222,214,207,199,191,183,176,168,160,160,
	163,166,169,171,173,176,179,180,183,184,186,187,189,190,191,192,
	192,193,194,193,194,194,193,193,192,192,191,190,189,187,185,185,
	182,181,178,176,174,171,169,165,163,168,176,184,191,199,206,214,
	222,230,237,246,253,245,237,230,222,215,207,199,191,184,175,168,
	161,152,145,137,129,121,114,106,99,91,83,75,68,59,52,45,
	51,59,66,74,80,89,96,104,112,120,127,136,144,152,160,168,
	177,185,193,202,210,218,227,235,245,253,244,236,226,218,208,200,
	191,187,194,201,208,214,221,214,208,201,194,187,181,174,168,161,
	154,146,140,133,127,120,113,106,99,92,86,79,72,69,78,87,
	160,152,143,134,125,117,108,100,90,81,83,91,99,106,114,122,
	130,137,144,153,160,168,175,183,191,199,207,214,222,230,238,246,
	253,245,237,230,222,215,207,199,197,207,215,225,234,242,252,246,
	237,228,220,211,202,194,185,176,168,160,152,144,136,127,119,111,
	103,96,87,80,72,64,57,50,52,59,68,76,83,91,98,106,
	113,122,129,137,145,153,160,168,175,183,192,199,206,215,222,230,
	238,245,253,246,237,230,222,214,207,199,191,183,176,168,167,171,
	174,177,179,183,185,187,189,192,194,195,198,199,200,202,202,203,
	204,205,205,206,205,205,205,205,203,203,202,202,201,198,198,195,
	194,192,190,188,185,182,180,177,174,170,176,183,191,199,207,214,
	222,229,237,245,253,245,238,229,222,215,206,199,191,183,176,168,
	160,152,145,137,129,121,114,106,98,90,83,76,68,60,52,45,
	43,49,57,64,72,80,88,96,103,111,120,127,136,144,152,160,
	169,177,185,194,202,211,219,228,237,246,252,243,234,225,216,206,
	198,189,194,201,208,214,221,214,208,201,194,187,181,174,168,160,
	154,146,140,134,126,120,113,106,99,92,86,79,73,65,74,82,
	156,147,139,129,121,112,103,94,85,77,83,90,99,106,113,121,
	129,137,145,153,160,168,176,183,191,199,206,214,222,229,237,245,
	253,245,238,230,223,214,206,199,204,214,223,231,241,250,247,238,
	230,220,212,203,195,186,178,169,161,152,144,135,127,119,111,104,
	95,88,79,72,64,56,48,45,52,60,67,75,83,91,99,106,
	114,122,129,138,145,152,160,168,175,184,191,199,206,214,222,230,
	237,245,253,245,238,230,222,214,207,199,191,184,176,175,178,181,
	184,187,191,193,196,199,201,203,205,207,209,210,212,212,213,214,
	215,216,216,217,216,217,217,216,216,215,214,212,212,210,209,206,
	205,203,201,199,196,193,191,188,185,181,178,184,191,199,207,214,
	222,229,237,245,253,245,238,230,223,214,206,199,191,183,176,168,
	160,152,145,137,130,121,113,106,98,90,83,75,68,60,52,44,
	37,41,48,56,63,72,79,88,95,103,111,119,127,136,144,152,
	161,169,178,186,195,204,212,221,229,239,247,250,241,232,223,214,
	205,196,194,201,207,214,221,214,208,201,194,188,181,174,167,160,
	153,147,140,133,127,120,113,106,100,93,85,79,72,65,68,76,
	151,142,133,124,115,106,98,89,81,76,83,91,99,107,114,121,
	129,137,145,153,160,168,176,184,191,199,206,215,222,229,237,245,
	253,245,237,230,222,215,207,203,211,221,230,239,248,249,240,231,
	222,213,204,196,187,179,170,161,153,145,136,128,119,111,104,95,
	87,79,71,63,55,47,39,45,52,60,67,75,83,90,98,106,
	114,122,130,137,145,152,161,168,175,184,191,199,207,214,223,230,
	237,245,253,245,237,230,223,214,207,199,191,184,182,186,189,192,
	195,199,202,205,207,209,212,214,216,219,220,221,223,224,225,226,
	226,228,228,228,228,228,228,228,227,226,225,224,223,221,220,218,
	216,214,212,210,207,205,202,199,196,192,189,186,191,199,207,215,
	222,230,238,245,253,246,237,230,222,214,206,199,191,183,176,168,
	161,153,145,137,129,121,114,106,98,91,83,75,68,60,52,45,
	37,32,40,47,55,63,71,79,87,95,103,111,119,128,136,145,
	153,161,170,178,187,196,204,213,222,231,240,249,248,238,230,221,
	211,203,194,201,208,215,221,215,208,200,194,187,181,174,167,160,
	154,147,140,133,127,119,112,106,99,93,86,80,73,66,64,72,
	147,137,129,119,111,102,94,85,75,76,83,91,98,106,114,122,
	130,137,145,153,160,168,175,183,191,199,206,214,222,229,238,245,
	253,245,238,230,222,214,206,209,219,228,236,246,251,242,233,224,
	215,206,197,188,180,171,162,154,145,136,128,120,112,103,95,87,
	79,70,63,55,47,39,36,45,52,60,67,75,83,91,99,106,
	114,121,130,137,144,153,160,168,175,183,192,198,207,214,222,230,
	238,245,253,245,238,230,222,215,207,199,191,189,192,197,200,203,
	207,210,213,215,219,221,223,225,227,229,231,232,234,236,236,238,
	238,239,239,240,240,240,239,239,238,237,237,236,234,233,231,230,
	228,225,223,221,218,215,213,210,206,203,200,197,193,199,207,215,
	222,230,238,246,253,245,238,230,222,214,207,199,191,183,176,168,
	160,152,144,137,129,121,114,106,98,91,83,75,68,60,52,44,
	37,28,32,39,47,55,63,71,79,87,95,103,111,120,129,137,
	145,154,162,171,180,189,198,206,215,224,233,242,252,246,237,228,
	218,209,200,200,208,215,221,215,208,200,194,187,181,173,167,161,
	153,147,140,133,127,120,112,106,99,93,86,79,73,65,58,67,
	142,133,124,115,106,97,88,80,71,76,83,90,98,106,114,122,
	130,137,145,153,161,168,176,183,192,199,206,214,222,230,237,245,
	253,246,238,230,222,214,207,216,225,235,244,252,244,235,226,217,
	208,199,190,182,173,163,155,146,138,130,120,112,104,95,88,79,
	71,62,55,47,38,31,36,45,52,60,68,75,83,91,99,107,
	114,121,130,137,145,153,160,168,176,183,191,199,207,214,222,229,
	238,245,253,246,237,230,222,214,207,199,195,199,203,208,211,215,
	218,220,224,227,230,232,234,237,239,241,243,244,246,246,248,249,
	250,251,251,251,251,251,250,251,250,249,248,247,245,244,242,240,
	239,237,234,232,229,227,224,220,217,215,211,207,204,199,206,215,
	222,230,238,245,253,245,238,230,223,214,207,199,192,183,175,168,
	160,153,145,138,129,121,114,106,99,91,83,75,67,60,52,44,
	37,29,23,31,38,46,54,63,71,78,87,95,104,112,120,129,
	138,147,155,164,172,181,190,199,208,217,225,235,244,253,244,234,
	226,216,206,201,208,214,221,214,208,201,195,187,180,174,167,160,
	154,147,140,134,126,120,113,106,100,93,86,79,72,65,58,62,
	137,129,119,111,102,92,84,75,68,75,83,91,98,106,114,121,
	129,137,144,152,161,168,176,184,191,199,206,215,222,230,238,245,
	253,246,237,229,222,215,214,222,232,241,251,247,237,228,219,210,
	201,192,183,174,166,156,147,139,131,122,113,105,96,87,79,71,
	62,55,46,39,30,29,37,45,52,60,68,75,83,91,98,106,
	114,122,130,138,145,153,160,168,176,184,191,198,207,215,222,230,
	237,245,253,245,237,229,222,214,207,202,206,210,214,218,222,225,
	229,232,235,238,241,243,246,248,250,253,252,251,249,248,247,246,
	245,245,243,244,243,243,244,244,245,246,247,248,249,251,252,252,
	250,248,246,244,241,238,235,232,229,225,222,218,214,211,206,214,
	222,229,238,245,253,245,238,230,222,214,207,199,191,184,176,168,
	160,153,145,138,130,122,114,106,98,91,83,75,67,60,52,44,
	36,29,21,23,30,38,47,54,63,71,79,87,96,104,113,122,
	130,139,148,157,165,174,183,192,201,210,219,228,237,246,250,241,
	232,223,214,203,207,214,221,215,207,200,195,187,180,173,167,160,
	153,147,140,133,127,120,113,106,99,93,85,79,72,66,59,57,
	133,124,115,106,98,88,80,70,68,76,83,90,98,106,114,122,
	130,137,145,152,161,168,176,184,191,199,206,214,222,230,237,246,
	253,245,238,230,222,214,220,229,239,248,249,240,230,221,212,203,
	194,184,176,166,158,149,140,132,123,114,106,97,88,80,71,63,
	55,46,38,30,23,29,36,45,52,59,67,75,83,91,98,107,
	114,122,129,137,145,152,160,168,175,183,191,199,207,214,222,229,
	237,245,253,245,237,230,222,214,208,213,216,221,225,228,232,236,
	239,243,246,249,252,251,249,247,244,242,241,239,238,236,235,234,
	234,233,232,232,232,232,232,233,233,234,236,236,238,239,240,243,
	244,247,249,252,252,249,246,243,239,236,233,228,225,221,217,215,
	222,230,238,245,253,245,238,230,222,214,207,199,191,184,176,168,
	160,152,145,137,129,122,114,106,99,91,83,75,68,60,52,45,
	37,29,21,14,22,31,38,47,55,63,72,80,88,97,105,114,
	122,132,140,149,158,167,175,185,194,203,212,221,230,240,249,248,
	238,229,220,210,207,215,221,215,208,201,195,187,181,174,167,160,
	154,146,140,133,126,120,113,106,100,93,86,79,72,65,59,53,
	129,120,110,102,93,84,75,66,67,75,83,90,98,106,114,122,
	129,137,144,152,160,168,175,184,191,199,207,214,222,230,237,245,
	253,246,237,230,222,217,226,236,245,252,242,232,223,215,205,196,
	187,178,168,159,151,141,133,124,116,106,98,89,81,72,64,56,
	47,38,31,23,21,29,36,45,52,60,67,75,83,91,98,106,
	114,122,130,137,145,153,160,168,176,183,191,199,207,214,222,230,
	238,245,253,245,237,230,222,214,219,222,227,231,236,239,243,247,
	251,252,249,246,243,241,238,236,234,232,230,228,227,225,224,222,
	222,221,221,221,220,221,221,222,222,223,224,225,226,228,229,231,
	234,236,238,240,243,246,249,253,251,247,243,239,236,231,227,223,
	222,230,238,245,253,245,237,230,222,214,207,199,191,184,175,168,
	161,152,144,137,130,122,114,106,98,91,83,75,67,59,53,45,
	36,29,21,13,14,22,30,39,47,55,64,73,81,89,98,107,
	116,124,133,142,150,160,169,178,187,196,205,214,223,233,242,252,
	245,236,226,216,208,215,221,214,208,201,195,187,180,174,167,160,
	154,147,140,134,126,119,113,106,99,93,86,80,72,65,59,52,
	124,115,106,97,88,79,70,61,68,76,83,91,98,106,114,121,
	130,137,145,152,161,168,175,183,191,199,206,214,222,230,237,245,
	253,245,238,230,222,223,233,242,252,245,235,227,217,207,198,190,
	180,171,162,153,143,134,126,117,108,99,90,82,73,65,56,47,
	39,30,23,14,21,29,37,44,53,59,67,76,83,90,98,106,
	114,122,129,137,145,152,161,168,175,184,191,199,206,214,222,230,
	237,245,253,245,238,230,222,224,229,233,238,242,246,250,252,248,
	244,242,238,235,232,229,227,224,223,220,219,216,215,213,213,211,
	210,210,209,209,209,209,210,210,211,212,213,213,215,216,219,220,
	222,224,227,229,232,234,238,242,245,248,252,250,246,243,238,234,
	229,229,238,245,253,245,238,229,222,214,206,199,191,184,175,168,
	161,152,144,137,129,122,114,107,99,90,83,75,67,59,53,44,
	37,29,21,14,6,14,23,31,39,48,56,64,73,82,90,99,
	108,117,125,135,144,153,161,171,179,189,199,207,217,226,236,245,
	251,242,233,223,213,215,221,214,207,200,194,187,181,173,167,160,
	153,147,140,133,126,120,113,106,100,93,86,80,73,66,59,52,
	120,111,101,93,83,75,65,60,67,75,83,90,98,107,114,122,
	129,138,145,153,160,168,176,183,191,199,206,214,222,230,238,245,
	253,245,237,230,223,229,239,248,248,239,229,219,210,201,191,182,
	173,164,155,146,136,128,119,109,100,92,83,74,65,57,48,40,
	32,23,14,14,22,29,37,44,52,59,68,75,83,90,98,106,
	114,122,129,137,145,152,160,168,176,183,191,199,206,214,222,230,
	238,245,253,246,237,230,230,235,239,243,248,253,249,245,242,238,
	234,230,227,224,221,219,216,213,211,209,207,206,204,203,201,200,
	199,199,198,198,198,198,198,199,199,200,201,202,203,206,207,209,
	210,213,215,219,221,224,227,230,234,237,241,245,249,253,248,244,
	239,234,237,245,253,245,237,230,222,214,207,198,191,184,176,168,
	160,153,145,137,129,122,114,106,98,91,83,75,68,60,52,44,
	37,29,21,13,6,6,14,23,31,40,49,57,65,75,83,92,
	100,110,119,127,137,146,155,163,173,182,192,201,211,220,229,238,
	248,249,239,229,219,214,221,214,207,201,194,187,181,174,167,160,
	154,146,140,133,126,120,113,107,100,92,86,80,73,65,59,52,
	115,107,97,89,80,70,61,59,67,75,83,91,99,106,113,122,
	129,137,145,152,161,168,176,184,191,199,207,214,222,230,237,245,
	253,245,238,230,226,235,245,251,242,232,222,214,204,194,185,176,
	166,157,148,139,129,120,111,102,93,84,75,67,58,49,40,32,
	23,15,7,13,21,29,37,44,52,59,68,75,83,90,99,107,
	114,121,130,137,145,152,160,168,176,183,191,199,207,214,222,230,
	237,245,253,245,237,235,240,245,250,251,247,243,239,234,230,227,
	223,220,216,212,210,207,205,202,200,197,195,194,192,190,189,188,
	187,187,187,186,187,187,187,187,188,189,189,191,192,193,195,197,
	200,202,204,207,210,213,216,219,222,226,230,234,238,243,247,251,
	250,245,240,245,253,245,238,230,222,214,207,199,191,184,176,168,
	160,153,145,137,129,123,115,108,101,93,86,77,70,62,55,47,
	39,31,23,15,6,0,7,15,23,32,41,49,58,67,76,85,
	94,102,111,120,130,139,148,157,167,176,185,194,204,213,222,233,
	241,251,245,235,226,216,222,214,208,201,195,188,180,173,167,160,
	154,147,140,133,126,119,113,106,99,93,85,79,72,65,59,53,
	111,102,93,85,76,66,57,60,68,75,83,90,99,106,114,122,
	130,137,145,153,161,168,176,183,192,199,207,214,222,230,238,246,
	253,245,237,230,232,241,251,245,236,225,216,207,197,187,179,169,
	159,151,141,132,123,114,105,95,86,77,68,60,51,42,34,25,
	16,7,6,14,21,29,37,44,52,60,67,75,83,91,98,106,
	113,122,130,137,145,153,160,168,176,184,191,199,206,215,222,230,
	237,245,253,245,240,245,250,251,245,241,237,232,228,224,220,215,
	212,208,205,202,199,196,193,191,188,186,185,183,181,180,178,178,
	176,175,175,175,175,175,176,175,177,177,179,180,181,183,185,187,
	188,191,193,196,199,202,205,208,212,216,219,224,228,232,236,241,
	246,250,250,245,253,245,238,230,223,215,206,199,192,186,179,173,
	166,159,153,146,138,131,124,116,110,101,94,87,79,71,63,55,
	47,38,31,22,14,6,5,12,18,26,34,42,51,60,68,78,
	86,96,104,113,123,132,141,150,160,169,178,187,197,207,216,226,
	235,245,252,242,232,222,221,214,207,201,194,188,180,173,167,160,
	154,147,140,133,127,120,113,106,99,93,86,79,72,66,59,53,
	108,98,89,80,71,62,53,60,67,76,83,91,99,106,114,121,
	129,137,145,152,160,168,176,183,192,199,207,214,222,230,237,246,
	253,246,238,230,238,248,248,239,229,220,210,200,191,181,172,162,
	153,144,135,125,116,106,97,88,79,70,61,53,43,35,26,18,
	9,0,6,14,22,30,39,47,55,62,71,79,87,95,103,110,
	118,126,133,140,147,155,162,169,176,183,191,198,207,215,222,230,
	237,246,253,245,250,251,246,241,236,231,226,221,217,213,209,205,
	201,198,194,191,188,184,182,180,178,175,173,172,170,168,167,166,
	165,164,163,163,163,163,164,164,164,166,167,168,169,172,173,175,
	177,179,182,185,188,191,194,197,201,205,208,213,217,221,226,231,
	236,240,246,251,253,246,238,233,227,221,215,208,202,196,189,183,
	176,169,161,155,147,140,133,125,117,110,102,95,87,79,71,62,
	54,47,39,30,21,13,5,11,18,25,32,39,45,53,61,70,
	79,88,97,107,116,125,134,144,153,163,172,181,191,200,210,219,
	229,238,248,248,238,228,222,215,208,201,194,187,180,174,167,160,
	154,147,140,134,126,120,113,106,99,92,85,79,73,66,59,52,
	103,94,85,76,67,58,53,60,67,75,83,90,99,106,114,121,
	129,137,145,153,161,168,176,183,191,199,206,214,222,229,237,246,
	253,245,238,235,245,253,243,232,223,213,204,194,185,175,165,156,
	147,137,128,118,110,100,91,81,72,64,54,46,37,29,21,13,
	6,4,12,21,29,38,46,55,63,71,79,87,96,103,111,119,
	126,134,142,149,156,164,170,178,184,191,199,205,212,218,224,231,
	238,245,253,252,246,241,235,231,225,220,216,211,206,203,198,194,
	190,186,183,179,177,174,171,168,166,164,162,160,158,157,156,154,
	153,153,152,152,152,152,152,153,154,155,155,157,158,160,161,163,
	166,168,171,174,177,180,183,187,190,194,198,202,206,211,216,221,
	226,231,238,245,253,252,248,243,236,231,224,218,211,205,198,192,
	185,178,171,163,157,149,141,134,126,118,111,103,95,87,79,71,
	62,55,47,37,29,20,12,12,19,25,32,38,45,52,59,66,
	73,82,91,100,109,119,127,137,146,156,166,174,184,194,203,214,
	223,233,242,252,244,234,225,215,208,201,194,187,181,174,167,160,
	154,147,140,133,127,120,113,106,100,92,86,79,73,65,59,52,
	99,90,81,72,63,54,52,60,68,75,83,91,99,106,113,122,
	129,137,145,153,160,168,176,183,191,199,206,215,222,230,237,245,
	253,245,238,240,250,246,237,227,217,207,197,188,178,169,159,149,
	140,130,121,112,102,93,84,75,67,60,52,45,36,29,21,14,
	5,11,20,28,37,46,54,63,71,79,87,95,103,111,119,127,
	135,142,150,158,165,172,180,187,194,201,208,214,221,227,234,240,
	247,252,253,245,237,231,225,220,215,210,205,201,196,192,188,184,
	180,175,172,169,166,162,160,158,155,153,151,148,147,145,144,143,
	142,142,140,141,141,140,141,142,142,143,144,145,147,148,151,153,
	155,157,160,162,166,169,172,176,180,183,187,191,196,201,206,214,
	222,230,237,246,253,245,247,253,247,240,234,228,221,214,207,200,
	193,187,180,172,165,157,150,142,135,127,119,111,103,96,87,79,
	71,62,54,46,37,29,19,11,18,25,32,39,46,52,59,66,
	72,79,86,93,103,112,121,130,140,149,159,169,178,188,197,207,
	217,227,236,246,250,241,230,220,211,201,194,188,181,174,167,160,
	154,147,140,133,126,120,113,107,99,93,86,79,72,65,59,53,
	96,86,77,68,58,49,52,60,68,75,83,91,98,106,114,121,
	129,137,145,153,160,168,176,184,191,199,206,215,222,229,237,246,
	253,245,237,245,250,240,230,221,210,201,192,182,172,163,153,143,
	134,124,114,107,99,90,83,75,67,60,52,44,37,29,21,13,
	10,18,27,36,45,53,62,70,79,87,95,104,112,119,128,135,
	143,151,158,166,174,181,188,196,203,210,217,224,231,237,244,250,
	250,245,253,245,238,230,222,214,206,200,194,190,185,181,176,173,
	169,164,162,158,155,152,149,146,143,142,139,137,136,134,133,131,
	131,130,130,129,129,130,129,130,131,131,132,134,136,137,139,142,
	144,146,149,152,154,158,161,165,169,172,177,183,191,199,207,215,
	222,230,238,245,253,246,238,244,250,250,243,237,230,223,217,210,
	203,196,189,181,174,166,158,151,143,136,128,120,111,103,96,86,
	79,70,62,53,44,36,28,18,18,25,32,39,46,52,59,66,
	72,79,86,93,99,107,114,124,133,143,153,163,172,181,192,201,
	211,220,231,241,250,246,236,226,216,206,196,188,180,174,167,160,
	154,147,140,133,126,120,113,106,100,93,86,80,72,65,59,53,
	91,82,73,64,55,45,52,59,68,75,83,91,99,107,113,122,
	130,137,145,152,160,168,176,184,191,198,207,214,223,229,237,246,
	253,245,241,251,245,235,224,215,205,195,185,175,166,156,146,137,
	130,121,114,106,98,90,83,75,68,60,52,44,36,29,21,14,
	16,26,35,43,52,60,70,78,87,94,103,111,120,128,135,144,
	152,159,167,175,183,189,198,204,212,219,225,232,239,246,253,247,
	240,246,253,245,237,230,222,214,207,199,191,183,175,171,166,162,
	157,154,151,147,144,141,138,135,133,130,128,126,124,123,122,120,
	119,119,118,117,117,118,118,119,120,120,122,122,124,126,128,130,
	132,135,138,140,143,147,151,154,160,168,176,184,191,199,206,214,
	222,230,237,245,253,245,238,234,240,247,253,247,239,233,226,219,
	211,205,197,190,182,175,167,160,152,144,136,128,120,111,103,94,
	86,78,69,61,52,44,35,25,18,25,31,39,46,52,59,65,
	73,79,86,92,99,106,113,120,127,137,146,156,166,175,185,195,
	205,215,225,234,244,252,242,232,221,211,201,191,181,173,167,160,
	154,147,140,133,127,120,113,106,99,93,86,80,73,66,59,52,
	88,78,69,60,51,44,52,60,67,75,83,91,99,106,114,122,
	130,137,145,153,161,168,176,184,191,199,207,215,222,230,238,245,
	253,246,247,248,239,229,219,209,199,189,180,170,161,153,145,137,
	129,122,114,106,99,91,83,75,68,60,52,44,37,29,21,15,
	24,33,42,50,59,68,77,86,94,103,110,119,127,136,144,152,
	160,168,175,183,191,199,206,213,221,228,235,242,249,251,244,238,
	238,246,253,245,238,229,222,214,207,199,191,184,176,168,161,153,
	147,143,139,136,133,130,126,124,121,119,117,114,112,111,110,109,
	108,107,107,106,106,106,106,107,108,109,110,111,113,115,117,119,
	121,124,127,130,133,137,145,152,160,168,176,184,191,199,206,214,
	222,230,238,245,253,245,237,230,230,237,244,251,249,242,234,228,
	220,213,206,198,191,183,176,168,160,151,144,136,128,119,111,102,
	94,85,77,68,60,51,42,33,24,25,32,38,46,52,59,66,
	72,79,86,93,100,106,113,120,126,133,140,150,160,169,179,189,
	199,209,218,229,238,249,247,237,227,217,207,196,187,177,167,160,
	154,147,140,133,126,119,113,106,99,92,85,79,73,66,59,52,
	84,75,66,56,47,44,52,59,68,75,83,91,98,106,114,121,
	129,137,145,153,161,168,176,183,191,199,207,215,222,230,238,246,
	253,245,253,244,233,223,213,203,194,184,175,168,160,153,145,137,
	130,122,114,106,98,91,83,75,67,60,52,45,36,29,21,22,
	31,40,49,58,67,76,84,93,102,110,118,127,136,143,151,161,
	168,176,184,192,199,208,214,222,230,237,244,251,248,242,235,229,
	237,245,253,245,237,230,222,214,206,199,191,184,176,168,160,153,
	145,138,130,125,122,119,115,113,110,107,106,104,101,100,99,98,
	96,95,95,95,94,94,95,96,97,97,99,100,101,103,106,107,
	110,112,116,122,129,137,145,153,160,168,176,183,192,199,207,214,
	222,230,238,245,253,245,238,230,222,228,234,241,248,251,244,237,
	229,222,214,207,200,192,184,176,168,160,152,144,135,127,119,110,
	101,93,84,76,67,58,49,40,31,25,31,39,45,52,59,65,
	73,79,86,93,99,106,113,120,126,133,140,146,154,164,174,183,
	193,203,213,223,233,244,252,243,232,222,212,202,192,182,172,161,
	153,147,140,133,127,120,113,106,100,92,86,80,73,65,59,52,
	80,71,61,52,43,45,52,60,67,75,83,91,99,106,114,122,
	129,137,145,152,161,168,176,183,192,199,207,214,222,230,237,245,
	253,247,248,237,228,218,208,199,191,183,176,168,160,152,145,138,
	130,121,114,106,99,91,83,76,67,60,53,44,37,29,21,29,
	38,47,56,65,74,82,92,101,109,118,126,134,143,151,159,168,
	176,184,192,200,208,216,223,230,238,246,253,246,239,232,226,230,
	237,246,253,245,238,229,222,214,207,199,191,183,176,168,160,153,
	145,137,130,122,113,107,104,102,99,96,94,92,91,89,87,86,
	85,84,83,83,83,83,84,84,85,86,87,89,90,92,94,97,
	99,106,114,122,130,137,145,153,160,168,175,183,191,199,207,215,
	223,229,237,245,253,245,237,229,222,219,225,232,238,246,253,246,
	239,231,223,216,208,200,193,185,176,168,160,152,143,135,126,118,
	110,101,91,82,74,65,56,47,38,29,32,38,46,52,59,66,
	73,79,86,92,99,106,113,119,126,134,140,147,153,161,168,178,
	188,198,207,217,228,238,248,248,238,228,218,207,197,187,176,166,
	156,147,140,134,126,119,112,106,99,93,86,79,72,66,58,52,
	76,67,58,48,39,44,52,60,68,76,83,91,99,106,114,122,
	130,137,145,153,161,168,176,184,191,199,207,214,222,229,238,246,
	253,253,243,232,223,215,207,199,191,183,176,168,160,152,144,137,
	129,121,114,106,99,91,83,75,67,60,52,44,37,29,26,36,
	45,54,64,72,81,90,100,108,117,126,133,143,151,160,167,176,
	185,193,200,208,216,224,232,239,247,251,244,237,230,223,222,230,
	237,246,253,246,238,230,222,214,207,199,191,184,176,168,160,153,
	144,138,129,122,114,106,99,91,88,85,83,81,79,78,76,75,
	73,73,72,72,71,72,72,73,74,75,76,77,79,80,83,91,
	98,106,114,122,129,137,145,152,160,168,176,184,191,199,207,214,
	222,230,238,246,253,245,238,230,223,215,216,223,230,237,245,251,
	247,239,232,224,217,209,201,192,184,176,168,159,151,142,134,125,
	116,108,99,90,81,72,63,54,45,36,32,39,45,53,59,66,
	72,79,86,93,99,107,113,119,126,134,140,147,154,160,167,173,
	183,193,202,213,222,232,243,253,243,233,223,212,202,192,182,171,
	160,151,140,133,127,120,113,106,100,93,86,80,73,66,59,52,
	73,63,54,45,36,44,53,59,67,76,83,90,99,107,114,122,
	129,138,145,152,160,168,176,183,191,199,206,214,222,229,238,245,
	253,247,238,230,222,215,207,199,191,184,176,168,160,153,145,137,
	130,122,114,107,99,91,83,76,68,60,52,45,37,29,33,43,
	51,61,70,80,89,97,106,115,124,133,142,150,159,168,175,184,
	192,201,209,216,225,232,240,248,250,243,236,228,221,215,222,230,
	238,245,253,245,238,230,222,214,206,199,191,184,175,168,160,152,
	145,137,129,122,114,106,99,91,83,75,72,69,68,66,65,64,
	62,62,61,60,61,60,61,61,63,63,64,66,68,75,83,91,
	98,106,113,121,129,137,145,153,160,168,176,184,191,199,207,214,
	222,229,237,245,253,245,238,230,222,214,207,214,221,228,236,243,
	250,248,240,232,224,216,209,200,192,184,175,167,159,150,142,133,
	124,115,106,98,88,79,70,61,52,42,33,38,45,52,59,66,
	72,79,85,93,100,106,113,120,127,134,140,147,154,161,167,174,
	181,187,197,207,217,228,237,248,248,238,228,217,208,197,187,176,
	166,156,145,134,126,120,113,107,99,93,86,79,72,65,59,52,
	70,60,51,41,37,44,52,60,68,76,83,91,98,106,114,122,
	130,137,145,153,161,168,176,184,191,199,206,214,222,230,237,245,
	253,246,237,230,222,214,207,199,191,183,176,168,160,153,145,137,
	129,121,114,106,99,91,83,75,68,60,52,44,37,31,40,49,
	58,67,77,86,95,104,113,122,131,140,148,158,166,175,183,191,
	200,208,217,225,232,241,248,249,241,234,227,219,212,215,223,230,
	238,245,253,246,238,230,222,214,207,199,191,183,176,168,160,152,
	145,137,130,121,114,106,98,91,83,76,67,59,56,55,54,52,
	51,49,49,49,49,49,50,50,51,51,53,60,68,75,83,91,
	99,106,114,122,129,138,145,152,160,168,175,183,192,199,206,214,
	222,229,237,245,253,245,237,230,222,215,207,205,212,219,227,234,
	242,250,249,240,233,224,217,208,200,192,184,175,167,158,149,141,
	131,122,113,105,95,86,77,68,59,49,40,39,46,52,59,65,
	72,79,86,92,99,106,113,120,127,133,140,147,153,161,167,174,
	181,188,194,201,212,222,232,243,253,243,233,223,212,202,191,181,
	171,160,149,139,129,120,112,106,100,93,86,80,73,65,59,52,
	66,56,48,38,37,45,52,60,67,75,83,90,99,107,114,122,
	129,137,144,153,160,168,175,184,191,199,207,214,222,230,238,248,
	253,245,237,229,222,215,207,199,191,184,175,168,160,153,145,137,
	129,122,114,106,98,90,83,75,67,59,52,45,37,37,47,56,
	65,74,84,93,103,112,120,129,138,147,156,165,174,182,191,199,
	208,216,225,232,241,249,249,241,233,226,218,211,206,214,222,230,
	238,245,253,246,237,230,222,214,206,199,191,184,176,168,160,152,
	145,137,129,121,114,106,99,90,83,76,67,60,52,44,42,41,
	39,38,38,38,37,38,38,39,39,45,52,60,68,76,83,91,
	99,106,114,122,129,137,144,152,160,168,176,184,191,199,206,215,
	222,229,237,245,253,245,237,230,222,214,207,199,204,210,218,226,
	233,241,249,249,241,233,225,216,208,200,191,183,173,165,156,147,
	138,129,120,112,102,93,84,75,65,56,47,39,46,52,59,66,
	72,79,86,92,99,106,113,119,126,133,140,146,153,161,167,174,
	181,187,194,201,208,217,228,238,247,248,237,228,217,207,196,186,
	175,165,154,144,133,123,113,106,99,92,86,79,72,66,59,52,
	62,53,44,35,37,44,52,59,68,75,83,91,99,106,114,122,
	129,137,145,152,160,168,175,183,191,199,206,215,222,232,242,253,
	253,245,237,230,223,214,206,199,191,184,176,168,161,153,145,137,
	130,121,113,106,98,90,83,75,68,59,52,45,36,44,53,62,
	72,81,91,99,109,118,127,136,145,155,163,172,181,189,199,207,
	215,224,232,241,249,249,240,233,225,217,209,202,207,214,222,229,
	238,246,253,246,238,230,222,214,206,198,191,183,176,168,160,152,
	145,137,129,122,114,107,99,90,83,75,67,60,52,44,36,29,
	28,27,27,26,26,27,26,29,36,44,52,59,67,75,83,90,
	98,106,114,122,129,137,145,153,160,168,176,184,191,199,206,214,
	222,229,238,245,253,245,237,230,222,214,207,199,195,202,209,217,
	225,233,240,249,249,241,232,224,216,207,199,190,181,172,164,155,
	145,137,128,118,109,99,90,81,72,63,53,44,45,52,59,66,
	72,79,86,93,100,106,113,120,126,133,140,146,153,160,167,173,
	180,187,194,201,208,215,222,233,243,253,243,232,222,211,201,190,
	180,169,158,148,138,127,117,106,100,93,86,79,73,66,58,52,
	59,50,41,31,36,44,52,60,68,75,83,91,99,106,114,121,
	129,137,145,153,160,168,176,184,192,199,207,215,227,237,247,249,
	253,245,237,230,222,214,206,199,192,184,175,168,161,152,145,137,
	129,121,114,106,99,91,83,75,67,60,52,44,40,49,59,69,
	78,87,97,107,116,125,134,144,152,162,171,180,189,197,206,215,
	223,232,240,249,249,241,233,225,217,209,201,199,206,215,222,230,
	237,245,253,245,238,230,222,214,207,199,191,184,176,168,160,153,
	145,137,129,121,114,106,99,91,83,75,67,60,52,44,36,29,
	22,16,15,15,15,15,21,29,37,44,52,60,68,75,83,90,
	98,106,114,122,129,137,145,152,160,168,176,184,191,199,207,215,
	222,230,237,245,253,245,238,230,222,215,207,199,191,193,201,209,
	216,225,232,241,249,248,240,232,223,215,206,197,188,179,171,161,
	152,143,135,125,116,107,97,87,79,69,59,49,45,52,58,65,
	72,79,86,93,100,106,113,120,126,133,140,147,154,160,167,174,
	181,187,194,201,207,215,222,228,238,248,248,237,227,216,206,195,
	185,174,164,152,142,131,121,110,99,92,85,79,73,65,59,52,
	56,47,37,29,37,44,52,59,68,76,83,90,99,107,114,122,
	129,137,144,153,161,168,175,183,191,199,210,220,231,241,252,246,
	253,245,238,229,222,214,206,199,191,184,176,168,161,152,144,137,
	130,122,114,107,99,91,83,76,68,60,52,45,46,56,65,75,
	85,94,104,113,123,132,141,150,159,169,177,187,195,205,213,223,
	231,239,248,249,241,233,225,216,208,200,193,199,206,214,222,230,
	238,245,253,245,238,230,222,215,207,199,191,183,175,168,160,153,
	145,137,129,121,114,106,99,91,83,75,67,60,52,45,37,29,
	21,13,6,3,5,14,21,28,37,44,52,60,68,75,83,91,
	98,107,114,121,129,137,145,153,160,168,176,184,191,199,207,214,
	222,230,238,246,253,245,237,230,222,215,206,199,191,185,193,201,
	208,217,224,233,241,250,248,239,231,223,214,205,196,187,178,169,
	160,151,141,132,122,113,103,94,85,75,65,56,47,52,59,65,
	72,79,86,93,99,106,112,119,127,133,140,147,153,161,167,173,
	181,187,194,201,208,215,221,223,234,244,252,241,231,220,210,199,
	189,178,167,157,146,136,125,114,103,93,86,79,72,65,59,53,
	53,43,34,29,36,44,52,60,67,75,83,91,98,106,114,121,
	129,138,145,153,160,168,176,183,193,203,214,225,236,246,249,245,
	253,245,238,230,222,215,207,199,191,183,176,168,160,152,145,138,
	130,121,114,106,98,90,83,75,68,60,53,44,52,62,71,81,
	91,100,110,119,129,138,148,157,166,175,184,194,203,212,221,230,
	238,247,250,242,234,225,217,208,200,192,191,199,206,215,222,230,
	237,246,253,246,238,230,222,215,207,198,191,183,176,168,160,153,
	145,137,129,121,114,106,98,91,83,76,68,60,52,44,36,28,
	21,13,6,4,6,13,21,29,37,44,52,60,67,75,83,91,
	98,106,114,122,129,137,144,153,160,168,176,183,191,199,206,214,
	222,230,238,245,253,246,237,230,223,214,207,199,192,183,184,192,
	200,208,216,225,233,242,250,247,238,229,221,212,202,194,185,176,
	167,157,148,138,129,119,110,101,90,81,72,62,52,52,58,66,
	73,79,86,93,100,106,113,119,127,133,140,147,153,160,167,173,
	180,188,194,201,208,215,221,218,229,239,250,246,235,225,214,204,
	193,183,172,161,150,140,129,118,108,98,86,79,72,65,59,52,
	50,40,30,29,37,44,52,60,68,76,83,91,99,107,113,122,
	129,137,145,153,160,168,176,187,197,208,218,230,240,251,245,245,
	253,246,238,229,223,215,207,199,191,183,176,168,160,153,145,137,
	130,122,113,106,99,91,83,75,68,59,52,48,58,67,78,88,
	97,107,116,126,136,145,155,163,174,182,192,200,210,219,227,237,
	246,252,243,234,226,218,209,201,193,185,191,199,207,214,222,230,
	237,245,253,245,237,230,222,214,206,199,191,183,176,168,160,153,
	145,137,129,121,114,106,98,90,83,75,67,60,52,44,37,29,
	21,15,15,16,16,15,21,29,37,44,52,60,67,75,83,91,
	98,107,114,122,130,137,145,152,161,168,176,183,191,199,207,214,
	222,230,237,245,253,246,237,230,222,215,207,199,192,183,176,184,
	192,201,209,218,225,234,243,251,246,237,228,219,210,201,191,182,
	173,163,154,145,135,126,116,107,97,88,78,68,58,52,59,65,
	72,79,86,93,100,107,113,120,126,133,140,147,153,161,167,174,
	180,188,194,201,208,214,221,214,224,235,246,250,240,229,219,208,
	197,186,176,166,155,144,133,123,112,101,90,79,73,65,59,52,
	46,37,28,29,36,44,52,60,68,75,83,90,98,107,114,122,
	130,137,145,152,161,169,180,191,202,212,223,234,244,251,241,246,
	253,245,238,230,223,214,207,199,191,183,175,168,160,153,144,137,
	130,122,114,106,98,91,83,75,67,60,53,54,64,74,84,94,
	104,113,122,132,142,152,160,170,180,189,199,207,216,226,235,244,
	253,244,236,227,218,209,201,192,185,183,191,199,206,214,222,230,
	237,245,253,245,238,230,223,215,207,199,191,183,176,168,160,153,
	145,137,129,122,114,106,99,91,83,75,67,60,52,44,36,29,
	25,26,27,27,28,27,27,29,37,44,52,60,68,76,83,90,
	98,106,114,121,129,137,145,153,160,168,176,183,191,199,206,215,
	222,229,237,246,253,245,237,229,222,215,207,199,192,183,176,176,
	185,192,201,210,218,227,235,244,253,243,235,226,217,208,198,189,
	180,171,161,151,141,132,122,112,103,93,83,73,64,54,59,65,
	72,79,86,93,99,107,113,119,126,133,140,146,154,160,167,174,
	181,187,194,200,207,215,221,214,219,230,241,251,245,233,223,212,
	201,191,180,170,159,148,137,126,116,105,94,83,73,66,59,52,
	44,35,24,29,37,44,52,60,67,75,83,91,99,106,114,122,
	129,137,144,153,162,174,185,195,206,217,227,237,248,247,238,245,
	253,245,237,229,222,214,206,198,191,183,175,168,160,153,144,137,
	130,122,114,106,99,91,83,75,67,60,52,60,69,80,90,99,
	109,119,128,138,148,157,167,177,186,195,205,215,223,233,242,251,
	246,237,228,220,210,202,193,185,177,184,191,199,207,214,222,230,
	237,245,253,245,237,229,222,214,207,199,191,184,176,168,161,153,
	145,137,130,121,114,106,98,90,83,75,67,60,53,45,37,35,
	36,38,38,39,39,38,38,37,37,44,52,60,68,75,83,91,
	99,106,114,122,130,137,145,152,160,168,176,183,192,198,206,214,
	222,230,238,245,253,245,238,230,222,214,207,199,191,183,176,168,
	176,185,194,202,211,219,228,237,246,251,242,233,224,215,204,196,
	186,177,167,158,148,139,128,118,109,99,89,79,69,60,59,66,
	72,79,86,92,99,106,113,119,127,134,140,147,153,160,167,173,
	181,187,194,201,208,215,221,214,215,225,236,247,248,237,227,217,
	205,195,184,174,163,152,141,130,119,109,98,88,76,66,59,52,
	40,32,22,29,36,45,52,60,68,75,83,91,99,106,114,121,
	129,137,145,156,166,177,188,198,210,221,231,241,252,243,238,245,
	253,246,237,230,222,214,206,199,191,183,176,168,161,152,144,137,
	129,122,114,106,98,91,83,75,67,60,55,65,75,85,96,105,
	115,125,135,144,154,164,174,183,193,202,212,221,230,240,248,248,
	239,230,221,212,204,194,186,177,175,184,191,199,206,215,222,230,
	237,245,253,245,238,230,222,215,207,199,191,183,176,168,161,153,
	145,137,130,122,114,106,99,90,83,75,67,60,52,44,45,47,
	48,49,49,50,50,50,50,48,48,47,52,60,67,75,83,91,
	99,106,114,122,129,137,145,153,161,168,176,183,191,199,207,215,
	222,229,238,245,253,245,238,229,222,214,207,199,191,183,176,168,
	168,177,186,194,203,212,221,230,239,248,249,240,231,221,212,202,
	192,183,173,163,154,144,134,125,115,105,95,85,75,65,59,66,
	72,79,86,92,99,106,113,119,126,133,140,147,154,161,167,174,
	180,188,194,201,208,214,221,215,211,221,232,243,252,242,231,221,
	210,199,188,177,167,155,145,134,123,113,102,91,80,69,59,52,
	38,28,21,29,36,44,52,60,67,75,83,91,98,106,114,121,
	129,138,149,159,171,182,192,202,214,225,235,246,249,239,238,245,
	253,246,238,230,222,214,207,199,191,184,176,168,160,152,144,137,
	129,122,114,106,99,90,83,75,68,60,61,71,81,91,101,111,
	120,131,141,151,160,170,180,189,198,209,218,228,237,246,251,241,
	232,223,214,205,196,187,178,170,175,183,192,199,207,214,222,230,
	237,245,253,245,237,230,222,214,206,199,191,183,175,168,161,152,
	145,137,130,122,114,107,98,91,83,75,67,60,53,55,56,58,
	59,60,61,61,61,62,61,61,59,58,57,60,67,75,83,91,
	98,106,114,121,129,137,145,152,161,168,176,183,191,198,207,214,
	222,230,238,246,253,245,238,230,222,214,207,199,191,183,176,168,
	161,169,178,187,196,205,214,223,232,241,250,246,237,228,218,208,
	199,189,180,170,161,150,140,130,121,110,101,90,81,70,60,65,
	73,79,86,93,99,106,113,120,126,133,140,147,154,160,167,174,
	180,187,194,201,207,214,221,214,207,218,228,238,249,246,235,224,
	213,203,192,181,171,160,148,138,127,116,106,95,83,73,62,52,
	35,26,21,29,37,45,52,60,68,75,83,91,98,106,114,121,
	130,141,152,163,174,185,196,207,217,228,239,250,245,234,237,246,
	253,246,237,230,222,214,206,199,191,183,175,168,161,152,145,137,
	129,121,114,106,98,90,83,75,68,60,66,76,86,96,106,116,
	126,136,146,157,166,176,186,195,205,215,225,234,244,252,244,235,
	225,216,207,197,189,180,171,168,176,183,191,199,207,214,222,230,
	237,246,253,246,237,230,222,214,207,199,191,183,176,168,160,152,
	145,138,129,121,114,106,98,91,83,75,68,61,64,66,68,69,
	70,71,72,73,73,73,73,72,70,69,68,65,68,75,83,90,
	99,107,114,121,129,137,145,153,161,168,175,183,191,199,207,214,
	222,229,237,245,253,245,238,229,222,214,207,199,191,183,176,168,
	160,162,171,180,189,198,207,216,225,235,244,253,243,233,224,215,
	205,195,186,176,166,156,146,136,127,117,106,96,86,76,66,65,
	72,79,86,92,99,106,113,120,126,133,140,146,154,160,167,174,
	180,188,194,201,208,214,221,214,208,214,224,234,245,250,239,228,
	218,206,196,185,174,163,152,142,131,120,109,98,87,76,65,54,
	33,22,21,28,36,44,52,60,68,75,83,90,99,106,114,123,
	134,145,156,167,178,188,200,210,221,232,243,252,242,230,238,246,
	253,245,238,230,222,214,207,199,191,184,176,168,161,153,145,137,
	129,122,114,106,98,91,83,75,68,60,71,81,91,101,112,122,
	131,142,152,161,172,181,192,201,211,221,230,240,249,246,238,228,
	218,209,200,191,181,173,164,168,176,184,191,199,207,214,222,230,
	238,245,253,245,238,230,222,214,206,199,191,184,175,168,160,153,
	145,137,129,121,114,106,98,91,83,75,69,72,74,77,79,80,
	82,83,84,84,84,84,84,84,82,81,78,77,74,76,83,91,
	99,106,114,122,129,137,145,153,160,168,176,184,192,199,206,215,
	223,230,238,245,253,245,238,230,222,214,207,199,192,184,176,168,
	160,155,164,173,181,191,200,210,218,228,238,246,250,240,230,221,
	211,202,191,182,172,162,152,142,132,121,112,101,92,82,71,65,
	72,79,86,93,99,106,113,120,127,133,140,147,154,160,167,174,
	181,187,194,201,207,215,221,215,208,209,220,231,242,253,242,232,
	221,211,199,189,178,167,156,145,134,124,112,102,90,80,68,58,
	30,20,21,29,37,44,52,60,67,75,83,91,99,106,116,126,
	137,149,160,170,181,192,203,214,225,236,247,249,238,230,237,245,
	253,245,238,230,222,214,206,199,191,184,176,168,160,153,145,137,
	129,121,114,106,98,91,83,75,68,66,76,87,96,107,117,127,
	137,148,158,167,178,187,198,208,217,227,237,246,250,240,231,221,
	212,203,193,184,175,166,160,168,175,184,191,199,207,214,222,230,
	237,245,253,245,237,230,222,215,207,199,191,184,176,168,160,153,
	145,137,130,122,114,106,98,91,83,77,80,83,86,88,91,92,
	94,95,95,95,96,95,96,95,93,92,90,89,86,83,83,91,
	98,106,114,122,129,137,145,153,160,168,175,183,191,199,207,215,
	223,230,238,246,253,245,238,229,222,214,207,199,192,183,176,168,
	160,152,157,165,174,184,193,203,212,221,231,240,250,247,236,227,
	217,207,197,187,177,168,158,147,137,127,117,106,97,86,76,66,
	72,79,86,92,100,106,113,120,126,133,140,147,154,160,167,173,
	180,187,194,201,207,214,222,214,208,205,216,227,238,248,247,235,
	225,214,204,192,181,170,160,149,138,126,116,105,94,83,72,61,
	28,18,21,29,37,45,52,60,67,75,83,90,98,108,119,130,
	141,152,163,173,184,196,206,217,229,239,251,245,234,230,237,245,
	253,246,238,230,222,215,207,199,192,184,176,168,160,152,144,137,
	130,121,114,106,98,90,83,76,67,71,81,92,102,112,122,132,
	143,152,163,173,183,193,203,213,223,233,243,252,244,234,225,215,
	205,196,186,177,168,159,160,168,175,183,191,199,206,215,222,230,
	238,245,253,246,238,230,222,215,207,199,191,184,176,168,160,153,
	145,137,129,121,114,106,98,91,85,88,91,94,97,99,102,103,
	105,106,107,107,108,107,107,106,105,103,101,100,97,94,92,91,
	99,106,114,122,130,138,145,153,160,168,176,183,191,199,207,215,
	222,230,237,245,253,245,238,229,222,215,207,198,191,184,176,168,
	161,152,149,159,168,177,187,196,205,215,224,234,244,252,242,232,
	223,213,203,193,183,173,163,153,142,133,122,112,102,91,81,71,
	73,79,86,93,100,106,113,119,126,133,140,147,153,160,167,174,
	180,187,194,201,207,214,221,215,208,202,213,223,234,245,250,240,
	228,218,206,196,185,174,163,152,141,130,119,108,97,86,75,64,
	24,15,21,29,37,44,53,60,67,75,83,91,100,112,123,133,
	145,155,166,177,188,199,210,221,232,243,252,242,231,230,238,246,
	253,245,237,230,222,215,206,199,191,183,176,168,161,153,145,137,
	130,121,114,106,99,91,83,75,68,75,86,96,106,117,127,137,
	148,157,168,178,188,199,208,219,229,238,248,248,238,228,218,208,
	200,189,181,171,162,153,161,168,176,183,191,199,206,215,222,230,
	238,246,253,246,237,229,222,214,207,199,191,184,176,168,160,153,
	144,137,129,121,114,107,98,91,96,99,102,106,108,110,113,114,
	116,117,119,119,119,119,118,117,116,115,112,111,108,105,103,99,
	99,107,114,122,130,137,145,152,161,168,175,183,191,199,207,214,
	222,229,238,246,253,246,238,230,222,215,207,199,191,184,176,168,
	161,153,145,152,161,171,180,190,199,209,218,228,238,248,248,238,
	229,219,208,198,188,178,168,158,148,138,127,116,107,96,86,76,
	72,80,86,93,99,106,113,120,126,133,140,146,154,160,167,174,
	181,187,194,201,207,214,221,215,208,201,209,219,231,241,252,243,
	232,221,210,199,188,178,166,155,144,134,122,112,101,89,78,68,
	22,14,22,29,37,45,52,60,68,76,83,92,103,115,125,137,
	147,159,169,180,191,203,214,224,235,246,249,238,227,230,238,245,
	253,245,238,230,222,215,207,199,191,183,176,168,160,153,144,137,
	130,121,114,106,98,91,83,75,69,80,90,101,111,122,132,142,
	153,164,174,183,193,204,214,224,235,244,252,242,232,222,212,202,
	193,184,173,164,155,153,160,168,176,184,191,199,207,214,222,230,
	237,245,253,245,237,230,222,214,207,199,191,183,176,168,160,153,
	145,137,129,122,114,106,99,102,106,110,114,116,120,121,124,126,
	128,129,129,130,130,130,130,129,127,126,124,122,119,117,114,110,
	106,106,114,121,130,137,145,152,161,168,176,184,191,199,207,214,
	222,230,238,246,253,246,237,230,222,215,207,199,191,183,176,168,
	160,153,145,145,154,165,174,184,193,203,212,222,232,242,252,244,
	234,224,214,204,194,183,174,163,152,142,132,121,112,101,91,80,
	73,79,86,92,100,106,113,120,126,133,140,147,154,160,167,174,
	180,188,194,201,208,214,221,214,207,201,205,216,227,237,249,246,
	235,225,214,202,191,181,169,158,147,137,126,114,103,93,82,70,
	20,14,21,29,37,44,52,60,68,76,84,96,107,117,129,139,
	150,161,173,183,195,205,216,227,239,249,245,235,224,229,237,245,
	253,245,237,230,222,214,207,199,192,184,176,168,160,153,144,137,
	129,122,114,106,99,90,83,75,74,84,95,106,116,127,137,147,
	158,168,178,189,199,209,219,229,240,249,246,237,226,217,206,196,
	187,177,168,158,148,153,160,168,176,184,191,199,206,214,222,229,
	237,246,253,245,237,230,222,215,206,199,191,184,176,168,161,153,
	145,137,129,122,114,106,108,113,117,120,124,128,130,133,135,137,
	139,140,141,142,142,141,141,140,139,137,135,133,130,128,124,121,
	117,113,113,122,129,137,145,152,161,168,176,184,191,199,207,214,
	222,230,237,245,253,245,238,230,222,214,207,199,191,183,175,168,
	160,153,145,139,148,158,168,177,187,196,207,216,226,236,247,249,
	240,230,219,209,199,189,178,168,158,147,137,127,116,106,95,85,
	75,79,86,93,100,106,113,120,127,134,140,147,154,160,167,173,
	181,187,194,201,207,214,221,215,208,200,202,212,224,234,245,249,
	239,228,216,205,195,184,173,162,150,140,128,118,106,95,84,73,
	17,13,21,29,37,44,52,60,68,76,87,98,110,120,131,143,
	153,164,176,187,197,209,220,231,242,253,243,231,222,229,238,245,
	253,246,237,230,222,214,206,199,192,183,176,168,161,153,145,137,
	130,121,114,106,99,91,83,76,79,89,100,110,121,131,142,152,
	162,173,183,194,204,215,224,235,245,251,240,231,221,211,201,191,
	181,171,162,152,145,152,160,168,176,183,191,199,206,214,222,230,
	238,245,253,246,238,229,222,215,207,199,191,183,176,168,160,153,
	145,137,129,122,114,114,119,123,128,132,135,138,142,144,146,149,
	150,152,152,153,153,153,153,152,150,148,147,144,142,138,135,131,
	127,123,119,122,130,137,145,153,161,168,175,183,192,199,207,215,
	222,230,238,245,253,246,237,230,222,215,206,199,191,184,176,168,
	160,152,145,137,142,151,162,172,181,191,201,211,221,231,241,251,
	245,234,225,214,204,193,183,173,163,152,141,131,120,110,99,89,
	78,79,86,92,99,106,112,120,127,133,140,147,154,160,167,173,
	181,188,195,201,208,215,221,215,208,201,199,209,220,232,242,253,
	242,231,219,208,197,186,176,164,154,143,131,121,109,98,87,76,
	15,13,21,28,37,45,52,60,68,79,90,101,112,123,135,145,
	156,167,179,190,201,212,223,234,245,250,239,228,223,230,237,245,
	253,245,238,230,222,215,207,199,192,184,175,168,160,152,145,137,
	130,122,114,106,98,90,83,75,82,94,104,114,125,136,146,157,
	168,177,189,198,209,219,229,240,251,245,235,225,216,205,195,185,
	175,165,155,145,145,152,161,168,176,184,191,199,206,214,223,230,
	238,245,253,245,238,230,222,214,207,199,192,183,176,168,160,152,
	145,137,129,121,119,124,130,134,138,142,146,150,152,155,158,160,
	161,163,164,164,165,164,164,163,162,160,158,155,153,149,146,142,
	138,133,129,124,130,137,145,152,160,168,176,183,191,199,206,214,
	222,230,237,245,253,246,238,230,222,215,206,199,191,184,176,168,
	160,152,145,137,136,146,155,166,175,186,195,205,215,225,235,246,
	250,240,229,219,209,199,188,177,167,157,147,136,125,114,104,93,
	83,80,86,93,100,106,113,120,127,133,140,147,154,161,167,174,
	180,187,194,201,208,214,221,215,208,201,195,206,217,228,239,250,
	245,233,222,212,201,189,179,168,156,145,135,123,112,101,90,79,
	13,13,21,29,36,45,52,60,70,82,92,104,114,126,137,149,
	159,170,181,192,204,215,226,237,248,247,236,225,222,230,238,245,
	253,245,237,230,222,214,206,198,192,183,175,168,160,153,145,137,
	129,122,114,106,99,91,83,76,87,97,108,119,130,140,151,161,
	171,182,193,204,213,224,234,245,251,241,230,220,210,200,190,180,
	170,159,150,140,144,153,161,168,176,183,191,199,206,214,222,230,
	237,245,253,246,237,230,222,214,207,199,191,183,176,168,161,153,
	145,137,129,123,129,134,139,145,148,153,156,161,164,166,169,171,
	173,175,175,176,176,176,175,174,173,172,169,167,163,161,157,153,
	148,144,139,135,129,137,145,153,161,168,175,183,191,199,207,215,
	222,230,237,245,253,246,238,229,222,215,206,199,192,183,176,168,
	160,152,145,137,130,140,150,159,169,180,190,200,210,220,231,241,
	250,245,234,224,214,203,193,182,172,162,150,140,129,119,108,98,
	87,79,86,92,99,106,113,120,126,133,140,146,154,160,167,174,
	181,188,194,201,207,214,221,215,207,201,194,202,214,225,236,247,
	248,237,225,215,204,192,182,171,159,148,138,126,115,104,93,82,
	11,13,21,29,37,44,52,62,73,84,95,106,118,129,140,150,
	162,174,185,195,206,217,228,240,251,244,233,222,222,230,237,245,
	253,245,238,229,222,215,207,199,191,183,175,168,161,152,145,137,
	129,121,114,107,99,91,83,80,91,101,113,123,133,145,155,166,
	177,187,197,208,218,229,240,250,246,235,225,215,205,195,185,174,
	165,154,144,137,145,152,160,168,176,184,191,199,207,214,222,230,
	238,245,253,245,237,230,222,215,207,198,191,183,176,168,160,152,
	145,137,130,133,139,145,150,155,159,164,168,172,175,178,180,183,
	185,185,187,187,188,187,186,185,184,183,180,177,175,171,168,164,
	159,154,150,145,139,137,145,152,160,168,176,184,192,198,207,214,
	222,230,237,245,253,246,238,230,222,215,207,198,191,184,175,168,
	160,152,144,137,129,134,144,154,164,174,184,195,204,215,225,236,
	246,250,240,229,218,208,197,187,176,166,155,144,134,123,113,102,
	91,80,86,93,100,106,113,120,126,134,140,147,153,160,167,174,
	180,188,194,200,208,215,221,214,208,201,195,200,211,222,233,244,
	251,240,228,218,207,195,184,173,162,151,140,129,118,106,95,84,
	8,13,21,29,37,44,53,64,75,87,97,109,120,131,143,153,
	165,176,187,198,210,220,231,242,253,241,230,219,222,230,238,245,
	253,245,237,230,222,214,206,199,191,183,176,168,160,152,145,137,
	130,122,113,106,99,91,83,84,95,105,117,127,138,148,159,170,
	181,191,202,212,223,234,244,251,241,231,220,210,199,190,179,169,
	159,148,139,137,145,152,160,168,176,183,191,199,207,214,222,230,
	238,246,253,245,237,230,222,214,206,199,191,184,175,168,161,152,
	145,138,137,143,149,155,160,165,170,174,179,182,186,188,191,194,
	196,197,198,198,199,199,199,197,195,194,192,189,185,182,178,174,
	170,165,159,154,149,143,145,152,160,168,176,184,192,199,206,214,
	222,230,238,245,253,245,238,230,222,215,206,198,191,183,176,168,
	160,152,145,137,129,129,139,149,159,169,179,189,200,210,220,231,
	241,252,244,233,223,213,201,192,180,170,159,149,138,127,116,106,
	94,84,86,92,99,106,113,120,126,134,140,147,154,161,167,174,
	181,187,194,201,208,214,221,215,208,201,194,197,207,220,230,241,
	252,243,231,220,209,198,187,176,164,154,142,131,120,109,97,86,
	7,13,21,29,37,44,55,67,78,89,101,111,123,133,145,156,
	167,178,190,201,211,223,234,245,250,238,228,217,222,229,237,245,
	253,245,238,229,223,214,206,199,191,184,176,168,160,153,145,137,
	129,122,114,106,99,90,83,87,99,109,120,131,142,152,163,174,
	185,195,206,217,227,238,249,247,237,226,215,205,194,184,174,164,
	153,144,134,137,145,153,160,168,176,183,192,199,207,214,222,230,
	238,246,253,245,238,230,223,215,207,199,191,184,175,168,160,152,
	145,140,146,152,159,164,170,175,180,185,189,193,196,200,202,204,
	207,208,209,211,210,210,210,208,207,205,203,200,196,193,189,185,
	181,175,170,164,159,153,146,153,160,168,176,183,191,198,207,214,
	222,230,238,245,253,245,238,230,222,215,207,199,191,184,176,168,
	160,152,144,138,129,123,133,143,154,164,174,185,195,205,215,226,
	236,247,249,238,227,217,205,195,185,174,164,152,141,131,120,109,
	98,88,86,92,100,106,113,120,127,133,140,147,153,160,167,173,
	181,187,194,201,207,214,221,214,207,201,194,194,206,216,228,238,
	249,246,234,223,212,200,190,178,167,156,145,133,123,112,100,89,
	6,14,21,29,37,46,58,69,80,91,103,113,125,136,147,158,
	170,181,192,203,214,225,237,248,247,236,225,214,222,230,238,246,
	253,245,238,230,222,215,206,199,191,184,176,168,161,152,145,137,
	130,122,114,106,99,90,83,91,102,113,124,134,145,157,167,178,
	188,199,210,220,232,242,253,242,232,221,211,200,190,180,170,159,
	149,138,130,137,145,152,160,168,176,183,191,198,207,214,222,230,
	237,245,253,245,238,230,223,214,207,199,191,184,176,168,160,153,
	144,149,155,162,168,174,180,186,190,195,199,204,208,210,214,216,
	218,220,221,221,222,222,221,219,218,217,214,211,207,204,200,196,
	191,185,180,175,168,162,155,152,161,168,176,184,191,198,206,214,
	222,230,238,246,253,245,237,229,222,214,206,199,191,184,176,168,
	160,153,145,137,129,122,128,138,149,159,169,180,190,201,211,221,
	232,243,253,242,232,221,210,199,189,178,167,157,146,135,124,113,
	103,91,86,93,99,106,113,119,127,133,140,147,153,160,167,174,
	180,187,194,200,208,214,221,214,208,201,194,191,202,213,224,236,
	247,248,237,225,214,203,192,180,170,158,148,136,125,114,102,91,
	6,13,21,29,37,48,59,71,82,93,105,116,127,139,150,160,
	172,184,195,205,217,228,239,250,244,233,222,214,223,230,238,245,
	253,245,237,230,222,214,206,199,192,184,176,168,161,153,144,137,
	130,121,114,106,98,91,84,95,106,116,128,138,149,160,170,182,
	192,203,214,225,235,246,249,238,227,217,207,196,186,174,165,154,
	144,133,130,137,144,152,160,168,176,183,191,199,206,214,222,230,
	238,245,253,245,238,230,222,215,207,199,191,184,176,168,160,153,
	151,158,165,171,178,184,190,195,201,206,210,214,219,222,225,227,
	230,231,232,233,233,233,233,231,229,228,225,222,219,214,211,206,
	201,196,190,184,177,172,165,157,161,168,176,184,191,199,207,215,
	222,230,238,245,253,245,237,230,222,215,206,199,192,184,176,168,
	160,152,144,137,129,121,123,133,144,154,164,175,185,196,206,217,
	227,239,249,247,235,225,214,204,193,182,171,161,149,138,128,117,
	106,94,86,92,100,106,113,119,127,133,140,147,154,160,167,174,
	180,188,194,201,208,214,221,214,207,201,194,189,199,211,222,233,
	245,250,239,228,217,206,194,183,172,161,149,138,127,116,105,93,
	6,13,21,29,39,51,62,73,84,96,107,118,129,140,152,163,
	174,185,197,208,219,230,242,252,242,231,220,215,222,230,237,245,
	253,246,238,230,222,215,207,199,191,184,175,168,161,152,145,137,
	130,122,114,106,98,91,87,98,109,120,131,142,152,164,175,185,
	196,207,218,229,240,250,245,235,224,213,203,191,181,171,160,149,
	139,128,130,137,144,152,160,168,176,183,191,199,207,214,222,229,
	238,246,253,245,237,230,222,214,206,199,191,184,176,168,161,153,
	159,166,174,180,187,193,199,205,211,216,221,225,229,233,236,239,
	241,242,244,245,244,245,243,243,241,239,235,232,229,226,221,216,
	211,206,200,194,187,181,173,166,161,168,176,184,191,199,206,215,
	222,229,238,245,253,246,237,230,222,214,206,198,192,183,176,168,
	160,153,145,137,129,121,118,128,139,149,159,170,181,191,203,213,
	224,234,245,251,240,229,218,207,197,186,175,164,153,142,131,120,
	109,99,87,93,99,106,112,120,127,133,140,146,154,161,167,174,
	180,187,195,201,208,214,221,214,208,201,194,188,197,208,220,231,
	242,253,241,230,219,208,197,186,174,163,152,141,129,118,107,96,
	6,14,21,30,41,53,64,75,86,98,109,120,131,143,154,166,
	177,188,199,210,221,233,244,251,239,229,217,214,222,230,238,246,
	253,246,237,230,222,214,207,199,191,184,175,168,160,153,145,137,
	129,121,114,106,98,91,90,101,112,124,134,145,156,167,178,189,
	200,210,222,232,243,252,241,230,220,209,198,187,177,166,155,145,
	134,123,129,137,145,152,161,168,175,184,191,199,207,214,222,229,
	237,245,253,245,238,230,223,214,207,199,191,184,176,168,160,160,
	167,175,182,190,197,203,209,216,221,226,231,236,240,244,247,250,
	252,253,251,250,250,251,251,252,252,250,247,244,240,235,231,227,
	221,216,210,203,196,190,182,176,168,168,175,183,192,199,206,215,
	222,230,237,245,253,245,237,230,222,214,206,199,191,184,176,168,
	160,153,145,137,129,122,114,123,134,144,155,166,177,187,198,209,
	220,230,241,252,244,233,221,211,200,189,178,167,156,145,135,123,
	113,101,90,92,99,106,113,120,126,134,140,147,153,160,167,174,
	180,187,195,200,208,214,221,215,207,201,194,187,195,206,217,229,
	240,251,244,233,221,210,199,188,177,165,154,142,131,121,109,98,
	6,13,21,32,43,54,66,77,89,100,111,123,133,145,156,168,
	178,190,201,213,224,235,246,249,237,226,215,214,222,230,237,246,
	253,245,238,229,222,214,207,199,191,183,176,168,160,153,145,137,
	129,121,114,106,98,90,93,105,115,127,137,149,159,170,181,192,
	203,214,225,236,247,248,237,227,215,205,194,184,173,162,152,140,
	130,121,129,137,145,152,160,168,175,183,191,199,207,214,222,230,
	238,245,253,245,237,230,222,215,207,199,191,184,176,168,161,169,
	176,184,192,199,206,212,219,225,231,236,242,247,251,252,248,246,
	243,240,240,239,239,238,240,241,243,245,248,252,251,247,242,236,
	231,225,219,212,206,198,192,184,176,168,176,183,191,199,207,215,
	222,230,237,246,253,246,237,230,222,214,207,199,191,183,176,168,
	161,153,145,137,130,122,114,120,129,141,152,162,173,183,194,205,
	215,226,237,248,247,236,226,214,204,192,182,170,160,148,138,126,
	115,104,93,93,100,106,113,119,126,133,140,147,153,160,167,174,
	180,187,194,201,207,214,221,214,208,201,194,187,193,203,215,226,
	238,249,246,235,224,213,201,190,179,167,156,145,133,123,111,100,
	6,14,23,33,45,56,68,79,90,101,112,124,135,147,158,169,
	181,192,203,214,226,237,248,246,235,224,213,214,222,230,238,245,
	253,246,238,229,223,214,207,199,192,183,175,168,161,152,145,137,
	129,122,114,106,99,91,97,108,119,129,141,152,163,173,184,196,
	206,218,229,240,251,244,233,223,211,201,191,180,169,158,147,137,
	125,122,129,137,145,152,160,168,176,183,191,199,207,215,222,229,
	238,246,253,245,238,230,222,214,207,199,191,184,176,168,167,176,
	184,192,200,207,214,222,229,235,241,246,252,249,245,241,237,234,
	232,229,228,228,227,227,228,229,231,234,237,240,245,249,252,247,
	241,235,229,222,215,208,200,193,184,176,176,184,191,199,206,214,
	222,230,237,245,253,246,238,230,223,215,206,198,192,183,176,168,
	160,153,145,137,130,122,114,115,125,137,148,158,169,180,190,201,
	212,223,234,245,251,239,229,218,207,196,184,174,163,152,141,130,
	119,108,96,93,100,106,113,119,126,133,140,146,153,161,167,173,
	180,187,194,201,208,214,222,214,208,200,194,188,191,201,213,224,
	235,246,248,237,225,214,203,191,180,169,158,147,135,124,113,102,
	6,13,24,35,47,58,69,81,92,103,115,126,137,149,160,171,
	182,194,205,216,227,239,251,245,233,222,211,215,222,230,238,245,
	253,245,237,230,222,214,206,199,192,184,176,168,161,153,144,137,
	129,121,114,106,98,91,100,110,122,133,144,154,165,177,187,199,
	210,221,232,243,252,241,230,219,208,198,186,176,165,154,143,133,
	122,122,130,137,145,153,160,168,176,183,191,199,206,214,222,229,
	237,245,253,245,238,230,222,214,206,199,192,184,176,168,175,184,
	192,201,208,216,224,231,238,244,251,250,244,239,234,230,226,223,
	220,218,217,216,215,216,217,218,220,223,226,230,234,239,244,250,
	251,245,238,231,223,216,209,200,192,184,176,183,191,199,207,215,
	222,230,238,245,253,246,237,230,222,215,206,199,191,184,176,168,
	160,153,145,137,129,122,114,111,122,133,144,154,165,176,186,197,
	209,219,230,241,252,243,232,221,209,199,188,177,165,154,143,133,
	121,110,99,93,99,106,113,119,127,133,140,147,153,160,167,174,
	181,187,194,201,208,215,221,214,207,201,194,187,188,200,211,222,
	233,245,250,239,228,217,205,193,183,171,159,149,137,126,114,104,
	6,14,26,37,48,60,71,83,94,105,116,127,139,150,161,173,
	184,195,207,219,230,241,252,242,231,220,209,214,223,230,237,246,
	253,245,237,229,222,214,206,199,192,183,176,168,161,153,145,137,
	130,122,114,106,99,91,102,113,124,135,147,158,168,179,191,202,
	213,224,235,246,249,238,227,216,205,194,183,172,161,150,140,128,
	118,122,129,137,145,153,160,168,176,184,191,198,207,214,222,230,
	237,246,253,245,238,229,222,214,206,199,191,183,176,173,183,191,
	200,208,217,224,232,240,247,253,246,239,234,229,224,219,216,211,
	210,206,205,205,204,205,206,207,209,212,215,219,223,229,233,239,
	245,252,247,240,232,225,216,208,200,192,183,183,191,199,207,214,
	222,230,238,245,253,245,237,230,222,214,207,198,191,184,176,168,
	160,152,145,137,129,121,114,107,118,129,140,150,161,172,183,194,
	205,216,227,238,249,246,235,224,213,202,191,180,168,157,147,135,
	124,113,102,93,99,106,113,119,126,133,140,147,154,160,167,173,
	181,187,194,200,208,215,221,214,207,201,194,187,186,197,209,220,
	231,243,252,241,229,218,207,196,184,173,161,150,139,128,117,105,
	6,16,27,38,49,61,72,84,96,106,118,129,141,152,164,175,
	186,198,208,220,231,243,252,241,229,218,207,215,222,230,237,245,
	253,245,238,230,222,214,206,199,191,184,175,168,161,153,145,138,
	130,122,114,106,99,93,104,115,126,138,149,160,171,182,193,204,
	216,226,238,249,246,235,224,213,202,191,180,169,158,147,136,125,
	114,121,129,137,145,153,160,168,176,183,191,199,206,215,222,229,
	238,246,253,245,237,230,222,214,207,199,192,183,176,181,190,199,
	207,216,225,233,240,248,250,243,237,230,223,219,213,209,204,200,
	198,195,194,192,193,193,194,195,197,200,204,208,213,218,224,230,
	236,243,250,248,240,233,225,216,207,198,189,184,191,198,206,215,
	222,230,237,245,253,245,237,230,222,215,207,199,191,184,176,168,
	160,152,145,137,130,121,113,106,115,125,136,147,158,169,180,191,
	202,213,224,235,246,249,237,227,215,204,193,182,172,160,149,138,
	127,115,104,93,99,106,113,120,127,133,140,147,153,160,167,174,
	180,187,194,201,208,215,221,214,208,201,194,187,184,195,207,219,
	229,241,252,243,231,220,209,197,186,175,164,152,141,129,118,106,
	6,17,29,40,51,62,74,86,96,108,120,131,143,154,165,176,
	188,199,211,221,233,245,251,239,228,217,207,214,222,229,237,245,
	253,245,238,230,222,214,207,199,191,183,176,168,160,152,145,137,
	129,122,114,106,98,95,107,117,129,140,152,162,174,185,197,207,
	219,230,240,252,243,232,220,210,198,187,177,166,154,144,133,122,
	114,122,130,137,145,152,160,168,176,183,192,199,207,214,222,230,
	237,246,253,246,237,230,222,214,207,199,191,184,178,187,197,206,
	215,223,232,241,249,249,242,234,227,220,214,208,202,198,194,190,
	186,185,182,181,181,182,182,185,187,190,194,198,203,208,214,220,
	227,234,241,249,249,241,233,224,215,206,196,187,191,199,207,214,
	222,230,238,245,253,245,238,230,222,214,207,199,191,184,176,168,
	160,152,145,137,130,122,114,106,111,122,133,144,154,166,177,188,
	199,210,221,232,244,252,240,230,219,207,196,185,174,162,151,140,
	129,117,106,95,99,107,113,120,126,133,140,147,153,161,167,174,
	181,187,194,201,208,214,222,215,207,201,194,187,182,193,205,217,
	227,239,250,244,233,221,210,199,188,176,165,153,142,131,120,108,
	8,19,30,42,53,64,75,87,98,110,121,132,143,155,166,178,
	189,201,211,223,234,246,249,238,226,215,206,214,222,230,238,245,
	253,245,237,230,222,214,206,199,192,184,175,168,161,153,145,137,
	130,122,114,107,99,98,109,120,132,143,154,165,177,187,198,210,
	221,232,243,251,240,229,218,207,196,185,174,162,151,140,130,118,
	114,122,129,137,145,152,160,168,176,183,191,199,206,214,223,230,
	237,246,253,245,237,230,222,214,207,199,191,183,184,194,203,213,
	222,231,240,248,249,241,232,226,218,210,204,198,193,188,183,179,
	176,173,172,170,170,170,171,173,176,179,182,187,193,198,204,210,
	218,225,233,241,249,248,240,231,222,213,203,194,191,199,207,215,
	222,230,237,246,253,246,238,230,223,214,207,199,191,183,176,168,
	160,152,144,137,129,122,114,106,108,118,130,141,151,162,174,185,
	196,207,219,229,241,252,244,232,221,210,199,188,176,165,153,142,
	132,120,109,97,99,106,113,120,126,133,140,147,154,160,167,174,
	181,188,194,201,208,215,221,214,207,200,194,187,181,192,204,214,
	226,237,249,245,234,224,212,201,189,178,167,155,143,132,121,110,
	9,20,31,43,54,65,77,88,99,111,122,134,145,156,167,179,
	191,201,213,225,236,248,248,236,224,213,207,214,222,230,238,246,
	253,246,238,230,222,214,206,198,191,183,176,168,160,153,145,137,
	129,122,113,106,99,99,111,122,134,144,156,167,178,189,201,212,
	224,234,246,249,238,227,216,205,193,182,171,160,149,138,126,116,
	114,122,129,137,145,152,161,168,176,184,191,198,207,214,222,230,
	237,245,253,245,237,230,222,214,207,199,191,184,189,200,210,219,
	229,238,247,250,241,233,224,217,209,202,195,189,183,178,173,168,
	165,161,160,159,158,158,160,162,165,168,173,177,183,188,195,202,
	209,217,225,233,241,250,247,238,229,219,210,199,191,199,207,215,
	222,230,238,245,253,245,237,230,222,214,207,199,191,184,176,168,
	160,152,145,137,130,121,114,106,104,115,127,138,149,160,170,182,
	193,204,215,227,238,249,246,234,223,212,201,190,179,168,156,144,
	133,123,111,99,99,106,113,120,127,133,140,146,153,160,167,174,
	180,188,194,201,207,214,221,214,208,201,194,187,181,191,201,213,
	224,236,247,248,236,224,213,201,190,180,168,157,145,134,123,111,
	9,22,32,44,56,67,78,90,100,113,124,135,146,158,169,181,
	192,203,214,226,238,249,246,235,223,212,206,214,222,230,237,246,
	253,245,238,230,222,215,207,198,191,184,176,168,160,152,145,137,
	129,122,114,106,98,101,113,124,136,147,158,170,181,192,203,214,
	225,236,248,246,236,225,213,202,191,179,169,157,147,135,124,113,
	114,121,129,137,145,153,161,168,175,184,191,199,207,214,222,230,
	237,245,253,245,238,230,222,214,207,199,191,185,195,205,215,225,
	235,244,252,243,234,225,216,208,201,193,186,179,173,167,162,157,
	154,151,149,147,147,148,149,150,153,157,162,167,173,178,186,193,
	201,209,217,226,234,243,253,245,235,225,215,205,196,199,207,214,
	222,230,237,245,253,245,238,230,222,215,207,199,191,184,175,168,
	161,153,145,137,129,121,114,107,102,113,124,135,146,157,169,180,
	191,202,213,225,235,247,248,236,225,214,203,192,180,169,158,147,
	136,124,113,102,99,106,113,120,126,133,140,146,153,160,167,173,
	180,187,194,201,208,214,221,215,207,201,194,187,181,189,200,212,
	223,235,246,248,237,226,214,203,192,180,169,157,147,135,123,113,
	11,22,34,45,57,67,79,91,102,114,125,136,148,159,171,181,
	193,204,216,227,238,250,244,233,222,210,207,215,222,230,238,245,
	253,245,238,230,222,214,207,198,192,184,176,168,161,152,145,137,
	129,122,114,106,99,104,114,126,137,148,160,171,183,194,205,216,
	228,239,250,245,233,222,211,200,189,177,166,155,144,132,121,110,
	114,121,129,137,145,152,160,168,175,184,191,199,206,215,222,229,
	237,245,253,245,238,230,223,215,207,199,191,191,200,211,221,231,
	241,251,245,236,227,218,209,201,192,184,177,169,163,157,152,147,
	143,140,138,135,135,136,137,140,143,146,152,157,163,170,177,184,
	192,200,209,218,227,236,246,251,241,231,221,211,201,199,207,214,
	223,230,237,246,253,246,237,230,222,214,206,199,191,184,175,168,
	160,152,145,137,130,122,114,106,99,110,121,132,144,155,166,177,
	188,200,211,222,234,244,250,239,228,217,205,194,182,171,159,149,
	138,126,114,103,99,106,113,120,126,133,140,147,154,161,167,174,
	180,188,194,201,208,215,221,214,207,200,194,188,181,188,199,211,
	222,233,245,250,239,228,216,204,193,181,170,159,148,136,124,114,
	12,23,34,46,58,69,80,92,103,115,126,137,148,160,171,183,
	194,206,217,228,240,251,244,232,221,209,207,215,222,230,238,245,
	253,245,237,229,222,215,206,198,191,184,175,168,160,152,145,137,
	129,121,114,106,99,105,116,127,139,150,161,173,184,195,206,219,
	230,241,252,243,231,220,209,197,186,175,164,153,141,130,119,108,
	114,122,129,137,145,153,161,168,176,183,192,199,207,215,222,230,
	238,245,253,245,238,230,222,215,206,199,192,195,206,216,226,236,
	247,250,240,229,220,211,202,193,184,176,168,161,154,147,141,136,
	132,128,126,124,124,124,126,129,132,137,141,147,153,160,168,176,
	184,193,202,211,220,230,239,249,247,236,226,217,206,198,206,214,
	222,230,238,245,253,245,238,230,222,214,207,199,191,183,176,168,
	160,152,145,137,129,122,113,106,98,108,119,130,141,152,164,175,
	186,198,209,220,231,243,252,241,229,219,207,195,184,173,161,150,
	139,128,116,105,99,106,113,119,126,133,140,146,154,160,167,174,
	180,187,194,200,207,215,221,214,208,201,194,187,181,186,197,209,
	220,232,243,251,240,229,217,206,194,183,171,160,149,137,126,114,
	13,24,36,47,58,70,81,93,104,116,126,138,150,161,173,184,
	195,206,218,229,241,252,242,231,219,208,207,214,222,230,237,245,
	253,245,237,229,222,214,207,199,191,183,176,168,160,153,145,137,
	129,122,114,106,99,107,117,129,140,152,163,174,186,197,209,220,
	231,243,252,241,230,218,207,196,184,173,161,151,139,128,116,106,
	114,122,130,137,144,152,160,168,176,183,191,199,206,215,223,230,
	238,245,253,245,238,230,222,214,207,199,191,200,211,221,232,242,
	252,244,233,224,214,204,195,186,177,169,160,152,145,138,131,126,
	121,118,115,113,112,113,115,117,122,126,132,138,145,152,160,169,
	177,186,195,204,214,224,233,243,252,242,231,221,211,199,206,215,
	222,230,237,245,253,245,238,230,222,214,207,199,191,184,175,168,
	160,153,144,137,129,122,114,106,99,105,117,127,139,150,162,173,
	185,196,207,219,230,240,252,242,231,220,209,197,186,175,163,152,
	141,130,118,106,100,106,113,120,126,133,140,147,154,161,167,174,
	181,188,194,201,208,214,221,214,208,201,194,187,180,185,197,208,
	220,231,243,252,240,229,218,206,195,184,172,161,149,139,127,115,
	13,25,36,48,59,71,82,93,105,116,128,139,150,162,174,185,
	196,208,219,230,242,253,241,230,219,207,206,214,223,230,237,245,
	253,245,238,230,222,214,207,199,191,183,175,168,160,152,144,137,
	129,122,114,106,98,108,120,130,142,153,165,176,187,198,210,221,
	232,244,250,240,228,216,205,194,183,172,159,148,137,126,114,106,
	114,122,129,138,145,152,160,168,176,183,191,199,207,214,222,230,
	237,246,253,245,238,230,222,214,206,199,193,204,214,225,236,246,
	250,239,228,218,208,198,188,179,170,161,152,143,136,129,121,116,
	110,107,104,102,101,102,104,107,111,116,121,129,136,144,152,161,
	169,179,188,198,208,218,229,239,249,247,236,225,214,204,206,214,
	222,229,237,246,253,245,238,230,222,215,206,199,191,183,175,168,
	160,153,145,137,129,122,114,106,98,104,115,126,137,149,160,172,
	182,194,205,217,227,239,251,244,233,221,210,198,187,176,164,153,
	142,131,119,108,100,106,113,119,127,133,140,147,153,160,167,174,
	180,188,194,201,207,215,221,215,207,201,194,187,181,184,195,207,
	218,230,241,253,242,231,219,207,196,184,174,162,151,139,128,116,
	15,26,37,49,60,71,82,94,106,118,128,140,151,163,174,186,
	197,208,220,231,243,252,241,230,217,207,207,215,222,230,238,245,
	253,245,238,230,222,214,207,199,191,183,175,168,161,153,145,137,
	129,122,114,106,99,109,120,132,143,154,166,177,189,201,212,223,
	235,246,249,238,227,215,203,193,181,170,158,147,136,124,113,107,
	114,122,130,137,144,152,160,168,176,184,191,199,206,215,222,230,
	237,245,253,245,238,230,222,215,206,199,197,207,218,229,240,250,
	244,234,223,213,203,193,183,173,163,154,144,136,128,119,112,106,
	100,95,92,91,89,91,92,95,101,106,112,120,128,136,145,154,
	163,173,183,193,203,213,224,234,245,250,240,230,218,208,207,215,
	222,230,238,245,253,245,238,230,222,214,207,199,191,184,176,168,
	160,152,145,137,130,121,114,107,99,101,113,124,136,147,159,169,
	181,192,204,215,226,238,249,245,234,223,212,200,188,177,166,155,
	143,131,121,109,100,106,113,120,127,133,140,146,154,161,167,174,
	180,187,194,201,208,215,221,214,207,200,194,187,180,183,195,206,
	217,229,241,251,242,232,220,208,197,185,174,163,151,140,129,117,
	15,27,38,49,61,72,84,95,107,118,129,141,152,164,175,186,
	198,209,221,232,244,251,240,228,217,205,207,214,222,230,238,245,
	253,245,237,230,222,215,206,199,191,184,176,168,160,152,145,137,
	129,122,114,106,99,110,121,133,144,156,167,179,189,201,213,224,
	235,247,247,236,225,213,202,191,180,168,157,145,134,123,112,107,
	114,122,129,137,145,153,160,168,175,184,191,199,207,215,222,230,
	237,245,253,245,238,230,222,215,206,199,200,211,221,232,244,252,
	241,230,219,208,198,188,177,167,157,148,138,129,120,112,104,96,
	90,85,81,79,78,79,81,86,90,96,104,112,119,128,138,147,
	157,167,177,187,198,209,219,230,240,251,244,233,222,211,206,214,
	222,229,238,246,253,245,238,230,222,214,207,199,191,183,175,168,
	160,152,145,137,129,121,114,106,98,100,111,122,134,145,157,168,
	179,191,203,213,225,237,247,247,235,224,212,201,190,178,167,156,
	144,133,122,110,99,107,113,119,126,133,140,147,153,160,167,174,
	181,187,194,201,208,215,221,214,208,201,194,187,180,183,194,205,
	217,228,240,251,244,232,220,209,198,186,175,163,152,141,129,118,
	16,27,38,50,61,73,84,95,107,119,130,141,152,164,175,187,
	198,210,221,233,244,251,239,228,217,205,207,214,222,230,238,246,
	253,245,238,229,223,214,206,199,191,183,175,168,160,152,145,137,
	129,121,114,107,99,111,123,134,146,157,168,180,191,203,214,225,
	237,248,246,235,224,212,201,189,178,167,156,144,133,121,110,106,
	114,121,130,137,144,153,160,168,176,183,191,199,207,214,222,230,
	237,245,253,245,238,229,222,215,207,199,202,214,225,236,247,248,
	237,226,215,204,193,183,173,162,152,142,132,122,112,104,95,87,
	81,75,70,68,67,68,70,75,80,87,95,103,112,122,132,141,
	152,162,172,183,194,204,215,226,237,248,247,236,224,214,207,214,
	222,229,238,245,253,245,237,229,222,215,207,199,191,184,176,168,
	160,152,144,137,129,121,114,106,99,98,110,121,133,144,155,167,
	178,190,201,212,223,235,247,248,236,225,214,202,191,180,169,157,
	145,134,123,111,100,106,113,120,127,133,140,146,154,160,167,174,
	181,187,194,201,208,215,221,214,208,201,194,187,181,182,193,205,
	216,227,239,250,244,232,221,210,198,187,175,164,153,141,130,118,
	16,27,39,50,61,73,85,96,107,119,131,142,153,165,176,188,
	199,211,222,234,245,250,238,227,216,204,207,214,222,230,238,245,
	253,245,238,230,222,214,207,199,191,184,176,168,160,153,145,137,
	129,122,114,106,101,112,124,135,146,157,169,180,192,203,215,227,
	237,249,246,235,222,211,200,188,177,166,155,143,132,120,109,106,
	114,122,130,138,145,153,161,168,175,184,191,199,206,214,222,230,
	238,246,253,246,238,229,222,214,207,199,205,216,227,239,250,245,
	234,223,212,201,190,179,169,157,147,136,126,116,106,97,87,79,
	71,65,60,57,56,56,60,64,71,79,87,96,106,116,126,136,
	147,157,168,179,190,201,212,222,234,246,250,239,227,217,207,214,
	222,230,238,245,253,245,237,230,222,214,206,199,191,183,176,168,
	160,153,145,137,129,121,114,106,98,98,109,120,132,142,155,166,
	177,189,200,211,223,234,246,249,237,226,215,203,192,181,169,158,
	146,135,124,112,101,106,112,120,127,133,140,147,153,161,167,174,
	181,187,194,201,207,215,221,214,207,200,194,187,181,181,193,205,
	216,227,239,250,244,233,222,210,199,188,176,165,153,142,131,119,
	17,28,39,51,62,73,85,96,107,120,131,142,153,165,177,188,
	199,210,222,234,245,250,238,226,215,204,206,214,222,229,238,245,
	253,245,238,230,222,214,206,199,191,183,176,168,160,153,144,137,
	130,122,114,106,101,112,124,135,147,158,170,181,192,204,216,227,
	238,250,245,234,222,211,199,188,176,164,153,142,130,119,108,106,
	114,121,130,137,144,152,161,168,176,184,191,199,206,215,222,230,
	238,245,253,246,237,229,222,214,207,198,207,218,230,241,252,243,
	232,220,209,198,187,176,164,154,142,132,122,111,101,90,81,71,
	62,55,49,45,43,45,49,55,62,72,80,90,100,111,121,132,
	143,154,164,176,186,198,209,221,231,243,252,241,229,219,207,215,
	222,230,237,245,253,246,237,229,222,215,207,199,191,184,176,168,
	161,152,145,137,130,121,114,106,99,96,108,120,131,142,154,165,
	176,188,199,211,222,233,245,249,238,227,216,204,193,181,169,158,
	147,136,124,112,101,106,113,120,127,134,140,147,154,161,167,173,
	180,187,194,201,208,215,221,215,207,201,194,187,180,180,192,204,
	215,226,238,249,245,234,223,210,199,188,177,165,153,142,131,119,
	17,28,40,51,62,74,86,96,108,120,131,142,153,165,177,189,
	199,211,223,234,245,249,237,226,215,203,206,215,222,230,237,245,
	253,245,238,230,222,215,206,199,191,184,175,168,160,153,145,137,
	129,121,114,106,102,113,125,136,148,159,171,182,194,205,216,228,
	239,250,244,232,221,210,199,187,176,164,153,141,130,118,107,107,
	114,121,129,137,145,153,160,168,176,184,191,199,206,214,222,230,
	238,246,253,246,237,229,222,215,207,199,208,220,231,242,252,241,
	230,218,207,195,184,173,162,151,140,128,117,107,96,85,74,64,
	55,46,39,35,32,34,39,46,55,65,75,85,95,107,117,129,
	139,151,162,173,184,196,206,218,229,241,252,243,232,219,209,214,
	222,229,238,246,253,245,238,230,222,215,206,199,191,184,176,168,
	160,153,144,137,130,122,114,106,99,96,107,119,130,141,153,164,
	176,187,199,210,221,232,244,250,239,227,216,205,193,182,170,159,
	147,136,125,113,102,106,113,120,126,133,140,146,154,161,167,173,
	180,188,194,201,207,214,221,214,208,201,194,187,180,181,192,204,
	215,226,237,249,245,234,223,212,200,188,176,165,154,143,131,120,
	17,29,40,51,63,74,85,97,108,120,131,143,154,166,177,189,
	200,212,223,235,246,249,238,226,214,203,207,215,222,230,238,245,
	253,245,238,230,222,214,207,199,191,184,175,168,160,153,145,137,
	130,122,114,106,102,113,125,137,148,159,171,182,193,205,216,227,
	239,251,243,232,221,210,198,187,175,163,152,141,130,118,107,106,
	114,122,129,137,145,153,161,168,176,183,191,199,207,214,223,230,
	238,246,253,245,237,229,223,214,207,199,210,221,232,243,251,240,
	228,217,206,194,182,172,160,149,138,126,114,103,92,82,71,60,
	49,39,30,24,21,23,30,40,49,60,70,81,92,104,115,126,
	138,148,160,172,183,194,205,216,228,240,251,244,233,221,209,214,
	222,229,238,245,253,246,238,230,222,214,207,199,191,183,175,168,
	160,152,145,137,129,122,114,106,99,95,107,118,129,141,152,163,
	175,186,198,210,221,232,244,251,240,228,217,205,194,182,171,160,
	148,136,125,113,102,106,113,119,127,133,140,146,153,160,167,173,
	181,188,194,201,208,214,221,214,207,201,195,188,180,180,192,203,
	215,226,237,249,246,235,223,212,200,188,177,166,155,142,131,120,
	17,28,40,51,62,74,86,97,108,120,132,143,155,166,177,189,
	200,211,223,234,246,249,237,226,214,202,206,214,222,230,237,245,
	253,245,237,230,222,214,206,199,191,184,175,168,160,153,145,138,
	129,122,114,106,102,113,125,136,148,160,170,183,193,205,217,228,
	240,251,243,232,220,209,197,186,175,163,152,140,130,118,107,106,
	114,121,129,137,144,153,161,168,175,184,191,199,206,214,222,229,
	237,245,253,245,237,230,222,214,207,199,210,221,233,245,250,239,
	227,216,204,193,182,170,159,147,136,125,113,101,91,78,68,56,
	46,34,24,15,9,14,24,34,45,56,67,79,90,101,113,125,
	136,147,158,170,182,193,204,216,227,239,250,245,233,222,210,215,
	222,230,238,245,253,245,237,230,222,215,206,199,191,184,175,168,
	160,153,145,137,130,121,114,106,99,95,106,117,129,140,152,164,
	175,186,197,210,221,233,243,251,239,228,217,205,193,182,170,159,
	148,136,125,114,103,106,113,119,126,133,140,146,153,160,167,173,
	181,188,194,201,207,214,221,214,208,201,194,187,181,180,192,203,
	214,225,237,249,246,234,223,211,200,188,177,166,155,143,132,120,
	17,29,40,52,62,74,86,97,109,120,131,143,154,166,177,189,
	200,212,223,235,246,248,237,226,214,203,207,214,222,230,238,245,
	253,245,238,229,222,215,206,199,191,183,176,168,160,152,145,137,
	129,122,114,107,102,113,125,137,148,159,171,183,193,205,217,228,
	239,251,243,232,221,209,198,186,175,164,152,140,129,118,106,107,
	114,122,129,137,144,152,160,168,176,184,191,199,206,214,222,229,
	238,245,253,245,238,229,222,215,206,199,210,222,233,245,250,238,
	227,215,204,193,181,169,158,147,135,124,113,101,89,78,66,55,
	43,32,21,9,5,14,21,33,44,56,67,78,89,101,112,124,
	135,147,158,170,181,192,204,216,227,238,250,245,233,222,211,215,
	222,229,238,245,253,246,238,230,222,215,207,199,191,183,176,168,
	161,153,145,137,130,121,114,106,99,95,106,118,129,141,152,163,
	175,186,197,209,221,233,243,251,239,228,217,205,194,182,170,159,
	148,136,125,114,103,107,113,120,127,133,140,147,154,161,167,174,
	180,188,194,201,207,215,221,214,208,200,194,187,180,180,192,203,
	214,225,237,249,246,235,223,211,200,188,177,166,154,143,131,120,
	17,28,40,52,63,74,86,97,108,120,131,142,154,166,177,189,
	200,212,223,235,245,249,238,226,214,203,207,215,222,230,238,246,
	253,245,238,229,222,214,207,199,191,184,176,168,160,152,145,137,
	130,121,114,106,102,113,125,136,148,159,171,182,193,205,217,228,
	239,251,244,232,220,209,198,186,175,164,152,140,130,118,106,106,
	113,122,130,137,145,153,160,168,176,183,191,199,207,214,222,230,
	238,245,253,246,238,230,222,214,206,199,211,222,233,244,250,239,
	227,215,204,193,182,170,159,148,136,124,113,101,90,79,67,56,
	45,34,24,14,9,14,24,34,45,56,68,79,91,102,113,124,
	136,148,159,170,181,193,204,216,227,238,250,245,233,222,210,215,
	222,230,238,245,253,245,237,230,222,215,207,199,191,183,175,168,
	161,153,144,137,129,122,114,106,98,94,106,117,129,140,152,164,
	175,186,198,209,220,232,243,251,239,228,216,205,194,182,171,159,
	147,137,125,113,102,106,113,120,126,133,140,147,153,160,167,174,
	181,187,194,201,207,215,221,214,208,201,194,187,181,180,191,203,
	215,226,238,249,246,234,223,211,200,188,177,166,154,143,131,120,
	17,28,40,51,63,74,86,97,109,120,132,142,154,165,177,189,
	200,211,223,234,246,249,238,226,214,203,207,215,222,230,238,246,
	253,245,237,230,222,215,206,199,191,183,176,168,160,153,145,137,
	130,122,113,106,102,113,125,137,148,159,170,182,193,205,217,227,
	239,251,244,232,221,210,198,186,175,164,152,141,129,118,107,106,
	114,121,129,137,145,153,160,168,176,183,191,199,206,214,222,230,
	237,245,253,245,237,230,222,214,206,199,210,220,232,243,251,240,
	228,217,205,194,183,172,160,148,137,126,114,104,92,81,70,60,
	49,39,31,23,21,23,31,39,49,60,70,82,92,104,115,126,
	137,148,160,171,182,194,206,217,228,239,251,243,233,220,209,215,
	222,230,238,245,253,246,237,230,223,214,207,199,191,184,176,168,
	161,153,145,137,130,122,114,106,99,95,107,118,130,141,152,163,
	175,187,198,209,221,232,244,251,240,228,216,205,194,182,170,159,
	148,136,124,114,102,107,113,120,126,134,140,146,153,161,167,174,
	181,188,195,201,208,215,221,214,208,201,194,187,180,180,192,203,
	215,226,237,249,246,235,223,211,200,188,177,166,154,143,131,120,
	17,28,40,51,62,74,85,96,108,119,131,143,154,165,177,188,
	199,211,223,234,245,249,238,226,215,204,206,215,222,229,238,245,
	253,245,238,230,222,214,207,199,191,184,175,168,160,152,145,137,
	130,121,114,107,101,113,125,136,147,158,170,182,193,204,216,227,
	239,250,245,232,221,210,198,187,176,165,153,141,130,119,107,106,
	113,121,129,137,145,153,160,168,175,184,191,199,207,215,222,230,
	237,246,253,245,238,229,222,215,207,199,208,219,231,242,252,241,
	229,218,207,195,184,173,162,150,139,128,117,106,95,85,75,65,
	55,46,40,34,32,34,39,46,55,64,75,85,96,107,117,129,
	140,151,162,173,185,196,207,218,230,241,252,243,231,219,209,215,
	222,230,238,246,253,246,238,230,223,215,207,199,191,183,176,168,
	161,152,145,137,130,122,114,106,98,96,107,118,130,141,153,164,
	176,187,199,210,221,232,244,250,238,228,216,204,193,182,170,159,
	147,136,125,113,101,106,113,120,126,134,140,146,154,160,167,174,
	180,188,194,201,208,215,222,214,208,201,194,187,181,180,192,203,
	215,227,238,249,246,234,223,211,200,188,177,165,154,142,131,120,
	17,27,40,51,62,73,85,97,108,119,131,143,153,165,177,188,
	200,211,222,233,245,249,238,226,215,204,206,215,222,230,238,245,
	253,245,238,230,222,215,207,199,191,183,176,168,160,153,144,137,
	129,121,113,106,101,112,124,135,147,158,169,181,192,204,215,227,
	239,250,245,234,222,211,200,188,177,165,153,142,130,119,108,106,
	114,121,130,137,145,152,161,168,175,184,191,198,206,214,222,229,
	238,246,253,245,237,230,223,214,207,199,207,218,229,241,252,243,
	231,220,209,198,187,176,165,154,143,132,121,111,101,90,81,72,
	62,55,49,45,43,45,49,55,63,72,80,90,101,110,122,132,
	143,153,164,176,186,198,209,221,232,242,252,241,229,218,207,215,
	222,230,237,245,253,245,237,230,222,214,206,199,191,183,176,168,
	161,153,145,137,130,121,114,106,98,96,107,119,130,142,154,165,
	176,187,200,211,222,234,245,250,238,226,215,204,192,181,169,158,
	147,136,124,113,101,106,113,119,126,133,140,147,153,160,167,174,
	180,187,194,201,207,215,221,214,207,201,194,188,180,181,192,204,
	215,227,238,249,245,234,222,211,199,188,176,165,154,142,131,120,
	16,28,39,50,61,73,85,96,107,119,130,142,153,165,176,188,
	199,210,222,233,245,249,238,228,216,204,206,214,222,230,237,245,
	253,245,237,230,222,214,207,198,191,184,175,168,161,152,145,137,
	129,122,113,107,100,112,123,135,146,158,169,180,191,203,215,226,
	238,249,245,234,223,212,200,189,177,165,154,143,132,121,109,106,
	114,122,129,137,145,152,160,168,176,183,192,199,207,214,222,230,
	237,245,253,245,238,230,222,214,206,199,204,216,228,239,250,245,
	234,223,212,201,190,179,168,157,147,136,126,116,106,97,88,79,
	72,64,60,56,55,56,60,65,71,79,87,96,106,116,126,136,
	147,157,168,179,190,201,212,223,234,245,250,239,228,216,207,214,
	222,230,237,246,253,245,238,230,223,214,207,199,191,184,176,168,
	160,153,145,137,130,121,113,107,99,97,109,120,131,143,155,165,
	177,188,200,211,223,235,246,249,238,226,215,204,192,180,169,158,
	146,135,124,112,101,106,113,120,127,133,140,147,154,161,167,173,
	181,188,194,201,207,215,221,214,207,201,194,187,180,181,193,204,
	215,227,238,250,245,233,221,210,199,188,176,164,153,141,130,119,
	16,27,39,50,61,73,84,96,107,118,130,141,152,164,176,186,
	199,210,221,232,244,250,239,228,216,204,207,214,222,229,238,246,
	253,245,238,230,222,214,207,199,191,184,176,168,161,153,145,137,
	129,122,114,106,100,111,123,134,145,157,169,180,191,202,213,225,
	236,248,247,235,224,212,201,189,179,167,156,144,132,121,110,106,
	113,122,129,137,144,153,160,168,176,184,191,199,207,214,222,230,
	237,245,253,245,238,230,222,214,207,199,202,214,225,235,247,248,
	237,226,215,204,194,183,172,162,152,141,131,122,113,104,96,87,
	81,74,71,68,67,68,70,75,80,87,95,104,112,122,131,142,
	152,162,172,183,193,204,216,226,237,248,247,236,225,214,207,215,
	223,230,238,245,253,245,238,230,222,214,207,199,191,184,176,168,
	160,152,145,137,129,122,114,106,99,99,110,121,133,144,156,167,
	178,189,201,212,223,235,246,248,236,225,214,202,191,179,168,157,
	146,134,123,111,100,106,113,120,126,133,140,146,154,160,167,174,
	181,187,194,201,207,214,221,214,207,200,194,187,181,182,194,205,
	216,227,239,251,244,232,221,210,198,187,175,164,153,141,130,118,
	15,27,38,50,60,72,84,95,106,117,130,141,152,164,175,186,
	198,209,221,232,243,251,239,228,217,206,207,215,222,230,238,246,
	253,246,238,230,222,214,207,199,191,184,176,168,160,152,145,137,
	130,122,114,106,99,110,122,133,144,156,167,178,190,201,212,225,
	235,246,248,237,225,214,202,191,180,168,156,146,134,123,111,106,
	114,122,130,137,145,153,160,168,175,184,191,199,206,214,222,230,
	238,245,253,245,238,229,222,214,206,199,200,210,222,233,244,252,
	240,229,219,208,198,188,177,167,157,148,137,128,120,111,104,96,
	90,85,81,79,78,79,81,85,90,96,103,112,120,129,138,147,
	157,167,177,188,198,208,219,230,241,251,243,232,222,211,207,214,
	222,230,238,245,253,246,237,230,222,214,207,199,191,183,176,168,
	160,152,144,138,130,121,114,106,98,100,111,122,134,145,156,168,
	179,190,202,214,225,236,247,247,235,224,213,201,189,178,167,156,
	144,133,122,110,99,106,113,120,127,133,140,147,154,160,167,174,
	181,187,194,201,208,214,221,214,208,201,194,187,180,182,194,205,
	217,228,239,251,244,232,221,209,197,186,175,164,152,141,129,118,
	14,26,37,49,60,71,83,94,105,117,128,139,152,162,174,186,
	197,209,220,231,243,252,240,229,218,206,207,214,222,230,237,245,
	253,245,238,230,222,214,206,199,191,184,176,168,160,153,145,137,
	129,122,114,106,98,109,121,132,143,155,166,177,188,200,212,222,
	235,246,250,237,226,215,204,192,181,170,159,147,135,124,113,106,
	114,122,130,137,145,152,160,168,176,183,191,199,207,214,222,230,
	238,245,253,245,237,229,222,215,207,199,197,207,219,230,240,251,
	244,234,223,213,203,193,183,173,163,154,144,135,127,120,112,106,
	101,96,92,90,89,90,92,95,100,106,113,120,128,136,144,154,
	163,173,183,193,203,213,224,234,244,251,240,230,219,207,206,214,
	222,230,238,245,253,245,238,230,223,215,206,199,191,184,175,168,
	161,153,145,137,129,121,114,106,98,101,113,124,136,147,158,169,
	180,192,204,215,226,238,249,246,235,223,212,200,188,178,166,154,
	143,132,121,109,100,106,113,120,127,133,140,146,153,160,167,173,
	180,187,194,201,208,214,221,214,208,201,195,188,181,184,194,206,
	218,229,241,252,242,231,220,208,197,185,174,162,151,140,128,117,
	14,25,36,48,60,70,82,93,105,116,128,139,150,162,173,185,
	196,208,219,230,242,253,241,230,219,208,206,214,222,230,238,246,
	253,245,237,230,222,215,207,199,191,184,176,168,160,153,145,137,
	129,122,114,106,98,108,119,131,142,153,164,176,187,199,211,221,
	233,244,250,239,227,216,205,193,183,171,160,149,137,126,114,106,
	113,122,130,138,145,152,160,168,176,184,191,199,206,215,222,230,
	237,245,253,246,237,230,222,214,207,199,193,204,215,225,236,246,
	249,239,228,218,208,198,188,179,169,161,152,143,135,128,122,116,
	111,107,104,101,101,101,103,107,111,116,122,128,136,143,152,160,
	169,179,188,199,208,218,228,239,249,247,236,225,214,204,207,215,
	222,230,238,245,253,246,237,229,222,214,207,199,191,184,175,168,
	160,153,145,137,129,122,114,106,99,103,115,126,137,148,160,172,
	182,194,206,216,228,239,251,244,232,222,210,199,188,176,165,153,
	142,131,119,108,99,106,113,119,126,133,140,147,153,160,167,174,
	180,187,194,201,208,214,221,214,208,201,195,187,181,185,195,207,
	218,230,242,252,242,231,219,207,197,184,173,162,150,139,127,116,
	13,24,35,47,58,69,81,93,104,115,127,138,149,161,173,184,
	196,207,218,229,241,252,242,231,219,208,207,215,222,229,237,246,
	253,245,238,230,222,215,207,199,192,184,176,168,160,153,145,137,
	129,121,114,106,99,107,118,130,141,152,163,175,186,198,209,220,
	231,243,253,241,229,218,207,195,184,173,162,150,139,128,116,106,
	114,121,129,137,145,153,160,168,176,183,191,199,207,215,222,230,
	238,246,253,246,238,230,222,214,207,199,191,199,211,221,232,242,
	252,244,233,224,214,204,195,186,177,169,159,152,144,137,131,126,
	121,117,115,113,113,113,115,118,121,126,131,138,144,152,160,168,
	177,186,195,204,214,224,233,244,252,242,231,221,210,200,206,214,
	222,230,238,245,253,245,237,229,222,214,206,199,191,183,176,168,
	160,152,145,137,129,122,114,106,99,106,117,128,139,150,161,173,
	184,196,207,218,229,241,252,242,231,220,208,197,186,174,163,152,
	141,129,117,106,100,106,113,120,126,133,139,147,154,160,167,174,
	180,188,194,201,207,214,221,214,208,201,194,187,181,185,197,208,
	219,231,243,252,240,230,218,206,195,184,172,161,149,139,127,115,
	12,23,34,46,58,69,80,91,103,114,126,137,148,160,171,183,
	194,206,217,228,240,251,244,232,220,209,206,214,222,230,238,245,
	253,246,237,230,222,215,207,199,191,183,175,168,160,153,144,137,
	129,121,114,106,99,105,116,128,139,150,162,173,184,196,206,218,
	229,240,252,243,232,220,209,198,186,175,163,153,141,130,119,107,
	114,121,130,137,145,153,160,168,176,183,191,199,207,214,222,230,
	238,245,253,246,237,230,222,214,206,199,191,195,206,216,226,237,
	246,249,240,230,220,211,202,193,185,176,168,161,154,147,141,136,
	132,129,126,124,124,125,126,129,132,136,142,148,153,160,168,176,
	184,193,201,211,220,229,239,249,247,236,226,216,206,199,207,215,
	222,229,237,245,253,245,238,230,222,215,207,199,191,184,175,168,
	160,152,145,137,129,122,114,106,99,107,119,130,141,152,164,175,
	187,198,209,220,231,243,252,241,230,218,207,195,185,172,162,150,
	139,127,117,105,99,106,113,119,126,133,140,147,153,161,167,173,
	181,188,194,201,208,214,221,215,208,201,194,187,181,186,198,209,
	220,232,244,251,240,228,217,206,194,183,171,160,148,137,126,114,
	11,22,34,45,57,68,79,90,101,114,125,136,148,159,170,182,
	193,205,216,228,239,250,245,234,222,210,207,214,222,230,238,245,
	253,246,238,229,222,214,206,199,191,183,176,168,161,153,144,137,
	130,122,114,106,99,103,115,125,137,148,159,172,183,194,205,217,
	228,239,250,245,234,222,211,200,189,177,166,155,143,133,121,110,
	114,122,130,137,144,152,160,168,176,183,191,199,207,214,222,230,
	238,245,253,245,238,230,222,215,207,199,192,190,201,211,221,231,
	241,251,246,237,227,218,209,201,193,184,177,170,163,157,152,146,
	142,139,138,136,136,136,137,140,143,147,151,157,163,170,177,184,
	192,200,209,218,227,236,246,251,241,231,221,211,201,199,207,214,
	222,230,238,245,253,245,238,229,222,215,207,199,191,184,175,168,
	161,152,145,137,129,121,114,107,99,110,121,133,144,155,166,177,
	189,200,211,222,233,245,250,238,228,216,205,193,183,171,159,149,
	137,126,115,104,100,106,113,119,127,133,140,147,153,161,167,173,
	180,188,194,201,207,214,221,215,207,201,194,188,180,188,199,211,
	222,233,244,250,239,228,216,205,193,182,171,159,147,136,125,113,
	10,21,33,44,55,66,78,89,101,112,123,135,147,158,169,180,
	192,203,214,226,238,249,246,234,223,212,206,214,222,229,238,246,
	253,245,237,230,222,214,207,199,191,183,176,168,160,153,145,137,
	129,121,113,106,99,102,113,124,135,147,158,170,180,192,203,215,
	226,237,248,247,235,224,213,202,190,179,169,157,146,135,124,112,
	114,121,130,137,145,153,161,168,176,184,191,199,207,215,222,230,
	238,245,253,245,237,229,222,214,206,199,192,185,196,205,216,225,
	234,245,252,243,234,225,217,208,200,193,186,179,172,167,162,157,
	154,151,149,148,147,147,148,151,154,158,162,167,173,179,186,193,
	201,209,216,225,234,243,252,244,235,226,216,205,196,199,206,214,
	222,229,238,245,253,245,238,230,222,214,207,199,191,183,176,168,
	160,152,144,137,130,122,114,106,102,113,124,134,146,157,168,179,
	190,202,213,225,236,247,248,237,225,214,203,192,181,169,158,147,
	136,124,112,101,99,106,113,120,126,133,140,147,153,160,167,174,
	181,188,194,200,208,215,221,214,207,200,194,187,180,189,201,212,
	223,235,245,249,237,226,215,203,192,180,169,158,147,135,124,112,
	9,20,31,43,54,66,77,88,100,111,122,134,145,156,168,179,
	191,202,213,225,236,247,247,236,225,213,207,214,222,229,237,245,
	253,245,238,230,222,214,207,199,192,184,175,168,160,153,145,137,
	129,122,114,107,99,99,111,123,134,145,156,167,179,189,201,212,
	223,235,246,250,238,227,215,205,193,182,171,160,148,138,127,115,
	114,122,130,137,144,152,160,168,176,183,192,199,206,214,222,230,
	237,245,253,245,237,229,222,214,206,199,191,184,190,200,209,219,
	229,238,247,250,242,233,224,217,209,201,195,189,182,177,172,168,
	164,162,160,159,159,159,160,162,164,169,172,177,183,188,195,201,
	209,217,225,233,242,250,247,238,229,219,209,200,192,199,207,215,
	222,230,238,245,253,245,238,230,222,214,206,199,191,183,176,168,
	160,153,145,137,129,121,114,106,104,115,126,138,149,160,171,182,
	193,205,216,226,238,249,246,235,224,212,201,189,178,167,156,144,
	134,122,111,100,99,106,113,120,126,133,140,146,154,160,167,174,
	180,187,194,200,207,215,222,215,207,201,194,187,180,191,202,214,
	225,236,247,248,236,225,213,202,191,179,168,157,145,134,122,111,
	8,18,30,41,52,64,76,87,99,110,121,132,144,155,166,178,
	189,200,212,223,234,246,248,238,226,215,207,215,222,230,238,246,
	253,246,238,230,222,215,206,199,191,184,176,168,160,153,144,137,
	129,122,114,106,98,98,109,120,131,142,154,165,176,188,198,210,
	221,232,244,252,241,229,218,207,196,185,174,163,152,140,129,119,
	114,122,129,137,145,152,160,168,176,183,191,199,206,214,222,229,
	238,245,253,245,237,229,222,215,207,199,191,183,184,193,203,212,
	222,231,239,249,249,241,233,225,218,211,204,198,192,187,183,179,
	176,173,171,170,170,170,171,173,175,179,183,187,193,198,204,210,
	218,225,233,241,249,248,240,231,221,213,204,193,191,199,207,214,
	222,230,237,245,253,245,237,230,222,214,207,199,191,184,175,168,
	160,153,145,138,130,121,114,106,108,119,130,141,152,163,174,185,
	196,207,218,229,241,252,243,232,221,209,198,187,176,165,154,142,
	131,120,109,97,99,106,113,120,127,134,140,147,154,160,167,174,
	180,187,194,201,208,215,222,215,208,201,195,187,181,192,204,215,
	226,238,249,245,235,223,212,200,189,178,166,155,144,133,121,110,
	6,17,29,40,52,63,74,86,97,108,119,131,143,154,164,176,
	188,199,210,222,233,244,250,239,228,216,207,214,222,229,238,245,
	253,246,238,229,222,214,206,199,191,183,175,168,160,152,145,137,
	130,122,114,106,98,95,106,118,128,140,151,162,174,185,196,207,
	218,229,241,252,243,232,221,210,199,188,177,165,155,144,133,122,
	114,122,130,137,145,153,161,168,176,183,191,199,206,214,222,230,
	238,245,253,245,238,230,222,214,206,199,191,183,177,187,196,206,
	214,224,233,240,249,249,241,234,227,221,214,208,203,198,194,190,
	187,184,183,181,181,182,182,185,187,190,194,198,203,208,214,220,
	227,234,242,249,249,241,232,224,215,206,196,187,191,199,206,214,
	223,230,237,245,253,245,238,230,222,215,207,199,192,183,176,168,
	160,152,145,138,130,121,114,106,111,121,132,143,155,166,177,187,
	198,210,221,232,243,252,241,230,218,207,196,184,173,162,151,140,
	129,118,107,96,99,106,113,120,127,133,140,146,153,160,167,174,
	181,187,194,201,208,214,221,215,207,201,194,187,183,194,205,216,
	228,239,250,245,233,222,210,199,188,176,165,153,142,130,119,108,
	6,16,28,38,50,61,73,84,95,106,118,129,140,152,163,175,
	186,197,208,220,231,242,252,241,230,218,207,214,222,230,238,246,
	253,246,237,230,223,214,206,199,191,183,176,168,160,152,145,137,
	129,121,114,106,98,93,104,116,126,137,149,160,171,182,193,205,
	216,227,238,248,246,235,224,213,202,191,180,169,157,147,136,125,
	114,122,129,137,145,153,160,168,176,183,192,199,207,214,222,230,
	238,245,253,245,238,229,222,214,207,199,191,183,176,181,189,199,
	207,216,225,233,241,249,250,243,236,230,223,218,213,208,205,200,
	198,195,194,192,193,193,194,195,198,201,204,208,213,218,224,230,
	236,243,250,249,241,233,225,216,208,198,189,183,191,199,206,214,
	222,230,237,245,253,246,238,230,222,215,206,199,191,184,176,168,
	160,153,145,137,129,122,114,107,114,125,136,147,158,168,180,191,
	202,213,224,235,246,248,238,227,216,204,193,183,172,160,149,138,
	127,116,104,93,99,106,113,119,127,133,140,146,153,160,167,174,
	180,187,194,201,208,214,221,214,207,201,194,187,184,195,207,219,
	229,241,252,243,232,220,209,197,186,174,163,152,141,129,118,107,
	6,14,25,37,49,60,71,82,94,105,117,128,139,151,162,173,
	184,195,207,218,229,241,252,243,232,220,209,215,222,229,237,245,
	253,245,237,229,222,214,207,199,191,184,176,168,161,153,144,137,
	130,122,114,107,99,91,102,113,124,135,147,157,169,180,190,202,
	213,224,235,246,249,238,227,216,205,194,184,172,161,151,139,129,
	118,122,129,137,145,152,160,168,176,184,191,199,207,215,222,230,
	238,245,253,245,237,229,222,214,207,199,191,184,176,173,183,191,
	200,208,217,225,233,240,247,252,246,240,234,229,223,219,215,212,
	209,207,206,204,204,205,205,207,209,211,215,219,223,228,233,240,
	246,252,247,240,233,225,216,209,200,191,182,184,191,199,206,214,
	222,230,238,246,253,245,238,229,222,214,207,199,191,184,176,168,
	161,153,144,138,130,122,114,107,118,129,139,150,162,172,183,194,
	205,216,227,238,250,246,235,223,213,202,191,180,168,157,147,135,
	124,113,102,92,100,107,113,120,126,134,140,146,154,160,167,174,
	181,187,194,201,208,215,221,214,207,201,194,187,186,197,209,220,
	231,242,252,241,230,219,207,195,184,173,161,151,139,128,116,105,
	6,14,24,36,47,58,69,81,92,104,115,126,137,149,160,171,
	183,193,205,216,228,239,250,245,233,222,210,214,222,230,238,246,
	253,245,238,230,223,214,207,199,191,183,176,168,161,153,145,137,
	130,122,114,106,98,90,99,110,121,132,143,155,166,176,187,199,
	209,221,232,243,252,242,230,220,208,197,187,175,165,154,143,133,
	121,122,129,137,144,152,160,168,175,184,191,198,207,214,222,230,
	237,245,253,245,237,230,223,214,206,199,191,183,175,168,176,184,
	192,201,208,216,224,231,238,245,251,249,244,239,234,230,226,223,
	220,219,216,216,215,215,217,218,220,223,226,230,234,238,244,249,
	251,244,238,231,224,216,208,201,192,183,176,184,191,199,206,215,
	223,229,237,245,253,245,237,230,222,214,206,199,191,183,176,168,
	160,153,145,137,130,122,113,111,122,133,143,154,165,176,186,198,
	208,219,230,242,252,242,232,221,210,199,188,177,165,154,144,132,
	122,110,99,92,100,107,112,119,127,133,140,147,154,160,167,174,
	180,188,194,201,208,214,221,215,207,201,194,187,189,199,211,222,
	233,245,250,239,227,216,205,194,182,171,160,148,137,126,115,104,
	6,14,22,33,45,57,68,79,90,102,113,124,136,146,158,169,
	181,192,203,215,225,237,249,247,235,224,212,215,222,229,237,245,
	253,245,237,230,222,215,207,199,191,184,176,168,160,153,145,137,
	129,122,114,106,98,91,96,107,118,129,141,152,163,174,185,196,
	207,218,229,240,250,245,234,223,212,201,191,180,169,158,147,137,
	126,121,130,137,145,152,160,168,175,183,191,199,207,215,222,230,
	237,245,253,246,238,229,222,214,207,199,191,184,175,168,168,176,
	185,192,200,208,215,222,228,234,241,247,252,249,245,240,237,234,
	231,230,228,227,227,227,228,230,231,234,237,241,245,249,252,247,
	241,235,228,222,214,207,200,192,184,176,175,183,191,199,207,215,
	222,230,238,245,253,246,238,229,222,214,206,199,191,184,176,168,
	160,153,145,137,130,122,114,115,126,136,147,158,168,180,190,201,
	212,223,233,244,250,239,229,217,207,195,184,174,163,151,141,130,
	118,108,97,93,100,107,113,120,127,134,140,146,153,161,167,174,
	181,187,194,201,208,214,221,214,208,201,194,187,190,202,213,224,
	235,246,249,237,226,214,203,192,181,169,158,147,135,124,113,102,
	6,14,21,32,43,54,66,77,88,100,111,123,133,145,156,167,
	178,190,201,213,223,234,246,248,238,227,215,214,222,230,237,245,
	253,246,238,229,222,214,207,199,192,183,176,168,160,153,145,137,
	129,121,114,106,98,91,93,105,115,126,138,149,160,171,181,193,
	203,214,225,236,247,249,237,226,215,205,194,183,172,162,152,141,
	130,121,129,137,144,153,160,168,176,183,191,199,207,215,222,230,
	238,246,253,245,237,230,222,215,206,199,191,184,176,168,160,168,
	176,184,191,198,205,213,219,226,231,236,242,246,250,252,248,245,
	242,240,239,239,238,239,240,241,243,245,248,252,251,247,242,236,
	232,225,219,212,206,199,191,184,176,168,176,184,192,199,207,214,
	222,230,237,245,253,245,238,230,222,214,206,199,191,184,176,168,
	160,153,145,137,130,122,114,120,130,140,151,162,173,183,194,205,
	215,226,237,248,247,236,225,215,204,193,182,171,160,149,137,126,
	116,104,94,92,99,106,113,120,127,133,140,147,154,160,167,174,
	180,188,194,201,207,214,221,215,208,201,195,187,192,204,215,226,
	238,249,246,235,223,213,201,190,179,167,156,144,134,123,111,100,
	6,14,21,30,42,53,64,75,86,97,109,120,131,143,154,165,
	177,188,199,211,222,232,243,251,240,229,218,214,223,229,238,246,
	253,245,237,230,222,215,207,199,191,183,176,168,160,152,144,137,
	129,122,114,107,98,91,90,101,112,123,134,145,156,167,178,189,
	200,211,222,233,244,252,241,230,220,208,198,188,176,167,155,145,
	135,124,129,137,145,153,161,168,176,184,192,199,206,214,222,230,
	237,245,253,245,238,230,222,215,207,199,191,183,176,168,161,160,
	168,176,183,190,197,204,210,215,221,227,232,235,240,244,247,249,
	252,252,251,250,250,250,251,252,252,250,247,244,240,236,232,226,
	221,216,210,204,196,189,183,175,167,168,175,183,191,199,207,214,
	222,230,237,245,253,246,238,229,222,214,207,199,192,184,176,168,
	161,153,145,137,129,121,114,124,135,145,156,166,177,187,198,208,
	219,231,241,252,243,233,222,211,200,189,178,167,156,146,134,123,
	112,102,90,93,99,106,113,120,126,133,140,146,153,161,167,174,
	180,188,194,200,207,215,221,215,208,201,194,188,195,206,217,228,
	240,251,244,233,222,210,199,188,176,166,154,142,132,120,109,98,
	6,13,21,29,39,51,62,73,84,96,107,118,130,140,152,163,
	174,185,197,208,219,230,242,253,242,231,220,215,222,230,238,245,
	253,246,237,230,223,215,207,199,191,183,176,168,160,152,144,138,
	129,122,114,106,99,90,87,98,109,120,131,142,153,164,174,186,
	196,207,218,229,239,250,245,235,223,213,203,192,181,171,160,150,
	139,128,130,137,145,152,160,168,175,184,191,199,207,215,222,230,
	238,245,253,245,237,230,222,214,207,199,191,184,176,168,161,153,
	159,166,174,181,187,193,200,205,211,216,221,225,229,233,236,239,
	240,243,244,244,245,244,243,242,241,238,236,232,229,225,221,216,
	211,205,200,194,187,180,173,166,160,168,175,183,191,199,207,214,
	222,230,238,245,253,245,237,230,222,214,207,199,191,183,176,168,
	160,153,145,137,129,122,118,128,138,150,160,170,181,192,202,212,
	224,234,245,250,239,229,218,207,196,185,174,163,153,141,131,120,
	109,98,87,92,99,107,113,120,127,133,140,147,153,160,167,173,
	181,187,194,200,207,214,221,214,208,201,195,187,197,208,220,230,
	242,253,242,230,220,208,197,186,174,163,152,141,129,118,107,96,
	6,13,22,29,37,48,60,71,83,94,105,116,127,139,149,161,
	172,183,195,205,217,228,239,251,245,233,223,214,222,230,238,245,
	253,245,238,230,222,214,206,199,192,184,176,168,161,153,145,137,
	129,122,114,106,98,91,84,94,106,117,128,138,149,160,171,182,
	193,204,214,224,236,246,249,238,227,217,206,196,186,174,165,154,
	144,133,129,137,145,152,160,168,176,183,191,199,206,214,222,230,
	237,245,253,245,238,230,222,215,207,199,191,184,175,168,160,152,
	150,158,165,171,178,184,190,195,201,206,210,214,218,222,224,227,
	230,231,232,233,233,233,232,231,229,228,225,222,219,215,211,206,
	201,195,190,184,178,171,165,157,160,168,176,184,192,199,206,215,
	222,229,237,245,253,245,238,230,222,214,207,199,191,184,175,168,
	160,152,145,137,130,122,123,133,144,154,164,175,186,196,207,217,
	228,238,249,247,236,225,215,204,193,182,171,160,149,138,127,117,
	106,94,86,93,100,107,113,120,127,134,140,147,154,160,167,174,
	180,187,195,201,208,215,222,215,208,201,194,189,200,211,222,233,
	244,251,239,228,217,205,194,184,172,161,150,139,127,116,104,94,
	5,13,21,28,36,47,58,69,80,91,102,114,125,136,147,158,
	169,181,192,204,214,226,237,248,247,236,224,215,222,230,237,246,
	253,246,237,230,223,215,207,199,192,183,176,168,161,153,145,137,
	130,122,114,106,98,91,83,91,103,113,124,135,146,156,167,178,
	189,199,210,221,231,243,252,243,232,222,211,201,190,180,169,159,
	148,138,129,137,145,153,161,168,176,184,191,198,207,214,222,230,
	237,245,253,245,237,230,222,214,206,198,191,184,175,168,160,152,
	145,148,156,162,168,174,180,186,190,195,200,203,208,211,213,216,
	219,220,221,221,222,221,221,220,218,216,214,211,207,204,200,195,
	191,186,180,174,168,162,155,152,160,168,176,184,191,198,206,215,
	222,230,237,245,253,246,237,229,222,214,207,199,192,183,175,168,
	160,153,145,137,130,122,128,138,148,159,170,179,190,201,211,221,
	232,243,253,242,231,221,210,199,188,178,167,157,146,135,124,113,
	102,92,86,93,99,106,113,120,127,134,140,147,153,161,167,174,
	180,188,194,200,208,214,221,214,207,200,194,191,203,213,225,236,
	247,248,237,225,214,204,192,181,170,159,147,136,125,114,102,91,
	7,14,21,29,37,45,55,66,78,89,100,111,122,133,144,156,
	167,179,190,200,212,223,234,245,250,238,228,216,222,230,238,245,
	253,245,238,230,222,215,207,199,191,184,175,168,160,153,145,137,
	129,121,114,106,99,90,83,88,98,109,120,131,142,153,164,174,
	185,195,206,216,227,238,248,247,237,226,215,205,194,184,174,164,
	153,144,133,137,145,153,161,168,175,184,192,199,207,215,222,230,
	238,245,253,246,238,230,223,214,206,199,191,184,176,168,160,153,
	145,139,146,153,159,165,170,175,180,185,189,193,196,200,202,205,
	207,208,209,210,210,210,209,208,207,205,202,200,196,193,190,185,
	180,175,170,164,159,153,146,152,160,168,175,184,191,199,206,215,
	222,230,237,245,253,246,237,230,222,214,206,199,191,183,176,168,
	160,152,145,137,129,123,134,143,153,163,174,185,195,205,216,226,
	236,247,249,238,228,216,206,195,185,174,163,152,141,131,120,110,
	99,88,86,93,99,106,113,120,126,133,140,147,154,160,167,174,
	180,188,194,201,207,214,221,214,208,201,194,194,205,216,227,238,
	250,245,234,223,212,201,190,179,167,156,145,134,123,111,100,89,
	9,13,21,29,37,44,52,64,76,87,97,109,120,132,143,153,
	165,176,186,198,209,220,231,242,252,242,230,219,222,230,238,245,
	253,245,237,230,222,214,206,199,191,184,175,168,160,153,145,137,
	129,121,114,106,99,90,83,84,95,106,117,127,138,148,159,170,
	180,191,202,212,223,234,244,252,241,230,220,210,199,189,179,169,
	158,149,138,137,145,153,160,168,176,183,191,199,207,215,222,230,
	238,245,253,246,238,229,222,214,207,199,192,184,176,168,161,153,
	145,137,136,143,149,154,160,165,169,174,179,183,185,189,191,193,
	196,197,198,199,199,199,198,197,196,193,191,188,186,182,178,175,
	170,165,160,155,149,142,145,152,160,168,176,183,192,199,207,214,
	222,230,238,245,253,245,238,230,222,214,206,199,191,183,175,168,
	161,153,145,137,129,128,139,148,159,169,179,189,200,209,220,231,
	241,252,244,234,223,213,201,191,181,170,159,148,138,127,116,105,
	95,84,86,93,100,107,113,120,127,133,140,147,154,160,167,174,
	181,187,194,201,208,214,221,215,208,201,194,196,208,219,231,242,
	253,243,232,220,209,198,187,175,165,153,143,131,120,109,98,87,
	11,13,21,29,37,44,52,62,73,84,95,106,118,129,140,151,
	162,173,185,195,207,218,228,240,251,244,233,222,222,230,238,245,
	253,245,237,230,222,214,206,198,191,183,176,168,161,153,145,137,
	130,121,114,106,98,91,83,81,91,101,112,123,133,145,155,166,
	176,187,197,208,219,228,239,250,246,236,226,215,205,194,184,174,
	164,154,144,137,145,153,160,168,175,184,191,199,207,214,222,229,
	237,245,253,245,238,230,222,214,207,199,191,183,176,168,160,152,
	144,137,129,133,139,144,150,155,160,164,168,171,175,178,180,182,
	184,186,186,187,188,187,186,185,184,182,180,178,174,171,167,164,
	159,154,149,144,138,137,145,153,161,168,176,183,191,199,206,214,
	222,230,237,245,253,245,237,230,222,214,207,199,191,184,176,168,
	160,152,145,137,130,134,144,154,164,174,184,194,205,215,225,235,
	246,249,239,228,218,208,197,187,176,166,155,144,134,123,113,101,
	91,80,86,93,100,106,113,120,127,133,140,147,154,161,167,174,
	181,187,194,201,207,215,221,214,208,201,194,200,211,222,233,244,
	251,240,228,218,206,196,185,173,162,151,140,129,118,107,95,84,
	13,13,21,29,37,45,52,60,71,81,93,104,115,126,137,148,
	159,171,182,193,204,214,226,237,248,247,236,225,222,230,238,246,
	253,245,237,230,222,215,207,199,192,183,176,168,160,153,145,137,
	129,122,114,106,98,90,83,76,87,98,109,119,130,140,150,162,
	172,182,193,204,213,224,234,244,251,240,230,220,209,200,190,179,
	169,159,149,139,145,152,160,168,175,183,191,199,207,215,222,230,
	238,246,253,246,238,230,222,214,206,199,191,184,175,168,161,153,
	144,137,129,123,129,134,139,144,149,153,157,161,164,167,169,171,
	173,174,175,176,176,176,175,174,173,171,169,167,163,161,156,153,
	149,144,140,134,129,137,144,153,160,168,176,184,191,199,207,214,
	222,230,237,245,253,245,238,230,222,215,207,199,192,183,175,168,
	161,153,145,137,130,140,150,159,170,179,189,200,210,220,230,241,
	251,245,234,224,214,203,193,183,172,161,151,141,130,119,108,97,
	87,79,86,93,99,106,113,120,127,133,140,147,153,161,167,173,
	180,188,195,201,207,214,221,215,208,201,194,202,214,225,236,247,
	248,237,226,215,204,193,182,170,159,148,137,126,115,104,93,81,
	16,13,21,29,36,45,52,60,68,79,90,101,112,123,134,145,
	156,168,178,190,201,212,222,234,245,250,239,228,222,229,237,245,
	253,245,237,230,222,214,207,199,192,183,176,168,160,153,145,137,
	130,122,114,107,98,91,83,75,82,93,104,115,125,136,146,157,
	168,178,189,199,209,219,229,239,250,246,236,226,216,205,196,185,
	175,165,155,146,145,153,160,168,176,183,191,199,206,215,222,230,
	237,245,253,245,238,229,222,214,206,199,192,183,176,168,160,152,
	145,137,130,122,119,124,129,134,138,142,146,149,152,156,157,160,
	161,162,164,165,165,164,164,163,161,160,158,155,152,149,146,142,
	138,134,129,124,130,137,145,153,160,168,176,184,192,199,206,214,
	222,230,238,245,253,246,237,230,222,214,207,199,191,184,175,168,
	160,153,145,137,135,146,155,166,175,185,195,206,215,225,236,246,
	250,240,230,220,209,198,188,177,168,157,146,135,125,114,104,93,
	82,79,85,92,99,106,112,120,127,134,140,147,153,160,167,173,
	181,187,194,201,208,214,221,215,208,201,195,206,217,228,239,250,
	245,234,223,211,201,189,178,167,156,146,134,123,112,101,90,79,
	17,13,21,29,37,44,52,60,68,76,87,98,109,120,131,143,
	153,165,175,187,198,209,220,231,242,253,242,231,222,229,237,245,
	253,245,238,229,222,214,207,199,191,183,176,168,160,152,145,138,
	130,122,114,106,98,91,83,75,78,89,99,111,121,131,141,153,
	163,172,184,194,204,215,224,235,244,251,241,231,221,210,201,191,
	181,171,161,151,145,152,161,168,176,184,191,199,207,215,222,229,
	238,245,253,245,237,230,222,214,207,199,191,184,176,168,160,153,
	145,137,130,122,114,114,119,124,128,132,136,139,141,144,146,148,
	150,151,153,153,153,153,152,151,150,148,147,144,142,138,135,132,
	127,124,118,122,130,137,144,153,160,168,175,184,191,199,206,214,
	222,230,237,246,253,245,237,230,222,214,207,199,191,184,176,168,
	160,153,144,137,142,152,162,171,181,191,201,210,220,230,241,251,
	245,235,224,214,204,193,184,173,162,153,142,131,121,110,100,89,
	79,79,86,93,99,107,113,119,126,133,140,147,153,160,167,173,
	180,187,194,201,208,214,221,214,207,201,199,209,220,231,242,253,
	241,230,220,209,198,186,176,165,154,143,131,120,110,98,87,76,
	20,14,21,29,36,44,52,59,67,75,85,95,106,118,128,139,
	150,162,172,184,194,205,217,228,238,250,246,234,223,230,238,245,
	253,245,238,230,222,214,207,199,191,184,175,168,160,153,144,137,
	129,121,114,106,99,91,83,75,74,85,95,106,116,127,137,148,
	158,168,179,189,199,209,219,230,239,249,247,237,227,217,207,196,
	187,177,168,158,148,153,160,168,176,184,191,199,206,214,222,230,
	237,245,253,245,238,230,222,214,206,199,191,183,176,168,160,152,
	145,137,130,122,114,106,108,112,117,121,124,128,130,133,135,137,
	139,141,141,141,142,141,141,141,139,137,135,133,130,127,124,120,
	117,112,114,121,129,137,145,152,161,168,175,183,191,199,206,215,
	222,230,237,245,253,245,238,230,222,215,207,199,191,183,176,168,
	160,152,144,138,148,158,167,177,187,197,207,217,226,236,246,249,
	240,229,219,209,198,188,178,168,158,147,137,126,116,105,96,85,
	74,79,86,92,100,106,113,120,126,133,140,147,154,161,167,174,
	180,188,194,201,208,215,222,214,208,201,202,213,224,235,245,250,
	239,227,217,205,194,184,173,162,151,140,129,117,106,96,84,73,
	22,13,22,29,37,44,52,60,68,75,83,93,103,114,125,137,
	148,158,170,180,191,203,214,224,235,246,249,237,227,230,237,246,
	253,245,238,230,222,214,207,198,191,184,176,168,160,153,145,137,
	129,121,114,106,98,91,83,75,70,80,91,101,112,121,132,143,
	153,163,173,184,194,204,214,224,235,244,252,242,232,222,213,203,
	193,184,173,164,155,152,160,168,175,183,191,199,207,214,223,229,
	238,245,253,245,238,230,222,214,207,199,191,183,176,168,160,152,
	145,137,130,122,114,106,98,102,106,110,113,116,119,122,124,126,
	127,129,129,130,131,130,130,129,127,126,124,122,119,117,113,110,
	106,106,114,122,129,137,145,153,161,168,176,183,192,199,207,214,
	222,230,238,245,253,245,237,230,222,214,207,199,192,183,176,168,
	161,153,145,146,155,164,173,184,193,202,213,222,232,242,252,244,
	234,224,214,204,194,183,173,163,153,142,132,122,111,101,90,80,
	72,80,86,92,99,106,113,120,127,133,140,146,154,160,167,174,
	181,188,194,201,207,214,221,214,208,200,205,216,227,238,248,246,
	235,224,214,203,192,180,169,159,148,136,125,114,103,92,81,70,
	25,15,21,28,37,44,53,59,67,76,83,91,100,111,123,133,
	145,155,167,177,188,200,210,221,232,243,253,241,231,230,237,245,
	253,245,237,230,223,215,207,199,191,183,176,168,160,153,145,137,
	129,122,113,106,99,91,83,76,68,76,86,96,106,117,128,138,
	148,158,168,178,189,198,209,219,228,238,248,247,238,228,219,209,
	199,189,180,170,161,152,160,168,175,184,191,199,207,215,222,230,
	237,245,253,246,238,230,223,214,206,199,191,183,176,168,160,153,
	145,138,129,122,114,106,99,91,95,99,103,105,108,111,112,114,
	116,117,118,119,118,118,118,118,116,114,112,111,108,105,102,99,
	98,106,114,122,130,137,144,152,160,168,175,183,192,199,206,214,
	222,230,238,245,253,245,238,229,222,214,207,199,191,183,175,168,
	160,152,145,152,161,171,180,190,199,208,219,229,237,248,249,239,
	228,218,209,199,189,179,168,158,148,137,127,117,107,96,85,75,
	73,80,86,92,100,106,113,120,126,133,140,146,154,161,167,174,
	180,187,194,201,208,214,221,214,208,201,209,219,230,242,252,243,
	232,221,210,199,189,177,166,155,144,134,123,111,100,89,78,67,
	27,18,21,29,37,44,52,60,68,75,83,90,99,109,119,130,
	141,152,163,174,185,196,206,218,228,239,251,245,234,230,238,245,
	253,246,238,230,222,214,206,199,191,183,175,168,160,152,145,137,
	130,121,114,106,98,91,83,75,67,71,81,91,102,112,122,132,
	142,153,163,173,183,193,203,213,223,232,243,252,244,235,224,215,
	206,196,186,177,168,159,160,168,175,183,191,199,207,215,222,230,
	238,245,253,245,238,230,222,214,207,198,191,184,175,168,160,153,
	145,138,130,122,114,106,98,91,84,88,91,94,97,99,102,103,
	105,106,107,107,107,108,106,106,105,104,101,99,98,94,91,90,
	99,106,114,122,129,137,145,152,160,168,175,183,191,199,206,215,
	222,230,238,246,253,245,238,229,222,215,207,199,191,183,176,168,
	160,153,150,159,168,177,187,197,206,215,224,234,244,252,242,233,
	223,213,203,193,183,173,163,153,143,133,122,112,102,91,81,71,
	72,79,86,93,100,106,113,120,127,133,140,146,153,160,167,174,
	180,187,194,201,207,214,221,214,208,201,212,223,234,245,250,239,
	228,218,206,196,184,174,163,152,141,130,119,108,97,86,75,64,
	30,20,21,29,37,45,52,60,67,75,83,90,98,106,115,126,
	137,149,159,171,181,193,203,214,224,235,247,249,238,230,238,246,
	253,246,238,230,222,215,207,198,191,183,175,168,160,153,144,137,
	130,121,114,106,99,91,83,75,68,66,76,87,97,107,117,127,
	137,148,157,168,177,188,197,208,217,227,236,247,250,241,231,221,
	212,203,193,184,175,166,161,168,176,183,191,199,206,214,222,230,
	237,246,253,246,238,230,222,215,207,199,191,183,176,168,160,153,
	145,137,129,122,114,106,98,91,83,77,80,84,86,88,90,92,
	94,94,96,96,96,95,95,94,93,92,91,88,86,83,83,91,
	99,106,114,121,130,137,145,152,160,168,176,184,191,199,207,215,
	222,230,238,245,253,245,238,230,222,214,206,198,191,184,176,168,
	160,152,157,166,175,184,193,202,212,222,231,241,250,247,237,227,
	218,207,197,188,178,168,157,148,138,127,117,107,96,86,76,66,
	72,79,86,92,99,106,113,120,126,134,140,147,153,161,167,173,
	180,187,194,201,208,214,221,214,207,205,216,227,238,249,246,236,
	225,214,203,192,181,171,159,148,138,127,115,105,94,83,71,61,
	32,23,21,29,37,44,52,60,68,75,83,91,98,106,114,123,
	134,145,156,166,178,189,200,211,221,232,243,253,242,231,237,245,
	253,246,237,229,222,214,206,199,191,184,176,168,160,152,145,137,
	129,122,113,106,98,91,83,75,68,60,71,81,92,102,112,122,
	131,142,152,162,172,181,192,202,211,220,230,240,249,247,238,228,
	218,209,200,191,182,173,163,168,175,184,191,199,207,214,222,230,
	238,246,253,246,237,230,222,214,206,199,191,183,175,168,160,153,
	144,137,130,122,114,107,99,91,83,75,69,72,75,77,79,80,
	82,83,84,85,85,84,84,83,82,80,79,77,75,75,83,90,
	98,106,114,121,129,137,144,153,161,168,176,184,191,199,206,214,
	222,229,238,245,253,245,237,230,223,214,207,199,191,184,176,168,
	160,155,164,172,182,191,200,209,219,228,237,247,249,240,231,220,
	211,201,192,182,171,162,152,142,131,122,112,101,91,81,71,66,
	72,79,86,93,99,106,113,119,127,133,140,147,153,160,167,174,
	180,188,194,201,207,215,221,214,208,209,220,231,241,253,243,232,
	221,210,199,189,178,167,156,146,134,124,113,102,90,79,68,58,
	35,25,21,29,37,44,52,60,68,75,83,91,99,107,114,121,
	131,142,152,164,174,185,196,207,218,228,239,250,246,235,238,245,
	253,245,238,230,222,215,207,199,191,183,176,168,161,152,145,137,
	129,122,114,107,98,91,83,75,68,59,65,76,86,97,107,116,
	126,136,146,156,166,176,185,195,205,215,225,234,243,252,244,234,
	225,216,207,197,188,179,171,168,176,183,191,199,207,214,222,230,
	237,245,253,245,238,230,222,214,206,199,191,183,176,168,161,153,
	145,137,129,122,114,107,98,90,83,75,67,61,64,66,68,69,
	70,72,72,73,73,73,72,72,71,70,68,66,67,75,83,90,
	99,106,114,122,129,137,144,152,160,168,175,183,191,199,207,214,
	222,230,238,245,253,246,238,230,223,214,207,199,191,184,176,168,
	160,162,171,180,189,198,207,216,225,234,244,253,244,234,224,215,
	205,196,185,176,166,156,146,136,127,116,106,97,86,76,66,66,
	72,79,85,92,99,107,113,119,127,133,140,147,153,161,167,174,
	181,188,194,201,207,215,221,214,208,213,224,234,246,250,239,228,
	217,207,195,185,174,163,152,141,131,120,109,98,87,76,66,55,
	38,28,21,29,36,45,52,60,67,76,83,91,98,106,114,121,
	130,138,149,160,170,182,192,203,213,224,235,245,249,238,237,245,
	253,246,238,230,222,214,207,199,192,183,176,168,160,152,145,137,
	129,121,114,106,98,91,83,75,67,60,61,70,81,90,100,111,
	121,131,140,150,160,170,179,189,199,208,217,228,236,246,251,241,
	232,223,214,205,196,187,178,170,176,184,192,199,207,215,222,229,
	237,245,253,245,237,230,222,214,206,199,191,184,176,168,160,153,
	144,137,129,122,114,106,98,91,83,76,67,60,53,55,56,58,
	59,60,61,61,62,61,61,60,59,58,56,60,68,75,83,91,
	99,107,114,122,129,137,145,152,160,168,175,183,192,199,207,214,
	222,230,238,245,253,245,237,230,222,215,206,198,191,184,176,168,
	161,170,178,187,196,204,214,223,232,241,250,246,237,228,218,209,
	199,189,180,170,160,150,140,131,121,111,101,90,81,71,61,65,
	72,79,86,92,100,106,112,119,127,133,140,147,153,160,167,173,
	180,187,194,201,208,214,221,214,207,217,228,238,249,246,235,224,
	213,203,192,181,171,160,149,138,127,116,106,94,84,73,62,52,
	41,31,22,29,37,45,52,60,68,75,83,91,98,106,114,122,
	129,138,145,156,166,177,189,199,210,221,231,242,253,242,237,246,
	253,245,238,230,222,215,206,199,191,184,176,168,160,153,145,137,
	129,121,114,106,98,91,83,75,67,60,55,65,76,85,96,105,
	115,124,135,145,154,164,173,183,192,202,212,221,230,239,248,248,
	239,230,221,212,204,195,186,178,175,183,191,199,207,214,222,230,
	238,245,253,245,237,230,222,215,207,199,191,184,176,168,160,153,
	145,137,129,122,114,106,99,91,83,75,68,59,52,44,45,47,
	48,48,49,50,50,50,49,49,48,47,52,60,68,75,83,90,
	98,106,114,121,129,137,145,152,160,168,176,184,191,199,207,215,
	222,230,238,245,253,245,237,230,222,214,207,199,192,183,176,168,
	169,178,186,195,203,212,220,229,239,248,249,239,230,221,212,202,
	192,182,173,163,154,144,135,124,115,105,95,85,75,65,59,66,
	72,79,86,93,100,107,113,120,127,134,140,147,154,160,167,174,
	181,188,194,201,208,214,221,214,211,222,232,242,252,242,231,220,
	210,199,188,178,166,156,145,134,124,113,102,91,80,69,59,52,
	44,34,25,29,37,45,52,60,68,75,83,91,99,106,114,122,
	129,137,145,153,162,174,184,194,206,216,227,238,248,247,237,246,
	253,246,237,230,222,214,207,199,191,183,176,168,161,153,145,137,
	129,122,114,107,98,90,83,76,67,60,52,59,69,79,90,99,
	109,119,129,138,148,158,167,177,187,196,205,214,223,233,242,251,
	246,237,228,219,210,202,194,185,176,183,192,199,207,214,222,230,
	237,245,253,245,237,230,222,215,207,199,192,183,176,168,160,153,
	144,137,129,122,114,106,99,90,83,75,68,59,52,44,36,36,
	37,38,38,38,39,38,39,38,37,44,52,60,68,75,83,90,
	99,107,114,122,129,137,145,153,160,168,176,184,191,199,207,214,
	222,230,237,245,253,245,237,230,223,214,206,199,191,184,176,168,
	176,184,193,202,210,219,228,237,246,251,242,233,223,214,205,195,
	186,176,167,158,148,138,129,119,109,99,90,79,70,60,59,65,
	72,79,86,93,99,106,113,120,126,133,140,146,154,161,167,174,
	181,187,194,201,208,214,221,214,215,226,237,247,248,237,227,216,
	206,194,185,173,163,152,142,131,120,109,98,87,76,66,59,52,
	47,37,27,29,37,44,52,60,68,75,83,90,99,106,114,122,
	129,137,145,152,160,170,181,190,202,212,223,233,244,251,241,246,
	253,245,237,230,222,214,207,199,191,183,175,168,160,152,144,137,
	130,122,114,106,98,91,83,75,67,60,52,54,64,74,84,94,
	103,112,123,133,141,151,161,170,179,189,198,208,217,226,235,244,
	253,244,235,227,218,209,201,193,185,184,191,199,206,214,222,230,
	238,246,253,246,238,230,222,215,206,199,191,184,176,168,160,153,
	145,137,129,122,114,106,98,91,83,76,68,60,53,45,37,29,
	25,26,27,27,27,27,27,29,36,45,52,60,67,75,83,91,
	98,106,114,122,130,137,145,152,161,168,175,183,191,199,207,214,
	222,230,238,245,253,245,237,230,222,214,207,199,191,184,176,176,
	184,193,201,210,218,227,235,244,253,244,235,226,217,208,199,189,
	179,170,161,151,142,132,123,112,103,94,83,74,63,54,59,65,
	73,79,86,93,99,106,113,120,127,133,140,146,153,160,167,174,
	180,187,194,201,207,214,221,215,220,230,241,252,245,234,223,213,
	201,191,180,169,159,148,138,127,116,105,95,83,73,66,58,52,
	50,40,31,29,36,44,53,59,68,75,83,91,99,106,114,121,
	130,137,145,152,161,168,176,186,198,208,218,229,240,251,245,245,
	253,246,237,230,223,214,207,199,191,184,175,168,161,152,145,137,
	130,122,114,106,99,91,83,76,68,60,52,48,58,68,77,87,
	97,106,116,126,136,145,155,164,173,183,192,201,210,219,228,237,
	245,252,243,235,226,217,209,200,192,184,191,199,206,215,222,230,
	237,245,253,245,237,230,223,214,207,199,191,183,176,168,161,152,
	145,137,130,122,114,106,98,91,83,76,68,60,52,44,36,29,
	21,15,15,16,15,16,21,29,37,45,53,60,68,75,83,91,
	98,107,114,121,129,138,145,153,161,168,176,183,191,199,207,214,
	222,230,238,245,253,245,238,230,222,215,207,199,191,184,176,185,
	193,200,209,217,226,234,243,251,246,237,228,219,210,200,192,183,
	173,164,154,144,135,125,116,107,97,87,78,68,58,52,59,66,
	72,79,86,92,100,106,113,120,126,134,140,147,154,160,167,174,
	181,188,194,201,208,214,221,215,224,235,245,250,240,229,218,208,
	198,186,176,165,155,144,134,122,112,101,90,79,72,66,59,52,
	53,43,34,29,36,45,52,59,68,75,83,90,99,106,114,122,
	129,137,144,153,160,168,176,183,193,203,214,225,236,246,249,246,
	253,246,238,229,222,215,207,199,191,184,176,168,160,152,145,137,
	130,121,114,107,98,90,83,76,68,60,52,44,52,62,71,81,
	91,101,110,120,129,139,147,158,166,175,185,193,202,212,220,230,
	238,247,250,242,233,225,216,209,201,192,191,199,207,214,222,230,
	237,245,253,245,238,230,222,214,207,199,191,184,175,168,160,152,
	145,137,129,122,114,106,98,91,83,75,68,60,52,45,37,29,
	21,13,5,4,6,13,22,29,36,45,52,60,67,76,83,91,
	98,106,114,121,129,138,145,152,160,168,175,183,191,198,207,214,
	222,229,238,246,253,245,238,230,222,215,206,199,191,183,184,193,
	200,209,217,225,233,242,250,247,238,229,221,212,203,194,185,176,
	166,157,147,138,129,120,110,101,91,81,72,62,52,52,59,65,
	72,79,86,92,99,106,113,119,126,134,140,146,153,160,167,174,
	181,187,194,201,207,214,222,218,229,239,249,246,235,225,214,204,
	193,183,171,161,151,140,129,119,108,98,87,79,72,65,59,52,
	56,47,37,29,37,44,52,60,68,75,83,90,99,107,114,121,
	129,137,145,153,160,168,176,183,191,200,210,220,231,242,252,245,
	253,245,237,230,222,214,206,199,192,184,176,168,160,152,145,137,
	129,122,114,106,99,90,83,75,67,59,52,45,46,55,66,75,
	84,94,103,113,123,132,141,151,159,169,178,186,196,205,213,222,
	230,239,248,249,241,233,224,216,209,200,192,199,206,214,222,229,
	238,245,253,245,238,230,222,215,207,198,191,183,176,168,160,153,
	145,137,129,121,114,106,99,90,83,76,68,60,52,44,37,29,
	21,13,6,4,6,14,21,29,37,45,52,60,68,76,83,91,
	99,107,114,121,129,137,144,152,161,168,175,183,191,199,206,215,
	222,230,238,246,253,245,237,229,222,214,206,199,191,184,193,200,
	208,217,224,233,241,249,248,239,231,222,214,205,195,187,178,169,
	159,150,141,132,123,113,103,94,85,75,65,55,46,52,59,66,
	73,79,86,93,100,106,112,120,127,133,140,147,154,160,167,174,
	180,188,194,200,207,214,221,223,233,244,251,241,231,220,210,200,
	189,178,167,157,146,135,125,114,104,93,86,79,73,66,59,52,
	60,50,40,31,37,44,52,59,68,75,83,90,98,106,114,121,
	130,137,145,152,160,168,176,183,191,198,207,215,226,236,247,249,
	253,245,237,230,222,215,207,199,191,184,175,168,160,153,145,138,
	129,121,114,107,99,91,83,75,67,59,52,44,40,50,59,69,
	78,87,97,106,116,125,134,143,152,161,170,180,188,197,206,215,
	223,232,241,249,249,241,233,225,216,209,201,199,206,214,222,229,
	238,245,253,245,238,230,222,214,207,199,191,183,176,168,160,153,
	145,137,130,122,114,106,98,90,83,75,67,60,52,45,37,29,
	21,16,15,14,14,15,21,29,37,44,52,60,67,75,83,91,
	99,107,114,122,130,138,145,153,160,168,176,183,191,199,206,215,
	222,230,238,245,253,246,238,230,222,214,206,199,191,193,201,209,
	216,224,232,241,249,249,241,232,223,214,206,197,189,179,170,162,
	152,144,135,125,116,106,97,88,78,69,59,50,46,52,59,65,
	73,79,85,93,99,106,113,120,126,134,140,146,153,160,167,174,
	180,187,194,200,208,214,221,228,238,249,248,237,226,216,205,195,
	185,174,163,152,142,131,121,110,100,93,86,79,72,66,58,52,
	63,53,44,35,37,45,52,60,68,75,83,91,98,107,113,122,
	130,137,144,152,160,168,175,183,191,199,207,214,222,232,243,253,
	253,245,237,230,222,214,207,199,191,183,176,168,161,153,145,137,
	129,122,114,106,99,91,83,75,67,60,53,44,37,43,52,62,
	72,81,90,100,109,119,128,136,145,155,164,173,181,190,198,207,
	216,224,232,241,249,248,241,233,225,217,210,202,207,214,222,230,
	238,246,253,245,238,229,222,214,207,199,192,184,176,168,160,152,
	145,137,129,121,114,106,99,91,83,76,68,60,52,44,36,29,
	28,28,27,26,26,26,26,29,36,44,53,60,68,75,83,90,
	98,106,114,121,129,137,145,152,160,168,175,183,191,199,207,214,
	222,230,238,245,253,245,237,230,223,214,207,199,195,202,210,217,
	225,233,241,248,249,240,232,224,216,207,198,189,181,172,163,155,
	145,137,128,118,109,100,91,81,72,62,53,43,45,52,59,66,
	72,79,86,93,99,106,113,120,126,134,140,147,154,161,167,173,
	181,188,194,201,207,215,222,232,243,253,242,232,222,211,200,190,
	179,169,159,148,137,127,116,107,100,93,86,79,73,66,59,52,
	66,57,47,38,37,44,52,60,67,76,83,90,99,107,114,122,
	130,137,145,153,161,168,176,184,191,199,207,214,222,230,238,248,
	253,246,238,230,222,214,206,199,191,184,176,168,161,152,145,137,
	129,121,114,106,99,91,83,76,67,60,52,44,37,37,47,56,
	65,75,83,93,102,111,120,129,139,148,156,165,173,183,191,200,
	208,217,225,233,241,249,249,241,234,226,218,210,206,214,222,230,
	238,245,253,245,238,229,222,214,207,199,191,183,176,168,160,152,
	145,138,130,121,114,107,98,90,83,75,68,60,52,44,42,41,
	39,39,38,38,37,38,38,39,40,45,52,60,67,75,83,90,
	99,106,114,122,129,137,145,152,161,168,175,183,191,199,206,214,
	222,230,238,245,253,246,238,230,223,214,206,199,203,211,218,226,
	233,241,249,249,241,233,225,217,207,200,191,182,174,165,156,147,
	139,129,121,112,102,93,84,75,65,56,46,39,45,52,59,65,
	73,80,85,93,100,106,113,120,126,133,140,147,153,160,167,174,
	180,187,194,201,207,217,227,238,248,248,238,227,217,206,197,185,
	176,164,154,143,133,123,113,106,99,93,86,80,73,66,59,52,
	70,60,51,41,37,44,52,60,67,75,83,90,99,106,114,122,
	129,137,145,153,160,168,176,184,191,199,206,215,222,230,237,245,
	253,246,237,230,222,215,207,199,191,184,175,168,160,153,145,137,
	129,121,114,107,98,91,83,75,67,60,52,44,37,30,40,49,
	58,68,77,86,95,105,113,122,132,140,149,158,166,174,183,192,
	200,209,217,225,233,241,248,250,242,234,227,220,212,215,222,229,
	238,246,253,245,238,230,222,215,206,199,191,183,176,168,160,153,
	145,137,129,122,114,106,98,91,83,75,67,60,56,55,53,52,
	50,50,50,49,49,49,49,50,51,52,53,60,67,75,83,91,
	98,106,114,122,129,137,145,152,160,168,176,183,191,199,207,214,
	223,230,238,245,253,245,238,230,223,215,206,205,212,220,227,234,
	242,249,248,240,233,224,216,208,200,191,183,175,166,158,149,140,
	131,122,114,104,95,86,77,68,59,49,40,39,46,53,59,65,
	72,79,85,93,100,106,113,119,127,133,140,147,154,160,167,174,
	180,188,194,202,212,222,232,243,252,243,232,222,212,201,191,180,
	170,160,150,139,129,120,113,106,99,93,86,79,72,65,59,52,
	73,63,55,45,36,45,52,60,68,75,83,91,99,107,114,121,
	130,137,144,152,160,168,176,183,191,199,206,214,223,230,238,246,
	253,248,238,230,222,215,207,199,191,183,176,168,161,153,145,137,
	129,121,114,106,99,91,83,76,67,59,52,44,36,29,33,43,
	52,61,70,79,88,98,106,115,124,132,142,150,158,167,175,184,
	192,200,209,216,224,232,240,248,250,243,236,228,221,214,223,230,
	238,245,253,246,238,230,222,214,207,199,192,184,176,168,160,153,
	145,137,130,122,114,106,99,91,83,75,72,70,68,66,65,63,
	62,61,61,60,61,60,61,61,62,64,65,66,68,75,83,91,
	98,106,114,122,129,138,145,152,160,168,176,183,192,199,206,214,
	222,230,237,246,253,245,238,230,222,214,207,214,221,228,236,243,
	251,248,240,233,224,217,209,200,193,184,175,167,159,150,142,133,
	124,115,106,97,88,80,70,61,52,43,33,38,45,52,59,65,
	72,79,86,92,99,106,113,120,126,133,140,147,154,161,167,174,
	180,187,197,207,217,227,237,248,248,238,227,217,207,197,187,176,
	165,156,145,134,127,120,113,106,100,92,86,79,72,66,58,52,
	76,68,58,48,39,45,52,60,68,75,83,90,98,106,114,122,
	129,138,145,152,160,168,176,183,192,199,207,214,222,230,237,245,
	253,252,243,233,222,214,206,199,191,184,176,168,161,152,145,137,
	129,122,114,106,99,91,83,75,67,60,52,45,37,29,26,36,
	45,54,63,73,81,90,99,108,117,125,134,143,151,160,168,176,
	184,193,200,209,216,224,231,240,247,252,244,237,230,222,222,230,
	238,245,253,245,238,230,223,215,206,199,191,184,176,168,161,152,
	145,137,130,122,113,106,99,90,87,85,83,81,79,77,75,74,
	73,72,72,72,72,72,73,72,74,75,76,77,78,80,83,91,
	98,107,114,122,130,137,145,152,160,168,176,183,192,199,207,215,
	222,230,238,246,253,246,238,230,223,215,216,223,230,237,244,252,
	247,240,232,224,216,209,200,193,184,176,168,160,151,142,134,125,
	117,108,99,90,81,72,63,54,45,36,32,38,45,52,58,66,
	72,79,86,93,99,106,113,120,127,133,140,147,153,160,167,174,
	182,192,203,212,222,233,243,253,243,233,223,213,202,192,182,171,
	161,151,140,133,126,120,113,106,99,92,86,79,72,66,59,52,
	80,71,61,52,43,44,52,60,68,76,83,90,98,106,114,122,
	130,137,145,153,160,168,175,183,191,199,206,214,222,230,237,246,
	253,248,248,238,228,218,208,199,191,184,176,168,161,152,145,137,
	130,121,113,106,98,90,83,75,67,59,52,45,37,29,21,29,
	38,47,56,65,74,83,91,100,109,118,126,134,143,152,160,168,
	176,184,192,200,208,216,223,231,239,246,253,246,239,233,225,230,
	238,245,253,245,238,229,222,214,207,199,191,183,176,168,160,152,
	145,137,130,122,114,108,104,101,99,97,94,93,90,89,87,86,
	85,84,84,83,83,83,84,85,85,86,87,88,91,92,94,96,
	99,106,114,121,129,137,145,152,160,168,176,183,191,198,207,214,
	222,230,237,245,253,245,237,230,222,219,226,232,239,246,253,246,
	238,231,223,215,208,200,192,185,176,168,160,151,144,135,126,117,
	109,101,92,82,74,65,56,47,38,29,32,39,45,52,59,65,
	72,79,86,92,99,106,113,119,126,133,140,146,154,160,168,178,
	188,198,208,218,228,238,248,248,238,227,218,207,197,187,177,166,
	156,147,140,134,127,119,113,107,100,93,86,79,72,65,59,53,
	84,75,65,56,47,44,52,60,67,75,83,91,98,106,114,121,
	129,138,145,153,160,168,176,184,191,199,206,214,222,230,237,246,
	253,245,252,244,233,223,213,203,194,184,176,168,161,153,144,137,
	130,122,114,106,98,91,83,75,67,59,52,44,36,28,22,22,
	31,40,49,58,66,75,84,93,102,111,118,127,135,143,151,160,
	168,176,183,192,199,207,215,222,230,236,243,251,249,241,235,230,
	238,245,253,245,237,230,222,214,207,199,191,184,175,168,161,153,
	145,137,130,125,122,119,116,113,110,108,106,103,101,99,99,97,
	97,96,95,95,94,95,95,95,96,97,99,100,102,104,105,108,
	110,112,116,122,130,137,145,152,160,168,176,183,191,198,206,215,
	222,230,238,246,253,246,238,230,223,227,234,241,248,250,244,237,
	229,222,215,207,199,192,184,176,168,160,152,144,135,127,119,110,
	101,93,84,76,66,58,49,40,31,25,32,38,45,53,58,66,
	72,79,86,93,99,106,113,120,126,133,140,147,154,164,174,183,
	194,203,214,224,233,243,253,242,232,223,213,202,192,181,171,162,
	154,147,140,133,126,120,113,106,99,92,86,79,72,66,58,52,
	88,79,69,60,50,45,52,60,68,75,83,90,98,107,114,121,
	129,137,145,153,160,168,176,183,191,199,207,214,222,230,237,245,
	253,245,248,249,238,229,218,209,200,190,179,169,160,152,145,137,
	129,122,114,107,98,90,83,75,67,59,52,45,37,29,22,15,
	24,33,42,51,59,68,77,85,94,103,111,119,127,136,143,152,
	160,167,175,184,191,198,206,213,221,228,235,242,249,251,244,238,
	237,245,253,245,238,230,222,214,206,198,191,184,175,168,161,153,
	147,143,140,136,132,129,127,124,121,119,117,114,113,112,110,109,
	107,107,106,106,106,106,106,107,108,109,110,111,113,115,117,119,
	122,123,126,130,133,137,145,152,160,168,176,183,192,199,206,214,
	222,230,237,245,253,246,238,230,231,237,244,251,249,242,235,227,
	220,214,206,199,190,184,176,168,160,152,143,136,128,119,111,102,
	94,85,77,68,59,51,42,33,24,25,32,38,45,52,59,65,
	72,79,86,93,100,107,113,120,126,133,141,151,160,170,180,189,
	199,209,219,229,239,248,247,237,227,217,207,196,187,177,167,160,
	154,147,140,133,126,120,113,106,99,93,85,80,73,65,58,53,
	91,82,73,64,55,46,52,60,67,76,83,91,98,106,114,122,
	129,138,145,153,160,168,176,184,191,199,207,215,222,230,237,245,
	253,245,242,251,244,235,224,215,205,195,185,176,166,156,147,137,
	129,122,114,106,99,91,82,76,67,60,52,45,36,29,21,13,
	17,26,35,44,52,61,70,78,87,95,103,111,119,127,136,144,
	152,160,167,174,182,190,197,204,212,219,226,233,240,246,253,247,
	241,245,253,245,238,230,222,215,207,199,191,183,176,170,166,162,
	158,154,151,147,144,141,137,135,132,130,128,126,124,122,121,120,
	119,119,118,118,118,117,118,118,119,120,121,122,124,126,128,130,
	132,135,138,141,144,147,150,154,160,168,175,183,191,199,207,214,
	222,230,237,245,253,245,237,235,241,247,253,246,239,233,226,218,
	212,204,197,190,182,175,167,160,151,143,136,127,120,111,103,95,
	86,77,70,61,52,43,35,26,19,25,32,39,45,52,59,65,
	72,79,86,92,100,106,113,120,127,137,147,157,166,176,185,195,
	204,215,225,235,245,252,242,232,221,212,201,192,181,173,167,161,
	154,147,140,133,127,119,113,106,99,93,86,79,73,66,59,52,
	95,86,77,68,59,49,52,59,67,75,83,91,99,106,114,122,
	129,137,145,153,160,168,176,184,191,199,207,215,222,230,238,245,
	253,245,237,246,251,241,231,221,211,201,192,182,172,162,153,143,
	134,124,114,107,98,91,83,75,67,60,52,45,37,29,21,13,
	10,18,27,36,44,53,62,70,78,87,95,103,111,119,127,136,
	143,151,158,166,174,182,189,195,202,210,217,224,230,236,243,249,
	250,245,253,245,237,230,223,215,206,199,195,190,185,181,177,173,
	168,165,161,158,155,151,149,146,144,141,139,137,136,134,132,132,
	131,130,130,129,129,129,129,130,131,132,133,134,136,137,139,141,
	144,146,148,152,154,158,162,165,168,172,177,184,191,199,207,215,
	222,230,237,245,253,245,238,244,250,250,243,237,230,223,217,210,
	203,196,189,181,174,166,159,151,144,135,128,120,112,103,95,87,
	78,70,61,53,44,36,27,19,18,26,32,38,45,52,58,66,
	73,79,86,92,99,106,115,124,134,143,153,163,172,182,192,201,
	211,221,231,240,250,246,235,226,216,206,196,187,181,174,167,160,
	153,147,140,133,127,119,113,106,100,93,86,79,73,66,59,52,
	99,91,81,72,62,53,52,60,68,76,83,90,98,106,114,122,
	130,137,145,153,161,168,176,183,191,199,207,214,222,230,238,245,
	253,245,237,240,250,247,237,227,217,207,198,188,178,169,159,149,
	140,130,122,112,103,93,84,76,67,60,52,45,37,29,21,13,
	5,11,20,29,37,45,54,62,70,79,87,95,104,111,119,127,
	135,143,150,157,165,172,180,186,194,200,208,214,221,228,234,240,
	247,252,253,245,238,231,226,220,215,210,205,200,196,192,188,183,
	180,175,172,169,166,163,160,158,155,153,150,149,147,146,145,143,
	142,141,141,141,141,140,141,142,143,143,144,145,147,149,150,153,
	155,158,160,162,166,169,172,176,180,183,187,191,196,200,206,214,
	222,230,238,245,253,246,247,252,246,240,234,227,221,215,207,201,
	194,187,179,172,165,157,150,142,134,127,119,111,103,95,87,79,
	71,62,54,46,37,29,19,12,18,25,32,38,46,52,59,66,
	72,79,86,93,103,112,121,130,140,149,159,169,178,188,198,207,
	217,226,236,246,250,240,230,220,211,201,194,188,181,174,167,160,
	153,147,140,133,127,120,113,106,99,92,86,80,72,65,59,52,
	104,94,85,76,66,58,52,60,67,75,83,91,98,106,114,122,
	130,138,144,152,161,168,176,184,191,199,207,214,222,229,238,245,
	253,245,238,234,244,252,243,232,223,214,204,194,185,175,165,156,
	147,137,128,118,109,100,90,82,72,64,55,45,37,29,22,13,
	6,3,13,20,29,38,46,55,62,71,79,87,96,103,110,118,
	126,134,141,149,156,164,170,178,184,192,199,205,212,217,224,231,
	237,245,253,252,246,241,236,230,226,220,216,211,206,202,198,194,
	190,186,184,180,176,173,171,168,166,164,162,159,158,157,156,154,
	153,153,152,152,152,152,153,153,154,154,155,156,158,160,162,164,
	166,169,171,174,176,180,183,187,190,194,198,202,206,211,216,220,
	225,230,238,245,253,252,249,242,236,231,224,218,211,204,198,192,
	184,178,171,164,156,149,142,134,127,118,111,103,95,88,79,71,
	63,55,46,38,29,21,13,11,18,25,32,38,45,52,59,65,
	73,81,91,100,109,118,127,137,146,156,165,175,184,194,203,214,
	223,232,243,253,244,234,224,215,208,201,195,187,181,174,167,160,
	154,147,140,133,126,120,113,106,100,92,86,79,73,65,59,52,
	108,98,89,80,71,62,53,59,68,75,83,91,99,106,114,122,
	129,137,145,153,161,168,176,183,191,199,206,215,222,230,238,246,
	253,245,238,230,238,248,248,239,229,220,210,201,191,181,172,162,
	153,144,134,125,116,107,97,88,80,70,62,53,43,35,26,18,
	8,1,6,14,22,30,38,47,55,63,71,79,87,94,102,110,
	117,126,133,140,147,155,162,169,175,184,191,199,206,214,222,230,
	237,246,253,245,250,251,246,240,236,231,226,221,217,213,209,205,
	201,198,194,191,188,185,182,180,177,175,173,172,169,168,167,165,
	165,165,164,164,163,164,164,165,165,166,167,168,170,171,173,175,
	177,179,182,185,188,191,194,198,201,205,208,213,217,221,226,231,
	235,240,246,251,253,245,239,233,227,221,215,209,202,196,189,182,
	176,169,162,154,148,140,133,125,118,110,102,95,87,79,71,62,
	55,47,38,30,22,13,5,11,19,25,32,39,45,53,62,70,
	79,88,98,107,115,125,134,143,153,162,171,182,191,200,210,219,
	229,238,248,247,238,229,222,214,208,200,194,187,180,174,167,160,
	154,147,140,133,126,120,113,106,99,93,86,79,73,65,59,52,
	111,103,93,85,76,66,57,60,68,76,83,91,98,106,114,122,
	129,137,145,153,160,168,176,183,191,199,206,214,222,230,238,245,
	253,245,238,230,233,242,252,245,236,225,216,207,197,188,179,169,
	160,150,141,132,122,114,105,95,86,78,68,59,51,43,33,25,
	16,7,6,13,21,29,37,44,52,60,67,75,83,90,99,106,
	114,121,130,137,145,153,160,168,175,183,191,199,206,214,222,230,
	237,245,253,245,240,245,251,251,246,241,236,232,228,223,219,216,
	212,209,205,202,199,196,193,191,188,186,185,182,181,180,178,177,
	177,175,175,175,175,175,175,176,177,177,179,179,181,182,184,186,
	188,191,194,196,199,202,205,208,212,216,219,223,228,232,237,241,
	245,251,250,245,253,245,238,230,222,215,207,199,193,186,180,173,
	166,159,153,146,139,131,124,116,110,102,94,86,79,71,63,55,
	47,38,30,22,13,5,5,12,19,25,33,42,50,60,68,77,
	87,95,105,113,123,132,141,150,160,169,178,188,197,207,216,226,
	235,245,251,242,232,222,221,214,207,201,194,187,181,174,167,160,
	154,147,140,133,126,120,113,106,99,93,86,79,72,66,59,52,
	115,106,97,89,80,71,61,60,68,75,83,91,98,106,114,122,
	130,137,145,153,160,168,175,184,191,199,207,215,222,230,238,245,
	253,246,237,230,226,235,246,251,241,232,223,213,204,194,185,175,
	167,157,148,139,129,121,111,103,94,85,76,66,59,49,41,32,
	24,15,7,13,21,29,37,45,52,60,67,76,83,91,99,106,
	114,121,130,137,145,153,160,168,176,184,192,199,206,215,223,230,
	238,246,253,245,238,235,240,245,250,252,247,243,238,234,230,227,
	223,219,216,213,210,207,205,202,200,197,195,193,192,191,189,189,
	188,187,186,186,186,186,187,187,188,189,190,191,193,193,196,197,
	199,202,205,207,210,213,216,219,223,227,230,234,239,243,247,251,
	250,245,240,245,253,245,238,230,222,214,206,199,191,183,176,168,
	161,152,145,137,130,122,116,108,100,93,86,77,70,62,55,46,
	38,30,22,14,6,0,7,15,24,32,41,50,58,67,76,85,
	94,103,112,120,129,139,148,157,166,175,185,195,204,213,223,232,
	242,251,246,235,226,217,222,215,207,201,194,187,181,174,167,160,
	154,146,140,133,127,120,113,107,99,93,86,79,72,65,59,52,
	120,111,102,92,84,75,66,60,68,75,83,91,98,106,114,122,
	129,137,145,153,160,168,175,183,191,198,206,214,222,230,237,245,
	253,245,238,230,222,229,239,249,248,238,229,220,210,201,192,182,
	173,164,155,146,136,128,118,110,101,92,83,75,66,57,49,40,
	31,23,15,13,21,29,37,45,52,60,68,75,83,91,99,106,
	114,121,129,137,145,152,160,168,175,183,192,199,207,214,222,230,
	237,245,253,246,237,229,230,234,240,244,249,252,249,245,241,237,
	233,231,227,224,221,218,216,213,211,209,207,206,204,202,201,200,
	200,198,198,198,197,197,198,199,200,200,201,202,203,206,207,209,
	211,213,216,218,221,223,227,230,234,237,241,245,249,252,248,244,
	239,234,238,245,253,246,237,230,222,215,206,199,192,183,175,168,
	160,153,145,137,129,122,114,106,98,90,83,76,68,59,52,45,
	36,29,21,13,5,6,15,23,32,39,48,57,65,74,83,92,
	101,109,118,128,136,145,155,164,173,182,192,201,210,220,229,239,
	248,248,239,229,220,214,221,215,207,201,194,187,180,174,167,160,
	153,147,140,133,126,120,113,106,99,93,85,79,72,66,59,52,
	124,115,106,97,88,79,70,61,67,75,83,90,98,106,114,121,
	130,137,145,152,161,168,175,184,191,199,206,214,222,230,237,245,
	253,245,237,230,222,223,233,242,251,245,236,226,217,207,199,189,
	180,170,161,153,144,134,126,116,108,99,91,82,73,65,56,47,
	39,30,23,14,21,28,36,44,53,60,68,75,83,91,98,106,
	114,122,129,137,144,152,161,168,176,184,191,199,207,215,222,230,
	238,245,253,246,237,229,222,224,229,233,237,242,247,251,252,248,
	244,241,238,235,232,229,226,225,222,220,218,216,215,213,212,212,
	211,210,210,209,210,209,209,210,210,212,212,214,215,217,218,220,
	222,224,227,230,232,235,238,241,244,248,252,250,246,243,237,233,
	228,229,238,245,253,245,238,230,222,215,207,199,191,183,176,168,
	160,153,145,137,130,122,114,106,99,91,83,75,67,60,52,44,
	37,29,21,13,6,15,22,31,39,48,56,65,73,82,90,100,
	108,117,126,135,143,153,162,170,180,189,198,208,217,226,236,245,
	252,242,233,223,214,215,221,214,207,200,194,187,180,174,167,160,
	153,147,140,133,126,119,113,106,99,93,86,79,72,65,58,52,
	128,120,111,102,93,84,75,66,67,75,83,91,98,107,114,121,
	129,137,145,153,161,168,176,184,191,199,206,214,222,230,237,246,
	253,245,237,229,223,216,226,236,245,251,242,232,223,215,205,196,
	186,178,169,159,151,142,133,124,115,106,98,90,81,72,64,56,
	47,39,30,22,21,29,36,44,52,60,67,75,83,90,99,106,
	114,122,130,137,145,153,160,168,176,183,191,199,207,215,223,230,
	238,245,253,245,238,230,222,214,219,223,227,231,235,239,243,247,
	250,252,249,246,243,240,238,236,233,232,229,228,226,225,224,223,
	222,222,221,221,221,221,221,222,222,222,224,225,226,228,229,231,
	234,236,238,240,243,246,249,252,250,247,244,240,236,232,227,223,
	222,230,238,245,253,245,238,230,222,215,207,199,191,183,176,168,
	160,153,145,137,130,122,113,106,98,90,83,76,68,60,52,45,
	37,29,21,14,14,22,30,39,47,55,64,73,81,90,98,106,
	116,124,133,141,151,160,168,178,187,196,205,214,224,233,242,251,
	245,235,226,217,207,215,221,214,207,201,194,187,181,174,167,161,
	153,147,140,133,126,119,113,106,99,93,86,79,72,65,59,52,
	133,124,115,106,97,88,79,70,68,75,83,90,98,106,114,122,
	129,138,145,153,160,168,176,184,191,199,207,214,222,230,238,245,
	253,245,237,230,222,214,220,229,239,248,249,240,231,221,212,203,
	194,185,176,167,158,149,140,131,123,114,106,97,88,80,71,63,
	55,46,39,30,22,29,36,44,52,60,67,75,83,91,99,106,
	114,122,129,137,145,152,160,168,176,183,191,199,207,215,222,229,
	238,245,253,245,238,230,222,214,208,213,217,220,225,228,232,236,
	240,243,246,249,252,252,249,246,244,242,240,239,238,236,236,234,
	234,233,233,232,232,232,232,233,234,234,235,236,238,239,240,242,
	244,247,249,252,252,249,246,243,240,236,232,229,225,220,217,215,
	222,230,237,245,253,245,238,229,222,215,206,198,191,183,176,168,
	161,153,145,137,130,122,114,106,99,90,83,75,67,59,52,44,
	36,29,22,15,22,31,39,46,55,63,72,80,88,97,106,114,
	123,131,140,149,158,167,176,185,194,203,212,221,230,240,248,248,
	239,229,220,210,208,214,221,214,208,201,194,187,180,174,167,160,
	154,146,140,133,126,120,113,107,100,92,86,80,73,66,59,52,
	138,128,119,111,102,92,84,75,67,75,83,91,98,106,114,122,
	130,137,145,153,161,168,175,184,191,199,206,214,223,229,238,245,
	253,246,237,229,222,214,213,222,232,241,251,246,237,228,219,209,
	201,191,183,174,165,157,147,139,131,122,113,105,96,87,80,71,
	62,55,46,39,30,29,36,45,52,60,67,75,83,91,99,106,
	114,121,129,137,144,152,160,168,176,184,191,199,207,214,222,230,
	237,246,253,246,237,230,222,215,207,202,206,210,214,218,221,225,
	228,232,235,238,240,243,246,248,250,252,252,250,249,247,247,245,
	245,244,244,244,244,244,243,244,245,245,246,247,249,250,252,252,
	250,248,246,243,241,238,235,232,229,225,222,218,214,211,206,214,
	222,229,237,246,253,245,237,230,222,214,207,198,191,183,176,168,
	160,153,144,137,129,122,114,106,99,91,83,75,67,60,52,44,
	36,29,22,22,30,38,47,55,63,71,79,87,96,104,113,121,
	130,138,148,157,166,174,183,192,201,210,219,228,237,246,251,241,
	232,223,213,204,208,215,221,215,207,201,194,187,181,174,167,161,
	153,146,140,133,126,119,113,106,100,92,86,79,72,66,59,57,
	142,133,124,115,106,98,88,80,71,76,83,90,99,106,114,122,
	129,138,145,153,160,168,176,184,192,198,207,214,222,230,238,246,
	253,245,237,229,222,215,207,216,225,234,243,253,245,235,225,217,
	208,199,190,181,172,164,155,146,138,129,121,112,104,95,87,79,
	71,63,55,47,39,31,37,45,52,60,67,75,83,91,98,106,
	114,122,129,137,145,153,161,168,176,183,191,199,207,214,222,230,
	238,245,253,245,237,229,222,214,207,199,195,200,203,208,211,214,
	217,221,224,227,230,232,235,237,238,240,243,244,246,247,248,248,
	249,250,251,251,251,251,250,251,250,249,248,247,246,244,242,241,
	239,237,235,232,230,227,224,221,218,215,211,207,204,199,206,215,
	222,230,237,245,253,246,237,230,222,214,207,199,191,183,176,168,
	160,152,145,137,130,122,114,106,99,91,83,75,67,60,52,44,
	37,29,22,31,39,46,54,63,71,79,87,96,103,112,121,129,
	138,146,155,164,173,182,191,199,208,217,226,235,244,253,243,234,
	225,216,207,201,207,215,221,215,207,201,195,187,181,174,167,161,
	154,147,140,133,126,120,113,106,99,93,86,79,73,66,59,63,
	146,138,129,120,111,102,94,84,75,75,83,91,98,106,114,122,
	129,137,145,152,160,168,176,184,192,199,206,214,222,229,238,245,
	253,246,238,230,222,215,207,210,218,228,236,246,251,242,233,224,
	215,207,197,189,180,171,163,154,145,137,128,120,112,103,96,86,
	79,70,63,55,47,39,36,44,52,60,68,76,83,91,98,106,
	114,121,129,137,145,152,161,168,175,184,191,198,207,214,222,230,
	238,245,253,246,238,230,222,215,206,199,192,189,192,196,200,203,
	207,209,213,216,218,220,223,226,227,229,231,232,234,236,237,238,
	238,239,239,239,240,240,239,239,238,238,236,236,234,233,231,229,
	228,226,224,220,219,215,213,209,207,203,200,196,192,199,206,215,
	222,230,238,245,253,246,238,230,222,215,207,199,191,184,176,168,
	160,152,145,137,129,122,114,107,98,91,83,75,68,60,52,44,
	37,29,31,40,47,55,62,71,79,87,95,103,112,120,128,137,
	146,154,163,171,180,189,197,206,215,224,233,242,251,246,237,227,
	219,209,200,201,207,214,221,214,207,201,194,187,181,174,167,160,
	154,147,140,133,126,119,113,106,100,93,85,79,72,66,59,67,
	151,142,133,125,115,107,98,89,80,76,83,91,99,106,114,122,
	129,137,145,152,161,168,176,183,191,198,206,215,222,229,238,245,
	253,245,237,230,222,214,206,202,211,221,230,239,248,250,240,231,
	223,214,204,196,187,179,170,162,153,145,136,128,120,111,103,95,
	87,79,71,64,55,47,40,45,52,59,68,75,83,91,98,106,
	114,122,129,137,144,152,161,168,175,184,191,199,207,215,222,229,
	238,245,253,245,238,230,222,214,207,199,192,184,182,186,189,193,
	195,199,201,204,208,209,212,214,217,218,220,222,223,224,225,226,
	227,227,228,228,229,228,228,227,227,226,225,224,223,222,220,218,
	216,214,212,210,207,204,202,198,196,192,189,185,191,199,206,215,
	223,229,238,246,253,245,238,230,223,215,206,199,191,184,176,168,
	160,153,145,137,130,122,114,106,98,91,83,76,67,60,52,44,
	37,33,40,48,55,63,71,79,87,95,104,112,119,128,136,145,
	153,162,170,179,187,196,205,213,222,231,240,249,248,239,230,221,
	211,202,194,201,208,214,221,214,208,201,195,188,180,174,167,160,
	154,147,140,133,127,119,112,107,99,93,86,79,73,66,63,72,
	156,146,138,129,120,112,103,94,86,77,83,91,99,107,114,122,
	130,138,144,153,160,168,176,184,191,199,207,215,223,230,238,245,
	253,245,238,230,222,214,207,199,204,214,222,231,241,250,247,239,
	230,221,212,203,195,186,178,170,161,153,144,136,127,119,111,103,
	95,88,80,72,64,56,48,45,52,60,68,76,83,90,98,106,
	114,122,129,137,144,153,161,168,176,183,191,199,207,214,222,230,
	238,245,253,246,238,230,222,215,207,199,191,183,176,174,178,182,
	184,188,191,193,196,199,201,203,205,207,209,210,211,212,213,215,
	216,216,217,216,216,216,216,216,215,215,213,213,211,210,208,207,
	205,203,201,198,196,193,191,188,185,182,178,184,191,199,207,214,
	222,229,238,245,253,245,238,230,222,215,207,199,191,183,176,168,
	161,152,145,137,130,121,114,106,99,90,83,75,68,60,52,45,
	36,41,48,56,64,71,79,87,95,103,111,120,127,136,144,153,
	161,169,178,187,195,203,212,221,230,238,247,250,241,232,223,214,
	205,195,195,201,208,214,221,215,208,201,194,187,180,174,167,160,
	154,147,140,133,127,120,113,106,99,93,86,79,73,65,68,77,
	160,151,143,134,126,116,108,99,91,82,83,91,99,106,114,122,
	130,137,145,153,160,168,176,184,191,199,206,214,222,230,238,245,
	253,246,238,230,222,215,206,199,198,207,215,224,234,242,251,246,
	237,228,219,211,202,194,185,176,168,160,152,143,135,128,119,111,
	104,96,88,80,73,64,57,49,52,60,67,75,83,91,98,107,
	114,121,129,137,145,152,160,168,176,184,191,198,207,215,222,229,
	238,246,253,246,238,230,222,214,207,199,192,184,176,168,168,171,
	173,176,179,182,185,187,190,192,194,195,197,198,201,201,203,203,
	204,205,205,205,206,205,205,205,204,203,202,201,200,198,197,196,
	194,192,190,187,185,182,179,177,174,170,176,184,191,199,207,215,
	222,230,238,245,253,245,237,230,222,215,207,199,192,183,175,168,
	160,153,145,137,129,121,114,106,98,91,83,75,67,60,52,45,
	42,49,57,64,72,80,88,96,104,111,119,127,135,143,152,160,
	168,177,186,194,202,211,220,228,237,245,252,242,233,224,216,206,
	197,189,194,200,207,214,221,215,208,201,194,188,180,174,167,161,
	154,147,140,133,127,120,113,106,99,93,86,79,73,66,73,81,
	165,156,148,139,130,121,113,104,95,87,83,90,98,106,114,121,
	129,137,145,153,160,168,176,184,191,199,207,215,222,229,237,245,
	253,246,237,230,222,215,207,199,191,199,209,218,226,235,244,253,
	245,236,227,219,210,202,193,185,176,168,160,152,144,136,128,119,
	112,104,96,88,81,74,66,58,52,60,67,75,83,91,98,106,
	114,122,129,137,144,153,160,168,175,183,192,199,207,214,222,230,
	237,246,253,245,238,230,222,214,207,199,191,184,176,168,160,159,
	163,165,169,171,173,176,178,180,182,184,185,187,188,190,191,192,
	193,193,193,193,194,193,193,193,193,192,191,190,189,187,185,184,
	183,180,178,177,173,171,168,165,163,168,175,183,192,199,207,214,
	222,230,237,245,253,246,238,230,222,214,207,199,191,183,176,168,
	160,152,145,137,130,122,114,106,99,91,83,75,67,60,52,44,
	51,58,65,74,80,88,96,104,111,120,128,136,144,151,160,168,
	177,185,193,201,210,219,227,236,245,253,244,235,226,217,208,200,
	191,188,194,201,207,214,221,215,208,201,194,187,181,173,167,160,
	153,146,140,133,126,119,113,106,99,93,86,79,72,69,78,87,
	170,162,153,144,135,126,117,109,100,92,84,90,98,106,114,122,
	130,137,145,152,161,168,176,184,191,199,207,214,222,230,237,245,
	253,245,238,230,222,215,207,199,191,192,202,210,219,228,237,246,
	252,243,235,226,217,209,201,193,184,176,168,160,151,144,136,128,
	120,112,105,97,89,82,75,67,60,60,67,76,83,90,99,107,
	114,122,129,137,145,152,160,168,176,183,191,199,206,214,223,230,
	238,245,253,245,237,229,222,214,206,199,192,184,175,168,160,153,
	152,155,158,160,163,165,167,169,172,173,174,176,177,178,180,180,
	181,181,182,183,182,183,182,182,181,181,180,179,178,176,174,173,
	171,169,167,165,162,160,157,155,160,168,176,184,191,199,207,214,
	222,230,238,246,253,245,237,230,222,214,206,199,191,183,175,168,
	161,152,145,138,130,122,114,106,98,91,83,75,68,60,52,52,
	60,67,75,82,89,97,105,113,120,128,136,143,152,160,168,176,
	184,193,201,209,218,227,235,243,252,245,237,228,219,211,202,193,
	183,188,194,201,208,214,221,215,207,201,194,187,181,174,167,160,
	154,147,140,133,126,120,113,106,99,93,86,79,73,74,84,91,
	175,166,158,149,140,131,122,114,106,97,88,91,99,106,114,121,
	129,137,145,153,160,168,176,184,191,199,206,215,223,230,238,245,
	253,245,237,229,222,214,207,199,191,186,194,203,212,221,229,238,
	246,251,242,234,226,217,208,201,192,184,176,168,160,152,144,136,
	129,121,113,105,98,91,83,76,69,61,67,75,83,91,98,106,
	114,122,130,137,145,153,160,168,175,183,191,199,207,214,222,229,
	237,245,253,245,237,230,222,215,207,199,191,183,175,168,160,152,
	145,144,146,149,151,154,156,158,160,162,164,165,166,167,168,169,
	169,170,171,171,171,171,170,170,170,169,168,167,166,164,163,161,
	160,158,156,153,151,149,146,153,160,168,176,184,191,198,206,215,
	222,230,237,246,253,245,238,230,222,215,206,198,191,184,175,168,
	161,153,144,137,129,122,114,106,98,91,83,75,68,60,54,61,
	69,75,83,91,98,106,113,120,129,136,144,152,160,167,176,184,
	193,200,209,217,226,234,243,251,247,238,229,220,212,204,194,186,
	180,187,194,201,207,214,221,214,207,201,194,187,181,174,167,160,
	154,147,140,133,126,119,113,106,99,93,86,79,72,80,88,97,
	180,171,162,153,145,136,128,120,110,102,94,91,99,106,114,122,
	129,137,145,153,160,168,176,184,191,199,207,214,223,230,238,246,
	253,245,238,230,222,214,207,199,191,183,187,196,204,213,222,230,
	239,247,250,241,233,225,216,209,200,192,184,176,169,160,152,145,
	136,129,122,114,106,99,92,85,78,70,68,75,83,91,99,106,
	114,122,129,137,145,152,160,168,175,184,191,199,207,214,222,230,
	238,245,253,246,237,230,222,214,206,199,192,184,176,168,161,153,
	145,137,135,138,140,142,144,147,149,150,152,153,154,156,157,158,
	159,158,159,160,160,159,159,159,158,157,156,156,154,153,151,150,
	149,146,145,143,141,137,145,152,160,168,176,183,191,199,207,214,
	222,230,237,246,253,245,238,230,222,214,207,199,191,183,176,168,
	161,153,145,137,129,121,114,106,99,91,83,75,67,60,63,71,
	78,84,92,99,107,114,122,129,137,144,153,160,168,177,184,192,
	200,209,217,225,233,242,250,247,239,230,222,213,204,196,187,178,
	180,187,194,201,207,215,221,214,207,201,194,188,181,173,167,161,
	153,147,140,134,126,119,113,107,99,92,86,79,77,86,94,102,
	185,177,168,159,151,142,133,125,116,108,99,91,98,107,114,121,
	130,137,145,153,161,168,176,184,191,199,207,214,222,230,238,245,
	253,246,237,230,222,215,207,199,191,183,179,189,197,206,215,223,
	231,240,248,250,241,233,225,216,209,201,192,184,177,169,161,153,
	146,138,130,122,116,108,101,94,86,79,72,75,83,91,99,106,
	114,122,129,137,145,153,160,168,176,184,192,199,206,214,222,230,
	237,245,253,245,238,230,222,215,207,199,191,184,175,168,160,153,
	144,137,130,126,129,131,134,135,137,139,141,142,144,145,146,146,
	147,148,148,148,148,148,148,148,147,146,145,145,143,142,141,139,
	138,135,133,131,129,137,145,153,161,168,175,184,191,199,207,214,
	222,230,238,245,253,245,237,230,222,215,207,198,191,184,175,168,
	160,152,145,137,129,121,114,106,98,91,83,75,68,66,73,80,
	86,93,101,108,116,123,131,138,145,153,160,169,177,184,192,200,
	208,216,225,233,241,250,248,240,231,223,214,206,197,188,179,174,
	181,188,194,201,207,214,221,214,207,201,194,188,180,173,167,160,
	153,147,140,133,127,120,113,107,99,92,86,80,82,91,99,108,
	190,182,173,164,155,147,138,130,121,113,104,95,99,107,114,122,
	129,137,144,152,160,168,176,184,191,198,207,214,222,230,238,246,
	253,245,238,229,222,214,207,199,191,183,176,181,190,198,207,215,
	224,232,240,249,249,241,233,225,216,209,200,193,184,177,170,162,
	154,146,139,131,124,117,109,102,96,89,81,76,83,90,99,106,
	114,122,129,137,145,153,160,168,176,184,191,199,206,215,222,230,
	237,245,253,245,238,230,222,214,206,199,191,184,176,168,160,153,
	144,137,129,122,118,120,123,124,126,127,129,131,131,133,134,134,
	135,136,136,136,137,136,137,136,136,135,134,133,132,131,129,128,
	126,124,123,122,129,138,145,153,160,168,176,184,191,199,207,214,
	222,229,238,246,253,246,237,230,222,214,207,198,191,184,176,168,
	160,153,145,137,129,122,113,106,98,91,83,76,68,75,82,88,
	95,102,110,116,124,132,139,147,154,162,169,177,185,192,200,208,
	216,225,233,240,249,248,241,232,223,215,207,198,190,181,172,174,
	180,187,194,201,208,215,221,214,208,201,195,188,181,173,167,160,
	153,147,140,133,126,120,113,106,99,92,86,79,88,96,104,113,
	195,186,178,169,160,152,144,135,127,118,110,101,99,106,114,122,
	129,137,145,153,161,168,176,184,192,198,207,214,222,230,238,246,
	253,245,238,230,222,214,207,198,191,183,176,173,182,191,199,208,
	216,224,233,241,249,249,241,233,225,217,209,201,193,185,178,170,
	162,155,148,140,133,126,118,111,105,97,91,84,83,90,99,106,
	114,121,130,138,145,152,160,168,176,184,191,199,207,215,222,230,
	238,245,253,245,238,229,222,214,206,199,191,183,176,168,160,152,
	145,137,129,122,114,109,111,113,114,116,118,119,120,121,122,123,
	124,124,125,125,125,125,125,125,124,123,123,121,121,119,118,116,
	114,113,114,122,130,137,144,153,160,168,176,184,191,199,207,214,
	222,229,237,246,253,245,237,230,222,214,206,199,191,183,176,168,
	160,152,145,137,130,122,114,106,98,91,83,75,77,84,91,97,
	104,111,119,126,133,140,148,155,162,170,178,185,193,201,209,217,
	225,232,240,249,249,241,233,224,216,207,199,190,182,173,167,173,
	180,187,194,201,208,214,221,214,208,201,194,188,181,174,167,160,
	153,147,140,133,126,119,113,106,100,92,86,85,93,101,110,118,
	200,191,183,175,166,157,149,140,132,124,115,107,98,106,114,121,
	129,137,144,152,160,168,176,183,191,199,207,215,222,230,237,245,
	253,245,238,230,222,214,207,199,191,184,175,168,174,182,191,200,
	208,216,224,233,241,249,249,241,233,225,217,209,201,194,186,178,
	171,164,156,149,142,134,127,120,114,107,100,93,87,91,99,106,
	114,122,129,137,145,152,161,168,175,184,191,198,206,215,222,230,
	237,245,253,246,238,230,222,215,206,199,191,184,176,168,161,152,
	145,137,129,122,114,106,99,101,104,105,106,108,109,110,111,112,
	113,113,114,114,113,114,113,113,113,112,111,110,110,108,106,105,
	103,106,114,122,129,138,145,153,160,168,176,184,191,199,207,214,
	222,230,238,245,253,245,237,229,222,214,206,199,192,183,176,168,
	160,153,145,137,129,121,114,106,98,90,83,80,86,93,100,107,
	114,121,128,135,142,150,157,164,171,178,187,194,202,209,217,225,
	233,241,248,249,241,233,225,217,208,200,191,183,174,166,167,174,
	180,187,194,201,208,214,221,214,207,201,194,187,180,174,167,161,
	153,147,140,133,126,120,113,106,100,93,86,90,98,107,115,124,
	205,197,188,180,172,163,154,145,137,129,120,112,104,107,114,121,
	129,137,145,153,160,168,176,183,191,199,206,215,222,230,238,245,
	253,245,238,230,222,214,206,199,191,183,176,168,166,175,183,192,
	200,208,217,224,233,241,249,249,241,233,225,217,210,203,195,187,
	179,172,165,158,151,143,137,130,123,116,109,102,96,90,99,106,
	114,122,129,137,145,152,160,168,175,184,191,199,206,214,222,230,
	238,245,253,245,237,230,222,214,207,199,191,184,176,168,160,153,
	145,137,129,122,114,106,98,90,92,93,95,97,98,99,100,101,
	101,102,102,103,102,102,102,102,101,101,99,99,98,96,95,93,
	98,106,114,121,129,137,144,153,160,168,176,184,191,199,207,215,
	222,230,238,246,253,245,238,230,222,215,206,199,191,183,176,168,
	160,153,144,137,129,122,114,107,99,91,83,90,96,102,109,116,
	122,130,137,144,150,158,165,173,180,187,195,203,210,217,225,234,
	241,249,249,241,233,225,216,208,200,192,183,175,167,160,168,174,
	181,188,194,200,208,215,221,214,208,200,194,187,181,174,167,160,
	154,146,140,133,126,120,113,106,99,93,87,96,103,112,121,129,
	211,202,194,185,176,168,159,151,143,134,126,117,110,106,114,122,
	129,137,144,153,160,168,176,184,191,199,206,215,222,230,237,245,
	253,246,238,230,222,215,206,198,192,184,176,168,160,168,175,184,
	192,200,209,216,224,233,241,249,249,241,234,226,219,211,203,196,
	188,181,174,166,160,152,146,139,132,125,119,111,106,99,98,106,
	114,122,130,137,145,153,160,168,176,184,191,199,207,214,222,230,
	237,245,253,245,238,230,222,215,207,199,192,184,176,168,161,152,
	145,137,129,122,114,106,98,91,83,82,84,85,86,87,88,89,
	89,90,91,91,91,90,90,90,89,89,88,87,87,85,84,91,
	98,106,114,122,130,138,145,153,161,168,176,184,191,199,206,214,
	222,229,237,245,253,245,238,229,222,214,207,199,191,184,176,168,
	160,153,145,137,129,121,114,106,99,91,92,99,106,112,118,126,
	132,139,146,153,160,167,174,181,189,196,204,211,218,226,233,242,
	249,248,240,233,225,217,208,200,192,184,176,168,158,160,167,174,
	180,187,194,201,208,214,221,214,208,201,194,187,181,174,167,160,
	154,147,140,133,126,119,113,106,99,92,93,101,110,118,126,135,
	215,207,199,190,182,174,165,156,149,140,132,123,115,107,114,122,
	130,138,144,153,161,168,176,183,192,199,207,215,222,230,238,245,
	253,246,238,230,222,214,207,199,191,183,175,168,160,160,168,176,
	184,193,200,209,216,225,233,241,248,250,242,235,227,219,213,205,
	197,190,183,176,169,162,155,148,141,134,127,121,114,108,102,106,
	114,121,129,137,145,153,160,168,176,183,191,198,206,214,222,229,
	238,245,253,246,238,230,222,214,207,199,191,183,176,168,160,153,
	145,137,129,121,114,106,99,91,83,75,73,74,75,76,77,78,
	78,79,79,80,79,80,79,79,78,78,77,76,75,75,83,91,
	99,106,113,121,130,138,145,153,160,168,176,184,192,198,206,215,
	222,230,237,245,253,246,238,230,222,214,207,198,191,184,176,168,
	160,152,145,137,129,122,114,106,99,95,102,108,115,121,128,135,
	141,148,154,162,168,176,183,191,197,204,212,220,227,235,242,250,
	248,240,233,225,217,208,201,192,184,176,168,159,153,160,167,173,
	180,187,194,200,208,214,221,214,208,201,194,187,181,174,167,161,
	154,146,140,133,126,119,113,107,100,93,99,107,115,123,131,140,
	221,213,205,196,188,178,171,162,154,146,137,128,121,113,114,122,
	129,137,145,153,160,168,176,184,191,199,206,215,222,230,237,245,
	253,245,237,230,223,214,206,199,192,183,176,168,161,152,160,169,
	176,184,192,201,208,216,224,232,239,247,251,244,236,229,221,214,
	206,199,192,185,178,171,164,157,150,144,138,131,124,118,112,106,
	114,122,129,137,145,153,160,168,175,183,191,199,207,214,222,230,
	238,246,253,245,238,229,222,214,207,199,191,184,176,168,160,153,
	145,137,129,122,114,106,98,91,83,76,67,62,64,64,65,66,
	67,68,68,68,68,68,68,67,67,66,65,64,68,75,83,90,
	99,106,114,122,129,137,145,153,161,168,176,184,191,199,206,214,
	222,230,237,245,253,246,238,230,222,215,206,199,192,183,175,168,
	161,153,145,137,129,122,114,107,99,105,112,117,124,130,137,144,
	150,157,164,171,178,184,192,199,206,213,221,228,236,243,250,248,
	240,232,224,216,208,200,193,184,176,168,160,151,153,161,167,174,
	181,187,194,200,207,215,221,215,208,201,194,187,180,174,167,160,
	153,147,140,133,126,119,113,106,100,96,104,112,121,129,137,145,
	216,218,210,201,193,184,176,168,159,151,143,134,127,119,114,122,
	130,137,145,152,160,168,176,184,191,199,207,214,222,230,238,245,
	253,245,238,230,222,215,206,199,191,183,176,168,160,152,152,160,
	168,176,184,192,200,208,216,224,231,239,246,252,245,237,230,223,
	215,208,200,194,187,179,174,167,159,153,146,140,133,128,121,115,
	113,122,129,137,145,153,160,168,176,184,191,199,207,214,222,230,
	237,246,253,245,238,230,222,214,207,199,191,183,176,168,160,153,
	145,137,130,122,114,106,99,91,83,76,67,60,52,53,54,55,
	55,56,56,57,57,57,56,56,55,54,54,60,68,76,83,90,
	99,106,114,121,129,137,145,153,160,168,176,184,192,199,206,214,
	222,230,237,246,253,246,237,230,222,215,207,199,192,183,175,168,
	160,153,144,137,129,122,114,107,109,115,122,128,134,140,147,153,
	159,166,173,179,187,194,201,208,216,222,230,237,245,252,247,239,
	231,223,216,208,200,193,185,176,168,160,152,147,154,160,167,174,
	180,187,194,201,208,214,221,215,208,201,194,187,181,174,167,160,
	153,147,140,134,126,120,113,106,99,102,110,118,126,135,143,151,
	210,219,215,207,198,190,182,174,165,157,149,141,133,124,116,121,
	130,137,144,152,160,168,176,183,191,198,207,215,222,230,238,245,
	253,245,237,229,222,214,207,198,191,184,176,168,161,153,145,152,
	160,168,177,184,192,199,207,215,222,231,238,245,253,245,238,231,
	224,217,209,202,196,189,182,176,169,163,156,150,144,137,131,125,
	118,121,130,137,145,153,161,168,176,184,191,199,207,214,222,230,
	238,245,253,245,238,230,222,214,207,199,191,183,175,168,160,152,
	144,137,129,121,114,106,99,91,83,75,68,60,52,44,42,43,
	44,44,45,45,45,45,45,45,44,44,52,59,67,75,83,90,
	98,106,114,122,129,137,145,153,161,168,176,184,192,199,206,215,
	222,230,237,245,253,245,238,230,223,215,206,198,191,184,176,168,
	161,152,144,137,129,121,113,113,119,124,130,137,143,149,156,162,
	169,175,182,189,196,203,210,217,224,232,239,246,252,245,238,230,
	222,215,208,200,192,184,176,168,160,152,143,147,154,160,167,174,
	181,188,195,201,208,214,221,214,207,201,194,187,180,174,167,160,
	153,147,140,133,126,120,113,106,100,108,116,124,132,140,148,157,
	205,213,220,212,204,196,187,179,171,163,155,146,138,130,122,122,
	129,137,145,153,160,168,176,184,191,199,206,215,222,229,237,246,
	253,245,237,230,222,215,206,199,191,184,176,168,160,152,145,144,
	151,160,168,175,184,191,199,206,214,222,230,237,244,251,247,240,
	233,226,219,212,205,198,191,185,178,172,165,159,152,147,141,134,
	128,122,129,137,145,153,160,168,176,183,192,199,207,214,222,230,
	237,245,253,245,238,230,222,215,206,199,191,184,175,168,161,152,
	145,137,129,122,114,107,99,91,83,75,67,60,53,44,37,32,
	33,33,33,33,34,33,33,33,37,45,52,60,67,75,83,91,
	98,106,113,122,129,138,145,152,160,168,175,184,191,199,206,214,
	222,230,238,245,253,245,237,230,222,214,207,199,192,184,176,168,
	160,153,144,137,130,122,116,123,128,135,141,146,153,159,165,172,
	178,185,191,199,206,212,219,225,233,240,248,252,244,237,230,222,
	215,207,199,191,183,176,167,160,152,143,140,146,154,160,167,174,
	181,187,194,201,207,214,221,214,208,201,195,188,181,174,167,160,
	154,146,140,133,126,120,113,107,106,114,121,130,138,146,154,163,
	199,208,217,218,210,201,193,185,177,168,160,152,144,136,128,122,
	130,137,145,153,161,168,176,183,191,199,206,214,222,230,238,245,
	253,245,238,230,222,214,207,199,191,183,176,168,160,152,145,137,
	144,152,160,167,175,183,191,198,205,213,221,228,235,242,250,249,
	242,235,228,221,214,207,201,195,188,181,175,168,162,156,150,144,
	138,132,130,137,145,152,160,168,175,184,191,199,207,214,222,230,
	237,245,253,245,238,230,222,215,207,198,191,184,176,168,160,153,
	145,137,129,122,114,106,99,91,83,76,68,60,52,45,36,29,
	21,22,22,22,22,22,22,29,36,44,52,60,68,75,83,90,
	98,107,114,121,129,138,145,152,161,168,176,183,191,199,207,214,
	222,230,237,245,253,245,237,230,222,215,207,199,191,183,175,168,
	160,153,144,138,129,122,127,132,138,144,150,157,162,169,175,182,
	188,194,200,207,215,222,228,234,242,249,250,242,236,228,220,213,
	205,198,191,183,175,167,160,151,144,136,140,146,153,161,167,174,
	180,187,194,201,207,215,221,214,208,201,194,187,181,174,167,161,
	153,146,140,133,127,120,113,106,111,120,128,136,144,152,160,168,
	194,202,211,219,215,207,198,190,182,174,166,158,150,142,134,126,
	129,138,144,152,160,168,175,183,192,199,206,214,222,229,237,245,
	253,245,237,230,222,215,206,199,191,184,176,168,160,153,145,137,
	135,143,151,158,166,175,182,190,197,205,212,219,226,233,241,248,
	251,244,237,231,224,217,211,204,197,190,184,178,172,166,160,154,
	148,142,136,137,145,153,160,168,175,183,191,199,207,214,222,230,
	237,245,253,245,238,230,222,214,207,199,191,184,176,168,160,153,
	144,137,129,121,114,107,99,91,83,75,68,60,52,44,37,29,
	21,14,10,10,11,14,21,29,37,44,52,60,67,75,83,91,
	99,106,114,122,130,137,144,152,160,168,176,183,191,198,207,214,
	222,230,238,245,253,246,237,230,222,214,207,199,191,183,176,168,
	160,152,145,137,129,131,136,142,148,154,159,166,172,178,185,191,
	197,204,210,217,224,230,237,244,251,248,241,233,227,219,212,204,
	197,189,182,174,166,158,151,143,135,133,140,147,154,161,167,174,
	181,187,194,201,207,215,221,215,207,200,194,187,181,174,167,160,
	154,147,140,133,126,120,113,109,118,126,133,141,150,158,166,174,
	189,197,205,213,220,212,204,196,188,180,172,164,155,147,140,132,
	130,137,145,153,161,168,176,183,191,198,207,215,222,230,237,245,
	253,246,237,229,222,214,207,199,191,183,176,168,160,152,145,137,
	129,135,142,151,158,166,173,181,188,195,203,211,218,225,232,238,
	246,253,246,240,233,226,219,213,207,201,194,188,182,175,170,164,
	158,153,146,141,145,153,160,168,176,184,192,199,207,214,222,230,
	238,245,253,245,237,230,223,215,207,199,191,183,176,168,160,153,
	145,138,130,122,114,106,99,91,83,75,67,60,52,44,37,29,
	21,14,6,0,6,13,21,29,36,45,52,60,68,75,83,91,
	98,106,114,121,129,137,145,152,160,168,175,183,192,199,206,215,
	222,229,237,246,253,245,237,230,222,215,206,199,191,184,176,168,
	160,153,145,137,136,141,146,152,157,164,169,175,182,188,194,200,
	206,213,220,226,233,240,246,253,246,238,232,225,218,211,203,196,
	188,181,173,166,158,150,143,135,128,133,140,147,154,161,167,173,
	180,187,194,201,208,214,221,215,208,201,194,187,181,174,167,160,
	154,146,140,133,127,120,113,116,124,131,139,148,155,164,172,180,
	183,191,199,207,216,219,210,202,194,186,178,169,162,153,145,138,
	130,137,145,153,160,168,176,184,191,199,206,215,222,229,237,245,
	253,245,238,230,222,214,207,199,191,184,176,168,161,152,145,137,
	129,127,134,142,150,157,165,172,179,187,194,202,209,215,223,230,
	237,244,250,249,243,236,229,222,216,209,204,197,192,186,179,174,
	168,163,156,151,146,153,160,168,176,183,191,199,207,214,222,230,
	238,245,253,245,238,230,222,214,207,199,191,184,176,168,160,152,
	145,137,129,122,114,106,98,91,83,75,68,60,53,44,37,29,
	22,13,9,8,9,13,21,29,37,45,52,60,67,75,83,90,
	98,106,114,121,129,137,145,153,160,168,175,184,191,199,207,215,
	222,230,238,245,253,246,238,229,223,214,207,199,192,183,176,168,
	160,153,145,141,146,151,156,162,168,174,179,185,191,197,204,209,
	216,223,229,236,242,249,250,243,237,230,223,216,208,201,195,187,
	180,172,164,157,149,142,135,126,126,134,140,146,154,160,167,174,
	180,188,194,201,208,214,221,214,207,201,194,188,181,174,167,160,
	154,147,140,133,126,120,114,122,130,137,146,154,161,170,178,186,
	177,185,193,201,210,218,216,208,200,191,184,176,168,159,152,144,
	136,137,144,152,160,168,176,183,191,199,207,214,222,230,238,245,
	253,245,238,229,222,215,207,199,191,184,176,168,161,152,145,137,
	129,122,126,134,141,148,156,163,171,178,185,193,200,207,214,220,
	228,235,241,248,252,245,238,232,226,219,213,207,201,195,189,184,
	178,172,167,161,156,152,161,168,176,184,191,199,206,214,222,230,
	238,245,253,245,237,230,222,215,206,199,191,184,176,168,160,152,
	144,137,129,121,114,106,99,90,83,75,68,60,52,45,36,29,
	22,20,20,19,20,20,21,29,37,44,52,60,68,75,83,91,
	98,106,114,121,130,137,145,152,160,168,175,183,191,199,207,215,
	222,230,237,245,253,245,237,230,222,214,206,199,192,183,175,168,
	161,153,145,151,156,161,166,172,178,183,189,195,201,207,213,219,
	226,232,239,245,252,248,241,235,228,221,214,207,200,193,185,178,
	171,163,156,148,141,133,125,120,126,133,140,147,153,160,167,174,
	181,187,194,201,207,214,221,215,207,201,194,187,181,174,167,160,
	153,146,140,134,126,120,120,128,136,144,152,159,168,176,183,192,
	171,180,188,195,204,212,220,214,205,198,190,182,174,166,158,150,
	142,137,145,152,160,168,176,184,191,199,206,215,222,230,237,246,
	253,246,238,230,222,214,207,198,192,184,176,168,161,153,144,137,
	130,121,117,125,133,140,148,155,162,169,176,183,190,198,204,211,
	218,225,232,239,245,252,248,242,236,229,223,217,211,205,199,193,
	188,182,177,171,166,161,161,168,176,184,191,199,207,215,222,230,
	238,246,253,246,237,230,222,215,207,198,191,184,175,168,161,152,
	145,137,130,122,113,106,98,91,83,76,68,60,52,44,37,33,
	32,32,31,31,31,32,31,32,37,44,53,60,67,75,83,90,
	98,106,113,121,129,137,145,153,160,168,176,184,191,199,206,215,
	222,229,238,246,253,245,237,229,222,215,207,199,191,183,176,168,
	160,152,155,161,166,171,176,182,188,193,199,205,210,217,223,229,
	236,242,248,252,245,239,232,225,219,212,205,198,190,184,177,169,
	162,154,148,140,132,125,117,120,127,133,140,147,154,160,167,174,
	180,187,195,201,208,214,221,214,208,201,194,187,180,174,167,160,
	154,147,140,133,126,120,127,134,142,150,157,166,174,182,190,197,
	166,174,182,190,198,207,214,220,211,203,196,188,180,172,164,157,
	148,141,145,152,161,168,175,183,191,199,207,215,222,230,238,246,
	253,245,238,230,222,214,207,199,192,184,176,168,160,153,145,137,
	130,122,114,116,124,131,138,146,153,160,167,175,182,188,196,203,
	209,216,222,229,236,242,249,251,245,239,233,226,221,215,209,204,
	198,192,187,181,176,171,165,168,176,183,192,199,206,214,222,230,
	237,245,253,245,238,230,222,214,206,199,191,184,176,167,160,153,
	145,138,129,122,114,106,98,91,83,75,67,60,52,46,45,44,
	44,43,43,43,43,42,43,43,43,45,52,60,67,75,83,91,
	98,107,114,122,129,137,145,153,160,168,176,183,191,199,207,214,
	222,230,237,245,253,245,237,229,222,215,207,199,191,183,175,168,
	160,160,165,171,176,181,187,192,198,203,209,215,221,226,233,238,
	245,252,248,242,236,229,222,216,209,203,196,189,182,175,168,161,
	153,146,138,131,124,117,113,120,126,133,140,146,153,161,167,173,
	180,188,194,201,208,215,221,215,208,201,194,188,181,174,167,161,
	153,147,140,134,127,125,133,141,148,156,164,172,180,188,196,204,
	160,169,176,184,193,201,209,217,218,210,202,194,186,178,170,163,
	155,147,144,152,160,168,176,184,191,199,207,214,223,230,238,246,
	253,245,237,230,222,214,206,199,191,183,176,168,160,152,145,137,
	130,121,114,108,115,122,130,138,145,152,158,166,172,179,186,193,
	200,206,213,220,226,232,239,246,251,248,242,236,231,225,219,213,
	208,203,197,191,186,181,176,171,176,183,191,199,207,214,222,230,
	238,245,253,246,238,230,223,215,207,199,191,184,175,168,161,153,
	144,137,130,122,113,107,98,91,83,75,68,60,58,57,56,55,
	55,54,54,54,54,54,54,55,55,55,56,60,68,75,83,91,
	99,106,114,122,130,137,145,153,160,168,176,183,191,199,206,214,
	222,230,238,245,253,245,238,230,223,214,207,198,191,183,176,168,
	166,171,176,181,186,191,197,202,208,213,219,224,231,236,242,248,
	252,245,239,233,227,219,213,207,200,193,187,180,173,165,158,151,
	144,137,130,122,115,108,113,119,127,134,140,147,153,160,167,173,
	180,188,195,201,207,214,221,215,208,201,194,187,180,174,167,161,
	154,147,140,133,127,132,139,147,155,163,170,178,186,194,202,209,
	154,162,170,179,186,194,202,211,218,216,208,200,192,185,177,169,
	161,153,146,152,160,168,176,183,191,199,206,214,223,230,237,246,
	253,245,238,230,223,215,207,199,191,184,176,168,161,153,145,137,
	130,122,114,106,107,113,121,129,135,143,149,157,164,170,178,184,
	190,197,204,210,217,224,229,236,242,248,252,246,241,234,229,223,
	218,212,207,202,197,192,186,181,176,184,191,199,207,214,222,229,
	238,245,253,245,238,230,222,214,206,199,191,184,176,168,161,153,
	145,137,130,122,114,106,98,91,83,76,72,70,69,69,68,67,
	67,66,65,66,66,66,66,66,67,67,68,69,69,76,83,91,
	98,106,113,122,129,137,145,152,160,168,176,183,191,199,207,214,
	222,230,237,245,253,245,238,230,222,214,207,199,191,184,175,171,
	177,181,186,191,196,202,207,212,217,223,229,235,240,246,252,248,
	242,236,230,223,216,210,204,197,190,184,177,170,163,157,150,143,
	135,129,120,113,106,107,113,119,127,133,140,146,154,161,167,173,
	181,187,194,201,207,215,222,214,208,201,194,188,181,173,167,160,
	154,147,140,133,130,138,145,153,161,169,176,185,192,201,208,216,
	148,157,165,172,180,188,197,204,212,220,215,206,199,191,183,175,
	167,160,152,152,161,168,176,183,191,199,206,214,222,229,237,245,
	253,246,238,230,222,215,207,199,191,183,176,168,160,152,145,137,
	129,122,114,106,99,104,112,119,126,134,140,148,154,162,168,174,
	181,188,194,201,207,214,220,226,232,238,244,250,251,244,238,233,
	228,223,217,212,207,202,197,192,187,184,191,199,207,214,222,229,
	237,246,253,245,237,230,222,214,207,199,191,184,176,168,160,153,
	145,137,130,121,114,106,98,90,85,84,83,81,81,80,80,78,
	77,77,77,77,77,77,77,77,77,78,79,80,81,82,83,91,
	98,106,114,122,130,137,145,152,160,168,176,183,191,199,207,214,
	223,230,238,245,253,246,238,230,222,214,206,199,191,184,178,182,
	187,192,197,202,207,212,217,222,228,233,239,244,251,250,245,239,
	233,226,220,214,208,201,194,188,181,175,168,161,154,148,140,133,
	126,119,112,105,100,106,113,120,126,133,140,147,154,161,167,174,
	180,187,194,200,208,215,221,215,207,201,194,187,181,174,167,160,
	154,147,140,133,137,144,152,160,168,176,183,190,198,206,214,220,
	142,150,158,167,174,183,190,198,207,214,220,213,205,197,189,182,
	174,166,158,152,160,168,176,183,191,199,207,214,222,230,237,246,
	253,245,237,230,222,214,207,199,192,183,176,168,160,152,144,137,
	129,121,114,106,99,96,104,110,117,124,131,138,145,152,158,165,
	172,178,185,192,197,204,210,216,223,229,234,240,245,252,248,243,
	238,232,227,222,217,212,207,202,198,192,191,199,206,214,222,230,
	238,246,253,245,238,230,222,214,207,199,191,183,175,168,160,152,
	144,137,130,122,114,107,100,98,97,96,95,93,92,92,90,89,
	89,89,88,89,88,89,89,89,89,90,90,91,92,93,95,95,
	98,106,114,122,129,138,145,153,161,168,176,184,191,199,206,215,
	222,230,237,245,253,245,237,230,222,215,207,199,191,184,188,192,
	197,202,207,212,217,222,227,232,238,243,248,252,246,240,234,229,
	223,217,210,204,198,192,185,179,172,165,159,152,145,139,131,124,
	117,110,104,96,100,106,113,120,127,133,140,147,153,160,167,174,
	180,188,195,201,208,214,221,214,208,201,194,188,180,174,167,161,
	153,146,140,136,143,151,158,166,174,181,189,197,204,212,220,214,
	136,145,152,160,168,176,184,192,200,208,216,219,211,203,196,188,
	180,172,165,158,160,168,176,183,192,199,207,214,222,230,238,245,
	253,246,238,230,222,214,207,199,191,184,176,168,161,152,145,137,
	130,122,114,106,98,90,95,102,108,116,122,130,136,142,149,156,
	162,169,176,182,188,194,200,206,213,218,224,230,236,242,247,253,
	248,243,237,232,227,222,217,212,208,204,198,199,207,214,223,230,
	237,245,253,245,238,230,222,215,206,198,192,183,176,168,160,153,
	145,137,130,122,115,113,111,110,108,107,106,104,104,103,102,101,
	101,101,100,100,100,100,100,100,101,101,102,103,103,105,105,107,
	108,110,114,122,129,137,145,152,161,168,176,183,191,199,207,214,
	222,230,237,246,253,245,238,230,222,214,207,199,192,194,198,203,
	208,212,217,222,227,232,238,242,248,252,248,242,236,231,225,218,
	212,207,201,194,188,182,176,169,163,156,150,143,136,129,122,115,
	108,101,94,93,99,106,113,119,126,133,140,147,153,161,168,174,
	180,188,194,201,208,214,221,214,208,200,195,188,180,173,167,161,
	154,147,140,142,150,158,165,172,180,188,196,203,211,219,216,208,
	131,139,147,154,163,170,178,186,194,201,209,218,217,209,202,195,
	187,179,172,164,160,168,175,184,191,199,207,214,222,230,238,245,
	253,246,237,230,222,215,206,199,191,184,175,168,161,153,145,137,
	130,121,114,106,99,91,85,93,99,106,113,120,127,134,140,147,
	153,160,166,172,178,185,191,197,203,209,214,220,226,232,238,242,
	247,253,247,242,237,232,228,223,218,214,209,205,206,214,222,230,
	238,245,253,245,238,230,222,214,207,199,191,183,176,168,160,152,
	145,137,130,128,126,124,122,121,119,118,117,116,115,114,113,112,
	113,112,111,112,111,111,112,111,112,113,113,114,115,116,117,118,
	120,121,122,124,130,137,144,153,161,168,175,183,191,199,207,214,
	222,230,238,245,253,245,238,230,222,214,206,199,200,204,209,213,
	218,223,228,233,238,242,248,253,248,243,237,231,226,220,215,209,
	202,197,191,185,178,173,166,160,153,146,140,134,127,120,113,106,
	100,92,86,93,99,106,113,119,127,133,140,147,153,160,167,174,
	180,187,194,201,208,214,221,215,208,200,194,187,180,174,167,161,
	153,147,142,149,156,164,172,179,187,194,202,210,217,217,210,202,
	124,133,141,148,156,164,172,179,187,195,203,211,218,216,208,201,
	193,186,178,170,163,168,176,184,191,199,207,215,222,230,237,246,
	253,245,238,229,222,214,206,199,192,183,176,168,161,152,145,137,
	129,121,113,106,98,91,83,84,90,97,104,111,118,125,131,137,
	144,150,156,163,169,175,181,187,193,199,205,210,216,221,227,233,
	238,243,249,253,247,243,238,233,229,224,220,215,211,215,222,230,
	238,245,253,245,237,230,222,215,207,199,191,184,176,168,160,152,
	145,143,141,139,137,135,134,133,131,130,128,127,127,126,124,124,
	124,124,123,122,122,122,123,124,124,124,124,126,126,128,128,130,
	131,133,133,136,138,139,145,152,160,168,175,183,191,199,207,214,
	222,230,238,246,253,245,238,230,222,215,207,207,211,215,219,224,
	228,233,238,242,248,253,248,243,237,233,227,222,216,210,204,199,
	193,187,182,175,169,163,156,150,144,138,130,125,118,111,104,97,
	90,84,86,93,99,106,113,120,126,134,140,147,154,160,167,174,
	181,188,194,201,207,214,221,215,208,201,194,187,180,174,167,160,
	153,146,149,156,163,171,179,185,193,201,208,216,218,211,203,196,
	119,126,134,142,150,158,165,173,181,189,197,204,212,219,215,207,
	200,192,185,177,170,168,176,183,192,199,206,214,222,230,238,245,
	253,245,238,230,222,215,207,199,191,184,176,168,160,152,145,137,
	130,122,114,106,99,90,83,75,82,88,94,102,108,115,122,128,
	135,140,147,153,159,166,172,178,183,189,195,200,206,212,217,222,
	228,233,238,243,248,253,249,244,239,235,230,226,222,217,222,230,
	237,246,253,245,238,230,222,214,207,199,192,183,175,168,162,159,
	156,154,152,150,148,147,145,144,142,141,139,139,137,136,136,135,
	135,135,134,134,134,134,134,134,135,136,136,137,137,139,140,141,
	143,144,145,147,149,151,153,154,160,168,176,183,191,199,207,214,
	222,230,238,246,253,246,238,229,222,214,214,217,222,226,230,234,
	239,244,249,253,248,243,238,233,228,222,217,212,206,200,195,189,
	184,178,171,165,159,153,147,141,134,128,121,115,108,102,95,88,
	81,79,86,93,99,107,113,120,127,133,140,147,153,160,167,173,
	180,188,194,201,207,214,221,215,208,201,195,188,181,174,167,161,
	154,148,155,163,170,178,184,192,200,207,215,220,212,204,196,189,
	112,120,128,135,144,152,159,167,175,182,190,198,206,213,221,214,
	206,198,192,184,177,169,176,183,192,199,206,214,222,230,237,245,
	253,245,238,230,222,214,206,199,191,184,176,168,161,153,145,137,
	130,122,114,106,99,91,83,75,72,78,86,92,99,106,112,119,
	124,131,137,144,150,156,161,168,173,180,185,190,196,201,206,213,
	218,223,228,233,237,242,247,252,250,245,241,236,232,229,224,230,
	237,246,253,245,238,230,223,215,206,199,191,184,178,175,173,170,
	168,165,164,161,160,159,156,155,154,152,151,150,149,149,148,147,
	146,146,146,146,146,145,146,146,146,147,147,149,150,150,151,152,
	153,155,156,158,160,162,164,166,168,170,175,184,191,199,207,214,
	222,230,237,245,253,245,238,230,222,220,224,228,232,237,240,245,
	249,252,247,242,238,232,228,223,218,212,207,201,196,190,185,180,
	174,167,162,155,150,143,137,131,125,118,112,106,99,92,86,79,
	72,79,86,93,100,107,112,120,126,133,140,147,153,161,167,174,
	180,188,194,201,208,215,221,215,208,201,194,188,180,174,167,160,
	153,154,161,169,176,184,191,198,206,214,221,213,206,198,191,183,
	106,114,122,130,137,145,153,161,168,176,184,192,199,207,214,220,
	213,205,198,191,184,176,176,184,192,199,207,215,222,230,238,246,
	253,245,238,230,222,215,207,199,191,184,176,168,160,152,145,137,
	130,122,114,107,99,91,83,75,68,70,76,83,90,96,103,108,
	115,121,128,133,139,146,152,158,163,169,175,181,186,191,197,202,
	208,212,217,222,228,232,236,241,246,250,251,247,243,239,235,231,
	237,245,253,245,237,229,222,214,207,199,194,192,188,186,184,181,
	180,177,174,173,172,169,168,167,166,164,163,161,161,159,159,159,
	158,158,157,157,157,157,157,157,158,159,159,160,161,162,163,164,
	165,167,168,170,171,173,175,176,179,181,184,186,191,199,207,214,
	222,230,237,245,253,245,237,229,227,231,235,239,243,247,251,250,
	246,241,237,232,227,223,217,212,208,202,197,191,186,181,175,170,
	163,158,152,146,140,134,128,122,116,109,102,96,89,83,76,70,
	73,80,86,92,99,106,113,120,126,133,140,146,153,160,167,174,
	181,187,194,201,208,215,221,215,208,201,194,187,180,174,167,160,
	154,162,168,176,183,191,198,206,213,221,215,206,199,191,183,176,
	100,107,116,124,131,139,146,154,162,169,177,185,192,200,208,216,
	220,213,205,198,190,183,176,184,191,199,207,214,222,230,237,246,
	253,245,238,230,222,215,207,199,191,184,176,168,160,153,145,137,
	130,122,114,106,98,91,83,76,67,60,67,74,80,87,93,99,
	106,112,118,124,130,136,142,148,153,159,165,170,176,182,187,192,
	197,202,207,212,217,221,226,231,236,240,245,248,253,250,245,241,
	238,246,253,245,237,230,222,215,211,208,205,202,200,198,194,193,
	190,188,186,184,182,181,179,177,177,175,174,173,172,171,171,170,
	169,168,169,169,169,169,169,169,170,170,170,171,172,173,174,175,
	176,178,180,181,182,184,186,188,190,192,195,197,200,202,207,215,
	222,230,237,245,253,245,237,234,238,242,245,250,252,248,245,239,
	235,230,226,222,217,212,207,202,197,192,187,182,175,170,165,159,
	153,148,142,136,130,124,118,112,106,99,93,86,80,74,67,66,
	73,79,86,93,100,106,113,120,127,134,140,147,153,160,167,174,
	181,187,194,201,208,215,221,215,207,201,194,187,181,174,167,161,
	161,168,176,183,190,197,205,212,220,215,208,200,192,185,177,169,
	93,101,109,117,124,132,140,148,155,163,171,178,186,194,200,209,
	216,219,212,204,197,189,182,184,192,199,207,214,222,230,237,245,
	253,246,238,230,222,214,206,199,191,184,176,168,160,153,145,137,
	129,122,114,107,98,91,83,76,67,59,57,64,71,77,83,89,
	96,102,109,114,120,126,132,138,143,149,154,161,166,171,177,182,
	186,192,196,202,207,211,215,220,225,229,233,237,241,246,249,253,
	248,245,253,246,238,232,228,224,222,219,216,213,211,208,206,203,
	201,199,198,196,193,192,190,189,188,186,185,184,183,183,182,182,
	180,180,180,180,180,180,180,181,181,182,181,182,183,184,185,186,
	188,189,190,193,194,196,197,200,201,204,206,209,211,214,216,219,
	222,230,238,246,253,246,241,245,249,253,250,246,242,238,233,229,
	225,220,216,211,207,202,197,191,187,182,177,171,166,160,155,150,
	144,138,132,126,120,114,108,102,96,90,83,77,71,64,59,66,
	73,79,86,93,99,106,113,120,127,133,140,146,154,161,167,173,
	180,188,194,201,207,215,221,214,208,201,194,188,181,174,167,161,
	168,175,182,190,197,205,212,219,216,208,201,194,186,179,171,163,
	87,95,103,111,118,126,134,142,149,156,164,172,180,187,194,201,
	209,217,219,211,204,197,189,184,191,199,207,215,222,230,237,245,
	253,245,237,230,222,214,207,199,191,183,176,168,160,152,145,137,
	129,122,114,107,98,90,83,76,67,60,52,54,61,68,74,80,
	87,92,99,105,110,116,122,128,134,139,145,151,156,161,166,172,
	176,181,186,191,196,201,205,210,215,218,223,227,231,235,239,243,
	246,250,253,249,245,242,239,236,233,230,227,225,222,219,217,215,
	213,210,209,207,205,203,202,200,199,198,197,196,194,194,193,193,
	192,192,192,191,191,191,191,192,192,192,193,194,195,195,197,198,
	199,200,202,203,205,207,208,211,213,215,217,219,223,225,228,230,
	233,236,239,245,253,249,252,250,247,243,239,235,231,227,223,219,
	215,210,206,200,196,192,187,181,176,171,166,161,156,150,145,140,
	134,128,122,116,110,105,99,92,86,80,74,68,61,54,59,65,
	73,79,86,93,100,106,113,120,126,133,140,147,154,160,167,174,
	180,187,194,201,207,214,221,214,208,201,194,187,181,174,167,168,
	175,182,190,196,204,211,219,217,209,202,194,187,180,171,165,156,
	81,89,97,104,112,120,127,135,142,150,157,165,172,181,188,195,
	202,210,217,218,211,203,197,189,191,199,206,214,222,230,237,246,
	253,245,237,230,222,214,207,199,191,184,175,168,160,153,145,137,
	129,122,114,106,98,90,83,75,68,60,52,46,52,58,64,71,
	76,83,89,95,100,106,113,119,124,129,135,140,146,151,156,161,
	166,172,176,180,185,190,195,199,204,208,212,217,221,224,228,232,
	237,246,253,246,250,253,250,247,244,241,239,236,233,231,228,226,
	224,222,220,218,216,215,213,212,211,209,208,208,206,205,204,204,
	203,203,203,203,203,203,203,203,204,205,205,205,206,207,208,210,
	211,211,214,215,216,218,220,222,224,227,228,231,233,236,238,241,
	244,247,250,253,253,247,243,240,236,232,228,224,220,217,213,207,
	204,199,195,191,186,181,176,171,166,161,156,151,146,140,135,130,
	123,119,112,107,101,95,89,83,76,71,64,58,52,53,59,66,
	72,79,85,93,99,106,113,119,127,134,140,147,154,160,167,174,
	180,187,194,201,208,214,221,214,207,201,194,187,181,174,168,175,
	182,189,196,203,211,218,217,210,202,195,187,180,172,165,157,150,
	74,83,90,98,106,114,121,129,136,144,151,159,166,174,180,188,
	196,203,210,217,217,211,204,197,191,199,206,214,222,230,238,245,
	253,246,238,230,222,214,207,199,191,183,176,168,160,152,145,137,
	130,122,114,107,98,91,83,75,68,60,53,44,42,49,55,61,
	68,73,79,86,91,97,103,108,114,119,125,130,135,140,145,151,
	156,161,166,171,175,180,184,189,193,197,202,206,210,215,222,230,
	238,245,253,245,239,242,245,248,251,252,250,247,244,242,240,237,
	236,233,231,230,227,226,224,223,222,220,220,218,218,217,216,216,
	215,215,214,214,214,214,215,215,215,215,216,217,217,219,219,221,
	222,224,225,226,228,229,231,234,235,237,240,242,244,247,249,252,
	251,248,245,245,253,246,237,230,224,221,218,214,210,206,202,197,
	194,188,184,179,175,170,165,161,155,150,146,141,135,131,125,119,
	114,108,102,97,91,85,79,73,67,61,55,48,45,52,59,65,
	73,79,86,93,100,106,113,120,126,133,140,146,153,161,167,174,
	180,188,195,201,207,214,222,214,208,201,194,187,181,174,175,182,
	189,196,203,211,218,218,210,203,196,188,181,173,166,159,151,143,
	68,76,84,92,99,106,114,122,129,137,144,152,159,166,174,181,
	189,195,203,211,218,217,210,203,197,199,206,215,222,229,238,246,
	253,245,238,230,222,215,206,199,192,183,176,168,160,152,145,138,
	129,122,114,106,98,91,83,75,67,60,53,44,36,39,45,51,
	58,63,70,75,81,87,93,98,104,109,114,120,125,130,136,141,
	146,151,155,160,165,169,173,178,183,187,191,199,207,214,222,229,
	238,245,253,246,237,231,234,236,240,243,245,247,250,252,250,248,
	247,245,242,240,239,238,236,234,233,232,231,230,229,228,228,227,
	226,226,225,226,226,226,226,226,227,227,227,228,229,230,231,232,
	234,234,236,238,239,241,242,245,246,249,251,253,250,248,245,243,
	240,237,237,246,253,246,238,230,222,215,207,203,199,194,191,187,
	183,178,174,169,164,160,155,150,146,141,136,130,125,120,115,109,
	104,98,93,87,81,75,69,63,58,52,45,39,45,52,58,66,
	73,79,86,92,100,106,113,120,127,133,140,147,154,160,167,174,
	181,187,194,201,208,214,221,215,207,201,194,187,181,175,182,189,
	196,204,210,217,217,210,203,196,189,182,174,167,159,152,144,136,
	62,69,77,85,92,100,108,115,123,130,138,145,152,160,167,175,
	182,189,196,203,211,218,217,210,203,199,207,214,222,229,237,246,
	253,245,238,230,223,215,207,199,192,184,175,168,160,152,145,137,
	130,122,114,106,99,91,83,76,67,60,52,44,36,29,36,42,
	48,54,60,65,71,76,83,88,93,99,105,110,115,121,126,130,
	135,140,145,149,154,159,163,168,176,184,192,199,207,214,223,229,
	238,245,253,245,238,230,223,226,229,232,234,237,239,241,244,246,
	248,250,252,252,250,248,247,246,244,243,243,242,240,240,239,238,
	238,237,237,237,238,237,237,238,238,239,239,239,241,241,242,244,
	245,246,247,249,250,252,252,250,248,246,244,242,240,237,234,231,
	229,230,237,245,253,245,238,230,222,214,206,199,191,184,180,176,
	172,168,163,159,154,150,145,140,136,131,125,121,115,110,104,99,
	94,88,83,77,71,66,59,54,47,42,36,38,45,52,59,66,
	72,79,85,93,100,106,113,119,126,133,140,147,154,160,167,174,
	181,187,194,201,207,214,221,214,207,201,194,187,181,183,189,196,
	203,210,217,218,211,203,196,189,182,175,167,160,152,145,137,130,
	56,63,70,78,86,94,102,109,116,124,131,139,146,153,161,168,
	175,182,189,197,203,211,217,217,210,204,207,214,222,230,237,245,
	253,246,237,230,222,215,207,199,191,183,176,168,160,153,145,137,
	129,122,114,106,99,91,83,75,68,59,52,44,37,29,26,32,
	38,44,50,56,61,67,73,78,84,89,94,100,105,110,115,120,
	125,130,134,139,145,153,160,168,176,183,192,199,207,215,222,229,
	238,246,253,245,238,229,223,215,218,220,223,226,228,230,233,235,
	237,239,241,243,245,246,247,248,250,251,253,253,252,251,251,250,
	249,249,249,249,249,249,249,249,250,250,250,251,252,253,252,251,
	250,249,247,245,244,243,241,239,237,235,233,230,228,225,223,221,
	222,229,238,245,253,245,238,229,222,214,207,198,191,183,176,168,
	161,157,152,148,143,139,134,130,125,120,115,109,105,99,94,89,
	84,78,72,67,61,56,49,44,38,32,31,39,45,52,59,66,
	72,79,86,93,100,106,113,120,126,134,140,147,154,160,167,173,
	180,188,194,200,208,215,221,214,207,201,194,187,183,190,197,204,
	210,217,218,210,203,196,189,183,175,168,161,153,146,138,131,124,
	50,57,64,72,80,87,95,102,109,117,124,132,138,147,153,161,
	168,175,182,189,197,204,210,218,218,211,206,214,222,229,237,245,
	253,246,238,229,222,214,207,199,191,183,175,168,160,153,145,137,
	129,122,114,106,98,91,83,75,67,60,52,45,37,29,21,22,
	29,34,40,46,51,57,63,68,73,79,84,89,95,100,105,109,
	115,121,129,137,145,153,161,168,175,184,191,199,206,214,222,230,
	238,245,253,245,238,230,222,214,207,209,212,214,217,219,221,223,
	225,227,229,231,233,234,236,238,239,240,241,242,243,243,244,245,
	245,246,246,246,246,246,245,246,245,245,244,243,243,241,241,240,
	238,238,236,235,233,231,230,227,225,224,221,219,217,215,212,215,
	222,230,237,245,253,246,237,230,223,214,206,199,192,184,176,168,
	160,153,145,137,133,129,124,120,114,110,105,100,95,90,84,79,
	74,68,63,57,51,46,40,34,28,25,32,39,46,52,59,65,
	72,79,86,92,99,106,113,119,126,133,139,147,154,160,167,174,
	181,188,194,201,207,214,221,214,208,200,194,187,190,197,204,211,
	217,217,210,203,196,189,182,175,168,160,154,146,139,132,124,117,
	43,50,58,65,73,80,87,95,103,110,117,125,132,139,147,154,
	161,168,175,182,190,197,204,211,217,218,211,214,222,230,237,246,
	253,245,237,230,222,214,207,199,192,183,175,168,160,153,145,137,
	130,122,114,106,98,91,82,76,67,60,52,45,37,28,21,13,
	19,25,30,36,41,47,52,58,63,69,74,79,84,91,98,107,
	114,122,129,137,145,153,161,168,175,184,192,199,206,215,222,230,
	238,245,253,245,238,230,222,214,207,199,201,203,206,208,210,213,
	214,216,218,220,222,223,225,226,227,228,229,230,231,232,233,233,
	234,234,234,235,235,234,235,234,233,233,233,232,231,230,229,228,
	227,226,225,223,221,220,219,217,215,213,211,208,206,203,206,214,
	222,229,237,246,253,245,238,230,222,214,207,199,191,184,175,168,
	160,152,145,137,130,121,113,108,104,99,95,89,85,79,74,69,
	64,58,53,47,41,36,30,24,18,25,32,38,46,52,59,66,
	73,80,86,92,99,106,112,119,127,133,140,147,153,160,167,174,
	181,187,194,201,208,215,221,214,208,201,194,191,197,205,211,218,
	218,210,204,197,189,183,175,168,161,154,146,140,132,125,118,110,
	36,44,51,59,66,74,81,89,96,103,110,118,125,133,139,147,
	154,161,168,176,182,189,196,203,210,217,219,214,222,229,238,246,
	253,245,237,230,222,214,207,199,191,183,176,168,160,153,144,137,
	129,121,114,106,99,91,83,75,67,60,52,45,37,29,22,14,
	8,15,20,26,31,37,43,48,53,60,68,75,83,90,98,106,
	114,122,130,137,145,152,160,168,176,183,191,199,206,215,222,230,
	238,245,253,246,238,230,222,214,206,199,191,192,194,197,199,201,
	203,205,207,208,210,212,213,215,215,217,218,219,220,221,221,222,
	222,223,223,223,223,223,223,223,222,221,221,221,220,219,218,217,
	216,215,213,212,210,209,207,205,203,201,199,197,194,198,207,214,
	222,230,238,245,253,245,237,230,222,215,206,199,192,183,176,168,
	161,153,145,137,129,122,114,106,99,90,84,79,74,69,64,58,
	54,48,42,37,31,25,20,14,18,25,32,38,46,52,59,66,
	72,79,86,92,100,106,113,119,126,134,140,147,154,161,167,173,
	181,187,194,201,208,214,221,214,207,201,194,198,204,211,219,217,
	210,204,196,190,182,176,169,161,154,147,140,132,126,118,111,103,
	29,37,44,52,59,67,74,82,89,97,104,111,118,125,133,140,
	147,154,161,168,175,182,189,196,203,209,217,219,222,230,237,245,
	253,245,237,230,222,215,207,199,191,183,176,168,160,153,145,137,
	129,121,114,106,98,91,83,75,68,60,52,44,37,29,21,13,
	6,5,10,16,22,29,37,44,52,60,67,75,83,90,98,106,
	114,121,129,137,145,153,161,168,176,184,191,199,206,215,222,230,
	238,246,253,245,238,230,222,214,206,199,191,184,183,185,187,190,
	192,194,196,197,199,201,202,204,204,206,207,208,208,209,210,211,
	211,211,212,212,212,212,211,211,211,210,209,210,209,208,206,205,
	205,204,202,200,199,197,196,194,191,190,188,186,192,199,207,214,
	222,230,237,245,253,245,237,230,222,215,206,199,191,184,176,168,
	160,153,145,137,129,121,113,107,98,90,83,75,68,60,53,48,
	43,38,32,27,21,16,10,12,19,25,32,39,45,52,59,66,
	73,80,86,93,99,106,113,119,126,133,140,147,154,160,167,174,
	180,188,194,201,208,215,221,215,208,201,199,205,213,219,216,210,
	202,196,189,182,175,168,161,154,147,140,133,126,118,111,103,97,
	23,31,38,45,52,60,68,75,82,90,97,104,111,119,125,133,
	139,147,154,161,168,175,182,189,196,202,209,216,222,229,238,246,
	253,246,237,230,222,214,207,199,191,183,176,168,161,153,144,137,
	129,121,114,106,98,90,83,75,68,60,52,44,36,29,21,13,
	6,2,5,14,21,29,36,45,52,60,68,76,83,91,99,106,
	114,122,129,138,145,152,160,168,176,183,191,199,206,215,222,229,
	238,245,253,245,237,230,222,214,207,199,192,184,176,174,177,179,
	181,182,185,185,187,189,190,192,193,195,195,196,197,198,199,199,
	200,199,200,200,201,200,200,200,199,199,198,198,197,196,196,194,
	193,192,191,189,187,186,185,182,180,179,177,183,191,199,207,214,
	222,230,238,245,253,245,238,230,222,214,206,199,191,183,176,168,
	161,153,145,137,129,121,114,106,99,90,83,75,68,60,52,44,
	36,29,22,17,11,6,4,11,18,25,32,39,45,52,58,66,
	73,80,86,93,99,106,113,120,126,133,140,147,154,161,167,174,
	181,188,194,201,208,214,221,215,207,201,207,213,220,216,209,202,
	195,189,182,175,168,161,154,147,140,133,126,118,111,104,97,90,
	16,24,31,39,46,54,61,69,75,82,90,98,104,112,118,126,
	132,140,146,154,161,168,175,184,191,199,207,214,222,230,237,245,
	253,245,238,229,222,214,206,199,191,183,176,168,160,152,145,137,
	129,121,114,106,98,90,83,75,67,60,52,44,37,30,25,20,
	15,9,6,13,21,29,36,44,52,60,68,75,83,90,99,107,
	114,122,129,138,145,153,160,168,176,183,191,199,207,214,222,230,
	238,246,253,245,237,230,223,215,207,198,191,183,175,168,165,168,
	169,171,173,174,176,178,179,181,181,182,184,184,186,187,187,187,
	188,188,189,189,188,189,188,188,188,187,187,186,185,185,184,183,
	182,180,179,178,177,175,173,171,169,168,176,184,191,199,206,214,
	222,230,237,246,253,245,237,230,222,214,206,199,191,183,176,168,
	160,152,145,137,129,122,114,106,99,91,83,75,68,60,52,44,
	37,29,21,14,6,1,5,12,18,25,32,38,46,52,59,65,
	73,79,86,93,99,106,113,120,127,133,140,147,153,160,167,173,
	180,187,194,201,207,214,221,214,208,207,214,221,215,209,201,195,
	188,181,174,167,160,153,147,139,132,126,119,111,104,98,90,83,
	10,17,24,32,40,47,54,61,68,76,83,91,98,107,114,122,
	130,137,145,153,160,168,176,183,192,199,207,214,222,230,238,245,
	253,245,238,230,222,214,207,199,191,184,175,168,160,153,145,137,
	129,121,114,106,98,90,83,75,68,60,54,49,44,39,34,28,
	23,18,13,13,21,29,37,45,52,59,68,75,83,91,98,106,
	114,122,130,137,144,153,161,168,175,184,191,199,206,214,222,230,
	237,245,253,246,237,230,222,215,207,199,191,184,176,168,160,156,
	158,159,162,163,165,166,167,169,171,172,173,173,174,174,175,176,
	177,177,177,177,177,177,177,176,176,176,176,175,174,173,173,171,
	171,169,168,167,165,164,162,160,160,168,176,183,192,199,206,214,
	222,230,237,246,253,245,238,230,222,215,206,199,191,184,175,168,
	160,152,145,137,129,122,114,106,98,91,83,75,68,59,52,44,
	37,29,22,14,6,9,14,18,24,29,34,38,45,52,59,66,
	72,79,86,92,99,106,113,119,126,134,140,147,153,160,167,174,
	181,187,194,201,208,214,221,214,209,215,221,214,207,201,194,188,
	180,174,167,161,154,147,140,133,125,119,111,104,97,90,83,76,
	5,14,21,29,36,45,52,60,67,75,83,91,98,106,114,121,
	130,137,145,152,160,168,175,184,191,199,207,215,222,230,237,246,
	253,246,237,230,222,214,207,199,192,184,176,168,161,152,145,137,
	129,122,114,106,98,91,85,78,73,68,63,58,52,47,42,37,
	32,27,22,18,21,29,37,44,52,60,68,75,83,90,98,106,
	114,122,129,137,145,152,160,168,176,183,191,199,206,214,222,230,
	238,246,253,245,238,230,222,215,207,199,191,183,175,168,161,152,
	146,148,150,152,154,155,157,158,159,160,161,162,163,164,164,164,
	166,165,166,166,165,166,166,165,165,164,164,163,162,162,161,160,
	158,157,157,155,154,152,150,153,160,168,176,183,192,198,206,214,
	222,230,237,246,253,245,237,230,222,214,207,199,191,183,176,168,
	161,152,145,137,129,121,114,107,98,90,83,75,67,59,52,44,
	36,29,22,13,12,17,22,27,32,37,42,47,52,57,63,68,
	73,79,86,93,99,106,113,120,126,133,140,147,153,160,167,173,
	180,188,194,201,207,214,221,215,216,220,213,206,200,193,187,180,
	173,167,160,153,146,139,132,125,119,112,105,98,90,83,76,68,
	6,14,21,29,36,44,52,60,67,76,83,91,99,106,114,122,
	130,137,145,152,160,168,176,184,192,199,207,214,222,230,237,246,
	253,245,238,230,222,215,207,199,191,183,175,168,160,153,145,137,
	130,122,115,109,103,98,93,88,82,77,72,66,61,56,50,46,
	41,36,31,26,21,29,37,45,52,60,68,75,83,91,98,106,
	114,122,129,137,144,153,160,168,175,183,191,199,207,214,222,230,
	237,245,253,245,238,230,222,214,207,199,191,184,175,168,160,153,
	145,137,139,141,142,144,145,146,148,149,150,150,151,152,153,153,
	153,154,154,154,154,155,154,154,153,153,152,152,151,150,150,148,
	148,146,145,143,142,141,145,153,160,168,175,183,191,199,207,215,
	223,230,238,245,253,246,238,230,222,214,207,199,191,183,176,168,
	160,152,145,137,129,122,114,106,98,91,83,76,68,60,52,44,
	37,29,21,17,21,26,31,36,41,46,51,56,60,66,72,77,
	82,87,93,98,104,110,115,121,127,133,140,147,153,160,167,173,
	181,187,194,201,208,214,221,218,219,212,205,199,192,186,179,173,
	166,159,152,145,139,132,125,118,112,104,98,90,83,76,69,61,
	6,14,21,29,36,44,52,59,67,75,83,91,99,107,114,122,
	130,137,145,152,160,168,176,184,191,199,206,214,222,230,238,246,
	253,245,238,230,222,215,207,199,192,183,176,168,160,152,146,140,
	134,129,124,117,112,106,101,96,90,85,80,75,69,64,59,55,
	49,45,39,35,30,29,37,44,52,59,67,75,83,90,98,106,
	114,122,129,137,144,152,160,168,175,183,191,199,206,215,222,230,
	238,245,253,245,238,230,222,215,206,199,191,183,176,168,161,153,
	145,137,129,129,130,133,134,135,136,137,138,139,140,140,142,142,
	142,142,143,143,143,143,143,143,142,142,141,140,140,139,138,137,
	136,135,134,133,131,137,145,153,161,168,175,183,192,199,207,215,
	222,230,237,245,253,245,237,230,222,215,206,199,191,184,176,168,
	161,153,144,137,130,122,114,106,98,91,83,76,68,60,52,45,
	36,29,21,26,30,35,40,44,50,54,59,65,69,75,80,85,
	90,96,101,106,112,118,124,129,134,140,146,152,158,164,170,176,
	182,188,194,200,208,214,221,217,211,205,198,191,185,178,172,166,
	159,152,145,138,131,125,118,111,104,98,91,83,76,69,62,55,
	6,13,21,29,37,45,52,60,68,76,83,91,99,106,113,122,
	129,137,145,153,161,168,176,183,191,199,207,214,222,230,237,246,
	253,245,238,230,222,215,206,199,191,184,178,172,165,160,154,148,
	143,137,132,126,120,115,109,104,98,94,88,83,78,73,68,63,
	58,53,48,44,39,34,37,45,52,60,67,76,83,91,99,106,
	114,121,130,137,145,152,160,168,176,184,191,199,207,214,222,230,
	238,245,253,245,238,230,223,214,206,199,191,183,176,168,161,153,
	145,138,129,122,120,121,123,123,125,126,127,127,129,129,129,130,
	131,131,131,132,132,131,131,131,131,131,129,129,128,128,127,125,
	125,124,122,122,129,137,144,152,160,168,176,183,192,199,206,214,
	222,230,237,246,253,245,237,230,222,214,206,199,191,184,176,168,
	160,152,145,137,129,122,114,106,99,90,83,75,68,60,53,44,
	37,29,30,35,39,44,49,53,58,64,68,73,78,84,88,94,
	99,104,109,115,120,126,131,137,143,149,154,160,165,172,177,184,
	190,195,201,208,214,221,221,215,208,201,194,187,181,174,167,160,
	153,147,140,134,126,120,113,106,100,93,86,79,72,65,59,52,
	6,13,22,29,37,45,53,60,68,76,83,91,98,106,114,121,
	130,137,145,153,161,168,176,183,191,199,207,214,222,230,238,245,
	253,245,237,230,222,216,210,204,198,191,186,180,175,168,162,156,
	151,145,140,134,128,123,118,113,108,102,97,92,87,81,77,72,
	67,62,57,53,48,43,39,44,52,60,68,76,83,90,99,106,
	113,121,129,138,145,152,160,168,175,184,192,199,206,214,222,229,
	238,245,253,245,238,230,222,215,207,199,191,184,176,168,160,152,
	144,137,129,121,114,110,111,112,114,114,116,116,117,118,119,119,
	119,120,120,120,120,120,120,120,119,119,118,117,117,116,115,115,
	114,113,114,121,129,137,145,153,160,168,175,184,192,199,206,214,
	222,230,237,245,253,246,237,230,222,214,206,199,191,183,176,168,
	160,152,145,138,129,121,114,106,98,90,83,76,67,60,52,44,
	37,34,38,43,48,52,58,63,67,72,77,82,87,91,97,103,
	108,112,118,123,129,134,140,145,151,157,162,168,174,180,186,192,
	197,204,210,216,220,214,221,214,208,201,194,187,181,174,167,161,
	153,147,140,134,127,120,113,106,100,92,86,79,73,66,58,52,
	6,13,21,29,37,45,52,60,68,75,83,91,98,107,114,122,
	129,138,145,152,160,168,176,183,191,199,207,214,222,230,238,245,
	253,245,238,230,222,219,217,212,206,200,193,188,182,177,171,165,
	159,154,148,143,138,131,127,121,116,110,105,101,95,91,86,81,
	76,71,67,61,57,53,48,44,52,60,68,76,83,91,98,107,
	114,121,130,137,145,153,161,168,176,184,191,199,206,214,222,230,
	238,245,253,245,237,230,222,215,207,199,191,183,175,168,160,153,
	145,137,130,122,114,106,100,101,102,103,104,105,105,107,107,108,
	108,108,108,109,109,109,109,108,108,107,107,106,106,104,104,103,
	102,106,114,121,129,138,144,153,160,168,175,183,191,199,207,215,
	222,229,238,245,253,245,237,230,222,215,207,199,191,183,176,168,
	161,152,145,137,129,122,114,106,98,91,83,75,68,60,52,44,
	39,43,48,52,57,61,66,71,75,81,86,90,95,100,105,111,
	116,121,126,132,137,143,148,153,159,165,170,177,183,188,194,200,
	206,212,218,218,212,214,221,215,208,201,194,188,180,174,167,160,
	154,146,140,133,127,120,113,107,100,93,86,79,73,66,59,52,
	6,14,21,29,37,45,52,60,68,76,83,90,98,106,114,122,
	130,138,145,152,160,168,176,184,191,199,207,215,222,230,238,245,
	253,245,237,230,222,214,217,220,214,208,202,197,190,184,179,173,
	168,162,157,151,145,140,135,130,125,120,114,109,104,99,94,90,
	85,80,75,71,66,62,57,52,53,60,68,75,83,90,99,107,
	114,122,129,137,145,152,160,168,176,184,191,199,207,214,222,230,
	238,246,253,245,238,230,222,214,207,199,192,183,176,168,161,152,
	145,137,129,121,114,106,98,91,90,91,92,94,95,95,96,96,
	96,97,97,98,97,97,97,97,97,96,95,95,95,94,93,92,
	98,106,114,121,130,137,145,153,160,168,176,183,191,199,207,214,
	222,230,237,245,253,245,237,229,222,215,207,199,192,184,176,168,
	160,153,145,137,129,121,114,106,98,91,83,76,67,60,52,44,
	48,52,57,61,66,71,75,80,85,89,94,100,104,109,115,119,
	125,130,135,141,146,151,157,162,168,173,179,185,191,196,202,208,
	214,219,216,210,208,214,221,215,208,201,194,188,180,174,167,160,
	154,147,140,133,126,120,113,106,100,93,86,79,73,66,59,52,
	6,14,21,29,37,44,52,60,68,75,83,91,99,106,114,122,
	130,137,145,153,160,168,175,184,191,199,207,214,222,230,238,245,
	253,245,237,230,222,215,208,215,220,216,211,205,199,193,188,182,
	176,171,165,159,155,149,144,138,133,128,123,118,113,108,103,98,
	93,89,84,79,74,70,65,61,57,60,68,75,83,91,99,106,
	114,122,129,137,145,153,160,168,176,183,191,199,207,214,222,230,
	238,245,253,246,237,229,222,214,207,199,192,184,176,168,161,152,
	145,137,130,122,113,106,98,90,83,80,81,82,83,84,84,85,
	85,85,86,86,85,86,85,85,85,84,84,84,82,82,83,91,
	98,106,114,121,130,137,145,153,160,168,176,184,192,199,206,214,
	222,230,238,245,253,246,238,230,222,214,207,199,191,184,176,168,
	161,153,145,137,129,122,114,106,98,91,83,75,67,60,53,52,
	57,61,66,70,74,80,84,89,93,98,103,108,112,118,123,128,
	134,138,144,149,154,159,165,171,176,182,187,193,198,205,210,216,
	220,214,209,202,207,214,221,215,207,201,194,187,180,174,167,160,
	153,146,140,133,126,120,113,107,99,92,86,80,72,66,59,52,
	6,13,21,29,37,45,52,60,68,75,83,91,99,106,114,122,
	129,137,144,152,161,168,176,184,192,199,207,215,222,230,238,245,
	253,245,238,230,222,214,207,206,212,218,218,213,207,202,195,190,
	184,179,174,168,163,157,152,147,141,136,132,126,121,117,111,107,
	102,98,93,88,84,79,74,71,66,62,68,76,83,91,99,106,
	114,121,130,137,145,152,160,168,176,183,191,199,206,215,222,229,
	237,246,253,245,238,230,222,214,207,199,191,184,176,168,160,153,
	145,137,129,122,114,106,98,91,83,76,70,71,72,72,72,74,
	73,73,74,74,74,75,74,74,73,73,72,72,71,76,83,91,
	99,106,114,122,129,137,145,152,160,168,175,183,192,199,207,214,
	222,230,238,246,253,245,238,229,222,215,207,199,191,184,176,168,
	160,152,145,137,129,122,114,107,99,90,83,76,67,60,58,62,
	66,71,75,79,83,88,92,97,102,107,111,116,121,127,131,136,
	142,147,152,158,162,168,174,179,184,189,195,201,207,213,219,218,
	213,207,200,201,208,215,221,214,207,201,194,188,180,173,167,160,
	154,147,140,134,127,120,113,106,100,92,86,79,72,66,59,53,
	6,14,21,29,37,45,52,60,67,75,83,90,98,106,114,121,
	129,137,145,153,161,168,176,184,191,199,207,214,222,230,238,245,
	253,245,238,230,222,214,206,198,204,210,216,220,215,209,204,198,
	193,187,181,177,171,166,160,156,150,145,140,135,131,125,121,115,
	111,106,102,97,93,88,84,79,75,71,67,75,83,91,98,106,
	114,121,130,137,145,153,161,168,176,183,192,199,207,214,222,229,
	238,245,253,245,237,230,222,215,207,199,192,184,176,168,160,153,
	144,137,129,122,114,106,98,91,83,75,67,60,60,60,61,62,
	62,63,63,62,63,63,63,62,62,62,61,61,67,75,83,91,
	99,107,114,122,130,137,145,152,161,168,176,184,192,199,207,214,
	223,230,237,245,253,245,237,230,222,214,206,199,191,183,175,168,
	160,152,145,137,129,122,114,106,99,90,83,76,67,62,66,71,
	75,80,84,88,93,97,102,106,111,116,121,126,130,135,140,145,
	151,155,161,166,171,176,182,188,193,198,204,210,215,220,216,210,
	204,198,194,201,207,215,221,214,207,201,194,188,181,174,167,160,
	153,146,140,133,126,120,113,106,100,93,86,79,73,65,59,52,
	5,13,21,29,37,45,53,60,68,75,83,90,99,106,114,121,
	129,138,144,153,160,168,176,184,191,199,207,214,222,230,238,245,
	253,246,238,230,222,214,207,199,196,201,207,213,218,217,212,206,
	201,196,191,185,179,174,169,164,159,154,148,143,139,134,130,125,
	120,115,111,106,102,97,93,89,84,80,76,75,83,91,99,106,
	114,122,129,137,144,153,160,168,175,184,191,199,207,214,222,230,
	238,245,253,246,238,230,222,214,207,199,191,184,176,168,160,152,
	144,137,129,121,114,106,98,91,83,75,67,59,52,49,49,50,
	51,51,51,51,51,51,51,51,50,51,52,60,67,75,83,91,
	99,106,114,121,129,137,144,152,161,168,176,183,191,199,207,214,
	222,230,237,245,253,246,237,230,222,214,206,199,191,184,175,168,
	160,153,145,137,129,122,114,106,99,91,83,75,68,72,76,80,
	84,88,92,97,102,106,110,115,119,124,129,134,139,144,149,153,
	159,164,169,175,179,185,190,196,202,206,212,218,219,213,207,202,
	196,190,194,201,208,215,221,214,208,200,194,187,181,174,167,160,
	153,147,140,134,126,120,113,106,99,93,86,80,72,65,59,52,
	6,13,21,28,37,44,52,60,67,75,83,91,98,106,114,122,
	129,137,145,152,161,168,175,184,191,199,206,214,222,230,237,245,
	253,245,238,229,223,214,206,199,191,194,199,205,211,216,220,215,
	209,204,199,194,188,183,178,172,167,162,158,153,148,143,138,133,
	128,124,119,115,111,106,102,98,94,90,85,81,83,91,99,106,
	114,122,130,137,145,153,161,168,175,183,192,199,206,214,223,230,
	237,245,253,246,238,230,222,214,206,199,192,184,176,168,160,153,
	145,137,130,122,114,107,99,90,83,76,67,60,52,44,38,38,
	39,40,40,40,39,40,40,40,39,44,52,60,67,75,83,91,
	98,106,114,122,130,137,145,152,161,168,175,184,191,199,206,214,
	222,230,237,245,255,245,237,230,223,215,207,199,191,183,175,168,
	161,153,145,137,129,121,113,106,99,91,83,75,77,81,85,89,
	93,98,101,106,111,115,119,124,129,133,138,143,147,153,157,163,
	168,173,178,183,188,193,199,204,209,215,220,216,211,205,200,194,
	188,187,194,201,208,214,222,215,208,201,194,187,180,174,167,160,
	154,147,140,133,127,119,113,106,100,93,86,79,72,66,59,52
	};

NS_MIA_END
