/*
 * MediathekView
 * Copyright (C) 2008 W. Xaver
 * W.Xaver[at]googlemail.com
 * http://zdfmediathk.sourceforge.net/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package msearch.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.tool.MSConfig;

public class PanelSenderSearch extends JPanel {

    private JButton[] buttonSender;
    private final String[] senderArray;
    private final MSearchGuiLoad filmeLaden;

    public PanelSenderSearch(MSearchGuiLoad filmeLaden_) {
        super();
        initComponents();
        filmeLaden = filmeLaden_;
        jLabelAnzahl.setText("");
        senderArray = filmeLaden.getSenderNamen();
        buttonSender = new JButton[senderArray.length];
        for (int i = 0; i < filmeLaden.getSenderNamen().length; ++i) {
            buttonSender[i] = new JButton(senderArray[i]);
            buttonSender[i].addActionListener(new BeobSenderLaden(senderArray[i]));
        }

        addSender();

        jButtonStop.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                MSConfig.setStop(true);
            }
        });

        filmeLaden.addAdListener(new MSListenerFilmeLaden() {
            @Override
            public void progress(MSListenerFilmeLadenEvent event) {
                if (event.max == 0) {
                    jProgressBar1.setIndeterminate(true);
                    jProgressBar1.setMaximum(0);
                    jProgressBar1.setMinimum(0);
                    jProgressBar1.setValue(0);
                    jProgressBar1.setStringPainted(false);
                } else {
                    jProgressBar1.setIndeterminate(false);
                    jProgressBar1.setMaximum(event.max);
                    jProgressBar1.setMinimum(0);
                    jProgressBar1.setValue(event.progress);
                    jProgressBar1.setStringPainted(true);
                }
                jLabelProgress.setText(textLaenge(80, event.text, true /* mitte */, false /*addVorne*/));
                jLabelAnzahl.setText(event.count + "");
            }

            @Override
            public void fertig(MSListenerFilmeLadenEvent event) {
                jProgressBar1.setIndeterminate(false);
                jProgressBar1.setMaximum(0);
                jProgressBar1.setMinimum(0);
                jProgressBar1.setValue(0);
                jProgressBar1.setStringPainted(false);
                jLabelProgress.setText("");
                MSearchGui.jLabelAnzahl.setText(MSearchGui.listeFilme.size() + "");

                for (JButton button : buttonSender) {
                    button.setEnabled(true);
                }
            }
        });
    }

    private void addSender() {
        panelSender.removeAll();
        panelSender.setLayout(new GridLayout(0, 5));
        int nr = 0;
        for (String sender : senderArray) {
            JButton btn = buttonSender[nr];
            btn.setText(sender);
            panelSender.add(btn);
            ++nr;
        }
        panelSender.repaint();
    }

    private static String textLaenge(int max, String text, boolean mitte, boolean addVorne) {
        if (text.length() > max) {
            if (mitte) {
                text = text.substring(0, 25) + " .... " + text.substring(text.length() - (max - 31));
            } else {
                text = text.substring(0, max - 1);
            }
        }
        while (text.length() < max) {
            if (addVorne) {
                text = " " + text;
            } else {
                text = text + " ";
            }
        }
        return text;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        panelSender = new javax.swing.JPanel();
        jProgressBar1 = new javax.swing.JProgressBar();
        jLabelProgress = new javax.swing.JLabel();
        jButtonStop = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabelAnzahl = new javax.swing.JLabel();

        panelSender.setBorder(javax.swing.BorderFactory.createTitledBorder("Sender"));

        javax.swing.GroupLayout panelSenderLayout = new javax.swing.GroupLayout(panelSender);
        panelSender.setLayout(panelSenderLayout);
        panelSenderLayout.setHorizontalGroup(
            panelSenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 152, Short.MAX_VALUE)
        );
        panelSenderLayout.setVerticalGroup(
            panelSenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 72, Short.MAX_VALUE)
        );

        jLabelProgress.setText("Fortschritt!");

        jButtonStop.setText("Stop");
        jButtonStop.setToolTipText("Abbrechen");

        jLabel1.setText("Anzahl Filme (Suchen):");

        jLabelAnzahl.setText("-1");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelProgress, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jProgressBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 507, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonStop))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(panelSender, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabelAnzahl)))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(panelSender, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 262, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jProgressBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonStop))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelProgress)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabelAnzahl))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonStop, jProgressBar1});

    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonStop;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelAnzahl;
    private javax.swing.JLabel jLabelProgress;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JPanel panelSender;
    // End of variables declaration//GEN-END:variables

    private class BeobSenderLaden implements ActionListener {

        private final String sender;

        public BeobSenderLaden(String ssender) {
            sender = ssender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            jLabelProgress.setText("");
            jLabelAnzahl.setText("");
            for (JButton aButtonSender : buttonSender) {
                aButtonSender.setEnabled(false);
            }
            filmeLaden.updateSender(new String[]{sender} /* senderAllesLaden */);
        }
    }

}
