# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.interactor_observer import InteractorObserver


class OrientationMarkerWidget(InteractorObserver):
    r"""
    OrientationMarkerWidget - 2D widget for manipulating a marker prop
    
    Superclass: InteractorObserver
    
    This class provides support for interactively manipulating the
    position, size, and apparent orientation of a prop that represents an
    orientation marker.  This class works by adding its internal renderer
    to an external "parent" renderer on a different layer.  The input
    orientation marker is rendered as an overlay on the parent renderer
    and, thus, appears superposed over all props in the parent's scene. 
    The camera view of the orientation the marker is made to match that
    of the parent's by means of an observer mechanism, giving the
    illusion that the orientation of the marker reflects that of the
    prop(s) in the parent's scene.
    
    The widget listens to left mouse button and mouse movement events. It
    will change the cursor shape based on its location. If the cursor is
    over the overlay renderer, it will change the cursor shape to a
    SIZEALL shape or to a resize corner shape (e.g., SIZENW) if the
    cursor is near a corner. If the left mouse button is pressed and held
    down while moving, the overlay renderer, and hence, the orientation
    marker, is resized or moved.  I the case of a resize operation,
    releasing the left mouse button causes the widget to enforce its
    renderer to be square.  The diagonally opposite corner to the one
    moved is repositioned such that all edges of the renderer have the
    same length: the minimum.
    
    To use this object, there are two key steps: 1) invoke
    set_interactor() with the argument of the method a
    RenderWindowInteractor, and 2) invoke set_orientation_marker with an
    instance of Prop (see caveats below). Specifically, AxesActor
    and AnnotatedCubeActor are two classes designed to work with this
    class.  A composite orientation marker can be generated by adding
    instances of AxesActor and AnnotatedCubeActor to a
    PropAssembly, which can then be set as the input orientation
    marker. The widget can be also be set up in a non-interactive fashion
    by setting Ineractive to Off and sizing/placing the overlay renderer
    in its parent renderer by calling the widget's set_viewport method.
    
    @par Thanks: This class was based originally on Paraview's
    PVAxesWidget.
    
    @warning
    The input orientation marker prop should calculate its bounds as
    though they are symmetric about it's origin.  This must currently be
    done to correctly implement the camera synchronization between the
    ivar renderer and the renderer associated with the set interactor. 
    Importantly, the interactor_style associated with the interactor must
    be of the type InteractorStyle*Camera. Where desirable, the parent
    renderer should be set by the set_default_renderer method.  The parent
    renderer's number of layers is modified to 2 where required.
    
    @sa
    InteractorObserver XYPlotWidget ScalarBarWidget AxesActor
    AnnotatedCubeActor
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOrientationMarkerWidget, obj, update, **traits)
    
    interactive = tvtk_base.true_bool_trait(desc=\
        r"""
        Set/get whether to allow this widget to be interactively
        moved/scaled. Default is On.
        """
    )

    def _interactive_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractive,
                        self.interactive_)

    def _get_orientation_marker(self):
        return wrap_vtk(self._vtk_obj.GetOrientationMarker())
    def _set_orientation_marker(self, arg):
        old_val = self._get_orientation_marker()
        self._wrap_call(self._vtk_obj.SetOrientationMarker,
                        deref_vtk(arg))
        self.trait_property_changed('orientation_marker', old_val, arg)
    orientation_marker = traits.Property(_get_orientation_marker, _set_orientation_marker, desc=\
        r"""
        
        """
    )

    outline_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Set/get the color of the outline of this widget.  The outline is
        visible when (in interactive mode) the cursor is over this
        widget. Default is white (1,1,1).
        """
    )

    def _outline_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutlineColor,
                        self.outline_color, False)

    should_constrain_size = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get whether the widget should constrain the size to be within
        the min and max limits. Default is off (unconstrained).
        """
    )

    def _should_constrain_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShouldConstrainSize,
                        self.should_constrain_size)

    tolerance = traits.Trait(7, traits.Range(1, 10, enter_set=True, auto_set=False), desc=\
        r"""
        The tolerance representing the distance to the widget (in pixels)
        in which the cursor is considered to be on the widget, or on a
        widget feature (e.g., a corner point or edge).
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    viewport = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 0.2, 0.2), cols=3, desc=\
        r"""
        Set/get the viewport to position/size this widget. Coordinates
        are expressed as (xmin,ymin,xmax,ymax), where each coordinate is
        0 <= coordinate <= 1.0. Default is bottom left corner
        (0,0,0.2,0.2). Note that this viewport is scaled with respect to
        the viewport of the current renderer i.e. if the viewport of the
        current renderer is (0.5, 0.5, 0.75, 0.75) and Viewport is set to
        (0, 0, 1, 1), the orientation marker will be confined to a
        viewport of (0.5, 0.5, 0.75, 0.75) in the render window.
        \sa set_current_renderer()
        """
    )

    def _viewport_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetViewport,
                        self.viewport)

    zoom = traits.Trait(1.0, traits.Range(0.1, 10.0, enter_set=True, auto_set=False), desc=\
        r"""
        The zoom factor to modify the size of the marker within the
        widget. Default is 1.0.
        """
    )

    def _zoom_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetZoom,
                        self.zoom)

    def _get_max_dimension_size(self):
        return self._vtk_obj.GetMaxDimensionSize()
    max_dimension_size = traits.Property(_get_max_dimension_size, desc=\
        r"""
        Returns the maximum dimension (width and height) size limit in
        pixels for the widget.
        """
    )

    def _get_min_dimension_size(self):
        return self._vtk_obj.GetMinDimensionSize()
    min_dimension_size = traits.Property(_get_min_dimension_size, desc=\
        r"""
        Returns the minimum dimension (width and height) size limit in
        pixels for the widget.
        """
    )

    def end_interaction(self):
        """
        end_interaction(self) -> None
        
        Ends any in progress interaction and resets border visibility
        """
        ret = self._vtk_obj.EndInteraction()
        return ret
        

    def execute_camera_update_event(self, *args):
        """
        execute_camera_update_event(self, o:Object, event:int,
            calldata:Pointer) -> None
        C++: void execute_camera_update_event(Object *o,
            unsigned long event, void *calldata)
        Callback to keep the camera for the orientation marker up to date
        with the camera in the parent renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ExecuteCameraUpdateEvent, *my_args)
        return ret

    def set_size_constraint_dimension_sizes(self, *args):
        """
        set_size_constraint_dimension_sizes(self, minDimensionSize:int,
            maxDimensionSize:int) -> bool
        C++: bool set_size_constraint_dimension_sizes(
            const int minDimensionSize, const int maxDimensionSize)
        Sets the minimum and maximum dimension (width and height) size
        limits for the widget. Validates the sizes are within tolerances
        before setting; ignoring otherwise. Default is 20, 500. Returns
        whether the sizes are valid and correctly set (true), or invalid
        (false).
        """
        ret = self._wrap_call(self._vtk_obj.SetSizeConstraintDimensionSizes, *args)
        return ret

    _updateable_traits_ = \
    (('interactive', 'GetInteractive'), ('enabled', 'GetEnabled'),
    ('key_press_activation', 'GetKeyPressActivation'), ('picking_managed',
    'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('outline_color', 'GetOutlineColor'), ('should_constrain_size',
    'GetShouldConstrainSize'), ('tolerance', 'GetTolerance'), ('viewport',
    'GetViewport'), ('zoom', 'GetZoom'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('priority', 'GetPriority'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'enabled', 'global_warning_display', 'interactive',
    'key_press_activation', 'picking_managed',
    'key_press_activation_value', 'object_name', 'outline_color',
    'priority', 'should_constrain_size', 'tolerance', 'viewport', 'zoom'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OrientationMarkerWidget, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OrientationMarkerWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enabled', 'interactive', 'key_press_activation',
            'picking_managed'], [], ['key_press_activation_value', 'object_name',
            'outline_color', 'priority', 'should_constrain_size', 'tolerance',
            'viewport', 'zoom']),
            title='Edit OrientationMarkerWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OrientationMarkerWidget properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

