/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _HTTP_CLIENT_INTERNALS_H_
#define _HTTP_CLIENT_INTERNALS_H_

#ifdef HAVE_LIBSOUP22_SOLARIS
#include <libsoup/soup-session-sync.h>
#else
#include <libsoup/soup-session-async.h>
#endif

#include <libsoup/soup-uri.h>
#ifndef HAVE_LIBSOUP22
#include <libsoup/soup-auth.h>
#endif

typedef struct SmlTransportHttpClientEnv {
#ifdef HAVE_LIBSOUP22
	SoupUri *uri;
#else
	SoupURI *uri;
#endif
	SoupSession *session;
	SmlTransport *tsp;
	uint16_t port;
	char *url;
	char *proxy;
	char *username;
	char *password;
	char *cafile;

	SmlBool connectDone;
	SmlBool disconnectDone;
} SmlTransportHttpClientEnv;

SmlBool smlTransportHttpClientNew(SmlTransport *tsp, SmlError **error);

#endif //_HTTP_CLIENT_INTERNALS_H_
