/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javascript2.doc;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.javascript2.doc.spi.AnnotationCompletionTagProvider;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationProvider;
import org.netbeans.modules.javascript2.doc.spi.SyntaxProvider;
import org.netbeans.modules.parsing.api.Snapshot;

/**
 * This is fallback instance of the {@link JsDocumentationProvider}. It enables to not
 * return {@code null} values anywhere where the {@code JsDocumentationProvider} is needed.
 *
 * @author Martin Fousek <marfous@netbeans.org>
 */
public final class JsDocumentationFallbackProvider implements JsDocumentationProvider {

    @Override
    public Set getSupportedTags() {
        return Collections.emptySet();
    }

    @Override
    public JsDocumentationHolder createDocumentationHolder(Snapshot snapshot) {
        return new JsDocumentationFallbackHolder(this, snapshot);
    }

    @Override
    public List<AnnotationCompletionTagProvider> getAnnotationsProvider() {
        return Collections.<AnnotationCompletionTagProvider>emptyList();
    }

    @Override
    public SyntaxProvider getSyntaxProvider() {
        return null;
    }

}
