/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tst_hud.h"

#include "../../src/hud.h"

#include <QtTest/QtTest>

void
TestHUD::contextOperations()
{
    Ubuntu::HUD::HUD hud;
    Ubuntu::HUD::Context *ctx1;
    Ubuntu::HUD::Context *ctx2;

    QList<Ubuntu::HUD::Context *>contexts;

    contexts = hud.contexts();
    QVERIFY(contexts.isEmpty());

    QSignalSpy changed_spy(&hud, SIGNAL(contextsChanged()));
    QSignalSpy added_spy(&hud, SIGNAL(contextAdded(Context*)));
    QSignalSpy removed_spy(&hud, SIGNAL(contextRemoved(Context*)));

    ctx1 = new Ubuntu::HUD::Context(&hud);
    ctx1->setIdentifier("Context1");
    ctx2 = new Ubuntu::HUD::Context(&hud);
    ctx2->setIdentifier("Context2");

    hud.addContext(ctx1);
    hud.addContext(ctx2);

    contexts = hud.contexts();
    QCOMPARE(contexts.count(), 2);
    QCOMPARE(changed_spy.count(), 2);
    QCOMPARE(added_spy.count(), 2);
    QVERIFY(contexts.contains(ctx1));
    QVERIFY(contexts.contains(ctx2));

    hud.removeContext(ctx1);
    QCOMPARE(hud.contexts().count(), 1);
    QCOMPARE(changed_spy.count(), 3);
    QCOMPARE(removed_spy.count(), 1);

    hud.setActiveContext(ctx1);
}

void
TestHUD::_register()
{
    QSKIP("not implemented.");
}
