/***************************************************************************
               priv-ips.cpp  -  test CNetAddr::IsPrivateI4()
                             -------------------
    begin                : Thu Dec 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * If it was broken for big-endian arch then so was DC++.
 */
#include <dclib/core/cnetaddr.h>

#include <stdio.h>

int main( int /* argc */, char*[] /* argv[] */ )
{
	const bool expected[4] = { false,true,true,false };
	
	const char * ips[4][4] = {
	 {"9.255.255.255",
	  "10.0.0.0",
	  "10.255.255.255",
	  "11.0.0.0"
	 },
	 {"126.255.255.255",
	  "127.0.0.0",
	  "127.255.255.255",
	  "128.0.0.0"
	 },
	 {"172.15.255.255",
	  "172.16.0.0",
	  "172.31.255.255",
	  "172.32.0.0"
	 },
	 {"192.167.255.255",
	  "192.168.0.0",
	  "192.168.255.255",
	  "192.169.0.0"
	 }
	};

	int failed = 0;
	
	for ( int i = 0; i < 4; ++i )
	{
		for ( int j = 0; j < 4; ++j )
		{
			/* printf("i=%d j=%d %s\n",i,j,ips[i][j]); */
			if ( CNetAddr::IsPrivateI4(ips[i][j]) != expected[j] )
			{
				printf( "failed for %s expected %d got %d\n", ips[i][j], expected[j], CNetAddr::IsPrivateI4(ips[i][j]) );
				++failed;
			}
		}
	}
	
	return failed;
}
