# -*- coding: utf-8 -*-
# Copyright (c) 2014-18 Richard Hull and contributors
# See LICENSE.rst for details.


from luma.core.const import common


class ssd1306(common):
    CHARGEPUMP = 0x8D
    COLUMNADDR = 0x21
    COMSCANDEC = 0xC8
    COMSCANINC = 0xC0
    EXTERNALVCC = 0x1
    MEMORYMODE = 0x20
    PAGEADDR = 0x22
    SETCOMPINS = 0xDA
    SETDISPLAYCLOCKDIV = 0xD5
    SETDISPLAYOFFSET = 0xD3
    SETHIGHCOLUMN = 0x10
    SETLOWCOLUMN = 0x00
    SETPRECHARGE = 0xD9
    SETSEGMENTREMAP = 0xA1
    SETSTARTLINE = 0x40
    SETVCOMDETECT = 0xDB
    SWITCHCAPVCC = 0x2


sh1106 = ssd1306


class ssd1322(common):
    DISPLAYON = 0xAF
    DISPLAYOFF = 0xAE
    SETCONTRAST = 0xC1


class ssd1362(common):
    DISPLAYON = 0xAF
    DISPLAYOFF = 0xAE
    SETCONTRAST = 0x81


class ws0010(object):
    """
    Values to be used by the ws0010 class during initialization of the display.
    Contains FONTDATA to enable the ws0010 class to embed the same fonts that
    are contained within any display that uses the ws0010 controller

    .. versionadded:: 3.6.0
    """
    CLEAR = 0x01
    HOME = 0x02
    ENTRY = 0x06
    DISPLAYOFF = 0x08
    DISPLAYON = 0x0C
    POWEROFF = 0x13
    POWERON = 0x17
    GRAPHIC = 0x08
    CHAR = 0x00
    FUNCTIONSET = 0x29
    DL8 = 0x10
    DL4 = 0x00
    DDRAMADDR = 0x80
    CGRAMADDR = 0x40
    FONTDATA = {
        'metrics': [
            # FT00 ENGLISH_JAPANESE 5x8 METRICS
            {
                'name': 'FT00',
                'index': range(16, 256),
                'xwidth': 6,
                'cell_size': (5, 10),
                'glyph_size': (5, 8),
                'table_size': (800, 20)
            },
            # FT01 WESTERN EUROPEAN 5x8 METRICS
            {
                'name': 'FT01',
                'index': range(16, 256),
                'xwidth': 6,
                'cell_size': (5, 10),
                'glyph_size': (5, 8),
                'table_size': (800, 20)
            },
            # FT10 ENGLISH_RUSSIAN 5x8 METRICS
            {
                'name': 'FT10',
                'index': range(16, 256),
                'xwidth': 6,
                'cell_size': (5, 10),
                'glyph_size': (5, 8),
                'table_size': (800, 20)
            },
            # FT11 WESTERN_EUROPEAN_II 5x8 METRICS
            {
                'name': 'FT11',
                'index': range(16, 256),
                'xwidth': 6,
                'cell_size': (5, 10),
                'glyph_size': (5, 8),
                'table_size': (800, 20)
            },
        ],
        # TODO: Complete (and verify) FONT Mappings (Issue #296)
        'mappings': [
            {   # FT00 ENGLISH_JAPANESE CHARACTER FONT
                # Missing maps for
                # 10-1F, 80-9f, a0, a1, e7, e9, ea, f8, f9, fa, fc, fe
                0x0410:   0x41,  # А CYRILLIC CAPITAL LETTER A
                0x0412:   0x42,  # В CYRILLIC CAPITAL LETTER VE
                0x0421:   0x43,  # С CYRILLIC CAPITAL LETTER ES
                0x0415:   0x45,  # Е CYRILLIC CAPITAL LETTER IE
                0x041d:   0x48,  # Н CYRILLIC CAPITAL LETTER EN
                0x041a:   0x4b,  # К CYRILLIC CAPITAL LETTER KA
                0x041c:   0x4d,  # М CYRILLIC CAPITAL LETTER EM
                0x041e:   0x4f,  # О CYRILLIC CAPITAL LETTER O
                0x0420:   0x50,  # Р CYRILLIC CAPITAL LETTER ER
                0x0422:   0x54,  # Т CYRILLIC CAPITAL LETTER TE
                0x0425:   0x58,  # Х CYRILLIC CAPITAL LETTER HA
                0x042c:   0x62,  # Ь CYRILLIC CAPITAL LETTER SOFT SIGN
                0x00a5:   0x5c,  # ¥ YEN SIGN
                0x2192:   0x7e,  # → RIGHTWARDS ARROW
                0x2190:   0x7f,  # ← LEFTWARDS ARROW
                0x300c:   0xa2,  # 「 LEFT CORNER BRACKET
                0x300d:   0xa3,  # 」 RIGHT CORNER BRACKET
                0x30fd:   0xa4,  # ヽ KATAKANA ITERATION MARK
                0x30f8:   0xa5,  # ヸ KATAKANA LETTER VI
                0x30f2:   0xa6,  # ヲ KATAKANA LETTER WO
                0x30a1:   0xa7,  # ァ KATAKANA LETTER SMALL A
                0x30a3:   0xa8,  # ィ KATAKANA LETTER SMALL I
                0x30a5:   0xa9,  # ゥ KATAKANA LETTER SMALL U
                0x30a7:   0xaa,  # ェ KATAKANA LETTER SMALL E
                0x30a9:   0xab,  # ォ KATAKANA LETTER SMALL O
                0x30e3:   0xac,  # ャ KATAKANA LETTER SMALL YA
                0x30e5:   0xad,  # ュ KATAKANA LETTER SMALL YU
                0x30e7:   0xae,  # ョ KATAKANA LETTER SMALL YO
                0x30c3:   0xaf,  # ッ KATAKANA LETTER SMALL TU
                0x30fc:   0xb0,  # ー KATAKANA-HIRAGANA PROLONGED SOUND MARK
                0x30a2:   0xb1,  # ア KATAKANA LETTER A
                0x30a4:   0xb2,  # イ KATAKANA LETTER I
                0x30a6:   0xb3,  # ウ KATAKANA LETTER U
                0x30a8:   0xb4,  # エ KATAKANA LETTER E
                0x30aa:   0xb5,  # オ KATAKANA LETTER O
                0x30ab:   0xb6,  # カ KATAKANA LETTER KA
                0x30ad:   0xb7,  # キ KATAKANA LETTER KI
                0x30af:   0xb8,  # ク KATAKANA LETTER KU
                0x30b1:   0xb9,  # ケ KATAKANA LETTER KE
                0x30b3:   0xba,  # コ KATAKANA LETTER KO
                0x30b5:   0xbb,  # サ KATAKANA LETTER SA
                0x30b7:   0xbc,  # シ KATAKANA LETTER SI
                0x30b9:   0xbd,  # ス KATAKANA LETTER SU
                0x30bb:   0xbe,  # セ KATAKANA LETTER SE
                0x30bd:   0xbf,  # ソ KATAKANA LETTER SO
                0x30bf:   0xc0,  # タ KATAKANA LETTER TA
                0x30c1:   0xc1,  # チ KATAKANA LETTER TI
                0x30c4:   0xc2,  # ツ KATAKANA LETTER TU
                0x30c6:   0xc3,  # テ KATAKANA LETTER TE
                0x30c8:   0xc4,  # ト KATAKANA LETTER TO
                0x30ca:   0xc5,  # ナ KATAKANA LETTER NA
                0x30cb:   0xc6,  # ニ KATAKANA LETTER NI
                0x30cc:   0xc7,  # ヌ KATAKANA LETTER NU
                0x30cd:   0xc8,  # ネ KATAKANA LETTER NE
                0x30ce:   0xc9,  # ノ KATAKANA LETTER NO
                0x30cf:   0xca,  # ハ KATAKANA LETTER HA
                0x30d2:   0xcb,  # ヒ KATAKANA LETTER HI
                0x30d5:   0xcc,  # フ KATAKANA LETTER HU
                0x30d8:   0xcd,  # ヘ KATAKANA LETTER HE
                0x30db:   0xce,  # ホ KATAKANA LETTER HO
                0x30de:   0xcf,  # マ KATAKANA LETTER MA
                0x30df:   0xd0,  # ミ KATAKANA LETTER MI
                0x30e0:   0xd1,  # ム KATAKANA LETTER MU
                0x30e1:   0xd2,  # メ KATAKANA LETTER ME
                0x30e2:   0xd3,  # モ KATAKANA LETTER MO
                0x30e4:   0xd4,  # ヤ KATAKANA LETTER YA
                0x30e6:   0xd5,  # ユ KATAKANA LETTER YU
                0x30e8:   0xd6,  # ヨ KATAKANA LETTER YO
                0x30e9:   0xd7,  # ラ KATAKANA LETTER RA
                0x30ea:   0xd8,  # リ KATAKANA LETTER RI
                0x30eb:   0xd9,  # ル KATAKANA LETTER RU
                0x30ec:   0xda,  # レ KATAKANA LETTER RE
                0x30ed:   0xdb,  # ロ KATAKANA LETTER RO
                0x30ef:   0xdc,  # ワ KATAKANA LETTER WA
                0x30f3:   0xdd,  # ン KATAKANA LETTER N
                0x309b:   0xde,  # ゛ KATAKANA-HIRAGANA VOICED SOUND MARK
                0x309c:   0xdf,  # ゜ KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
                0x03b1:   0xe0,  # α GREEK SMALL LETTER ALPHA
                0x00e4:   0xe1,  # ä LATIN SMALL LETTER A WITH DIAERESIS
                0x03b2:   0xe2,  # β GREEK SMALL LETTER BETA (5x10)
                0x0385:   0xe3,  # ΅ GREEK DIALYTIKA TONOS
                0x00b5:   0xe4,  # µ MICRO SIGN (5x10)
                0x03bc:   0xe4,  # μ GREEK SMALL LETTER MU (5x10)
                0x03c3:   0xe5,  # σ GREEK SMALL LETTER SIGMA
                0x03c1:   0xe6,  # ρ GREEK SMALL LETTER RHO (5x10)
                0x221a:   0xe8,  # √ SQUARE ROOT
                0x02e3:   0xeb,  # ˣ MODIFIER LETTER SMALL X
                0x00a2:   0xec,  # ¢ CENT SIGN
                0x2c60:   0xed,  # Ⱡ LATIN CAPITAL LETTER L WITH DOUBLE BAR
                0x00f1:   0xee,  # ñ LATIN SMALL LETTER N WITH TILDE
                0x00f6:   0xef,  # ö LATIN SMALL LETTER O WITH DIAERESIS
                0x0398:   0xf2,  # Θ GREEK CAPITAL LETTER THETA
                0x03f4:   0xf2,  # ϴ GREEK CAPITAL THETA SYMBOL
                0x221e:   0xf3,  # ∞ INFINITY
                0x03a9:   0xf4,  # Ω GREEK CAPITAL LETTER OMEGA
                0x00fc:   0xf5,  # ü LATIN SMALL LETTER U WITH DIAERESIS
                0x03a3:   0xf6,  # Σ GREEK CAPITAL LETTER SIGMA
                0x03c0:   0xf7,  # π GREEK SMALL LETTER PI
                0xa68b:   0xfb,  # ꚋ CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK
                0x00f7:   0xfd,  # ÷ DIVISION SIGN
                0x25ae:   0xff,  # ▮ BLACK VERTICAL RECTANGLE
            },

            {   # FT01 WESTERN EUROPEAN CHARACTER FONT
                # Missing mappings 9f, a0, aa, ab, ac, ad, ae, c5, c8
                # Dropping e1, e2, e3 conflict with 5x8 versions at be, bd, bf
                0x0410:   0x41,  # А CYRILLIC CAPITAL LETTER A
                0x0412:   0x42,  # В CYRILLIC CAPITAL LETTER VE
                0x0421:   0x43,  # С CYRILLIC CAPITAL LETTER ES
                0x0415:   0x45,  # Е CYRILLIC CAPITAL LETTER IE
                0x041d:   0x48,  # Н CYRILLIC CAPITAL LETTER EN
                0x041a:   0x4b,  # К CYRILLIC CAPITAL LETTER KA
                0x041c:   0x4d,  # М CYRILLIC CAPITAL LETTER EM
                0x041e:   0x4f,  # О CYRILLIC CAPITAL LETTER O
                0x0420:   0x50,  # Р CYRILLIC CAPITAL LETTER ER
                0x0422:   0x54,  # Т CYRILLIC CAPITAL LETTER TE
                0x0425:   0x58,  # Х CYRILLIC CAPITAL LETTER HA
                0x00a5:   0x5c,  # ¥ YEN SIGN
                0x042c:   0x62,  # Ь CYRILLIC CAPITAL LETTER SOFT SIGN
                0x2192:   0x7e,  # → RIGHTWARDS ARROW
                0x2190:   0x7f,  # ← LEFTWARDS ARROW
                0x00db:   0x80,  # Û LATIN CAPITAL LETTER U WITH CIRCUMFLEX
                0x00d9:   0x81,  # Ù LATIN CAPITAL LETTER U WITH GRAVE
                0x00da:   0x82,  # Ú LATIN CAPITAL LETTER U WITH ACUTE
                0x00dc:   0x83,  # Ü LATIN CAPITAL LETTER U WITH DIAERESIS
                0x00fb:   0x84,  # û LATIN SMALL LETTER U WITH CIRCUMFLEX
                0x00f9:   0x85,  # ù LATIN SMALL LETTER U WITH GRAVE
                0x00fa:   0x86,  # ú LATIN SMALL LETTER U WITH ACUTE
                0x00d4:   0x87,  # Ô LATIN CAPITAL LETTER O WITH CIRCUMFLEX
                0x00d2:   0x88,  # Ò LATIN CAPITAL LETTER O WITH GRAVE
                0x00d3:   0x89,  # Ó LATIN CAPITAL LETTER O WITH ACUTE
                0x00f4:   0x8b,  # ô LATIN SMALL LETTER O WITH CIRCUMFLEX
                0x00f2:   0x8c,  # ò LATIN SMALL LETTER O WITH GRAVE
                0x00f3:   0x8d,  # ó LATIN SMALL LETTER O WITH ACUTE
                0x00f6:   0x8e,  # ö LATIN SMALL LETTER O WITH DIAERESIS
                0x00bf:   0x8f,  # ¿ INVERTED QUESTION MARK
                0x00ca:   0x90,  # Ê LATIN CAPITAL LETTER E WITH CIRCUMFLEX
                0x00c8:   0x91,  # È LATIN CAPITAL LETTER E WITH GRAVE
                0x00c9:   0x92,  # É LATIN CAPITAL LETTER E WITH ACUTE
                0x00cb:   0x93,  # Ë LATIN CAPITAL LETTER E WITH DIAERESIS
                0x00ea:   0x94,  # ê LATIN SMALL LETTER E WITH CIRCUMFLEX
                0x00e8:   0x95,  # è LATIN SMALL LETTER E WITH GRAVE
                0x00e9:   0x96,  # é LATIN SMALL LETTER E WITH ACUTE
                0x00eb:   0x97,  # ë LATIN SMALL LETTER E WITH DIAERESIS
                0x00c1:   0x98,  # Á LATIN CAPITAL LETTER A WITH ACUTE
                0x00c4:   0x99,  # Ä LATIN CAPITAL LETTER A WITH DIAERESIS
                0x0227:   0x9a,  # ȧ LATIN SMALL LETTER A WITH DOT ABOVE
                0x00e2:   0x9b,  # â LATIN SMALL LETTER A WITH CIRCUMFLEX
                0x00e0:   0x9c,  # à LATIN SMALL LETTER A WITH GRAVE
                0x00e1:   0x9d,  # á LATIN SMALL LETTER A WITH ACUTE
                0x00e4:   0x9e,  # ä LATIN SMALL LETTER A WITH DIAERESIS
                0x00ee:   0xa1,  # î LATIN SMALL LETTER I WITH CIRCUMFLEX
                0x00ec:   0xa2,  # ì LATIN SMALL LETTER I WITH GRAVE
                0x00ed:   0xa3,  # í LATIN SMALL LETTER I WITH ACUTE
                0x00ef:   0xa4,  # ï LATIN SMALL LETTER I WITH DIAERESIS
                0x00a1:   0xa5,  # ¡ INVERTED EXCLAMATION MARK
                0x00d1:   0xa6,  # Ñ LATIN CAPITAL LETTER N WITH TILDE
                0x00f1:   0xa7,  # ñ LATIN SMALL LETTER N WITH TILDE
                0x00c6:   0xaf,  # Æ LATIN CAPITAL LETTER AE
                0x00a7:   0xb0,  # § SECTION SIGN
                0x00b1:   0xb1,  # ± PLUS-MINUS SIGN
                0x0133:   0xb2,  # ĳ LATIN SMALL LIGATURE IJ
                0x2191:   0xb3,  # ↑ UPWARDS ARROW
                0x2193:   0xb4,  # ↓ DOWNWARDS ARROW
                0x21b2:   0xb5,  # ↲ DOWNWARDS ARROW WITH TIP LEFTWARDS
                0x2a0d:   0xb6,  # ⨍ FINITE PART INTEGRAL
                0x00a3:   0xb7,  # £ POUND SIGN
                0x21e5:   0xb8,  # ⇥ RIGHTWARDS ARROW TO BAR
                0x2908:   0xb9,  # ⤈ DOWNWARDS ARROW WITH HORIZONTAL STROKE
                0x2909:   0xba,  # ⤉ UPWARDS ARROW WITH HORIZONTAL STROKE
                0x2913:   0xbb,  # ⤓ DOWNWARDS ARROW TO BAR
                0x00b6:   0xbc,  # ¶ PILCROW SIGN
                0x00bd:   0xbd,  # ½ VULGAR FRACTION ONE HALF
                0x2153:   0xbe,  # ⅓ VULGAR FRACTION ONE THIRD
                0x00bc:   0xbf,  # ¼ VULGAR FRACTION ONE QUARTER
                0x00f8:   0xc0,  # ø LATIN SMALL LETTER O WITH STROKE
                0x013f:   0xc1,  # Ŀ LATIN CAPITAL LETTER L WITH MIDDLE DOT
                0x00d0:   0xc2,  # Ð LATIN CAPITAL LETTER ETH
                0x00df:   0xc3,  # ß LATIN SMALL LETTER SHARP S
                0x00e7:   0xc4,  # ç LATIN SMALL LETTER C WITH CEDILLA
                0x00a4:   0xc6,  # ¤ CURRENCY SIGN
                0x26f6:   0xc7,  # ⛶ SQUARE FOUR CORNERS
                0x00d8:   0xc9,  # Ø LATIN CAPITAL LETTER O WITH STROKE
                0x00ff:   0xca,  # ÿ LATIN SMALL LETTER Y WITH DIAERESIS
                0x00c3:   0xcb,  # Ã LATIN CAPITAL LETTER A WITH TILDE
                0x00a2:   0xcc,  # ¢ CENT SIGN
                0x00e3:   0xcd,  # ã LATIN SMALL LETTER A WITH TILDE
                0x00d5:   0xce,  # Õ LATIN CAPITAL LETTER O WITH TILDE
                0x00f5:   0xcf,  # õ LATIN SMALL LETTER O WITH TILDE
                0x0307:   0xd0,  # ̇ COMBINING DOT ABOVE
                0x0308:   0xd1,  # ̈ COMBINING DIAERESIS
                0x030a:   0xd2,  # ̊ COMBINING RING ABOVE
                0x0300:   0xd3,  # ̀ COMBINING GRAVE ACCENT
                0x0301:   0xd4,  # ́ COMBINING ACUTE ACCENT
                0x0303:   0xd5,  # ̃ COMBINING TILDE
                0x00f7:   0xd6,  # ÷ DIVISION SIGN
                0x2aa1:   0xd7,  # ⪡ DOUBLE NESTED LESS-THAN
                0x2aa2:   0xd8,  # ⪢ DOUBLE NESTED GREATER-THAN
                0x0140:   0xd9,  # ŀ LATIN SMALL LETTER L WITH MIDDLE DOT
                0x005c:   0xda,  # ⧵ REVERSE SOLIDUS
                0x29f5:   0xda,  # ⧵ REVERSE SOLIDUS OPERATOR
                0x00d7:   0xdb,  # × MULTIPLICATION SIGN
                0x00ae:   0xdc,  # ® REGISTERED SIGN
                0x00a9:   0xdd,  # © COPYRIGHT SIGN
                0x2122:   0xde,  # ™ TRADE MARK SIGN
                0x039e:   0xdf,  # Ξ GREEK CAPITAL LETTER XI
                0x03b1:   0xe0,  # α GREEK SMALL LETTER ALPHA
                0x2154:   0xe4,  # ⅔ VULGAR FRACTION TWO THIRDS
                0x00be:   0xe5,  # ¾ VULGAR FRACTION THREE QUARTERS
                0x2195:   0xe8,  # ↕ UP DOWN ARROW
                0x2938:   0xe9,  # ⤸ RIGHT-SIDE ARC CLOCKWISE ARROW
                0x25af:   0xeb,  # ▯ WHITE VERTICAL RECTANGLE
                0x1d19:   0xed,  # ᴙ LATIN LETTER SMALL CAPITAL REVERSED R
                0x042e:   0xee,  # Ю CYRILLIC CAPITAL LETTER YU
                0x03f4:   0xf2,  # ϴ GREEK CAPITAL THETA SYMBOL
                0x221e:   0xf3,  # ∞ INFINITY
                0x03a9:   0xf4,  # Ω GREEK CAPITAL LETTER OMEGA
                0x03b2:   0xf5,  # β GREEK SMALL LETTER BETA
                0x03a3:   0xf6,  # Σ GREEK CAPITAL LETTER SIGMA
                0x1d540:   0xfb,  # 𝕀 MATHEMATICAL DOUBLE-STRUCK CAPITAL I
                0x0439:   0xfc,  # й CYRILLIC SMALL LETTER SHORT I
                0x25ae:   0xff,  # ▮ BLACK VERTICAL RECTANGLE
                # CONFLICT 0x2153:   0xe1,  # ⅓ VULGAR FRACTION ONE THIRD (5x10)
                # CONFLICT 0x00bd:   0xbd,  # ½ VULGAR FRACTION ONE HALF (5x10)
                # CONFLICT 0x00bc:   0xe3,  # ¼ VULGAR FRACTION ONE QUARTER (5x10)
                # CONFLICT 0x00f8:   0xf8,  # ø LATIN SMALL LETTER O WITH STROKE (5x10)
            },

            {  # FT10 ENGLISH_RUSSIAN CHARACTER FONT
                0x00c0:   0x10,  # À LATIN CAPITAL LETTER A WITH GRAVE
                0x00c1:   0x11,  # Á LATIN CAPITAL LETTER A WITH ACUTE
                0x00c2:   0x12,  # Â LATIN CAPITAL LETTER A WITH CIRCUMFLEX
                0x00c3:   0x13,  # Ã LATIN CAPITAL LETTER A WITH TILDE
                0x00c4:   0x14,  # Ä LATIN CAPITAL LETTER A WITH DIAERESIS
                0x00c5:   0x15,  # Å LATIN CAPITAL LETTER A WITH RING ABOVE
                0x00c6:   0x16,  # Æ LATIN CAPITAL LETTER AE
                0x00c7:   0x17,  # Ç LATIN CAPITAL LETTER C WITH CEDILLA
                0x00c8:   0x18,  # È LATIN CAPITAL LETTER E WITH GRAVE
                0x00c9:   0x19,  # É LATIN CAPITAL LETTER E WITH ACUTE
                0x00ca:   0x1a,  # Ê LATIN CAPITAL LETTER E WITH CIRCUMFLEX
                0x00cb:   0x1b,  # Ë LATIN CAPITAL LETTER E WITH DIAERESIS
                0x00cc:   0x1c,  # Ì LATIN CAPITAL LETTER I WITH GRAVE
                0x00cd:   0x1d,  # Í LATIN CAPITAL LETTER I WITH ACUTE
                0x00ce:   0x1e,  # Î LATIN CAPITAL LETTER I WITH CIRCUMFLEX
                0x00cf:   0x1f,  # Ï LATIN CAPITAL LETTER I WITH DIAERESIS
                0x0410:   0x41,  # А CYRILLIC CAPITAL LETTER A
                0x0412:   0x42,  # В CYRILLIC CAPITAL LETTER VE
                0x0421:   0x43,  # С CYRILLIC CAPITAL LETTER ES
                0x0415:   0x45,  # Е CYRILLIC CAPITAL LETTER IE
                0x041d:   0x48,  # Н CYRILLIC CAPITAL LETTER EN
                0x041a:   0x4b,  # К CYRILLIC CAPITAL LETTER KA
                0x041c:   0x4d,  # М CYRILLIC CAPITAL LETTER EM
                0x041e:   0x4f,  # О CYRILLIC CAPITAL LETTER O
                0x0420:   0x50,  # Р CYRILLIC CAPITAL LETTER ER
                0x0422:   0x54,  # Т CYRILLIC CAPITAL LETTER TE
                0x0425:   0x58,  # Х CYRILLIC CAPITAL LETTER HA
                0x042c:   0x62,  # Ь CYRILLIC CAPITAL LETTER SOFT SIGN
                0x00a2:   0x5c,  # ¢ CENT SIGN
                0x21b2:   0x7e,  # ↲ DOWNWARDS ARROW WITH TIP LEFTWARDS
                0x00d0:   0x80,  # Ð LATIN CAPITAL LETTER ETH
                0x00d1:   0x81,  # Ñ LATIN CAPITAL LETTER N WITH TILDE
                0x00d2:   0x82,  # Ò LATIN CAPITAL LETTER O WITH GRAVE
                0x00d3:   0x83,  # Ó LATIN CAPITAL LETTER O WITH ACUTE
                0x00f4:   0x84,  # ô LATIN SMALL LETTER O WITH CIRCUMFLEX
                0x00f5:   0x85,  # õ LATIN SMALL LETTER O WITH TILDE
                0x00f6:   0x86,  # ö LATIN SMALL LETTER O WITH DIAERESIS
                0x00d7:   0x87,  # × MULTIPLICATION SIGN
                0x00d8:   0x88,  # Ø LATIN CAPITAL LETTER O WITH STROKE
                0x00d9:   0x89,  # Ù LATIN CAPITAL LETTER U WITH GRAVE
                0x00da:   0x8a,  # Ú LATIN CAPITAL LETTER U WITH ACUTE
                0x00db:   0x8b,  # Û LATIN CAPITAL LETTER U WITH CIRCUMFLEX
                0x00dc:   0x8c,  # Ü LATIN CAPITAL LETTER U WITH DIAERESIS
                0x00dd:   0x8d,  # Ý LATIN CAPITAL LETTER Y WITH ACUTE
                0x00de:   0x8e,  # Þ LATIN CAPITAL LETTER THORN
                0x00df:   0x8f,  # ß LATIN SMALL LETTER SHARP S
                0x00e0:   0x90,  # à LATIN SMALL LETTER A WITH GRAVE
                0x00e1:   0x91,  # á LATIN SMALL LETTER A WITH ACUTE
                0x00e2:   0x92,  # â LATIN SMALL LETTER A WITH CIRCUMFLEX
                0x00e3:   0x93,  # ã LATIN SMALL LETTER A WITH TILDE
                0x00e4:   0x94,  # ä LATIN SMALL LETTER A WITH DIAERESIS
                0x00e5:   0x95,  # å LATIN SMALL LETTER A WITH RING ABOVE
                0x00e6:   0x96,  # æ LATIN SMALL LETTER AE
                0x00e7:   0x97,  # ç LATIN SMALL LETTER C WITH CEDILLA
                0x00e8:   0x98,  # è LATIN SMALL LETTER E WITH GRAVE
                0x00e9:   0x99,  # é LATIN SMALL LETTER E WITH ACUTE
                0x00ea:   0x9a,  # ê LATIN SMALL LETTER E WITH CIRCUMFLEX
                0x00eb:   0x9b,  # ë LATIN SMALL LETTER E WITH DIAERESIS
                0x00ec:   0x9c,  # ì LATIN SMALL LETTER I WITH GRAVE
                0x00ed:   0x9d,  # í LATIN SMALL LETTER I WITH ACUTE
                0x00ee:   0x9e,  # î LATIN SMALL LETTER I WITH CIRCUMFLEX
                0x00ef:   0x9f,  # ï LATIN SMALL LETTER I WITH DIAERESIS
                0x042e:   0xb0,  # Ю CYRILLIC CAPITAL LETTER YU
                0x2aa1:   0xc8,  # ⪡ DOUBLE NESTED LESS-THAN
                0x2aa2:   0xc9,  # ⪢ DOUBLE NESTED GREATER-THAN
                0x2193:   0xda,  # ↓ DOWNWARDS ARROW
                0x0301:   0xe7,  # ́ COMBINING ACUTE ACCENT
                0x0308:   0xe8,  # ̈ COMBINING DIAERESIS
                0x0303:   0xe9,  # ̃ COMBINING TILDE
                0x00bc:   0xf0,  # ¼ VULGAR FRACTION ONE QUARTER
                0x2153:   0xf1,  # ⅓ VULGAR FRACTION ONE THIRD
                0x00bd:   0xf2,  # ½ VULGAR FRACTION ONE HALF
                0x00be:   0xf3,  # ¾ VULGAR FRACTION THREE QUARTERS
                0x00a7:   0xfd,  # § SECTION SIGN
                0x00b6:   0xfe,  # ¶ PILCROW SIGN
                0x25ae:   0xff,  # ▮ BLACK VERTICAL RECTANGLE
                # conflict 0x00e9:  0xea,  # 'é' LATIN SMALL LETTER E WITH ACUTE
                # duplicate 0x00e7:  0xeb,  # 'ç' LATIN SMALL LETTER C WITH CEDILLA
            },

            {   # FT11 WESTERN_EUROPEAN_II CHARACTER FONT
                0x00b1:   0x10,  # ± PLUS-MINUS SIGN
                0x039e:   0x11,  # Ξ GREEK CAPITAL LETTER XI
                0x2248:   0x1a,  # ≈ ALMOST EQUAL TO
                0x222b:   0x1b,  # ∫ INTEGRAL
                0x2017:   0x1c,  # ‗ DOUBLE LOW LINE
                0x0303:   0x1d,  # ̃ COMBINING TILDE
                0x00b2:   0x1e,  # ² SUPERSCRIPT TWO
                0x00b3:   0x1f,  # ³ SUPERSCRIPT THREE
                0x00c7:   0x80,  # Ç LATIN CAPITAL LETTER C WITH CEDILLA
                0x00fc:   0x81,  # ü LATIN SMALL LETTER U WITH DIAERESIS
                0x00e9:   0x82,  # é LATIN SMALL LETTER E WITH ACUTE
                0x00e2:   0x83,  # â LATIN SMALL LETTER A WITH CIRCUMFLEX
                0x00e4:   0x84,  # ä LATIN SMALL LETTER A WITH DIAERESIS
                0x00e0:   0x85,  # à LATIN SMALL LETTER A WITH GRAVE
                0x00e7:   0x87,  # ç LATIN SMALL LETTER C WITH CEDILLA
                0x00ea:   0x88,  # ê LATIN SMALL LETTER E WITH CIRCUMFLEX
                0x00eb:   0x89,  # ë LATIN SMALL LETTER E WITH DIAERESIS
                0x00e8:   0x8a,  # è LATIN SMALL LETTER E WITH GRAVE
                0x00ef:   0x8b,  # ï LATIN SMALL LETTER I WITH DIAERESIS
                0x00ee:   0x8c,  # î LATIN SMALL LETTER I WITH CIRCUMFLEX
                0x00ec:   0x8d,  # ì LATIN SMALL LETTER I WITH GRAVE
                0x00c4:   0x8e,  # Ä LATIN CAPITAL LETTER A WITH DIAERESIS
                0x00c5:   0x8f,  # Å LATIN CAPITAL LETTER A WITH RING ABOVE
                0x00c9:   0x90,  # É LATIN CAPITAL LETTER E WITH ACUTE
                0x00e6:   0x91,  # æ LATIN SMALL LETTER AE
                0x00c6:   0x92,  # Æ LATIN CAPITAL LETTER AE
                0x00f4:   0x93,  # ô LATIN SMALL LETTER O WITH CIRCUMFLEX
                0x00f6:   0x94,  # ö LATIN SMALL LETTER O WITH DIAERESIS
                0x00f2:   0x95,  # ò LATIN SMALL LETTER O WITH GRAVE
                0x00fb:   0x96,  # û LATIN SMALL LETTER U WITH CIRCUMFLEX
                0x00f9:   0x97,  # ù LATIN SMALL LETTER U WITH GRAVE
                0x00ff:   0x98,  # ÿ LATIN SMALL LETTER Y WITH DIAERESIS
                0x00dc:   0x9a,  # Ü LATIN CAPITAL LETTER U WITH DIAERESIS
                0x00f1:   0x9b,  # ñ LATIN SMALL LETTER N WITH TILDE
                0x00d1:   0x9c,  # Ñ LATIN CAPITAL LETTER N WITH TILDE
                0x00bf:   0x9f,  # ¿ INVERTED QUESTION MARK
                0x00e1:   0xa0,  # á LATIN SMALL LETTER A WITH ACUTE
                0x00ed:   0xa1,  # í LATIN SMALL LETTER I WITH ACUTE
                0x00f3:   0xa2,  # ó LATIN SMALL LETTER O WITH ACUTE
                0x00fa:   0xa3,  # ú LATIN SMALL LETTER U WITH ACUTE
                0x00a2:   0xa4,  # ¢ CENT SIGN
                0x00a3:   0xa5,  # £ POUND SIGN
                0x00a5:   0xa6,  # ¥ YEN SIGN
                0x00b4:   0xa7,  # ´ ACUTE ACCENT
                0x2a0d:   0xa8,  # ⨍ FINITE PART INTEGRAL
                0x00a1:   0xa9,  # ¡ INVERTED EXCLAMATION MARK
                0x00c3:   0xaa,  # Ã LATIN CAPITAL LETTER A WITH TILDE
                0x00e3:   0xab,  # ã LATIN SMALL LETTER A WITH TILDE
                0x00d5:   0xac,  # Õ LATIN CAPITAL LETTER O WITH TILDE
                0x00f5:   0xad,  # õ LATIN SMALL LETTER O WITH TILDE
                0x00f8:   0xaf,  # ø LATIN SMALL LETTER O WITH STROKE
                0x0307:   0xb0,  # ̇ COMBINING DOT ABOVE
                0x0308:   0xb1,  # ̈ COMBINING DIAERESIS
                0x030a:   0xb2,  # ̊ COMBINING RING ABOVE
                0x0300:   0xb3,  # ̀ COMBINING GRAVE ACCENT
                0x0301:   0xb4,  # ́ COMBINING ACUTE ACCENT
                0x00bd:   0xb5,  # ½ VULGAR FRACTION ONE HALF
                0x00bc:   0xb6,  # ¼ VULGAR FRACTION ONE QUARTER
                0x00d7:   0xb7,  # × MULTIPLICATION SIGN
                0x00f7:   0xb8,  # ÷ DIVISION SIGN
                0x2264:   0xb9,  # ≤ LESS-THAN OR EQUAL TO
                0x2265:   0xba,  # ≥ GREATER-THAN OR EQUAL TO
                0x2aa1:   0xbb,  # ⪡ DOUBLE NESTED LESS-THAN
                0x2aa2:   0xbc,  # ⪢ DOUBLE NESTED GREATER-THAN
                0x2260:   0xbd,  # ≠ NOT EQUAL TO
                0x221a:   0xbe,  # √ SQUARE ROOT
                0x203e:   0xbf,  # ‾ OVERLINE
                0x221e:   0xc2,  # ∞ INFINITY
                0x25f8:   0xc3,  # ◸ UPPER LEFT TRIANGLE
                0x21b2:   0xc4,  # ↲ DOWNWARDS ARROW WITH TIP LEFTWARDS
                0x2191:   0xc5,  # ↑ UPWARDS ARROW
                0x2193:   0xc6,  # ↓ DOWNWARDS ARROW
                0x2192:   0xc7,  # → RIGHTWARDS ARROW
                0x2190:   0xc8,  # ← LEFTWARDS ARROW
                0x250c:   0xc9,  # ┌ BOX DRAWINGS LIGHT DOWN AND RIGHT
                0x231c:   0xc9,  # ⌜ TOP LEFT CORNER
                0x2510:   0xca,  # ┐ BOX DRAWINGS LIGHT DOWN AND LEFT
                0x231d:   0xca,  # ⌝ TOP RIGHT CORNER
                0x2514:   0xcb,  # └ BOX DRAWINGS LIGHT UP AND RIGHT
                0x231e:   0xcb,  # ⌞ BOTTOM LEFT CORNER
                0x2518:   0xcc,  # ┘ BOX DRAWINGS LIGHT UP AND LEFT
                0x231f:   0xcc,  # ⌟ BOTTOM RIGHT CORNER
                0x00b7:   0xcd,  # · MIDDLE DOT
                0x00ae:   0xce,  # ® REGISTERED SIGN
                0x00a9:   0xcf,  # © COPYRIGHT SIGN
                0x2122:   0xd0,  # ™ TRADE MARK SIGN
                0x2020:   0xd1,  # † DAGGER
                0x00a7:   0xd2,  # § SECTION SIGN
                0x00b6:   0xd3,  # ¶ PILCROW SIGN
                0x25ff:   0xd5,  # ◿ LOWER RIGHT TRIANGLE
                0x0398:   0xd6,  # Θ GREEK CAPITAL LETTER THETA
                0x03f4:   0xd6,  # ϴ GREEK CAPITAL THETA SYMBOL
                0x1d6b5:  0xd8,  # 𝚵 MATHEMATICAL BOLD CAPITAL XI
                0x2aea:   0xd9,  # ⫪ DOUBLE DOWN TACK
                0x03a3:   0xda,  # Σ GREEK CAPITAL LETTER SIGMA
                0x297e:   0xdb,  # ⥾ UP FISH TAIL
                0x00d8:   0xdc,  # Ø LATIN CAPITAL LETTER O WITH STROKE
                0x03a8:   0xdd,  # Ψ GREEK CAPITAL LETTER PSI
                0x03a9:   0xde,  # Ω GREEK CAPITAL LETTER OMEGA
                0x03b1:   0xdf,  # α GREEK SMALL LETTER ALPHA
                0x03b2:   0xe0,  # β GREEK SMALL LETTER BETA
                0x03b4:   0xe2,  # δ GREEK SMALL LETTER DELTA
                0x03b6:   0xe4,  # ζ GREEK SMALL LETTER ZETA
                0x03b7:   0xe5,  # η GREEK SMALL LETTER ETA
                0x00b5:   0xea,  # µ MICRO SIGN
                0x03b3:   0xec,  # γ GREEK SMALL LETTER GAMMA
                0x03c0:   0xed,  # π GREEK SMALL LETTER PI
                0x03c3:   0xef,  # σ GREEK SMALL LETTER SIGMA
                0x25bc:   0xf5,  # ▼ BLACK DOWN-POINTING TRIANGLE
                0x25b6:   0xf6,  # ▶ BLACK RIGHT-POINTING TRIANGLE
                0x25c0:   0xf7,  # ◀ BLACK LEFT-POINTING TRIANGLE
                0x21a4:   0xf9,  # ↤ LEFTWARDS ARROW FROM BAR
                0x21e5:   0xfb,  # ⇥ RIGHTWARDS ARROW TO BAR
                0x25af:   0xfc,  # ▯ WHITE VERTICAL RECTANGLE
            }
        ],
        'fonts': [
            # FT00 ENGLISH_JAPANESE CHARACTER FONT
            b'\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x01\x14\xa2a\x8c\x12\x00\x00\x00\x00q\x1d\xf1|\xdfs\x80\x01\x01\x0es\xbc\xee\x7f\xee\x8b\x8f\x18F.\xf3\xbc\xff\xc61\x8c~\xe8\xb8\x80@ \x00\x80\xc0\x81\x05\x06\x00\x00\x00\x00\x04\x00\x00\x00\x00" \x00\x00\x00\x00\x00\x00\x00\x00@\x00@ \x00\x00\x10\x80\x00\x00@\x00\x06\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x8f\x8d\xff\x99\xdf\xb9\x9f\xef\xfe\xc6\x01\x14\xa7\xe6D!\x08@\x00\x01\x8b"#A\x01\x8cX\xc2\x00\x91\x8cc\x19B\x11\x89\x05(n1\x8cc\x02F1\x8cB\x85\t@  \x00\x81/\x80\x01\x02\x00\x00\x00\x00\x04\x00\x00\x00\x00B\x10\x847\xe2\xff\xa6?\xfd^\x91\x00\x84(\x04\x06\x01%\x02\x80\x02\x84\x1d\x00\x08\x00\x03\xe0\x00\x00\x00\x00\x00H\x84 \x88\x91\xa8\x82\x10\xc5"\x01\x15\xfa\n\x88@\xaa@\x00\x02\x99\x02Ez\x02\x8cX\xc4|A\x0cc\x08\xc2\x10\x89\x05HW1\x8cc\x02F1TD\x8f\x8a \x13\xac\xe6\xb9\x11\xb3\r"j\xce\xf3l\xeeF1\x8c~B\x10H\x14b\x94\x99A\rS\xd0\x01\xc0\xe1\x00\x01?\xa0\x00\x1e@\x04\x01\x00\x08\x00\x00?\x11\x00$\x03\xc0p\x8c(\x89\x11\xa8\x02\x10\xc6"\x01\x00\xa7\x11\x00@\x9d\xf0|\x04\xa9\x04)\x07\xc4s\xc0\x08\x00"l}\x08\xfb\xd7\xf9\x05\x88V\xb1\xf4|\xe2F5"\x88\x82\x08\x00\x00s\t\xc7\x91\xc9\x05BW1\x8c\xf3\x04F1TD\x82\x0b\xff\x14R\xd6\x88\x91\rR\x11\x08\x06\x02\xa6t\xa4"c\x12\xa9\x84\x81\x00\x08@3\xe1\'\xff\xff\xb8U\x90\x94(\x88\x91\x88\x02\x10\xc6"\x00\x01\xf2\xa2\xa0@\xaaF\x00\x08\xc9\x08\x1f\x86(\x88X\xc4|D\xaf\xe3\x08\xc2\x11\x89\x05HFq\x85h\x12F5Q\x10\x8f\x88\x00\x03\xe3\x08\xfd\x0f\x89\x05\x82V1\xf3\xe0\xe4F5#\xc8B\x10H\x14J\x10\x84V\rS\x12\x94H fZ\x98%R\x8c\x19\x85A\x07\x00H0&dHd\x8b\xd5\x8f\xd4(\x88Qx\x03\xe3~\xe2\x00\x00\xafN@!\x08B\x01\x90\x89\x11\x11F(\x88\x98B\x00\x80\xacc\x19B\x11\x89%(F1\x84\xa4\x12EU\x89 \x82\x08\x00\x04c\x18\xc1\x01\x89%BF1\x80`\x14\xcdUPPB\x10\x84s\xbc\x1f\x87\xf0\x0b\xb3\xefy\x9e\xff\xff\xbf\xe4>ks\xff\xf9\xc1\x05\x00D\x00D\xa0H\xa5\x08A\x00\x00\x00\x00\x00\x00\x02\x00\x00\x02\x01\x00\xa2\r\xa0\x12\x00\x04\x01\x80s\xbe\xe19\xc8s\x00\x81\x01\x04t|\xee~\x0f\x8b\x99\x1f\xc6.\x83c\xe28\x8a\x89>\xe28\x1f\x03\xfc\xe7\xb9\x0e\x8b\x99\'F.\x80a\xe34\x8a\x8b\xbe" \x00\x00\x00\x10\x04\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x01\xc2\x00\x88!\xbf$\x7f\xc6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\xc2@\t\x04\x02\x00\xa0\x01\x00\x00\x80\xe4\x10\x00 \x81\x00\x00\x80\x00\x00\x04\x00\x0e\x90\x00\x00\x00\x9c\x02\x80\x00\x00\x00\x00\x04\x00!\xca\x00\x00\x00+\xe0\xf8\x00\x00\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00E\xff\xff\xff{\xff\xfc\x7f\xf1\x7f*\x04\x11\xdf\xf8\x89\x0f\xa3\xffq\x03\xf4;\xe0\x91!\xff\xe2T\x00\x00\x00\x00\x00\x00\x81B \x00\x00\x1c\x00\x02\x00\x00\x02\x00\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01I\x12\t$L\x82\xa0\x851I+\xf4|\x01\x10\x85\xf0\xd0\x81\x02\x02\x8f\x88?\x95!\x18\x81\x1cK\x9c\xe8\xbc\xcf>\x8c\x87r\xce\xb3b\x07E\x1f\x8c}\xff\x90\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\x99\x12\x19?\x88\x82\xac\x89I\xaf\xeaF\x10\n \xa3\x00\x88\x81t\x15\xf4\x8b\xe1\x95#\x18\x84\x00\xa8c\x08\xd11 \x85J#1\xcc\xfe\xb8\xc4\x8aTH\x8a\x80\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01(\x12)$\x08\x82 \x91\x01\x19\x02E\x10\x04p\xa3\x00\x86\xaa\x04H\x85\x08!\x15e\x10\x84\x00\x93\xfc\xc8\xca1 \x04\n\xf21\x8ccX\xc5\n$~\xff\xfc\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x08"I$\x10\x82A)\x02\x11\x04D \n\xa9#\x01\x06\xa4w\xd4\x84\x08"%i\x11\x08\x00\x94c\x19\xc61\xa0\x04\x07"1\x8cc\xa5N\nTH\x98\x80\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x08O\x8aDa>\x8eD\xecb\x08\x84C\xf0""\xf6\x00\x82\x08`t\x7f\xe4E\xb1\xf2p\x00k\xfc\xee\xbb\xcf@\x04\x02>.\xf3\xdc\r\xb7\xf3\x8b\xc9\x18\x90\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x08\x02\x01\x00\x04\x00\x00\x00\x80@\x00\x00\x00\x00@\x00\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x08\x02\x01\x00$\x00\x00\x00\x80@\x00\x00\x00\x00@\x00\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x08\x02\x0e\x00\x18\x00\x00\x00\x80@\x00\x00\x00\x03\x80\x00\x00\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',

            # FT01 WESTERN EUROPEAN CHARACTER FONT
            b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x14\xa2a\x8c\x12\x00\x00\x00\x00q\x1d\xf1|\xdfs\x80\x01\x01\x0es\xbc\xee\x7f\xee\x8b\x8f\x18F.\xf3\xbc\xff\xc61\x8c~\xe8\xb8\x80@ \x00\x80\xc0\x81\x05\x06\x00\x00\x00\x00\x04\x00\x00\x00\x00" \x00"\x04\xa2 D@\x9cD\tD"\x04\xa2 J"\x88D\tNq\x10%\x11)\x1b\x9d\x18\xc5O\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x14\xa7\xe6D!\x08@\x00\x01\x8b"#A\x01\x8cX\xc2\x00\x91\x8cc\x19B\x11\x89\x05(n1\x8cc\x02F1\x8cB\x85\t@  \x00\x81/\x80\x01\x02\x00\x00\x00\x00\x04\x00\x00\x00\x00B\x10\x84Q\x08\x05\x10\x8a!"\xa2\x10\x00Q\x08\x05\x10\x80\x00\x00\xa2\x10\x11\n\x88@\x02\xd6\x04\xa5\x18\xd6\xb4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x15\xfa\n\x88@\xaa@\x00\x02\x99\x02Ez\x02\x8cX\xc4|A\x0cc\x08\xc2\x10\x89\x05HW1\x8cc\x02F1TD\x8f\x8a \x13\xac\xe6\xb9\x11\xb3\r"j\xce\xf3l\xeeF1\x8c~B\x10H\x8cc\x10\x00\x0es\xa2\x00\x00\x04\xff\xff\xf79\xces\x9c\xe79\xdf{\x18\xc6\x10\x00\x9b\x9c\xa5V\xb4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\xa7\x11\x00@\x9d\xf0|\x04\xa9\x04)\x07\xc4s\xc0\x08\x00"l}\x08\xfb\xd7\xf9\x05\x88V\xb1\xf4|\xe2F5"\x88\x82\x08\x00\x00s\t\xc7\x91\xc9\x05BW1\x8c\xf3\x04F1TD\x82\x0b\xff\x8cc\x18\xc61\x8cb\xe79\xc8\x84!\x08\xc61\x8cB\x10\x841\x89\x08B\x136\xd0\x84B*>\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xf2\xa2\xa0@\xaaF\x00\x08\xc9\x08\x1f\x86(\x88X\xc4|D\xaf\xe3\x08\xc2\x11\x89\x05HFq\x85h\x12F5Q\x10\x8f\x88\x00\x03\xe3\x08\xfd\x0f\x89\x05\x82V1\xf3\xe0\xe4F5#\xc8B\x10H\x8cc\x18\xc61\x8c]\x18\xc60\xf7\xbd\xef\xff\xff\xff\xde\xf7\xbd\xe0y\x08B\x12\xb9\xb3\x18\x00\x00\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xafN@!\x08B\x01\x90\x89\x11\x11F(\x88\x98B\x00\x80\xacc\x19B\x11\x89%(F1\x84\xa4\x12EU\x89 \x82\x08\x00\x04c\x18\xc1\x01\x89%BF1\x80`\x14\xcdUPPB\x10\x84\x8cc\x19\xceq\x8cA\x18\xc61\x84!\x08B\x10\x8cc\x18\xc6?\x01\x08B\x12q\x97\xc0\x0f\xff\xf4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\xa2\r\xa0\x12\x00\x04\x01\x80s\xbe\xe19\xc8s\x00\x81\x01\x04t|\xee~\x0f\x8b\x99\x1f\xc6.\x83c\xe28\x8a\x89>\xe28\x1f\x03\xfc\xe7\xb9\x0e\x8b\x99\'F.\x80a\xe34\x8a\x8b\xbe" \x00s\x9c\xe6\xb5\xaes\xbe\xe79\xce\xff\xff\xf79\xce\x8c^\xf7\xbd\xe0\xfb\x9c\xe7\x121\x90\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00q\x14B\x04fI\x08G\xc61\x04\x18\xc78\x1b\x00T\x92%)"\x88\x81$\x00\x06\x00\x07;\xff\x04c\x1c`\x00 \x05\xf8\x00\x00\x00\x00\x00\x03\xe0p=\xf5H\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x00\xe2\x14\x89)\x1cN\xcaR\x0c\x15(v1K\x81g\xda\xd6\x00\x14BX\x85\xa2!\x19\xc6 \x04\xa5$ \x00s\x81\x1a\x1eU\x00\x1c\x00:\x00 \x12\xa2I\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00w\xd5R$\x88\x1f\xeaN\xde\xf5t\x13(m\xc0L\xe2\xea9\xc0\x00\x08\x00\x00\nR\x10\xaa\xd7`M)H\xe4\xcf\xa8M\x1c&\xb5\xb3b\x07E\x0etP\xa8\xca\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x14B}\xdc\xf9\tV\xa5+\xac\xbbHv Mc\x1a\x06.\x00\x00\x00\x03\xf4*\x88I\xdf\x7f\xaa\x10\x9d)1 E\x1a&\xb5\xcc\xfe\xb8\xf8\x90\xacP\xa9\xc8\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00q\x14J\xa0\x88\x1d~\xe2\xcew\xac\x13\'n v_\xfa>1\x00\x00\x00\x00\nR\x04\xaa\xd7`\x95\xef2v1 E\x17\'\xb5\x8ccX\xc5\x00\xac\\\xaa\xc8\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x04G\x10\x88+\x88B\x88!t\x15"E\xd1C\x83\x17\xc61\x00\x00\x00\x00\x85\xa2\x03\x1a\xc7`\x90BU\xae1!E\x12\x1e\xb5\x8cc\xa5z\x00\xacR\xac\xc8\xdf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00w\xd8B\x03\x1fI\t\xf2\x8ca\x87\xd9F:;\x84\x1d\x12]\xce\x00\x00\x00\x00\x00\x07\x00\x07;\xffi\xce\xf8\xd7\xcf"E\x13\x96\xb5\xf3\xdc\r\xc3\xe0\xab\xd2\xa8\xc8\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00H\x11\xbe\x01\xaf\xc5\x11&_\x80@\x00@\x00pR\xa0H\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xce\x00\x86\x01r%\x10\x80\x00\x80@\x00@\x00 S\xf0x\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x82\x0e!\x19\xf1\x80\x00\x80@\x00@\x00s\xbc\x00\x04\xdf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',

            # FT10 ENGLISH_RUSSIAN CHARACTER FONT
            b'@\x88\xd5\x10\x0e@\x88\x04\x08\x80\x01\x14\xa2a\x8c\x12\x00\x00\x00\x00q\x1d\xf1|\xdfs\x80\x01\x01\x0es\xbc\xee\x7f\xee\x8b\x8f\x18F.\xf3\xbc\xff\xc61\x8c~\xe08\x80@ \x00\x80\xc0\x81\x05\x06\x00\x00\x00\x00\x04\x00\x00\x00\x01{\xdc \x03P"5@\x02\x04E\x0b\x00@\x88\xd0\x10\x00@\x88\x04\x08\x80\xff\xd5_EO\xfcI\x1a\xe2.!\x15 (\xf1!\x14\xa2\x11J\x01\x14\xa7\xe6D!\x08@\x00\x01\x8b"#A\x01\x8cX\xc2\x00\x91\x8cc\x19B\x11\x89\x05(n1\x8cc\x02F1\x8cB\x82\t@  \x00\x81 \x80\x01\x02\x00\x00\x00\x00\x04\x00\x00\x00\x01X\xd0\xa7t\x88EH\x00q\x08\xa0\x11\x06!\x15%(\x00!\x14\xa2\x11J\x8cAP\xc4\x85\x8c]\x1a\xa21!\x00\x02\x11\x90\x00\x00\x00\x00\x00\x01\x15\xfa\n\x88@\xaa@\x00\x02\x99\x02Ez\x02\x8cX\xc4|A\x0cc\x08\xc2\x10\x89\x05HW1\x8cc\x02F1TD\x87\n \x03\xac\xe6\xb9\x0f\xb3\r"j\xce\xf3\xec\xeeF1\x8c\x7f[\xdd.H\x1c\xe0\x01\xd1$b\x08\xc5\xc9\x00\x00\x00\x13N\x00\x00\x00\x00\x00\x84=P\xce%\x8ck\x1a\xa2!R\x9c\xe5:\x90\xff\xff\xf79\xce\x01\x00\xa7\x11\x00@\x9d\xf0|\x04\xa9\x04)\x07\xc4s\xc0\x08\x00"l}\x08\xfb\xd7\xf9\x05\x88V\xb1\xf4|\xe2F5"\x88\x8a\x08\x00\x00s\t\xc7\x91\xc9\x05BW1\x8cs\x04F1TEZG\xfcLc\x17:*tc\x18\xa9)s\x9c\xe78\xb0s\x9c\xe2\x10\x84\xf4 \xe7Ve\x8a\xaa\xfa\xbb\'\x8cc\x18\xc6\xf1\x84!\x02\x10\x84\x00\x01\xf2\xa2\xa0@\xaaF\x00\x08\xc9\x08\x1f\x86(\x88X\xc4|D\xaf\xe3\x08\xc2\x11\x89\x05HFq\x85h\x12F5Q\x10\x8a\x88\x00\x03\xe3\x08\xfd\x0f\x89\x05\x82V1\xf3\xe0\xe4F5#\xc9{\xdd\x11\xeec\x18\xc6$\xacc\x18\x91.\x08B\x10\x85\xf1\x8cc\x161\x8c\x8c9P\xe6\xa5\x89*\x1a\xa6\xa1\xff\xff\xff\xff\x8e\xf7\xbd\xe2\x10\x84\x00\x00\xafN@!\x08B\x01\x90\x89\x11\x11F(\x88\x98B\x00\x80\xacc\x19B\x11\x89%(F1\x84\xa4\x12EU\x89 \x87\x08\x00\x04c\x18\xc1\x01\x89%BF1\x80`\x14\xcdUPP\x00\x00\x9eMc\x18\xc6*tc\x18\x91\xc9{\xde\xf7\xbe\x8e\xff\xff\xf2\x10\x84\x8c!P\xc75\x8a\x1c\x1a\xa6\xb1\x8cc\x18\xc6\x82\x84!\x02\x10\x84\x01\x00\xa2\r\xa0\x12\x00\x04\x01\x80s\xbe\xe19\xc8s\x00\x81\x01\x04t|\xee~\x0f\x8b\x99\x1f\xc6.\x83c\xe28\x8a\x89>\xe28\x1f\x03\xfc\xe7\xb9\x0e\x8b\x99\'F.\x80a\xe34\x8a\x8b\xbe\x00\x00\x00L\xe3\x18\xc61$c\x18\x91\t\x8cc\x18\xc6\xa4\x84!\x02\x10\x84\xf4=_F)\x8c\x08\x1f\xbb.\x8cc\x18\xc6\xe6\xff\xff\xf79\xce\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00t\\\xe79\xc0s\x9c\xe7\x13\x96{\xde\xf7\xbdLs\x9c\xe79\xce\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\xc6\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xb9\x10d\x00\x00\n\x02\x8e\xf9\t\x00\xc2\x00|j\x00\x00\x02RD\x05\x10\x00\x8cc\x88\xe1\x08 \x04A\x19\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xacX\x00\x00\x00\x02\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x00\x8a\x00\x00\x00m\x04S\x89$\xc7\x80,j\x02\x00\x04\x05\x88\x009N\x94\xa4\x8f\x82\x8es\\\xe9&\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaca\xcf\xba\xbe\x89$\xf8\xc7\xff\x8dq\x18:O!\x01+\x10\x88\x00\x14\xae\xba\xa4UIf\xd6&,j\xf2F\xa0\x00\x1c\xe58\x11\xad\xef\x88\x8f\x88 \x04E\x12\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xeb\xfd(\xc6\xa1\x9ch]\xc6$\x8dQ\x18F\xb1L\x80\t!\xde\x01\x14\xa1\x10DQ\t\xff\xfcF,jWF\xa0\x00#\x05:1ZR\x9f\x82\xaf\xff}\xf3)\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa9c\xc8}\xc6\xac\xf0Z\xfe$}]\x9e\x1f\xaf\x92R\x03\xc0\x88\x01\x14\xa28\x84Q+f\xd4\x80Lj\x9a\xc6\xa0\x00?\x15|\x11\xbc\xe7\xb8\xb0( \x04E(\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaac(B\xa1\xcdiX\xc6$\rSYF\xa5L\xa4\x02\xc4\x88!\x00\x04m\x0e\xf9\x1d$\xc5\x00\x8ck\x1a\xc6\xa0\x00 \xe1\x11N\x08H\x7f\x80\xaes\\\xe9\x10\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94]\xc8:\xbe\x8ed\x98\xc6$\x0f\xdd\x9e:I!6\x03\xbb\x0f!\x1c\xa8\x02\x00\x01\t\x00\xc2\x00\xff\xff\xf7\x7f\xe0\x00\x1cF\x00\x00\t\xce\x18\x81\xe8 \x84AH\xbf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88C\x12\x04 \x00\x00\xc0\x00\x00\x00\x00\x10\x00\x9cq\xce\x03\xb0\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',

            # FT11 WESTERN_EUROPEAN_II CHARACTER FONT
            b' > \x92\x04\x0c\x000\x03\x9c\x01\x14\xa2a\x0c\x12\x08\x00\x00\x00q\x1d\xf1|\xdfs\x80\x01\x01\x0eq<\xee\x7f\xee\x8b\x9f\x18F.\xf3\xbc\xef\xc61\x8c~\xe08\x800 \x00\x80`\x81\x04\x86\x00\x00\x00\x00\x02\x00\x00\x00\x002a\x00x\x04E \x80"\x90\xa2!D\x10\x1e@ \x88TT\xd6\xb9\xc4\x10\x84"\x1a<\x11\x1a\xd6\xb4 \'\xe2A\x11\x04\x12\x14P\x00\x84\x01\x14\xa7\xe6\x84!*@\x00\x01\x8b"#A\x01\x8cX\xc2\x00\x91\x8a\xa3\x19B\x11\x89\x05(n1\x8cc\x12F1\x8cB\x88\t@  \x00\x80\x80\x80\x00\x82\x00\x00\x00\x00\x02\x00\x00\x00\x00B\x12\xa4\x82\x88\xa0\x10\x0fP\x08\x05\x10\n (\xa5\x11D\x03\x81)\x06 !\x08G\xa5R(%)I\xc2\xf8"A\x11\x04!(@#\x9c\x01\x15\xfa\n\x88@\x9c@\x00\x02\x99\x02Ez\x02\x8cX\xc4|A\xbcc\x08\xc2\x10\x89\x05HW1\x8cc\x02F1R\x84\x84\n \x13\xbc\xf7\xbb\xef\xb3\x0c\x92j\xce\xf3\xd6\xef\xc61\x8c~B\x10D\x80\x1c\xe79\xd0s\x9c\xc0\x00\x84\xfe\xa8\x00\x00\x00\x8cb\x00>$p\x00\n#\xfc \x00g\x02n\'\xd2B\x10\x84!\x00@V\x04\x01\x00\xa7\x11 @\x89\xf0|\x04\xa9\x04)\x07\xc2s\xc0\x08\x00"\xac}\x08\xfb\xd7\xf9\x05\x88V\xb1\xf4|\xe2F5!\x08\x82\x08\x00\x00c\x08\xc4\x91\xc9\x04\xa2W1\x8cY\x02F1TD\x82\x08\n\x84b\x10\x840\x8cbF1N\x81~\xe7:1\x8ccl\xc6(\x0b\x1d\x1ax\x92q\x1c\x18\xba\xb5 \x10\x82\x10\x84!\x14O\xd7\x9c\x00\x01\xf2\xa2\xa0@\x9cF\x00\x08\xc9\x08\x1f\x86$\x88X\xc4|D\xbf\xe3\x08\xc2\x11\x89\x05HFq\x85h\x12F5Q\x10\x81\x08\x00\x03\xe3\x08\xfc\x8f\x89\x04\xc2V1\xf3\xd0\xe2F5#\xc8B\x10\n|~\xf7\xbd\xef\xff\xfeB\x121\xf3\xe9\x18\xc61|c\x9a\xbd\xd0y#\x1a#\xf7!"\xf8\xc75\x07\xd0\x82\x10\x84!(@\x08\x00\x00\x00\xafN@!*B\x01\x90\x89\x11\x11F$\x88\x98B\x00\x80\x84c\x19B\x11\x89%(F1\x84\xa5\x12EU\x89 \x80\x88\x00\x04c\x08\xc0\x81\x89$\xa2V1\x80P\x12MUPPB\x10\x11\x14\xe1\x18\xc6"\x84 B\x13\xff\x85)\x18\xc6s\x0cc\x19\x80\x11\x89#7\xa0\x92\xa1?\x18\xc5\xce\xf8\x08\x92\x10\x84!\x00O\x80\x00\x01\x00\xa2\r\xa0\x12\x08\x04\x01\x80s\xbe\xe19\xc4s\x00\x81\x01\x04t|\xee~\x0f\x8b\x99\x1f\xc6.\x83b\xe28\x8a\x89>\xe08\x1f\x03\xfc\xf7\xb8\x8e\x8b\x98\x97V.\x80Q\xe1\xb4\x8a\x8b\xbe2`\x1fs\\\xf7\xbd\xees\x9c\xe7:1\xfb\xee\xe79\xads\x9d\x18\xff\xee{\x9c\xd2|\x93A"\xf7:\x08\x00\t\x12\x08\x88!\x00@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\t\x12\x08\x88@\x81@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\xf2\x04\x90\x80A\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"\x88\x81B\x00\x00\x90\x00\x08\xff\x11\x01\xf0\x90\x80\x07\xff\x00\x81\xce\xf9\x1c\xff\x81\xc4\xff\xfe\xa7U\xc0`\x0c\x0f\x81\x80\x03\x00\x0f\x80\x00\x00\x00\x00\x00\x00\xf0~\x1f\x83\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14BB\x11!\x08Z\x08\x80)\x01\x10\xb8\x84$\x03\x00\x82{!!\xd8\x86$\x8a\x91RV \x90\x12\x01\x02@\x01\x00\x02\x00\x00\x00\x00\x00~\x01\xf9~X\x831\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00J\x8a\x02\x04\xa5|\x80!\x15"\xd4\x82D\x03\x00\x82\xb5\'\xdd\xd8\x8e*\x02\x89WV-\x94H\xf2ZDI%4}\xcf\xfc\xb2E\x7f\x87\xdap8\x82\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00V\xa4\xf9\tB\x90\x80!+D\x90\x9f\xfc\x03\x00\xb2w\x89"\xd8\x17\xear\x84J\xd62\xb2\x9d\x04\'\xc4Q%\x13\xaa2$KX\xbb\xff\xff\xfd\xf8\xfe1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\xaa\x00\x90\xa5~\x80!+\x8f\x92\xa2D\x03\x00\xb2\xb5\xd9\x1cX&1\x02\x88J\xb9R\x8a\xa3\xe8&Db\xa5$*2$MZ\xbb\x87\xf2|8\xff\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\xf1 \x00Z!\x80%\x15\x04\x11\xc4$\x03\x00\x82\xbb\xa9\x02XF1\x8a\x90G\x11R\x89#\x08&DR\xa5H*2,\x8dZ\x92\x01\xd9pX\x82w\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c \x07\xfe\x00 \x80"\x00\x02\x10\x80\x04\x03\xff\x81\xce\x89\x1cX}\xd1\xfa\xbeB\x13m\xb1\x1c\xf7%\x83Lz\x88O\xcc\x13\x18\xe5\x10\x00\xd8p\x18\x83\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x82\x00\x00\x84\x00\x00 \x07\x02\x00\x00\x18@\x00\x00\x00\x00\x0f\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x84\x00\x00 \x00\x82\x00\x00(@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x01\x00\x00\x00&\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
        ]
    }
    # Replicate FT00 data to support making 5x10 version
    FONTDATA['mappings'].append(FONTDATA['mappings'][0])
    FONTDATA['fonts'].append(FONTDATA['fonts'][0])
    FONTDATA['metrics'].append(dict(FONTDATA['metrics'][0]))
    FONTDATA['metrics'][4]['name'] = 'FT00_5x10'
    FONTDATA['metrics'][4]['glyph_size'] = (5, 10)

    # Replicate FT01 data to support making 5x10 version
    FONTDATA['mappings'].append(FONTDATA['mappings'][1])
    FONTDATA['fonts'].append(FONTDATA['fonts'][1])
    FONTDATA['metrics'].append(dict(FONTDATA['metrics'][1]))
    FONTDATA['metrics'][5]['name'] = 'FT01_5x10'
    FONTDATA['metrics'][5]['glyph_size'] = (5, 10)

    # Replicate FT10 data to support making 5x10 version
    FONTDATA['mappings'].append(FONTDATA['mappings'][2])
    FONTDATA['fonts'].append(FONTDATA['fonts'][2])
    FONTDATA['metrics'].append(dict(FONTDATA['metrics'][2]))
    FONTDATA['metrics'][6]['name'] = 'FT10_5x10'
    FONTDATA['metrics'][6]['glyph_size'] = (5, 10)

    # Replicate FT11 data to support making 5x10 version
    FONTDATA['mappings'].append(FONTDATA['mappings'][3])
    FONTDATA['fonts'].append(FONTDATA['fonts'][3])
    FONTDATA['metrics'].append(dict(FONTDATA['metrics'][3]))
    FONTDATA['metrics'][7]['name'] = 'FT11_5x10'
    FONTDATA['metrics'][7]['glyph_size'] = (5, 10)


class winstar_weh(ws0010):
    """
    Values to be used by the winstar_weh class during initialization of the display.
    Contains FONTDATA to enable the winstar_weh class to embed the same fonts that
    are contained within any character-based display that uses the ws0010 controller.

    .. versionadded:: 3.6.0
    """
    FONTDATA = {
        'mappings': ws0010.FONTDATA['mappings'],
        'fonts': ws0010.FONTDATA['fonts'],
        'metrics': []
    }

    for i, m in enumerate(ws0010.FONTDATA['metrics']):
        FONTDATA['metrics'].append(dict(m))
        FONTDATA['metrics'][i]['xwidth'] = 5
