#ifndef _NETWORK_H // -*-C++-*-
#define _NETWORK_H

#ifdef WIN32
#include <winsock2.h>
#include <ws2tcpip.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif

#ifdef WIN32
#define FILE_SEPARATOR ''
#define MSG_WAITALL 0
#else
#define FILE_SEPARATOR '/'
#endif

#include <fcntl.h>
#include <errno.h>
#include <gc/gc.h>
#include <KayaAPI.h>

class ConnInfo : public gc {
public:
    int cid;
    struct sockaddr_in addr;
    socklen_t addrlen;
};

extern "C" {
/// Initialise network library (only needed on Windows at the moment)
    void net_init(void* vm_ptr);
/// Create a socket and connect to the server. Returns connection info.
    void* net_connect(void* vmptr,int proto,wchar_t* server, int port);
/// Create a socket and start listening. Returns socket id.
    int net_listen(void* vmptr,int proto, int port, int backlog);
    bool net_connwaiting(void* vmptr, int socket, kint timeout);
/// Accept a connection. Returns connection info.
    void* net_accept(void* vmptr,int socket);
/// Shutdown a connection.
    void net_shutdown(void* conn);
/// Close a socket.
    void net_close(void* vmptr, void* conn);

    void net_send(void* vmptr,void* conn, wchar_t* data);
    void net_sendchars(void* vmptr,void* conn, void* data, kint len);
    void net_sendbyte(void* vmptr,void* conn, kint byte);
  /* need byte, chars forms */

    wchar_t* net_recv(void* vmptr,void* conn, KayaValue len);
    void* net_recvchars(void* vmptr,void* conn, KayaValue len);
    kint net_recvbyte(void* vmptr,void* conn);

/// Get the address of the host in the connection.
    wchar_t* net_getaddr(void* conn);
/// Return whether data is available on a socket
    bool net_pending(void* vm, void* conn, int timeout);
}

#endif
