// ライセンス: GPL2

//
//  ArticleBaseのチェーン式ハッシュテーブルとイテレータ
//
//  コンパイルが遅くなるのでテンプレートを使用しないでArticleBase専用にした

#ifndef _ARTICLEHASH_H
#define _ARTICLEHASH_H

#include <memory>
#include <string>
#include <vector>


namespace DBTREE
{
    class ArticleBase;
    class ArticleHashIterator;

    class ArticleHash
    {
        friend class ArticleHashIterator;

        size_t m_size{};
        size_t m_min_hash;
        std::vector< std::vector<std::unique_ptr<ArticleBase>> > m_table;

        // iterator 用変数
        size_t m_it_hash{};
        size_t m_it_pos{};
        size_t m_it_size{};

      public:

        ArticleHash();
        ArticleHash( const ArticleHash& ) = delete;
        virtual ~ArticleHash();

        ArticleHash& operator=( const ArticleHash& ) = delete;

        size_t size() const { return m_size; }

        ArticleBase* insert( std::unique_ptr<ArticleBase> article );

        ArticleBase* find( const std::string& datbase, const std::string& id );

        ArticleHashIterator begin();
        size_t end() const { return size(); }

      private:

        int get_hash( const std::string& id ) const;

        // iterator 用関数
        ArticleBase* it_get();
        void it_inc();
        size_t it_size() const { return m_it_size; }
    };


    /////////////////////////////////////////////////////


    class ArticleHashIterator
    {
        ArticleHash* m_hashtable;

      public:

        explicit ArticleHashIterator( ArticleHash* hashtable );

        ArticleBase* operator * ();
        ArticleBase* operator ++ ();
        bool operator != ( const size_t size );
    };

}

#endif
