/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.comparator;

import java.io.File;
import java.util.Comparator;

import org.dbdoclet.service.FileServices;

public class PathTokenCountComparator implements Comparator<File> {

    public int compare(File f1, File f2) {

        int i1 = FileServices.getPathTokenCount(f1.getAbsolutePath());
        int i2 = FileServices.getPathTokenCount(f2.getAbsolutePath());

        if (i1 == i2) {
            return 0;
        }

        if (i1 < i2) {
            return 1;
        }

        if (i1 > i2) {
            return -1;
        }

        return 0;
    }

    @Override
    public boolean equals(Object other) {

        if (this == other) {
            return true;
        }

        if (other == null) {
            return false;
        }

        if (other.getClass() != getClass()) {
            return false;
        }

        return true;
    }
}
