--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.ATI.FragmentShader
-- Copyright   :  (c) Sven Panne 2015
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- The <https://www.opengl.org/registry/specs/ATI/fragment_shader.txt ATI_fragment_shader> extension.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.ATI.FragmentShader (
  -- * Enums
  gl_2X_BIT_ATI,
  gl_4X_BIT_ATI,
  gl_8X_BIT_ATI,
  gl_ADD_ATI,
  gl_BIAS_BIT_ATI,
  gl_BLUE_BIT_ATI,
  gl_CND0_ATI,
  gl_CND_ATI,
  gl_COLOR_ALPHA_PAIRING_ATI,
  gl_COMP_BIT_ATI,
  gl_CON_0_ATI,
  gl_CON_10_ATI,
  gl_CON_11_ATI,
  gl_CON_12_ATI,
  gl_CON_13_ATI,
  gl_CON_14_ATI,
  gl_CON_15_ATI,
  gl_CON_16_ATI,
  gl_CON_17_ATI,
  gl_CON_18_ATI,
  gl_CON_19_ATI,
  gl_CON_1_ATI,
  gl_CON_20_ATI,
  gl_CON_21_ATI,
  gl_CON_22_ATI,
  gl_CON_23_ATI,
  gl_CON_24_ATI,
  gl_CON_25_ATI,
  gl_CON_26_ATI,
  gl_CON_27_ATI,
  gl_CON_28_ATI,
  gl_CON_29_ATI,
  gl_CON_2_ATI,
  gl_CON_30_ATI,
  gl_CON_31_ATI,
  gl_CON_3_ATI,
  gl_CON_4_ATI,
  gl_CON_5_ATI,
  gl_CON_6_ATI,
  gl_CON_7_ATI,
  gl_CON_8_ATI,
  gl_CON_9_ATI,
  gl_DOT2_ADD_ATI,
  gl_DOT3_ATI,
  gl_DOT4_ATI,
  gl_EIGHTH_BIT_ATI,
  gl_FRAGMENT_SHADER_ATI,
  gl_GREEN_BIT_ATI,
  gl_HALF_BIT_ATI,
  gl_LERP_ATI,
  gl_MAD_ATI,
  gl_MOV_ATI,
  gl_MUL_ATI,
  gl_NEGATE_BIT_ATI,
  gl_NUM_FRAGMENT_CONSTANTS_ATI,
  gl_NUM_FRAGMENT_REGISTERS_ATI,
  gl_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI,
  gl_NUM_INSTRUCTIONS_PER_PASS_ATI,
  gl_NUM_INSTRUCTIONS_TOTAL_ATI,
  gl_NUM_LOOPBACK_COMPONENTS_ATI,
  gl_NUM_PASSES_ATI,
  gl_QUARTER_BIT_ATI,
  gl_RED_BIT_ATI,
  gl_REG_0_ATI,
  gl_REG_10_ATI,
  gl_REG_11_ATI,
  gl_REG_12_ATI,
  gl_REG_13_ATI,
  gl_REG_14_ATI,
  gl_REG_15_ATI,
  gl_REG_16_ATI,
  gl_REG_17_ATI,
  gl_REG_18_ATI,
  gl_REG_19_ATI,
  gl_REG_1_ATI,
  gl_REG_20_ATI,
  gl_REG_21_ATI,
  gl_REG_22_ATI,
  gl_REG_23_ATI,
  gl_REG_24_ATI,
  gl_REG_25_ATI,
  gl_REG_26_ATI,
  gl_REG_27_ATI,
  gl_REG_28_ATI,
  gl_REG_29_ATI,
  gl_REG_2_ATI,
  gl_REG_30_ATI,
  gl_REG_31_ATI,
  gl_REG_3_ATI,
  gl_REG_4_ATI,
  gl_REG_5_ATI,
  gl_REG_6_ATI,
  gl_REG_7_ATI,
  gl_REG_8_ATI,
  gl_REG_9_ATI,
  gl_SATURATE_BIT_ATI,
  gl_SECONDARY_INTERPOLATOR_ATI,
  gl_SUB_ATI,
  gl_SWIZZLE_STQ_ATI,
  gl_SWIZZLE_STQ_DQ_ATI,
  gl_SWIZZLE_STRQ_ATI,
  gl_SWIZZLE_STRQ_DQ_ATI,
  gl_SWIZZLE_STR_ATI,
  gl_SWIZZLE_STR_DR_ATI,
  -- * Functions
  glAlphaFragmentOp1ATI,
  glAlphaFragmentOp2ATI,
  glAlphaFragmentOp3ATI,
  glBeginFragmentShaderATI,
  glBindFragmentShaderATI,
  glColorFragmentOp1ATI,
  glColorFragmentOp2ATI,
  glColorFragmentOp3ATI,
  glDeleteFragmentShaderATI,
  glEndFragmentShaderATI,
  glGenFragmentShadersATI,
  glPassTexCoordATI,
  glSampleMapATI,
  glSetFragmentShaderConstantATI
) where

import Graphics.Rendering.OpenGL.Raw.Tokens
import Graphics.Rendering.OpenGL.Raw.Functions
