Gradle Kotlin DSL 0.11.1 Release Notes
============================

Gradle Kotlin DSL v0.11.1 brings the latest and greatest Kotlin (**1.1.4-3**) and takes big steps toward general usability with utilities for Groovy-heavy DSLs such as Maven POM customization, Ant usage and those provided by Groovy-biased community plugins.
 
v0.11.1 is expected to be included in the upcoming Gradle 4.2 RC1.

The features in this release are also available for immediate use within the latest Gradle Kotlin DSL distribution snapshot. To use it, upgrade your Gradle wrapper in the following fashion:

    $ cd $YOUR_PROJECT_ROOT
    $ gradle wrapper --gradle-distribution-url https://repo.gradle.org/gradle/dist-snapshots/gradle-kotlin-dsl-4.2-20170901130305+0000-all.zip

Once Gradle 4.2 RC1 is out, we encourage all users to upgrade in the following fashion:

    $ cd $YOUR_PROJECT_ROOT
    $ gradle wrapper --gradle-version 4.2-rc-1 --distribution-type all


Updates since v0.10.3
----------------------

 * **Kotlin 1.1.4-3** ([#414][issue-414]). Bringing performance improvements and [more](https://blog.jetbrains.com/kotlin/2017/08/kotlin-1-1-4-is-out/).

 * **Better support for Groovy-heavy DSLs** ([#142][issue-142], [#47][issue-47], [#259][issue-259]). With the introduction of the `withGroovyBuilder` and `withConvention` utility extensions. `withGroovyBuilder` provides a dynamic dispatching DSL with Groovy semantics for better integration with plugins that rely on Groovy builders such as the core `maven` plugin.

   It supports Groovy keyword arguments and arbitrary nesting, for instance, the following Groovy code,

   ```Groovy
   repository(url: "scp://repos.mycompany.com/releases") {
     authentication(userName: "me", password: "myPassword")
   }
   ```

   can be mechanically translated to the following Kotlin with the aid of `withGroovyBuilder` to:

   ```Kotlin
   withGroovyBuilder {
     "repository"("url" to "scp://repos.mycompany.com/releases") {
       "authentication"("userName" to "me", "password" to "myPassword")
     }
   }
   ```

   Check out the [maven plugin configuration sample](https://github.com/gradle/kotlin-dsl/blob/75eff6bff118253852d5e040831caa7afd7136c3/samples/maven-plugin/build.gradle.kts#L16) and the [ant usage sample](https://github.com/gradle/kotlin-dsl/blob/fc5cd9d444c8917b1e7e9bf828cdd406068c9259/samples/ant/build.gradle.kts) to see these extensions in action. 

 * **Projects using the `kotlin-dsl` plugin can be edited correctly in IntelliJ** ([#373][issue-373]). Before this release, lambda expressions passed as `org.gradle.api.Action<T>` arguments were not being typed accurately and  so `T` member references were highlighted as errors and code completion provided wrong suggestions. These are now working properly except in `buildSrc` projects. 

   ![Gradle plugin screenshot](https://user-images.githubusercontent.com/132773/29875212-83c1f456-8d99-11e7-84f7-987b3c34164c.png)

 * **Seamless testing for projects using the `kotlin-dsl` plugin** ([#450][issue-450]). As the `gradleKotlinDsl()` dependency is now added to the `testRuntimeOnly` configuration.
 
 * **IntelliJ IDEA resolves Gradle script classpath asynchronously** ([#355][issue-355]). A long awaited feature, IntelliJ no longer blocks the editor while the classpath of the open script is being resolved.

 * **Maven repository shortcut** ([#256][issue-256]). Due to popular demand a shortcut has been added to the DSL that simplifies the configuration of `maven` repositories.

   Instead of writing:

   ```Kotlin
   repositories {
       maven { url = uri("...") }
   }
   ```

   Users can now simply write:

   ```Kotlin
   repositories {
       maven(url = "...") // or maven("...")
   }
   ```

  * **Improved Gradle API null safety** ([#403][issue-403], [#420][issue-420]). An effort is under way to add nullability annotations to the whole Gradle API. Expect more improvements in upcoming releases.

 * **New samples** ([#456][issue-456], [#260][issue-260]). A new sample demonstrating how to write [a Kotlin DSL friendly Gradle plugin in Groovy](https://github.com/gradle/kotlin-dsl/blob/2ac84ffa73a0c786560e16c562d2b57d6900fbb9/samples/kotlin-friendly-groovy-plugin/plugin/src/main/groovy/my/DocumentationPlugin.groovy#L5) has been added as well as another one demonstrating [how to configure the (now deprecated) Software Model in Kotlin](https://github.com/gradle/kotlin-dsl/blob/68206dceb2d86a5e33fc4169d7dc15039c5289e2/samples/model-rules/buildSrc/src/main/kotlin/my/model_rules.kt#L16).

 * **`applyFrom(uri)` removed from the DSL** ([#444][issue-444]). For symmetry, scripts should use `apply { from(uri) }` instead.
 
[issue-47]: https://github.com/gradle/kotlin-dsl/issues/47
[issue-142]: https://github.com/gradle/kotlin-dsl/issues/142
[issue-256]: https://github.com/gradle/kotlin-dsl/issues/256
[issue-260]: https://github.com/gradle/kotlin-dsl/issues/260
[issue-259]: https://github.com/gradle/kotlin-dsl/issues/259
[issue-355]: https://github.com/gradle/kotlin-dsl/issues/355
[issue-373]: https://github.com/gradle/kotlin-dsl/issues/373
[issue-403]: https://github.com/gradle/kotlin-dsl/issues/403
[issue-420]: https://github.com/gradle/kotlin-dsl/issues/420
[issue-414]: https://github.com/gradle/kotlin-dsl/issues/414
[issue-444]: https://github.com/gradle/kotlin-dsl/issues/444
[issue-450]: https://github.com/gradle/kotlin-dsl/issues/450
[issue-456]: https://github.com/gradle/kotlin-dsl/issues/456
