/* gkrellm-thinkbat.h - gkrellm-ThinkBat a Thinkpad battery monitor for Gkrellm2
 *
 * Copyright (C) 2006 Rasto Sramek <rasto@ksp.sk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define PIC_NONE        0
#define PIC_AC          1
#define PIC_BATT        2

#define TIME_POWER_NOW  20

#define CONFIG_NAME 	"ThinkBat"
#define STYLE_NAME 	"ThinkBat"

static GkrellmMonitor	*monitor;
static GkrellmPanel	*panel_top, *panel_bottom;
static GkrellmDecal	*decal_percent = NULL, *decal_time = NULL, *decal_watt = NULL, *decal_pixmap = NULL;
static GkrellmAlert	*alert;
static GkrellmKrell	*krell;
static gint		style_id;
static GtkWidget 	*show_all_button, *invoke_adj;
static gint 		show_all_button_val;
gint 			power_old, time_offline, invoke_time;

static gint panel_top_expose_event(GtkWidget *widget, GdkEventExpose *ev);
static gint panel_bottom_expose_event(GtkWidget *widget, GdkEventExpose *ev);
static gint panel_click_event(GtkWidget * widget, GdkEventButton * ev);
static void create_plugin(GtkWidget *vbox, gint first_create) ;
static void create_plugin_config(GtkWidget *vbox);
static void apply_plugin_config(void);
static void save_plugin_config(FILE *file);
static void load_plugin_config(gchar *arg);
static void alert_trigger_callback(GkrellmAlert *alert, gpointer data);
static void create_alert(void);
static void set_alert(GtkWidget *entry, gpointer data);
static void update_plugin();
GkrellmMonitor *gkrellm_init_plugin();

static gchar plugin_desc[] = "gkrellm-ThinkBat " VERSION "\nThinkPad SMAPI batteries "
	"monitoring plugin\n\nCopyright (C) 2006 Rasto Sramek <rasto@ksp.sk>\n\nReleased "
	"under the GNU General Public License";


static GkrellmMonitor plugin_mon = {
	CONFIG_NAME,		/* Name, for config tab.    */
	0,			/* Id,  0 if a plugin       */
	create_plugin,		/* The create function      */
	update_plugin,		/* The update function      */
	create_plugin_config,	/* The config tab create function   */
	apply_plugin_config,	/* Apply the config function        */
	save_plugin_config,	/* Save user config */
	load_plugin_config,	/* Load user config */
	"ThinkBat",		/* config keyword */
	
	NULL,			/* Undefined 2  */
	NULL,			/* Undefined 1  */
	NULL,			/* private      */
	
	MON_BATTERY,		/* Insert plugin before this monitor            */
	
	NULL,			/* Handle if a plugin, filled in by GKrellM     */
	NULL			/* path if a plugin, filled in by GKrellM       */
};

