#!/bin/sh 

set -e

# called by uscan with '--upstream-version' <version> <file>
echo "version $2"
package=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
version=$2
tarball=$3
TAR=${package}_${version}.orig.tar.gz
DIR=${package}-${version}.orig
REPO="http://svn.apache.org/repos/asf/geronimo/specs/tags/${package}-${version}/"

# setting timezone to avoid varying times
TZ=Etc/UTC svn export $REPO $DIR
GZIP=--best tar --numeric --group 0 --owner 0 -c -v -z -f $TAR $DIR

rm -rf $tarball $DIR
