/* pdphandler.c generated by valac 0.16.1, the Vala compiler
 * generated from pdphandler.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsogsm.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <freesmartphone.h>
#include <fsotransport.h>
#include <radio.h>
#include <fsobasics.h>


#define SAMSUNG_TYPE_PDP_HANDLER (samsung_pdp_handler_get_type ())
#define SAMSUNG_PDP_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMSUNG_TYPE_PDP_HANDLER, SamsungPdpHandler))
#define SAMSUNG_PDP_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SAMSUNG_TYPE_PDP_HANDLER, SamsungPdpHandlerClass))
#define SAMSUNG_IS_PDP_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMSUNG_TYPE_PDP_HANDLER))
#define SAMSUNG_IS_PDP_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMSUNG_TYPE_PDP_HANDLER))
#define SAMSUNG_PDP_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SAMSUNG_TYPE_PDP_HANDLER, SamsungPdpHandlerClass))

typedef struct _SamsungPdpHandler SamsungPdpHandler;
typedef struct _SamsungPdpHandlerClass SamsungPdpHandlerClass;
typedef struct _SamsungPdpHandlerPrivate SamsungPdpHandlerPrivate;
#define _fso_gsm_context_params_unref0(var) ((var == NULL) ? NULL : (var = (fso_gsm_context_params_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SAMSUNG_TYPE_IPC_CHANNEL (samsung_ipc_channel_get_type ())
#define SAMSUNG_IPC_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannel))
#define SAMSUNG_IPC_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannelClass))
#define SAMSUNG_IS_IPC_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMSUNG_TYPE_IPC_CHANNEL))
#define SAMSUNG_IS_IPC_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMSUNG_TYPE_IPC_CHANNEL))
#define SAMSUNG_IPC_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannelClass))

typedef struct _SamsungIpcChannel SamsungIpcChannel;
typedef struct _SamsungIpcChannelClass SamsungIpcChannelClass;
typedef struct _samsung_pdp_handler_setupPdpContextData samsung_pdp_handler_setupPdpContextData;
typedef struct _samsung_pdp_handler_activatePdpContextData samsung_pdp_handler_activatePdpContextData;
typedef struct _samsung_pdp_handler_deactivatePdpContextData samsung_pdp_handler_deactivatePdpContextData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fso_gsm_route_info_unref0(var) ((var == NULL) ? NULL : (var = (fso_gsm_route_info_unref (var), NULL)))
typedef struct _samsung_pdp_handler_handleIpConfigurationData samsung_pdp_handler_handleIpConfigurationData;
typedef struct _SamsungPdpHandlerScActivateData SamsungPdpHandlerScActivateData;
typedef struct _SamsungPdpHandlerScDeactivateData SamsungPdpHandlerScDeactivateData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _samsung_pdp_handler_statusUpdateData samsung_pdp_handler_statusUpdateData;

struct _SamsungPdpHandler {
	FsoGsmPdpHandler parent_instance;
	SamsungPdpHandlerPrivate * priv;
};

struct _SamsungPdpHandlerClass {
	FsoGsmPdpHandlerClass parent_class;
};

struct _samsung_pdp_handler_setupPdpContextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungPdpHandler* self;
	FsoGsmContextParams* contextParams;
	FsoGsmModem* _tmp0_;
	FsoGsmModem* _tmp1_;
	FsoGsmChannel* _tmp2_;
	SamsungIpcChannel* channel;
	struct ipc_message_info* response;
	struct ipc_gprs_define_pdp_context contextSetupMessage;
	FsoGsmContextParams* _tmp3_;
	const gchar* _tmp4_;
	SamsungIpcChannel* _tmp5_;
	struct ipc_gprs_define_pdp_context _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	guint8* _tmp8_;
	gint _tmp8__length1;
	struct ipc_message_info* _tmp9_;
	struct ipc_message_info* _tmp10_;
	GError* _tmp11_;
	struct ipc_message_info* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	struct ipc_gen_phone_res* r;
	struct ipc_gen_phone_res* _tmp14_;
	guint16 _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _samsung_pdp_handler_activatePdpContextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungPdpHandler* self;
	FsoGsmContextParams* contextParams;
	FsoGsmModem* _tmp0_;
	FsoGsmModem* _tmp1_;
	FsoGsmChannel* _tmp2_;
	SamsungIpcChannel* channel;
	struct ipc_message_info* response;
	struct ipc_gprs_pdp_context contextActMessage;
	FsoGsmContextParams* _tmp3_;
	const gchar* _tmp4_;
	FsoGsmContextParams* _tmp5_;
	const gchar* _tmp6_;
	SamsungIpcChannel* _tmp7_;
	struct ipc_gprs_pdp_context _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	struct ipc_message_info* _tmp11_;
	struct ipc_message_info* _tmp12_;
	GError* _tmp13_;
	GError * _inner_error_;
};

struct _samsung_pdp_handler_deactivatePdpContextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungPdpHandler* self;
	FsoGsmModem* _tmp0_;
	FsoGsmModem* _tmp1_;
	FsoGsmChannel* _tmp2_;
	SamsungIpcChannel* channel;
	struct ipc_message_info* response;
	struct ipc_gprs_pdp_context contextDeactMessage;
	SamsungIpcChannel* _tmp3_;
	struct ipc_gprs_pdp_context _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	struct ipc_message_info* _tmp7_;
	struct ipc_message_info* _tmp8_;
	GError* _tmp9_;
	GError * _inner_error_;
};

struct _samsung_pdp_handler_handleIpConfigurationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungPdpHandler* self;
	gchar* local;
	gchar* subnetmask;
	gchar* gateway;
	gchar* dns1;
	gchar* dns2;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	FsoFrameworkLogger* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	FsoGsmRouteInfo* _tmp30_;
	FsoGsmRouteInfo* route;
};

struct _SamsungPdpHandlerScActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungPdpHandler* self;
	FsoGsmModem* _tmp0_;
	FsoGsmModem* _tmp1_;
	FsoGsmModemData* _tmp2_;
	FsoGsmModemData* _tmp3_;
	FsoGsmContextParams* _tmp4_;
	gboolean _tmp5_;
	GError* _tmp6_;
	FsoGsmModem* _tmp7_;
	FsoGsmModem* _tmp8_;
	FsoGsmModemData* _tmp9_;
	FsoGsmModemData* _tmp10_;
	FsoGsmContextParams* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	GError* _tmp14_;
	FsoGsmModem* _tmp15_;
	FsoGsmModem* _tmp16_;
	FsoGsmModemData* _tmp17_;
	FsoGsmModemData* _tmp18_;
	FsoGsmContextParams* _tmp19_;
	FsoGsmModem* _tmp20_;
	FsoGsmModem* _tmp21_;
	FsoGsmModemData* _tmp22_;
	FsoGsmModemData* _tmp23_;
	FsoGsmContextParams* _tmp24_;
	GError * _inner_error_;
};

struct _SamsungPdpHandlerScDeactivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungPdpHandler* self;
	GError * _inner_error_;
};

struct _samsung_pdp_handler_statusUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungPdpHandler* self;
	gchar* status;
	GHashTable* properties;
};


static gpointer samsung_pdp_handler_parent_class = NULL;
static GType samsung_pdp_handler_type_id = 0;

GType samsung_pdp_handler_get_type (void) G_GNUC_CONST;
GType samsung_pdp_handler_register_type (GTypeModule * module);
enum  {
	SAMSUNG_PDP_HANDLER_DUMMY_PROPERTY
};
#define SAMSUNG_PDP_HANDLER_RMNET_IFACE "rmnet0"
static void samsung_pdp_handler_setupPdpContext_data_free (gpointer _data);
static void samsung_pdp_handler_setupPdpContext (SamsungPdpHandler* self, FsoGsmContextParams* contextParams, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void samsung_pdp_handler_setupPdpContext_finish (SamsungPdpHandler* self, GAsyncResult* _res_, GError** error);
static gboolean samsung_pdp_handler_setupPdpContext_co (samsung_pdp_handler_setupPdpContextData* _data_);
GType samsung_ipc_channel_get_type (void) G_GNUC_CONST;
GType samsung_ipc_channel_register_type (GTypeModule * module);
void samsung_ipc_channel_enqueue_async (SamsungIpcChannel* self, int type, unsigned short command, guint8* data, int data_length1, gint retry, gint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_);
struct ipc_message_info* samsung_ipc_channel_enqueue_finish (SamsungIpcChannel* self, GAsyncResult* _res_);
static void samsung_pdp_handler_setupPdpContext_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_pdp_handler_activatePdpContext_data_free (gpointer _data);
static void samsung_pdp_handler_activatePdpContext (SamsungPdpHandler* self, FsoGsmContextParams* contextParams, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void samsung_pdp_handler_activatePdpContext_finish (SamsungPdpHandler* self, GAsyncResult* _res_, GError** error);
static gboolean samsung_pdp_handler_activatePdpContext_co (samsung_pdp_handler_activatePdpContextData* _data_);
static void samsung_pdp_handler_activatePdpContext_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_pdp_handler_deactivatePdpContext_data_free (gpointer _data);
static void samsung_pdp_handler_deactivatePdpContext (SamsungPdpHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void samsung_pdp_handler_deactivatePdpContext_finish (SamsungPdpHandler* self, GAsyncResult* _res_, GError** error);
static gboolean samsung_pdp_handler_deactivatePdpContext_co (samsung_pdp_handler_deactivatePdpContextData* _data_);
static void samsung_pdp_handler_deactivatePdpContext_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_pdp_handler_handleIpConfiguration_data_free (gpointer _data);
void samsung_pdp_handler_handleIpConfiguration (SamsungPdpHandler* self, const gchar* local, const gchar* subnetmask, const gchar* gateway, const gchar* dns1, const gchar* dns2, GAsyncReadyCallback _callback_, gpointer _user_data_);
void samsung_pdp_handler_handleIpConfiguration_finish (SamsungPdpHandler* self, GAsyncResult* _res_);
static gboolean samsung_pdp_handler_handleIpConfiguration_co (samsung_pdp_handler_handleIpConfigurationData* _data_);
static void samsung_pdp_handler_real_sc_activate_data_free (gpointer _data);
static void samsung_pdp_handler_real_sc_activate (FsoGsmPdpHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_pdp_handler_real_sc_activate_co (SamsungPdpHandlerScActivateData* _data_);
static void samsung_pdp_handler_sc_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_pdp_handler_real_sc_deactivate_data_free (gpointer _data);
static void samsung_pdp_handler_real_sc_deactivate (FsoGsmPdpHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_pdp_handler_real_sc_deactivate_co (SamsungPdpHandlerScDeactivateData* _data_);
static void samsung_pdp_handler_sc_deactivate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_pdp_handler_real_statusUpdate_data_free (gpointer _data);
static void samsung_pdp_handler_real_statusUpdate (FsoGsmPdpHandler* base, const gchar* status, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_pdp_handler_real_statusUpdate_co (samsung_pdp_handler_statusUpdateData* _data_);
static gchar* samsung_pdp_handler_real_repr (FsoFrameworkAbstractObject* base);
SamsungPdpHandler* samsung_pdp_handler_new (void);
SamsungPdpHandler* samsung_pdp_handler_construct (GType object_type);


static void samsung_pdp_handler_setupPdpContext_data_free (gpointer _data) {
	samsung_pdp_handler_setupPdpContextData* _data_;
	_data_ = _data;
	_fso_gsm_context_params_unref0 (_data_->contextParams);
	_g_object_unref0 (_data_->self);
	g_slice_free (samsung_pdp_handler_setupPdpContextData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _fso_gsm_context_params_ref0 (gpointer self) {
	return self ? fso_gsm_context_params_ref (self) : NULL;
}


static void samsung_pdp_handler_setupPdpContext (SamsungPdpHandler* self, FsoGsmContextParams* contextParams, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	samsung_pdp_handler_setupPdpContextData* _data_;
	SamsungPdpHandler* _tmp0_;
	FsoGsmContextParams* _tmp1_;
	FsoGsmContextParams* _tmp2_;
	_data_ = g_slice_new0 (samsung_pdp_handler_setupPdpContextData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_pdp_handler_setupPdpContext);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_pdp_handler_setupPdpContext_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contextParams;
	_tmp2_ = _fso_gsm_context_params_ref0 (_tmp1_);
	_data_->contextParams = _tmp2_;
	samsung_pdp_handler_setupPdpContext_co (_data_);
}


static void samsung_pdp_handler_setupPdpContext_finish (SamsungPdpHandler* self, GAsyncResult* _res_, GError** error) {
	samsung_pdp_handler_setupPdpContextData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Define a new PDP context with the modem we will use in the following steps to setup
     * the GPRS data connection.
     **/
static guint8* samsung_ipc_gprs_define_pdp_context_message_get_data (struct ipc_gprs_define_pdp_context* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) (&(*self));
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = (gint) sizeof (struct ipc_gprs_define_pdp_context);
	_tmp0_ = res_length1;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static void samsung_pdp_handler_setupPdpContext_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	samsung_pdp_handler_setupPdpContextData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_pdp_handler_setupPdpContext_co (_data_);
}


static gboolean samsung_pdp_handler_setupPdpContext_co (samsung_pdp_handler_setupPdpContextData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_pdp_handler_get_modem ((FsoGsmPdpHandler*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = fso_gsm_modem_channel (_data_->_tmp1_, "main");
	_data_->channel = SAMSUNG_IS_IPC_CHANNEL (_data_->_tmp2_) ? ((SamsungIpcChannel*) _data_->_tmp2_) : NULL;
	_data_->response = NULL;
	memset (&_data_->contextSetupMessage, 0, sizeof (struct ipc_gprs_define_pdp_context));
	_data_->_tmp3_ = _data_->contextParams;
	_data_->_tmp4_ = _data_->_tmp3_->apn;
	ipc_gprs_define_pdp_context_setup (&_data_->contextSetupMessage, _data_->_tmp4_);
	_data_->_tmp5_ = _data_->channel;
	_data_->_tmp6_ = _data_->contextSetupMessage;
	_data_->_tmp7_ = samsung_ipc_gprs_define_pdp_context_message_get_data (&_data_->_tmp6_, &_data_->_tmp7__length1);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp8__length1 = _data_->_tmp7__length1;
	_data_->_state_ = 1;
	samsung_ipc_channel_enqueue_async (_data_->_tmp5_, IPC_TYPE_SET, IPC_GPRS_DEFINE_PDP_CONTEXT, _data_->_tmp8_, _data_->_tmp8__length1, 0, 5, samsung_pdp_handler_setupPdpContext_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = samsung_ipc_channel_enqueue_finish (_data_->_tmp5_, _data_->_res_);
	_data_->response = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->response;
	if (_data_->_tmp10_ == NULL) {
		_data_->_tmp11_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, "Did not receive a response from modem for PDP context setup");
		_data_->_inner_error_ = _data_->_tmp11_;
		if (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			 (&_data_->contextSetupMessage);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			 (&_data_->contextSetupMessage);
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp12_ = _data_->response;
	_data_->_tmp13_ = (*_data_->_tmp12_).data;
	_data_->_tmp13__length1 = (*_data_->_tmp12_).length;
	_data_->r = (struct ipc_gen_phone_res*) _data_->_tmp13_;
	_data_->_tmp14_ = _data_->r;
	_data_->_tmp15_ = (*_data_->_tmp14_).code;
	if (_data_->_tmp15_ == IPC_GPRS_ERROR_UNAVAILABLE) {
		_data_->_tmp16_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, "It is not possible to setup a PDP context yet");
		_data_->_inner_error_ = _data_->_tmp16_;
		if (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			 (&_data_->contextSetupMessage);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			 (&_data_->contextSetupMessage);
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	 (&_data_->contextSetupMessage);
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_pdp_handler_activatePdpContext_data_free (gpointer _data) {
	samsung_pdp_handler_activatePdpContextData* _data_;
	_data_ = _data;
	_fso_gsm_context_params_unref0 (_data_->contextParams);
	_g_object_unref0 (_data_->self);
	g_slice_free (samsung_pdp_handler_activatePdpContextData, _data_);
}


static void samsung_pdp_handler_activatePdpContext (SamsungPdpHandler* self, FsoGsmContextParams* contextParams, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	samsung_pdp_handler_activatePdpContextData* _data_;
	SamsungPdpHandler* _tmp0_;
	FsoGsmContextParams* _tmp1_;
	FsoGsmContextParams* _tmp2_;
	_data_ = g_slice_new0 (samsung_pdp_handler_activatePdpContextData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_pdp_handler_activatePdpContext);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_pdp_handler_activatePdpContext_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contextParams;
	_tmp2_ = _fso_gsm_context_params_ref0 (_tmp1_);
	_data_->contextParams = _tmp2_;
	samsung_pdp_handler_activatePdpContext_co (_data_);
}


static void samsung_pdp_handler_activatePdpContext_finish (SamsungPdpHandler* self, GAsyncResult* _res_, GError** error) {
	samsung_pdp_handler_activatePdpContextData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * This will activate an already defined PDP context.
     **/
static guint8* samsung_ipc_gprs_pdp_context_message_get_data (struct ipc_gprs_pdp_context* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) (&(*self));
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = (gint) sizeof (struct ipc_gprs_pdp_context);
	_tmp0_ = res_length1;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static void samsung_pdp_handler_activatePdpContext_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	samsung_pdp_handler_activatePdpContextData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_pdp_handler_activatePdpContext_co (_data_);
}


static gboolean samsung_pdp_handler_activatePdpContext_co (samsung_pdp_handler_activatePdpContextData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_pdp_handler_get_modem ((FsoGsmPdpHandler*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = fso_gsm_modem_channel (_data_->_tmp1_, "main");
	_data_->channel = SAMSUNG_IS_IPC_CHANNEL (_data_->_tmp2_) ? ((SamsungIpcChannel*) _data_->_tmp2_) : NULL;
	_data_->response = NULL;
	memset (&_data_->contextActMessage, 0, sizeof (struct ipc_gprs_pdp_context));
	_data_->_tmp3_ = _data_->contextParams;
	_data_->_tmp4_ = _data_->_tmp3_->username;
	_data_->_tmp5_ = _data_->contextParams;
	_data_->_tmp6_ = _data_->_tmp5_->password;
	ipc_gprs_pdp_context_setup (&_data_->contextActMessage, TRUE, _data_->_tmp4_, _data_->_tmp6_);
	_data_->_tmp7_ = _data_->channel;
	_data_->_tmp8_ = _data_->contextActMessage;
	_data_->_tmp9_ = samsung_ipc_gprs_pdp_context_message_get_data (&_data_->_tmp8_, &_data_->_tmp9__length1);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp10__length1 = _data_->_tmp9__length1;
	_data_->_state_ = 1;
	samsung_ipc_channel_enqueue_async (_data_->_tmp7_, IPC_TYPE_SET, IPC_GPRS_PDP_CONTEXT, _data_->_tmp10_, _data_->_tmp10__length1, 0, 5, samsung_pdp_handler_activatePdpContext_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = samsung_ipc_channel_enqueue_finish (_data_->_tmp7_, _data_->_res_);
	_data_->response = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->response;
	if (_data_->_tmp12_ == NULL) {
		_data_->_tmp13_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, "Did not receive a response for PDP context activation");
		_data_->_inner_error_ = _data_->_tmp13_;
		if (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			 (&_data_->contextActMessage);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			 (&_data_->contextActMessage);
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	 (&_data_->contextActMessage);
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_pdp_handler_deactivatePdpContext_data_free (gpointer _data) {
	samsung_pdp_handler_deactivatePdpContextData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (samsung_pdp_handler_deactivatePdpContextData, _data_);
}


static void samsung_pdp_handler_deactivatePdpContext (SamsungPdpHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	samsung_pdp_handler_deactivatePdpContextData* _data_;
	SamsungPdpHandler* _tmp0_;
	_data_ = g_slice_new0 (samsung_pdp_handler_deactivatePdpContextData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_pdp_handler_deactivatePdpContext);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_pdp_handler_deactivatePdpContext_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_pdp_handler_deactivatePdpContext_co (_data_);
}


static void samsung_pdp_handler_deactivatePdpContext_finish (SamsungPdpHandler* self, GAsyncResult* _res_, GError** error) {
	samsung_pdp_handler_deactivatePdpContextData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * This will deactivate the currently active PDP context
     **/
static void samsung_pdp_handler_deactivatePdpContext_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	samsung_pdp_handler_deactivatePdpContextData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_pdp_handler_deactivatePdpContext_co (_data_);
}


static gboolean samsung_pdp_handler_deactivatePdpContext_co (samsung_pdp_handler_deactivatePdpContextData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_pdp_handler_get_modem ((FsoGsmPdpHandler*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = fso_gsm_modem_channel (_data_->_tmp1_, "main");
	_data_->channel = SAMSUNG_IS_IPC_CHANNEL (_data_->_tmp2_) ? ((SamsungIpcChannel*) _data_->_tmp2_) : NULL;
	_data_->response = NULL;
	memset (&_data_->contextDeactMessage, 0, sizeof (struct ipc_gprs_pdp_context));
	ipc_gprs_pdp_context_setup (&_data_->contextDeactMessage, FALSE, NULL, NULL);
	_data_->_tmp3_ = _data_->channel;
	_data_->_tmp4_ = _data_->contextDeactMessage;
	_data_->_tmp5_ = samsung_ipc_gprs_pdp_context_message_get_data (&_data_->_tmp4_, &_data_->_tmp5__length1);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp5__length1;
	_data_->_state_ = 1;
	samsung_ipc_channel_enqueue_async (_data_->_tmp3_, IPC_TYPE_SET, IPC_GPRS_PDP_CONTEXT, _data_->_tmp6_, _data_->_tmp6__length1, 0, 5, samsung_pdp_handler_deactivatePdpContext_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = samsung_ipc_channel_enqueue_finish (_data_->_tmp3_, _data_->_res_);
	_data_->response = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->response;
	if (_data_->_tmp8_ == NULL) {
		_data_->_tmp9_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, "Did not receive a reponse for PDP context deactivation");
		_data_->_inner_error_ = _data_->_tmp9_;
		if (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			 (&_data_->contextDeactMessage);
			_g_object_unref0 (_data_->channel);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			 (&_data_->contextDeactMessage);
			_g_object_unref0 (_data_->channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	 (&_data_->contextDeactMessage);
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_pdp_handler_handleIpConfiguration_data_free (gpointer _data) {
	samsung_pdp_handler_handleIpConfigurationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->local);
	_g_free0 (_data_->subnetmask);
	_g_free0 (_data_->gateway);
	_g_free0 (_data_->dns1);
	_g_free0 (_data_->dns2);
	_g_object_unref0 (_data_->self);
	g_slice_free (samsung_pdp_handler_handleIpConfigurationData, _data_);
}


void samsung_pdp_handler_handleIpConfiguration (SamsungPdpHandler* self, const gchar* local, const gchar* subnetmask, const gchar* gateway, const gchar* dns1, const gchar* dns2, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	samsung_pdp_handler_handleIpConfigurationData* _data_;
	SamsungPdpHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	_data_ = g_slice_new0 (samsung_pdp_handler_handleIpConfigurationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_pdp_handler_handleIpConfiguration);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_pdp_handler_handleIpConfiguration_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = local;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->local = _tmp2_;
	_tmp3_ = subnetmask;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->subnetmask = _tmp4_;
	_tmp5_ = gateway;
	_tmp6_ = g_strdup (_tmp5_);
	_data_->gateway = _tmp6_;
	_tmp7_ = dns1;
	_tmp8_ = g_strdup (_tmp7_);
	_data_->dns1 = _tmp8_;
	_tmp9_ = dns2;
	_tmp10_ = g_strdup (_tmp9_);
	_data_->dns2 = _tmp10_;
	samsung_pdp_handler_handleIpConfiguration_co (_data_);
}


void samsung_pdp_handler_handleIpConfiguration_finish (SamsungPdpHandler* self, GAsyncResult* _res_) {
	samsung_pdp_handler_handleIpConfigurationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * We need to wait a little bit until the modem sends us the IP configuration for
     * acccess the packet switched network. If we finally receive the configuration data
     * we setup the IP connection locally.
     **/
static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean samsung_pdp_handler_handleIpConfiguration_co (samsung_pdp_handler_handleIpConfigurationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = fso_framework_logger_debug (_data_->_tmp0_, "Got IP configuration from modem:");
	g_assert (_data_->_tmp1_);
	_data_->_tmp2_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp3_ = _data_->local;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = string_to_string (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->subnetmask;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strconcat ("local = ", _data_->_tmp4_, ", subnetmask = ", _data_->_tmp6_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = FALSE;
	_data_->_tmp9_ = fso_framework_logger_debug (_data_->_tmp2_, _data_->_tmp8_);
	g_assert (_data_->_tmp9_);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp10_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp11_ = _data_->gateway;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = string_to_string (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->dns1;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = string_to_string (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->dns2;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = string_to_string (_data_->_tmp15_);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_strconcat ("gateway = ", _data_->_tmp12_, ", dns1 = ", _data_->_tmp14_, ", dns2 = ", _data_->_tmp16_, NULL);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = FALSE;
	_data_->_tmp19_ = fso_framework_logger_debug (_data_->_tmp10_, _data_->_tmp18_);
	g_assert (_data_->_tmp19_);
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp20_ = g_strdup (SAMSUNG_PDP_HANDLER_RMNET_IFACE);
	_data_->_tmp21_ = _data_->local;
	_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
	_data_->_tmp23_ = g_strdup ("255.255.255.0");
	_data_->_tmp24_ = _data_->local;
	_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->dns1;
	_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
	_data_->_tmp28_ = _data_->dns2;
	_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = fso_gsm_route_info_new ();
	_g_free0 (_data_->_tmp30_->iface);
	_data_->_tmp30_->iface = _data_->_tmp20_;
	_g_free0 (_data_->_tmp30_->ipv4addr);
	_data_->_tmp30_->ipv4addr = _data_->_tmp22_;
	_g_free0 (_data_->_tmp30_->ipv4mask);
	_data_->_tmp30_->ipv4mask = _data_->_tmp23_;
	_g_free0 (_data_->_tmp30_->ipv4gateway);
	_data_->_tmp30_->ipv4gateway = _data_->_tmp25_;
	_g_free0 (_data_->_tmp30_->dns1);
	_data_->_tmp30_->dns1 = _data_->_tmp27_;
	_g_free0 (_data_->_tmp30_->dns2);
	_data_->_tmp30_->dns2 = _data_->_tmp29_;
	_data_->route = _data_->_tmp30_;
	fso_gsm_ipdp_handler_connectedWithNewDefaultRoute ((FsoGsmIPdpHandler*) _data_->self, _data_->route, NULL, NULL);
	_fso_gsm_route_info_unref0 (_data_->route);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_pdp_handler_real_sc_activate_data_free (gpointer _data) {
	SamsungPdpHandlerScActivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungPdpHandlerScActivateData, _data_);
}


static void samsung_pdp_handler_real_sc_activate (FsoGsmPdpHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungPdpHandler * self;
	SamsungPdpHandlerScActivateData* _data_;
	SamsungPdpHandler* _tmp0_;
	self = (SamsungPdpHandler*) base;
	_data_ = g_slice_new0 (SamsungPdpHandlerScActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_pdp_handler_real_sc_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_pdp_handler_real_sc_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_pdp_handler_real_sc_activate_co (_data_);
}


static void samsung_pdp_handler_real_sc_activate_finish (FsoGsmPdpHandler* base, GAsyncResult* _res_, GError** error) {
	SamsungPdpHandlerScActivateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void samsung_pdp_handler_sc_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungPdpHandlerScActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_pdp_handler_real_sc_activate_co (_data_);
}


static gboolean samsung_pdp_handler_real_sc_activate_co (SamsungPdpHandlerScActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_pdp_handler_get_modem ((FsoGsmPdpHandler*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = fso_gsm_modem_data (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_->contextParams;
	_data_->_tmp5_ = _data_->_tmp4_ == NULL;
	_g_object_unref0 (_data_->_tmp3_);
	if (_data_->_tmp5_) {
		fso_gsm_ipdp_handler_disconnected ((FsoGsmIPdpHandler*) _data_->self);
		_data_->_tmp6_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, "Context parameters not set");
		_data_->_inner_error_ = _data_->_tmp6_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp7_ = fso_gsm_pdp_handler_get_modem ((FsoGsmPdpHandler*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = fso_gsm_modem_data (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->_tmp10_->contextParams;
	_data_->_tmp12_ = _data_->_tmp11_->apn;
	_data_->_tmp13_ = _data_->_tmp12_ == NULL;
	_g_object_unref0 (_data_->_tmp10_);
	if (_data_->_tmp13_) {
		fso_gsm_ipdp_handler_disconnected ((FsoGsmIPdpHandler*) _data_->self);
		_data_->_tmp14_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, "APN not set");
		_data_->_inner_error_ = _data_->_tmp14_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp15_ = fso_gsm_pdp_handler_get_modem ((FsoGsmPdpHandler*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = fso_gsm_modem_data (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = _data_->_tmp18_->contextParams;
	_data_->_state_ = 1;
	samsung_pdp_handler_setupPdpContext (_data_->self, _data_->_tmp19_, samsung_pdp_handler_sc_activate_ready, _data_);
	return FALSE;
	_state_1:
	samsung_pdp_handler_setupPdpContext_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_g_object_unref0 (_data_->_tmp18_);
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp20_ = fso_gsm_pdp_handler_get_modem ((FsoGsmPdpHandler*) _data_->self);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = fso_gsm_modem_data (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = _data_->_tmp23_->contextParams;
	_data_->_state_ = 2;
	samsung_pdp_handler_activatePdpContext (_data_->self, _data_->_tmp24_, samsung_pdp_handler_sc_activate_ready, _data_);
	return FALSE;
	_state_2:
	samsung_pdp_handler_activatePdpContext_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_g_object_unref0 (_data_->_tmp23_);
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_pdp_handler_real_sc_deactivate_data_free (gpointer _data) {
	SamsungPdpHandlerScDeactivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungPdpHandlerScDeactivateData, _data_);
}


static void samsung_pdp_handler_real_sc_deactivate (FsoGsmPdpHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungPdpHandler * self;
	SamsungPdpHandlerScDeactivateData* _data_;
	SamsungPdpHandler* _tmp0_;
	self = (SamsungPdpHandler*) base;
	_data_ = g_slice_new0 (SamsungPdpHandlerScDeactivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_pdp_handler_real_sc_deactivate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_pdp_handler_real_sc_deactivate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_pdp_handler_real_sc_deactivate_co (_data_);
}


static void samsung_pdp_handler_real_sc_deactivate_finish (FsoGsmPdpHandler* base, GAsyncResult* _res_, GError** error) {
	SamsungPdpHandlerScDeactivateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void samsung_pdp_handler_sc_deactivate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungPdpHandlerScDeactivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_pdp_handler_real_sc_deactivate_co (_data_);
}


static gboolean samsung_pdp_handler_real_sc_deactivate_co (SamsungPdpHandlerScDeactivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	samsung_pdp_handler_deactivatePdpContext (_data_->self, samsung_pdp_handler_sc_deactivate_ready, _data_);
	return FALSE;
	_state_1:
	samsung_pdp_handler_deactivatePdpContext_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_pdp_handler_real_statusUpdate_data_free (gpointer _data) {
	samsung_pdp_handler_statusUpdateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->status);
	_g_hash_table_unref0 (_data_->properties);
	_g_object_unref0 (_data_->self);
	g_slice_free (samsung_pdp_handler_statusUpdateData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void samsung_pdp_handler_real_statusUpdate (FsoGsmPdpHandler* base, const gchar* status, GHashTable* properties, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungPdpHandler * self;
	samsung_pdp_handler_statusUpdateData* _data_;
	SamsungPdpHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (SamsungPdpHandler*) base;
	_data_ = g_slice_new0 (samsung_pdp_handler_statusUpdateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_pdp_handler_real_statusUpdate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_pdp_handler_real_statusUpdate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = status;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->status = _tmp2_;
	_tmp3_ = properties;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->properties = _tmp4_;
	samsung_pdp_handler_real_statusUpdate_co (_data_);
}


static void samsung_pdp_handler_real_statusUpdate_finish (FsoGsmPdpHandler* base, GAsyncResult* _res_) {
	samsung_pdp_handler_statusUpdateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean samsung_pdp_handler_real_statusUpdate_co (samsung_pdp_handler_statusUpdateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_assert_not_reached ();
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* samsung_pdp_handler_real_repr (FsoFrameworkAbstractObject* base) {
	SamsungPdpHandler * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (SamsungPdpHandler*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


SamsungPdpHandler* samsung_pdp_handler_construct (GType object_type) {
	SamsungPdpHandler * self = NULL;
	self = (SamsungPdpHandler*) fso_gsm_pdp_handler_construct (object_type);
	return self;
}


SamsungPdpHandler* samsung_pdp_handler_new (void) {
	return samsung_pdp_handler_construct (SAMSUNG_TYPE_PDP_HANDLER);
}


static void samsung_pdp_handler_class_init (SamsungPdpHandlerClass * klass) {
	samsung_pdp_handler_parent_class = g_type_class_peek_parent (klass);
	FSO_GSM_PDP_HANDLER_CLASS (klass)->sc_activate = samsung_pdp_handler_real_sc_activate;
	FSO_GSM_PDP_HANDLER_CLASS (klass)->sc_activate_finish = samsung_pdp_handler_real_sc_activate_finish;
	FSO_GSM_PDP_HANDLER_CLASS (klass)->sc_deactivate = samsung_pdp_handler_real_sc_deactivate;
	FSO_GSM_PDP_HANDLER_CLASS (klass)->sc_deactivate_finish = samsung_pdp_handler_real_sc_deactivate_finish;
	FSO_GSM_PDP_HANDLER_CLASS (klass)->statusUpdate = samsung_pdp_handler_real_statusUpdate;
	FSO_GSM_PDP_HANDLER_CLASS (klass)->statusUpdate_finish = samsung_pdp_handler_real_statusUpdate_finish;
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = samsung_pdp_handler_real_repr;
}


static void samsung_pdp_handler_instance_init (SamsungPdpHandler * self) {
}


/**
 * @class Pdp.SamsungIpc
 *
 * Pdp Handler implements the Samsung IPC protocol handling for PDP sessions
 **/
GType samsung_pdp_handler_get_type (void) {
	return samsung_pdp_handler_type_id;
}


GType samsung_pdp_handler_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (SamsungPdpHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) samsung_pdp_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SamsungPdpHandler), 0, (GInstanceInitFunc) samsung_pdp_handler_instance_init, NULL };
	samsung_pdp_handler_type_id = g_type_module_register_type (module, FSO_GSM_TYPE_PDP_HANDLER, "SamsungPdpHandler", &g_define_type_info, 0);
	return samsung_pdp_handler_type_id;
}



