#!/bin/sh
# Repackage upstream source to xz --best
set -e
set -u

VER="$2"
FILE="$3"
PKG=`dpkg-parsechangelog|grep ^Source:|sed 's/^Source: //'`
UPSTREAM_NAME=`echo $FILE | sed 's/\.\.\///'` 
SRC_NAME=`basename $UPSTREAM_NAME .tar.gz`
REPACK_DIR="$SRC_NAME"
DIR=`mktemp -d ./tmpRepackXXXXXX`
trap "rm -rf \"$DIR\"" QUIT INT EXIT
# Create an extra directory to cope with rootless tarballs
UP_BASE="$DIR/unpack/$SRC_NAME"
mkdir -p "$UP_BASE"
tar xzf "$FILE" -C "$UP_BASE"

if [ `ls -1 "$UP_BASE" | wc -l` -eq 1 ]; then
        # Tarball does contain a root directory
        UP_BASE="$UP_BASE/`ls -1 "$UP_BASE"`"
fi
mv "$UP_BASE" "$DIR/$REPACK_DIR"
# Using a pipe hides tar errors!
tar cfC "$DIR/repacked.tar" "$DIR" "$REPACK_DIR"
xz --best  < "$DIR/repacked.tar" > "$DIR/repacked.tar.xz"
FILE="../${PKG}_${VER}.orig-${SRC_NAME}.tar.xz"
mv "$DIR/repacked.tar.xz" "$FILE"
echo "*** $FILE repackaged"
