# FIAIF is an Intelligent firewall
#
# description: Automates a packet filtering firewall with iptables.
#
# Script Author: Anders Fugmann <afu at fugmann dot net>
# 
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2011 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

###############################################################################
# Compose a new file containing IPSETS
# Arguments: <input_file> <output_file>
###############################################################################
function read_aliases ()
{
    local IN_FILE=$1
    local OUT_FILE=$2

    local NEW_LINE=1
    local LINE
    local LINE_NO=0
    local ALIAS
    local VALUE
    local I
    cat ${IN_FILE} | cut -d"#" -f1 | while read -a LINE; do
	let LINE_NO++
	if (( ${#LINE[*]} == 0 )); then
	    continue
	fi
	# Syntax: ALIAS = [IP,]*
	ALIAS=${LINE[0]}
	if [[ "${LINE[1]}" != "=" ]]; then
	    debug_err "Error in alias syntax on line ${LINE_NO}"
	fi
	VALUE=""
	for ((I=2;I<${#LINE[*]};I++)); do
	    VALUE="${VALUE} ${LINE[I]}"
	done
	# Print the correct string to a new file
	echo "declare -r IPSET_${ALIAS}=\"${VALUE}\"" >> ${OUT_FILE}
    done
    
}

###############################################################################
# Expand an ip alias.
# Args: <alias>
# Returns: RESULT is a space seperated list of IPs.
###############################################################################
function get_alias ()
{
    local ALIAS=$1
    local VAR=IPSET_${ALIAS}
    VAR="${!VAR}"
    local RES
    # Will not recurse when no alias is found.
    for IP in ${VAR}; do
	get_alias ${IP}
	if [[ -n ${RESULT} ]]; then
	    IP=${RESULT}
	fi
	if [[ -z ${RES} ]]; then
	    RES=${IP}
	else
	    RES="${RES} ${IP}"
	fi
    done
    RESULT="${RES}"
}

	    
	    
	
	
