/* $Id: chip_intel_x86_64_cpuid.c,v 1.15 2009-01-28 12:59:18 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define FAST

#include <assert.h>
#include <stdio.h>

#include "chip_intel_x86_64_def.h"

#include "exec.h"
#include "arch_gen_cpu_x86_sim_fast.h"

void
chip_intel_x86_64_helper_cpuid(void)
{
	uint32_t index_;

	index_ = (uint32_t) EAX;
    
	/* test if maximum index reached */
	if (index_ & 0x80000000) {
		if (index_ > 0x80000008) 
			index_ = 6;
	} else {
		if (index_ > 6) 
			index_ = 6;
	}

	switch (index_) {
	case 0x00000000:
		EAX = 0x00000006;
		EBX = 0x756e6547; /* GenuineIntel */
		ECX = 0x6c65746e;
		EDX = 0x49656e69;
		break;

	case 0x00000001:
		EAX = 0x00000f62; /* CPU Version */
		EBX = 0x00020800;
		ECX = CONFIG_CPU_SSE3_SUPPORT << 0
			| CONFIG_CPU_MONITOR_SUPPORT << 3
			| CONFIG_CPU_DSCPL_SUPPORT << 4
			| CONFIG_CPU_VMX_SUPPORT << 5
			/* Bit 6 is reserved. */
			| CONFIG_CPU_EST_SUPPORT << 7
			| CONFIG_CPU_TM2_SUPPORT << 8
			| CONFIG_CPU_SSSE3_SUPPORT << 9
			| CONFIG_CPU_CNXTID_SUPPORT << 10
			/* Bit 11 is reserved. */
			/* Bit 12 is reserved. */
			| CONFIG_CPU_CMPXCHG16B_SUPPORT << 13
			| CONFIG_CPU_XTPR_SUPPORT << 14
			| CONFIG_CPU_PDCM_SUPPORT << 15;
		ECX &= 0; /* FIXME */

		EDX = CONFIG_CPU_FPU_SUPPORT << 0
			| CONFIG_CPU_VME_SUPPORT << 1
			| CONFIG_CPU_DE_SUPPORT << 2
			| CONFIG_CPU_PSE_SUPPORT << 3
			| CONFIG_CPU_TSC_SUPPORT << 4
			| CONFIG_CPU_MSR_SUPPORT << 5
			| CONFIG_CPU_PAE_SUPPORT << 6
			| CONFIG_CPU_MCE_SUPPORT << 7
			| CONFIG_CPU_CX8_SUPPORT << 8
			| CONFIG_CPU_APIC_SUPPORT << 9
			| CONFIG_CPU_SEP_SUPPORT << 11 
			| CONFIG_CPU_MTRR_SUPPORT << 12
			| CONFIG_CPU_PGE_SUPPORT << 13
			| CONFIG_CPU_MCA_SUPPORT << 14
			| CONFIG_CPU_CMOV_SUPPORT << 15
			| CONFIG_CPU_PAT_SUPPORT << 16
			| CONFIG_CPU_PSE36_SUPPORT << 17
			| CONFIG_CPU_PSN_SUPPORT << 18
			| CONFIG_CPU_CFLSH_SUPPORT << 19
			| CONFIG_CPU_DS_SUPPORT << 21
			| CONFIG_CPU_ACPI_SUPPORT << 22
			| CONFIG_CPU_MMX_SUPPORT << 23
			| CONFIG_CPU_FXSR_SUPPORT << 24
			| CONFIG_CPU_SSE_SUPPORT << 25
			| CONFIG_CPU_SSE2_SUPPORT << 26
			| CONFIG_CPU_SS_SUPPORT << 27
			| CONFIG_CPU_HTT_SUPPORT << 28
			| CONFIG_CPU_TM_SUPPORT << 29
			| CONFIG_CPU_PBE_SUPPORT << 31;
		/* FIXME */
		EDX &= CPUID_FP87	/* 0: Floating Point Unit */
			| CPUID_VME	/* 1: VME */
			| CPUID_DE	/* 2: Debugging Extensions */
			| CPUID_PSE	/* 3: Page Size Extensions */
			| CPUID_TSC	/* 4: Time Stamp Counter */
			| CPUID_MSR	/* 5: Model Specific Registers */
			| CPUID_PAE	/* 6: Physical Address Extensions */
			| CPUID_MCE	/* 7: Machine Check Exception */
			| CPUID_CX8	/* 8: Compare and Exchange 8 Byte */
#if 0
			| CPUID_APIC	/* 9: Advanced PIC */
#endif
			/* reserved */
			| CPUID_SEP	/* 11: sysenter/sysleave Instructions */
			| CPUID_MTRR	/* 12: Mem. Type Range Reg. */
			| CPUID_PGE	/* 13: Page Global Bit Extension */
			| CPUID_MCA	/* 14: Machine Check Architecture */
			| CPUID_CMOV	/* 15: Conditional Move */
			| CPUID_PAT	/* 16: Page Attribute Table */
			/* CPUID_PSE36 */ /* 17: 36bit Page Size Extension */
			/* ... */
			| CPUID_CLFLUSH	/* 19: clflush Instruction */
			/* ... */
			| CPUID_MMX	/* 23: Multimedia Extension */
			| CPUID_FXSR	/* 24: fxsave/fxrstor Instructions */
			| CPUID_SSE	/* 25: SSE */
			| CPUID_SSE2;

		env->update_signature = 0;
		break;

	case 0x00000002:
		EAX = 0x605b5101;
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x007d7040;
		break;

	case 0x00000003:
		EAX = 0x00000000;
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x00000000;
		break;

	case 0x00000004:
		switch (ECX) {
		case 0:
			EAX =     0x0121;
			EBX = 0x01c0003f;
			ECX = 0x0000001f;
			break;
		case 1:
			EAX =     0x0143;
			EBX = 0x01c0103f;
			ECX = 0x000007ff;
			break;
		default:
			EAX =     0x0000;
			break;
		}
		EAX |= ((1-1) << 26)	/* # Processor Cores */
		     | ((1-1) << 14);	/* # Threads */
		EDX = 0x00000000;
		break;

	case 0x00000005:
		EAX = 0x00000040;
		EBX = 0x00000040;
		ECX = 0x00000000;
		EDX = 0x00000000;
		break;

	case 0x00000006:
		EAX = 0x00000000;
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x00000000;
		break;

	case 0x80000000:
		EAX = 0x80000008;
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x00000000;
		break;

	case 0x80000001:
		EAX = 0x00000000;
		EBX = 0x00000000;

		ECX = CONFIG_CPU_LAHF_SUPPORT << 0;
		/* FIXME */
		ECX &= 0;

		EDX = CONFIG_CPU_SYSCALL_SUPPORT << 11
			| CONFIG_CPU_NX_SUPPORT << 20
			| CONFIG_CPU_FFXSR_SUPPORT << 25
			| CONFIG_CPU_LM_SUPPORT << 29;
		/* FIXME */
		EDX &= CONFIG_CPU_SYSCALL_SUPPORT << 11
			| CONFIG_CPU_NX_SUPPORT << 20
			| CONFIG_CPU_LM_SUPPORT << 29;
		break;

	case 0x80000002:
		EAX = 0x20202020;
		EBX = 0x20202020;
		ECX = 0x20202020;
		EDX = 0x6e492020;
		break;

	case 0x80000003:
		EAX = 0x286c6574;
		EBX = 0x50202952;
		ECX = 0x69746e65;
		EDX = 0x52286d75;
		break;

	case 0x80000004:
		EAX = 0x20442029;
		EBX = 0x20555043;
		ECX = 0x30342e33;
		EDX = 0x007a4847;
		break;

	case 0x80000005:
		EAX = 0x00000000;
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x00000000;
		break;

	case 0x80000006:
		EAX = 0x00000000;
		EBX = 0x00000000;
		ECX = 0x08006040;
		EDX = 0x00000000;
		break;

	case 0x80000007:
		EAX = 0x00000000;
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x00000000;
		break;

	case 0x80000008:
		EAX = (CONFIG_CPU_VIRT_BITS << 8)
			| (CONFIG_CPU_PHYS_BITS << 0);
		EBX = 0x00000000;
		ECX = 0x00000000;
		EDX = 0x00000000;
		break;
	}
}
