// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file optionalTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "optionalTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "optional.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_short_optional_type_identifier(
        TypeIdentifierPair& type_ids_short_optional)
{

    ReturnCode_t return_code_short_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_short_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "short_optional", type_ids_short_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_optional)
    {
        StructTypeFlag struct_flags_short_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_short_optional = "short_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_short_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_short_optional;
        CompleteTypeDetail detail_short_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_short_optional, ann_custom_short_optional, type_name_short_optional.to_string());
        CompleteStructHeader header_short_optional;
        header_short_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_short_optional);
        CompleteStructMemberSeq member_seq_short_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_short_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_short_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_short_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_short_optional, member_value);
        }
        CompleteStructType struct_type_short_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_short_optional, header_short_optional, member_seq_short_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_short_optional, type_name_short_optional.to_string(), type_ids_short_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "short_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ushort_optional_type_identifier(
        TypeIdentifierPair& type_ids_ushort_optional)
{

    ReturnCode_t return_code_ushort_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ushort_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ushort_optional", type_ids_ushort_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ushort_optional)
    {
        StructTypeFlag struct_flags_ushort_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ushort_optional = "ushort_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ushort_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ushort_optional;
        CompleteTypeDetail detail_ushort_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ushort_optional, ann_custom_ushort_optional, type_name_ushort_optional.to_string());
        CompleteStructHeader header_ushort_optional;
        header_ushort_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ushort_optional);
        CompleteStructMemberSeq member_seq_ushort_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ushort_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ushort_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ushort_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ushort_optional, member_value);
        }
        CompleteStructType struct_type_ushort_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ushort_optional, header_ushort_optional, member_seq_ushort_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ushort_optional, type_name_ushort_optional.to_string(), type_ids_ushort_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ushort_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_long_optional_type_identifier(
        TypeIdentifierPair& type_ids_long_optional)
{

    ReturnCode_t return_code_long_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_long_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "long_optional", type_ids_long_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_optional)
    {
        StructTypeFlag struct_flags_long_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_long_optional = "long_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_long_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_long_optional;
        CompleteTypeDetail detail_long_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_long_optional, ann_custom_long_optional, type_name_long_optional.to_string());
        CompleteStructHeader header_long_optional;
        header_long_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_long_optional);
        CompleteStructMemberSeq member_seq_long_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_long_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_long_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_long_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_long_optional, member_value);
        }
        CompleteStructType struct_type_long_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_long_optional, header_long_optional, member_seq_long_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_long_optional, type_name_long_optional.to_string(), type_ids_long_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "long_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulong_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulong_optional)
{

    ReturnCode_t return_code_ulong_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulong_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulong_optional", type_ids_ulong_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulong_optional)
    {
        StructTypeFlag struct_flags_ulong_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulong_optional = "ulong_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulong_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulong_optional;
        CompleteTypeDetail detail_ulong_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulong_optional, ann_custom_ulong_optional, type_name_ulong_optional.to_string());
        CompleteStructHeader header_ulong_optional;
        header_ulong_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulong_optional);
        CompleteStructMemberSeq member_seq_ulong_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulong_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulong_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulong_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulong_optional, member_value);
        }
        CompleteStructType struct_type_ulong_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulong_optional, header_ulong_optional, member_seq_ulong_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulong_optional, type_name_ulong_optional.to_string(), type_ids_ulong_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulong_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longlong_optional_type_identifier(
        TypeIdentifierPair& type_ids_longlong_optional)
{

    ReturnCode_t return_code_longlong_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longlong_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longlong_optional", type_ids_longlong_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longlong_optional)
    {
        StructTypeFlag struct_flags_longlong_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longlong_optional = "longlong_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longlong_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longlong_optional;
        CompleteTypeDetail detail_longlong_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longlong_optional, ann_custom_longlong_optional, type_name_longlong_optional.to_string());
        CompleteStructHeader header_longlong_optional;
        header_longlong_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longlong_optional);
        CompleteStructMemberSeq member_seq_longlong_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longlong_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longlong_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longlong_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longlong_optional, member_value);
        }
        CompleteStructType struct_type_longlong_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longlong_optional, header_longlong_optional, member_seq_longlong_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longlong_optional, type_name_longlong_optional.to_string(), type_ids_longlong_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longlong_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulonglong_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulonglong_optional)
{

    ReturnCode_t return_code_ulonglong_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulonglong_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulonglong_optional", type_ids_ulonglong_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulonglong_optional)
    {
        StructTypeFlag struct_flags_ulonglong_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulonglong_optional = "ulonglong_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulonglong_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulonglong_optional;
        CompleteTypeDetail detail_ulonglong_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulonglong_optional, ann_custom_ulonglong_optional, type_name_ulonglong_optional.to_string());
        CompleteStructHeader header_ulonglong_optional;
        header_ulonglong_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulonglong_optional);
        CompleteStructMemberSeq member_seq_ulonglong_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulonglong_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulonglong_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulonglong_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulonglong_optional, member_value);
        }
        CompleteStructType struct_type_ulonglong_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulonglong_optional, header_ulonglong_optional, member_seq_ulonglong_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulonglong_optional, type_name_ulonglong_optional.to_string(), type_ids_ulonglong_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulonglong_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_float_optional_type_identifier(
        TypeIdentifierPair& type_ids_float_optional)
{

    ReturnCode_t return_code_float_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_float_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "float_optional", type_ids_float_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_float_optional)
    {
        StructTypeFlag struct_flags_float_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_float_optional = "float_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_float_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_float_optional;
        CompleteTypeDetail detail_float_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_float_optional, ann_custom_float_optional, type_name_float_optional.to_string());
        CompleteStructHeader header_float_optional;
        header_float_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_float_optional);
        CompleteStructMemberSeq member_seq_float_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_float_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_float_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_float_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_float_optional, member_value);
        }
        CompleteStructType struct_type_float_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_float_optional, header_float_optional, member_seq_float_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_float_optional, type_name_float_optional.to_string(), type_ids_float_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "float_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_double_optional_type_identifier(
        TypeIdentifierPair& type_ids_double_optional)
{

    ReturnCode_t return_code_double_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_double_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "double_optional", type_ids_double_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_double_optional)
    {
        StructTypeFlag struct_flags_double_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_double_optional = "double_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_double_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_double_optional;
        CompleteTypeDetail detail_double_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_double_optional, ann_custom_double_optional, type_name_double_optional.to_string());
        CompleteStructHeader header_double_optional;
        header_double_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_double_optional);
        CompleteStructMemberSeq member_seq_double_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_double_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_double_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_double_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_double_optional, member_value);
        }
        CompleteStructType struct_type_double_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_double_optional, header_double_optional, member_seq_double_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_double_optional, type_name_double_optional.to_string(), type_ids_double_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "double_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longdouble_optional_type_identifier(
        TypeIdentifierPair& type_ids_longdouble_optional)
{

    ReturnCode_t return_code_longdouble_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longdouble_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longdouble_optional", type_ids_longdouble_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longdouble_optional)
    {
        StructTypeFlag struct_flags_longdouble_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longdouble_optional = "longdouble_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longdouble_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longdouble_optional;
        CompleteTypeDetail detail_longdouble_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longdouble_optional, ann_custom_longdouble_optional, type_name_longdouble_optional.to_string());
        CompleteStructHeader header_longdouble_optional;
        header_longdouble_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longdouble_optional);
        CompleteStructMemberSeq member_seq_longdouble_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longdouble_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longdouble_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longdouble_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longdouble_optional, member_value);
        }
        CompleteStructType struct_type_longdouble_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longdouble_optional, header_longdouble_optional, member_seq_longdouble_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longdouble_optional, type_name_longdouble_optional.to_string(), type_ids_longdouble_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longdouble_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_boolean_optional_type_identifier(
        TypeIdentifierPair& type_ids_boolean_optional)
{

    ReturnCode_t return_code_boolean_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_boolean_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "boolean_optional", type_ids_boolean_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_boolean_optional)
    {
        StructTypeFlag struct_flags_boolean_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_boolean_optional = "boolean_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_boolean_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_boolean_optional;
        CompleteTypeDetail detail_boolean_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_boolean_optional, ann_custom_boolean_optional, type_name_boolean_optional.to_string());
        CompleteStructHeader header_boolean_optional;
        header_boolean_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_boolean_optional);
        CompleteStructMemberSeq member_seq_boolean_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_boolean_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_boolean_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_boolean_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_boolean_optional, member_value);
        }
        CompleteStructType struct_type_boolean_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_boolean_optional, header_boolean_optional, member_seq_boolean_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_boolean_optional, type_name_boolean_optional.to_string(), type_ids_boolean_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "boolean_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_octet_optional_type_identifier(
        TypeIdentifierPair& type_ids_octet_optional)
{

    ReturnCode_t return_code_octet_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_octet_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "octet_optional", type_ids_octet_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_octet_optional)
    {
        StructTypeFlag struct_flags_octet_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_octet_optional = "octet_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_octet_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_octet_optional;
        CompleteTypeDetail detail_octet_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_octet_optional, ann_custom_octet_optional, type_name_octet_optional.to_string());
        CompleteStructHeader header_octet_optional;
        header_octet_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_octet_optional);
        CompleteStructMemberSeq member_seq_octet_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_octet_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_octet_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_octet_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_octet_optional, member_value);
        }
        CompleteStructType struct_type_octet_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_octet_optional, header_octet_optional, member_seq_octet_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_octet_optional, type_name_octet_optional.to_string(), type_ids_octet_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "octet_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_char_optional_type_identifier(
        TypeIdentifierPair& type_ids_char_optional)
{

    ReturnCode_t return_code_char_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_char_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "char_optional", type_ids_char_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_char_optional)
    {
        StructTypeFlag struct_flags_char_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_char_optional = "char_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_char_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_char_optional;
        CompleteTypeDetail detail_char_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_char_optional, ann_custom_char_optional, type_name_char_optional.to_string());
        CompleteStructHeader header_char_optional;
        header_char_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_char_optional);
        CompleteStructMemberSeq member_seq_char_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_char_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_char_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_char_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_char_optional, member_value);
        }
        CompleteStructType struct_type_char_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_char_optional, header_char_optional, member_seq_char_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_char_optional, type_name_char_optional.to_string(), type_ids_char_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "char_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_wchar_optional_type_identifier(
        TypeIdentifierPair& type_ids_wchar_optional)
{

    ReturnCode_t return_code_wchar_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_wchar_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "wchar_optional", type_ids_wchar_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_wchar_optional)
    {
        StructTypeFlag struct_flags_wchar_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_wchar_optional = "wchar_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_wchar_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_wchar_optional;
        CompleteTypeDetail detail_wchar_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_wchar_optional, ann_custom_wchar_optional, type_name_wchar_optional.to_string());
        CompleteStructHeader header_wchar_optional;
        header_wchar_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_wchar_optional);
        CompleteStructMemberSeq member_seq_wchar_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_wchar_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_wchar_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_wchar_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_wchar_optional, member_value);
        }
        CompleteStructType struct_type_wchar_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_wchar_optional, header_wchar_optional, member_seq_wchar_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_wchar_optional, type_name_wchar_optional.to_string(), type_ids_wchar_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "wchar_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_short_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_short_align_1_optional)
{

    ReturnCode_t return_code_short_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_short_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "short_align_1_optional", type_ids_short_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_align_1_optional)
    {
        StructTypeFlag struct_flags_short_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_short_align_1_optional = "short_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_short_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_short_align_1_optional;
        CompleteTypeDetail detail_short_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_short_align_1_optional, ann_custom_short_align_1_optional, type_name_short_align_1_optional.to_string());
        CompleteStructHeader header_short_align_1_optional;
        header_short_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_short_align_1_optional);
        CompleteStructMemberSeq member_seq_short_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_short_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_short_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_short_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_short_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_short_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_short_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_short_align_1_optional, member_value);
        }
        CompleteStructType struct_type_short_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_short_align_1_optional, header_short_align_1_optional, member_seq_short_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_short_align_1_optional, type_name_short_align_1_optional.to_string(), type_ids_short_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "short_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_short_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_short_align_2_optional)
{

    ReturnCode_t return_code_short_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_short_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "short_align_2_optional", type_ids_short_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_align_2_optional)
    {
        StructTypeFlag struct_flags_short_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_short_align_2_optional = "short_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_short_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_short_align_2_optional;
        CompleteTypeDetail detail_short_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_short_align_2_optional, ann_custom_short_align_2_optional, type_name_short_align_2_optional.to_string());
        CompleteStructHeader header_short_align_2_optional;
        header_short_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_short_align_2_optional);
        CompleteStructMemberSeq member_seq_short_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_short_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_short_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_short_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_short_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_short_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_short_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_short_align_2_optional, member_value);
        }
        CompleteStructType struct_type_short_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_short_align_2_optional, header_short_align_2_optional, member_seq_short_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_short_align_2_optional, type_name_short_align_2_optional.to_string(), type_ids_short_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "short_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_short_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_short_align_4_optional)
{

    ReturnCode_t return_code_short_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_short_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "short_align_4_optional", type_ids_short_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_short_align_4_optional)
    {
        StructTypeFlag struct_flags_short_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_short_align_4_optional = "short_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_short_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_short_align_4_optional;
        CompleteTypeDetail detail_short_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_short_align_4_optional, ann_custom_short_align_4_optional, type_name_short_align_4_optional.to_string());
        CompleteStructHeader header_short_align_4_optional;
        header_short_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_short_align_4_optional);
        CompleteStructMemberSeq member_seq_short_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_short_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_short_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_short_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_short_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_short_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_short_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_short_align_4_optional, member_value);
        }
        CompleteStructType struct_type_short_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_short_align_4_optional, header_short_align_4_optional, member_seq_short_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_short_align_4_optional, type_name_short_align_4_optional.to_string(), type_ids_short_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "short_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ushort_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_ushort_align_1_optional)
{

    ReturnCode_t return_code_ushort_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ushort_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ushort_align_1_optional", type_ids_ushort_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ushort_align_1_optional)
    {
        StructTypeFlag struct_flags_ushort_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ushort_align_1_optional = "ushort_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ushort_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ushort_align_1_optional;
        CompleteTypeDetail detail_ushort_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ushort_align_1_optional, ann_custom_ushort_align_1_optional, type_name_ushort_align_1_optional.to_string());
        CompleteStructHeader header_ushort_align_1_optional;
        header_ushort_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ushort_align_1_optional);
        CompleteStructMemberSeq member_seq_ushort_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ushort_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ushort_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ushort_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ushort_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ushort_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ushort_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ushort_align_1_optional, member_value);
        }
        CompleteStructType struct_type_ushort_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ushort_align_1_optional, header_ushort_align_1_optional, member_seq_ushort_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ushort_align_1_optional, type_name_ushort_align_1_optional.to_string(), type_ids_ushort_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ushort_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ushort_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_ushort_align_2_optional)
{

    ReturnCode_t return_code_ushort_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ushort_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ushort_align_2_optional", type_ids_ushort_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ushort_align_2_optional)
    {
        StructTypeFlag struct_flags_ushort_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ushort_align_2_optional = "ushort_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ushort_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ushort_align_2_optional;
        CompleteTypeDetail detail_ushort_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ushort_align_2_optional, ann_custom_ushort_align_2_optional, type_name_ushort_align_2_optional.to_string());
        CompleteStructHeader header_ushort_align_2_optional;
        header_ushort_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ushort_align_2_optional);
        CompleteStructMemberSeq member_seq_ushort_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ushort_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ushort_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ushort_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ushort_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ushort_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ushort_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ushort_align_2_optional, member_value);
        }
        CompleteStructType struct_type_ushort_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ushort_align_2_optional, header_ushort_align_2_optional, member_seq_ushort_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ushort_align_2_optional, type_name_ushort_align_2_optional.to_string(), type_ids_ushort_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ushort_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ushort_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_ushort_align_4_optional)
{

    ReturnCode_t return_code_ushort_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ushort_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ushort_align_4_optional", type_ids_ushort_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ushort_align_4_optional)
    {
        StructTypeFlag struct_flags_ushort_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ushort_align_4_optional = "ushort_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ushort_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ushort_align_4_optional;
        CompleteTypeDetail detail_ushort_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ushort_align_4_optional, ann_custom_ushort_align_4_optional, type_name_ushort_align_4_optional.to_string());
        CompleteStructHeader header_ushort_align_4_optional;
        header_ushort_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ushort_align_4_optional);
        CompleteStructMemberSeq member_seq_ushort_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ushort_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ushort_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ushort_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ushort_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ushort_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ushort_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ushort_align_4_optional, member_value);
        }
        CompleteStructType struct_type_ushort_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ushort_align_4_optional, header_ushort_align_4_optional, member_seq_ushort_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ushort_align_4_optional, type_name_ushort_align_4_optional.to_string(), type_ids_ushort_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ushort_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_long_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_long_align_1_optional)
{

    ReturnCode_t return_code_long_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_long_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "long_align_1_optional", type_ids_long_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_align_1_optional)
    {
        StructTypeFlag struct_flags_long_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_long_align_1_optional = "long_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_long_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_long_align_1_optional;
        CompleteTypeDetail detail_long_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_long_align_1_optional, ann_custom_long_align_1_optional, type_name_long_align_1_optional.to_string());
        CompleteStructHeader header_long_align_1_optional;
        header_long_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_long_align_1_optional);
        CompleteStructMemberSeq member_seq_long_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_long_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_long_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_long_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_long_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_long_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_long_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_long_align_1_optional, member_value);
        }
        CompleteStructType struct_type_long_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_long_align_1_optional, header_long_align_1_optional, member_seq_long_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_long_align_1_optional, type_name_long_align_1_optional.to_string(), type_ids_long_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "long_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_long_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_long_align_2_optional)
{

    ReturnCode_t return_code_long_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_long_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "long_align_2_optional", type_ids_long_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_align_2_optional)
    {
        StructTypeFlag struct_flags_long_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_long_align_2_optional = "long_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_long_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_long_align_2_optional;
        CompleteTypeDetail detail_long_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_long_align_2_optional, ann_custom_long_align_2_optional, type_name_long_align_2_optional.to_string());
        CompleteStructHeader header_long_align_2_optional;
        header_long_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_long_align_2_optional);
        CompleteStructMemberSeq member_seq_long_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_long_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_long_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_long_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_long_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_long_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_long_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_long_align_2_optional, member_value);
        }
        CompleteStructType struct_type_long_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_long_align_2_optional, header_long_align_2_optional, member_seq_long_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_long_align_2_optional, type_name_long_align_2_optional.to_string(), type_ids_long_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "long_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_long_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_long_align_4_optional)
{

    ReturnCode_t return_code_long_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_long_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "long_align_4_optional", type_ids_long_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_align_4_optional)
    {
        StructTypeFlag struct_flags_long_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_long_align_4_optional = "long_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_long_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_long_align_4_optional;
        CompleteTypeDetail detail_long_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_long_align_4_optional, ann_custom_long_align_4_optional, type_name_long_align_4_optional.to_string());
        CompleteStructHeader header_long_align_4_optional;
        header_long_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_long_align_4_optional);
        CompleteStructMemberSeq member_seq_long_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_long_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_long_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_long_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_long_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_long_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_long_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_long_align_4_optional, member_value);
        }
        CompleteStructType struct_type_long_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_long_align_4_optional, header_long_align_4_optional, member_seq_long_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_long_align_4_optional, type_name_long_align_4_optional.to_string(), type_ids_long_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "long_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulong_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulong_align_1_optional)
{

    ReturnCode_t return_code_ulong_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulong_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulong_align_1_optional", type_ids_ulong_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulong_align_1_optional)
    {
        StructTypeFlag struct_flags_ulong_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulong_align_1_optional = "ulong_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulong_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulong_align_1_optional;
        CompleteTypeDetail detail_ulong_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulong_align_1_optional, ann_custom_ulong_align_1_optional, type_name_ulong_align_1_optional.to_string());
        CompleteStructHeader header_ulong_align_1_optional;
        header_ulong_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulong_align_1_optional);
        CompleteStructMemberSeq member_seq_ulong_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ulong_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ulong_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulong_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulong_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulong_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulong_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulong_align_1_optional, member_value);
        }
        CompleteStructType struct_type_ulong_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulong_align_1_optional, header_ulong_align_1_optional, member_seq_ulong_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulong_align_1_optional, type_name_ulong_align_1_optional.to_string(), type_ids_ulong_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulong_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulong_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulong_align_2_optional)
{

    ReturnCode_t return_code_ulong_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulong_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulong_align_2_optional", type_ids_ulong_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulong_align_2_optional)
    {
        StructTypeFlag struct_flags_ulong_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulong_align_2_optional = "ulong_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulong_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulong_align_2_optional;
        CompleteTypeDetail detail_ulong_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulong_align_2_optional, ann_custom_ulong_align_2_optional, type_name_ulong_align_2_optional.to_string());
        CompleteStructHeader header_ulong_align_2_optional;
        header_ulong_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulong_align_2_optional);
        CompleteStructMemberSeq member_seq_ulong_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ulong_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ulong_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulong_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulong_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulong_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulong_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulong_align_2_optional, member_value);
        }
        CompleteStructType struct_type_ulong_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulong_align_2_optional, header_ulong_align_2_optional, member_seq_ulong_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulong_align_2_optional, type_name_ulong_align_2_optional.to_string(), type_ids_ulong_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulong_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulong_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulong_align_4_optional)
{

    ReturnCode_t return_code_ulong_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulong_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulong_align_4_optional", type_ids_ulong_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulong_align_4_optional)
    {
        StructTypeFlag struct_flags_ulong_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulong_align_4_optional = "ulong_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulong_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulong_align_4_optional;
        CompleteTypeDetail detail_ulong_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulong_align_4_optional, ann_custom_ulong_align_4_optional, type_name_ulong_align_4_optional.to_string());
        CompleteStructHeader header_ulong_align_4_optional;
        header_ulong_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulong_align_4_optional);
        CompleteStructMemberSeq member_seq_ulong_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ulong_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ulong_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulong_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulong_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulong_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulong_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulong_align_4_optional, member_value);
        }
        CompleteStructType struct_type_ulong_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulong_align_4_optional, header_ulong_align_4_optional, member_seq_ulong_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulong_align_4_optional, type_name_ulong_align_4_optional.to_string(), type_ids_ulong_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulong_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longlong_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_longlong_align_1_optional)
{

    ReturnCode_t return_code_longlong_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longlong_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longlong_align_1_optional", type_ids_longlong_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longlong_align_1_optional)
    {
        StructTypeFlag struct_flags_longlong_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longlong_align_1_optional = "longlong_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longlong_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longlong_align_1_optional;
        CompleteTypeDetail detail_longlong_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longlong_align_1_optional, ann_custom_longlong_align_1_optional, type_name_longlong_align_1_optional.to_string());
        CompleteStructHeader header_longlong_align_1_optional;
        header_longlong_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longlong_align_1_optional);
        CompleteStructMemberSeq member_seq_longlong_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_longlong_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_longlong_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_longlong_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longlong_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longlong_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longlong_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longlong_align_1_optional, member_value);
        }
        CompleteStructType struct_type_longlong_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longlong_align_1_optional, header_longlong_align_1_optional, member_seq_longlong_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longlong_align_1_optional, type_name_longlong_align_1_optional.to_string(), type_ids_longlong_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longlong_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longlong_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_longlong_align_2_optional)
{

    ReturnCode_t return_code_longlong_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longlong_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longlong_align_2_optional", type_ids_longlong_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longlong_align_2_optional)
    {
        StructTypeFlag struct_flags_longlong_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longlong_align_2_optional = "longlong_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longlong_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longlong_align_2_optional;
        CompleteTypeDetail detail_longlong_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longlong_align_2_optional, ann_custom_longlong_align_2_optional, type_name_longlong_align_2_optional.to_string());
        CompleteStructHeader header_longlong_align_2_optional;
        header_longlong_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longlong_align_2_optional);
        CompleteStructMemberSeq member_seq_longlong_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_longlong_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_longlong_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_longlong_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longlong_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longlong_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longlong_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longlong_align_2_optional, member_value);
        }
        CompleteStructType struct_type_longlong_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longlong_align_2_optional, header_longlong_align_2_optional, member_seq_longlong_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longlong_align_2_optional, type_name_longlong_align_2_optional.to_string(), type_ids_longlong_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longlong_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longlong_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_longlong_align_4_optional)
{

    ReturnCode_t return_code_longlong_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longlong_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longlong_align_4_optional", type_ids_longlong_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longlong_align_4_optional)
    {
        StructTypeFlag struct_flags_longlong_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longlong_align_4_optional = "longlong_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longlong_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longlong_align_4_optional;
        CompleteTypeDetail detail_longlong_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longlong_align_4_optional, ann_custom_longlong_align_4_optional, type_name_longlong_align_4_optional.to_string());
        CompleteStructHeader header_longlong_align_4_optional;
        header_longlong_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longlong_align_4_optional);
        CompleteStructMemberSeq member_seq_longlong_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_longlong_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_longlong_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_longlong_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longlong_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longlong_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longlong_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longlong_align_4_optional, member_value);
        }
        CompleteStructType struct_type_longlong_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longlong_align_4_optional, header_longlong_align_4_optional, member_seq_longlong_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longlong_align_4_optional, type_name_longlong_align_4_optional.to_string(), type_ids_longlong_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longlong_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulonglong_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulonglong_align_1_optional)
{

    ReturnCode_t return_code_ulonglong_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulonglong_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulonglong_align_1_optional", type_ids_ulonglong_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulonglong_align_1_optional)
    {
        StructTypeFlag struct_flags_ulonglong_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulonglong_align_1_optional = "ulonglong_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulonglong_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulonglong_align_1_optional;
        CompleteTypeDetail detail_ulonglong_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulonglong_align_1_optional, ann_custom_ulonglong_align_1_optional, type_name_ulonglong_align_1_optional.to_string());
        CompleteStructHeader header_ulonglong_align_1_optional;
        header_ulonglong_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulonglong_align_1_optional);
        CompleteStructMemberSeq member_seq_ulonglong_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ulonglong_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ulonglong_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulonglong_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulonglong_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulonglong_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulonglong_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulonglong_align_1_optional, member_value);
        }
        CompleteStructType struct_type_ulonglong_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulonglong_align_1_optional, header_ulonglong_align_1_optional, member_seq_ulonglong_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulonglong_align_1_optional, type_name_ulonglong_align_1_optional.to_string(), type_ids_ulonglong_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulonglong_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulonglong_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulonglong_align_2_optional)
{

    ReturnCode_t return_code_ulonglong_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulonglong_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulonglong_align_2_optional", type_ids_ulonglong_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulonglong_align_2_optional)
    {
        StructTypeFlag struct_flags_ulonglong_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulonglong_align_2_optional = "ulonglong_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulonglong_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulonglong_align_2_optional;
        CompleteTypeDetail detail_ulonglong_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulonglong_align_2_optional, ann_custom_ulonglong_align_2_optional, type_name_ulonglong_align_2_optional.to_string());
        CompleteStructHeader header_ulonglong_align_2_optional;
        header_ulonglong_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulonglong_align_2_optional);
        CompleteStructMemberSeq member_seq_ulonglong_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ulonglong_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ulonglong_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulonglong_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulonglong_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulonglong_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulonglong_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulonglong_align_2_optional, member_value);
        }
        CompleteStructType struct_type_ulonglong_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulonglong_align_2_optional, header_ulonglong_align_2_optional, member_seq_ulonglong_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulonglong_align_2_optional, type_name_ulonglong_align_2_optional.to_string(), type_ids_ulonglong_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulonglong_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ulonglong_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_ulonglong_align_4_optional)
{

    ReturnCode_t return_code_ulonglong_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ulonglong_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ulonglong_align_4_optional", type_ids_ulonglong_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ulonglong_align_4_optional)
    {
        StructTypeFlag struct_flags_ulonglong_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ulonglong_align_4_optional = "ulonglong_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ulonglong_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ulonglong_align_4_optional;
        CompleteTypeDetail detail_ulonglong_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ulonglong_align_4_optional, ann_custom_ulonglong_align_4_optional, type_name_ulonglong_align_4_optional.to_string());
        CompleteStructHeader header_ulonglong_align_4_optional;
        header_ulonglong_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ulonglong_align_4_optional);
        CompleteStructMemberSeq member_seq_ulonglong_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_ulonglong_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_ulonglong_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulonglong_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_ulonglong_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_ulonglong_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_ulonglong_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_ulonglong_align_4_optional, member_value);
        }
        CompleteStructType struct_type_ulonglong_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_ulonglong_align_4_optional, header_ulonglong_align_4_optional, member_seq_ulonglong_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ulonglong_align_4_optional, type_name_ulonglong_align_4_optional.to_string(), type_ids_ulonglong_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ulonglong_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_float_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_float_align_1_optional)
{

    ReturnCode_t return_code_float_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_float_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "float_align_1_optional", type_ids_float_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_float_align_1_optional)
    {
        StructTypeFlag struct_flags_float_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_float_align_1_optional = "float_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_float_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_float_align_1_optional;
        CompleteTypeDetail detail_float_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_float_align_1_optional, ann_custom_float_align_1_optional, type_name_float_align_1_optional.to_string());
        CompleteStructHeader header_float_align_1_optional;
        header_float_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_float_align_1_optional);
        CompleteStructMemberSeq member_seq_float_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_float_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_float_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_float_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_float_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_float_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_float_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_float_align_1_optional, member_value);
        }
        CompleteStructType struct_type_float_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_float_align_1_optional, header_float_align_1_optional, member_seq_float_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_float_align_1_optional, type_name_float_align_1_optional.to_string(), type_ids_float_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "float_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_float_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_float_align_2_optional)
{

    ReturnCode_t return_code_float_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_float_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "float_align_2_optional", type_ids_float_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_float_align_2_optional)
    {
        StructTypeFlag struct_flags_float_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_float_align_2_optional = "float_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_float_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_float_align_2_optional;
        CompleteTypeDetail detail_float_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_float_align_2_optional, ann_custom_float_align_2_optional, type_name_float_align_2_optional.to_string());
        CompleteStructHeader header_float_align_2_optional;
        header_float_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_float_align_2_optional);
        CompleteStructMemberSeq member_seq_float_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_float_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_float_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_float_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_float_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_float_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_float_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_float_align_2_optional, member_value);
        }
        CompleteStructType struct_type_float_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_float_align_2_optional, header_float_align_2_optional, member_seq_float_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_float_align_2_optional, type_name_float_align_2_optional.to_string(), type_ids_float_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "float_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_float_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_float_align_4_optional)
{

    ReturnCode_t return_code_float_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_float_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "float_align_4_optional", type_ids_float_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_float_align_4_optional)
    {
        StructTypeFlag struct_flags_float_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_float_align_4_optional = "float_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_float_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_float_align_4_optional;
        CompleteTypeDetail detail_float_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_float_align_4_optional, ann_custom_float_align_4_optional, type_name_float_align_4_optional.to_string());
        CompleteStructHeader header_float_align_4_optional;
        header_float_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_float_align_4_optional);
        CompleteStructMemberSeq member_seq_float_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_float_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_float_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_float_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_float_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_float_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_float_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_float_align_4_optional, member_value);
        }
        CompleteStructType struct_type_float_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_float_align_4_optional, header_float_align_4_optional, member_seq_float_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_float_align_4_optional, type_name_float_align_4_optional.to_string(), type_ids_float_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "float_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_double_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_double_align_1_optional)
{

    ReturnCode_t return_code_double_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_double_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "double_align_1_optional", type_ids_double_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_double_align_1_optional)
    {
        StructTypeFlag struct_flags_double_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_double_align_1_optional = "double_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_double_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_double_align_1_optional;
        CompleteTypeDetail detail_double_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_double_align_1_optional, ann_custom_double_align_1_optional, type_name_double_align_1_optional.to_string());
        CompleteStructHeader header_double_align_1_optional;
        header_double_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_double_align_1_optional);
        CompleteStructMemberSeq member_seq_double_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_double_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_double_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_double_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_double_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_double_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_double_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_double_align_1_optional, member_value);
        }
        CompleteStructType struct_type_double_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_double_align_1_optional, header_double_align_1_optional, member_seq_double_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_double_align_1_optional, type_name_double_align_1_optional.to_string(), type_ids_double_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "double_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_double_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_double_align_2_optional)
{

    ReturnCode_t return_code_double_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_double_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "double_align_2_optional", type_ids_double_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_double_align_2_optional)
    {
        StructTypeFlag struct_flags_double_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_double_align_2_optional = "double_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_double_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_double_align_2_optional;
        CompleteTypeDetail detail_double_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_double_align_2_optional, ann_custom_double_align_2_optional, type_name_double_align_2_optional.to_string());
        CompleteStructHeader header_double_align_2_optional;
        header_double_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_double_align_2_optional);
        CompleteStructMemberSeq member_seq_double_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_double_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_double_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_double_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_double_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_double_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_double_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_double_align_2_optional, member_value);
        }
        CompleteStructType struct_type_double_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_double_align_2_optional, header_double_align_2_optional, member_seq_double_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_double_align_2_optional, type_name_double_align_2_optional.to_string(), type_ids_double_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "double_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_double_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_double_align_4_optional)
{

    ReturnCode_t return_code_double_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_double_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "double_align_4_optional", type_ids_double_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_double_align_4_optional)
    {
        StructTypeFlag struct_flags_double_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_double_align_4_optional = "double_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_double_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_double_align_4_optional;
        CompleteTypeDetail detail_double_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_double_align_4_optional, ann_custom_double_align_4_optional, type_name_double_align_4_optional.to_string());
        CompleteStructHeader header_double_align_4_optional;
        header_double_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_double_align_4_optional);
        CompleteStructMemberSeq member_seq_double_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_double_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_double_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_double_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_double_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_double_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_double_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_double_align_4_optional, member_value);
        }
        CompleteStructType struct_type_double_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_double_align_4_optional, header_double_align_4_optional, member_seq_double_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_double_align_4_optional, type_name_double_align_4_optional.to_string(), type_ids_double_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "double_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longdouble_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_longdouble_align_1_optional)
{

    ReturnCode_t return_code_longdouble_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longdouble_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longdouble_align_1_optional", type_ids_longdouble_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longdouble_align_1_optional)
    {
        StructTypeFlag struct_flags_longdouble_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longdouble_align_1_optional = "longdouble_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longdouble_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longdouble_align_1_optional;
        CompleteTypeDetail detail_longdouble_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longdouble_align_1_optional, ann_custom_longdouble_align_1_optional, type_name_longdouble_align_1_optional.to_string());
        CompleteStructHeader header_longdouble_align_1_optional;
        header_longdouble_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longdouble_align_1_optional);
        CompleteStructMemberSeq member_seq_longdouble_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_longdouble_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_longdouble_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_longdouble_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longdouble_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longdouble_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longdouble_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longdouble_align_1_optional, member_value);
        }
        CompleteStructType struct_type_longdouble_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longdouble_align_1_optional, header_longdouble_align_1_optional, member_seq_longdouble_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longdouble_align_1_optional, type_name_longdouble_align_1_optional.to_string(), type_ids_longdouble_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longdouble_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longdouble_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_longdouble_align_2_optional)
{

    ReturnCode_t return_code_longdouble_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longdouble_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longdouble_align_2_optional", type_ids_longdouble_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longdouble_align_2_optional)
    {
        StructTypeFlag struct_flags_longdouble_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longdouble_align_2_optional = "longdouble_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longdouble_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longdouble_align_2_optional;
        CompleteTypeDetail detail_longdouble_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longdouble_align_2_optional, ann_custom_longdouble_align_2_optional, type_name_longdouble_align_2_optional.to_string());
        CompleteStructHeader header_longdouble_align_2_optional;
        header_longdouble_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longdouble_align_2_optional);
        CompleteStructMemberSeq member_seq_longdouble_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_longdouble_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_longdouble_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_longdouble_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longdouble_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longdouble_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longdouble_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longdouble_align_2_optional, member_value);
        }
        CompleteStructType struct_type_longdouble_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longdouble_align_2_optional, header_longdouble_align_2_optional, member_seq_longdouble_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longdouble_align_2_optional, type_name_longdouble_align_2_optional.to_string(), type_ids_longdouble_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longdouble_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_longdouble_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_longdouble_align_4_optional)
{

    ReturnCode_t return_code_longdouble_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_longdouble_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "longdouble_align_4_optional", type_ids_longdouble_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_longdouble_align_4_optional)
    {
        StructTypeFlag struct_flags_longdouble_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_longdouble_align_4_optional = "longdouble_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_longdouble_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_longdouble_align_4_optional;
        CompleteTypeDetail detail_longdouble_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_longdouble_align_4_optional, ann_custom_longdouble_align_4_optional, type_name_longdouble_align_4_optional.to_string());
        CompleteStructHeader header_longdouble_align_4_optional;
        header_longdouble_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_longdouble_align_4_optional);
        CompleteStructMemberSeq member_seq_longdouble_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_longdouble_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_longdouble_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_longdouble_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_longdouble_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_longdouble_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_longdouble_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_longdouble_align_4_optional, member_value);
        }
        CompleteStructType struct_type_longdouble_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_longdouble_align_4_optional, header_longdouble_align_4_optional, member_seq_longdouble_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_longdouble_align_4_optional, type_name_longdouble_align_4_optional.to_string(), type_ids_longdouble_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "longdouble_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_boolean_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_boolean_align_1_optional)
{

    ReturnCode_t return_code_boolean_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_boolean_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "boolean_align_1_optional", type_ids_boolean_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_boolean_align_1_optional)
    {
        StructTypeFlag struct_flags_boolean_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_boolean_align_1_optional = "boolean_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_boolean_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_boolean_align_1_optional;
        CompleteTypeDetail detail_boolean_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_boolean_align_1_optional, ann_custom_boolean_align_1_optional, type_name_boolean_align_1_optional.to_string());
        CompleteStructHeader header_boolean_align_1_optional;
        header_boolean_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_boolean_align_1_optional);
        CompleteStructMemberSeq member_seq_boolean_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_boolean_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_boolean_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_boolean_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_boolean_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_boolean_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_boolean_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_boolean_align_1_optional, member_value);
        }
        CompleteStructType struct_type_boolean_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_boolean_align_1_optional, header_boolean_align_1_optional, member_seq_boolean_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_boolean_align_1_optional, type_name_boolean_align_1_optional.to_string(), type_ids_boolean_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "boolean_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_boolean_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_boolean_align_2_optional)
{

    ReturnCode_t return_code_boolean_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_boolean_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "boolean_align_2_optional", type_ids_boolean_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_boolean_align_2_optional)
    {
        StructTypeFlag struct_flags_boolean_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_boolean_align_2_optional = "boolean_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_boolean_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_boolean_align_2_optional;
        CompleteTypeDetail detail_boolean_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_boolean_align_2_optional, ann_custom_boolean_align_2_optional, type_name_boolean_align_2_optional.to_string());
        CompleteStructHeader header_boolean_align_2_optional;
        header_boolean_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_boolean_align_2_optional);
        CompleteStructMemberSeq member_seq_boolean_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_boolean_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_boolean_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_boolean_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_boolean_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_boolean_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_boolean_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_boolean_align_2_optional, member_value);
        }
        CompleteStructType struct_type_boolean_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_boolean_align_2_optional, header_boolean_align_2_optional, member_seq_boolean_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_boolean_align_2_optional, type_name_boolean_align_2_optional.to_string(), type_ids_boolean_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "boolean_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_boolean_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_boolean_align_4_optional)
{

    ReturnCode_t return_code_boolean_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_boolean_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "boolean_align_4_optional", type_ids_boolean_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_boolean_align_4_optional)
    {
        StructTypeFlag struct_flags_boolean_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_boolean_align_4_optional = "boolean_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_boolean_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_boolean_align_4_optional;
        CompleteTypeDetail detail_boolean_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_boolean_align_4_optional, ann_custom_boolean_align_4_optional, type_name_boolean_align_4_optional.to_string());
        CompleteStructHeader header_boolean_align_4_optional;
        header_boolean_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_boolean_align_4_optional);
        CompleteStructMemberSeq member_seq_boolean_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_boolean_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_boolean_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_boolean_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_boolean_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_boolean_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_boolean_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_boolean_align_4_optional, member_value);
        }
        CompleteStructType struct_type_boolean_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_boolean_align_4_optional, header_boolean_align_4_optional, member_seq_boolean_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_boolean_align_4_optional, type_name_boolean_align_4_optional.to_string(), type_ids_boolean_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "boolean_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_octet_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_octet_align_1_optional)
{

    ReturnCode_t return_code_octet_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_octet_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "octet_align_1_optional", type_ids_octet_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_octet_align_1_optional)
    {
        StructTypeFlag struct_flags_octet_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_octet_align_1_optional = "octet_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_octet_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_octet_align_1_optional;
        CompleteTypeDetail detail_octet_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_octet_align_1_optional, ann_custom_octet_align_1_optional, type_name_octet_align_1_optional.to_string());
        CompleteStructHeader header_octet_align_1_optional;
        header_octet_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_octet_align_1_optional);
        CompleteStructMemberSeq member_seq_octet_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_octet_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_octet_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_octet_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_octet_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_octet_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_octet_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_octet_align_1_optional, member_value);
        }
        CompleteStructType struct_type_octet_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_octet_align_1_optional, header_octet_align_1_optional, member_seq_octet_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_octet_align_1_optional, type_name_octet_align_1_optional.to_string(), type_ids_octet_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "octet_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_octet_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_octet_align_2_optional)
{

    ReturnCode_t return_code_octet_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_octet_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "octet_align_2_optional", type_ids_octet_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_octet_align_2_optional)
    {
        StructTypeFlag struct_flags_octet_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_octet_align_2_optional = "octet_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_octet_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_octet_align_2_optional;
        CompleteTypeDetail detail_octet_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_octet_align_2_optional, ann_custom_octet_align_2_optional, type_name_octet_align_2_optional.to_string());
        CompleteStructHeader header_octet_align_2_optional;
        header_octet_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_octet_align_2_optional);
        CompleteStructMemberSeq member_seq_octet_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_octet_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_octet_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_octet_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_octet_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_octet_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_octet_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_octet_align_2_optional, member_value);
        }
        CompleteStructType struct_type_octet_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_octet_align_2_optional, header_octet_align_2_optional, member_seq_octet_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_octet_align_2_optional, type_name_octet_align_2_optional.to_string(), type_ids_octet_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "octet_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_octet_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_octet_align_4_optional)
{

    ReturnCode_t return_code_octet_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_octet_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "octet_align_4_optional", type_ids_octet_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_octet_align_4_optional)
    {
        StructTypeFlag struct_flags_octet_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_octet_align_4_optional = "octet_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_octet_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_octet_align_4_optional;
        CompleteTypeDetail detail_octet_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_octet_align_4_optional, ann_custom_octet_align_4_optional, type_name_octet_align_4_optional.to_string());
        CompleteStructHeader header_octet_align_4_optional;
        header_octet_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_octet_align_4_optional);
        CompleteStructMemberSeq member_seq_octet_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_octet_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_octet_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_octet_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_octet_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_octet_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_octet_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_octet_align_4_optional, member_value);
        }
        CompleteStructType struct_type_octet_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_octet_align_4_optional, header_octet_align_4_optional, member_seq_octet_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_octet_align_4_optional, type_name_octet_align_4_optional.to_string(), type_ids_octet_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "octet_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_char_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_char_align_1_optional)
{

    ReturnCode_t return_code_char_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_char_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "char_align_1_optional", type_ids_char_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_char_align_1_optional)
    {
        StructTypeFlag struct_flags_char_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_char_align_1_optional = "char_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_char_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_char_align_1_optional;
        CompleteTypeDetail detail_char_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_char_align_1_optional, ann_custom_char_align_1_optional, type_name_char_align_1_optional.to_string());
        CompleteStructHeader header_char_align_1_optional;
        header_char_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_char_align_1_optional);
        CompleteStructMemberSeq member_seq_char_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_char_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_char_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_char_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_char_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_char_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_char_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_char_align_1_optional, member_value);
        }
        CompleteStructType struct_type_char_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_char_align_1_optional, header_char_align_1_optional, member_seq_char_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_char_align_1_optional, type_name_char_align_1_optional.to_string(), type_ids_char_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "char_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_char_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_char_align_2_optional)
{

    ReturnCode_t return_code_char_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_char_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "char_align_2_optional", type_ids_char_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_char_align_2_optional)
    {
        StructTypeFlag struct_flags_char_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_char_align_2_optional = "char_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_char_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_char_align_2_optional;
        CompleteTypeDetail detail_char_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_char_align_2_optional, ann_custom_char_align_2_optional, type_name_char_align_2_optional.to_string());
        CompleteStructHeader header_char_align_2_optional;
        header_char_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_char_align_2_optional);
        CompleteStructMemberSeq member_seq_char_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_char_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_char_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_char_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_char_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_char_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_char_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_char_align_2_optional, member_value);
        }
        CompleteStructType struct_type_char_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_char_align_2_optional, header_char_align_2_optional, member_seq_char_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_char_align_2_optional, type_name_char_align_2_optional.to_string(), type_ids_char_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "char_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_char_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_char_align_4_optional)
{

    ReturnCode_t return_code_char_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_char_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "char_align_4_optional", type_ids_char_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_char_align_4_optional)
    {
        StructTypeFlag struct_flags_char_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_char_align_4_optional = "char_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_char_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_char_align_4_optional;
        CompleteTypeDetail detail_char_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_char_align_4_optional, ann_custom_char_align_4_optional, type_name_char_align_4_optional.to_string());
        CompleteStructHeader header_char_align_4_optional;
        header_char_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_char_align_4_optional);
        CompleteStructMemberSeq member_seq_char_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_char_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_char_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_char_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_char_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_char_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_char_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_char_align_4_optional, member_value);
        }
        CompleteStructType struct_type_char_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_char_align_4_optional, header_char_align_4_optional, member_seq_char_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_char_align_4_optional, type_name_char_align_4_optional.to_string(), type_ids_char_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "char_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_wchar_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_wchar_align_1_optional)
{

    ReturnCode_t return_code_wchar_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_wchar_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "wchar_align_1_optional", type_ids_wchar_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_wchar_align_1_optional)
    {
        StructTypeFlag struct_flags_wchar_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_wchar_align_1_optional = "wchar_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_wchar_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_wchar_align_1_optional;
        CompleteTypeDetail detail_wchar_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_wchar_align_1_optional, ann_custom_wchar_align_1_optional, type_name_wchar_align_1_optional.to_string());
        CompleteStructHeader header_wchar_align_1_optional;
        header_wchar_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_wchar_align_1_optional);
        CompleteStructMemberSeq member_seq_wchar_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_wchar_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_wchar_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_wchar_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_wchar_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_wchar_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_wchar_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_wchar_align_1_optional, member_value);
        }
        CompleteStructType struct_type_wchar_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_wchar_align_1_optional, header_wchar_align_1_optional, member_seq_wchar_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_wchar_align_1_optional, type_name_wchar_align_1_optional.to_string(), type_ids_wchar_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "wchar_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_wchar_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_wchar_align_2_optional)
{

    ReturnCode_t return_code_wchar_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_wchar_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "wchar_align_2_optional", type_ids_wchar_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_wchar_align_2_optional)
    {
        StructTypeFlag struct_flags_wchar_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_wchar_align_2_optional = "wchar_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_wchar_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_wchar_align_2_optional;
        CompleteTypeDetail detail_wchar_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_wchar_align_2_optional, ann_custom_wchar_align_2_optional, type_name_wchar_align_2_optional.to_string());
        CompleteStructHeader header_wchar_align_2_optional;
        header_wchar_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_wchar_align_2_optional);
        CompleteStructMemberSeq member_seq_wchar_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_wchar_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_wchar_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_wchar_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_wchar_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_wchar_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_wchar_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_wchar_align_2_optional, member_value);
        }
        CompleteStructType struct_type_wchar_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_wchar_align_2_optional, header_wchar_align_2_optional, member_seq_wchar_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_wchar_align_2_optional, type_name_wchar_align_2_optional.to_string(), type_ids_wchar_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "wchar_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_wchar_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_wchar_align_4_optional)
{

    ReturnCode_t return_code_wchar_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_wchar_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "wchar_align_4_optional", type_ids_wchar_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_wchar_align_4_optional)
    {
        StructTypeFlag struct_flags_wchar_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_wchar_align_4_optional = "wchar_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_wchar_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_wchar_align_4_optional;
        CompleteTypeDetail detail_wchar_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_wchar_align_4_optional, ann_custom_wchar_align_4_optional, type_name_wchar_align_4_optional.to_string());
        CompleteStructHeader header_wchar_align_4_optional;
        header_wchar_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_wchar_align_4_optional);
        CompleteStructMemberSeq member_seq_wchar_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_wchar_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_wchar_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_wchar_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "value Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_wchar_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_wchar_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_wchar_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_wchar_align_4_optional, member_value);
        }
        CompleteStructType struct_type_wchar_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_wchar_align_4_optional, header_wchar_align_4_optional, member_seq_wchar_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_wchar_align_4_optional, type_name_wchar_align_4_optional.to_string(), type_ids_wchar_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "wchar_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_sequence_short_optional_type_identifier(
        TypeIdentifierPair& type_ids_sequence_short_optional)
{

    ReturnCode_t return_code_sequence_short_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_sequence_short_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "sequence_short_optional", type_ids_sequence_short_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_sequence_short_optional)
    {
        StructTypeFlag struct_flags_sequence_short_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_sequence_short_optional = "sequence_short_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_sequence_short_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_sequence_short_optional;
        CompleteTypeDetail detail_sequence_short_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_sequence_short_optional, ann_custom_sequence_short_optional, type_name_sequence_short_optional.to_string());
        CompleteStructHeader header_sequence_short_optional;
        header_sequence_short_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_sequence_short_optional);
        CompleteStructMemberSeq member_seq_sequence_short_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_sequence_short_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_sequence_short_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_sequence_short_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_sequence_short_optional, member_value);
        }
        CompleteStructType struct_type_sequence_short_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_sequence_short_optional, header_sequence_short_optional, member_seq_sequence_short_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_sequence_short_optional, type_name_sequence_short_optional.to_string(), type_ids_sequence_short_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "sequence_short_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_sequence_short_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_sequence_short_align_1_optional)
{

    ReturnCode_t return_code_sequence_short_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_sequence_short_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "sequence_short_align_1_optional", type_ids_sequence_short_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_sequence_short_align_1_optional)
    {
        StructTypeFlag struct_flags_sequence_short_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_sequence_short_align_1_optional = "sequence_short_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_sequence_short_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_sequence_short_align_1_optional;
        CompleteTypeDetail detail_sequence_short_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_sequence_short_align_1_optional, ann_custom_sequence_short_align_1_optional, type_name_sequence_short_align_1_optional.to_string());
        CompleteStructHeader header_sequence_short_align_1_optional;
        header_sequence_short_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_sequence_short_align_1_optional);
        CompleteStructMemberSeq member_seq_sequence_short_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_sequence_short_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_sequence_short_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_sequence_short_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_sequence_short_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_sequence_short_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_sequence_short_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_sequence_short_align_1_optional, member_value);
        }
        CompleteStructType struct_type_sequence_short_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_sequence_short_align_1_optional, header_sequence_short_align_1_optional, member_seq_sequence_short_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_sequence_short_align_1_optional, type_name_sequence_short_align_1_optional.to_string(), type_ids_sequence_short_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "sequence_short_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_sequence_short_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_sequence_short_align_2_optional)
{

    ReturnCode_t return_code_sequence_short_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_sequence_short_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "sequence_short_align_2_optional", type_ids_sequence_short_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_sequence_short_align_2_optional)
    {
        StructTypeFlag struct_flags_sequence_short_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_sequence_short_align_2_optional = "sequence_short_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_sequence_short_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_sequence_short_align_2_optional;
        CompleteTypeDetail detail_sequence_short_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_sequence_short_align_2_optional, ann_custom_sequence_short_align_2_optional, type_name_sequence_short_align_2_optional.to_string());
        CompleteStructHeader header_sequence_short_align_2_optional;
        header_sequence_short_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_sequence_short_align_2_optional);
        CompleteStructMemberSeq member_seq_sequence_short_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_sequence_short_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_sequence_short_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_sequence_short_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_sequence_short_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_sequence_short_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_sequence_short_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_sequence_short_align_2_optional, member_value);
        }
        CompleteStructType struct_type_sequence_short_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_sequence_short_align_2_optional, header_sequence_short_align_2_optional, member_seq_sequence_short_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_sequence_short_align_2_optional, type_name_sequence_short_align_2_optional.to_string(), type_ids_sequence_short_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "sequence_short_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_sequence_short_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_sequence_short_align_4_optional)
{

    ReturnCode_t return_code_sequence_short_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_sequence_short_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "sequence_short_align_4_optional", type_ids_sequence_short_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_sequence_short_align_4_optional)
    {
        StructTypeFlag struct_flags_sequence_short_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_sequence_short_align_4_optional = "sequence_short_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_sequence_short_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_sequence_short_align_4_optional;
        CompleteTypeDetail detail_sequence_short_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_sequence_short_align_4_optional, ann_custom_sequence_short_align_4_optional, type_name_sequence_short_align_4_optional.to_string());
        CompleteStructHeader header_sequence_short_align_4_optional;
        header_sequence_short_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_sequence_short_align_4_optional);
        CompleteStructMemberSeq member_seq_sequence_short_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_sequence_short_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_sequence_short_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_sequence_short_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_sequence_short_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_sequence_short_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_sequence_short_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_sequence_short_align_4_optional, member_value);
        }
        CompleteStructType struct_type_sequence_short_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_sequence_short_align_4_optional, header_sequence_short_align_4_optional, member_seq_sequence_short_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_sequence_short_align_4_optional, type_name_sequence_short_align_4_optional.to_string(), type_ids_sequence_short_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "sequence_short_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_unbounded_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_unbounded_optional)
{

    ReturnCode_t return_code_string_unbounded_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_unbounded_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_unbounded_optional", type_ids_string_unbounded_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_unbounded_optional)
    {
        StructTypeFlag struct_flags_string_unbounded_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_unbounded_optional = "string_unbounded_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_unbounded_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_unbounded_optional;
        CompleteTypeDetail detail_string_unbounded_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_unbounded_optional, ann_custom_string_unbounded_optional, type_name_string_unbounded_optional.to_string());
        CompleteStructHeader header_string_unbounded_optional;
        header_string_unbounded_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_unbounded_optional);
        CompleteStructMemberSeq member_seq_string_unbounded_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_unbounded_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_unbounded_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_unbounded_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_unbounded_optional, member_value);
        }
        CompleteStructType struct_type_string_unbounded_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_unbounded_optional, header_string_unbounded_optional, member_seq_string_unbounded_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_unbounded_optional, type_name_string_unbounded_optional.to_string(), type_ids_string_unbounded_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_unbounded_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_unbounded_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_unbounded_align_1_optional)
{

    ReturnCode_t return_code_string_unbounded_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_unbounded_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_unbounded_align_1_optional", type_ids_string_unbounded_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_unbounded_align_1_optional)
    {
        StructTypeFlag struct_flags_string_unbounded_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_unbounded_align_1_optional = "string_unbounded_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_unbounded_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_unbounded_align_1_optional;
        CompleteTypeDetail detail_string_unbounded_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_unbounded_align_1_optional, ann_custom_string_unbounded_align_1_optional, type_name_string_unbounded_align_1_optional.to_string());
        CompleteStructHeader header_string_unbounded_align_1_optional;
        header_string_unbounded_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_unbounded_align_1_optional);
        CompleteStructMemberSeq member_seq_string_unbounded_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_string_unbounded_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_string_unbounded_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_unbounded_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_unbounded_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_unbounded_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_unbounded_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_unbounded_align_1_optional, member_value);
        }
        CompleteStructType struct_type_string_unbounded_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_unbounded_align_1_optional, header_string_unbounded_align_1_optional, member_seq_string_unbounded_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_unbounded_align_1_optional, type_name_string_unbounded_align_1_optional.to_string(), type_ids_string_unbounded_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_unbounded_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_unbounded_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_unbounded_align_2_optional)
{

    ReturnCode_t return_code_string_unbounded_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_unbounded_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_unbounded_align_2_optional", type_ids_string_unbounded_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_unbounded_align_2_optional)
    {
        StructTypeFlag struct_flags_string_unbounded_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_unbounded_align_2_optional = "string_unbounded_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_unbounded_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_unbounded_align_2_optional;
        CompleteTypeDetail detail_string_unbounded_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_unbounded_align_2_optional, ann_custom_string_unbounded_align_2_optional, type_name_string_unbounded_align_2_optional.to_string());
        CompleteStructHeader header_string_unbounded_align_2_optional;
        header_string_unbounded_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_unbounded_align_2_optional);
        CompleteStructMemberSeq member_seq_string_unbounded_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_string_unbounded_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_string_unbounded_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_unbounded_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_unbounded_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_unbounded_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_unbounded_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_unbounded_align_2_optional, member_value);
        }
        CompleteStructType struct_type_string_unbounded_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_unbounded_align_2_optional, header_string_unbounded_align_2_optional, member_seq_string_unbounded_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_unbounded_align_2_optional, type_name_string_unbounded_align_2_optional.to_string(), type_ids_string_unbounded_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_unbounded_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_unbounded_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_unbounded_align_4_optional)
{

    ReturnCode_t return_code_string_unbounded_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_unbounded_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_unbounded_align_4_optional", type_ids_string_unbounded_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_unbounded_align_4_optional)
    {
        StructTypeFlag struct_flags_string_unbounded_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_unbounded_align_4_optional = "string_unbounded_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_unbounded_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_unbounded_align_4_optional;
        CompleteTypeDetail detail_string_unbounded_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_unbounded_align_4_optional, ann_custom_string_unbounded_align_4_optional, type_name_string_unbounded_align_4_optional.to_string());
        CompleteStructHeader header_string_unbounded_align_4_optional;
        header_string_unbounded_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_unbounded_align_4_optional);
        CompleteStructMemberSeq member_seq_string_unbounded_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_string_unbounded_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_string_unbounded_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_unbounded_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_unbounded_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_unbounded_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_unbounded_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_unbounded_align_4_optional, member_value);
        }
        CompleteStructType struct_type_string_unbounded_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_unbounded_align_4_optional, header_string_unbounded_align_4_optional, member_seq_string_unbounded_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_unbounded_align_4_optional, type_name_string_unbounded_align_4_optional.to_string(), type_ids_string_unbounded_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_unbounded_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_bounded_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_bounded_optional)
{

    ReturnCode_t return_code_string_bounded_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_bounded_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_bounded_optional", type_ids_string_bounded_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_bounded_optional)
    {
        StructTypeFlag struct_flags_string_bounded_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_bounded_optional = "string_bounded_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_bounded_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_bounded_optional;
        CompleteTypeDetail detail_string_bounded_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_bounded_optional, ann_custom_string_bounded_optional, type_name_string_bounded_optional.to_string());
        CompleteStructHeader header_string_bounded_optional;
        header_string_bounded_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_bounded_optional);
        CompleteStructMemberSeq member_seq_string_bounded_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_8", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = static_cast<SBound>(8);
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_8", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_8 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_bounded_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_bounded_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_bounded_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_bounded_optional, member_value);
        }
        CompleteStructType struct_type_string_bounded_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_bounded_optional, header_string_bounded_optional, member_seq_string_bounded_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_bounded_optional, type_name_string_bounded_optional.to_string(), type_ids_string_bounded_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_bounded_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_bounded_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_bounded_align_1_optional)
{

    ReturnCode_t return_code_string_bounded_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_bounded_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_bounded_align_1_optional", type_ids_string_bounded_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_bounded_align_1_optional)
    {
        StructTypeFlag struct_flags_string_bounded_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_bounded_align_1_optional = "string_bounded_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_bounded_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_bounded_align_1_optional;
        CompleteTypeDetail detail_string_bounded_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_bounded_align_1_optional, ann_custom_string_bounded_align_1_optional, type_name_string_bounded_align_1_optional.to_string());
        CompleteStructHeader header_string_bounded_align_1_optional;
        header_string_bounded_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_bounded_align_1_optional);
        CompleteStructMemberSeq member_seq_string_bounded_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_string_bounded_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_string_bounded_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_bounded_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_8", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = static_cast<SBound>(8);
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_8", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_8 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_bounded_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_bounded_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_bounded_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_bounded_align_1_optional, member_value);
        }
        CompleteStructType struct_type_string_bounded_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_bounded_align_1_optional, header_string_bounded_align_1_optional, member_seq_string_bounded_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_bounded_align_1_optional, type_name_string_bounded_align_1_optional.to_string(), type_ids_string_bounded_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_bounded_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_bounded_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_bounded_align_2_optional)
{

    ReturnCode_t return_code_string_bounded_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_bounded_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_bounded_align_2_optional", type_ids_string_bounded_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_bounded_align_2_optional)
    {
        StructTypeFlag struct_flags_string_bounded_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_bounded_align_2_optional = "string_bounded_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_bounded_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_bounded_align_2_optional;
        CompleteTypeDetail detail_string_bounded_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_bounded_align_2_optional, ann_custom_string_bounded_align_2_optional, type_name_string_bounded_align_2_optional.to_string());
        CompleteStructHeader header_string_bounded_align_2_optional;
        header_string_bounded_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_bounded_align_2_optional);
        CompleteStructMemberSeq member_seq_string_bounded_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_string_bounded_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_string_bounded_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_bounded_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_8", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = static_cast<SBound>(8);
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_8", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_8 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_bounded_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_bounded_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_bounded_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_bounded_align_2_optional, member_value);
        }
        CompleteStructType struct_type_string_bounded_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_bounded_align_2_optional, header_string_bounded_align_2_optional, member_seq_string_bounded_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_bounded_align_2_optional, type_name_string_bounded_align_2_optional.to_string(), type_ids_string_bounded_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_bounded_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_string_bounded_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_string_bounded_align_4_optional)
{

    ReturnCode_t return_code_string_bounded_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_string_bounded_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "string_bounded_align_4_optional", type_ids_string_bounded_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_bounded_align_4_optional)
    {
        StructTypeFlag struct_flags_string_bounded_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_string_bounded_align_4_optional = "string_bounded_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_string_bounded_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_string_bounded_align_4_optional;
        CompleteTypeDetail detail_string_bounded_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_string_bounded_align_4_optional, ann_custom_string_bounded_align_4_optional, type_name_string_bounded_align_4_optional.to_string());
        CompleteStructHeader header_string_bounded_align_4_optional;
        header_string_bounded_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_string_bounded_align_4_optional);
        CompleteStructMemberSeq member_seq_string_bounded_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_string_bounded_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_string_bounded_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_bounded_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_8", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                {
                    SBound bound = static_cast<SBound>(8);
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_8", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_8 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_string_bounded_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_string_bounded_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_string_bounded_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_string_bounded_align_4_optional, member_value);
        }
        CompleteStructType struct_type_string_bounded_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_string_bounded_align_4_optional, header_string_bounded_align_4_optional, member_seq_string_bounded_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_string_bounded_align_4_optional, type_name_string_bounded_align_4_optional.to_string(), type_ids_string_bounded_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "string_bounded_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_map_short_optional_type_identifier(
        TypeIdentifierPair& type_ids_map_short_optional)
{

    ReturnCode_t return_code_map_short_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_map_short_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "map_short_optional", type_ids_map_short_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_map_short_optional)
    {
        StructTypeFlag struct_flags_map_short_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_map_short_optional = "map_short_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_map_short_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_map_short_optional;
        CompleteTypeDetail detail_map_short_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_map_short_optional, ann_custom_map_short_optional, type_name_map_short_optional.to_string());
        CompleteStructHeader header_map_short_optional;
        header_map_short_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_map_short_optional);
        CompleteStructMemberSeq member_seq_map_short_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int16_t_unbounded, element_flags_anonymous_map_int32_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int16_t_unbounded), key_flags_anonymous_map_int32_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_map_short_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_map_short_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_map_short_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_map_short_optional, member_value);
        }
        CompleteStructType struct_type_map_short_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_map_short_optional, header_map_short_optional, member_seq_map_short_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_map_short_optional, type_name_map_short_optional.to_string(), type_ids_map_short_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "map_short_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_map_short_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_map_short_align_1_optional)
{

    ReturnCode_t return_code_map_short_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_map_short_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "map_short_align_1_optional", type_ids_map_short_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_map_short_align_1_optional)
    {
        StructTypeFlag struct_flags_map_short_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_map_short_align_1_optional = "map_short_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_map_short_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_map_short_align_1_optional;
        CompleteTypeDetail detail_map_short_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_map_short_align_1_optional, ann_custom_map_short_align_1_optional, type_name_map_short_align_1_optional.to_string());
        CompleteStructHeader header_map_short_align_1_optional;
        header_map_short_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_map_short_align_1_optional);
        CompleteStructMemberSeq member_seq_map_short_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_map_short_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_map_short_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_map_short_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int16_t_unbounded, element_flags_anonymous_map_int32_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int16_t_unbounded), key_flags_anonymous_map_int32_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_map_short_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_map_short_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_map_short_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_map_short_align_1_optional, member_value);
        }
        CompleteStructType struct_type_map_short_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_map_short_align_1_optional, header_map_short_align_1_optional, member_seq_map_short_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_map_short_align_1_optional, type_name_map_short_align_1_optional.to_string(), type_ids_map_short_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "map_short_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_map_short_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_map_short_align_2_optional)
{

    ReturnCode_t return_code_map_short_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_map_short_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "map_short_align_2_optional", type_ids_map_short_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_map_short_align_2_optional)
    {
        StructTypeFlag struct_flags_map_short_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_map_short_align_2_optional = "map_short_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_map_short_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_map_short_align_2_optional;
        CompleteTypeDetail detail_map_short_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_map_short_align_2_optional, ann_custom_map_short_align_2_optional, type_name_map_short_align_2_optional.to_string());
        CompleteStructHeader header_map_short_align_2_optional;
        header_map_short_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_map_short_align_2_optional);
        CompleteStructMemberSeq member_seq_map_short_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_map_short_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_map_short_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_map_short_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int16_t_unbounded, element_flags_anonymous_map_int32_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int16_t_unbounded), key_flags_anonymous_map_int32_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_map_short_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_map_short_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_map_short_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_map_short_align_2_optional, member_value);
        }
        CompleteStructType struct_type_map_short_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_map_short_align_2_optional, header_map_short_align_2_optional, member_seq_map_short_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_map_short_align_2_optional, type_name_map_short_align_2_optional.to_string(), type_ids_map_short_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "map_short_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_map_short_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_map_short_align_4_optional)
{

    ReturnCode_t return_code_map_short_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_map_short_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "map_short_align_4_optional", type_ids_map_short_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_map_short_align_4_optional)
    {
        StructTypeFlag struct_flags_map_short_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_map_short_align_4_optional = "map_short_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_map_short_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_map_short_align_4_optional;
        CompleteTypeDetail detail_map_short_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_map_short_align_4_optional, ann_custom_map_short_align_4_optional, type_name_map_short_align_4_optional.to_string());
        CompleteStructHeader header_map_short_align_4_optional;
        header_map_short_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_map_short_align_4_optional);
        CompleteStructMemberSeq member_seq_map_short_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_map_short_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_map_short_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_map_short_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int16_t_unbounded", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int16_t_unbounded, element_flags_anonymous_map_int32_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int16_t_unbounded), key_flags_anonymous_map_int32_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int16_t_unbounded", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_map_short_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_map_short_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_map_short_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_map_short_align_4_optional, member_value);
        }
        CompleteStructType struct_type_map_short_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_map_short_align_4_optional, header_map_short_align_4_optional, member_seq_map_short_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_map_short_align_4_optional, type_name_map_short_align_4_optional.to_string(), type_ids_map_short_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "map_short_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_array_short_optional_type_identifier(
        TypeIdentifierPair& type_ids_array_short_optional)
{

    ReturnCode_t return_code_array_short_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_array_short_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "array_short_optional", type_ids_array_short_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_short_optional)
    {
        StructTypeFlag struct_flags_array_short_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_array_short_optional = "array_short_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_array_short_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_array_short_optional;
        CompleteTypeDetail detail_array_short_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_array_short_optional, ann_custom_array_short_optional, type_name_array_short_optional.to_string());
        CompleteStructHeader header_array_short_optional;
        header_array_short_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_array_short_optional);
        CompleteStructMemberSeq member_seq_array_short_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_array_short_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_array_short_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_array_short_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_array_short_optional, member_value);
        }
        CompleteStructType struct_type_array_short_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_array_short_optional, header_array_short_optional, member_seq_array_short_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_array_short_optional, type_name_array_short_optional.to_string(), type_ids_array_short_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "array_short_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_array_short_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_array_short_align_1_optional)
{

    ReturnCode_t return_code_array_short_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_array_short_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "array_short_align_1_optional", type_ids_array_short_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_short_align_1_optional)
    {
        StructTypeFlag struct_flags_array_short_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_array_short_align_1_optional = "array_short_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_array_short_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_array_short_align_1_optional;
        CompleteTypeDetail detail_array_short_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_array_short_align_1_optional, ann_custom_array_short_align_1_optional, type_name_array_short_align_1_optional.to_string());
        CompleteStructHeader header_array_short_align_1_optional;
        header_array_short_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_array_short_align_1_optional);
        CompleteStructMemberSeq member_seq_array_short_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_array_short_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_array_short_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_array_short_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_array_short_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_array_short_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_array_short_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_array_short_align_1_optional, member_value);
        }
        CompleteStructType struct_type_array_short_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_array_short_align_1_optional, header_array_short_align_1_optional, member_seq_array_short_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_array_short_align_1_optional, type_name_array_short_align_1_optional.to_string(), type_ids_array_short_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "array_short_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_array_short_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_array_short_align_2_optional)
{

    ReturnCode_t return_code_array_short_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_array_short_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "array_short_align_2_optional", type_ids_array_short_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_short_align_2_optional)
    {
        StructTypeFlag struct_flags_array_short_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_array_short_align_2_optional = "array_short_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_array_short_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_array_short_align_2_optional;
        CompleteTypeDetail detail_array_short_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_array_short_align_2_optional, ann_custom_array_short_align_2_optional, type_name_array_short_align_2_optional.to_string());
        CompleteStructHeader header_array_short_align_2_optional;
        header_array_short_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_array_short_align_2_optional);
        CompleteStructMemberSeq member_seq_array_short_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_array_short_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_array_short_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_array_short_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_array_short_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_array_short_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_array_short_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_array_short_align_2_optional, member_value);
        }
        CompleteStructType struct_type_array_short_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_array_short_align_2_optional, header_array_short_align_2_optional, member_seq_array_short_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_array_short_align_2_optional, type_name_array_short_align_2_optional.to_string(), type_ids_array_short_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "array_short_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_array_short_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_array_short_align_4_optional)
{

    ReturnCode_t return_code_array_short_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_array_short_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "array_short_align_4_optional", type_ids_array_short_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_short_align_4_optional)
    {
        StructTypeFlag struct_flags_array_short_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_array_short_align_4_optional = "array_short_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_array_short_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_array_short_align_4_optional;
        CompleteTypeDetail detail_array_short_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_array_short_align_4_optional, ann_custom_array_short_align_4_optional, type_name_array_short_align_4_optional.to_string());
        CompleteStructHeader header_array_short_align_4_optional;
        header_array_short_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_array_short_align_4_optional);
        CompleteStructMemberSeq member_seq_array_short_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_array_short_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_array_short_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_array_short_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_array_short_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_array_short_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_array_short_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_array_short_align_4_optional, member_value);
        }
        CompleteStructType struct_type_array_short_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_array_short_align_4_optional, header_array_short_align_4_optional, member_seq_array_short_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_array_short_align_4_optional, type_name_array_short_align_4_optional.to_string(), type_ids_array_short_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "array_short_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_struct_optional_type_identifier(
        TypeIdentifierPair& type_ids_struct_optional)
{

    ReturnCode_t return_code_struct_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_struct_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "struct_optional", type_ids_struct_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_struct_optional)
    {
        StructTypeFlag struct_flags_struct_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_struct_optional = "struct_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_struct_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_struct_optional;
        CompleteTypeDetail detail_struct_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_struct_optional, ann_custom_struct_optional, type_name_struct_optional.to_string());
        CompleteStructHeader header_struct_optional;
        header_struct_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_struct_optional);
        CompleteStructMemberSeq member_seq_struct_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_struct_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_struct_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_struct_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_struct_optional, member_value);
        }
        CompleteStructType struct_type_struct_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_struct_optional, header_struct_optional, member_seq_struct_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_struct_optional, type_name_struct_optional.to_string(), type_ids_struct_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "struct_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_struct_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_struct_align_1_optional)
{

    ReturnCode_t return_code_struct_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_struct_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "struct_align_1_optional", type_ids_struct_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_struct_align_1_optional)
    {
        StructTypeFlag struct_flags_struct_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_struct_align_1_optional = "struct_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_struct_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_struct_align_1_optional;
        CompleteTypeDetail detail_struct_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_struct_align_1_optional, ann_custom_struct_align_1_optional, type_name_struct_align_1_optional.to_string());
        CompleteStructHeader header_struct_align_1_optional;
        header_struct_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_struct_align_1_optional);
        CompleteStructMemberSeq member_seq_struct_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_struct_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_struct_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_struct_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_struct_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_struct_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_struct_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_struct_align_1_optional, member_value);
        }
        CompleteStructType struct_type_struct_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_struct_align_1_optional, header_struct_align_1_optional, member_seq_struct_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_struct_align_1_optional, type_name_struct_align_1_optional.to_string(), type_ids_struct_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "struct_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_struct_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_struct_align_2_optional)
{

    ReturnCode_t return_code_struct_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_struct_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "struct_align_2_optional", type_ids_struct_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_struct_align_2_optional)
    {
        StructTypeFlag struct_flags_struct_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_struct_align_2_optional = "struct_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_struct_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_struct_align_2_optional;
        CompleteTypeDetail detail_struct_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_struct_align_2_optional, ann_custom_struct_align_2_optional, type_name_struct_align_2_optional.to_string());
        CompleteStructHeader header_struct_align_2_optional;
        header_struct_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_struct_align_2_optional);
        CompleteStructMemberSeq member_seq_struct_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_struct_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_struct_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_struct_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_struct_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_struct_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_struct_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_struct_align_2_optional, member_value);
        }
        CompleteStructType struct_type_struct_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_struct_align_2_optional, header_struct_align_2_optional, member_seq_struct_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_struct_align_2_optional, type_name_struct_align_2_optional.to_string(), type_ids_struct_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "struct_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_struct_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_struct_align_4_optional)
{

    ReturnCode_t return_code_struct_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_struct_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "struct_align_4_optional", type_ids_struct_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_struct_align_4_optional)
    {
        StructTypeFlag struct_flags_struct_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_struct_align_4_optional = "struct_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_struct_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_struct_align_4_optional;
        CompleteTypeDetail detail_struct_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_struct_align_4_optional, ann_custom_struct_align_4_optional, type_name_struct_align_4_optional.to_string());
        CompleteStructHeader header_struct_align_4_optional;
        header_struct_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_struct_align_4_optional);
        CompleteStructMemberSeq member_seq_struct_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_struct_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_struct_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_struct_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelper", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructureHelper_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_struct_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_struct_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_struct_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_struct_align_4_optional, member_value);
        }
        CompleteStructType struct_type_struct_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_struct_align_4_optional, header_struct_align_4_optional, member_seq_struct_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_struct_align_4_optional, type_name_struct_align_4_optional.to_string(), type_ids_struct_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "struct_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InnerStructOptional_type_identifier(
        TypeIdentifierPair& type_ids_InnerStructOptional)
{

    ReturnCode_t return_code_InnerStructOptional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerStructOptional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerStructOptional", type_ids_InnerStructOptional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerStructOptional)
    {
        StructTypeFlag struct_flags_InnerStructOptional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_InnerStructOptional = "InnerStructOptional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerStructOptional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerStructOptional;
        CompleteTypeDetail detail_InnerStructOptional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerStructOptional, ann_custom_InnerStructOptional, type_name_InnerStructOptional.to_string());
        CompleteStructHeader header_InnerStructOptional;
        header_InnerStructOptional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_InnerStructOptional);
        CompleteStructMemberSeq member_seq_InnerStructOptional;
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x00000000;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_InnerStructOptional.reset();
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_InnerStructOptional);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerStructOptional, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_l = 0x00000001;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_InnerStructOptional.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_InnerStructOptional = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_InnerStructOptional);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerStructOptional, member_l);
        }
        CompleteStructType struct_type_InnerStructOptional = TypeObjectUtils::build_complete_struct_type(struct_flags_InnerStructOptional, header_InnerStructOptional, member_seq_InnerStructOptional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InnerStructOptional, type_name_InnerStructOptional.to_string(), type_ids_InnerStructOptional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructOptional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_opt_struct_optional_type_identifier(
        TypeIdentifierPair& type_ids_opt_struct_optional)
{

    ReturnCode_t return_code_opt_struct_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_opt_struct_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "opt_struct_optional", type_ids_opt_struct_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_opt_struct_optional)
    {
        StructTypeFlag struct_flags_opt_struct_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_opt_struct_optional = "opt_struct_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_opt_struct_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_opt_struct_optional;
        CompleteTypeDetail detail_opt_struct_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_opt_struct_optional, ann_custom_opt_struct_optional, type_name_opt_struct_optional.to_string());
        CompleteStructHeader header_opt_struct_optional;
        header_opt_struct_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_opt_struct_optional);
        CompleteStructMemberSeq member_seq_opt_struct_optional;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructOptional", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructOptional_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_opt_struct_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_opt_struct_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_opt_struct_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_opt_struct_optional, member_value);
        }
        CompleteStructType struct_type_opt_struct_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_opt_struct_optional, header_opt_struct_optional, member_seq_opt_struct_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_opt_struct_optional, type_name_opt_struct_optional.to_string(), type_ids_opt_struct_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "opt_struct_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_opt_struct_align_1_optional_type_identifier(
        TypeIdentifierPair& type_ids_opt_struct_align_1_optional)
{

    ReturnCode_t return_code_opt_struct_align_1_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_opt_struct_align_1_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "opt_struct_align_1_optional", type_ids_opt_struct_align_1_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_opt_struct_align_1_optional)
    {
        StructTypeFlag struct_flags_opt_struct_align_1_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_opt_struct_align_1_optional = "opt_struct_align_1_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_opt_struct_align_1_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_opt_struct_align_1_optional;
        CompleteTypeDetail detail_opt_struct_align_1_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_opt_struct_align_1_optional, ann_custom_opt_struct_align_1_optional, type_name_opt_struct_align_1_optional.to_string());
        CompleteStructHeader header_opt_struct_align_1_optional;
        header_opt_struct_align_1_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_opt_struct_align_1_optional);
        CompleteStructMemberSeq member_seq_opt_struct_align_1_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_opt_struct_align_1_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_opt_struct_align_1_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_opt_struct_align_1_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructOptional", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructOptional_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_opt_struct_align_1_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_opt_struct_align_1_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_opt_struct_align_1_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_opt_struct_align_1_optional, member_value);
        }
        CompleteStructType struct_type_opt_struct_align_1_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_opt_struct_align_1_optional, header_opt_struct_align_1_optional, member_seq_opt_struct_align_1_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_opt_struct_align_1_optional, type_name_opt_struct_align_1_optional.to_string(), type_ids_opt_struct_align_1_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "opt_struct_align_1_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_opt_struct_align_2_optional_type_identifier(
        TypeIdentifierPair& type_ids_opt_struct_align_2_optional)
{

    ReturnCode_t return_code_opt_struct_align_2_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_opt_struct_align_2_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "opt_struct_align_2_optional", type_ids_opt_struct_align_2_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_opt_struct_align_2_optional)
    {
        StructTypeFlag struct_flags_opt_struct_align_2_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_opt_struct_align_2_optional = "opt_struct_align_2_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_opt_struct_align_2_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_opt_struct_align_2_optional;
        CompleteTypeDetail detail_opt_struct_align_2_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_opt_struct_align_2_optional, ann_custom_opt_struct_align_2_optional, type_name_opt_struct_align_2_optional.to_string());
        CompleteStructHeader header_opt_struct_align_2_optional;
        header_opt_struct_align_2_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_opt_struct_align_2_optional);
        CompleteStructMemberSeq member_seq_opt_struct_align_2_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_opt_struct_align_2_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_opt_struct_align_2_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_opt_struct_align_2_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructOptional", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructOptional_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_opt_struct_align_2_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_opt_struct_align_2_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_opt_struct_align_2_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_opt_struct_align_2_optional, member_value);
        }
        CompleteStructType struct_type_opt_struct_align_2_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_opt_struct_align_2_optional, header_opt_struct_align_2_optional, member_seq_opt_struct_align_2_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_opt_struct_align_2_optional, type_name_opt_struct_align_2_optional.to_string(), type_ids_opt_struct_align_2_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "opt_struct_align_2_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_opt_struct_align_4_optional_type_identifier(
        TypeIdentifierPair& type_ids_opt_struct_align_4_optional)
{

    ReturnCode_t return_code_opt_struct_align_4_optional {eprosima::fastdds::dds::RETCODE_OK};
    return_code_opt_struct_align_4_optional =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "opt_struct_align_4_optional", type_ids_opt_struct_align_4_optional);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_opt_struct_align_4_optional)
    {
        StructTypeFlag struct_flags_opt_struct_align_4_optional = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_opt_struct_align_4_optional = "opt_struct_align_4_optional";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_opt_struct_align_4_optional;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_opt_struct_align_4_optional;
        CompleteTypeDetail detail_opt_struct_align_4_optional = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_opt_struct_align_4_optional, ann_custom_opt_struct_align_4_optional, type_name_opt_struct_align_4_optional.to_string());
        CompleteStructHeader header_opt_struct_align_4_optional;
        header_opt_struct_align_4_optional = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_opt_struct_align_4_optional);
        CompleteStructMemberSeq member_seq_opt_struct_align_4_optional;
        {
            TypeIdentifierPair type_ids_align;
            ReturnCode_t return_code_align {eprosima::fastdds::dds::RETCODE_OK};
            return_code_align =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_align);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_align)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "align Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_align = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_align = 0x00000000;
            bool common_align_ec {false};
            CommonStructMember common_align {TypeObjectUtils::build_common_struct_member(member_id_align, member_flags_align, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_align, common_align_ec))};
            if (!common_align_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure align member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_align = "align";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_align;
            ann_custom_opt_struct_align_4_optional.reset();
            CompleteMemberDetail detail_align = TypeObjectUtils::build_complete_member_detail(name_align, member_ann_builtin_align, ann_custom_opt_struct_align_4_optional);
            CompleteStructMember member_align = TypeObjectUtils::build_complete_struct_member(common_align, detail_align);
            TypeObjectUtils::add_complete_struct_member(member_seq_opt_struct_align_4_optional, member_align);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructOptional", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerStructOptional_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false, false, false);
            MemberId member_id_value = 0x00000001;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_opt_struct_align_4_optional.reset();
            AppliedAnnotationSeq tmp_ann_custom_value;
            eprosima::fastcdr::optional<std::string> unit_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_value;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_value;
            eprosima::fastcdr::optional<std::string> hash_id_value;
            if (unit_value.has_value() || min_value.has_value() || max_value.has_value() || hash_id_value.has_value())
            {
                member_ann_builtin_value = TypeObjectUtils::build_applied_builtin_member_annotations(unit_value, min_value, max_value, hash_id_value);
            }
            if (!tmp_ann_custom_value.empty())
            {
                ann_custom_opt_struct_align_4_optional = tmp_ann_custom_value;
            }
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_opt_struct_align_4_optional);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_opt_struct_align_4_optional, member_value);
        }
        CompleteStructType struct_type_opt_struct_align_4_optional = TypeObjectUtils::build_complete_struct_type(struct_flags_opt_struct_align_4_optional, header_opt_struct_align_4_optional, member_seq_opt_struct_align_4_optional);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_opt_struct_align_4_optional, type_name_opt_struct_align_4_optional.to_string(), type_ids_opt_struct_align_4_optional))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "opt_struct_align_4_optional already registered in TypeObjectRegistry for a different type.");
        }
    }
}

