#  Album|deepin-album|

## Overview

Album is a stylish and smooth photo management tool, supporting photo viewing and managing in various formats. You can sort your photos by date or timeline, add them to the Favorites or category them into different albums to manage photos in an order way.

![1|main](fig/album_main.png)

## Guide

You can run, close, and create shortcuts for Album in the following ways.

### Run Album

1. Click ![launcher](../common/deepin_launcher.svg) in the Dock and enter the Launcher interface.
2. Locate ![deepin_album](../common/deepin_album.svg) by scrolling the mouse wheel or searching "album" in the Launcher interface and click it to run.
3. Right-click ![deepin_album](../common/deepin_album.svg) and you can:
 - Click **Send to desktop** to create a desktop shortcut.
 - Click **Send to dock** to fix the application in the dock.
 - Click **Add to startup** to add the application to startup and it will automatically run when the system starts up.

> ![tips](../common/tips.svg) Tips: In Control Center, you can set Album as the default photo viewing application. Please refer to [Default Applications](dman:///dde#Default Application Settings) for specific operations.

### Exit Album

- On the Album interface, click![close_icon](../common/close_icon.svg)to exit Album.
- Right-click ![deepin_album](../common/deepin_album.svg) in the dock and select **Close All** to exit Album.
- On the Album interface, click ![icon_menu](../common/icon_menu.svg) and select **Exit** to exit Album.

### View Shortcuts

On the Album interface, press **Ctrl** + **Shift** + **?** to view shortcuts. Proficiency in shortcuts will greatly improve your efficiency.

![0|hotkey](fig/hotkey.png)

## Photo Management

You are able to manage photos by **Timelines** and **Albums** after launching Album.

### Import Photos

On the Album interface, you are able to import photos as follows:
- Click **Import Photos** when there is no photo in the album.
- Click![icon_menu](../common/icon_menu.svg)> **Import photos**.
- Drag directly the photo or the folder where the photo is located to the Album interface.
- Import photos from the mobile device.

> ![tips](../common/tips.svg) Tips: You can also import photos to the empty Album by clicking **Import Photos** on the Album interface.

> ![notes](../common/notes.svg) Notes: The photo formats supported include BMP, GIF, JPG, PNG, PBM, PGM, PPM, XBM, XPM, SVG, DDS, ICNS,  MNG, TGA, TIFF, WBMP, WEBP, PSD, ICO, JNG, PCD, PCX, TIF, RAS, MRW, DNG, RAF, CR2, RAW, ORF, NEF, etc.

### Search Photos 

1. In the search box on top of the Album interface, click ![search](../common/search.svg) to enter keywords.
2. Press the **Enter** key on the keyboard to locate the photos quickly.

### View Photos

Click the scroll bar on the Album interface to adjust the thumbnail size of photos.

Double-click the photo, or right-click the photo and select **View** to enter the photo viewing interface. Press **Esc** on the keyboard to exit.

| Icon                                                    | Name                    | Description                                                  |
| ------------------------------------------------------- | ----------------------- | ------------------------------------------------------------ |
| ![ back_normal](../common/back_normal.svg)              | Back                    | Back to the main interface.                                  |
| ![previous](../common/previous.svg)                     | Previous                | Switch to the previous photo.                                |
| ![next](../common/next.svg)                             | Next                    | Switch to the next image.                                    |
| ![adapt_image](../common/adapt_image.svg)               | 1:1 Size                | The photo will be displayed in 1:1 size without changing the size of the window. |
| ![fit_hover](../common/adapt_screen.svg)                | Fit to window           | The photo will be resized to adapt to the current window.    |
| ![collect](../common/collect.svg)                       | Favorite                | Add favorite photos to your Favorites.                       |
| ![clockwise_rotation](../common/clockwise_rotation.svg) | Rotate clockwise        | Rotate the photo 90 degrees clockwise.                       |
| ![contrarotate](../common/contrarotate.svg)             | Rotate counterclockwise | Rotate the photo 90 degrees counterclockwise.                |
| ![delete](../common/delete.svg)                         | Delete                  | Delete the current photo.                                    |

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
> ![tips](../common/tips.svg) Tips: Scroll the mouse wheel to enlarge the picture. If the photo size exceeds the window, a navigation window will appear at the lower part. Drag the box in the window to fast locate the corresponding photo areas. You can click ![close_icon](../common/close_icon.svg) on the top right corner of the navigation window to close it. Right-click the photo, you can select **Hide navigation window/Show navigation window**.

![0|copy](fig/view-pic.png)

### View Timelines

In Timelines, all photos are sorted by date. Photos with the same date are displayed together and photos with different dates are displayed in different columns. You are able to locate photos of a specific date quickly by Timelines.

### Print Photos

1. On the Album interface, select the photo to be printed and right-click to select **Print**.
2. Select the printer and set the printing parameters.
3. Click **Print**.

### Slide Show

1. On the Album interface, right-click a photo.
2. Select **Slide show** to play the photo as slides in full screen.
3. Press **Esc** on the keyboard to exit. 

![0|copy](fig/play.png)

### Copy Photos

1. On the Album interface, right-click a photo.
2. Select **Copy**.
3. Right-click on the desktop or in a target place and select **Paste** to copy the photo file there.

### Favorite Photos

1. On the Album interface, right-click a photo.
2. Select **Favorite** and the photo will be added to the **Favorites** album.
3. Right-click the photo in Favorites to **Unfavorite** it.

> ![tips](../common/tips.svg) Tips: When viewing a photo, click the ![collect](../common/collect.svg) icon to favorite the photo and click ![collect_active](../common/collect_active.svg) again to unfavorite it.

### Rotate Photos

1. On the Album interface, right-click a photo and select **Rotate clockwise** or **Rotate counterclockwise**.
2. The photo will be rotated clockwise or counterclockwise for 90 degrees.

>    ![notes](../common/notes.svg) Notes: If you are using a computer equipped with touch-screen, place two fingers on the photo and keep a certain distance, and rotate the two fingers at the same time to rotate the photo.
>

### Set as Wallpaper

1. Right-click the photo on the Album interface. 
2. Select **Set as wallpaper** to set the current photo as wallpaper.

### Display in File Manager

1. Right-click the photo on the Album interface. 
2. Select **Display in file manager** to open the folder where the photo is located.

![0|display](fig/display.png)

### View Photo Information

1. Right-click the photo on the Album interface. 
2. Select **Photo info** to view the detailed information of photos.

![0|display](fig/info.png)
### Delete Photos

You can delete photos from Album in the following ways:

- Click the ![delete_press](../common/delete.svg) icon on the Album interface when viewing photos.
- Right-click the photo and select **Delete**.
- On the Album interface, click to select the photo and press **Delete** on the keyboard.

> ![tips](../common/tips.svg) Tips: The deleted photos in the Album are not deleted permanently but are temporarily stored in the **Trash** album. When the number displayed in remaining days on the photo is 0, the photos will be deleted permanently. You are able to restore or permanently delete the photos here in advance.

## Album Management

On the Album interface, you are able to create new albums, manage photos in the album, and view all albums.

> ![notes](../common/notes.svg) Notes: **Import**, **Trash** and **Favorites** are albums generated automatically by the system according to the actual conditions, which cannot be deleted or renamed.

![1|album](fig/album.png)

### Create New Albums

1. On the Albums interface, Click ![create](fig/create.jpeg) or ![icon_menu](../common/icon_menu.svg)> **New album**.
2. Enter the album name and click **Create**.

> ![tips](../common/tips.svg) Tips: You are able to create a new album by right-clicking the album created to select **New album**, or create a new album when adding photos to albums.

### Add Photos to Albums

1. On the Album interface, right-click a photo and select **Add to album**.
2. Select an album and add the photo to it.

>![tips](../common/tips.svg) Tips: You are also able to add photos to an album by dragging the photo or photo folder directly to it.

![0|add-to-album](fig/add-to-album.png)

### Delete Photos from Albums

1. On the Albums interface, right-click a photo in an album.
2. Select **Remove from album** to remove the photo from the album.

### Rename Albums

1. On the Albums interface, right-click the album to be renamed and select **Rename**. 
2. Enter the album name and press the **Enter** key on the keyboard, or click the blank area of the interface.

### Export Albums

1. On the Albums interface, right-click an album.
2. Select **Export**.

### Delete Albums

1. On the Albums interface, right-click an album.
2. Select **Delete**.

## Main Menu

In the main menu, you can [Create New Albums](#Create New Albums), [Import Photos](#Import Photos), switch window themes, view help manual, and get more information about Album.

### Theme

The window theme provides three theme types, namely Light Theme, Dark Theme, and System Theme.

1.  On the Album interface, click ![main_menu](../common/icon_menu.svg).
2.  Click **Theme** to choose one theme.

### Help

1.  On the Album interface, click ![icon_menu](../common/icon_menu.svg).
2.  Click **Help** to view the manual of Album.

### About

1.  On the Album interface, click ![icon_menu](../common/icon_menu.svg).
2.  Click **About** to view the version and introduction of Album.

### Exit

1.  On the Album interface, click ![icon_menu](../common/icon_menu.svg).
2.  Click **Exit** to exit Album.
