#include "dispatcher"

typedef map < unsigned long, std::queue<time_t> > AccessMap;
static AccessMap accesslog;
static time_t accesslog_lastclean = 0;

// Execute an external program upon excess of hard/soft rates
static void run_excess(string const &prog, char const *ip) {
    ostringstream o;
    o << prog << ' ' << ip;
    msg ((Mstr("Max connection rate exceeded, invoking '") + o.str()) +
	 "'\n");
    int ret = sysrun(o.str());
    if (ret == -1)
	throw Error(string("Failed to start system call: ") +
		    strerror(errno));
    else if (ret)
	warnmsg((Mstr("Program '") + o.str()) +
		(Mstr("' exited with exit status ") + ret) + "\n");
    else
	msg((Mstr("Program '") + o.str()) + "' finished.\n");
}

bool Dispatcher::check_dos() {
    msg ("Verifying DOS protection\n");
    Threadlist::desc("Verifying");

    // Check 'softmaxconnrate' and 'hardmaxconnrate' now!
    // Descend into this block if connrate_time() is set, AND
    // either hardmaxconnrate() is set,
    // or both softmaxconnrate() and defertime() are set.
    if (config.connrate_time() &&
	(config.hardmaxconnrate() ||
	 (config.softmaxconnrate() && config.defertime()))) {
     	time_t now, min_ts;
     	now = time(0);
     	min_ts = now - config.connrate_time();
     	unsigned max_conns = max(config.hardmaxconnrate(),
     	  			 config.softmaxconnrate());

	Mutex::lock (&accesslog[clientip().s_addr]);
	accesslog[clientip().s_addr].push(now);
	Mutex::unlock (&accesslog[clientip().s_addr]);
	
	if (accesslog_lastclean < min_ts) {
	    // Clean the entire access log, it's been a while...

	    Mutex::lock(&accesslog_lastclean);
	    accesslog_lastclean = now;
	    Mutex::unlock(&accesslog_lastclean);

	    for (AccessMap::iterator i = accesslog.begin();
		 i != accesslog.end();
		 i++ ) {
		if (accesslog[i->first].back() < min_ts) {
		    // This IP hasn't made ANY connections in a while -- erase!
		    accesslog.erase(i);
		} else {
		    // Keep popping off this IP's oldest connection until we
		    // have only "recent" connections left.
		    Mutex::lock(&accesslog[i->first]);
		    while ( accesslog[i->first].front() < min_ts
			    || accesslog[i->first].size() > max_conns ) {
		    	accesslog[i->first].pop();
		    }
		    Mutex::unlock(&accesslog[i->first]);
		}	
	    }
	} else {
	    // The "big log" doesn't need to be fully cleaned,
	    // but this particular IP should be!
	    Mutex::lock(&accesslog[clientip().s_addr]);
	    while ( accesslog[clientip().s_addr].front() < min_ts
		    || accesslog[clientip().s_addr].size() > max_conns ) {
	     	accesslog[clientip().s_addr].pop();
	    }
	    Mutex::unlock(&accesslog[clientip().s_addr]);
	}

	if (config.hardmaxconnrate() &&
	    accesslog[clientip().s_addr].size() >= config.hardmaxconnrate() ) {
	    // This IP has violated the "HARD" limit!  Reject the connection
	    ostringstream o;
	    o << "Client " << clientipstr() 
	      << " has hit the HARD maximum number of connections ("
	      << config.hardmaxconnrate() << " conections in "
	      << config.connrate_time() << " seconds; "
	      << accesslog[clientip().s_addr].size()
	      << " connections recorded). Client is refused.\n";
	    warnmsg (o.str());
	    socketclose(clientfd());
	    run_excess(config.hardmaxconnexcess(), clientipstr().c_str());
	    return false;
	} else if (config.softmaxconnrate() &&
		   (accesslog[clientip().s_addr].size() >=
		    config.softmaxconnrate())) {
	    // This IP has violated the "SOFT" Limit. Go to sleep for a while.
	    ostringstream o;
	    o << "Client " << clientipstr()
	      << " has hit the SOFT maximum number of connections ("
	      << config.softmaxconnrate() << " connections in "
	      << config.connrate_time() << " sedonds; "
	      << accesslog[clientip().s_addr].size()
	      << " connections recorded). Client is deferred for "
	      << config.defertime() << " microseconds.\n";
	    warnmsg (o.str());
	    run_excess(config.softmaxconnexcess(), clientipstr().c_str());
	    usleep(config.defertime());
	}
    }

    return true;
}
