/*
** Copyright 1998 - 2008 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	<stdlib.h>

static const char decode64tab[256]= {
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100,  62, 100, 100, 100,  63, 
	 52,  53,  54,  55,  56,  57,  58,  59, 
	 60,  61, 100, 100, 100, 100, 100, 100, 
	100,   0,   1,   2,   3,   4,   5,   6, 
	  7,   8,   9,  10,  11,  12,  13,  14, 
	 15,  16,  17,  18,  19,  20,  21,  22, 
	 23,  24,  25, 100, 100, 100, 100, 100, 
	100,  26,  27,  28,  29,  30,  31,  32, 
	 33,  34,  35,  36,  37,  38,  39,  40, 
	 41,  42,  43,  44,  45,  46,  47,  48, 
	 49,  50,  51, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100};

int authsasl_frombase64(char *base64buf)
{
	int	i, j, k;

	for (j=0; base64buf[j]; j++)
		if (decode64tab[(unsigned char)base64buf[j]] >= 100)
			break;

	if (base64buf[j] && base64buf[j+1] && base64buf[j+2])
		return (-1);
	while (base64buf[j] == '=')	++j;
	if (j % 4)	return (-1);

	i=j;
	k=0;
	for (j=0; j<i; j += 4)
	{
	int	w=decode64tab[(int)(unsigned char)base64buf[j]];
	int	x=decode64tab[(int)(unsigned char)base64buf[j+1]];
	int	y=decode64tab[(int)(unsigned char)base64buf[j+2]];
	int	z=decode64tab[(int)(unsigned char)base64buf[j+3]];
	int	a,b,c;

		a= (w << 2) | (x >> 4);
		b= (x << 4) | (y >> 2);
		c= (y << 6) | z;
		base64buf[k++]=a;
		if ( base64buf[j+2] != '=')
			base64buf[k++]=b;
		if ( base64buf[j+3] != '=')
			base64buf[k++]=c;
	}
	return (k);
}
