/*
 * Copyright © 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 */

#ifndef PLATFORM_NMOFONO_WIFI_ACCESS_POINT
#define PLATFORM_NMOFONO_WIFI_ACCESS_POINT

#include <com/ubuntu/connectivity/networking/wifi/access-point.h>

#include <services/nm.h>

#include <chrono>

namespace platform {
namespace nmofono {
namespace wifi {
    class AccessPoint;
}
}
}

class platform::nmofono::wifi::AccessPoint : public com::ubuntu::connectivity::networking::wifi::AccessPoint
{

public:
    AccessPoint(org::freedesktop::NetworkManager::Interface::AccessPoint ap)
        : m_ap(ap)
    {
        m_secured = m_ap.flags->get() == NM_802_11_AP_FLAGS_PRIVACY;
        /// @todo check for the other modes also..
        m_adhoc = m_ap.mode->get() != NM_802_11_MODE_INFRA;

        std::string ssid;
        for (auto c : m_ap.ssid->get()) {
            if (isprint(c)) {
                ssid += (char)c;
            } else {
                // contains unprintable characters
                /// @todo do something more elegant
                ssid += u8"�";
            }
        }
        m_ssid = ssid;

        m_strength.set(m_ap.strength->get());
        m_ap.properties_changed->connect([this](org::freedesktop::NetworkManager::Interface::AccessPoint::Signal::PropertiesChanged::ArgumentType map){
            for (auto entry : map) {
                if (entry.first == "Strength") {
                    m_strength.set(entry.second.as<std::int8_t>());
                }
            }
        });
    }

    const core::Property<double>& strength()
    {
        return m_strength;
    }

    // time when last connected to this access point
    // for APs that have never been connected the
    // lastConnected->time_since_epoch().count() is 0
    const core::Property<std::chrono::system_clock::time_point>& lastConnected()
    {
        return m_lastConnected;
    }

    std::string ssid()
    {
        return m_ssid;
    }

    bool secured()
    {
        return m_secured;
    }

    bool adhoc()
    {
        return m_adhoc;
    }

    core::Property<double> m_strength;
    core::Property<std::chrono::system_clock::time_point> m_lastConnected;
    std::string m_ssid;
    bool m_secured;
    bool m_adhoc;
    org::freedesktop::NetworkManager::Interface::AccessPoint m_ap;
};

#endif
