/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2012 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 4344 $
//
//  $LastChangedDate: 2012-05-11 14:51:08 -0700 (Fri, 11 May 2012) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#ifndef __cmtkClassStreamInput_h_included_
#define __cmtkClassStreamInput_h_included_

#include <cmtkconfig.h>

#include <IO/cmtkTypedStreamInput.h>
#include <IO/cmtkStudy.h>

#include <Base/cmtkAffineXform.h>
#include <Base/cmtkWarpXform.h>
#include <Base/cmtkSplineWarpXform.h>
#include <Base/cmtkParametricPlane.h>

#include <string>

namespace
cmtk
{

/** \addtogroup IO */
//@{

/** Class for reading various library classes to and from disk.
 */
class ClassStreamInput : 
  /// Inherit basic functionality from typed stream.
  public TypedStreamInput
{
public:
  /// This class.
  typedef ClassStreamInput Self;

  /// Parent class.
  typedef TypedStreamInput Superclass;

  /// Default constructor.
  ClassStreamInput() : TypedStreamInput() {}

  /** Open constructor.
   *\param filename Name of the archive to open.
   */
  ClassStreamInput( const std::string& filename ) : TypedStreamInput( filename ) {}

  /** Open constructor for separate path and archive names.
   *\param dir Directory to open archive in.
   *\param archive Name of the archive to open.
   */
  ClassStreamInput( const std::string& dir, const std::string& archive ) : TypedStreamInput( dir, archive ) {}

  /// Read (spline or linear) warp transformation.
  ClassStreamInput& operator >> ( WarpXform::SmartPtr& warpXform );

  /// Read (spline or linear) warp transformation.
  ClassStreamInput& operator >> ( WarpXform*& warpXform );

  /// Actually read warp transformation object.
  ClassStreamInput& Get ( WarpXform::SmartPtr& warpXform, const AffineXform* affineXform = NULL  );

  /// Actually read warp transformation object.
  ClassStreamInput& Get ( WarpXform*& warpXform, const AffineXform* affineXform = NULL  );

  /// Read parametric plane.
  ClassStreamInput& operator >> ( ParametricPlane*& parametricPlane );
};

//@}

} // namespace cmtk

#endif // #ifndef __cmtkClassStreamInput_h_included_
