#ifndef H_CDW_CHECKBOX
#define H_CDW_CHECKBOX


#include "cdw_ncurses.h"

typedef struct {
	WINDOW *parent;  /* parent window of the widget */
	int begin_y;
	int begin_x;
	bool checked;    /* state of the checkbox */
	bool visible;    /* widget may be present, but invisible to the user, and "not-visitable" */

	/* The variable will be set to CDW_WIDGET_ID_CHECKBOX by
	   cdw_checkbox_new(). */
	cdw_id_t widget_id;

	cdw_form_widget_function_t on_toggle_callback;
} CDW_CHECKBOX;




CDW_CHECKBOX *cdw_checkbox_new(WINDOW *parent, int begin_y, int begin_x, bool checked);
void cdw_checkbox_delete(CDW_CHECKBOX **checkbox);
void cdw_checkbox_free(CDW_CHECKBOX *checkbox);
bool cdw_checkbox_toggle(CDW_CHECKBOX *checkbox);
bool cdw_checkbox_get_state(CDW_CHECKBOX *checkbox);
bool cdw_checkbox_set_state(CDW_CHECKBOX *checkbox, bool checked);
void cdw_checkbox_set_visibility(CDW_CHECKBOX *checkbox, bool visible);
void cdw_checkbox_draw(CDW_CHECKBOX *checkbox);
int  cdw_checkbox_driver(CDW_CHECKBOX *checkbox, void *cdw_form);

#endif /* #ifndef H_CDW_CHECKBOX */
