/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef REPORTWINDOW_H
#define REPORTWINDOW_H

#if defined(_WIN32) && !defined(__MINGW32__) // MSVC only
#pragma warning( disable : 4290 )
#endif // MSVC only

#include <QString>
#include <QStringList>
// Include GUI  automatically generated from the file 
// MedicalViewer.ui (to be modified via QtDesigner).
#include "ui_ReportWindow.h"

class ReportWindow : public QMainWindow  {
    Q_OBJECT	

	
public:
	ReportWindow(QMainWindow * dad);
    ReportWindow(QMainWindow * dad, QString fileName);

    void setHTMLFile(QString fileName) throw (QString);


public slots:
	virtual void camiTKPushButtonClicked();
	virtual void wizardPushButtonClicked();
    virtual void slotFileOpen();
    virtual void slotClose();
    virtual void backPushButtonClicked();
    virtual void forwardPushButtonClicked();
    virtual void urlEdited();


private:
    void readHTMLFile() throw (QString);

	 Ui_ReportWindow ui;

     QMainWindow * dad;
     QString filename;
     QStringList backwardList;
     QStringList forwardList;

};
#endif
