#!
#! \addtogroup CamiTKMacros
#!
#! macro camitk_sub_project_add adds a subproject definition from targets and its dependencies (if any) to the variable
#! Typically recursively call this function accross all targets to generate Project.xml file.
#!
#! Usage:
#! \code
#! camitk_sub_project_add(ACTION|COMPONENT|CEP_LIBRARY|APPLICATION target name
#!               [DEPENDENCIES dep1 dep2 dep3]
#!               
#! )
#! \endcode
#!
#! \param TARGET_TYPE name              the library / exe program targeted for CMake compilation
#! \param DEPENDENCIES (optional)       the library dependencies to build the target
macro(camitk_sub_project_add)
    parse_arguments(ADD_SUB_PROJECT
        "ACTION;COMPONENT;CEP_LIBRARY;APPLICATION;CORELIB;DEPENDENCIES"  # possible lists
        "" #possible options
        ${ARGN}
    )

    # check types
    if(ADD_SUB_PROJECT_ACTION)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_ACTION})
        set(CAMITK_ACTION_TARGETS ${CAMITK_ACTION_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK action targets" FORCE)
    endif()
    if(ADD_SUB_PROJECT_COMPONENT)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_COMPONENT})
        set(CAMITK_COMPONENT_TARGETS ${CAMITK_COMPONENT_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK component targets" FORCE)
    endif()
    if(ADD_SUB_PROJECT_CEP_LIBRARY)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_CEP_LIBRARY})
        set(CAMITK_CEP_LIBRARY_TARGETS ${CAMITK_CEP_LIBRARY_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK CEP library targets" FORCE)
    endif()
    if(ADD_SUB_PROJECT_APPLICATION)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_APPLICATION})
        set(CAMITK_APPLICATION_TARGETS ${CAMITK_APPLICATION_TARGETS} ${SUB_PROJECT_NAME} CACHE STRING "List of CamiTK applications targets" FORCE)
    endif()
    if(ADD_SUB_PROJECT_CORELIB)
        set(SUB_PROJECT_NAME ${ADD_SUB_PROJECT_CORELIB})
    endif()

    # Create the xml node for this current subproject
    set(xml_subproject "\n  <SubProject name=\"${SUB_PROJECT_NAME}\">")
    foreach(DEPENDENCY ${ADD_SUB_PROJECT_DEPENDENCIES})
            set(xml_subproject ${xml_subproject} "\n    <Dependency name=\"${DEPENDENCY}\"/>")
    endforeach()
    set(xml_subproject ${xml_subproject} "  </SubProject>")
    # Please note that no "\n" character is used, avoiding cmake cache to throw an "Offending entry"
    # At the moment I did not find a way to solve this one.

    # Add it to the list of different nodes
    set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} ${xml_subproject} CACHE INTERNAL "")
    set(CAMITK_SUBPROJECTS ${CAMITK_SUBPROJECTS} ${SUB_PROJECT_NAME} CACHE INTERNAL "")

endmacro()