+++
title = "Bipyramid4"
+++

### Bipyramid4

A compound of two truncated pyramids with a common square base and opposite
orientations.

<img src="/img/draw/ff/3d/Bipyramid4.png" width="30%" >
<img src="/img/draw/ff/2d/Bipyramid4_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Bipyramid4_xz.svg" width="30%">

#### Constructor

```python
Bipyramid4(L, H, r_H, alpha)
```

Parameters:
- L, edge length of the shared quadratic base
- H, height of the bottom pyramid
- r_H, height ratio $r_{H}$ between the top and bottom pyramid
- alpha, dihedral angle $\alpha$ between the base and a side face.

Constraint:

$H \le \dfrac{\tan\alpha}{2} L \quad $ and $ \quad r_{H} H \le \dfrac{\tan\alpha}{2} L$

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class [Bipyramid4]({{% url-src %}}/Sample/HardParticle/Polyhedra.h) inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron
provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$V=\dfrac{L^3\tan\alpha}{6}\Big[2-\Big(1-\dfrac{2H}{L\tan\alpha}\Big)^3-\Big(1-\dfrac{2r_{H}H}{L\tan\alpha}\Big)^3\Big].$$

#### Related shapes

More special:
- [Pyramid4](/ref/sample/particle/ff/hard/pyramid4), if $r_H \to \infty$.
- [Box](/ref/sample/particle/ff/hard/box), if $\alpha=90^{\circ}$.
- [PlatonicOctahedron](/ref/sample/particle/ff/hard/platonicoctahedron), if regular and not truncated.

#### Example

Scattering by uncorrelated, oriented bipyramids for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/Bipyramid4.png">

Generated by {{% ref-ex "ff/Bipyramid4.py" %}}.

#### History

Was incorrectly named "Cuboctahedron" up to BornAgain 1.19.

Agrees with "Cubooctaedron" form factor of IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.33;
[Renaud 2009](/lit/renaud2009), Eq. 218],
except for different parametrization $L = 2R_{IsGISXAXS}$. Since BornAgain-1.6 implemented using the generic polyhedron form factor [[Wuttke 2021](/lit/wuttke2021)].
