//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_13.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root13(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[13] = {5.661340588975947e-01,1.071427972318604e-01,1.398569672149007e+00,2.616607091098259e+00,4.238862100920015e+00,
    6.292280277333457e+00,8.815035572474203e+00,1.186144884335685e+01,1.551082121638828e+01,1.988471153160454e+01,2.518535995833174e+01,3.180050763847425e+01,
    4.072316405595257e+01};
  constexpr double aw[13] = {1.828451089831869e-01,1.235948257355774e-01,1.262816917406144e-01,5.173557633872573e-02,1.321642760925927e-02,
    2.110206065922282e-03,2.059416702618249e-04,1.175778179702481e-05,3.658669747628742e-07,5.544229240135393e-09,3.385426230780610e-11,5.799921859627044e-14,
    1.122550867941830e-17};
  constexpr double x[6851] = {  7.291850316246106e-03,  1.396957335135578e-04,  1.999562486050905e-06,  2.531466228978526e-08,  2.985293612068409e-10,
  3.353344979581788e-12,  3.627501603071741e-14,  3.800652881608797e-16,  3.866649834873157e-18,  3.821635304642107e-20,  3.663943238003051e-22,  3.395037465196105e-24,
  6.493945880174758e-02,  1.206742977708125e-03,  1.623882119711686e-05,  1.847221098338755e-07,  1.831218218317748e-09,  1.554327479336491e-11,  1.031921047883912e-13,
  3.257065051286789e-16, -4.564870715009902e-18, -1.170553574906267e-19, -1.658916054993814e-21, -1.781864064731409e-23,  1.766336697066981e-01,  3.086117898484807e-03,
  3.642774385013236e-05,  3.201969495785663e-07,  1.779191295360087e-09, -2.476931745296824e-12, -2.166728720193432e-13, -3.137201371254490e-15, -2.548116212645195e-17,
 -3.950016678931197e-20,  2.515216053101904e-21,  4.725349559966284e-23,  3.354693337742074e-01,  5.334220610075058e-03,  5.051352542395852e-05,  2.411806558287198e-07,
 -1.353098658155244e-09, -3.976996053452290e-11, -3.450353874694540e-13,  3.220202421388605e-16,  4.763849422835689e-17,  5.901955933437676e-19,  1.456124380934727e-21,
 -6.290344547507541e-23,  5.317862592935951e-01,  7.430355070265150e-03,  4.912525733013070e-05, -6.534428112832400e-08, -4.719878972842256e-09, -3.273223605595298e-11,
  2.638405913328840e-13,  6.474292134695863e-15,  2.394940671603391e-17, -6.795506891206834e-19, -9.863058696534459e-21,  6.832934002564256e-24,  7.538941997916104e-01,
  8.902345739401855e-03,  3.037737759444259e-05, -4.112389676980769e-07, -4.341410910596217e-09,  2.521004364671704e-11,  6.304729800011206e-13, -3.923700029702348e-16,
 -8.833429059685810e-17, -3.615260973735033e-19,  1.139031821867149e-20,  1.105968886262626e-22,  9.888855511733313e-01,  9.433035461994586e-03,  6.295439969695293e-07,
 -5.594915267195027e-07, -4.440327357471544e-11,  5.975436808327402e-11,  2.091846761209245e-15, -7.763764400525936e-15,  2.219120183256959e-19,  1.118127576056071e-18,
 -1.185194198014316e-22, -1.716290863118917e-22,  1.223454615693848e+00,  8.923727662234626e-03, -2.885563207223378e-05, -4.128336719860086e-07,  4.165920840834541e-09,
  2.542091716425959e-11, -6.037620019981074e-13, -4.625470353623486e-16,  8.370485458720015e-17, -3.357981502580580e-19, -1.060892777998543e-20,  1.028328849846063e-22,
  1.444661387735191e+00,  7.504577844358690e-03, -4.736012468241387e-05, -8.168175888647531e-08,  4.568287274973459e-09, -2.920408385775322e-11, -2.666069091347172e-13,
  5.906096116980216e-15, -1.852644829270136e-17, -6.293048674839088e-19,  8.429269218250016e-21,  1.156653565764025e-23,  1.640600717506251e+00,  5.495530841366417e-03,
 -4.950787161250164e-05,  2.117327345834779e-07,  1.542198056090704e-09, -3.770258104116751e-11,  2.890878750252373e-13,  7.395015642880639e-16, -4.430507967158340e-17,
  4.756177706571804e-19, -3.996230413687959e-22, -5.875028293471598e-23,  1.800958177109012e+00,  3.331184244426753e-03, -3.730144343799130e-05,  3.038952935948825e-07,
 -1.418136709232735e-09, -6.051144876262445e-12,  2.248583673146964e-13, -2.757960642137607e-15,  1.772922918508439e-17,  3.912361007297750e-20, -2.731326643521240e-21,
  3.915967346143908e-23,  1.917449688382196e+00,  1.467807075241860e-03, -1.875441683534978e-05,  2.000080672926072e-07, -1.817969561934816e-09,  1.347568043988856e-11,
 -6.594647225210150e-14, -1.252388809839648e-16,  8.502475840081432e-18, -1.352413055705345e-19,  1.498819867238923e-21, -1.224879929406377e-23,  1.984166657540881e+00,
  2.909707577941726e-04, -3.979842655460909e-06,  4.788511680449372e-08, -5.329226450398823e-10,  5.597996417875124e-12, -5.596442122987294e-14,  5.334216480394206e-16,
 -4.830665196782930e-18,  4.115656744836330e-20, -3.229529537140735e-22,  2.222128653155304e-24,  7.884671930103884e-03,  1.569939606292930e-04,  2.334374215012939e-06,
  3.067885699070533e-08,  3.752423002012992e-10,  4.367009200016652e-12,  4.887792328709990e-14,  5.289590861060103e-16,  5.546506974963063e-18,  5.633845932596964e-20,
  5.529227091827892e-22,  5.214425469101775e-24,  7.004102618698159e-02,  1.346042813933727e-03,  1.864198554778231e-05,  2.166458368749102e-07,  2.167484893627935e-09,
  1.810842420152172e-11,  1.095325062029135e-13,  9.773842222432382e-17, -1.018181799901293e-17, -2.012630564278090e-19, -2.607517794563447e-21, -2.549020436631506e-23,
  1.895859959149180e-01,  3.393387487264502e-03,  4.043827399146258e-05,  3.479536267768977e-07,  1.670057105405628e-09, -8.823831711643475e-12, -3.159798477648116e-13,
 -3.951457184234071e-15, -2.452868291676901e-17,  1.095807384235395e-19,  5.112175504399077e-21,  7.091005488384997e-23,  3.576321594145944e-01,  5.749474097321590e-03,
  5.325010661070173e-05,  2.127243764620862e-07, -2.229601460706507e-09, -4.775046747300744e-11, -3.114384818951572e-13,  2.191285375447224e-15,  6.912204167722349e-17,
  5.770456020710718e-19, -2.524700692487470e-21, -1.190158254150214e-22,  5.622868426927138e-01,  7.818889589831641e-03,  4.786770023682195e-05, -1.456925769470619e-07,
 -5.296176405838500e-09, -2.416338501635330e-11,  4.516398631440362e-13,  6.775121130691989e-15, -7.324317064353630e-18, -1.043607036498738e-18, -7.687536459903491e-21,
  9.590857081222641e-23,  7.899567567258379e-01,  9.124488044252879e-03,  2.504501197059738e-05, -4.758554019768797e-07, -3.688476094992515e-09,  3.988147378646822e-11,
  5.786324133696303e-13, -3.331079326203991e-15, -9.216622137206515e-17,  1.697130003778917e-19,  1.454313210426756e-20,  2.477454571765200e-23,  1.026585346643033e+00,
  9.411294622117618e-03, -6.049371201894169e-06, -5.507119759117312e-07,  1.133738603403623e-09,  5.723354850129108e-11, -2.092338749646178e-13, -7.128072253364536e-15,
  3.861056263393665e-17,  9.678202583239612e-19, -7.145832956601065e-21, -1.374703893990035e-22,  1.258658105083315e+00,  8.674233244267216e-03, -3.339547951037493e-05,
 -3.428980253411359e-07,  4.529894209664108e-09,  1.106402611615065e-11, -5.815596050913658e-13,  1.950317572887464e-15,  6.518212653312867e-17, -6.579252845744906e-19,
 -5.305994471362560e-21,  1.292025449366623e-22,  1.473917422489658e+00,  7.122972321099565e-03, -4.792200086443813e-05, -1.355469571493171e-08,  3.933188407680847e-09,
 -3.370379483706346e-11, -1.124773872897433e-13,  5.015785845276405e-15, -3.514743023505755e-17, -2.988391487626968e-19,  7.732622036509177e-21, -3.799495180928205e-23,
  1.661807326376475e+00,  5.109995682770644e-03, -4.684267764476332e-05,  2.307568194697852e-07,  8.584431098029252e-10, -3.066060854118192e-11,  2.924713708666658e-13,
 -4.117654869731853e-16, -2.799079191474077e-17,  4.190724027964176e-19, -2.171295713853382e-21, -2.364107766325819e-23,  1.813708632589403e+00,  3.046966519459546e-03,
 -3.379395393371356e-05,  2.805050458814683e-07, -1.491114297023099e-09, -1.516483542411362e-12,  1.556578685595835e-13, -2.186053705843076e-15,  1.754872798912704e-17,
 -3.978719198280552e-20, -1.313647993400394e-21,  2.556125661079912e-23,  1.923035374823319e+00,  1.326897560542952e-03, -1.652023175866865e-05,  1.729899760830127e-07,
 -1.564425918949270e-09,  1.187751962096579e-11, -6.629934567360048e-14,  7.950761972027180e-17,  4.590627038797279e-18, -8.523041380543822e-20,  1.022962520425581e-21,
 -9.350538765270879e-24,  1.985270308366574e+00,  2.612936060152438e-04, -3.452910388401184e-06,  4.018583690966643e-08, -4.332691533504533e-10,  4.417896748385344e-12,
 -4.298672877975396e-14,  4.002349710703248e-16, -3.559450992613728e-18,  3.003439055107250e-20, -2.369976345010121e-22,  1.695778108348057e-24,  8.552482751676914e-03,
  1.772506838928683e-04,  2.741647129629381e-06,  3.745061419361877e-08,  4.756250644803732e-10,  5.739904323288123e-12,  6.651175684828439e-14,  7.436583623756250e-16,
  8.034687252893395e-18,  8.378459866400516e-20,  8.397895644432307e-22,  8.023792535816376e-24,  7.574080406955312e-02,  1.506195708749541e-03,  2.146222911094584e-05,
  2.543659482628907e-07,  2.555941358855370e-09,  2.072575555165772e-11,  1.064615700353887e-13, -3.664727935639874e-16, -1.959647695972122e-17, -3.303380855002438e-19,
 -3.901645391485107e-21, -3.301704114801342e-23,  2.038336227351238e-01,  3.734033426574156e-03,  4.476677807259419e-05,  3.728115378378720e-07,  1.408346125518677e-09,
 -1.781851894884798e-11, -4.366978122328385e-13, -4.627301665591694e-15, -1.609317651542703e-17,  3.826750030911448e-19,  8.674321297794144e-21,  8.865830456124523e-23,
  3.814972695286695e-01,  6.185004172122812e-03,  5.555599490676894e-05,  1.690301572042897e-07, -3.253016412278765e-09, -5.422054758662242e-11, -2.161959364010372e-13,
  4.704863645955123e-15,  8.666945386396397e-17,  3.555093633141528e-19, -8.905240711282461e-21, -1.668396366206340e-22,  5.943151346709814e-01,  8.193364802678056e-03,
  4.559709034973580e-05, -2.336450435759198e-07, -5.655975728663067e-09, -1.111067243605897e-11,  6.320471241354209e-13,  5.890254255581093e-15, -4.915089699414897e-17,
 -1.238171657036789e-18, -1.360809686257165e-21,  1.883882984663002e-22,  8.268179335861423e-01,  9.301069155819007e-03,  1.900931851344676e-05, -5.277730429775515e-07,
 -2.761213489932186e-09,  5.232581221299518e-11,  4.457934263080176e-13, -6.070195975687248e-15, -7.562183205016761e-17,  7.402155902818794e-19,  1.314792390696018e-20,
 -8.886953731829561e-23,  1.064092428503774e+00,  9.336858751591270e-03, -1.251236418090233e-05, -5.237525881137108e-07,  2.212877082366900e-09,  4.998647005378629e-11,
 -3.867402543536727e-13, -5.400810617425651e-15,  6.704366922322804e-17,  5.828715475037781e-19, -1.149970389093462e-20, -5.550920735957325e-23,  1.292796405715276e+00,
  8.391854432929847e-03, -3.707047991775478e-05, -2.693853125065548e-07,  4.617144548004173e-09, -2.025475720340338e-12, -5.015380920529974e-13,  3.627190873969316e-15,
  3.902057379595850e-17, -7.599169811663730e-19,  4.807550529301624e-23,  1.078540227131089e-22,  1.501642971482492e+00,  6.739963560759261e-03, -4.772966600557709e-05,
  4.388239779346083e-08,  3.242802206153784e-09, -3.485293798904224e-11,  1.100542306551474e-14,  3.774867019988894e-15, -4.081394666244732e-17, -3.055869840743646e-20,
  5.545583549855770e-21, -5.679195604401851e-23,  1.681515635071244e+00,  4.746519932909372e-03, -4.401020059248894e-05,  2.399620258525132e-07,  3.140239276041764e-10,
 -2.386756432758340e-11,  2.705411337551909e-13, -1.084410142587805e-15, -1.464749224773808e-17,  3.189983172609745e-19, -2.668097312499717e-21, -1.056276994391880e-24,
  1.825376539701506e+00,  2.789672462028285e-03, -3.057143789471321e-05,  2.565878679381004e-07, -1.488722871240514e-09,  1.546611949136232e-12,  1.020342654354856e-13,
 -1.655563593442666e-15,  1.540990113068470e-17, -7.327427239993054e-20, -4.395598672075527e-22,  1.474235791420355e-23,  1.928091210956871e+00,  1.202631198470095e-03,
 -1.458697510622895e-05,  1.497741320449518e-07, -1.342532320555116e-09,  1.032707783840808e-11, -6.242590831396019e-14,  1.844576524252622e-16,  2.167308361363933e-18,
 -5.171216896052141e-20,  6.726346538343919e-22, -6.652870963208128e-24,  1.986263132389377e+00,  2.354877629082666e-04, -3.009530068142451e-06,  3.390793009479370e-08,
 -3.543828069001722e-10,  3.508760343033554e-12, -3.322447757777531e-14,  3.019403622608152e-16, -2.632125137022619e-18,  2.191023076208522e-20, -1.724106171734993e-22,
  1.256501737026270e-24,  9.308392986142340e-03,  2.011201859735687e-04,  3.240804473752627e-06,  4.607337169143927e-08,  6.082354713895641e-10,  7.618146216938970e-12,
  9.143771424950598e-14,  1.056267619719583e-15,  1.175078144291480e-17,  1.255715798176968e-19,  1.280684147029304e-21,  1.230687157073346e-23,  8.212933850655860e-02,
  1.690830705272242e-03,  2.477410662170198e-05,  2.987110412248886e-07,  2.994759084583099e-09,  2.307470019576775e-11,  8.540167095687626e-14, -1.216884706603389e-15,
 -3.466061319920820e-17, -5.167303694021462e-19, -5.432823055401579e-21, -3.485216690095866e-23,  2.195148587326466e-01,  4.110414668950521e-03,  4.936199044100824e-05,
  3.918797480310870e-07,  9.364361517190599e-10, -2.989691885409688e-11, -5.708789924766889e-13, -4.847209758944372e-15,  4.874362444109558e-18,  8.077450479001007e-19,
  1.250874653048353e-20,  7.839074474413914e-23,  4.071376686029921e-01,  6.636596757329511e-03,  5.723550467702522e-05,  1.080752406064704e-07, -4.376984017408785e-09,
 -5.750601477152622e-11, -4.428314415177748e-14,  7.599565812629915e-15,  9.123330200634115e-17, -1.524803267550041e-19, -1.649430494674101e-20, -1.660418276414086e-22,
  6.277982032105669e-01,  8.545376868042015e-03,  4.224585724771829e-05, -3.250418235278933e-07, -5.714232085627510e-09,  5.818716489721451e-12,  7.682786633927753e-13,
  3.611143417001135e-15, -9.253058405392407e-17, -1.108384899829192e-18,  8.178456026970712e-21,  2.326346461388488e-22,  8.642852974946355e-01,  9.427142554108581e-03,
  1.244721458607761e-05, -5.630613729268033e-07, -1.622770258123874e-09,  6.073984740427984e-11,  2.466255710441829e-13, -7.971733614492825e-15, -4.072902962502047e-17,
  1.157877886239680e-18,  7.073839327758208e-21, -1.789009799749094e-22,  1.101200805987675e+00,  9.212294082667966e-03, -1.855373106767490e-05, -4.808998665968199e-07,
  3.108863119921844e-09,  3.914858827118793e-11, -5.054254002967911e-13, -3.011587445394861e-15,  7.940873720691880e-17,  1.014051687890350e-19, -1.191335588895584e-20,
  3.451654125529837e-23,  1.325751986276586e+00,  8.083608814776547e-03, -3.986321334362066e-05, -1.964523340078667e-07,  4.465115059818574e-09, -1.272760363575828e-11,
 -3.865554007261357e-13,  4.447049603873312e-15,  1.272771041594700e-17, -6.758459129622851e-19,  3.813806444540495e-21,  6.135060133348578e-23,  1.527843661844586e+00,
  6.361061914410492e-03, -4.691463287229083e-05,  9.023839667104537e-08,  2.556184283504755e-09, -3.346764352390961e-11,  9.852838068738830e-14,  2.489108331059375e-15,
 -3.852715845338632e-17,  1.411435345328858e-19,  3.067814729493982e-21, -5.310367804281596e-23,  1.699815864282600e+00,  4.406007878571773e-03, -4.111515003150112e-05,
  2.415092362261634e-07, -1.010883079661717e-10, -1.778202695630303e-11,  2.351958794105669e-13, -1.389821929225026e-15, -5.058094593300190e-18,  2.153367610772517e-19,
 -2.434482621398585e-21,  1.005847893026522e-23,  1.836065019649312e+00,  2.557015384906694e-03, -2.763388983976704e-05,  2.331340219577023e-07, -1.436779938444994e-09,
  3.492357064512212e-12,  6.216797759235529e-14, -1.206926210250959e-15,  1.258951181500789e-17, -8.029124964330427e-20,  3.514169491093976e-23,  7.376811621074151e-24,
  1.932679231491159e+00,  1.092774564672840e-03, -1.291201134719774e-05,  1.298664207051122e-07, -1.150520795960154e-09,  8.897122883358431e-12, -5.653609790045242e-14,
  2.286865006195952e-16,  7.256098245796546e-19, -2.999019202302114e-20,  4.289696922211990e-22, -4.523833872139133e-24,  1.987159378573202e+00,  2.129477763286497e-04,
 -2.634472753507608e-06,  2.875859424419536e-08, -2.915429353476944e-10,  2.803990869197087e-12, -2.583965682441125e-14,  2.291032342191908e-16, -1.955156238413860e-18,
  1.601242326337763e-20, -1.249573253086036e-22,  9.161086102077086e-25,  1.016847804766914e-02,  2.294359911210117e-04,  3.857519188773505e-06,  5.715415471787264e-08,
  7.851777629277865e-10,  1.021460661467503e-11,  1.270342544362795e-13,  1.515666379842630e-15,  1.733911847157003e-17,  1.893265524876030e-19,  1.953196353652637e-21,
  1.864874241819641e-23,  8.931294613135256e-02,  1.904211992278058e-03,  2.866168843437082e-05,  3.504164273427599e-07,  3.473263224318310e-09,  2.457137437700609e-11,
  3.268867556678982e-14, -2.668456412006650e-15, -5.751993071095066e-17, -7.616953066594587e-19, -6.691759761722818e-21, -1.744242062603391e-23,  2.367763854257082e-01,
  4.524325024706677e-03,  5.413217742808895e-05,  4.012893441303817e-07,  1.907115249193714e-10, -4.517857770802434e-11, -6.993220738918358e-13, -4.123496325016345e-15,
  4.365630911738835e-17,  1.361198443336703e-18,  1.462407243173831e-20,  3.580814778480421e-24,  4.346062414151216e-01,  7.098390465254329e-03,  5.807428780758523e-05,
  2.886295954400736e-08, -5.518830676076763e-09, -5.569541688599165e-11,  2.075663407728733e-13,  1.029062622150632e-14,  7.227611556168229e-17, -9.382909435039315e-19,
 -2.209958784109191e-20, -7.004389458333110e-23,  6.626287669919564e-01,  8.866202945339083e-03,  3.780395311081412e-05, -4.145087945706144e-07, -5.407156662492785e-09,
  2.510203777288143e-11,  8.225033046744913e-13,  9.461034618846993e-17, -1.241291883058648e-16, -5.837709009241773e-19,  1.767841410133936e-20,  1.811951778818029e-22,
  9.021497312208278e-01,  9.499345959593321e-03,  5.575609581889948e-06, -5.790637530080194e-07, -3.674549338548035e-10,  6.387315283410504e-11,  1.173274672469646e-14,
 -8.569753062176378e-15,  4.029280333139636e-18,  1.271193580926681e-18, -1.565346027616189e-21, -2.003336831197312e-22,  1.137717840946187e+00,  9.041681753883847e-03,
 -2.400244132680102e-05, -4.255768499111482e-07,  3.765189146943349e-09,  2.629381034679665e-11, -5.542579468860573e-13, -4.997929343273507e-16,  7.504319890554721e-17,
 -3.238409175161222e-19, -8.904013334046617e-21,  9.534848550790124e-23,  1.357435364976703e+00,  7.756465499018562e-03, -4.180190627017910e-05, -1.275080905967869e-07,
  4.128022262568643e-09, -2.048601541728439e-11, -2.597575075892773e-13,  4.498893566731655e-15, -8.339353612741442e-18, -4.838323308475266e-19,  5.440938039909524e-21,
  1.409646932302355e-23,  1.552545049183121e+00,  5.990721648209262e-03, -4.560799202249562e-05,  1.259322607098396e-07,  1.915426180498867e-09, -3.040050363892106e-11,
  1.518705669209052e-13,  1.356871682629147e-15, -3.176610660526703e-17,  2.209767999626167e-19,  1.030680523682808e-21, -3.858293586377761e-23,  1.716800336073921e+00,
  4.088626522811443e-03, -3.823752310170599e-05,  2.373399195668630e-07, -4.035004545383329e-10, -1.261608182882538e-11,  1.950517317700307e-13, -1.445482373530341e-15,
  1.061477483971483e-18,  1.282128491053056e-19, -1.898165676596526e-21,  1.335008008582221e-23,  1.845868113010082e+00,  2.346749676333133e-03, -2.497167439435162e-05,
  2.107746822054128e-07, -1.354525771141324e-09,  4.621737851398531e-12,  3.358475651563489e-14, -8.494967468067492e-16,  9.788575738124776e-18, -7.389214754763633e-20,
  2.523218366672395e-22,  2.901526093497108e-24,  1.936853182856123e+00,  9.954121760448874e-04, -1.145842496596727e-05,  1.128101171741798e-07, -9.856186121039785e-10,
  7.618830735532070e-12, -4.994860381333086e-14,  2.375843442591156e-16, -8.857604215770512e-20, -1.631796981287872e-20,  2.658857756392672e-22, -2.978156363852548e-24,
  1.987971097171188e+00,  1.931771606328905e-04, -2.315610589635609e-06,  2.451091127089027e-08, -2.411794267626614e-10,  2.254247955524386e-12, -2.022046237260370e-14,
  1.748706394184786e-16, -1.459706192486400e-18,  1.173991929605562e-20, -9.051422542852546e-23,  6.623091016981943e-25,  1.115260946211692e-02,  2.632697913607766e-04,
  4.626066671969198e-06,  7.153263208626214e-08,  1.023748504509924e-09,  1.384227004561434e-11,  1.783829612103504e-13,  2.196394848900504e-15,  2.578057714007824e-17,
  2.862788633992162e-19,  2.958652110498474e-21,  2.746007726865323e-23,  9.741639591361739e-02,  2.151307698785917e-03,  3.321639485095847e-05,  4.099331963212546e-07,
  3.965294677145074e-09,  2.422410153780268e-11, -7.229265769101634e-14, -5.000222603307164e-15, -8.982212352801986e-17, -1.030491695180190e-18, -6.284163097943834e-21,
  4.700701100802054e-23,  2.557702733643160e-01,  4.976621428868263e-03,  5.893308698793684e-05,  3.961644438001867e-07, -8.890268296883446e-10, -6.314066253437892e-11,
 -7.870604107191073e-13, -1.831715489248324e-15,  1.028403640893187e-16,  1.905251452919846e-18,  1.128022911410449e-20, -1.748292308904142e-22,  4.639289574504524e-01,
  7.562786673195459e-03,  5.785523136629808e-05, -6.797672312751836e-08, -6.558388236568687e-09, -4.703222881000411e-11,  5.217691316720036e-13,  1.188943531491264e-14,
  2.231875711301683e-17, -1.830163002166810e-18, -2.097665252733638e-20,  1.373606331291299e-22,  6.986649220543778e-01,  9.147312495783690e-03,  3.233078471592117e-05,
 -4.959418034525370e-07, -4.709883765101012e-09,  4.441086292817583e-11,  7.674359717885835e-13, -4.063880161182855e-15, -1.308339512076029e-16,  2.443110707460440e-19,
  2.261550464346673e-20,  2.975957731746333e-23,  9.401923025011787e-01,  9.516152612837911e-03, -1.366446406287074e-06, -5.747888159476388e-07,  8.936395974458784e-10,
  6.133130765472241e-11, -2.197187703549503e-13, -7.737342403752558e-15,  4.663723536275475e-17,  1.043918554765562e-18, -9.381001272847043e-21, -1.435650064197337e-22,
  1.173469677664438e+00,  8.830293932497192e-03, -2.873289423320721e-05, -3.618496026884744e-07,  4.158258346733326e-09,  1.308202923759219e-11, -5.368252450666027e-13,
  1.655061205016098e-15,  5.806291906073426e-17, -5.882056974929260e-19, -4.201520401927872e-21,  1.109641674923337e-22,  1.387784247447868e+00,  7.417019552916435e-03,
 -4.295021590657833e-05, -6.503412492688188e-08,  3.665945029904471e-09, -2.525329767448966e-11, -1.398399064315867e-13,  3.995882018325849e-15, -2.179267753671844e-17,
 -2.647791040444987e-19,  5.271702159457514e-21, -1.880630910813784e-23,  1.575788455045817e+00,  5.632378590418229e-03, -4.393231628174725e-05,  1.519239853908543e-07,
  1.346380762860836e-09, -2.640700915372017e-11,  1.768666199687104e-13,  4.725679026050923e-16, -2.343348954278927e-17,  2.331281235721322e-19, -3.042340654941241e-22,
 -2.233571311556209e-23,  1.732560901401454e+00,  3.793991310183124e-03, -3.543572015043654e-05,  2.291060444240364e-07, -6.122519108325051e-10, -8.412914586541833e-12,
  1.556498416294310e-13, -1.351169243779111e-15,  4.451771892312136e-18,  6.396196830265974e-20, -1.321522816816745e-21,  1.240998163439689e-23,  1.854871073237432e+00,
  2.156732306814595e-03, -2.256924110429976e-05,  1.898780612904483e-07, -1.255784561943000e-09,  5.175353475962380e-12,  1.379929757001939e-14, -5.766791492558756e-16,
  7.333046104889180e-18, -6.208354901453189e-20,  3.204339648713565e-22,  4.629537654387350e-25,  1.940659706600929e+00,  9.089027423208647e-04, -1.019449934889109e-05,
  9.819634908078854e-08, -8.446945317203393e-10,  6.499096929203940e-12, -4.341098209657370e-14,  2.271683217337248e-16, -5.129717884579664e-19, -7.958692322017930e-21,
  1.598414931737069e-22, -1.910134484251549e-24,  1.988708530572000e+00,  1.757664618979199e-04, -2.043226156363188e-06,  2.098792720514334e-08, -2.005764804755764e-10,
  1.822801973819610e-12, -1.591916602300716e-14,  1.342768547899298e-16, -1.095760281742378e-18,  8.643314746606560e-21, -6.566210367819157e-23,  4.772339661831220e-25,
  1.228556507259096e-02,  3.040130132528806e-04,  5.592688954614174e-06,  9.038270006522539e-08,  1.348912609269087e-09,  1.896507358560292e-11,  2.531584762100924e-13,
  3.211655056765523e-15,  3.853566963616901e-17,  4.318403882770417e-19,  4.396415712401182e-21,  3.796347905945461e-23,  1.065858140778172e-01,  2.437830157701256e-03,
  3.853179891552246e-05,  4.771055972103313e-07,  4.419256023819191e-09,  2.044833125528775e-11, -2.584285020323205e-13, -8.510451975932672e-15, -1.306157718689520e-16,
 -1.202627345887877e-18, -1.175059297779110e-21,  2.055553827288899e-22,  2.766493205797873e-01,  5.466757504497516e-03,  6.355668664292648e-05,  3.708012729072602e-07,
 -2.342688190268701e-09, -8.220766280782379e-11, -7.814529644607518e-13,  2.624136518157507e-15,  1.770044516097437e-16,  2.125202055380680e-18, -2.355186706680887e-21,
 -4.577830046061326e-22,  4.950980151976141e-01,  8.020515256218731e-03,  5.638137905230852e-05, -1.796418987993021e-07, -7.346704126756894e-09, -3.050050665041803e-11,
  8.537035050896434e-13,  1.140389233515558e-14, -5.651999152461512e-17, -2.471951572041942e-18, -9.212665687448497e-21,  3.957896642151322e-22,  7.357320613353007e-01,
  9.380946258695882e-03,  2.595976120385283e-05, -5.632405033402190e-07, -3.649086535747013e-09,  6.100513706151760e-11,  5.975989545897743e-13, -7.936068043102090e-15,
 -1.059550807154677e-16,  1.118405279238051e-18,  1.967906340763498e-20, -1.621734424126576e-22,  9.781918291512061e-01,  9.477965258609181e-03, -8.138765270325027e-06,
 -5.510342948422602e-07,  2.050993538324807e-09,  5.365881065925366e-11, -4.104009006125297e-13, -5.726752868126422e-15,  7.619966790227592e-17,  5.711196675549660e-19,
 -1.349729384897375e-20, -3.984318549316149e-23,  1.208305243888063e+00,  8.584208473339490e-03, -3.266947849647539e-05, -2.939050911679428e-07,  4.295813130863440e-09,
  9.437865740448182e-13, -4.678316542359678e-13,  3.151165788802852e-15,  3.500338398070077e-17, -6.629910092509934e-19,  2.990628274606062e-22,  8.890888765018763e-23,
  1.416761535457461e+00,  7.071253937733326e-03, -4.339585223310462e-05, -1.056535913647676e-08,  3.135940672385433e-09, -2.735304091627322e-11, -3.887233833319290e-14,
  3.184722227605702e-15, -2.778183774332818e-17, -7.606363457562711e-20,  4.057058067568508e-21, -3.356404881017409e-23,  1.597627064568224e+00,  5.288540003276036e-03,
 -4.199664860827823e-05,  1.694746627045900e-07,  8.613548897236770e-10, -2.208053498613789e-11,  1.808353921018719e-13, -1.470373163953293e-16, -1.545821721957448e-17,
  2.054805808521165e-19, -9.821870545894824e-22, -9.177122075006278e-24,  1.747187056799669e+00,  3.521324575026409e-03, -3.275015325628908e-05,  2.181543652650354e-07,
 -7.461277144390149e-10, -5.113425064530642e-12,  1.200909086914318e-13, -1.181045561941845e-15,  5.928177655063572e-18,  2.131379973796110e-20, -8.299357037965636e-22,
  9.819220638925080e-24,  1.863150853606051e+00,  1.984958909558382e-03, -2.040779957335606e-05,  1.706265206379054e-07, -1.150144968988818e-09,  5.337312506079231e-12,
  6.192273529635540e-16, -3.752942293718503e-16,  5.329793406198807e-18, -4.926805721072108e-20,  3.121114571339696e-22, -6.743751129954104e-25,  1.944139356714286e+00,
  8.318399368132829e-04, -9.093121976797868e-06,  8.566661044408941e-08, -7.246265725743048e-10,  5.531482587047355e-12, -3.731523618169889e-14,  2.072529687756777e-16,
 -7.024936716055609e-19, -3.012958797507204e-21,  9.268522621111652e-23, -1.188504350321456e-24,  1.989380426352603e+00,  1.603761582112055e-04, -1.809487236385691e-06,
  1.805080378258359e-08, -1.676558213195190e-10,  1.482167099684657e-12, -1.260692608994160e-14,  1.037226378539787e-16, -8.272082677641495e-19,  6.394522801449534e-21,
 -4.773701805522786e-23,  3.453604506493002e-25,  1.359852812222404e-02,  3.534909330485995e-04,  6.820453259199546e-06,  1.153631107127565e-07,  1.797041949654351e-09,
  2.627500037197660e-11,  3.629476638870255e-13,  4.730913813529960e-15,  5.767524948162111e-17,  6.438005898410558e-19,  6.255535944431557e-21,  4.512133106142338e-23,
  1.169916381978995e-01,  2.770216108857994e-03,  4.469347601062522e-05,  5.506584074790122e-07,  4.744287860574414e-09,  1.087441871585480e-11, -5.616862118425399e-13,
 -1.336978457191318e-14, -1.718832863065589e-16, -9.901879723913035e-19,  1.404942176005769e-20,  5.152345176920295e-22,  2.995603660152102e-01,  5.992240845335616e-03,
  6.772394386320311e-05,  3.191834086810347e-07, -4.164836576722190e-09, -9.937180978115135e-11, -6.175621915901140e-13,  9.449375950368061e-15,  2.461387702309140e-16,
  1.538690417115404e-18, -2.903689148902805e-20, -7.371203159649984e-22,  5.280656529914185e-01,  8.460906566121145e-03,  5.350415383130910e-05, -3.008521992727200e-07,
 -7.727372896547735e-09, -6.468144369298539e-12,  1.134022802564591e-12,  8.138212541026428e-15, -1.473710573094379e-16, -2.431161164944645e-18,  1.246385421114548e-20,
  5.594337604944202e-22,  7.736271231651958e-01,  9.560693642020168e-03,  1.889312861991910e-05, -6.111677146690148e-07, -2.305362760515417e-09,  7.234009287750867e-11,
  3.349616717027882e-13, -1.054740414891811e-14, -5.368314313418985e-17,  1.715848257794661e-18,  9.205448874279676e-21, -2.964719809497956e-22,  1.015932481763677e+00,
  9.387041195208978e-03, -1.452073672163360e-05, -5.102175064542830e-07,  3.014176158717036e-09,  4.217576102534459e-11, -5.342749550923936e-13, -3.065114801336116e-15,
  8.690879859947782e-17,  2.766868384599605e-20, -1.293560850227774e-20,  6.109905608816910e-23,  1.242098676020901e+00,  8.309911290459293e-03, -3.578520791380668e-05,
 -2.255991316214261e-07,  4.210117544078485e-09, -9.120602746024490e-12, -3.674479898615265e-13,  3.898703628265688e-15,  1.219435565651767e-17, -5.838433152914573e-19,
  3.370713232215245e-21,  4.976690781045711e-23,  1.444352563750950e+00,  6.724391195645788e-03, -4.323972500143979e-05,  3.521100473978526e-08,  2.586247362311798e-09,
 -2.731785290284023e-11,  3.764815633562264e-14,  2.280250762812918e-15, -2.796479278905493e-17,  5.578464804025272e-20,  2.535648264380450e-21, -3.361311753374527e-23,
  1.618122446705734e+00,  4.960903845635591e-03, -3.989407795100830e-05,  1.799569439894709e-07,  4.625502847053611e-10, -1.783923919257700e-11,  1.708473860503856e-13,
 -5.315355745752676e-16, -8.838345925412145e-18,  1.610302151861888e-19, -1.175578467831484e-21, -2.646316101729276e-25,  1.760764636834530e+00,  3.269585002545100e-03,
 -3.020682650761643e-05,  2.055439214688821e-07, -8.221399841140259e-10, -2.606138345902625e-12,  8.975178001661638e-14, -9.846782322496891e-16,  6.194606188311049e-18,
 -4.053949288239531e-21, -4.576911941326448e-22,  7.194471228180072e-24,  1.870776701093560e+00,  1.829581848091659e-03, -1.846717897244042e-05,  1.530757323864406e-07,
 -1.044008314351310e-09,  5.243793307726142e-12, -7.751107423625093e-15, -2.307771709820988e-16,  3.772345747156719e-18, -3.751677635455666e-20,  2.732972968501451e-22,
 -9.722276898602209e-25,  1.947327469614281e+00,  7.630179611975733e-04, -8.131188364768069e-06,  7.491088972448088e-08, -6.224959957361138e-10,  4.702936709621345e-12,
 -3.183861852176307e-14,  1.836608318171970e-16, -7.553399489228233e-19, -1.900175043478580e-22,  5.219568517642975e-23, -6.731438119068469e-25,  1.989994289512367e+00,
  1.467232472992637e-04, -1.608044997030987e-06,  1.558995417076857e-08, -1.408175005994719e-10,  1.211660728946134e-12, -1.004113849486579e-14,  8.059463253575839e-17,
 -6.279808226373705e-19,  4.760280846803300e-21, -3.460321950329526e-23,  2.592175456415621e-25,  1.513113358750591e-02,  4.141240365883289e-04,  8.396333933222879e-06,
  1.488421481106607e-07,  2.421554416858409e-09,  3.680712262178832e-11,  5.251026295686244e-13,  6.999480570604668e-15,  8.582510045021889e-17,  9.322681260310940e-19,
  8.072671763649316e-21,  3.132164562537792e-23,  1.288312850669726e-01,  3.155497058662913e-03,  5.176125756999765e-05,  6.274356448909177e-07,  4.793315004596350e-09,
 -7.747652640407063e-12, -1.017335945432177e-12, -1.928006002304851e-14, -1.907920093572738e-16,  1.545859258514912e-19,  4.664367644349585e-20,  9.870173720981472e-22,
  3.246353660327160e-01,  6.548064600823677e-03,  7.108641207083754e-05,  2.359477676483428e-07, -6.274273878901682e-09, -1.100867279567997e-10, -2.363609729283905e-13,
  1.792193878555783e-14,  2.724503737101438e-16, -3.052959247200291e-19, -6.325778039800740e-20, -7.442571305004230e-22,  5.627395131976046e-01,  8.872397163876316e-03,
  4.915280721660534e-05, -4.239794069661731e-07, -7.569193696227436e-09,  2.287371758697494e-11,  1.283679415740682e-12,  2.166549195482465e-15, -2.199814585626575e-16,
 -1.443824587530486e-18,  3.629118439784673e-20,  4.749443104981106e-22,  8.121250017081727e-01,  9.681987846646971e-03,  1.138667942785653e-05, -6.361454668902817e-07,
 -8.028454785314349e-10,  7.670009398448298e-11,  2.522477799289505e-14, -1.123226255578231e-14,  1.145056399652377e-17,  1.812004411244347e-18, -4.403684596448597e-21,
 -2.972434077465567e-22,  1.053210774339176e+00,  9.247264175851110e-03, -2.032847282488995e-05, -4.559628087082974e-07,  3.724129258696205e-09,  2.863505165769103e-11,
 -5.816880308395809e-13, -3.613397056829999e-16,  7.944226219017708e-17, -4.143436458968743e-19, -8.714678585514823e-21,  1.228474898591008e-22,  1.274750207035692e+00,
  8.013929231123528e-03, -3.809569510726883e-05, -1.601380293878924e-07,  3.948509399129645e-09, -1.660369264845109e-11, -2.557740383092339e-13,  3.982247307990864e-15,
 -5.973079023197616e-18, -4.164669489267602e-19,  4.739711599871165e-21,  1.450771705824030e-23,  1.470561907868395e+00,  6.380825879450044e-03, -4.258672895583087e-05,
  7.228911805975121e-08,  2.053585063121196e-09, -2.574676755697944e-11,  8.939225434539319e-14,  1.434314882720183e-15, -2.446790370875552e-17,  1.298729593868572e-19,
  1.237813759986331e-21, -2.419423158251784e-23,  1.637341577228418e+00,  4.650489273562811e-03, -3.770125710147196e-05,  1.847206854825953e-07,  1.454197330386803e-10,
 -1.394442369157892e-11,  1.528120455375968e-13, -7.305914658008728e-16, -3.873033447028109e-18,  1.156576695380469e-19, -1.050324419564814e-21,  5.639382751177903e-24,
  1.773374968937187e+00,  3.037569630773239e-03, -2.782059047762978e-05,  1.920807619180770e-07, -8.548407941699592e-10, -7.607943413381250e-13,  6.491224866099708e-14,
 -7.917361092427501e-16,  5.790050562083467e-18, -1.660025797590418e-20, -1.811472483102851e-22,  5.625198525206368e-24,  1.877810796892502e+00,  1.688915976139599e-03,
 -1.672707226468708e-05,  1.371985319993404e-07, -9.414506465464278e-10,  4.992691852782341e-12, -1.271132673875902e-14, -1.296425309945961e-16,  2.608731004110381e-18,
 -2.737266286990341e-20,  2.368908290876910e-22, -5.607375272329717e-25,  1.950254905729642e+00,  7.014017452834765e-04, -7.289043192578909e-06,  6.566360546953898e-08,
 -5.356760815527673e-10,  3.997795397269207e-12, -2.703295846479524e-14,  1.597336912284039e-16, -7.304932101623530e-19,  1.442500322358190e-21,  3.289166172650067e-23,
 -1.949200510470296e-25,  1.990556586869673e+00,  1.345706630689016e-04, -1.433724742401987e-06,  1.351837457856036e-08, -1.188224674525001e-10,  9.956317526018084e-13,
 -8.041841608938142e-15,  6.299540289247120e-17, -4.789142845054703e-19,  3.589902953838515e-21, -2.416808754409503e-23,  2.248240272108600e-25,  1.693429275434880e-02,
  4.891585444098495e-04,  1.044161609209649e-05,  1.942335301735836e-07,  3.301340102928591e-09,  5.210504527004601e-11,  7.650389046306632e-13,  1.034700022273574e-14,
  1.253886381221898e-16,  1.265708963649264e-18,  7.990845299422079e-21, -5.414519985030730e-23,  1.423309516111311e-01,  3.600986455558003e-03,  5.974070191123665e-05,
  7.013667061623428e-07,  4.346984598606649e-09, -3.931143275272251e-11, -1.638712178575936e-12, -2.484233545238628e-14, -1.398190761123924e-16,  3.036057923647884e-18,
  1.007510489647958e-19,  1.433198604101357e-21,  3.519803077193540e-01,  7.126206371505064e-03,  7.324230756210469e-05,  1.178253224592737e-07, -8.487108037636238e-09,
 -1.087815298607920e-10,  3.820364311275328e-13,  2.591852591606541e-14,  2.090586361954110e-16, -3.366670955535783e-18, -8.545407957456130e-20, -1.443398843963569e-22,
  5.989804773551974e-01,  9.243255475232399e-03,  4.335895142935801e-05, -5.397469881807960e-07, -6.802997882459255e-09,  5.357744443938032e-11,  1.240187550000096e-12,
 -5.388392599214966e-15, -2.415649033973205e-16,  3.375842088480044e-19,  5.018120212697312e-20,  1.212997249215221e-22,  8.509866379530272e-01,  9.742444198312786e-03,
  3.726300541746495e-06, -6.367915174529965e-07,  7.121989595598414e-10,  7.363130964537750e-11, -2.747244551990189e-13, -9.879982119126046e-15,  7.063331808538142e-17,
  1.406045177425392e-18, -1.489361583031952e-20, -1.610957309925769e-22,  1.089841403549783e+00,  9.063801742042047e-03, -2.542606542339890e-05, -3.925521232360030e-07,
  4.157823889346109e-09,  1.482447589393743e-11, -5.588736105361748e-13,  1.885967954709222e-15,  5.962973327195542e-17, -6.471152088119583e-19, -2.808582896898738e-21,
  1.389347494926768e-22,  1.306185702799362e+00,  7.702523820942877e-03, -3.965023109441299e-05, -9.991464114362641e-08,  3.563915941866910e-09, -2.143835562398853e-11,
 -1.489350389646012e-13,  3.588628363495119e-15, -1.746392879646153e-17, -2.209118285911735e-19,  4.905602699406271e-21, -3.668377418091628e-24,  1.495410055705210e+00,
  6.044122184379902e-03, -4.153869704243996e-05,  1.011556849542697e-07,  1.562919046133227e-09, -2.320328505178516e-11,  1.193515576646747e-13,  7.338613955261836e-16,
 -1.912109229985129e-17,  1.621864989597969e-19,  4.862443226585061e-22, -9.381365226340390e-24,  1.655354382465375e+00,  4.357765427530003e-03, -3.547922593157555e-05,
  1.850083996632971e-07, -9.850789705631178e-11, -1.053284721853479e-11,  1.311917435517204e-13, -7.954439843266030e-16, -3.922934424425329e-19,  8.008608492188804e-20,
 -6.920329237028022e-22,  1.062109115708057e-23,  1.785094387015954e+00,  2.823991624440856e-03, -2.559793368989768e-05,  1.783590595700472e-07, -8.561676815271429e-10,
  5.514227559118056e-13,  4.524053349125269e-14, -6.169379627689481e-16,  5.120698628937424e-18, -1.897534273275326e-20,  6.378988297914959e-23,  5.809162615532800e-24,
  1.884308903075212e+00,  1.561436328706752e-03, -1.516783064666549e-05,  1.229165012713033e-07, -8.448964339001409e-10,  4.652647249669310e-12, -1.530790894892660e-14,
 -6.013287365805399e-17,  1.790487349418136e-18, -1.809880018575891e-20,  2.353694999562219e-22,  6.099818397708152e-25,  1.952948680486160e+00,  6.461014038960229e-04,
 -6.549976430919340e-06,  5.769865829370329e-08, -4.618592232296727e-10,  3.400090273777048e-12, -2.287810885714854e-14,  1.374356024269831e-16, -6.554642064749936e-19,
  2.751903198107515e-21,  3.695630214439955e-23,  4.052130127693213e-25,  1.991072913607620e+00,  1.237188754840902e-04, -1.282286489269764e-06,  1.176659964588048e-08,
 -1.007054667722950e-10,  8.221754801663319e-13, -6.474312946228850e-15,  4.957084198305142e-17, -3.646679189313279e-19,  2.824893752338336e-21, -1.387175549948338e-23,
  2.533580813196445e-25,  1.907413547331540e-02,  5.829988522896265e-04,  1.312725795931289e-05,  2.564966100641572e-07,  4.553046756172171e-09,  7.444010929384232e-11,
  1.118175639866792e-12,  1.514212120980305e-14,  1.755961009739336e-16,  1.474938633152437e-18,  4.107747164526850e-22, -3.415264718119989e-22,  1.577456240379685e-01,
  4.113685210316671e-03,  6.854088076533997e-05,  7.622477456928635e-07,  3.109049506346816e-09, -8.736122674934035e-11, -2.374232077682410e-12, -2.666421107716977e-14,
  5.750811644362922e-17,  8.345338903285948e-18,  1.632504212475839e-19,  1.212017332387522e-21,  3.816624934330127e-01,  7.715331117336111e-03,  7.377197030725590e-05,
 -3.461659646044699e-08, -1.050892090110149e-08, -9.028361145642286e-11,  1.178510556105773e-12,  3.001620749568968e-14,  2.776255418358987e-17, -6.578372133882690e-18,
 -6.590477074027321e-20,  1.111607249694283e-21,  6.366037295757927e-01,  9.562460442811142e-03,  3.626932203656223e-05, -6.384720905022931e-07, -5.450440721578429e-09,
  8.068313843317762e-11,  9.857017751381161e-13, -1.253415820921628e-14, -1.932098897695643e-16,  2.318091790567269e-18,  4.556287371039837e-20, -3.249678636480327e-22,
  8.899680569644270e-01,  9.741991473698088e-03, -3.799635054314970e-06, -6.140624712449960e-07,  2.097986055733775e-09,  6.401603801440012e-11, -5.129940510464581e-13,
 -6.935264321521070e-15,  1.093411039381620e-16,  7.262150413173000e-19, -1.763830418349755e-20,  3.723915504638662e-23,  1.125661579984427e+00,  8.842699547182545e-03,
 -2.973005855316829e-05, -3.243622433143815e-07,  4.325482256540997e-09,  2.238808527773937e-12, -4.829405547930824e-13,  3.411512479490815e-15,  3.576037603134694e-17,
 -6.402763452996119e-19,  3.022302501409240e-21,  1.213470847705436e-22,  1.336355125065699e+00,  7.381461771182716e-03, -4.052175884031928e-05, -4.648338754632044e-08,
  3.107190780394734e-09, -2.387617116276884e-11, -5.720517613154854e-14,  2.939998464285782e-15, -2.193678698290634e-17, -2.916810088783887e-20,  4.673010613858895e-21,
 -5.181170105506817e-24,  1.518930168093922e+00,  5.717058966928655e-03, -4.018958237382105e-05,  1.226113112196737e-07,  1.128828114922176e-09, -2.015589765508101e-11,
  1.322346676095801e-13,  2.186366799549660e-16, -1.298864412882011e-17,  1.780841044998083e-19,  4.195742219061576e-22,  5.645421552735551e-24,  1.672231779618354e+00,
  4.082770293055743e-03, -3.327500010046832e-05,  1.819105260724379e-07, -2.794795346264730e-10, -7.650435910989457e-12,  1.091446099412313e-13, -7.662123166395910e-16,
  2.117803349923267e-18,  6.311459208005537e-20, -1.265905089751551e-22,  1.462867630572706e-23,  1.795994014648700e+00,  2.627537705778820e-03, -2.353927730040159e-05,
  1.648020500349544e-07, -8.355875914338936e-10,  1.447820020557824e-12,  3.016415765164644e-14, -4.629920394711339e-16,  4.548336512532142e-18, -1.095451257102910e-20,
  3.460407480179137e-22,  6.943030752089053e-24,  1.890320989471167e+00,  1.445770803705811e-03, -1.377093790177241e-05,  1.101221573338701e-07, -7.556226203147356e-10,
  4.270991912417173e-12, -1.627405099928510e-14, -1.136577856219613e-17,  1.318946271245809e-18, -7.701026422707636e-21,  2.950515495381992e-22,  2.018314704830514e-24,
  1.955432500800282e+00,  5.963504829788968e-04, -5.899780119276012e-06,  5.082435913768405e-08, -3.990482802359850e-10,  2.894926685782085e-12, -1.930637272329235e-14,
  1.183777661706043e-16, -5.237118860174258e-19,  4.780159941939685e-21,  6.890776579939672e-23,  1.002090559723534e-24,  1.991548129697694e+00,  1.139991855729645e-04,
 -1.150238495124711e-06,  1.027886711107112e-08, -8.570979391735176e-11,  6.822198312238666e-13, -5.235044248616163e-15,  3.944439078938296e-17, -2.701098749926603e-19,
  2.510844318116284e-21, -1.410787784722658e-24,  3.081985439493157e-25,  2.163757116363522e-02,  7.016905683572913e-04,  1.669658615185093e-05,  3.428700757796417e-07,
  6.348040723386318e-09,  1.070473044895148e-10,  1.628609108671798e-12,  2.157460327127103e-14,  2.238045416755698e-16,  1.009921523323851e-18, -2.937267396760194e-20,
 -1.135485437474289e-21,  1.753559417629753e-01,  4.699291674841500e-03,  7.791795940278640e-05,  7.946726562746426e-07,  7.339588446772627e-10, -1.527691751816440e-10,
 -3.040419600002781e-12, -1.867519580785829e-14,  4.846766014611431e-16,  1.550671207357731e-17,  1.796125324239855e-19, -8.968623514716493e-22,  4.136973365155936e-01,
  8.300861025724323e-03,  7.229388428239355e-05, -2.153833296682074e-07, -1.196414086127405e-08, -5.204770723319735e-11,  1.992848690347292e-12,  2.672709037497455e-14,
 -2.409881884554679e-16, -7.831977015942252e-18,  1.232887053812942e-20,  2.337963608624386e-21,  6.753834350812905e-01,  9.820616188447732e-03,  2.814147521260931e-05,
 -7.116152747771634e-07, -3.631877285732554e-09,  9.951872521112157e-11,  5.630458872386991e-13, -1.706446191976537e-14, -8.138426895846145e-17,  3.749362751972864e-18,
  2.377244927838132e-20, -6.301970839266750e-22,  9.288294880264463e-01,  9.682782707176658e-03, -1.092705704549603e-05, -5.709797203446695e-07,  3.241587636549218e-09,
  4.978873545869700e-11, -6.552032484991171e-13, -3.147924029310139e-15,  1.236410596214873e-16,  1.024824492282953e-19, -1.255407356841940e-20,  1.714098355325326e-22,
  1.160533706230401e+00,  8.590465703541564e-03, -3.320762773796173e-05, -2.553915309001669e-07,  4.262671751693002e-09, -8.096404513249178e-12, -3.746391563151528e-13,
  4.220143052128285e-15,  1.606672279752995e-17, -4.248937183174698e-19,  7.362447569185762e-21,  6.790551687979839e-23,  1.365230236136974e+00,  7.055865010483086e-03,
 -4.079719604554861e-05, -6.365561781440746e-10,  2.622196621994258e-09, -2.434027059399295e-11,  1.538390888182143e-14,  2.256854719344113e-15, -1.967773299236771e-17,
  1.529027110553751e-19,  4.388571827384651e-21, -1.168174240762365e-23,  1.541165083600923e+00,  5.401705182620772e-03, -3.862261965223824e-05,  1.376213649898005e-07,
  7.577252257361343e-10, -1.694971587702275e-11,  1.335280943299042e-13, -9.053976934971002e-17, -6.193090093417889e-18,  2.020297290300959e-19,  7.929257650651565e-22,
  7.304555377000535e-24,  1.688044164458746e+00,  3.825215239519008e-03, -3.112351162438482e-05,  1.763499785715479e-07, -4.079828554255969e-10, -5.278658691555533e-12,
  8.898139870601053e-14, -6.617992696104308e-16,  4.454134961407967e-18,  7.078202103398357e-20,  4.833433913295835e-22,  1.071009773143240e-23,  1.806139744323253e+00,
  2.446909141495497e-03, -2.164079747325739e-05,  1.516995184374968e-07, -8.003580106758503e-10,  2.032387136724380e-12,  1.920123835805196e-14, -3.204918862078599e-16,
  4.475372876460903e-18,  8.756383447939827e-21,  6.210207088144175e-22,  4.242482154486150e-24,  1.895891825189573e+00,  1.340689988527334e-03, -1.251926176681352e-05,
  9.869430790982959e-08, -6.741104594440151e-10,  3.881194857319160e-12, -1.602579047089008e-14,  2.886451698578623e-17,  1.276535643823322e-18,  5.935582142354918e-21,
  3.812920686077254e-22,  1.181521550371336e-24,  1.957727221269106e+00,  5.514875123203745e-04, -5.326364340953238e-06,  4.487869453988185e-08, -3.455238312014266e-10,
  2.469635165023738e-12, -1.619623728412758e-14,  1.049938451845964e-16, -2.910010613151975e-19,  8.440250100509490e-21,  1.118223680569619e-22,  6.571706686669085e-25,
  1.991986472218896e+00,  1.052683445888518e-04, -1.034691091683610e-06,  9.010198093028913e-09, -7.323704072780529e-11,  5.689391550495779e-13, -4.237946228968246e-15,
  3.226259482584112e-17, -1.775112660049140e-19,  2.717180342896415e-21,  1.101806330686223e-23,  2.045800612973643e-25,  2.474020780725978e-02,  8.536252777924672e-04,
  2.149856642136573e-05,  4.639102809070796e-07,  8.933070590375226e-09,  1.542148820463555e-10,  2.336123344288836e-12,  2.896822975139364e-14,  2.230003471092878e-16,
 -1.620763713284959e-18, -1.161619664982427e-19, -3.075782949909355e-21,  1.954601332826724e-01,  5.360720576578134e-03,  8.741042641935412e-05,  7.778690348814796e-07,
 -3.082063525495414e-09, -2.296993267661943e-10, -3.253174904936999e-12,  7.004138990199459e-15,  1.151573777620343e-15,  2.063277772536841e-17,  3.978836240952767e-20,
 -5.944357178869592e-21,  4.480364378191193e-01,  8.865558412917774e-03,  6.853544345727835e-05, -4.123030400034481e-07, -1.247177440849483e-08,  3.637593452709867e-12,
  2.592747689771045e-12,  1.480929398755596e-14, -4.881083094323756e-16, -5.180573752626589e-18,  1.191901505592535e-19,  2.175955922000039e-21,  7.150608904787707e-01,
  1.001075780260482e-02,  1.932103932906790e-05, -7.532342010639212e-07, -1.546046227583419e-09,  1.071337630485889e-10,  7.005195911848839e-14, -1.738277047999782e-14,
  6.359281822387991e-17,  4.100025979439946e-18, -7.148523891377780e-21, -7.589903353910802e-22,  9.673437288951546e-01,  9.568910948010236e-03, -1.743759077804998e-05,
 -5.120244175742741e-07,  4.075287726236164e-09,  3.345355782922897e-11, -6.880031345939252e-13,  7.857080835844530e-16,  1.201273648495903e-16, -2.503497381341125e-19,
 -5.582422794189340e-21,  1.020451072645787e-22,  1.194346454134609e+00,  8.313690057534193e-03, -3.586992378577834e-05, -1.889316761604685e-07,  4.020649606987540e-09,
 -1.562366593287203e-11, -2.511458422884838e-13,  4.550532897363873e-15,  6.527144327657003e-18, -1.009912579446395e-19,  7.909090134145363e-21, -5.969747086028731e-23,
  1.392801851097863e+00,  6.730133359755336e-03, -4.056904765165190e-05,  3.746448896719530e-08,  2.143860043776625e-09, -2.327764549646087e-11,  7.082077228690474e-14,
  1.747545524132669e-15, -1.122905012856127e-17,  3.071669138062604e-19,  2.929700409159528e-21, -6.657395465948649e-23,  1.562164660058170e+00,  5.099511514255991e-03,
 -3.690904757317788e-05,  1.472059581580181e-07,  4.504859178007414e-10, -1.379090854149412e-11,  1.293574645310357e-13, -1.659588800971074e-16,  1.669721977372522e-18,
  2.330503334286331e-19,  4.917358630222507e-22, -2.964336247015533e-23,  1.702860285498354e+00,  3.584573674454731e-03, -2.904960274139314e-05,  1.690877202871675e-07,
 -4.936076797449628e-10, -3.346858048017155e-12,  7.286005321252362e-14, -4.741454275528738e-16,  7.415514004445103e-18,  9.381379267718301e-20,  4.717827910363481e-22,
 -1.649946658509037e-23,  1.815592354216366e+00,  2.280849879169922e-03, -1.989582276361015e-05,  1.392412561550549e-07, -7.557433301135188e-10,  2.402183126735542e-12,
  1.231526509728805e-14, -1.672565207546497e-16,  5.254007216146400e-18,  3.393493294503943e-20,  5.220793685180481e-22, -1.180218900178309e-23,  1.901061526473364e+00,
  1.245095628486749e-03, -1.139714982197142e-05,  8.850899551384835e-08, -6.002422063911294e-10,  3.511194032877276e-12, -1.459240309880305e-14,  7.609201753545396e-17,
  1.763489266906470e-18,  2.058513192684397e-20,  2.937706255270757e-22, -6.773402779129625e-24,  1.959851232370844e+00,  5.109404139784921e-04, -4.819426053967941e-06,
  3.972531948950666e-08, -2.997842304362260e-10,  2.115463565176820e-12, -1.333478076988220e-14,  1.014286432160135e-16,  9.477573504699796e-20,  1.283074359551478e-20,
  8.467477459074202e-23, -2.532632175092163e-24,  1.992391648288551e+00,  9.740421525448438e-05, -9.332410577131783e-07,  7.924206206084137e-09, -6.280511480989831e-11,
  4.775205360842688e-13, -3.398738095637683e-15,  2.824298990794037e-17, -7.071015327773106e-20,  3.205587949664126e-21,  8.896263613764514e-24, -4.194109382385186e-25,
  2.853770917475007e-02,  1.050566920654803e-03,  2.803550036879075e-05,  6.348493174521421e-07,  1.264753556120663e-08,  2.207279738519704e-10,  3.230161091302710e-12,
  3.395155124764032e-14,  3.941072255143100e-17, -9.999538423760660e-18, -3.331754628070768e-19, -7.270612575012350e-21,  2.183590227119544e-01,  6.096127342336648e-03,
  9.628401549484472e-05,  6.877123651737166e-07, -8.416500616893720e-09, -3.005755315086536e-10, -2.430830792813645e-12,  5.541874830556146e-14,  1.842328192295357e-15,
  1.505634105039451e-17, -3.656977266504854e-19, -1.229026572304706e-20,  4.845591500255107e-01,  9.390687151307826e-03,  6.240417388856595e-05, -6.077810931059115e-07,
 -1.175289541824989e-08,  6.893914038292399e-11,  2.768199143781590e-12, -2.716947475443835e-15, -5.705103623707679e-16,  9.420787379386907e-19,  1.689390909213522e-19,
 -2.784106114704777e-22,  7.553554333063124e-01,  1.012891298901086e-02,  1.020437420807331e-05, -7.608978235552116e-07,  5.757720459473313e-10,  1.033371077611135e-10,
 -3.667681511376395e-13, -1.310869745387641e-14,  1.976849780852577e-16,  3.110163914261989e-18, -4.345338247539569e-20, -9.131450904926919e-22,  1.005303082070619e+00,
  9.405986617111754e-03, -2.317144395450103e-05, -4.423492264185617e-07,  4.583224575957242e-09,  1.763012964477579e-11, -6.138193175355825e-13,  4.446729637642713e-15,
  1.074637695851109e-16, -4.661207589288014e-19, -7.722352952624858e-21, -2.412250933012492e-22,  1.227014446980366e+00,  8.018729904518962e-03, -3.776237465962728e-05,
 -1.273848404952682e-07,  3.658336972206876e-09, -2.009995306666207e-11, -1.209650926944025e-13,  4.753581580641165e-15,  7.400312924755136e-18,  1.005300596912591e-19,
  4.264831816661737e-22, -2.976036059222954e-22,  1.419076904523006e+00,  6.407927702021357e-03, -3.992868332127185e-05,  6.815022023277069e-08,  1.699103450289221e-09,
 -2.102052619505282e-11,  1.165025506711502e-13,  1.580099675528510e-15,  9.312591289646860e-19,  3.314908970592934e-19, -2.711064046674466e-21, -2.028440415719144e-22,
  1.581983495728324e+00,  4.811407678511914e-03, -3.510788885818102e-05,  1.523744982622319e-07,  2.054014658794308e-10, -1.072825296296391e-11,  1.267257842385530e-13,
  2.162476736772393e-17,  9.892103256612638e-18,  2.030660050166900e-19, -2.675098111988290e-21, -1.230728390147403e-22,  1.716746441719335e+00,  3.360154311545751e-03,
 -2.706984868370854e-05,  1.607455190514214e-07, -5.439816517140363e-10, -1.727515520995004e-12,  6.342727074943985e-14, -1.814833675534195e-16,  1.081865050798703e-17,
  8.241378889297129e-20, -1.493060764508389e-21, -7.814168049885911e-23,  1.824407717636336e+00,  2.128165064360871e-03, -1.829584508283735e-05,  1.275485364117679e-07,
 -7.050199482124247e-10,  2.661788120602693e-12,  1.018984854409694e-14,  2.290873233538081e-17,  6.644916062238331e-18,  3.519011212141698e-20, -7.239826846593222e-22,
 -4.795321882210894e-23,  1.905866057666491e+00,  1.158008813298489e-03, -1.039040710191385e-05,  7.944873130430535e-08, -5.333118290409836e-10,  3.193666649860082e-12,
 -1.154887526432862e-14,  1.457987638004389e-16,  2.602725804959402e-18,  2.166324215877125e-20, -3.752474276471798e-22, -2.526328780946051e-23,  1.961820791320009e+00,
  4.742133869424392e-04, -4.370158960883770e-06,  3.525083482528693e-08, -2.604416218527234e-10,  1.830294421341216e-12, -1.037999652963744e-14,  1.121811949409034e-16,
  5.742288956211060e-19,  1.210961301426134e-20, -1.746687006009143e-22, -9.899114966040729e-24,  1.992766912337444e+00,  9.030226405753627e-05, -8.438783403837420e-07,
  6.991561353779515e-09, -5.400721006543604e-11,  4.052926057499588e-13, -2.622081551986511e-15,  2.783897028028912e-17,  4.349425276834732e-20,  2.834724038432853e-21,
 -3.766542324569921e-23, -1.816144416642286e-24,  3.324212882424832e-02,  1.309128290109498e-03,  3.702805820006396e-05,  8.770589762017539e-07,  1.791327012266241e-08,
  3.093599604730215e-10,  4.121835180871888e-12,  2.614276577877691e-14, -6.549377366504532e-16, -3.168237397386376e-17, -8.054602473215034e-19, -1.472475970549794e-20,
  2.443324860322299e-01,  6.896646027600884e-03,  1.035216738018397e-04,  5.024391142004955e-07, -1.484962214121202e-08, -3.332605387677337e-10,  1.143375386083859e-15,
  1.190979482132528e-13,  1.981314599681671e-15, -1.128609845314158e-17, -9.552176184765729e-19, -1.262772602724888e-20,  5.230698283015850e-01,  9.857678225680835e-03,
  5.403955727426737e-05, -7.812495594129041e-07, -9.726271052794832e-09,  1.324762667811998e-10,  2.450482928959312e-12, -1.921393452283473e-14, -4.276182401844140e-16,
  6.383892535333420e-18,  7.645560937010595e-20, -3.886676718380711e-21,  7.959769505966025e-01,  1.017433489914846e-02,  1.195220303640922e-06, -7.357405422130690e-07,
  2.528842497385125e-09,  9.093441708817407e-11, -6.312844950360169e-13, -5.409676934644567e-15,  2.680225552194871e-16,  4.956813733605698e-19, -8.906817823429837e-20,
 -1.151331809072613e-21,  1.042524455922068e+00,  9.200650775008619e-03, -2.803046998656166e-05, -3.669481334019511e-07,  4.800528338812503e-09,  4.762852576590313e-12,
 -4.442758713741313e-13,  7.528382909707137e-15,  8.129621990745123e-17, -1.126863256509326e-18, -2.873663700741473e-20, -7.030161870778670e-22,  1.258476850862588e+00,
  7.711480152575190e-03, -3.895344442753117e-05, -7.217940604246776e-08,  3.238238013453691e-09, -2.137641790850288e-11,  1.584494245784058e-14,  5.020936598165174e-15,
  7.405325704696414e-18, -2.279625705431086e-19, -1.883917759749308e-20, -5.658791007525733e-22,  1.444075547480481e+00,  6.092200713356326e-03, -3.896110665417043e-05,
  9.213974377174000e-08,  1.310297116838512e-09, -1.768039466546803e-11,  1.626911174828533e-13,  1.759372263962820e-15,  8.293658123119205e-18, -6.758698575633246e-21,
 -1.543264496081262e-20, -3.687543913469447e-22,  1.600679039414344e+00,  4.537899183345917e-03, -3.326621941410145e-05,  1.541105779953692e-07,  2.150952078934167e-11,
 -7.638082909186386e-12,  1.326430371764968e-13,  4.217955870868877e-16,  1.365220842974467e-17, -4.719716265733037e-20, -1.067683702700120e-20, -2.361611120213829e-22,
  1.729765946365093e+00,  3.151161249899973e-03, -2.519399989790804e-05,  1.518471249747857e-07, -5.635093195033062e-10, -2.249814408931018e-13,  6.351071689207963e-14,
  1.925752149693222e-16,  1.167567325374179e-17, -6.864915399041063e-20, -6.600072438726232e-21, -1.509747033083844e-22,  1.832637072779991e+00,  1.987733003148458e-03,
 -1.683114307524664e-05,  1.167080534069534e-07, -6.491586173410790e-10,  2.938923715967681e-12,  1.393100621133653e-14,  2.453044735874836e-16,  6.761186531474173e-18,
 -4.918940117006867e-20, -3.810956177789028e-21, -9.056607036306061e-23,  1.910337686004002e+00,  1.078558798905902e-03, -9.486157006994469e-06,  7.141323403251586e-08,
 -4.718284294555949e-10,  2.975449148282344e-12, -6.218500541669714e-15,  2.360845566427157e-16,  2.782475676540522e-18, -2.237019621481122e-20, -1.988764778178780e-21,
 -4.715464279892325e-23,  1.963650304942067e+00,  4.408760147838488e-04, -3.970984171528458e-06,  3.136419028792011e-08, -2.260603173722948e-10,  1.621274310449681e-12,
 -6.931477474346788e-15,  1.351688971253572e-16,  7.547670380518128e-19, -6.288900784331392e-21, -8.097892770012417e-22, -1.860178930655084e-23,  1.993115130745968e+00,
  8.387273747985840e-05, -7.649071455338450e-07,  6.189142542974556e-09, -4.646635775494654e-11,  3.519532806634531e-13, -1.810892329106817e-15,  3.038588768892454e-17,
  9.451381472670989e-20, -7.792496383662411e-22, -1.551927746479701e-22, -3.456200540675641e-24,  3.914529127676126e-02,  1.652830151584185e-03,  4.949457114379965e-05,
  1.218734089196761e-06,  2.513137076214478e-08,  4.133892525286651e-10,  4.336514365238794e-12, -2.070564288680331e-14, -2.555153620847959e-15, -7.941419811421712e-17,
 -1.638159689395757e-18, -2.225627094944081e-20,  2.736072396563030e-01,  7.744396979298972e-03,  1.079088244981023e-04,  2.127800820936299e-07, -2.121004946722637e-08,
 -2.867149000869148e-10,  4.104342036514903e-12,  1.677031174550198e-13,  7.799661162202660e-16, -5.742665579079620e-17, -1.240369936324184e-18,  2.642838924446892e-21,
  5.633023546699389e-01,  1.025007027248925e-02,  4.382806517267125e-05, -9.126861447475304e-07, -6.539249755189656e-09,  1.835099640110633e-10,  1.757499972051171e-12,
 -2.901254118028144e-14, -1.909452635959126e-16,  5.303533702785920e-18, -1.417183428111613e-19, -5.379972354873619e-21,  8.366386437803212e-01,  1.014940164785612e-02,
 -7.333645959111208e-06, -6.815868640099339e-07,  4.188734659291290e-09,  7.492452916096914e-11, -6.654819856046600e-13,  2.664668647157334e-15,  2.094033254539821e-16,
 -4.084005031678357e-18, -1.386245176614705e-19, -9.589471835189138e-22,  1.078852532107646e+00,  8.960103099411436e-03, -3.197152267408412e-05, -2.898805707999392e-07,
  4.807559728566198e-09, -3.123283846916272e-12, -2.051185924860626e-13,  9.193045088001813e-15,  1.180887267389695e-17, -2.972035746466826e-18, -6.432938675079696e-20,
 -8.038369289487174e-22,  1.288695231832411e+00,  7.397236667232267e-03, -3.952263652692160e-05, -2.371903989824391e-08,  2.825983156262090e-09, -1.929636921801290e-11,
  1.571821825893749e-13,  4.929771688872317e-15, -2.074523367672230e-17, -1.515822164499663e-18, -4.573177459329220e-20, -5.841331722602825e-22,  1.467828444810604e+00,
  5.785265557949191e-03, -3.774057609813588e-05,  1.105050213320635e-07,  9.998612418276182e-10, -1.315997248930974e-11,  2.145906785495137e-13,  1.868330246305127e-15,
 -7.206188379265242e-18, -9.709233283233629e-19, -3.286303266425186e-20, -3.766047422936516e-22,  1.618310083437936e+00,  4.279162123605177e-03, -3.141929541500752e-05,
  1.534104540499142e-07, -9.822512823264352e-11, -4.268603550775426e-12,  1.496027302734379e-13,  7.275713456717060e-16,  1.597900719797275e-18, -6.977989445887099e-19,
 -2.193426514551043e-20, -2.445496414709445e-22,  1.741978811601748e+00,  2.956744846294604e-03, -2.342580477852470e-05,  1.428803399147092e-07, -5.521288259554144e-10,
  1.401758489840335e-12,  7.331963954523587e-14,  4.619645529346356e-16,  2.746199651094593e-18, -4.756109617498401e-19, -1.380204476737094e-20, -1.566662337791839e-22,
  1.840327333092941e+00,  1.858513872425257e-03, -1.549095975726508e-05,  1.068126516401354e-07, -5.863654195177670e-10,  3.377248905544330e-12,  2.330520374232394e-14,
  3.956820407798377e-16,  1.225138237310254e-18, -2.871720065097280e-19, -8.117345645823272e-21, -9.355404520395500e-23,  1.914505394822039e+00,  1.005973522591815e-03,
 -8.672549654787442e-06,  6.433435489637959e-08, -4.132299416222858e-10,  2.914193034054681e-12,  1.383241014949724e-15,  2.926055974438081e-16,  1.400215921123607e-20,
 -1.464047949328722e-19, -4.227234452873569e-21, -4.858737498843931e-23,  1.965352573308826e+00,  4.105545463236932e-04, -3.615271292733218e-06,  2.799892116336502e-08,
 -1.949795522692068e-10,  1.502590736782321e-12, -2.896945390732839e-15,  1.477584279244096e-16, -2.643576647666292e-19, -5.624015781746696e-20, -1.693574119028619e-21,
 -1.918969645197835e-23,  1.993438836401077e+00,  7.803844139396722e-05, -6.948727618950774e-07,  5.499926549396110e-09, -3.979151554420921e-11,  3.189668325336201e-13,
 -9.323128843120045e-16,  3.144930569288275e-17, -8.427465129436995e-20, -1.025355454136487e-20, -3.196636450915681e-22, -3.573904985873224e-24,  4.665167181931256e-02,
  2.114784994463170e-03,  6.682212389457478e-05,  1.692231124701878e-06,  3.433219879756212e-08,  4.981279295507726e-10,  2.081057219935682e-12, -1.627516845661208e-13,
 -6.823198010139082e-15, -1.633188448169777e-16, -2.454567145671573e-18, -7.010873665679474e-21,  3.063188744163710e-01,  8.611718888434042e-03,  1.082585500932874e-04,
 -1.654834817040108e-07, -2.557368938857207e-08, -1.312807375182752e-10,  8.773932167250852e-12,  1.506916788161141e-13, -2.082499170370585e-15, -9.694642480312310e-17,
 -5.355328068533424e-19,  2.961394039939757e-20,  6.049323943693311e-01,  1.055539959240260e-02,  3.237582312637300e-05, -9.859476007971993e-07, -2.516048752081468e-09,
  2.153776011600842e-10,  8.779590495156776e-13, -3.359597391648333e-14, -1.542351595331563e-16, -4.489185398913061e-18, -3.232831259151818e-19, -2.013287157014474e-21,
  8.770688631665370e-01,  1.005926406789148e-02, -1.506383308133999e-05, -6.034101124704678e-07,  5.536744783830380e-09,  6.042962751438360e-11, -5.271899523547673e-13,
  5.877133563572769e-15, -4.494172728398155e-17, -1.015981259313890e-17, -1.546858928409689e-19,  4.847595726496256e-22,  1.114161207401672e+00,  8.691718254359816e-03,
 -3.499125373820819e-05, -2.136399822772030e-07,  4.716446790095667e-09, -5.032757490613691e-12,  3.758931764333468e-14,  7.301427837057481e-15, -1.486889985332836e-16,
 -6.090421621006452e-18, -8.559244932097772e-20,  2.323021572200519e-23,  1.317651062129419e+00,  7.080657954555544e-03, -3.954791898133452e-05,  1.865904005996657e-08,
  2.488308882719930e-09, -1.400679272025900e-11,  2.749388909996562e-13,  2.995616782809938e-15, -1.134456152814344e-16, -3.740415648377657e-18, -6.127285051514922e-20,
 -1.223734098108488e-24,  1.490374416174088e+00,  5.488899051973215e-03, -3.632626193692821e-05,  1.246938409676817e-07,  7.920937867764096e-10, -7.450194646193800e-12,
  2.564436215160563e-13,  7.964464105274800e-16, -6.915513786547732e-17, -2.537852570747203e-18, -4.267237395231239e-20,  1.151922454250215e-23,  1.634935637765057e+00,
  4.035139557585400e-03, -2.958996653530438e-05,  1.513576272812963e-07, -1.461346478248717e-10, -4.576376298251818e-13,  1.655973483785010e-13,  1.890314037435652e-16,
 -4.148185868725539e-17, -1.739110902109045e-18, -2.829475796379434e-20,  9.150126699716859e-24,  1.753441628616949e+00,  2.776049258912596e-03, -2.176299827972133e-05,
  1.343705029528874e-07, -5.054798894302478e-10,  3.306644732753522e-12,  8.408104033020701e-14,  1.575275102577607e-16, -2.570407139498972e-17, -1.133063305606838e-18,
 -1.790440207939767e-20,  4.472338085190223e-24,  1.847521432863059e+00,  1.739559059640201e-03, -1.426316142222572e-05,  9.800525553093148e-08, -5.123561798128040e-10,
  4.061977739433777e-12,  3.289024244319894e-14,  1.997501396066580e-16, -1.578906911334964e-17, -6.749152341547846e-19, -1.057864211972989e-20,  1.969748251365038e-24,
  1.918395264719980e+00,  9.395732307160044e-04, -7.938270807448353e-06,  5.819346239075024e-08, -3.539754355373984e-10,  3.039625448881273e-12,  8.535664331539136e-15,
  1.724236758240924e-16, -8.732093437643127e-18, -3.482477292449114e-19, -5.506401492047433e-21,  9.680481201848203e-25,  1.966939003187891e+00,  3.829255559700587e-04,
 -3.297019062632314e-06,  2.511724584098714e-08, -1.653025914625713e-10,  1.479379344198872e-12,  7.156653344162722e-16,  9.238251125478014e-17, -3.678896653930654e-18,
 -1.369105043962327e-19, -2.197925167750615e-21,  4.429081788845270e-25,  1.993740275547963e+00,  7.273311085813609e-05, -6.324862553012605e-07,  4.913369882272235e-09,
 -3.356797324643521e-11,  3.064172835820414e-13, -1.641765632501408e-16,  2.010910588533282e-17, -7.153056141287905e-19, -2.544597192992016e-20, -4.134181548840029e-22,
  9.507899070663519e-26,  5.632276753691350e-02,  2.740692465465326e-03,  9.075687597050544e-05,  2.321890969907162e-06,  4.427206591900710e-08,  4.626107992421143e-10,
 -6.549822874972866e-12, -4.935639280564026e-13, -1.435753714770340e-14, -2.451699128807623e-16, -8.104935008938446e-19,  1.091622156700988e-19,  3.424753281375022e-01,
  9.462769250139745e-03,  1.037715915644970e-04, -5.829693185312097e-07, -2.580470795195942e-08,  1.190933361876895e-10,  1.152282087648887e-11,  2.699562103175462e-14,
 -5.589969085749803e-15, -8.675630566663444e-17,  1.128830949813922e-18,  4.073154628668347e-20,  6.475965467194010e-01,  1.076672950131003e-02,  2.044786491799571e-05,
 -9.909317823952686e-07,  1.922168986386814e-09,  2.243618888646214e-10, -1.743599874987468e-13, -4.367142595200630e-14, -5.522051913811674e-16, -1.719675783381465e-17,
 -2.572368385875293e-19,  5.477907003358015e-21,  9.170212808306151e-01,  9.911383348712988e-03, -2.173543465679796e-05, -5.057926184500544e-07,  6.629717248886363e-09,
  4.921045953889180e-11, -4.458059765699360e-13, -2.521084369426478e-15, -5.100329721472986e-16, -1.513985299534084e-17, -7.196009938008986e-20,  3.563324621793288e-21,
  1.148353785514412e+00,  8.402809343584790e-03, -3.710515696111229e-05, -1.388760445952849e-07,  4.637649916693801e-09, -2.440647790660837e-12,  1.378938106866778e-13,
 -1.594933402369703e-15, -4.248768484635655e-16, -8.987122867574961e-18, -4.435658719422705e-20,  2.075955322861800e-21,  1.345343275836054e+00,  6.765828201169075e-03,
 -3.909315964219171e-05,  5.660879643484848e-08,  2.278243779510767e-09, -6.952936601259144e-12,  2.844707258046454e-13, -3.242723499937584e-15, -2.891862275994516e-16,
 -5.845568958399050e-18, -3.376072375017151e-20,  1.410207760552231e-21,  1.511758560912862e+00,  5.204480573911529e-03, -3.475772145517048e-05,  1.365116010810709e-07,
  7.047499622733817e-10, -1.373944291200998e-12,  2.317481228438249e-13, -3.193654776179794e-15, -1.890755235970159e-16, -4.001341675738277e-18, -2.358043177974737e-20,
  9.677991110654029e-22,  1.650614204439532e+00,  3.805645945286426e-03, -2.778730984054414e-05,  1.491604744083648e-07, -1.161639433509579e-10,  3.364730284368402e-12,
  1.413833607364145e-13, -2.349094834553691e-15, -1.230118341547447e-16, -2.708262406338452e-18, -1.555235131064469e-20,  6.464413095257511e-22,  1.764207643256769e+00,
  2.608263303550283e-03, -2.019654184771544e-05,  1.269208265345388e-07, -4.194682499657204e-10,  5.242049630823650e-12,  6.988772661635425e-14, -1.449951224938234e-15,
 -7.847405410774817e-17, -1.746535042583987e-18, -9.814685509314516e-21,  4.130006706607279e-22,  1.854258718670001e+00,  1.630025116682214e-03, -1.313346267678962e-05,
  9.050092065370027e-08, -4.231707184522527e-10,  4.836059140835133e-12,  2.719168650031632e-14, -7.724644226808013e-16, -4.716873840850736e-17, -1.037662127773544e-18,
 -5.800636889415325e-21,  2.451200748386838e-22,  1.922030838275539e+00,  8.787687669588813e-04, -7.271885929051241e-06,  5.302823633971265e-08, -2.909610931285178e-10,
  3.257769165187880e-12,  7.272475455043006e-15, -3.483140717655923e-16, -2.495683085570878e-17, -5.371649876599765e-19, -3.024629019446666e-21,  1.275152003150003e-22,
  1.968419801517481e+00,  3.577123268577558e-04, -3.010500060224097e-06,  2.271061425431759e-08, -1.354239696740272e-10,  1.509145168616685e-12,  7.957846251101430e-16,
 -1.204553369775517e-16, -1.007968083671050e-17, -2.123325519219660e-19, -1.209565244593308e-21,  5.074612446866783e-23,  1.994021449350514e+00,  6.790039716508348e-05,
 -5.765464150533003e-07,  4.425227949391863e-09, -2.745079035242202e-11,  3.056890891323003e-13, -8.138769558821740e-17, -2.049420545042034e-17, -1.908206956596137e-18,
 -3.963261136937649e-20, -2.277935025396983e-22,  9.519604887735422e-24,  6.893193539283313e-02,  3.590860435322234e-03,  1.231320275895795e-04,  3.089983744053397e-06,
  5.053016900316849e-08,  7.959549880909804e-11, -2.809686922301446e-11, -1.086509129375316e-12, -2.189014448567956e-14, -9.852073527134045e-17,  1.070318118080978e-17,
  4.599575157977262e-19,  3.819328972229681e-01,  1.025821889971353e-02,  9.442573532883780e-05, -9.619038512630439e-07, -2.071144589464313e-08,  3.820069973076059e-10,
  9.386262663270742e-12, -1.898581085257538e-13, -7.504978300937378e-15, -1.015891322935035e-17,  2.547875061507209e-18,  2.063317956386526e-20,  6.909165028990871e-01,
  1.088360784066934e-02,  8.887314456472649e-06, -9.249661290078294e-07,  6.255554106609484e-09,  2.028784570404978e-10, -1.748258222248512e-12, -7.260070002868589e-14,
 -1.273658739457073e-15, -1.990035333360264e-17,  1.972176171765290e-19,  1.592109652561371e-20,  9.562832463712381e-01,  9.715095855151406e-03, -2.713805719551360e-05,
 -3.924885563937588e-07,  7.489502869354738e-09,  3.530530124497198e-11, -8.286280138383906e-13, -2.773212298445229e-14, -1.056729931202700e-15, -1.347427166364340e-17,
  1.970571931677409e-19,  9.389069673620831e-21,  1.181362562994789e+00,  8.100560735777328e-03, -3.832760001463784e-05, -6.493106768144160e-08,  4.609078046270818e-09,
 -1.509211612620870e-12, -1.468837699104185e-13, -2.047543062473916e-14, -7.496183949414728e-16, -7.939124049290495e-18,  1.265750529678736e-19,  6.223949143057651e-21,
  1.371786264014662e+00,  6.456411431608631e-03, -3.819866522052623e-05,  9.226693955054267e-08,  2.193851842913918e-09, -2.460951662627014e-12,  3.151619542719877e-14,
 -1.596395255277844e-14, -5.028880346441287e-16, -5.258610586052413e-18,  8.405717499328848e-20,  4.322759423779039e-21,  1.532031004640161e+00,  4.933162719116150e-03,
 -3.305197064148976e-05,  1.478255158806216e-07,  7.215334936266978e-10,  2.294181067390355e-12,  3.527919493126077e-14, -1.162068021736512e-14, -3.356364889609449e-16,
 -3.612012368914595e-18,  5.757019613865994e-20,  2.986356618673831e-21,  1.665403490925259e+00,  3.590481737297081e-03, -2.600580090864973e-05,  1.479930232010070e-07,
 -2.295646759237371e-11,  5.431146667199060e-12,  5.396142429850817e-15, -7.891708417150912e-15, -2.220159605521627e-16, -2.436756970098467e-18,  3.895920011758226e-20,
  2.012557597859377e-21,  1.774327047848011e+00,  2.452677541172513e-03, -1.871005759035102e-05,  1.211195250545544e-07, -3.028621740211772e-10,  6.088693514983846e-12,
 -1.559729358220405e-14, -4.995628172217919e-15, -1.422045611396711e-16, -1.565858123339947e-18,  2.521006434939186e-20,  1.296775694119590e-21,  1.860575409226789e+00,
  1.529193887657786e-03, -1.208479782868018e-05,  8.452854130638097e-08, -3.227072277086930e-10,  5.023079376176032e-12, -2.134799933788778e-14, -2.896233104891087e-15,
 -8.500619707272130e-17, -9.284625823710982e-19,  1.506949181706555e-20,  7.741928988343007e-22,  1.925433488162726e+00,  8.230648830046483e-04, -6.661311991215784e-06,
  4.889841123565336e-08, -2.253944852457384e-10,  3.206665289848090e-12, -1.665336911213786e-14, -1.465055287789977e-15, -4.454817091921734e-17, -4.803739040492643e-19,
  7.854913154283248e-21,  4.040107170213626e-22,  1.969804159850161e+00,  3.346838925048348e-04, -2.749978906991418e-06,  2.078443648732893e-08, -1.055424039454803e-10,
  1.444060230561758e-12, -8.276048591670028e-15, -5.688207444009855e-16, -1.782842984584714e-17, -1.899295778939697e-19,  3.123434843301940e-21,  1.609802825386169e-22,
  1.994284152582636e+00,  6.349343259627061e-05, -5.258784141836134e-07,  4.034482875303629e-09, -2.144442692263962e-11,  2.885936238473648e-13, -1.731066350716354e-15,
 -1.050508722980359e-16, -3.355268333849759e-18, -3.546431118426568e-20,  5.851787505327409e-22,  3.020831582629481e-23,  8.551952204920425e-02,  4.737805860901424e-03,
  1.649648736928103e-04,  3.862791617471020e-06,  4.250601856128948e-08, -1.038134814041085e-09, -6.799839089912344e-11, -1.712941197156287e-12, -1.155655796308129e-14,
  8.742785528955897e-16,  4.090449632634658e-17,  8.398152320430225e-19,  4.243963791186823e-01,  1.096246910580377e-02,  8.118025363970214e-05, -1.222218991609705e-06,
 -1.138820436741148e-08,  5.167498676379525e-10,  8.019025074155542e-13, -4.147406751286811e-13, -5.861593605617366e-15,  1.058146654979562e-16,  3.255199986363191e-18,
  2.257655706126785e-20,  7.345256192952545e-01,  1.091229926192778e-02, -1.487335569664284e-06, -7.954780989988777e-07,  9.702593360095274e-09,  1.313521605997982e-10,
 -4.439267941963186e-12, -1.216543708012473e-13, -1.636545373513019e-15,  6.886871025762890e-18,  1.289207209441699e-18,  3.620240939760381e-20,  9.946825276730415e-01,
  9.481234127817730e-03, -3.111002419561072e-05, -2.684259766634069e-07,  7.912463161774921e-09,  1.908426119334045e-12, -2.135092430456770e-12, -6.680370094207509e-14,
 -1.272887267549432e-15,  5.817734251878610e-18,  8.620841885519043e-19,  2.235900868846688e-20,  1.213148393442733e+00,  7.792072199047178e-03, -3.866657431809354e-05,
  8.134558027238743e-09,  4.482250275693213e-09, -1.483845644303221e-11, -1.088324082524029e-12, -4.739943252399419e-14, -8.589538183842248e-16,  4.808534677772501e-18,
  5.759827780509193e-19,  1.514199059367953e-20,  1.397008580142587e+00,  6.155843282748642e-03, -3.688284155616823e-05,  1.268292919536752e-07,  2.105968855169019e-09,
 -9.027850232690607e-12, -6.620278143492224e-13, -3.397768288475706e-14, -5.723219635212600e-16,  3.447655786077043e-18,  3.963040360606531e-19,  1.047689496973845e-20,
  1.551246339987765e+00,  4.676041979262718e-03, -3.120749183236780e-05,  1.596493355442218e-07,  7.428276704552145e-10, -2.074147253948720e-12, -4.550656878314681e-13,
 -2.368005732471883e-14, -3.831950138206631e-16,  2.383498803912038e-18,  2.731668459426386e-19,  7.211379309675991e-21,  1.679360574127697e+00,  3.389540617208146e-03,
 -2.422872312913396e-05,  1.484112734915700e-07,  6.462523191238171e-11,  2.040944646927692e-12, -3.248787566776294e-13, -1.588521770010654e-14, -2.540250715837372e-16,
  1.611521832302458e-18,  1.842683069551132e-19,  4.850509750975018e-21,  1.783847497576392e+00,  2.308737286087376e-03, -1.728189889123751e-05,  1.171701989631815e-07,
 -1.990046832131554e-10,  3.479721659180009e-12, -2.254961257157708e-13, -1.011565030822107e-14, -1.625900231929483e-16,  1.047671287789231e-18,  1.188562629695686e-19,
  3.121428833267840e-21,  1.866505137905109e+00,  1.436492392308821e-03, -1.109829957061888e-05,  8.010763849893564e-08, -2.356361935821777e-10,  3.205417146986412e-12,
 -1.442589328903639e-13, -5.952573880235836e-15, -9.693032002950861e-17,  6.328381510326685e-19,  7.097734826438308e-20,  1.861420493780733e-21,  1.928622802579925e+00,
  7.720648549185053e-04, -6.094168346335853e-06,  4.576642890493867e-08, -1.694699626619189e-10,  2.140836643723060e-12, -7.955893398033117e-14, -3.063690509207421e-15,
 -5.062754831720068e-17,  3.340462714666798e-19,  3.702505844364597e-20,  9.703458629471608e-22,  1.971100437613460e+00,  3.136550996811184e-04, -2.509797360101614e-06,
  1.930937133043235e-08, -8.029310949991226e-11,  9.847896715041709e-13, -3.295011480599352e-14, -1.207498283940587e-15, -2.020218853683390e-17,  1.343124633409562e-19,
  1.474368830065635e-20,  3.863035061541043e-22,  1.994530011197138e+00,  5.947464567569496e-05, -4.793434116184465e-07,  3.734058409336202e-09, -1.639314758678769e-11,
  1.986754980296250e-13, -6.317354236153022e-15, -2.251169893388145e-16, -3.795048503377390e-18,  2.534021940706553e-20,  2.765363556015864e-21,  7.245181995122886e-23,
  1.074171714438368e-01,  6.252264096546907e-03,  2.143812522693675e-04,  4.271554346536584e-06,  1.492827547660893e-09, -3.245367000387945e-09, -1.137652142847973e-10,
 -1.197931790226647e-12,  5.700768132043300e-14,  3.069195510016439e-15,  5.868103383083498e-17, -6.184067726061259e-19,  4.694488964830744e-01,  1.155091831925714e-02,
  6.575321116335849e-05, -1.324979873017268e-06, -1.892510267896651e-09,  3.799309537845089e-10, -1.266900382241840e-11, -5.132980675848411e-13,  6.872721848222647e-16,
  2.738985717076835e-16,  5.675236023395570e-18,  9.066248291041498e-20,  7.780944967891935e-01,  1.086501262030305e-02, -1.003708888419161e-05, -6.262665807470883e-07,
  1.096026028379453e-08, -2.131244446903045e-11, -8.449991352578920e-12, -1.564818077368050e-13,  1.347855861604569e-19,  9.859037629397714e-17,  3.470557475368823e-18,
  5.817420263237492e-20,  1.032092318617263e+00,  9.221603012845818e-03, -3.358122465766972e-05, -1.450189289745201e-07,  7.264768753119073e-09, -7.589783892954113e-11,
 -4.484272062422701e-12, -9.530297781593316e-14, -1.602761487307687e-16,  6.481098533163409e-17,  2.179941551560773e-18,  3.374772983983856e-20,  1.243700312122617e+00,
  7.484315006065200e-03, -3.815441338199368e-05,  7.555400153158689e-08,  3.802101726833836e-09, -5.963556238616830e-11, -2.734076651577219e-12, -6.617144306270228e-14,
 -8.149267991161206e-17,  4.423862781303858e-17,  1.449467394247762e-18,  2.166870151390099e-20,  1.421052248242304e+00,  5.867420100599818e-03, -3.516843955002956e-05,
  1.578590886692212e-07,  1.679732326209837e-09, -3.815370527810677e-11, -1.823465757868541e-12, -4.621580241128524e-14, -3.259241286611120e-17,  3.052559141429216e-17,
  9.905677752809510e-19,  1.439447257015135e-20,  1.569463596139820e+00,  4.434239039518680e-03, -2.922435150109773e-05,  1.703608340942214e-07,  5.319267647417851e-10,
 -2.216617635958923e-11, -1.257819236339800e-12, -3.175376472102726e-14, -1.149244629170087e-17,  2.098160923326992e-17,  6.773357508731697e-19,  9.618458403557619e-21,
  1.692542380731820e+00,  3.202851687474315e-03, -2.244205940398078e-05,  1.491817082894496e-07, -1.285251465189464e-11, -1.189625655778126e-11, -8.619033771410320e-13,
 -2.118915308224122e-14, -3.545246227624172e-18,  1.411563492154603e-17,  4.537736207086100e-19,  6.329081457856494e-21,  1.792814768791740e+00,  2.176054995638802e-03,
 -1.589390369173742e-05,  1.141427797787557e-07, -2.092193086379029e-10, -5.843981192100307e-12, -5.676275395638588e-13, -1.349304294258992e-14, -9.220388099149831e-19,
  9.092840747634445e-18,  2.911811361044293e-19,  4.006426405847534e-21,  1.872079536889939e+00,  1.351490414087081e-03, -1.015829173515747e-05,  7.659973415407900e-08,
 -2.212872318697890e-10, -2.562352644628007e-12, -3.459907415870702e-13, -7.960599070348957e-15, -2.049483771006125e-19,  5.428906484088164e-18,  1.732539828859933e-19,
  2.360049273984322e-21,  1.931616971727889e+00,  7.254646236260414e-04, -5.560250495455097e-06,  4.326149897415663e-08, -1.535503097668434e-10, -9.574405867131815e-13,
 -1.836394017029490e-13, -4.111128528667450e-15, -5.467548669718547e-20,  2.833139361864581e-18,  9.015940681811615e-20,  1.219451766420187e-21,  1.972316339480424e+00,
  2.944828865571849e-04, -2.285316617171733e-06,  1.812657556549195e-08, -7.158481526929753e-11, -2.753410481520916e-13, -7.405808527905511e-14, -1.625229231127373e-15,
 -2.278531416585997e-20,  1.128824280066948e-18,  3.584899888536194e-20,  4.826309588990804e-22,  1.994760518095360e+00,  5.581491113788449e-05, -4.360104204435762e-07,
  3.492947908813521e-09, -1.451039060965895e-11, -4.052726102966643e-14, -1.399130990214757e-14, -3.035734886641364e-16, -5.321296437054619e-21,  2.118132657158755e-19,
  6.718826686916439e-21,  9.023027234306350e-23,  1.361737761186628e-01,  8.166821420027837e-03,  2.631416351322366e-04,  3.621582441800808e-06, -9.188572760293929e-08,
 -6.056512172669866e-09, -1.026114402476934e-10,  2.715745504141464e-12,  1.909081691954315e-13,  3.462199075237786e-15, -8.075478084109303e-17, -6.187249144310002e-18,
  5.166037932907508e-01,  1.201327675328792e-02,  4.985605664249364e-05, -1.315699719503916e-06,  1.559237234093454e-09, -8.323326923708141e-11, -2.489289687083815e-11,
 -2.819360737904930e-13,  1.555858747977487e-14,  5.701947576071581e-16,  7.948192463151113e-18, -8.835674629665644e-20,  8.213504246284629e-01,  1.075752510242714e-02,
 -1.655381981356897e-05, -4.667685577050753e-07,  8.168896614178647e-09, -2.723368946759828e-10, -1.208038546208652e-11, -6.848554390553029e-14,  6.556630312306502e-15,
  2.734438001568160e-16,  4.441764117292271e-18, -6.168443622551263e-20,  1.068432993943327e+00,  8.947810537442190e-03, -3.469549908457378e-05, -4.765744130712838e-08,
  4.462996157411708e-09, -2.132993858524277e-10, -6.739052848729769e-12, -4.383334644631229e-14,  4.018281701752458e-15,  1.706829911399778e-16,  2.562408374314717e-18,
 -4.507901656624601e-20,  1.273034151208639e+00,  7.183623583026890e-03, -3.693535613345898e-05,  1.226685551641069e-07,  1.809447299287467e-09, -1.458694335729283e-10,
 -4.294969360391211e-12, -3.059710405927815e-14,  2.723175983975256e-15,  1.132128750565155e-16,  1.615377865123758e-18, -3.292712967116705e-20,  1.443971777389154e+00,
  5.594031126704496e-03, -3.314693300490241e-05,  1.758262246395962e-07,  3.789917503454898e-10, -9.624793107582507e-11, -2.906391924599649e-12, -2.105267495843569e-14,
  1.887118059639256e-15,  7.695251990006089e-17,  1.060575538372797e-18, -2.390414535276591e-20,  1.586746054722360e+00,  4.208720416050021e-03, -2.714970352058021e-05,
  1.733927517229314e-07, -2.818055617081803e-10, -6.216231235166806e-11, -1.997303478637524e-12, -1.416889795008958e-14,  1.301186677271457e-15,  5.236371380293823e-17,
  7.032767909714498e-19, -1.703663015828772e-20,  1.705006013174218e+00,  3.030446076517535e-03, -2.066514089833467e-05,  1.457541303139978e-07, -5.032715363438875e-10,
 -3.910815874919811e-11, -1.352862198076842e-12, -9.256089970572738e-15,  8.760386508944933e-16,  3.495713363476296e-17,  4.601944645112583e-19, -1.175706780756030e-20,
  1.801273262298038e+00,  2.054311398162182e-03, -1.455087104092623e-05,  1.089962553544700e-07, -4.913492067165995e-10, -2.361407224302310e-11, -8.790072583666645e-13,
 -5.779344487075494e-15,  5.638178794917891e-16,  2.237925007089179e-17,  2.900546544756990e-19, -7.709627698405808e-21,  1.877328693208988e+00,  1.273833484580974e-03,
 -9.263692159517489e-06,  7.212500862062004e-08, -3.726762397017722e-10, -1.330905108028161e-11, -5.291261973956208e-13, -3.352267432275609e-15,  3.360786317652614e-16,
  1.329620426276227e-17,  1.702833727276661e-19, -4.660320427134241e-21,  1.934433091015441e+00,  6.830142054980982e-04, -5.057364727268517e-06,  4.037436526913229e-08,
 -2.255999876481200e-10, -6.625049722328935e-12, -2.779993028864316e-13, -1.707867427635375e-15,  1.750805087933731e-16,  6.913102044990398e-18,  8.776141919734784e-20,
 -2.452474902257735e-21,  1.973459054658470e+00,  2.770498374071413e-04, -2.075205419159080e-06,  1.682570359361273e-08, -9.835384091081508e-11, -2.550603582226203e-12,
 -1.113027977528786e-13, -6.686426776716827e-16,  6.965824547347991e-17,  2.747416388125605e-18,  3.467262333311693e-20, -9.823394726910257e-22,  1.994977061217643e+00,
  5.249034833558263e-05, -3.955815515306966e-07,  3.233272014148711e-09, -1.933027807400555e-11, -4.692803276832569e-13, -2.094224338634462e-14, -1.242097563615908e-16,
  1.305931757982203e-17,  5.148001480328112e-19,  6.475858590965713e-21, -1.848394537735033e-22,  1.732782731581997e-01,  1.041090525518034e-02,  2.934519659759380e-04,
  1.087978320334970e-06, -2.275551380637030e-07, -6.838173956266190e-09,  6.978435134618593e-11,  9.591005724140502e-12,  1.820973343749210e-13, -6.040185800182325e-15,
 -3.806950611293280e-16, -3.778211561178450e-18,  5.653547600183019e-01,  1.234905001312501e-02,  3.405293614965390e-05, -1.337940009306427e-06, -6.341202025775383e-09,
 -6.983970965608138e-10, -2.240189236754969e-11,  5.846010473897989e-13,  3.871927153363402e-14,  5.584612756764808e-16, -1.662081706734860e-17, -1.174214161836471e-18,
  8.640826503062023e-01,  1.060439422844612e-02, -2.160207776563422e-05, -3.954916474313983e-07, -1.676245105308946e-10, -5.514949213162883e-10, -9.398680304531496e-12,
  3.211984238273757e-13,  1.790201266010450e-14,  2.764290520890854e-16, -7.954469035710439e-18, -5.521711632060954e-19,  1.103666699614569e+00,  8.668790874958109e-03,
 -3.500852456418763e-05, -1.924257529788871e-08, -1.418528573301043e-09, -3.690163666017885e-10, -5.143005936594403e-12,  1.949893104576762e-13,  1.090548188058253e-14,
  1.618965162818978e-16, -5.115599663119413e-18, -3.273325643173062e-19,  1.301187358623640e+00,  6.894262337893490e-03, -3.540429923207715e-05,  1.226175849756134e-07,
 -2.139992702607980e-09, -2.452870894157124e-10, -3.259034785655723e-12,  1.287882540912511e-13,  7.205328851495838e-15,  1.023319461789398e-16, -3.503919153807483e-18,
 -2.120284307225610e-19,  1.465830834917241e+00,  5.337227112104911e-03, -3.107661120665881e-05,  1.626578828145682e-07, -2.244308126954029e-09, -1.634810716032501e-10,
 -2.195989008587489e-12,  8.803181576778244e-14,  4.892993960986264e-15,  6.709365678876099e-17, -2.442859001345101e-18, -1.421642899982109e-19,  1.603159464565979e+00,
  3.999657337341063e-03, -2.514562061953862e-05,  1.563069570133362e-07, -2.004303150683995e-09, -1.082749301468608e-10, -1.503242018000850e-12,  6.040226168034188e-14,
  3.326241480603708e-15,  4.441390217090944e-17, -1.694202675638912e-18, -9.584237926341296e-20,  1.716807946278969e+00,  2.871913200668848e-03, -1.899600037673935e-05,
  1.296650691152896e-07, -1.609467719993003e-09, -7.026856243358270e-11, -1.014739865490882e-12,  4.066049392299763e-14,  2.217701467752704e-15,  2.902607277147438e-17,
 -1.147129620528218e-18, -6.354459596410438e-20,  1.809265732173044e+00,  1.942959173623703e-03, -1.330942370900888e-05,  9.620198144934534e-08, -1.173791909080861e-09,
 -4.381436460348274e-11, -6.574470190065501e-13,  2.622269489203177e-14,  1.417781977270170e-15,  1.828083887281396e-17, -7.421152390777407e-19, -4.046895562182476e-20,
  1.882281114084293e+00,  1.203059818420485e-03, -8.445009463621924e-06,  6.333872210786714e-08, -7.651693852124774e-10, -2.544521343197145e-11, -3.948694516833480e-13,
  1.567414859774477e-14,  8.412450171162569e-16,  1.072790843530671e-17, -4.443026416713523e-19, -2.394927057409050e-20,  1.937087195548977e+00,  6.444194450747421e-04,
 -4.600086954808008e-06,  3.534050064948025e-08, -4.243832228931938e-10, -1.299162874466176e-11, -2.071156894986041e-13,  8.187237616633648e-15,  4.369083404841223e-16,
  5.528027260293681e-18, -2.322599218594057e-19, -1.241624437033554e-20,  1.974535285396130e+00,  2.612242468013638e-04, -1.884896270344248e-06,  1.469821342610223e-08,
 -1.758805769671435e-10, -5.096894901447041e-12, -8.282950073012205e-14,  3.264177709866926e-15,  1.734971527751651e-16,  2.183876593751032e-18, -9.263242090987914e-20,
 -4.924996792110385e-21,  1.995180930445959e+00,  4.947474279950679e-05, -3.590368591767134e-07,  2.821493507793318e-09, -3.370237144354620e-11, -9.480964592599117e-13,
 -1.557521334330824e-14,  6.127095968858951e-16,  3.249422319729081e-17,  4.078817189685950e-19, -1.739008493647479e-20, -9.218593115769663e-22,  2.196000676508139e-01,
  1.273953538031842e-02,  2.807142449151800e-04, -3.456485211011151e-06, -3.236569285031515e-07, -1.589648055951232e-09,  3.662091733426675e-10,  9.056354875882998e-12,
 -2.892896672834896e-13, -1.764768089001174e-14,  5.868027241040998e-18,  2.309097311587456e-17,  6.151900965241913e-01,  1.255431471081847e-02,  1.685498956010611e-05,
 -1.572100002756134e-06, -2.358316384539502e-08, -8.884860797507573e-10,  1.274145251658888e-11,  1.897816821041707e-12,  3.190126357892736e-14, -1.366696999352322e-15,
 -7.811359232033259e-17, -8.211214429370364e-19,  9.061232912514342e-01,  1.041165074140337e-02, -2.675640354540316e-05, -4.943603969486914e-07, -1.236337913166072e-08,
 -5.987300858230930e-10,  8.360532837478188e-12,  9.371994362849500e-13,  1.529345299978047e-14, -6.139811606764783e-16, -3.562356333535856e-17, -3.671663365786710e-19,
  1.137778940052870e+00,  8.386820996577145e-03, -3.563399800177809e-05, -1.050733120168959e-07, -9.371902209870379e-09, -3.842971477996824e-10,  5.614715182369025e-12,
  5.659456203734271e-13,  9.097137514492388e-15, -3.713071489054195e-16, -2.075161470144555e-17, -1.894254557306123e-19,  1.328205919849148e+00,  6.615939165704992e-03,
 -3.430943606003376e-05,  4.660701314210495e-08, -7.391821642124488e-09, -2.522349141206682e-10,  3.819359948196074e-12,  3.709610311675679e-13,  5.850993706686658e-15,
 -2.456357773301440e-16, -1.326114458693308e-17, -1.079056823145075e-19,  1.486693673415260e+00,  5.095549778829838e-03, -2.945424326217143e-05,  9.890416714245362e-08,
 -5.743911564601180e-09, -1.676849184572581e-10,  2.612117239938172e-12,  2.509336742679395e-13,  3.885114618585799e-15, -1.674840937871034e-16, -8.800890500728926e-18,
 -6.480293568262894e-20,  1.618766645217842e+00,  3.805276403104355e-03, -2.353804053973377e-05,  1.057579046225400e-07, -4.327568728871814e-09, -1.112409062137190e-10,
  1.773397024129726e-12,  1.703423280280270e-13,  2.594396182907403e-15, -1.143783440295053e-16, -5.887494721875068e-18, -3.982077364787285e-20,  1.728000751013723e+00,
  2.725618478676876e-03, -1.764376844512320e-05,  9.188686708207595e-08, -3.122237761672518e-09, -7.243801523641114e-11,  1.176999774257210e-12,  1.135571730408168e-13,
  1.705730097804980e-15, -7.658645736306718e-17, -3.880637877226109e-18, -2.444595547583212e-20,  1.816831385861513e+00,  1.840711672820344e-03, -1.229846279017756e-05,
  6.990062511415134e-08, -2.120360415649297e-09, -4.534480677293533e-11,  7.483252005380635e-13,  7.263120504854338e-14,  1.078719002056518e-15, -4.914226764646753e-17,
 -2.460486524899077e-18, -1.462180741912135e-20,  1.886962699098813e+00,  1.138290827341537e-03, -7.776316636096391e-06,  4.671674986629805e-08, -1.316679831145155e-09,
 -2.643400809278006e-11,  4.416729470968318e-13,  4.312504288470439e-14,  6.348197018966171e-16, -2.924568577645961e-17, -1.451304637239937e-18, -8.234003541991690e-21,
  1.939593767223128e+00,  6.091786673120380e-04, -4.225906229935577e-06,  2.630949849108935e-08, -7.067338856888097e-10, -1.354011310730293e-11,  2.283651033348462e-13,
  2.241222954374498e-14,  3.277338938086269e-16, -1.522341315086814e-17, -7.506358690666455e-19, -4.112408789265769e-21,  1.975551062716217e+00,  2.467945046937218e-04,
 -1.729002631256751e-06,  1.100356440903365e-08, -2.868728970380616e-10, -5.324792084845240e-12,  9.038825465179818e-14,  8.904586124825039e-15,  1.296251488305364e-16,
 -6.054645414164916e-18, -2.972801019465859e-19, -1.590071969186352e-21,  1.995373284299013e+00,  4.672717746812273e-05, -3.290846185470598e-07,  2.118307116531286e-09,
 -5.437210798343311e-11, -9.918583382315417e-13,  1.689709126338101e-14,  1.668254268361289e-15,  2.422483257252201e-17, -1.134946011165575e-18, -5.559781731445822e-20,
 -2.934619157045125e-22,  2.746637843267001e-01,  1.473231631883773e-02,  2.088377532733086e-04, -8.351483705241066e-06, -2.547380041091430e-07,  8.664830033122427e-09,
  4.076843604111999e-10, -8.124752292686303e-12, -6.507807310129481e-13,  4.392969997075271e-15,  9.702509440389637e-16,  5.367100431760648e-18,  6.655469713870934e-01,
  1.260613209372210e-02, -4.754119835481593e-06, -2.055628966380198e-06, -3.366726249919508e-08,  1.030719352093086e-10,  6.847951542949081e-11,  1.544421193070010e-12,
 -6.849464746722318e-14, -3.617290874706789e-15,  1.383971631321024e-17,  5.445613243634388e-18,  9.472984196081045e-01,  1.016971526003630e-02, -3.420945625302832e-05,
 -7.675122690125802e-07, -2.004325952816726e-08, -5.828046256097405e-11,  3.616000344145680e-11,  8.026402184819614e-13, -3.059479496671578e-14, -1.694020031823946e-15,
  1.877344128366879e-18,  2.280342159016487e-18,  1.170743820108341e+00,  8.093648199616298e-03, -3.800881442928849e-05, -3.034253415755698e-07, -1.433027386718805e-08,
 -4.461066267659347e-11,  2.238927765736380e-11,  4.873357735530822e-13, -1.795537691919468e-14, -9.910557190903907e-16,  9.979880815797261e-19,  1.280283803783974e-18,
  1.354120987154223e+00,  6.341357802729319e-03, -3.459984477373793e-05, -1.032679869138977e-07, -1.061727203985542e-08, -2.660030808669562e-11,  1.477714065056703e-11,
  3.181425068515767e-13, -1.162029630684562e-14, -6.336315655404653e-16,  8.215523035636578e-19,  8.026533419157607e-19,  1.506609622836911e+00,  4.862880702559848e-03,
 -2.891151564500922e-05, -1.387546379522892e-08, -7.861472216482614e-09, -1.461704417581296e-11,  9.997216508083657e-12,  2.139351751501289e-13, -7.805229567281015e-15,
 -4.202619079773705e-16,  6.842275103500204e-19,  5.266535787336755e-19,  1.633617324372785e+00,  3.620725815620255e-03, -2.274562182462670e-05,  2.275652374580554e-08,
 -5.713992956569893e-09, -7.474967028328990e-12,  6.770164178426207e-12,  1.443963908465678e-13, -5.275080206608679e-15, -2.808905942555103e-16,  5.411687919151014e-19,
  3.497199667400572e-19,  1.738626583401847e+00,  2.587935189982270e-03, -1.688056975017078e-05,  3.302470574801284e-08, -4.013778356609355e-09, -3.469928285935117e-12,
  4.498847557775566e-12,  9.578276047984232e-14, -3.506091012172330e-15, -1.849783378900628e-16,  4.026742539575124e-19,  2.293522823972491e-19,  1.824001876908659e+00,
  1.745043502838599e-03, -1.168797742916400e-05,  3.042956206139315e-08, -2.672158561216191e-09, -1.382217600313153e-12,  2.868232799392064e-12,  6.101238536161036e-14,
 -2.237783118759001e-15, -1.171907815814461e-16,  2.787722519388554e-19,  1.449054857707557e-19,  1.891394440570105e+00,  1.077930274149945e-03, -7.356511629219186e-06,
  2.243185662207178e-08, -1.635257919330923e-09, -4.138933564520617e-13,  1.698182306100109e-12,  3.610971239341870e-14, -1.326700655936303e-15, -6.907905211879996e-17,
  1.751798515189850e-19,  8.525878143658657e-20,  1.941964572192634e+00,  5.764245126479946e-04, -3.985394486109236e-06,  1.335930857264349e-08, -8.686667236701054e-10,
 -5.294941621651155e-14,  8.805341919831908e-13,  1.872130997310686e-14, -6.887685410258020e-16, -3.571072745256296e-17,  9.471024996895128e-20,  4.402124328160991e-20,
  1.976511293638944e+00,  2.334057410833081e-04, -1.627387537973416e-06,  5.769324336938567e-09, -3.502069239614506e-10,  2.355799696412051e-14,  3.492749863244177e-13,
  7.426042347717503e-15, -2.734673213022519e-16, -1.413788146715644e-17,  3.860487748826847e-20,  1.741475267520117e-20,  1.995555066061345e+00,  4.418010868408676e-05,
 -3.094220775551753e-07,  1.128514849954926e-09, -6.613296006755372e-11,  9.053036755035644e-15,  6.537578145103048e-14,  1.390010434181670e-15, -5.121474573163453e-17,
 -2.643580939916366e-18,  7.331953669740106e-21,  3.255016886480845e-21,  3.362229805677540e-01,  1.594894132945080e-02,  9.130199060046502e-05, -1.062453691451198e-05,
 -1.261717613452916e-08,  1.376966059881023e-08, -3.730919675396844e-11, -1.964427607406500e-11,  8.536733229638520e-14,  2.887795174076819e-14, -1.293020078927879e-16,
 -4.313575184607750e-17,  7.157272768444376e-01,  1.246105820760951e-02, -3.227009322791173e-05, -2.479673955901301e-06, -1.340439607317328e-08,  1.913860364681203e-09,
  6.515740209694496e-11, -2.118889866372958e-12, -1.273275643980142e-13,  1.804025449853303e-15,  2.163557141710306e-16, -1.692034769055206e-19,  9.873642047681902e-01,
  9.853992491516188e-03, -4.521487992399335e-05, -1.045400357587798e-06, -1.150189422230136e-08,  9.181378686700690e-10,  3.712047818730956e-11, -9.199001148388465e-13,
 -6.349520624590704e-14,  5.412262432571817e-16,  9.690934332098052e-17,  4.534737887646810e-19,  1.202481879073604e+00,  7.771254202300377e-03, -4.295150230753530e-05,
 -5.075763766303312e-07, -9.208599726541031e-09,  5.618590331358550e-10,  2.338687162419214e-11, -5.282951729211804e-13, -3.791216752889693e-14,  2.645267423345086e-16,
  5.502762722490230e-17,  3.264549570533628e-19,  1.378921013483688e+00,  6.056810118308313e-03, -3.680755738020192e-05, -2.561112237342133e-07, -7.180985173672840e-09,
  3.739496034385575e-10,  1.553492538540837e-11, -3.362185579126823e-13, -2.449053476825851e-14,  1.565155234039207e-16,  3.452328516689226e-17,  2.159613183093068e-19,
  1.525594574639307e+00,  4.628854172344292e-03, -2.979616782166901e-05, -1.276000416502455e-07, -5.469849695525742e-09,  2.564067299644991e-10,  1.054093305973099e-11,
 -2.229533660518062e-13, -1.634669212377429e-14,  1.003203602386345e-16,  2.261011068457970e-17,  1.423179286703162e-19,  1.647735896482585e+00,  3.438349980121564e-03,
 -2.299473939680518e-05, -6.011540804693642e-08, -4.046250541542307e-09,  1.760662034796576e-10,  7.149457670414281e-12, -1.491977928596585e-13, -1.097249490045628e-14,
  6.607665573016920e-17,  1.497869699461665e-17,  9.344208282167250e-20,  1.748709248805272e+00,  2.453420251755703e-03, -1.685110250312077e-05, -2.527422211709114e-08,
 -2.875747458339707e-09,  1.184942740882487e-10,  4.755158116403584e-12, -9.840929648168371e-14, -7.247892910844564e-15,  4.327684894548053e-17,  9.801378055982355e-18,
  6.032312624460089e-20,  1.830796360279692e+00,  1.652297802432253e-03, -1.156701261813142e-05, -8.417238059576530e-09, -1.930061825968945e-09,  7.637573075594683e-11,
  3.033328095548962e-12, -6.244186564670067e-14, -4.602009845157686e-15,  2.738500125132455e-17,  6.180717299858990e-18,  3.751644527895803e-20,  1.895589553207244e+00,
  1.019725137549538e-03, -7.236742991807783e-06, -1.354018323851751e-09, -1.187814489127030e-09,  4.562424521193822e-11,  1.796573806290923e-12, -3.685528554800608e-14,
 -2.717073458482755e-15,  1.615305986747787e-17,  3.630993482236034e-18,  2.177049329072583e-20,  1.944207195765856e+00,  5.449543585933215e-04, -3.904442424932029e-06,
  7.196438069398138e-10, -6.334305412256619e-10,  2.381883109573095e-11,  9.317692321119884e-13, -1.907208414931221e-14, -1.406207887167755e-15,  8.360894322069459e-18,
  1.872599995241866e-18,  1.111744132042398e-20,  1.977419186485433e+00,  2.205715659161668e-04, -1.590146624013765e-06,  6.725391341610630e-10, -2.560067098930369e-10,
  9.492712579587591e-12,  3.696516545539724e-13, -7.556047988052233e-15, -5.571349233869490e-16,  3.313978178355785e-18,  7.402118479627050e-19,  4.363897106076691e-21,
  1.995726896890434e+00,  4.174152871019342e-05, -3.019207114495348e-07,  1.659395483366215e-10, -4.840810710225941e-11,  1.781462451519451e-12,  6.919503499129283e-14,
 -1.413435572040465e-15, -1.042181911398259e-16,  6.201302212647638e-19,  1.382937746231048e-19,  8.120985494056933e-22,  4.006934054766436e-01,  1.618569529583284e-02,
 -2.894607986151456e-05, -8.842099177087042e-06,  2.145390960589623e-07,  7.424470523097788e-09, -4.188627113395885e-10, -4.419435729433987e-12,  6.708600861018654e-13,
 -2.187223395026841e-15, -9.689639781939595e-16,  1.468631010112338e-17,  7.648659593496263e-01,  1.208355877797268e-02, -6.184689663218873e-05, -2.330100586977884e-06,
  3.378071973073151e-08,  2.419275941956656e-09, -3.104333811916028e-11, -3.782811391381048e-12,  4.942125885741559e-14,  5.901612167132639e-15, -8.460578431263784e-17,
 -9.310166629540456e-18,  1.025975034469768e+00,  9.440617109733715e-03, -5.813394933631793e-05, -1.046525649419924e-06,  1.266728707065992e-08,  1.313837121835127e-09,
 -9.184642343895616e-12, -1.972536549561722e-12,  1.256813423768711e-14,  2.892496743646035e-15, -1.699156012549958e-17, -4.301048758934056e-18,  1.232838894103950e+00,
  7.401791795525457e-03, -4.947596769233414e-05, -5.417565087917822e-07,  5.826139467920357e-09,  8.320238065047050e-10, -4.087835874479154e-12, -1.201341491123764e-12,
  4.859046639913439e-15,  1.695304311341366e-15, -5.109863539452717e-18, -2.418116372842638e-18,  1.402537999794741e+00,  5.748781262402942e-03, -4.027008901678379e-05,
 -2.955525552449817e-07,  2.862308565211656e-09,  5.597217249658295e-10, -2.191579013771512e-12, -7.843755835966082e-13,  2.286237555508595e-15,  1.080127106602462e-15,
 -1.806197492429277e-18, -1.498244289226232e-18,  1.543622063350963e+00,  4.383336748102672e-03, -3.164686416509668e-05, -1.634298624795069e-07,  1.413458454441199e-09,
  3.847769390972313e-10, -1.292226075072831e-12, -5.269659121493973e-13,  1.196036858128182e-15,  7.136925667965974e-16, -6.665092753306287e-19, -9.707801721439863e-19,
  1.661115675386356e+00,  3.250724406758306e-03, -2.396361797614596e-05, -8.942784314241607e-08,  6.716390191220989e-10,  2.640699161791528e-10, -7.970798430952508e-13,
 -3.552324621681469e-13,  6.625534648097847e-16,  4.754626675406127e-16, -2.318069617051193e-19, -6.376131781521229e-19,  1.758250567472210e+00,  2.316830041526829e-03,
 -1.733577441818644e-05, -4.749005201632316e-08,  2.925308782615607e-10,  1.774183762236835e-10, -4.966521263638703e-13, -2.353371047105449e-13,  3.757050355856687e-16,
  3.122934957321191e-16, -6.285251888004733e-20, -4.144128011723812e-19,  1.837219278923267e+00,  1.558970411099320e-03, -1.179237061979502e-05, -2.398826302165931e-08,
  1.078044451360397e-10,  1.141264771193079e-10, -3.028359759683660e-13, -1.497330380023492e-13,  2.114514264449204e-16,  1.974452480871066e-16, -2.186902225475172e-21,
 -2.599618450327429e-19,  1.899552214531791e+00,  9.615252786812715e-04, -7.330670162497278e-06, -1.122745709770534e-08,  2.735133920216793e-11,  6.804681540009005e-11,
 -1.738838836599037e-13, -8.853158372355585e-14,  1.137259989134219e-16,  1.162049782266460e-16,  1.359777747519375e-20, -1.521155271319169e-19,  1.946324409744893e+00,
  5.136239224272639e-04, -3.937658210788569e-06, -4.653677169114312e-09,  6.607750251922706e-14,  3.546950490290364e-11, -8.832645325607858e-14, -4.586454756304109e-14,
  5.493460530846237e-17,  6.000495724671323e-17,  1.213219858719041e-20, -7.822451791305375e-20,  1.978276005580001e+00,  2.078301082702288e-04, -1.599102905942927e-06,
 -1.527493387343583e-09, -3.785988148550608e-12,  1.412002418495193e-11, -3.458669186981520e-14, -1.818294889820105e-14,  2.077222682968558e-17,  2.373812347211853e-17,
  6.066271876797152e-21, -3.086174987748258e-20,  1.995889030493253e+00,  3.932416287340734e-05, -3.031603316746597e-07, -2.529273548054501e-10, -1.101227735072558e-12,
  2.648155587277917e-12, -6.430377682077007e-15, -3.402467128409832e-15,  3.787508329497225e-18,  4.436879615799406e-18,  1.257476641792813e-21, -5.759898989652722e-21,
  4.643937856550982e-01,  1.559575516494970e-02, -1.113412083781272e-04, -4.769387947089563e-06,  2.638791255406984e-07, -1.980911139860475e-09, -2.959841787070942e-10,
  1.032607879130839e-11,  1.550580563217653e-13, -1.816968253987730e-14,  2.075455653806088e-16,  2.110865550331286e-17,  8.120508517038535e-01,  1.148938335723716e-02,
 -8.518545039650620e-05, -1.473651674378778e-06,  6.775451805988070e-08,  7.387010405538425e-10, -9.117487709026890e-11, -4.423529459042965e-14,  1.360474913503665e-13,
 -1.751584470686240e-15, -1.830584408186856e-16,  5.267645200580599e-18,  1.062735117822096e+00,  8.930591052181263e-03, -6.869473273188761e-05, -6.624530659642407e-07,
  3.286537797967728e-08,  5.594520416289932e-10, -4.592480325741993e-11, -3.431551958546279e-13,  6.926816232822133e-14, -2.911506417399548e-16, -9.629274129947649e-17,
  1.531397566677881e-18,  1.261617068352437e+00,  6.982741359877021e-03, -5.491488066824658e-05, -3.311955578744914e-07,  1.907045221106787e-08,  3.980982120056511e-10,
 -2.773549717137124e-11, -2.889882877450183e-13,  4.135415502556156e-14, -2.876212866981124e-17, -5.712789814460835e-17,  6.358452525043631e-19,  1.424868496136366e+00,
  5.414009834156322e-03, -4.320087535622588e-05, -1.699452073602183e-07,  1.193550931164079e-08,  2.843069437834538e-10, -1.806398601454886e-11, -2.168306154587219e-13,
  2.661923011244210e-14,  3.133007571201059e-17, -3.643015506976796e-17,  3.154777640394664e-19,  1.560637911103130e+00,  4.123251992337859e-03, -3.323672605316751e-05,
 -8.558758333506740e-08,  7.719821357979433e-09,  2.026485254188042e-10, -1.213040834350443e-11, -1.573079854275662e-13,  1.770088913299442e-14,  4.109166454174490e-17,
 -2.402487379340060e-17,  1.723695439615291e-19,  1.673729117732567e+00,  3.055284304360744e-03, -2.481007083002014e-05, -4.061691661061767e-08,  5.031174793926469e-09,
  1.424522129531666e-10, -8.180053634863288e-12, -1.112513817493349e-13,  1.184248628074918e-14,  3.644766041129015e-17, -1.596522732947536e-17,  9.904172413738562e-20,
  1.767237355655650e+00,  2.176198779813684e-03, -1.776835932210316e-05, -1.716006444533929e-08,  3.236286826694544e-09,  9.732211037622649e-11, -5.422691492051553e-12,
 -7.609934398938926e-14,  7.801392718927992e-15,  2.809276412448262e-17, -1.046107146118885e-17,  5.791958584222985e-20,  1.843264918169777e+00,  1.463673498390104e-03,
 -1.199952245748926e-05, -5.729867378161958e-09,  2.008175389199623e-09,  6.335653384661421e-11, -3.452648632447445e-12, -4.950140963457978e-14,  4.942748928018252e-15,
  1.963103132935275e-17, -6.600217272384808e-18,  3.344226512026676e-20,  1.903280311777213e+00,  9.024464079896707e-04, -7.420779164873805e-06, -9.174420982452439e-10,
  1.163309932874025e-09,  3.810073022034365e-11, -2.042776759043324e-12, -2.972418594578098e-14,  2.913378222639135e-15,  1.233801123051162e-17, -3.877994646628274e-18,
  1.836049349016330e-20,  1.948315616861389e+00,  4.819503957280400e-04, -3.971590199776875e-06,  4.985901772374792e-10,  5.932322945045938e-10,  1.997932103178917e-11,
 -1.058857485019401e-12, -1.556288657116458e-14,  1.505952482250912e-15,  6.652579014524770e-18, -1.999943382494508e-18,  9.009302124200339e-21,  1.979081649748867e+00,
  1.949832848572112e-04, -1.609071732626449e-06,  4.639103922146619e-10,  2.326170919293466e-10,  7.984568931999246e-12, -4.199492030276453e-13, -6.211955631261302e-15,
  5.961603681045495e-16,  2.703893446805310e-18, -7.904949117639700e-19,  3.443878475027947e-21,  1.996041461984865e+00,  3.689025739642594e-05, -3.046645150318738e-07,
  1.144274383993307e-10,  4.326228701563503e-11,  1.500594826619240e-12, -7.860032640737919e-14, -1.166601616521451e-15,  1.114680357166522e-16,  5.125700508262356e-19,
 -1.476801238268652e-19,  6.317453766816417e-22,  5.247276898712272e-01,  1.454285605524039e-02, -1.455214544070120e-04, -1.148744883657849e-06,  1.772938887925986e-07,
 -5.569047857485162e-09, -1.713184322846915e-11,  7.562383910259699e-12, -2.278582479442750e-13, -2.234687075013623e-15,  3.633450632496614e-16, -8.692411818003266e-18,
  8.565599812373403e-01,  1.075597411912564e-02, -9.624469637680805e-05, -3.829887429479173e-07,  6.269963484124319e-08, -1.068003789757125e-09, -4.790439261377307e-11,
  2.429856118002630e-12,  8.439816323606143e-15, -3.542813169357042e-15,  7.401418659477869e-17,  3.148910023021209e-18,  1.097321271898769e+00,  8.358637067281547e-03,
 -7.331264966136516e-05, -1.060902887469842e-07,  3.342559183241583e-08, -4.391335023362843e-10, -3.024608831192025e-11,  1.164583804009227e-12,  1.546478373118630e-14,
 -1.880694852965712e-15,  1.994803639377384e-17,  2.092665947514969e-18,  1.288652045490949e+00,  6.533079021285026e-03, -5.691422207035745e-05,  1.249441457111226e-09,
  2.043889703556363e-08, -2.295736452271724e-10, -2.004811975165790e-11,  6.771532134909603e-13,  1.238103537868459e-14, -1.130309378967629e-15,  6.855050782768868e-18,
  1.336096893922769e-18,  1.445825361446622e+00,  5.063767582278294e-03, -4.398469265640536e-05,  4.254817998815467e-08,  1.326372165017657e-08, -1.335722556534231e-10,
 -1.373364802442749e-11,  4.290757353288839e-13,  9.154397962261034e-15, -7.271391507077961e-16,  2.529427774324896e-18,  8.814901450460167e-19,  1.576595864220279e+00,
  3.855552146394840e-03, -3.344156755966170e-05,  5.414728420890648e-08,  8.819527706174257e-09, -8.182925624858874e-11, -9.515861741713717e-12,  2.823431153188694e-13,
  6.599305365750295e-15, -4.824004241667578e-16,  8.777177933884385e-19,  5.923092761773594e-19,  1.685552334311488e+00,  2.856367632612382e-03, -2.475610135137002e-05,
  5.169450884156877e-08,  5.876564426543617e-09, -5.114441452096259e-11, -6.552751992744983e-12,  1.875034991641940e-13,  4.651679606421518e-15, -3.219163475804649e-16,
  2.194043056569054e-19,  3.981130121046563e-19,  1.775657930779671e+00,  2.034208905660681e-03, -1.762305423678822e-05,  4.288972423534886e-08,  3.848846695785062e-09,
 -3.183691077209631e-11, -4.407952650582225e-12,  1.228575971108139e-13,  3.175778738480908e-15, -2.115714019458577e-16, -2.728846219632653e-20,  2.627863147048304e-19,
  1.848928044269234e+00,  1.368014503931820e-03, -1.184879367619855e-05,  3.187782687690782e-08,  2.423463694009483e-09, -1.925371938624069e-11, -2.836028684957756e-12,
  7.753221522556162e-14,  2.063358691996905e-15, -1.337814813668519e-16, -9.582260374192302e-20,  1.666191648869302e-19,  1.906771795670732e+00,  8.433925173721260e-04,
 -7.303918202387908e-06,  2.102991055413077e-08,  1.420250097094582e-09, -1.093447794326976e-11, -1.690519393616533e-12,  4.556788426512290e-14,  1.238066400565558e-15,
 -7.872971710310263e-17, -8.980469798697384e-20,  9.822602523686592e-20,  1.950180167003673e+00,  4.503840201404293e-04, -3.900116109698305e-06,  1.175385516200695e-08,
  7.306289708872133e-10, -5.494949479701127e-12, -8.808348166022504e-13,  2.350653590988687e-14,  6.479183963121289e-16, -4.064782842581857e-17, -5.848594165007927e-20,
  5.077027549549103e-20,  1.979835973669096e+00,  1.822046910195920e-04, -1.577747375379166e-06,  4.894505078440267e-09,  2.882227774300854e-10, -2.133403263528274e-12,
 -3.505237344551711e-13,  9.293115516459029e-15,  2.585448579284452e-16, -1.607819798601872e-17, -2.626085135410798e-20,  2.009571322719788e-20,  1.996184175827152e+00,
  3.447179005535708e-05, -2.984929907739902e-07,  9.402156495820913e-10,  5.378290851870693e-11, -3.946191211613650e-13, -6.572432807820243e-14,  1.736351757205117e-15,
  4.854760670756909e-17, -3.004907395289044e-18, -5.221007119609602e-21,  3.757053444591107e-21,  5.805405671519637e-01,  1.336345501015791e-02, -1.458734759329944e-04,
  8.316153626634745e-07,  7.468028082416695e-08, -4.257154555409371e-09,  9.577557642483732e-11,  9.848932578625849e-13, -1.449638769239527e-13,  4.352310587234674e-15,
 -3.221812204700890e-19, -4.891205529765791e-18,  8.980364179526555e-01,  9.982770723167235e-03, -9.566692073418132e-05,  4.092651860464409e-07,  3.509917989106188e-08,
 -1.464155464941731e-09,  9.675559667581021e-12,  1.360462928537934e-12, -5.328641967480576e-14,  8.786185960283247e-18,  6.484332936047660e-17, -2.078504972867860e-18,
  1.129586456531996e+00,  7.775268157513966e-03, -7.176333552451535e-05,  3.303901428876621e-07,  2.007962119687428e-08, -7.716026560489210e-10,  9.372396034620521e-13,
  8.462825979483746e-13, -2.532701149335674e-14, -2.776326833729627e-16,  3.837821151806792e-17, -7.926800936269414e-19,  1.313881044584178e+00,  6.082899510042738e-03,
 -5.515472156317641e-05,  2.722046757312562e-07,  1.265771438471130e-08, -4.719263828365943e-10, -7.837824903539190e-13,  5.557728460405381e-13, -1.444616617810680e-14,
 -2.522380892810601e-16,  2.401062073507666e-17, -3.750362469243892e-19,  1.465384615791706e+00,  4.717242382789612e-03, -4.233500945755347e-05,  2.198773662811013e-07,
  8.345296951504771e-09, -3.078917284988308e-10, -1.074907260928039e-12,  3.780958443304379e-13, -8.992244436450514e-15, -1.961070694689112e-16,  1.575215087197280e-17,
 -2.000425056989881e-19,  1.591490261625334e+00,  3.592826993536529e-03, -3.203137745602874e-05,  1.726809506770764e-07,  5.599001703516456e-09, -2.062537917782888e-10,
 -9.833301805703624e-13,  2.605784263337754e-13, -5.829924911666927e-15, -1.452733428153122e-16,  1.056640632559138e-17, -1.140278270177742e-19,  1.696587731911291e+00,
  2.662274961963205e-03, -2.362773245057192e-05,  1.309485129182586e-07,  3.750290956717543e-09, -1.385358580018500e-10, -7.901656237131721e-13,  1.786858983736553e-13,
 -3.825306855483890e-15, -1.041461788961626e-16,  7.099179072776199e-18, -6.717635751807146e-20,  1.783517431992573e+00,  1.896250671686329e-03, -1.677501622949559e-05,
  9.491922611867127e-08,  2.463831769262182e-09, -9.144294292861043e-11, -5.859846188269590e-13,  1.198031486498516e-13, -2.482436546597256e-15, -7.190996348676624e-17,
  4.686318308814426e-18, -3.985137590120249e-20,  1.854213810952833e+00,  1.275364197496802e-03, -1.125607441688795e-05,  6.469199746003720e-08,  1.554142928650589e-09,
 -5.798562350455512e-11, -4.025469518374318e-13,  7.688127010299866e-14, -1.554774340270078e-15, -4.708833404920515e-17,  2.972004424413459e-18, -2.318734970925545e-20,
  1.910030609627180e+00,  7.863283405840600e-04, -6.928264504841566e-06,  4.028196836265714e-08,  9.116960034035119e-10, -3.418686637835765e-11, -2.510105166335015e-13,
  4.573747381679081e-14, -9.084860273607400e-16, -2.840951736937673e-17,  1.752500774516104e-18, -1.277683263663615e-20,  1.951920456158744e+00,  4.199314162727021e-04,
 -3.695600541527270e-06,  2.166532424503003e-08,  4.692541377539691e-10, -1.767089304280177e-11, -1.348538691124918e-13,  2.379675948177224e-14, -4.666542477629455e-16,
 -1.492371936501436e-17,  9.060144191886668e-19, -6.277973211974545e-21,  1.980540023708701e+00,  1.698903167975083e-04, -1.493964889387807e-06,  8.806308200460761e-09,
  1.851604526944496e-10, -6.994463970389735e-12, -5.472352361675599e-14,  9.460595857919135e-15, -1.839599402056753e-16, -5.969592257675582e-18,  3.586727943050707e-19,
 -2.400411169626519e-21,  1.996317377826579e+00,  3.214253935144169e-05, -2.825352593988519e-07,  1.670348184179702e-09,  3.455483096556553e-11, -1.307662653632791e-12,
 -1.036745507619153e-14,  1.772951532402959e-15, -3.431790980393155e-17, -1.122367677911078e-18,  6.706287819648333e-20, -4.402898470388671e-22,  6.317448008478367e-01,
  1.225105281715490e-02, -1.311231138934006e-04,  1.471980240256847e-06,  1.263616609938638e-08, -2.014909728756786e-09,  8.020004550111140e-11, -1.432075932069331e-12,
 -1.989875036008947e-14,  2.184609539335067e-15, -6.787890588247332e-17,  6.119950197918531e-19,  9.364786436170731e-01,  9.244534194913379e-03, -8.828435032448993e-05,
  7.588337240429260e-07,  1.028021170923380e-08, -9.536838831348413e-10,  2.650038457080584e-11, -1.142887969913535e-14, -2.698926369745501e-14,  9.718944798492217e-16,
 -6.302661540499480e-18, -7.972110100196862e-19,  1.159570640377852e+00,  7.221350135346918e-03, -6.635833811031721e-05,  5.358096816252840e-07,  6.311913134320123e-09,
 -5.568658218921153e-10,  1.345376114699629e-11,  9.540412655111128e-14, -1.716057762271033e-14,  4.800601817165933e-16,  1.722180586597633e-18, -5.599653945784425e-19,
  1.337354788348607e+00,  5.657468748331469e-03, -5.097583011361967e-05,  4.024989858186189e-07,  4.007014128466557e-09, -3.589770331472095e-10,  8.030153269306780e-12,
  9.278050128253305e-14, -1.135956515433585e-14,  2.767053922097718e-16,  2.716836275363494e-18, -3.754242675944906e-19,  1.483595530719188e+00,  4.390924562540142e-03,
 -3.909475907256673e-05,  3.057070286921222e-07,  2.605320978996274e-09, -2.419058234232050e-10,  5.153921562380816e-12,  7.506000768265838e-14, -7.754326979841750e-15,
  1.726180054998137e-16,  2.445355953598955e-18, -2.557291514476235e-19,  1.605363930528068e+00,  3.346076392618856e-03, -2.955620003046378e-05,  2.300476555599692e-07,
  1.708996265949369e-09, -1.656410498578111e-10,  3.413583547263045e-12,  5.712107712149250e-14, -5.352623090686654e-15,  1.118325593181937e-16,  1.943451868690693e-18,
 -1.755953696579441e-19,  1.706869903157730e+00,  2.480348776394515e-03, -2.178710584643282e-05,  1.691825201297195e-07,  1.115464167534286e-09, -1.130139898031955e-10,
  2.274401113664289e-12,  4.174952339207848e-14, -3.673183647138171e-15,  7.325179188470341e-17,  1.451985657891512e-18, -1.198378376672547e-19,  1.790842010927962e+00,
  1.767137805412859e-03, -1.545960078135088e-05,  1.199056171919329e-07,  7.137969557268102e-10, -7.546220557859840e-11,  1.492554869131770e-12,  2.924157697427354e-14,
 -2.463583221860786e-15,  4.744306486832258e-17,  1.029712894620264e-18, -7.997937189341922e-20,  1.859140567322560e+00,  1.188755172631010e-03, -1.036881592176603e-05,
  8.037380478607255e-08,  4.392155171973706e-10, -4.826440380964012e-11,  9.424853604341553e-13,  1.935306760863140e-14, -1.581163906619720e-15,  2.965854671934923e-17,
  6.866525744347246e-19, -5.112101254577539e-20,  1.913068413405780e+00,  7.330315429995974e-04, -6.379951701144803e-06,  4.944050318574863e-08,  2.520769187099701e-10,
 -2.863630792505254e-11,  5.539950398978918e-13,  1.176838075769002e-14, -9.406804750390648e-16,  1.730228432971071e-17,  4.195210344871958e-19, -3.031400983363524e-20,
  1.953542843328762e+00,  3.915071687822036e-04, -3.402263993579773e-06,  2.636230616065851e-08,  1.274523915798135e-10, -1.486896404765772e-11,  2.857570005846484e-13,
  6.216843025186325e-15, -4.894208534563084e-16,  8.876275264947139e-18,  2.222775815447148e-19, -1.573324949937815e-20,  1.981196407798049e+00,  1.584009614146451e-04,
 -1.375147722346621e-06,  1.065485931597410e-08,  4.964567075290378e-11, -5.903002982755432e-12,  1.129553749457961e-13,  2.496016359256962e-15, -1.945686003011600e-16,
  3.496006742745258e-18,  8.940218645128455e-20, -6.244297003642390e-21,  1.996441564994200e+00,  2.996983101369473e-05, -2.600406236466817e-07,  2.014817123843512e-09,
  9.196805409502084e-12, -1.105385654036088e-12,  2.110264236485865e-14,  4.702258506498687e-16, -3.646223171031111e-17,  6.518585110203726e-19,  1.685781769123303e-20,
 -1.169110586538445e-21,  6.787644974808230e-01,  1.127370654985918e-02, -1.132760371223763e-04,  1.442186336748168e-06, -1.178821034407996e-08, -5.875759310928167e-10,
  3.968768795307767e-11, -1.261255115690537e-12,  1.919537255675912e-14,  2.713841700596090e-16, -2.666134306879303e-17,  8.503693009955023e-19,  9.721042138290190e-01,
  8.576248226865535e-03, -7.871261342850646e-05,  8.038064036231023e-07, -2.836833892901673e-09, -3.897227513568413e-10,  1.873446636556870e-11, -4.067274188467220e-13,
 -1.193091418643961e-15,  4.138648987753402e-16, -1.454161318013483e-17,  1.786316951667345e-19,  1.187436481363942e+00,  6.717187358040551e-03, -5.963314590641471e-05,
  5.652387652588485e-07, -1.634412455807446e-09, -2.484627396241675e-10,  1.091923719680428e-11, -1.983820685223225e-13, -2.527691543930689e-15,  2.737394480590094e-16,
 -7.671668693781413e-18,  3.254751715219247e-20,  1.359200547247065e+00,  5.269596153917620e-03, -4.596327809299153e-05,  4.199103656467667e-07, -1.207501962028129e-09,
 -1.668514831104682e-10,  7.038515899233482e-12, -1.146637489634334e-13, -2.218051260505963e-15,  1.844471517471277e-16, -4.564812209238198e-18, -3.444595326942049e-21,
  1.500557519422733e+00,  4.093226806083859e-03, -3.531314673661330e-05,  3.156945108496144e-07, -9.451926530738283e-10, -1.150666061311192e-10,  4.747618218116160e-12,
 -7.178517163067081e-14, -1.736046826575606e-15,  1.271444821180795e-16, -2.900722109765965e-18, -1.233767298111687e-20,  1.618293183072277e+00,  3.120912532313847e-03,
 -2.672571137658068e-05,  2.355862489108267e-07, -7.383370522356302e-10, -7.993578288646552e-11,  3.255513592200050e-12, -4.663366770175341e-14, -1.300357355136670e-15,
  8.829550622829672e-17, -1.901657039291397e-18, -1.301751681664216e-20,  1.716455789957960e+00,  2.314324702581616e-03, -1.971422980012522e-05,  1.721053916852268e-07,
 -5.618270093980790e-10, -5.506212813719544e-11,  2.224720784457112e-12, -3.060355670765549e-14, -9.417822063292968e-16,  6.083404519932566e-17, -1.255708364804890e-18,
 -1.107798078936479e-20,  1.797672461163053e+00,  1.649309370547315e-03, -1.399528708067579e-05,  1.213386302713788e-07, -4.096986762352219e-10, -3.700731479626513e-11,
  1.487830571377501e-12, -1.984613209826664e-14, -6.558024642280585e-16,  4.091349710798407e-17, -8.179381315573429e-19, -8.463921593744484e-21,  1.863735878036204e+00,
  1.109717221759101e-03, -9.389753357706468e-06,  8.100305988544460e-08, -2.809616770114541e-10, -2.377706411711131e-11,  9.529529845923681e-13, -1.241682001022225e-14,
 -4.323371069392569e-16,  2.630991538535205e-17, -5.134252293499381e-19, -5.916377433485209e-21,  1.915902263566352e+00,  6.843951402306078e-04, -5.778849849375482e-06,
  4.967322679387238e-08, -1.758973506634174e-10, -1.415207606211365e-11,  5.660976245789248e-13, -7.247531403840516e-15, -2.621930642212567e-16,  1.567403621745946e-17,
 -3.004047756419308e-19, -3.729020233504846e-21,  1.955056461730296e+00,  3.655691135344183e-04, -3.082193284764853e-06,  2.642662989628893e-08, -9.501010660701543e-11,
 -7.364030577061469e-12,  2.942216305678398e-13, -3.719250257871708e-15, -1.382549591614765e-16,  8.162682789104951e-18, -1.544275493727898e-19, -2.016902009018413e-21,
  1.981808827578510e+00,  1.479167731182384e-04, -1.245904268589476e-06,  1.066474552160299e-08, -3.873455189313461e-11, -2.927517572582265e-12,  1.168864048573021e-13,
 -1.465129013677890e-15, -5.544363476539013e-17,  3.247045860544818e-18, -6.090378168753978e-20, -8.217694929245417e-22,  1.996557438352833e+00,  2.798723101966982e-05,
 -2.356131557927291e-07,  2.015032442642115e-09, -7.359306611826094e-12, -5.485946968564560e-13,  2.189637154126882e-14, -2.732091627453156e-16, -1.043861383853527e-17,
  6.086951855836729e-19, -1.136407081367439e-20, -1.560060425306646e-22, -2.009943653491789e+00,  6.632878593655911e-03, -2.249028084668175e-03,  8.078339786185102e-04,
 -3.059663803614808e-04,  1.208625094641431e-04, -4.885693788005211e-05,  1.967138226833361e-05, -7.615853297602951e-06,  2.704072698413270e-06, -8.202001618129757e-07,
  1.876516496552821e-07, -2.008241151772963e+00,  5.372278901229668e-03, -1.658396851942392e-03,  5.484056385787934e-04, -1.942976203628566e-04,  7.294319009499068e-05,
 -2.830268776394199e-05,  1.092647334287933e-05, -3.983156087672973e-06,  1.263436941145923e-06, -2.918870466896930e-07,  2.422316448656297e-08, -2.007342535290872e+00,
  4.727230622188191e-03, -1.383775340478643e-03,  4.382804602072054e-04, -1.505846605836077e-04,  5.543379468697827e-05, -2.122083645275266e-05,  8.075523291217138e-06,
 -2.871533478661757e-06,  8.602900792719458e-07, -1.637197152411873e-07, -7.897874420594890e-09, -2.006762287336973e+00,  4.318274485202853e-03, -1.219662788169729e-03,
  3.758869566566196e-04, -1.268850024466878e-04,  4.625599626366033e-05, -1.760330037709672e-05,  6.652746743212725e-06, -2.332752787398770e-06,  6.742275189963894e-07,
 -1.100843985363478e-07, -1.887745635110550e-08, -2.006352585285790e+00,  4.033116712509068e-03, -1.109908823794216e-03,  3.356453140212998e-04, -1.120257031980425e-04,
  4.061540742191698e-05, -1.541081558720897e-05,  5.801123429176100e-06, -2.015776608480898e-06,  5.682820698418292e-07, -8.177744054976675e-08, -2.356792546998032e-08,
 -2.006049061012020e+00,  3.823789274294312e-03, -1.031820240302569e-03,  3.077582266959512e-04, -1.019283363649926e-04,  3.683161363837954e-05, -1.395233187625065e-05,
  5.238857704425963e-06, -1.808885864175491e-06,  5.007503030667661e-07, -6.480867087768882e-08, -2.580569584883291e-08, -2.005818217961695e+00,  3.665689621191844e-03,
 -9.742466543391405e-04,  2.876011893873067e-04, -9.473278707362812e-05,  3.415885052055920e-05, -1.292760474237030e-05,  4.845745634057546e-06, -1.665408436578957e-06,
  4.547482303993693e-07, -5.381813936425746e-08, -2.693222539305957e-08, -2.005640648564653e+00,  3.544725728952191e-03, -9.310186446868455e-04,  2.726948980221485e-04,
 -8.946737804563211e-05,  3.221512092775109e-05, -1.218504234256826e-05,  4.561834680661725e-06, -1.562405416899417e-06,  4.221755129765908e-07, -4.635230880545341e-08,
 -2.750863518190277e-08, -2.005504304423539e+00,  3.452229399023648e-03, -8.984474639551534e-04,  2.615939654419748e-04, -8.557696967710547e-05,  3.078534373793614e-05,
 -1.164015719412745e-05,  4.353996030055218e-06, -1.487338471286694e-06,  3.986891597543393e-07, -4.114816690917120e-08, -2.779903410984659e-08, -2.005401377734376e+00,
  3.382624847444591e-03, -8.742147882030211e-04,  2.534082870148009e-04, -8.272507053457887e-05,  2.974057828360441e-05, -1.124267081304362e-05,  4.202635906124243e-06,
 -1.432853224660546e-06,  3.817812520313795e-07, -3.750156357511140e-08, -2.793827236876390e-08, -2.005326706681576e+00,  3.332247526473571e-03, -8.568251703032162e-04,
  2.475729124392016e-04, -8.070073005238849e-05,  2.900065848772817e-05, -1.096149031412701e-05,  4.095691453147714e-06, -1.394450670004262e-06,  3.699366890884225e-07,
 -3.499957577340083e-08, -2.799906807930308e-08, -2.005276904117024e+00,  3.298703676224508e-03, -8.453158731612874e-04,  2.437286499495328e-04, -7.937107754039485e-05,
  2.851539900380588e-05, -1.077722535396999e-05,  4.025664158535010e-06, -1.369347463100601e-06,  3.622272514908031e-07, -3.339527580370401e-08, -2.802172926794463e-08,
 -2.005249857696585e+00,  3.280505632205678e-03, -8.390952284078912e-04,  2.416568103403445e-04, -7.865577090110438e-05,  2.825458709134520e-05, -1.067823345003635e-05,
  3.988061857249309e-06, -1.355881974735614e-06,  3.581028487058658e-07, -3.254504836417436e-08, -2.802823485478818e-08, -2.002474729519405e+00,  1.505283189821024e-03,
 -3.262995497010090e-04,  7.118037738149913e-05, -1.562166283568464e-05,  3.448240097815799e-06, -7.653420570506010e-07,  1.707622813955448e-07, -3.829142202311289e-08,
  8.626540321441369e-09, -1.947586319793552e-09,  4.207687785098215e-10, -2.002328473047935e+00,  1.408264628403662e-03, -2.954959517274424e-04,  6.239025816097023e-05,
 -1.325464999394135e-05,  2.833291016560902e-06, -6.093517766118802e-07,  1.318496676468635e-07, -2.870118683673564e-08,  6.284350160718696e-09, -1.381035251845033e-09,
  2.914391936684529e-10, -2.002231296236705e+00,  1.344367278962994e-03, -2.759153346972054e-04,  5.700031305822246e-05, -1.185470451629237e-05,  2.482437180702911e-06,
 -5.234722988954095e-07,  1.111684028497256e-07, -2.377786852199021e-08,  5.122089057830771e-09, -1.108976401268161e-09,  2.311110791516679e-10, -2.002159372484033e+00,
  1.297364762835638e-03, -2.618724610484157e-04,  5.323192191864859e-05, -1.090034729732947e-05,  2.249136337955707e-06, -4.677421485999521e-07,  9.806268392681021e-08,
 -2.072895381209929e-08,  4.418098967352359e-09, -9.476197603573162e-10,  1.959808222112818e-10, -2.002103583149435e+00,  1.261075974115514e-03, -2.512404419209609e-04,
  5.043388781268141e-05, -1.020519517546246e-05,  2.082352663531567e-06, -4.286182968999001e-07,  8.902168192037509e-08, -1.866054170266327e-08,  3.948022681046360e-09,
 -8.414617403243724e-10,  1.731605504057382e-10, -2.002059290527572e+00,  1.232370950134434e-03, -2.429603372975442e-04,  4.828816516713520e-05, -9.680082953206587e-06,
  1.958193049068488e-06, -3.998993939920841e-07,  8.247343448152706e-08, -1.718127664653153e-08,  3.615799228683476e-09, -7.672489168354046e-10,  1.573539895106055e-10,
 -2.002023779901208e+00,  1.209424818085954e-03, -2.364242055116982e-04,  4.661525068713541e-05, -9.275582467070429e-06,  1.863654490493502e-06, -3.782727672781223e-07,
  7.759364435804303e-08, -1.608966169054334e-08,  3.372846793781100e-09, -7.134218510208482e-10,  1.459678316814517e-10, -2.001995325240525e+00,  1.191081414662239e-03,
 -2.312521609886147e-04,  4.530464617932133e-05, -8.961736849850461e-06,  1.790979676378326e-06, -3.617930226667356e-07,  7.390569220141990e-08, -1.527094058658431e-08,
  3.191899502773329e-09, -6.735827370902577e-10,  1.375840558919416e-10, -2.001972772029025e+00,  1.176569781635613e-03, -2.271939364981827e-04,  4.428449541390385e-05,
 -8.719324034641608e-06,  1.735257514601407e-06, -3.492448209005929e-07,  7.111566909649037e-08, -1.465523365617265e-08,  3.056553066397617e-09, -6.439258514394982e-10,
  1.313673807238532e-10, -2.001955325914412e+00,  1.165360862629873e-03, -2.240795648900222e-04,  4.350653390134138e-05, -8.535577914995995e-06,  1.693262974664560e-06,
 -3.398388860024931e-07,  6.903475183766048e-08, -1.419810985549284e-08,  2.956479672802958e-09, -6.220771636253534e-10,  1.268008500441752e-10, -2.001942436234318e+00,
  1.157088700738565e-03, -2.217924880590124e-04,  4.293796431700609e-05, -8.401903766117577e-06,  1.662844818284586e-06, -3.330534885660080e-07,  6.753921422517888e-08,
 -1.387069900509626e-08,  2.885021553831183e-09, -6.065174789945235e-10,  1.235557161670651e-10, -2.001933728221231e+00,  1.151504665546361e-03, -2.202540619340684e-04,
  4.255681783426348e-05, -8.312586762296771e-06,  1.642583046364887e-06, -3.285466902680833e-07,  6.654852231524143e-08, -1.365433196196892e-08,  2.837899819519713e-09,
 -5.962759497131913e-10,  1.214228985038725e-10, -2.001928961365122e+00,  1.148449434969034e-03, -2.194141895262010e-04,  4.234918354531861e-05, -8.264029491868026e-06,
  1.631588903203228e-06, -3.261056564588725e-07,  6.601281212260527e-08, -1.353750663570122e-08,  2.812490400910909e-09, -5.907597060650089e-10,  1.202751701094884e-10,
 -2.000982799898615e+00,  5.849693531791733e-04, -1.114102739010205e-04,  2.124705942636197e-05, -4.057336742878628e-06,  7.757807896480970e-07, -1.485182608383456e-07,
  2.846759055603364e-08, -5.463087304991550e-09,  1.049565742384802e-09, -2.016118860990637e-10,  3.743001537508884e-11, -2.000957085350005e+00,  5.683941551482305e-04,
 -1.067431048337995e-04,  2.007110735714943e-05, -3.778690402591936e-06,  7.122735113373124e-07, -1.344264302694265e-07,  2.540104902495918e-08, -4.805556833968221e-09,
  9.102044951487335e-10, -1.723949710823628e-10,  3.158927562077539e-11, -2.000938909855325e+00,  5.567201976113145e-04, -1.035071136199505e-04,  1.926861913875996e-05,
 -3.591557022362411e-06,  6.703029273489342e-07, -1.252621363935647e-07,  2.343865941911274e-08, -4.391501391524878e-09,  8.238468763112649e-10, -1.545767508211907e-10,
  2.807934442676499e-11, -2.000924857284028e+00,  5.477180080045147e-04, -1.010406399212004e-04,  1.866412086480317e-05, -3.452247191201012e-06,  6.394247132852108e-07,
 -1.185987598266087e-07,  2.202843983447444e-08, -4.097405113254915e-09,  7.632163929999999e-10, -1.422094345849514e-10,  2.566876201645422e-11, -2.000913587291296e+00,
  5.405132575305040e-04, -9.908480600933384e-05,  1.818921547246791e-05, -3.343816389563176e-06,  6.156126632240625e-07, -1.135073876339311e-07,  2.096073638340133e-08,
 -3.876752550764458e-09,  7.181343608112168e-10, -1.330947359310744e-10,  2.390656931883829e-11, -2.000904400497211e+00,  5.346500736268710e-04, -9.750509601159364e-05,
  1.780852768419494e-05, -3.257550072779261e-06,  5.968094229291826e-07, -1.095167271188270e-07,  2.012999489119404e-08, -3.706315189537764e-09,  6.835611543312744e-10,
 -1.261538100468906e-10,  2.257329301153889e-11, -2.000896877378740e+00,  5.298552363889892e-04, -9.622119892397698e-05,  1.750103961380386e-05, -3.188299837477213e-06,
  5.818071834252828e-07, -1.063519766094296e-07,  1.947511190043804e-08, -3.572747637342666e-09,  6.566239029498454e-10, -1.207765307474622e-10,  2.154573794074933e-11,
 -2.000890745153653e+00,  5.259512480642168e-04, -9.518114212027891e-05,  1.725321391607435e-05, -3.132767478110577e-06,  5.698367346695355e-07, -1.038392208223315e-07,
  1.895767033062880e-08, -3.467716361266535e-09,  6.355411386694212e-10, -1.165872250033917e-10,  2.074854912976047e-11, -2.000885817687169e+00,  5.228170926297300e-04,
 -9.434962106436976e-05,  1.705589507403123e-05, -3.088733320233960e-06,  5.603831509779668e-07, -1.018626903335740e-07,  1.855224651211616e-08, -3.385739502261622e-09,
  6.191481714521563e-10, -1.133417984210330e-10,  2.013304576942325e-11, -2.000881964686623e+00,  5.203681237996640e-04, -9.370202336980246e-05,  1.690272528316123e-05,
 -3.054662648604631e-06,  5.530920604977193e-07, -1.003431016944277e-07,  1.824151732315166e-08, -3.323101179339149e-09,  6.066596661193398e-10, -1.108765296186550e-10,
  1.966673640892040e-11, -2.000879094521989e+00,  5.185448517772934e-04, -9.322110091181762e-05,  1.678926393520522e-05, -3.029487485190238e-06,  5.477178311001679e-07,
 -9.922572540553640e-08,  1.801357522809126e-08, -3.277258221807539e-09,  5.975404887412125e-10, -1.090803466192037e-10,  1.932766794326824e-11, -2.000877144105795e+00,
  5.173063399896391e-04, -9.289501312036551e-05,  1.671247099373352e-05, -3.012478886500119e-06,  5.440933412119426e-07, -9.847344832817787e-08,  1.786037298567917e-08,
 -3.246497883969060e-09,  5.914315052989684e-10, -1.078789685742568e-10,  1.910120657821516e-11, -2.000876072513192e+00,  5.166260488363100e-04, -9.271610346002782e-05,
  1.667038599663556e-05, -3.003168082950978e-06,  5.421114232610832e-07, -9.806253964847154e-08,  1.777677983495488e-08, -3.229731289143593e-09,  5.881050490831241e-10,
 -1.072254392204395e-10,  1.897812561035561e-11, -2.000444208714659e+00,  2.621506872518295e-04, -4.726911072494872e-05,  8.525889876980474e-06, -1.538283592533998e-06,
  2.776297729226625e-07, -5.012185566644192e-08,  9.051451590190365e-09, -1.635073908478258e-09,  2.954400510604638e-10, -5.334475982948650e-11,  9.339148199317036e-12,
 -2.000438701064050e+00,  2.586415988234586e-04, -4.633107054831009e-05,  8.301760198508978e-06, -1.487961015667098e-06,  2.667694297657820e-07, -4.784133790259899e-08,
  8.582086895710309e-09, -1.539940705153932e-09,  2.763903892931554e-10, -4.957229182429027e-11,  8.624165179280394e-12, -2.000434708563389e+00,  2.561019763442607e-04,
 -4.565719166362907e-05,  8.141949909550736e-06, -1.452349226034618e-06,  2.591418249218706e-07, -4.625175375572605e-08,  8.257403806075564e-09, -1.474631299440461e-09,
  2.634119536100250e-10, -4.702155359679566e-11,  8.144142223107070e-12, -2.000431563498710e+00,  2.541038432316727e-04, -4.512995266842162e-05,  8.017620170323588e-06,
 -1.424800675261516e-06,  2.532747241847303e-07, -4.503599417908579e-08,  8.010485871372251e-09, -1.425245903498378e-09,  2.536535786866488e-10, -4.511447763952306e-11,
  7.787134696711445e-12, -2.000429003683153e+00,  2.524791174635773e-04, -4.470316469280630e-05,  7.917433283005648e-06, -1.402702282099602e-06,  2.485897094343504e-07,
 -4.406958252851418e-08,  7.815098289780219e-09, -1.386343499996271e-09,  2.460012461237343e-10, -4.362567518361006e-11,  7.509590260229338e-12, -2.000426891891250e+00,
  2.511398246799660e-04, -4.435265185965299e-05,  7.835457373749428e-06, -1.384687984249279e-06,  2.447847478010779e-07, -4.328761750691962e-08,  7.657586813365352e-09,
 -1.355098054533074e-09,  2.398776704488028e-10, -4.243864215918767e-11,  7.289052882335494e-12, -2.000425145467533e+00,  2.500329784361010e-04, -4.406385860320382e-05,
  7.768123817395578e-06, -1.369936891083254e-06,  2.416786069023275e-07, -4.265122342741537e-08,  7.529788903361573e-09, -1.329823910586188e-09,  2.349393502450971e-10,
 -4.148423479155847e-11,  7.112229098819611e-12, -2.000423710423733e+00,  2.491239734131206e-04, -4.382728428592255e-05,  7.713105539609313e-06, -1.357914387739495e-06,
  2.391534403455909e-07, -4.213516683477565e-08,  7.426417084411390e-09, -1.309431550965376e-09,  2.309647910312035e-10, -4.071797982452415e-11,  6.970589417149916e-12,
 -2.000422549754235e+00,  2.483890930773880e-04, -4.363642213158176e-05,  7.668810380674288e-06, -1.348255166092022e-06,  2.371288451920242e-07, -4.172226155925234e-08,
  7.343877019805115e-09, -1.293181874427656e-09,  2.278040683008562e-10, -4.010984402866711e-11,  6.858386711658016e-12, -2.000421637446456e+00,  2.478116685915465e-04,
 -4.348670210372277e-05,  7.634121172899541e-06, -1.340703210872270e-06,  2.355485529578107e-07, -4.140049924369791e-08,  7.279661622671274e-09, -1.280560310986490e-09,
  2.253530091854946e-10, -3.963900224016986e-11,  6.771643829847182e-12, -2.000420955138755e+00,  2.473799354211445e-04, -4.337490084966520e-05,  7.608250645380358e-06,
 -1.335078301425927e-06,  2.343730028556613e-07, -4.116144881015048e-08,  7.232013308211951e-09, -1.271206702063215e-09,  2.235388243319436e-10, -3.929092877614005e-11,
  6.707591385883471e-12, -2.000420490148935e+00,  2.470857689365970e-04, -4.329879363142187e-05,  7.590655849162756e-06, -1.331256261704581e-06,  2.335749652558394e-07,
 -4.099931387789094e-08,  7.199725242692861e-09, -1.264874075257320e-09,  2.223116692416094e-10, -3.905569111992162e-11,  6.664338323591607e-12, -2.000420234216395e+00,
  2.469238783549670e-04, -4.325693320954068e-05,  7.580983980444813e-06, -1.329156498206018e-06,  2.331367890513608e-07, -4.091034179010501e-08,  7.182017115126634e-09,
 -1.261402954322601e-09,  2.216394011505623e-10, -3.892689281580197e-11,  6.640668363070127e-12, -2.000211768007240e+00,  1.244968974491803e-04, -2.188502262931119e-05,
  3.847409299023211e-06, -6.764294802889548e-07,  1.189348793292049e-07, -2.091357819015540e-08,  3.677728503531451e-09, -6.467890559530442e-10,  1.137536771734218e-10,
 -1.998982926280718e-11,  3.410752902588664e-12, -2.000210488119982e+00,  1.236857532799894e-04, -2.167341348869329e-05,  3.798085217245825e-06, -6.656283274351665e-07,
  1.166617652375945e-07, -2.044819126823854e-08,  3.584353235521152e-09, -6.283416557714777e-10,  1.101535506147728e-10, -1.929499174816483e-11,  3.282201258993924e-12,
 -2.000209549544216e+00,  1.230913797814196e-04, -2.151891221734203e-05,  3.762203344240809e-06, -6.577995026354496e-07,  1.150202183037957e-07, -2.011334260089936e-08,
  3.517416259280653e-09, -6.151661528113562e-10,  1.075917444208453e-10, -1.880236936700721e-11,  3.191374644607216e-12, -2.000208803717540e+00,  1.226193465334626e-04,
 -2.139654800261731e-05,  3.733863705762247e-06, -6.516334452513001e-07,  1.137309195462610e-07, -1.985107978827518e-08,  3.465135569765092e-09, -6.049042225798916e-10,
  1.056020112461528e-10, -1.842081633900102e-11,  3.121209109805637e-12, -2.000208192424461e+00,  1.222326428778446e-04, -2.129652531933784e-05,  3.710750112691848e-06,
 -6.466157254233211e-07,  1.126840881498288e-07, -1.963861656573227e-08,  3.422877247341731e-09, -5.966281514582465e-10,  1.040009242268775e-10, -1.811447545336289e-11,
  3.064992248684542e-12, -2.000207685223033e+00,  1.219119129160141e-04, -2.121371856966568e-05,  3.691650108270939e-06, -6.424769788951024e-07,  1.118222317667624e-07,
 -1.946401917851232e-08,  3.388214537949404e-09, -5.898521817805786e-10,  1.026924649534238e-10, -1.786458318421398e-11,  3.019212985619151e-12, -2.000207263781006e+00,
  1.216454995899772e-04, -2.114503989866523e-05,  3.675833124614494e-06, -6.390548888235764e-07,  1.111107075849435e-07, -1.932009789460690e-08,  3.359685770629036e-09,
 -5.842838376281341e-10,  1.016188461282728e-10, -1.765985290219422e-11,  2.981760517730208e-12, -2.000206916121914e+00,  1.214257870099422e-04, -2.108847157312946e-05,
  3.662821753047210e-06, -6.362433915177381e-07,  1.105268825364439e-07, -1.920215672658157e-08,  3.336336595874322e-09, -5.797322418644030e-10,  1.007423742006880e-10,
 -1.749292696766338e-11,  2.951259686377728e-12, -2.000206634033109e+00,  1.212475526006116e-04, -2.104262982790480e-05,  3.652288595972875e-06, -6.339697603377872e-07,
  1.100552409651586e-07, -1.910697746006973e-08,  3.317513249625870e-09, -5.760666992217138e-10,  1.000372542236278e-10, -1.735877337986145e-11,  2.926770585060204e-12,
 -2.000206411738522e+00,  1.211071232190042e-04, -2.100654141346707e-05,  3.644003401402132e-06, -6.321828567741527e-07,  1.096848756283455e-07, -1.903229849079495e-08,
  3.302756482427036e-09, -5.731954430303706e-10,  9.948538401075717e-11, -1.725386286363956e-11,  2.907634380548111e-12, -2.000206245158671e+00,  1.210019046246589e-04,
 -2.097951896216715e-05,  3.637803567814822e-06, -6.308465737499093e-07,  1.094080872158996e-07, -1.897652387318927e-08,  3.291742335993366e-09, -5.710537678453852e-10,
  9.907400561812709e-11, -1.717570936655980e-11,  2.893387225983399e-12, -2.000206131474258e+00,  1.209301039744679e-04, -2.096108747089354e-05,  3.633576743769601e-06,
 -6.299359672173433e-07,  1.092195580364061e-07, -1.893855165097905e-08,  3.284247200722336e-09, -5.695970280282335e-10,  9.879431992876254e-11, -1.712259903152895e-11,
  2.883709492720878e-12, -2.000206068846082e+00,  1.208905517942863e-04, -2.095093722487043e-05,  3.631249706117743e-06, -6.294347880416871e-07,  1.091158257428338e-07,
 -1.891766471120423e-08,  3.280125637294001e-09, -5.687962012838278e-10,  9.864061022177102e-11, -1.709341901710373e-11,  2.878393752843827e-12, -2.000103456943553e+00,
  6.071076887600515e-05, -1.054204098921374e-05,  1.830592903762367e-06, -3.178827299469526e-07,  5.520140835275947e-08, -9.586088298615757e-09,  1.664718109389673e-09,
 -2.890997031446811e-10,  5.020550688851688e-11, -8.711464662938944e-12,  1.468642393315858e-12, -2.000103148155426e+00,  6.051556615298164e-05, -1.049171603959196e-05,
  1.819002308318242e-06, -3.153749988777736e-07,  5.468000647486564e-08, -9.480628521930902e-09,  1.643815095582278e-09, -2.850202590565639e-10,  4.941907918554853e-11,
 -8.561527388758249e-12,  1.441219149900745e-12, -2.000102920454724e+00,  6.037167793591403e-05, -1.045468624624908e-05,  1.810489085029742e-06, -3.135364042362008e-07,
  5.429842052320822e-08, -9.403587845310115e-09,  1.628572649984073e-09, -2.820509288523144e-10,  4.884769575749630e-11, -8.452786537101309e-12,  1.421364345292382e-12,
 -2.000102738751360e+00,  6.025688944848161e-05, -1.042518537414378e-05,  1.803716070015659e-06, -3.120756539326552e-07,  5.399567125711053e-08, -9.342548367462486e-09,
  1.616512716350553e-09, -2.797048208283956e-10,  4.839686210720135e-11, -8.367105820917274e-12,  1.405740231957999e-12, -2.000102589316849e+00,  6.016250841220382e-05,
 -1.040095590565501e-05,  1.798159471810516e-06, -3.108785853482426e-07,  5.374784838418823e-08, -9.292638787698658e-09,  1.606662798036598e-09, -2.777907841978457e-10,
  4.802946714313792e-11, -8.297360228786124e-12,  1.393035181311548e-12, -2.000102464979972e+00,  6.008399391768116e-05, -1.038081801666244e-05,  1.793545443749758e-06,
 -3.098854920580857e-07,  5.354244311383674e-08, -9.251309963775302e-09,  1.598513867077354e-09, -2.762087452402170e-10,  4.772607855389609e-11, -8.239818379461185e-12,
  1.382562214678381e-12, -2.000102361425342e+00,  6.001861322583043e-05, -1.036406146993833e-05,  1.789709089967358e-06, -3.090604136695111e-07,  5.337192007209468e-08,
 -9.217026023341886e-09,  1.591759190759373e-09, -2.748983949516274e-10,  4.747498472157628e-11, -8.192231324440197e-12,  1.373907276228038e-12, -2.000102275835116e+00,
  5.996458183483981e-05, -1.035022237010972e-05,  1.786542687162508e-06, -3.083798542371967e-07,  5.323135515095500e-08, -9.188783233343406e-09,  1.586198298760347e-09,
 -2.738203161075181e-10,  4.726853105247994e-11, -8.153129209727084e-12,  1.366799762182693e-12, -2.000102206277652e+00,  5.992067641594207e-05, -1.033898264965306e-05,
  1.783972365294603e-06, -3.078276999845953e-07,  5.311737109097071e-08, -9.165893140140001e-09,  1.581693687552474e-09, -2.729474725355893e-10,  4.710146747382086e-11,
 -8.121503965376484e-12,  1.361054098840866e-12, -2.000102151394691e+00,  5.988603674638461e-05, -1.033011862134029e-05,  1.781946168815133e-06, -3.073926167236310e-07,
  5.302759228219880e-08, -9.147871469175299e-09,  1.578148634947796e-09, -2.722608472216993e-10,  4.697010134293688e-11, -8.096646620987047e-12,  1.356539785219894e-12,
 -2.000102110227058e+00,  5.986005534090479e-05, -1.032347230421025e-05,  1.780427401316614e-06, -3.070665987493526e-07,  5.296034072549319e-08, -9.134376157528142e-09,
  1.575494823921981e-09, -2.717470086575894e-10,  4.687182475998668e-11, -8.078056514066333e-12,  1.353164672478683e-12, -2.000102082111896e+00,  5.984231238084216e-05,
 -1.031893451598812e-05,  1.779390700784747e-06, -3.068441130165630e-07,  5.291445670178407e-08, -9.125170800649112e-09,  1.573685041623481e-09, -2.713966750783334e-10,
  4.680483568447704e-11, -8.065387720811106e-12,  1.350865098019115e-12, -2.000102066616519e+00,  5.983253383630525e-05, -1.031643400228028e-05,  1.778819518580212e-06,
 -3.067215499329469e-07,  5.288918379840138e-08, -9.120101238863032e-09,  1.572688507158010e-09, -2.712037964911112e-10,  4.676795978804570e-11, -8.058414867033284e-12,
  1.349599594009629e-12, -2.000051139974627e+00,  2.998334812548185e-05, -5.175107138164673e-06,  8.932243935631737e-07, -1.541713991382808e-07,  2.661025638965898e-08,
 -4.592998545088028e-09,  7.927669719228830e-10, -1.368347696625867e-10,  2.361775250655697e-11, -4.073048856536643e-12,  6.826950196321396e-13, -2.000051064121366e+00,
  2.993545637059459e-05, -5.162832009060566e-06,  8.904138592870365e-07, -1.535669059634099e-07,  2.648531622093226e-08, -4.567877987854390e-09,  7.878174962760970e-10,
 -1.358745851468644e-10,  2.343375477970207e-11, -4.038177340784361e-12,  6.763526989888144e-13, -2.000051008035077e+00,  2.990005159084120e-05, -5.153765417128412e-06,
  8.883398065950914e-07, -1.531212153068111e-07,  2.639328089539656e-08, -4.549389920426061e-09,  7.841780874909776e-10, -1.351691851359850e-10,  2.329870241325149e-11,
 -4.012604966673128e-12,  6.717055862633796e-13, -2.000050963185791e+00,  2.987174428620210e-05, -5.146521268212443e-06,  8.866837819168223e-07, -1.527655978625270e-07,
  2.631989611961856e-08, -4.534658505242568e-09,  7.812801761148235e-10, -1.346078905161617e-10,  2.319131367708759e-11, -3.992284676285420e-12,  6.680152749993801e-13,
 -2.000050926239395e+00,  2.984842771751194e-05, -5.140557570049338e-06,  8.853212242323959e-07, -1.524731624137516e-07,  2.625958306291801e-08, -4.522557874855948e-09,
  7.789011092941861e-10, -1.341473473395035e-10,  2.310325013636191e-11, -3.975630380280022e-12,  6.649923079965240e-13, -2.000050895455482e+00,  2.982900210897335e-05,
 -5.135591319580038e-06,  8.841870783812733e-07, -1.522298611740448e-07,  2.620942675196205e-08, -4.512499634627236e-09,  7.769245023456762e-10, -1.337648894203797e-10,
  2.303015152810023e-11, -3.961812552585860e-12,  6.624852757552005e-13, -2.000050869787290e+00,  2.981280597700460e-05, -5.131452266370918e-06,  8.832422010500122e-07,
 -1.520272402152437e-07,  2.616767267595264e-08, -4.504129577720333e-09,  7.752802828951636e-10, -1.334468681540019e-10,  2.296939195702800e-11, -3.950331566514623e-12,
  6.604029744261453e-13, -2.000050848551585e+00,  2.979940755148922e-05, -5.128029266143855e-06,  8.824610347426289e-07, -1.518597790526126e-07,  2.613317498244531e-08,
 -4.497216348735860e-09,  7.739226772773682e-10, -1.331843669372707e-10,  2.291925577937104e-11, -3.940860962001286e-12,  6.586858066458090e-13, -2.000050831280161e+00,
  2.978851093872774e-05, -5.125246142171976e-06,  8.818260607486699e-07, -1.517236932081000e-07,  2.610514807647478e-08, -4.491601317003618e-09,  7.728202979658087e-10,
 -1.329712711266523e-10,  2.287856640386523e-11, -3.933176840203407e-12,  6.572928964700432e-13, -2.000050817643869e+00,  2.977990812406285e-05, -5.123049336793171e-06,
  8.813249610919132e-07, -1.516163214800436e-07,  2.608303949696248e-08, -4.487172920078173e-09,  7.719510693584232e-10, -1.328032799345100e-10,  2.284649623005639e-11,
 -3.927121707819949e-12,  6.561954904679288e-13, -2.000050807410317e+00,  2.977345223601867e-05, -5.121401032178206e-06,  8.809490372988599e-07, -1.515357845202114e-07,
  2.606645907375461e-08, -4.483852364457709e-09,  7.712993994438638e-10, -1.326773556107588e-10,  2.282246068793482e-11, -3.922584318180166e-12,  6.553732781219308e-13,
 -2.000050800418922e+00,  2.976904178668443e-05, -5.120275095052817e-06,  8.806922782080567e-07, -1.514807835402463e-07,  2.605513715796877e-08, -4.481585194090757e-09,
  7.708545119930376e-10, -1.325913986187740e-10,  2.280605574849113e-11, -3.919487782043545e-12,  6.548122215952241e-13, -2.000050796564834e+00,  2.976661051299880e-05,
 -5.119654463927584e-06,  8.805507596649322e-07, -1.514504707476123e-07,  2.604889774975414e-08, -4.480335868657230e-09,  7.706093746217075e-10, -1.325440389637164e-10,
  2.279701779869529e-11, -3.917781937033875e-12,  6.545031634731009e-13, -2.000025425067852e+00,  1.490015635916747e-05, -2.564077470287538e-06,  4.412370380949137e-07,
 -7.592997892036463e-08,  1.306637440716432e-08, -2.248523430001419e-09,  3.869369702367330e-10, -6.658604517863057e-11,  1.145819196406593e-11, -1.970110841695457e-12,
  3.292768570617608e-13, -2.000025406269260e+00,  1.488829470416231e-05, -2.561045997785316e-06,  4.405449732452834e-07, -7.578156521817670e-08,  1.303578957367840e-08,
 -2.242392130676731e-09,  3.857324892058521e-10, -6.635306895228304e-11,  1.141367919930256e-11, -1.961699551905630e-12,  3.277512631234602e-13, -2.000025392350800e+00,
  1.487951316348931e-05, -2.558802693816600e-06,  4.400330693796443e-07, -7.567183608752305e-08,  1.301318689223330e-08, -2.237863029574069e-09,  3.848431550991876e-10,
 -6.618112695838329e-11,  1.138084244347019e-11, -1.955497372070967e-12,  3.266268164679644e-13, -2.000025381209483e+00,  1.487248430048713e-05, -2.557007727990528e-06,
  4.396236120020097e-07, -7.558409684864473e-08,  1.299512000984816e-08, -2.234244047586381e-09,  3.841327756387792e-10, -6.604383080351682e-11,  1.135463120101787e-11,
 -1.950548305831422e-12,  3.257298451509282e-13, -2.000025372023725e+00,  1.486668950058709e-05, -2.555528310173414e-06,  4.392862287840394e-07, -7.551182181911339e-08,
  1.298024158226233e-08, -2.231264574201563e-09,  3.835480896658571e-10, -6.593085906976341e-11,  1.133306974121309e-11, -1.946478314823116e-12,  3.249923895749428e-13,
 -2.000025364364823e+00,  1.486185814327853e-05, -2.554295139560335e-06,  4.390050669055943e-07, -7.545160449010344e-08,  1.296784818682498e-08, -2.228783311544164e-09,
  3.830612838006742e-10, -6.583682119959452e-11,  1.131512608183633e-11, -1.943092005809897e-12,  3.243789447684240e-13, -2.000025357975013e+00,  1.485782751088285e-05,
 -2.553266542864964e-06,  4.387705924622680e-07, -7.540139597631327e-08,  1.295751669985066e-08, -2.226715257752240e-09,  3.826556245219717e-10, -6.575847374476647e-11,
  1.130017923353481e-11, -1.940271791897949e-12,  3.238681422928917e-13, -2.000025352686093e+00,  1.485449142040701e-05, -2.552415323464745e-06,  4.385765829627819e-07,
 -7.535985892341233e-08,  1.294897091699377e-08, -2.225004921524929e-09,  3.823201869651140e-10, -6.569369899318715e-11,  1.128782371178918e-11, -1.937940887788177e-12,
  3.234460275190094e-13, -2.000025348382819e+00,  1.485177711951660e-05, -2.551722846030357e-06,  4.384187744209446e-07, -7.532607684406851e-08,  1.294202154374929e-08,
 -2.223614270005432e-09,  3.820474829606000e-10, -6.564104533102264e-11,  1.127778155675357e-11, -1.936046654385732e-12,  3.231030335967960e-13, -2.000025344984187e+00,
  1.484963347153415e-05, -2.551176011297216e-06,  4.382941694056901e-07, -7.529940544646629e-08,  1.293653549913133e-08, -2.222516563408583e-09,  3.818322475529417e-10,
 -6.559949207894191e-11,  1.126985731711825e-11, -1.934552076303320e-12,  3.228324329536571e-13, -2.000025342433014e+00,  1.484802437540802e-05, -2.550765571150242e-06,
  4.382006516334723e-07, -7.527938982124652e-08,  1.293241881619476e-08, -2.221692920382691e-09,  3.816707629494473e-10, -6.556831847090321e-11,  1.126391296801202e-11,
 -1.933431013032424e-12,  3.226294744077434e-13, -2.000025340689788e+00,  1.484692488751073e-05, -2.550485135517168e-06,  4.381367587969436e-07, -7.526571562718260e-08,
  1.292960656236431e-08, -2.221130293315930e-09,  3.815604599796317e-10, -6.554702641295634e-11,  1.125985312381938e-11, -1.932665399175428e-12,  3.224908744206330e-13,
 -2.000025339728709e+00,  1.484631871971943e-05, -2.550330531850257e-06,  4.381015360840275e-07, -7.525817762335361e-08,  1.292805634325716e-08, -2.220820163779030e-09,
  3.814996613697127e-10, -6.553529073950837e-11,  1.125761551749735e-11, -1.932243442263081e-12,  3.224144896964129e-13, -2.000012676574932e+00,  7.427381778037232e-06,
 -1.276231101093838e-06,  2.192921194868722e-07, -3.768051685064461e-08,  6.474568087315288e-09, -1.112512445490541e-09,  1.911609013010787e-10, -3.284680066750654e-11,
  5.643865788319654e-12, -9.689551610694004e-13,  1.617191637871532e-13, -2.000012671895675e+00,  7.424430132130161e-06, -1.275477838562353e-06,  2.191204048967828e-07,
 -3.764374635556181e-08,  6.467001583453146e-09, -1.110997822948404e-09,  1.908637935495199e-10, -3.278941713807856e-11,  5.632918121084539e-12, -9.668894795162333e-13,
  1.613450162262563e-13, -2.000012668428842e+00,  7.422243376785428e-06, -1.274919899208343e-06,  2.189932445924288e-07, -3.761652265394161e-08,  6.461400834679737e-09,
 -1.109876945149619e-09,  1.906439717425374e-10, -3.274697014460818e-11,  5.624821866875915e-12, -9.653621625601868e-13,  1.610684380038236e-13, -2.000012665652322e+00,
  7.420492109501707e-06, -1.274473147551516e-06,  2.188914424438850e-07, -3.759473158813335e-08,  6.456918511681659e-09, -1.108980051401540e-09,  1.904681068619782e-10,
 -3.271301693265388e-11,  5.618346809238721e-12, -9.641408845220905e-13,  1.608473150482947e-13, -2.000012663362196e+00,  7.419047671933089e-06, -1.274104719055391e-06,
  2.188074995192990e-07, -3.757676583218499e-08,  6.453223550127476e-09, -1.108240808002229e-09,  1.903231745495257e-10, -3.268503958243430e-11,  5.613012121999304e-12,
 -9.631348341510663e-13,  1.606651845820877e-13, -2.000012661452076e+00,  7.417842942778392e-06, -1.273797467073197e-06,  2.187375030839300e-07, -3.756178667166920e-08,
  6.450143186715370e-09, -1.107624596945790e-09,  1.902023772520682e-10, -3.266172387910065e-11,  5.608566824344423e-12, -9.622966069389004e-13,  1.605134523405572e-13,
 -2.000012659858009e+00,  7.416837570628040e-06, -1.273541082964967e-06,  2.186791006554972e-07, -3.754928981274214e-08,  6.447573538462055e-09, -1.107110601235387e-09,
  1.901016271522219e-10, -3.264227945742271e-11,  5.604859969344337e-12, -9.615976910387634e-13,  1.603869489876082e-13, -2.000012658538266e+00,  7.416005227534132e-06,
 -1.273328840383574e-06,  2.186307571795406e-07, -3.753894617621730e-08,  6.445446813086946e-09, -1.106685235461504e-09,  1.900182563797101e-10, -3.262619047225682e-11,
  5.601793034860691e-12, -9.610194761847486e-13,  1.602823002647305e-13, -2.000012657464260e+00,  7.415327876744462e-06, -1.273156131071689e-06,  2.185914209430497e-07,
 -3.753053029161598e-08,  6.443716560656522e-09, -1.106339190840792e-09,  1.899504368343929e-10, -3.261310343985514e-11,  5.599298506167746e-12, -9.605492088142804e-13,
  1.601971937320673e-13, -2.000012656615900e+00,  7.414792841654046e-06, -1.273019716152456e-06,  2.185603527358325e-07, -3.752388367940505e-08,  6.442350131321890e-09,
 -1.106065924005045e-09,  1.898968834647276e-10, -3.260276987422392e-11,  5.597328921637106e-12, -9.601779231689986e-13,  1.601300037044691e-13, -2.000012655979004e+00,
  7.414391173599348e-06, -1.272917309184996e-06,  2.185370307102801e-07, -3.751889445790446e-08,  6.441324474770014e-09, -1.105860815329808e-09,  1.898566890032839e-10,
 -3.259501433644217e-11,  5.595850771168642e-12, -9.598992888811297e-13,  1.600795823284652e-13, -2.000012655543772e+00,  7.414116689909595e-06, -1.272847330431603e-06,
  2.185210943079441e-07, -3.751548532385813e-08,  6.440623664428781e-09, -1.105720672846011e-09,  1.898292265566860e-10, -3.258971560198135e-11,  5.594840899680790e-12,
 -9.597089316827459e-13,  1.600451364304771e-13, -2.000012655303806e+00,  7.413965353080168e-06, -1.272808748285333e-06,  2.185123080796552e-07, -3.751360579819088e-08,
  6.440237300427301e-09, -1.105643412272668e-09,  1.898140867859039e-10, -3.258679451703714e-11,  5.594284188302908e-12, -9.596039954953975e-13,  1.600261481352410e-13,
 -2.000006329331286e+00,  3.708039458494695e-06, -6.366712309990425e-07,  1.093166051949914e-07, -1.876968904630483e-08,  3.222760637205866e-09, -5.533489041410457e-10,
  9.501016667562958e-11, -1.631326262707543e-11,  2.800922714590913e-12, -4.805136837918793e-13,  8.014170508388866e-14, -2.000006328164008e+00,  3.707303259180364e-06,
 -6.364834874776407e-07,  1.092738380508593e-07, -1.876053768411013e-08,  3.220878877842763e-09, -5.529724991210348e-10,  9.493638527958346e-11, -1.629902289414083e-11,
  2.798208039884200e-12, -4.800018341130440e-13,  8.004905954840195e-14, -2.000006327298891e+00,  3.706757644307508e-06, -6.363443615301095e-07,  1.092421492844070e-07,
 -1.875375763966849e-08,  3.219484878735938e-09, -5.526936910302004e-10,  9.488174054093997e-11, -1.628847769408427e-11,  2.796197918597414e-12, -4.796228695669982e-13,
  7.998047357290079e-14, -2.000006326605858e+00,  3.706320568137144e-06, -6.362329211574164e-07,  1.092167686261235e-07, -1.874832772420980e-08,  3.218368565878578e-09,
 -5.524704409288526e-10,  9.483798858440642e-11, -1.628003527776195e-11,  2.794588766797646e-12, -4.793195249487738e-13,  7.992557787747297e-14, -2.000006326034113e+00,
  3.705959989662497e-06, -6.361409915114945e-07,  1.091958329986459e-07, -1.874384908460184e-08,  3.217447885550295e-09, -5.522863279284106e-10,  9.480190911830801e-11,
 -1.627307383580141e-11,  2.793261985709112e-12, -4.790694279451293e-13,  7.988032123949961e-14, -2.000006325557157e+00,  3.705659194878365e-06, -6.360643080839236e-07,
  1.091783704715800e-07, -1.874011363992350e-08,  3.216680029008237e-09, -5.521327846939958e-10,  9.477182194979645e-11, -1.626726892703238e-11,  2.792155692011398e-12,
 -4.788609045779750e-13,  7.984258964571352e-14, -2.000006325159062e+00,  3.705408136708211e-06, -6.360003073332361e-07,  1.091637967679432e-07, -1.873699629858910e-08,
  3.216039260285731e-09, -5.520046605301525e-10,  9.474671691619808e-11, -1.626242548610329e-11,  2.791232678271827e-12, -4.786869356609448e-13,  7.981111197592062e-14,
 -2.000006324829437e+00,  3.705200260257430e-06, -6.359473167197471e-07,  1.091517306771302e-07, -1.873441544289411e-08,  3.215508787213805e-09, -5.518985946408520e-10,
  9.472593487775286e-11, -1.625841622832353e-11,  2.790468665226490e-12, -4.785429408062207e-13,  7.978505874022100e-14, -2.000006324561161e+00,  3.705031075173493e-06,
 -6.359041904680895e-07,  1.091419110453312e-07, -1.873231515838621e-08,  3.215077105636716e-09, -5.518122845331298e-10,  9.470902424707212e-11, -1.625515394725618e-11,
  2.789847018139985e-12, -4.784257817420723e-13,  7.976386160052819e-14, -2.000006324349233e+00,  3.704897425700524e-06, -6.358701233310415e-07,  1.091341543316205e-07,
 -1.873065614734188e-08,  3.214736130093459e-09, -5.517441119219789e-10,  9.469566762547949e-11, -1.625257734883984e-11,  2.789356044919779e-12, -4.783332526321180e-13,
  7.974712107645074e-14, -2.000006324190120e+00,  3.704797084216362e-06, -6.358445468841715e-07,  1.091283309727605e-07, -1.872941066879343e-08,  3.214480152842489e-09,
 -5.516929344032441e-10,  9.468564094743107e-11, -1.625064316241480e-11,  2.788987491413891e-12, -4.782637962256373e-13,  7.973455514443369e-14, -2.000006324081384e+00,
  3.704728511688734e-06, -6.358270684078225e-07,  1.091243514538383e-07, -1.872855955641441e-08,  3.214305230353257e-09, -5.516579626729647e-10,  9.467878940145374e-11,
 -1.624932149115397e-11,  2.788735654567850e-12, -4.782163365604190e-13,  7.972596894253226e-14, -2.000006324021431e+00,  3.704690703046123e-06, -6.358174314369782e-07,
  1.091221573177778e-07, -1.872809029388232e-08,  3.214208787376817e-09, -5.516386812955382e-10,  9.467501189261740e-11, -1.624859281201858e-11,  2.788596810242483e-12,
 -4.781901710310910e-13,  7.972123522661097e-14, -2.000003162430776e+00,  1.852609692465287e-06, -3.179754789891315e-07,  5.457620537477532e-08, -9.367270256491569e-09,
  1.607765747555147e-09, -2.759513362036755e-10,  4.736333004040589e-11, -8.129272038443208e-12,  1.395245510933698e-12, -2.392734086768048e-13,  3.989285383157096e-14,
 -2.000003162139273e+00,  1.852425856108835e-06, -3.179286143998727e-07,  5.456553370223763e-08, -9.364987551647558e-09,  1.607296535064996e-09, -2.758575147489987e-10,
  4.734494626187470e-11, -8.125725286403453e-12,  1.394569602565609e-12, -2.391460131634402e-13,  3.986980294253504e-14, -2.000003161923192e+00,  1.852289586339652e-06,
 -3.178938776538485e-07,  5.455762413407504e-08, -9.363295763763098e-09,  1.606948805567815e-09, -2.757879883205509e-10,  4.733132371505133e-11, -8.123097257623532e-12,
  1.394068804238301e-12, -2.390516277172968e-13,  3.985272577140080e-14, -2.000003161750071e+00,  1.852180409697426e-06, -3.178660484297672e-07,  5.455128767977480e-08,
 -9.361940509007485e-09,  1.606670258866317e-09, -2.757322969579035e-10,  4.732041238591924e-11, -8.120992360484753e-12,  1.393667711275562e-12, -2.389760369607728e-13,
  3.983904967278205e-14, -2.000003161607232e+00,  1.852090331326221e-06, -3.178430881553579e-07,  5.454606001992974e-08, -9.360822444319010e-09,  1.606440470012499e-09,
 -2.756863556121102e-10,  4.731141164120366e-11, -8.119256093217402e-12,  1.393336873072909e-12, -2.389136887100264e-13,  3.982776981280804e-14, -2.000003161488065e+00,
  1.852015180989375e-06, -3.178239334623631e-07,  5.454169895015933e-08, -9.359889748160770e-09,  1.606248784304613e-09, -2.756480332746653e-10,  4.730390381490409e-11,
 -8.117807855550490e-12,  1.393060925612729e-12, -2.388616864091641e-13,  3.981836196451649e-14, -2.000003161388594e+00,  1.851952452000715e-06, -3.178079451620340e-07,
  5.453805887976376e-08, -9.359111269808654e-09,  1.606088796945700e-09, -2.756160489269151e-10,  4.729763783080032e-11, -8.116599194655673e-12,  1.392830632689606e-12,
 -2.388182887453017e-13,  3.981051097597603e-14, -2.000003161306227e+00,  1.851900509014883e-06, -3.177947062469808e-07,  5.453504482409728e-08, -9.358466686016970e-09,
  1.605956329291233e-09, -2.755895667914219e-10,  4.729244987682729e-11, -8.115598497618575e-12,  1.392639968096248e-12, -2.387823595771574e-13,  3.980401122015071e-14,
 -2.000003161239186e+00,  1.851858231793149e-06, -3.177839310574350e-07,  5.453259171582909e-08, -9.357942074616540e-09,  1.605848518788358e-09, -2.755680143187850e-10,
  4.728822773242595e-11, -8.114784107589428e-12,  1.392484803458932e-12, -2.387531205609942e-13,  3.979872182552254e-14, -2.000003161186224e+00,  1.851824833067842e-06,
 -3.177754188393195e-07,  5.453065382700609e-08, -9.357527651321056e-09,  1.605763353662912e-09, -2.755509891236808e-10,  4.728489252883178e-11, -8.114140803984016e-12,
  1.392362237305169e-12, -2.387300246628725e-13,  3.979454378434115e-14, -2.000003161146460e+00,  1.851799757124444e-06, -3.177690278839597e-07,  5.452919887888795e-08,
 -9.357216509492108e-09,  1.605699413812902e-09, -2.755382071624004e-10,  4.728238859225280e-11, -8.113657842461016e-12,  1.392270221447854e-12, -2.387126857220554e-13,
  3.979140720491835e-14, -2.000003161119285e+00,  1.851782620033125e-06, -3.177646602878037e-07,  5.452820457067211e-08, -9.357003877436244e-09,  1.605655718106768e-09,
 -2.755294721916743e-10,  4.728067745799575e-11, -8.113327799786730e-12,  1.392207340794517e-12, -2.387008369389614e-13,  3.978926379869194e-14, -2.000003161104301e+00,
  1.851773171063393e-06, -3.177622521139052e-07,  5.452765633864732e-08, -9.356886638975765e-09,  1.605631625814550e-09, -2.755246560549985e-10,  4.727973400683499e-11,
 -8.113145828267199e-12,  1.392172671232406e-12, -2.386943040834150e-13,  3.978808203154272e-14,     0.995557314790591,     0.999159213798331,     0.989024683411614,
     0.979465630863655,     0.966733620856341,     0.950616529447658,     0.930813806982891,     0.906897721500746,      0.87824374933809,     0.843894415190319,
     0.802256468169935,      0.75027475541071,     0.680123896047494,     0.997783957166272,     0.999580607150412,     0.994525499777354,     0.989757614966182,
     0.983407384809772,     0.975369262955455,     0.965493720245837,     0.953567977791808,     0.939281404929805,     0.922157840464039,     0.901405082023728,
     0.875504298070052,     0.840565789358763,     0.998893161973128,     0.999790527232184,     0.997265680534825,     0.994884310356881,     0.991712650243733,
      0.98769801097126,     0.982765747424269,     0.976809640969453,     0.969674626840625,     0.961123010188631,     0.950759333562965,     0.937825416047395,
     0.920379557360392,      0.99944686299509,     0.999895316951144,     0.998633537791771,     0.997443462534692,     0.995858448102998,     0.993852166503619,
     0.991387318726469,      0.98841082895934,     0.984845213707688,     0.980571700405791,     0.975392684622089,     0.968929313379074,     0.960211341233751,
     0.999723500443421,     0.999947671519419,     0.999316939322954,     0.998722050407696,     0.997929741671221,     0.996926852783705,     0.995694739431771,
     0.994206871091019,     0.992424516778723,     0.990288306688609,     0.987699465963561,     0.984468620428014,     0.980110780834974,      0.99986176727306,
     0.999973838986193,     0.999658511797752,     0.999361104072531,     0.998964998677724,     0.998463616307285,     0.997847636020713,      0.99710379428536,
      0.99621272813281,     0.995144756523511,     0.993850498448911,     0.992235279110527,     0.990056635292537,     0.999930887876778,      0.99998692029551,
     0.999829266375522,     0.999680571641572,     0.999482531108594,     0.999231855331243,     0.998923884133404,     0.998551986167147,     0.998106480558793,
     0.997572527723909,     0.996925438713313,     0.996117879106716,     0.995028624917018,      0.99996544499566,     0.999993460347839,     0.999914635799829,
     0.999840290708292,     0.999741273473156,       0.9996159394228,     0.999461958541477,     0.999276015258105,     0.999053269285997,     0.998786301063038,
     0.998462766497324,     0.998058999112089,     0.997514388790926,     0.999982722761801,     0.999996730223876,      0.99995731855205,     0.999920146574305,
     0.999870638713363,     0.999807972646068,     0.999730983382475,     0.999638013162547,     0.999526641880175,     0.999393159811364,     0.999231395005082,
      0.99902951440489,     0.998757213418413,      0.99999136144685,     0.999998365124419,     0.999978659438949,     0.999960073591978,     0.999935319850513,
     0.999903987056125,     0.999865492718304,     0.999819007963384,     0.999763322747578,     0.999696582223098,     0.999615700438065,      0.99951476090957,
     0.999378611457456,     0.999995680739907,     0.999999182565329,     0.999989329760192,     0.999980036872169,     0.999967660048669,     0.999951993711263,
     0.999932746615811,     0.999909504327062,     0.999881661825436,     0.999848291690585,     0.999807850952466,     0.999757381380932,     0.999689306914856
  };
  constexpr double w[6851] = {  1.116133016257935e-01, -4.891802710352082e-02,  1.150976554808129e-02, -1.840803958150150e-03,  2.226416033465179e-04,
 -2.163840238489090e-05,  1.757364307488664e-06, -1.225678368004388e-07,  7.490500518659115e-09, -4.073540945156029e-10,  1.995570143095647e-11, -8.880385529860223e-13,
  1.117674409201738e-01, -4.785388530871020e-02,  1.098359689398272e-02, -1.715384333029625e-03,  2.028931525440889e-04, -1.931285069192372e-05,  1.538413358324488e-06,
 -1.053831627285839e-07,  6.333483385868834e-09, -3.391214925548738e-10,  1.637490292073283e-11, -7.190020631341384e-13,  1.120111804922040e-01, -4.570897605438827e-02,
  9.977312057447426e-03, -1.485359746859794e-03,  1.679844064860776e-04, -1.533642774512581e-05,  1.175193818425489e-06, -7.765428225583982e-08,  4.513438207427276e-09,
 -2.342723627339006e-10,  1.099001722864710e-11, -4.698032650133216e-13,  1.121955501028007e-01, -4.246548065360799e-02,  8.583180676991672e-03, -1.188225174439174e-03,
  1.255822840027809e-04, -1.076682155508021e-05,  7.783125400651464e-07, -4.872127785686917e-08,  2.693097232078451e-09, -1.334151905975255e-10,  5.993061583283290e-12,
 -2.460887617864810e-13,  1.120490944493593e-01, -3.813615633815564e-02,  6.937111920789613e-03, -8.702921522136816e-04,  8.396683465283944e-05, -6.617022055288409e-06,
  4.424403196501153e-07, -2.576502915650035e-08,  1.331803347889156e-09, -6.199236923031915e-11,  2.627981030064209e-12, -1.022589438611656e-13,  1.111286542163345e-01,
 -3.281135466749627e-02,  5.208481919036639e-03, -5.763501358586348e-04,  4.955024187460476e-05, -3.511521316616596e-06,  2.128779376045576e-07, -1.132207667711896e-08,
  5.380401169245197e-10, -2.316230583840013e-11,  9.130477436915611e-13, -3.320618603401914e-14,  1.087771455993278e-01, -2.671289662322977e-02,  3.578016943776092e-03,
 -3.393836267612978e-04,  2.535508360156470e-05, -1.579920153210962e-06,  8.507935071669397e-08, -4.055742369449107e-09,  1.741302466094004e-10, -6.821287973395382e-12,
  2.462732735859332e-13, -8.252962933819658e-15,  1.041220785618666e-01, -2.023376445155500e-02,  2.203916716212102e-03, -1.738207941757586e-04,  1.099151846788630e-05,
 -5.882577053912481e-07,  2.754686482245041e-08, -1.154187150346075e-09,  4.396572926307536e-11, -1.540876190753285e-12,  5.014668545585775e-14, -1.525397133983160e-15,
  9.615950370899912e-02, -1.393025491396001e-02,  1.184749413702023e-03, -7.519422180601794e-05,  3.913231303289853e-06, -1.754494529105283e-07,  6.984350714152806e-09,
 -2.518870615230930e-10,  8.348604607497673e-12, -2.570287628640438e-13,  7.411020803617064e-15, -2.013051821315872e-16,  8.395751138112417e-02, -8.434043186155538e-03,
  5.355024772226404e-04, -2.638674243047543e-05,  1.095799762464147e-06, -4.003858456937437e-08,  1.321204572602323e-09, -4.006442952321896e-11,  1.130324261525643e-12,
 -2.994196757729320e-14,  7.499787893676683e-16, -1.785295992253080e-17,  6.696639243142306e-02, -4.279193524706858e-03,  1.926874147843353e-04, -7.073346312144164e-06,
  2.260991856415247e-07, -6.516323301707000e-09,  1.729493316461640e-10, -4.287095541942230e-12,  1.002470665091778e-13, -2.227727585449925e-15,  4.731577359144707e-17,
 -9.644777860811653e-19,  4.534710267108907e-02, -1.692544465309084e-03,  5.041764530944430e-05, -1.306317758400174e-06,  3.064782312024051e-08, -6.669472775017484e-10,
  1.366846368409279e-11, -2.665096922371225e-13,  4.979874625996559e-15, -8.965487859150829e-17,  1.561626081916777e-18, -2.639566953898934e-20,  2.019305716211267e-02,
 -4.467192684254533e-04,  7.990458659516771e-06, -1.321924892018128e-07,  2.084563878000644e-09, -3.167521106392506e-11,  4.666240185048324e-13, -6.693522731557126e-15,
  9.381213132693222e-17, -1.288119641164400e-18,  1.736570853685492e-20, -2.302303320866452e-22,  1.582175211598605e-02, -6.926750727547611e-03,  1.627829271669570e-03,
 -2.600419533345398e-04,  3.141646348577352e-05, -3.050104523536221e-06,  2.474645454817647e-07, -1.724294226875286e-08,  1.052810155244621e-09, -5.720513995851755e-11,
  2.800088619207761e-12, -1.245077080103423e-13,  1.680352299129318e-02, -7.159399364610059e-03,  1.634836193213349e-03, -2.540782755964881e-04,  2.991497455239994e-05,
 -2.835449822955723e-06,  2.249750955963000e-07, -1.535465902450675e-08,  9.196677577653010e-10, -4.908688495110996e-11,  2.363222107991339e-12, -1.034810340364909e-13,
  1.886195276638151e-02, -7.602257068217237e-03,  1.638468700596570e-03, -2.410232715904916e-04,  2.695717072842751e-05, -2.435968864941049e-06,  1.849000847199198e-07,
 -1.211106419597755e-08,  6.982249616262870e-10, -3.596966180812637e-11,  1.675617115655788e-12, -7.116623815000818e-14,  2.216728630962957e-02, -8.196525939633294e-03,
  1.618592281871638e-03, -2.192647287887449e-04,  2.271480141704303e-05, -1.911884385946447e-06,  1.358760633111689e-07, -8.373050486162843e-09,  4.561421211198819e-10,
 -2.229437984804446e-11,  9.890023107938484e-13, -4.014115294037146e-14,  2.690788303132799e-02, -8.823594544999723e-03,  1.548465086992385e-03, -1.879445080474748e-04,
  1.759144182950936e-05, -1.348196552278738e-06,  8.786014091249450e-08, -4.996431882727250e-09,  2.526492431278044e-10, -1.152245333597868e-11,  4.792616424009353e-13,
 -1.832189240029112e-14,  3.316226153723312e-02, -9.285619680364498e-03,  1.403020562228687e-03, -1.484369035457183e-04,  1.224940268008176e-05, -8.360929084927174e-07,
  4.896224027672782e-08, -2.522036588158518e-09,  1.163400396619065e-10, -4.871627633307844e-12,  1.871385888861094e-13, -6.643715750332144e-15,  4.067004226855337e-02,
 -9.317339727815007e-03,  1.172683633492687e-03, -1.051837560592434e-04,  7.469297868665372e-06, -4.442827225767596e-07,  2.292063368120176e-08, -1.050037225427100e-09,
  4.344371204383991e-11, -1.643957395734972e-12,  5.745890148810487e-14, -1.867848340873678e-15,  4.852021701470739e-02, -8.661771055159558e-03,  8.770234081067797e-04,
 -6.482666359590660e-05,  3.865659245763046e-06, -1.960556053196670e-07,  8.735603549464994e-09, -3.494665511648438e-10,  1.274836261421225e-11, -4.290103352703031e-13,
  1.343783946747980e-14, -3.942820496387510e-16,  5.489305698553763e-02, -7.214721528532062e-03,  5.663455620587485e-04, -3.349402379338531e-05,  1.635214152119053e-06,
 -6.913513219240148e-08,  2.606183658096491e-09, -8.932011090571826e-11,  2.821902518661060e-12, -8.303374966741654e-14,  2.293669014312377e-15, -5.981940129703170e-17,
  5.713663661214985e-02, -5.169828655485735e-03,  3.023242698932413e-04, -1.385613543886644e-05,  5.387954807537592e-07, -1.852563167165496e-08,  5.775544346243915e-10,
 -1.660149298534620e-11,  4.452337523326285e-13, -1.123935771125693e-14,  2.688738211461486e-16, -6.125405831740607e-18,  5.247043275378899e-02, -3.024334518755643e-03,
  1.258448889931892e-04, -4.307971945622320e-06,  1.291580916302702e-07, -3.506348898563955e-09,  8.795667837371032e-11, -2.066451193311755e-12,  4.590757042875101e-14,
 -9.712592828630329e-16,  1.967666528377140e-17, -3.832296277302818e-19,  3.929489112253106e-02, -1.344479709384966e-03,  3.729534547162894e-05, -9.070880438972853e-07,
  2.006667981656025e-08, -4.130456114690400e-10,  8.026357066075397e-12, -1.486907854986317e-13,  2.644332666917083e-15, -4.537960778418358e-17,  7.544769151337251e-19,
 -1.218799110368867e-20,  1.852472241468706e-02, -3.886183236863871e-04,  6.585171772315519e-06, -1.033571477790931e-07,  1.549455848232591e-09, -2.242453619716148e-11,
  3.151142854223295e-13, -4.316968085618157e-15,  5.784122193130905e-17, -7.598972657272905e-19,  9.809162335199006e-21, -1.246053490575665e-22,  2.249096287043552e-03,
 -9.834277772422877e-04,  2.308012260178616e-04, -3.682173945073851e-05,  4.442995176736674e-06, -4.308427568312318e-07,  3.491642708074946e-08, -2.430338138599487e-09,
  1.482408995337644e-10, -8.047076878049375e-12,  3.935327574022669e-13, -1.748363942447648e-14,  2.556925131895876e-03, -1.083181393549803e-03,  2.458660498006575e-04,
 -3.799490803728146e-05,  4.449889759549157e-06, -4.197137864812363e-07,  3.315079207058012e-08, -2.253060905127026e-09,  1.344218066024793e-10, -7.148770904217308e-12,
  3.430110561246609e-13, -1.497292236376916e-14,  3.266095787340156e-03, -1.297451099928199e-03,  2.755430198741727e-04, -3.997703452679763e-05,  4.414472104604025e-06,
 -3.942419661358276e-07,  2.960154390832396e-08, -1.919593204275509e-09,  1.096482300931248e-10, -5.600425599228693e-12,  2.588269770663604e-13, -1.091224416135201e-14,
  4.585712034812113e-03, -1.650545111110408e-03,  3.173984829211479e-04, -4.195110949146245e-05,  4.248675551968125e-06, -3.502453765698192e-07,  2.441956822406315e-08,
 -1.478454020026358e-09,  7.923794139856696e-11, -3.814698149647352e-12,  1.668656979001149e-13, -6.685091449627421e-15,  6.871480655938293e-03, -2.160429825824422e-03,
  3.642441551523617e-04, -4.261650528571129e-05,  3.857212953767478e-06, -2.866556109300348e-07,  1.815938482628490e-08, -1.006040006501292e-09,  4.965465681141670e-11,
 -2.214252157031901e-12,  9.019328870420476e-14, -3.381617639388181e-15,  1.062197786206502e-02, -2.805022470874795e-03,  4.016484444946228e-04, -4.047707383815950e-05,
  3.195779016032610e-06, -2.094755801430982e-07,  1.181821504549871e-08, -5.881237606459748e-10,  2.627510048688079e-11, -1.067925557195280e-12,  3.989686748138328e-14,
 -1.380037178213252e-15,  1.634290187379174e-02, -3.474348948115997e-03,  4.093465347377582e-04, -3.461296979611377e-05,  2.330036909837009e-06, -1.319787221271757e-07,
  6.508555041340468e-09, -2.859522167699065e-10,  1.137847044661353e-11, -4.151557437207054e-13,  1.402238662403607e-14, -4.414260471528707e-16,  2.414666245267904e-02,
 -3.943488983879482e-03,  3.702791799191851e-04, -2.560338141782696e-05,  1.437408740508013e-06, -6.898261624727871e-08,  2.920484712556595e-09, -1.114013836653078e-10,
  3.886682013564280e-12, -1.254271359694739e-13,  3.776483426375680e-15, -1.067468357698150e-16,  3.306295808239746e-02, -3.933480071607785e-03,  2.848293815337396e-04,
 -1.569053419180199e-05,  7.183856790780083e-07, -2.863097558364480e-08,  1.021650380520542e-09, -3.325958926252439e-11,  1.001101651119689e-12, -2.813832031358598e-14,
  7.442119057773320e-16, -1.862366993444883e-17,  4.041654588655601e-02, -3.293724217542853e-03,  1.776164203669643e-04, -7.579609491757808e-06,  2.762112982903829e-07,
 -8.943359231947636e-09,  2.635703017883690e-10, -7.184698770672914e-12,  1.832270960939876e-13, -4.408777849445588e-15,  1.007447268713595e-16, -2.196617313618416e-18,
  4.210260952993298e-02, -2.193898370130557e-03,  8.455837172738607e-05, -2.704815084982606e-06,  7.619226689345366e-08, -1.951308770118667e-09,  4.632427308722106e-11,
 -1.032713974648014e-12,  2.181890787948757e-14, -4.398799212231818e-16,  8.506766259128307e-18, -1.584125840748469e-19,  3.445171483085697e-02, -1.084765255305501e-03,
  2.809449139455613e-05, -6.429030765315050e-07,  1.343855690592433e-08, -2.621357811586229e-10,  4.838242469339992e-12, -8.529298450602990e-14,  1.445796671305086e-15,
 -2.368261058321299e-17,  3.763077951397648e-19, -5.816563152919838e-21,  1.706830990842164e-02, -3.405082460604583e-04,  5.480060718126885e-06, -8.178050467780935e-08,
  1.167784412134973e-09, -1.612595375000457e-11,  2.165231663712676e-13, -2.837561707444056e-15,  3.640323159990554e-17, -4.582853032148664e-19,  5.672702802762544e-21,
 -6.914235963858213e-23,  3.207272206992824e-04, -1.400408429404675e-04,  3.281623823633927e-05, -5.227731442439264e-06,  6.299045235065515e-07, -6.100155770326984e-08,
  4.937503809741491e-09, -3.432655799946338e-10,  2.091441923290143e-11, -1.134113108925618e-12,  5.540690038029664e-14, -2.459252988712070e-15,  3.945730344941984e-04,
 -1.660240283389369e-04,  3.742153307621753e-05, -5.744750634173587e-06,  6.686907041938210e-07, -6.271379028560982e-08,  4.927505389711332e-09, -3.332753407559206e-10,
  1.979498398556212e-11, -1.048372733060651e-12,  5.010972840608583e-14, -2.179581599050982e-15,  5.838958645192304e-04, -2.280457696987722e-04,  4.760911822268138e-05,
 -6.797936551381012e-06,  7.397037487012238e-07, -6.517360362989640e-08,  4.833099307340447e-09, -3.098493584186493e-10,  1.751294113850762e-11, -8.858156769048269e-13,
  4.057070323408709e-14, -1.696263298693884e-15,  9.982460159066679e-04, -3.483212233110820e-04,  6.498650960203115e-05, -8.353124756420466e-06,  8.246388582563310e-07,
 -6.640685638785338e-08,  4.531438221459007e-09, -2.689687006149426e-10,  1.415414504797817e-11, -6.699784607842841e-13,  2.885052047235271e-14, -1.139146082250552e-15,
  1.873841091055016e-03, -5.618672464235095e-04,  9.060313331400018e-05, -1.017917041998191e-05,  8.878849921833618e-07, -6.379062353524458e-08,  3.917434482517798e-09,
 -2.108953403858845e-10,  1.013656515006111e-11, -4.410277389385928e-13,  1.755765627313528e-14, -6.444114565283856e-16,  3.658360822417404e-03, -9.059201074418543e-04,
  1.223894432627288e-04, -1.170558550732124e-05,  8.813728268454669e-07, -5.532006824754684e-08,  2.998973521801631e-09, -1.438347371629826e-10,  6.209510882319918e-12,
 -2.444485006272057e-13,  8.863981897759931e-15, -2.981727542266263e-16,  7.050667632818661e-03, -1.383720915350708e-03,  1.520830718719349e-04, -1.208900866053676e-05,
  7.695797763174361e-07, -4.141963021687981e-08,  1.948598014367772e-09, -8.194777488673013e-11,  3.130492400871132e-12, -1.099396288103687e-13,  3.582523289158417e-15,
 -1.090389057705770e-16,  1.279082401646809e-02, -1.903750869925167e-03,  1.654494461510456e-04, -1.068618343088079e-05,  5.641180395419733e-07, -2.558736720978412e-08,
  1.028147360258217e-09, -3.735396484288666e-11,  1.245064699955140e-12, -3.848861253322231e-14,  1.112734340829111e-15, -3.026747732599924e-17,  2.092156962109335e-02,
 -2.248797124158500e-03,  1.501960227661730e-04, -7.706835473740402e-06,  3.309039336960486e-07, -1.243093413317554e-08,  4.198259202281566e-10, -1.297966147214351e-11,
  3.721117547870329e-13, -9.987429796454765e-15,  2.528147343369868e-16, -6.067809101158300e-18,  2.959805368962627e-02, -2.173142521959987e-03,  1.082262909161482e-04,
 -4.305586841458329e-06,  1.471959408061052e-07, -4.492084105096007e-09,  1.252384324228225e-10, -3.239429838788438e-12,  7.859594089469573e-14, -1.803301341151775e-15,
  3.937247515755874e-17, -8.217784668612314e-19,  3.450017249030321e-02, -1.629155386277101e-03,  5.829904531139927e-05, -1.746120097814468e-06,  4.629496139607569e-08,
 -1.120203219083952e-09,  2.520216312581113e-11, -5.337630985567615e-13,  1.073649425296378e-14, -2.064573677017716e-16,  3.814569437630226e-18, -6.796981145152706e-20,
  3.051798725923153e-02, -8.875745226009348e-04,  2.151517071124765e-05, -4.642459132799103e-07,  9.187593055595150e-09, -1.701434759257723e-10,  2.987724042402347e-12,
 -5.019883862344940e-14,  8.122109473374664e-16, -1.271586052896864e-17,  1.933420108906105e-19, -2.862785109996749e-21,  1.578816084803224e-02, -3.002983893756180e-04,
  4.601004923208914e-06, -6.541858675857109e-08,  8.914161835249625e-10, -1.176499848586949e-11,  1.511807605436646e-13, -1.898153985269316e-15,  2.335087473929860e-17,
 -2.820968906939570e-19,  3.352978112226406e-21, -3.926598650382937e-23,  4.590171176962342e-05, -2.000974831884796e-05,  4.680805301242781e-06, -7.444160586917554e-07,
  8.955433074196428e-08, -8.659690319534004e-09,  6.999338807527216e-10, -4.859639443871105e-11,  2.957176451858667e-12, -1.601681936873925e-13,  7.816290032731914e-15,
 -3.465647685122475e-16,  6.189502482160997e-05, -2.583532801919083e-05,  5.775341563038494e-06, -8.797436819745268e-07,  1.016704835330892e-07, -9.472512299092260e-09,
  7.397601777359707e-10, -4.975508123318604e-11,  2.940010885936113e-12, -1.549673447463038e-13,  7.374494347370873e-15, -3.194583936834339e-16,  1.082649822642367e-04,
 -4.144890381515206e-05,  8.482837773579850e-06, -1.189072263078378e-06,  1.272126623453361e-07, -1.103577716761941e-08,  8.068165099546338e-10, -5.105288804013700e-11,
  2.851026202749002e-12, -1.426147610612869e-13,  6.465163975651606e-15, -2.677615074604601e-16,  2.298664200536250e-04, -7.739433531324239e-05,  1.395175443423116e-05,
 -1.737691491131327e-06,  1.666870862045961e-07, -1.307486755084281e-08,  8.709549364688899e-10, -5.056360538050778e-11,  2.607029922489854e-12, -1.210933365281927e-13,
  5.124055512976240e-15, -1.990680316669987e-16,  5.477335889333899e-04, -1.557325732490837e-04,  2.390596134165806e-05, -2.568739563605735e-06,  2.151728696153832e-07,
 -1.489832590525818e-08,  8.844055876113994e-10, -4.614642036433344e-11,  2.154764178389820e-12, -9.126784986405479e-14,  3.543835348200848e-15, -1.270802887147801e-16,
  1.356189731867123e-03, -3.130760266808260e-04,  3.973481729494844e-05, -3.593841649263309e-06,  2.572647583036696e-07, -1.541935436356602e-08,  8.011766891164663e-10,
 -3.694674388604362e-11,  1.537930388632739e-12, -5.852009554752530e-14,  2.055623294185809e-15, -6.712217926062335e-17,  3.259758482974457e-03, -5.876357785810337e-04,
  6.006157782229447e-05, -4.477077931915011e-06,  2.689498773102162e-07, -1.372774211581237e-08,  6.149971546330047e-10, -2.471487814248144e-11,  9.049301950901302e-13,
 -3.054163868114082e-14,  9.587228367258153e-16, -2.817096901911836e-17,  7.185359852627434e-03, -9.713198239548934e-04,  7.801860582944839e-05, -4.702002168602936e-06,
  2.331833198996432e-07, -9.987939413483895e-09,  3.805863857246262e-10, -1.315866966068074e-11,  4.186591525153804e-13, -1.238650189339111e-14,  3.435451289301238e-16,
 -8.984431517552646e-18,  1.384978775135286e-02, -1.343017515925217e-03,  8.276227771584257e-05, -3.956886651925534e-06,  1.593678178770669e-07, -5.644225238970285e-09,
  1.804301405378812e-10, -5.297678962139880e-12,  1.446481026788880e-13, -3.706721450913397e-15,  8.978339836607651e-17, -2.066168254821909e-18,  2.235857255244475e-02,
 -1.479864733555122e-03,  6.818085073394466e-05, -2.532274433081317e-06,  8.131330868698434e-08, -2.341250732110769e-09,  6.180258151166863e-11, -1.518005687269853e-12,
  3.506073009991533e-14, -7.674471000712352e-16,  1.601663249426174e-17, -3.201121176458670e-19,  2.879940417001711e-02, -1.235496422947543e-03,  4.114466436215046e-05,
 -1.156231213072054e-06,  2.890375809095513e-08, -6.618158060077916e-10,  1.412976558223305e-11, -2.846567948431021e-13,  5.457317673410537e-15, -1.001956278631622e-16,
  1.770273614614400e-18, -3.020699429155430e-20,  2.727986550620235e-02, -7.354734168581255e-04,  1.672536471499892e-05, -3.410013795759583e-07,  6.401486432889819e-09,
 -1.127430846354604e-10,  1.886577836250785e-12, -3.025522142230482e-14,  4.679051284036225e-16, -7.010541348012145e-18,  1.021236048925724e-19, -1.450181399519359e-21,
  1.465593179436254e-02, -2.664046628827396e-04,  3.894385561303588e-06, -5.285785088615207e-08,  6.884942645923724e-10, -8.698538561771106e-12,  1.071336351119711e-13,
 -1.290560749910968e-15,  1.524511099493164e-17, -1.769742532999418e-19,  2.022501974728487e-21, -2.278547487673953e-23,  6.596566956899704e-06, -2.870211934996858e-06,
  6.700765351252368e-07, -1.063615695272877e-07,  1.277228354064366e-08, -1.232951778842888e-09,  9.949676626691953e-11, -6.897748886134301e-12,  4.191521549910080e-13,
 -2.267244547023709e-14,  1.105054909621824e-15, -4.893964971047547e-17,  9.897687822182764e-06, -4.092007526754513e-06,  9.058515075575853e-07, -1.367314969569050e-07,
  1.566957742194565e-08, -1.448708126115030e-09,  1.123409745408765e-10, -7.507026927227714e-12,  4.409503944556936e-13, -2.311509972984610e-14,  1.094427802043747e-15,
 -4.718896645529068e-17,  2.092739591268058e-05, -7.826204043983276e-06,  1.565046350534512e-06, -2.147425092383914e-07,  2.253014439790982e-08, -1.919980013216214e-09,
  1.380987645465048e-10, -8.608889429766397e-12,  4.742068313632007e-13, -2.342308817998082e-14,  1.049537509288567e-15, -4.300317317091086e-17,  5.628982051829842e-05,
 -1.819108926155236e-05,  3.154125187518917e-06, -3.791636315900068e-07,  3.521763192745434e-08, -2.682467442260519e-09,  1.739460573640209e-10, -9.852179076585215e-12,
  4.965476022594089e-13, -2.258446186496695e-14,  9.372481461028525e-16, -3.576189414227817e-17,  1.721714994352623e-04, -4.613251958361071e-05,  6.708739006798323e-06,
 -6.866300607564443e-07,  5.503812723186534e-08, -3.660840887157753e-09,  2.094649544269605e-10, -1.056505608684575e-11,  4.780923746391149e-13, -1.966927215465292e-14,
  7.433269559574471e-16, -2.599153395493113e-17,  5.412199506109091e-04, -1.157878446775357e-04,  1.374833946144508e-05, -1.171961794086584e-06,  7.952897838039688e-08,
 -4.539854843166437e-09,  2.255482572804917e-10, -9.978847315134860e-12,  3.996711755234079e-13, -1.467079007218501e-14,  4.982817523740872e-16, -1.576536028231961e-17,
  1.611087594586919e-03, -2.655118494702783e-04,  2.516817817034847e-05, -1.755595934249049e-06,  9.934168968879741e-08, -4.800907783231640e-09,  2.044979114252895e-10,
 -7.841660408557159e-12,  2.748085539503433e-13, -8.901098808466531e-15,  2.687964997248603e-16, -7.615038350112022e-18,  4.263969030119255e-03, -5.219257214776150e-04,
  3.870912957672025e-05, -2.175366266814132e-06,  1.012892771226195e-07, -4.094686903757767e-09,  1.478751925255935e-10, -4.862609926856187e-12,  1.475827880568985e-13,
 -4.176204373958281e-15,  1.110425122144606e-16, -2.789978271586086e-18,  9.552737043027197e-03, -8.347694228339165e-04,  4.749773280177833e-05, -2.117186879298592e-06,
  8.002924429219176e-08, -2.673181891823431e-09,  8.090977203617503e-11, -2.256555531944669e-12,  5.868640498388810e-14, -1.435897676632511e-15,  3.327872149896963e-17,
 -7.342183939586444e-19,  1.736466872799414e-02, -1.036948489895715e-03,  4.428083311121732e-05, -1.537729913047117e-06,  4.643911312740924e-08, -1.262964186930741e-09,
  3.159644675463994e-11, -7.375685742613311e-13,  1.622842814965707e-14, -3.391002762035357e-16,  6.768196529763072e-18, -1.295859001588936e-19,  2.443776824660889e-02,
 -9.548747837146256e-04,  2.966090209536694e-05, -7.836296489909941e-07,  1.850241985452548e-08, -4.015141358480133e-10,  8.146212125367652e-12, -1.563004078744823e-13,
  2.859254491740928e-15, -5.017303209057266e-17,  8.484852304547555e-19, -1.387636912012963e-20,  2.458191232890435e-02, -6.164540633938192e-04,  1.318072960332506e-05,
 -2.544167146872429e-07,  4.538632747643747e-09, -7.614684193337820e-11,  1.216085513692961e-12, -1.864160786303079e-14,  2.759333781374593e-16, -3.961508088267987e-18,
  5.535323910025006e-20, -7.546698527749212e-22,  1.364885413853404e-02, -2.376118561524871e-04,  3.320866960378154e-06, -4.310537118542344e-08,  5.375703809861570e-10,
 -6.511206944542273e-12,  7.697088773618578e-14, -8.908069208051072e-16,  1.011776041646618e-17, -1.130057596477127e-19,  1.243258631385543e-21, -1.349101481959720e-23,
  9.525427028053234e-07, -4.135493156242968e-07,  9.632312148500789e-08, -1.525554835658641e-08,  1.828134248942435e-09, -1.761334840159173e-10,  1.418788032139269e-11,
 -9.819303751117438e-13,  5.957409116094578e-14, -3.217658826643851e-15,  1.566105805718209e-16, -6.926782741987411e-18,  1.618965577953465e-06, -6.616941672378108e-07,
  1.447887951984321e-07, -2.162015839011277e-08,  2.453322393690238e-09, -2.247802151256239e-10,  1.728758076501670e-11, -1.146535915788140e-12,  6.688155640858493e-14,
 -3.483810066838789e-15,  1.639865007454291e-16, -7.032795393999988e-18,  4.241245083875605e-06, -1.542874609891300e-06,  3.003406568286074e-07, -4.020526202635798e-08,
  4.124528563284360e-09, -3.443733284590473e-10,  2.431224578230639e-11, -1.489968394773496e-12,  8.079937941090216e-14, -3.934090174098697e-15,  1.739605448339308e-16,
 -7.041441935155425e-18,  1.473596777973618e-05, -4.543918036062899e-06,  7.540442117843406e-07, -8.711655828544029e-08,  7.805844942488408e-09, -5.754314051272984e-10,
  3.621597737637431e-11, -1.995804061075849e-12,  9.808291416615358e-14, -4.358437178937097e-15,  1.770180538458292e-16, -6.620967288330064e-18,  5.834448426143294e-05,
 -1.463736209023372e-05,  2.006599105000424e-06, -1.948189110793053e-07,  1.489023785652290e-08, -9.484419441408889e-10,  5.215676861136055e-11, -2.536297540297804e-12,
  1.109578980374950e-13, -4.423893196356690e-15,  1.623700761357259e-16, -5.525034697921551e-18,  2.323504890539783e-04, -4.579739479971677e-05,  5.067669489458421e-06,
 -4.058820957874848e-07,  2.604018175519406e-08, -1.412384155018348e-09,  6.694700418196679e-11, -2.835783766532784e-12,  1.090723941086630e-13, -3.855189405304573e-15,
  1.263812201000170e-16, -3.867945471990908e-18,  8.486356735530345e-04, -1.272882334394817e-04,  1.116507322676605e-05, -7.275573951849215e-07,  3.872315877387465e-08,
 -1.769486846797407e-09,  7.157397482397165e-11, -2.615630565650301e-12,  8.762808000411276e-14, -2.720688223668645e-15,  7.894575457035314e-17, -2.153826643329630e-18,
  2.662311720941959e-03, -2.942869141956570e-04,  2.014390922884877e-05, -1.055268619426274e-06,  4.612081163567815e-08, -1.759181442144435e-09,  6.019248679930048e-11,
 -1.881788014418907e-12,  5.445934030923429e-14, -1.473240369979058e-15,  3.753457756312488e-17, -9.055383493381243e-19,  6.838840726011400e-03, -5.381153725114559e-04,
  2.830107990661931e-05, -1.177118723552288e-06,  4.178916161060499e-08, -1.317272140463560e-09,  3.776768627352765e-11, -1.000903679363897e-12,  2.480074315555378e-14,
 -5.794796057326084e-16,  1.285176024311670e-17, -2.718453336997608e-19,  1.382410153078155e-02, -7.455644663134165e-04,  2.956920992170357e-05, -9.616705842518437e-07,
  2.735159278668939e-08, -7.034453610332967e-10,  1.669626575660787e-11, -3.707463617366374e-13,  7.777200833419854e-15, -1.552388479104624e-16,  2.965024162385467e-18,
 -5.441142170233786e-20,  2.103966673552325e-02, -7.507171184056904e-04,  2.179932856797706e-05, -5.425317886661043e-07,  1.211985695676768e-08, -2.496441623608110e-10,
  4.819808129254103e-12, -8.818477041288337e-14,  1.541045699571095e-15, -2.587219117819071e-17,  4.191830815874236e-19, -6.576253030908200e-21,  2.230925429954576e-02,
 -5.220919748948184e-04,  1.051787250556741e-05, -1.925573762953404e-07,  3.269925598974100e-09, -5.234455704225197e-11,  7.990072839159251e-13, -1.172359017483806e-14,
  1.663049267879212e-16, -2.290614741268857e-18,  3.073552585959081e-20, -4.027600524624886e-22,  1.274845872874213e-02, -2.129770436672456e-04,  2.851215305358395e-06,
 -3.545353540926734e-08,  4.239731975648764e-10, -4.930073469437330e-12,  5.601172131357972e-14, -6.235815796536230e-16,  6.818326864473244e-18, -7.335953652338913e-20,
  7.778242626120662e-22, -8.141342970674974e-24,  1.383167513954776e-07, -5.989553234600210e-08,  1.391294471641684e-08, -2.197839454614711e-09,  2.627427084897299e-10,
 -2.525765562569143e-11,  2.030328426989545e-12, -1.402459874035927e-13,  8.493480882267596e-15, -4.579721532201604e-16,  2.225555425524146e-17, -9.829060518559624e-19,
  2.719804949400269e-07, -1.096347817810001e-07,  2.365949096632537e-08, -3.487933025203502e-09,  3.911979379331887e-10, -3.546440649523575e-11,  2.701319933574047e-12,
 -1.775852045763656e-13,  1.027620555233614e-14, -5.313524757807589e-16,  2.484286361699683e-17, -1.058839138282219e-18,  9.068437046264622e-07, -3.193270874036994e-07,
  6.024675560617845e-08, -7.838434996080650e-09,  7.836378146398789e-10, -6.391560943499346e-11,  4.417293987731939e-12, -2.655036739632948e-13,  1.414422342205465e-14,
 -6.775308448579795e-16,  2.951328360732589e-17, -1.178240801543771e-18,  4.144606501571656e-06, -1.211457088452440e-06,  1.913840489662547e-07, -2.115462916994594e-08,
  1.821391685490898e-09, -1.294976066817876e-10,  7.885569860343486e-12, -4.216132592325533e-13,  2.015141607831324e-14, -8.727525690627647e-16,  3.461452995206560e-17,
 -1.266513599740681e-18,  2.135055215059288e-05, -4.981468661866933e-06,  6.406023713446274e-07, -5.876302869172562e-08,  4.267760295080328e-09, -2.595145648040018e-10,
  1.367774676222705e-11, -6.396067528629389e-13,  2.698657121271159e-14, -1.040373166346521e-15,  3.700691011459632e-17, -1.222989003888905e-18,  1.071452893644765e-04,
 -1.934512262060394e-05,  1.987870713328487e-06, -1.491779148985217e-07,  9.027148868059746e-09, -4.642224479161219e-10,  2.095220810916877e-11, -8.481407947970340e-13,
  3.127251746143108e-14, -1.062524603548289e-15,  3.356467553890943e-17, -9.921171359132819e-19,  4.747897946314117e-04, -6.454488015893221e-05,  5.229802823823535e-06,
 -3.179488215899111e-07,  1.589921903954126e-08, -6.862646292009960e-10,  2.633369610707963e-11, -9.162437440302792e-13,  2.931562458075604e-14, -8.716288179398068e-16,
  2.427859892577939e-17, -6.372459832926429e-19,  1.742000009605781e-03, -1.734841364112136e-04,  1.095986678992640e-05, -5.352246620576121e-07,  2.195760166031861e-08,
 -7.902131503613574e-10,  2.561498449922368e-11, -7.612185457906899e-13,  2.100155555555553e-14, -5.429840924104948e-16,  1.325106222407645e-17, -3.068470340953878e-19,
  5.063494997775731e-03, -3.585655821304852e-04,  1.745491808933835e-05, -6.781378974620603e-07,  2.263086723788324e-08, -6.737043560828933e-10,  1.830861962828786e-11,
 -4.612902646653043e-13,  1.089441125319871e-14, -2.431651985936223e-16,  5.161883608255527e-18, -1.046972719452890e-19,  1.125111638649435e-02, -5.486748034702329e-04,
  2.025261133650553e-05, -6.179069044631430e-07,  1.657501023441390e-08, -4.036314672300960e-10,  9.098991865141308e-12, -1.923826370823579e-13,  3.850858646077690e-15,
 -7.348347144231542e-17,  1.343975064323618e-18, -2.365287682039299e-20,  1.834855563972597e-02, -5.994098362257191e-04,  1.630597261797911e-05, -3.830213654781349e-07,
  8.109252010199279e-09, -1.587839443820903e-10,  2.921168664430592e-12, -5.102897704004235e-14,  8.528264648731887e-16, -1.371298077456282e-17,  2.130675366026923e-19,
 -3.209369054413014e-21,  2.037569665238944e-02, -4.463756370020257e-04,  8.489643563817815e-06, -1.476734786050979e-07,  2.391020023243468e-09, -3.657464600602293e-11,
  5.343649819593919e-13, -7.514693663292854e-15,  1.022864075025658e-16, -1.353215187539924e-18,  1.745569687703295e-20, -2.200973368387284e-22,  1.193962901995344e-02,
 -1.917608171685588e-04,  2.463441835440750e-06, -2.939125891502205e-08,  3.375180535756563e-10, -3.772902172086276e-12,  4.124810168108924e-14, -4.422811079882736e-16,
  4.660818015940747e-18, -4.836751316941635e-20,  4.944798142361050e-22, -5.010046845646664e-24,  2.021715822073026e-08, -8.727742398586780e-09,  2.020848533095713e-09,
 -3.182697162140978e-10,  3.794108378040680e-11, -3.637846992982970e-12,  2.917262960682327e-13, -2.010644618796876e-14,  1.215168033402935e-15, -6.539713637808406e-17,
  3.172373015565275e-18, -1.398742118757172e-19,  4.715782442145373e-08, -1.869294421044893e-08,  3.967500156102657e-09, -5.760482101102458e-10,  6.372163115269437e-11,
 -5.704953925659012e-12,  4.296480086198611e-13, -2.795576610991954e-14,  1.602597671025174e-15, -8.215918709218943e-17,  3.811295519639849e-18, -1.612829406987021e-19,
  2.059391385639743e-07, -6.979169409118776e-08,  1.269846602559763e-08, -1.598848815237670e-09,  1.551880582918449e-10, -1.232386644724128e-11,  8.313187006398673e-13,
 -4.887566658506262e-14,  2.551757064297811e-15, -1.199941033314315e-16,  5.138915670993549e-18, -2.019808946217461e-19,  1.258031371015947e-06, -3.460748601707707e-07,
  5.175533505637156e-08, -5.447644137908764e-09,  4.488671647124040e-10, -3.066873561580041e-11,  1.801044822388614e-12, -9.315145201295257e-14,  4.318411030977717e-15,
 -1.818344174449460e-16,  7.026219997401743e-18, -2.509514340728218e-19,  8.443171718047095e-06, -1.819409758937690e-06,  2.184371047454701e-07, -1.885908621764693e-08,
  1.297212766026876e-09, -7.508475004037499e-11,  3.782659666055010e-12, -1.696805235690900e-13,  6.888761690890545e-15, -2.562326641755351e-16,  8.815119512471429e-18,
 -2.823783551170646e-19,  5.295232743456995e-05, -8.708581106177155e-06,  8.284614726197702e-07, -5.811325987012489e-08,  3.310081400828078e-09, -1.610953295458999e-10,
  6.911444628182711e-12, -2.669301219535204e-13,  9.420360632559660e-15, -3.072077826761502e-16,  9.337767767247490e-18, -2.661837910071156e-19,  2.810891782778440e-04,
 -3.450011083175200e-05,  2.579103229485780e-06, -1.461548551253779e-07,  6.861439831036356e-09, -2.795480552448490e-10,  1.016897005300755e-11, -3.366174053163295e-13,
  1.027826655488654e-14, -2.924243519335681e-16,  7.812717397438596e-18, -1.971202887931369e-19,  1.189827661725638e-03, -1.065387676972869e-04,  6.214804778691724e-06,
 -2.830156880136451e-07,  1.090180630115502e-08, -3.702478957444876e-10,  1.137137994747764e-11, -3.212423275081617e-13,  8.448899213607834e-15, -2.087492348985676e-16,
  4.878892642398134e-18, -1.084149171414957e-19,  3.864484883241902e-03, -2.462094259804394e-04,  1.111202353079731e-05, -4.037361947777325e-07,  1.267846536275615e-08,
 -3.567558400250392e-10,  9.196459948577412e-12, -2.204232565859174e-13,  4.964441637564643e-15, -1.058957137511760e-16,  2.152373160699284e-18, -4.187241802786361e-20,
  9.339141068828698e-03, -4.123496484973146e-04,  1.419650400107370e-05, -4.070316750159989e-07,  1.031261238487551e-08, -2.380897245480659e-10,  5.103428032449900e-12,
 -1.028464582256183e-13,  1.966161664094000e-15, -3.589690084270811e-17,  6.291392758056436e-19, -1.062544643431306e-20,  1.618552646297645e-02, -4.853601728993690e-04,
  1.239454055378016e-05, -2.753051889430086e-07,  5.533115927646442e-09, -1.031413263170937e-10,  1.810511653878305e-12, -3.023338392688906e-14,  4.837714153946816e-16,
 -7.457875748903624e-18,  1.112335866157654e-19, -1.610080299113287e-21,  1.871565537278584e-02, -3.849478543560146e-04,  6.925037011578315e-06, -1.146377078199431e-07,
  1.772468037291063e-09, -2.594558130492956e-11,  3.633156139777535e-13, -4.903096066499118e-15,  6.411392746701537e-17, -8.156634842585246e-19,  1.012456220910124e-20,
 -1.229991309197242e-22,  1.120988954710340e-02, -1.733776630999630e-04,  2.140821761042316e-06, -2.454477352712507e-08,  2.710371997497530e-10, -2.916183039301867e-12,
  3.071542109351734e-14, -3.175701388301265e-16,  3.228219690980554e-18, -3.238249521761733e-20,  3.181341116898360e-22, -3.167607393976706e-24,  2.978263225305343e-09,
 -1.280951213982443e-09,  2.954614809443226e-10, -4.636633484348636e-11,  5.509087776579003e-12, -5.266159060357014e-13,  4.211256277339090e-14, -2.895037865450435e-15,
  1.745518301299456e-16, -9.373315963627832e-18,  4.537687666894147e-19, -1.996955707763956e-20,  8.488148056370839e-09, -3.296513912094002e-09,  6.858194126564587e-10,
 -9.777911582190498e-11,  1.064022468969167e-11, -9.386406757895648e-13,  6.975374993567621e-14, -4.484177417419038e-15,  2.542589247634548e-16, -1.290551999765532e-17,
  5.932512515069484e-19, -2.489701363787877e-20,  5.002074099464871e-08, -1.620549161533536e-08,  2.827566884233250e-09, -3.428833970272397e-10,  3.217772058263763e-11,
 -2.478853561687026e-12,  1.626776386533326e-13, -9.328132499385697e-15,  4.760289308389421e-16, -2.192221000539727e-17,  9.210240091020778e-19, -3.556856397659245e-20,
  4.136530379701702e-07, -1.062676166852270e-07,  1.495700161978907e-08, -1.492004083451767e-09,  1.171650877778555e-10, -7.664983791046520e-12,  4.326840545862678e-13,
 -2.158341966082885e-14,  9.678383334490595e-16, -3.951989977359036e-17,  1.484265697784043e-18, -5.163417058029908e-20,  3.607280051076841e-06, -7.129062887181703e-07,
  7.954992980910833e-08, -6.441147057888279e-09,  4.183356316112378e-10, -2.298603956694525e-11,  1.104137607713843e-12, -4.740136605561916e-14,  1.847699747829851e-15,
 -6.617338130714498e-17,  2.197487545705296e-18, -6.810516163594695e-20,  2.796589881547652e-05, -4.166809915333468e-06,  3.660312113618114e-07, -2.395243236080715e-08,
  1.282044558828556e-09, -5.895973008586744e-11,  2.401052411653922e-12, -8.835336924517124e-14,  2.980480412242584e-15, -9.316849199877583e-17,  2.721357837741566e-18,
 -7.471833298434084e-20,  1.754131121003869e-04, -1.936873817938478e-05,  1.335014101636780e-06, -7.048140689072204e-08,  3.105072447550744e-09, -1.193576478682371e-10,
  4.114072015808633e-12, -1.295022233629149e-13,  3.771588232314644e-15, -1.026197557570415e-16,  2.628161286057354e-18, -6.370110653483302e-20,  8.451497715323109e-04,
 -6.791945347859670e-05,  3.661655558028441e-06, -1.555840719649158e-07,  5.630080908213070e-09, -1.805179142733217e-10,  5.254661645590356e-12, -1.411437337177026e-13,
  3.539245253324020e-15, -8.356941202064152e-17,  1.870549508113811e-18, -3.988383669139148e-20,  3.030996035279434e-03, -1.737176359966598e-04,  7.282664794661687e-06,
 -2.477848755281186e-07,  7.330314556651804e-09, -1.951584533391129e-10,  4.776007432226223e-12, -1.089764791140524e-13,  2.342058159167505e-15, -4.776863289175531e-17,
  9.300514556643267e-19, -1.736026426333322e-20,  7.889484141406510e-03, -3.158331562603848e-04,  1.016415478328979e-05, -2.743343006011537e-07,  6.574628023067058e-09,
 -1.440948596763705e-10,  2.940264832648567e-12, -5.653527400025433e-14,  1.033226188674353e-15, -1.806350207884397e-17,  3.036109710529794e-19, -4.923941554747117e-21,
  1.442341096684592e-02, -3.980562374809593e-04,  9.560914700217538e-06, -2.011762893546594e-07,  3.844332583149183e-09, -6.831863247328235e-11,  1.145749111621010e-12,
 -1.831124262179996e-14,  2.808424781646463e-16, -4.155092172104065e-18,  5.954818708687217e-20, -8.289800393207542e-22,  1.727858432811904e-02, -3.346046321346745e-04,
  5.703833805599038e-06, -8.999857712322086e-08,  1.330724356440948e-09, -1.866618970644620e-11,  2.508390954732836e-13, -3.252579265334433e-15,  4.090247526906632e-17,
 -5.010653592475863e-19,  5.987340520539620e-21, -7.023575344037937e-23,  1.054886518480186e-02, -1.573597026018699e-04,  1.870501327493725e-06, -2.063754094451537e-08,
  2.194210482075056e-10, -2.275038951805074e-12,  2.311048746038565e-14, -2.307137620249123e-16,  2.261251891255239e-18, -2.208758475107249e-20,  2.043129375117056e-22,
 -2.105257388633738e-24,  4.428889645894302e-10, -1.896252206913594e-10,  4.353656328042492e-11, -6.802784934520968e-12,  8.051064418138521e-13, -7.668438246662623e-14,
  6.112222505299474e-15, -4.189255243945610e-16,  2.518890240086556e-17, -1.349197979793401e-18,  6.516277612767863e-20, -2.861504387540624e-21,  1.597009271393263e-09,
 -6.048840124316480e-10,  1.228425192104051e-10, -1.713665991038106e-11,  1.828773988636714e-12, -1.585315135011935e-13,  1.159732512779558e-14, -7.350493104098185e-16,
  4.114710013128556e-17, -2.064348033296241e-18,  9.389559095700268e-20, -3.902708863577633e-21,  1.308685399318963e-08, -4.021961469182671e-09,  6.687567209378158e-10,
 -7.769475162102528e-11,  7.017573709958720e-12, -5.223476578473708e-13,  3.323193236479406e-14, -1.852612622233883e-15,  9.214430459660465e-17, -4.144925839691957e-18,
  1.704291999107285e-19, -6.452822617037876e-21,  1.477546712923894e-07, -3.515657625231125e-08,  4.629700789577163e-09, -4.355900802021394e-10,  3.246768046573538e-11,
 -2.026428649341310e-12,  1.095993228588414e-13, -5.257128887453270e-15,  2.273976607076279e-16, -8.981536705439281e-18,  3.270847608859138e-19, -1.105789137858141e-20,
  1.663039553203448e-06, -2.993137544484700e-07,  3.091447263412834e-08, -2.340014788134734e-09,  1.431081286378551e-10, -7.446310221423114e-12,  3.402808614357482e-13,
 -1.395159848414211e-14,  5.211105656243195e-16, -1.793550525595701e-17,  5.738687971483684e-19, -1.717719350528154e-20,  1.573025438544693e-05, -2.112344715495233e-06,
  1.710016328642368e-07, -1.042293288131930e-08,  5.235632998216662e-10, -2.272536325104244e-11,  8.774469206720640e-13, -3.072906718878445e-14,  9.897487285713796e-16,
 -2.962421242658761e-17,  8.305971102085173e-19, -2.194093533406829e-20,  1.149324260373488e-04, -1.137897936866328e-05,  7.230651877291612e-07, -3.555775433640361e-08,
  1.469846515095641e-09, -5.329872325376728e-11,  1.740388310959600e-12, -5.208099733705953e-14,  1.446266758697737e-15, -3.761867032841381e-17,  9.231479465323198e-19,
 -2.148451874756418e-20,  6.220831783363838e-04, -4.479857791372365e-05,  2.235002567905870e-06, -8.867813426085618e-08,  3.016711714192550e-09, -9.136984902695616e-11,
  2.521936996920022e-12, -6.443275183171209e-14,  1.540839222925581e-15, -3.477670590461100e-17,  7.455690033664166e-19, -1.525440288950736e-20,  2.436285571934069e-03,
 -1.256169201857770e-04,  4.901818024144224e-06, -1.564004657868678e-07,  4.364082591319414e-09, -1.100464312302564e-10,  2.559058407874809e-12, -5.563193197504137e-14,
  1.141682810585460e-15, -2.227842762136618e-17,  4.157245729188404e-19, -7.448702450726013e-21,  6.770192893861680e-03, -2.460962033755586e-04,  7.419300476008681e-06,
 -1.888392708430821e-07,  4.287206124779779e-09, -8.931468051357266e-11,  1.736945458297934e-12, -3.189913950962016e-14,  5.578602284424910e-16, -9.346699862291220e-18,
  1.507901216298381e-19, -2.349864635559218e-21,  1.297022182113629e-02, -3.302746577906587e-04,  7.475168610998402e-06, -1.492615665478086e-07,  2.716126326832172e-09,
 -4.608109041300086e-11,  7.392709520158203e-13, -1.132076760352441e-14,  1.666084947067819e-16, -2.367870727970741e-18,  3.264368540571027e-20, -4.373395492851634e-22,
  1.602506334127863e-02, -2.929583274840508e-04,  4.740261641832485e-06, -7.139498553343418e-08,  1.010924322817953e-09, -1.360616764582946e-11,  1.756770164680125e-13,
 -2.191519847986529e-15,  2.652241009446185e-17, -3.135164366864245e-19,  3.602204698921940e-21, -4.094917470982673e-23,  9.947865875041036e-03, -1.433298840273781e-04,
  1.642505683100137e-06, -1.746273250647124e-08,  1.789828594471273e-10, -1.790412968261226e-12,  1.755426364227803e-14, -1.696674183117755e-16,  1.592770501184933e-18,
 -1.556491437467944e-20,  1.262613333605920e-22, -1.490037096329584e-24,  6.662037177618762e-11, -2.836424180819516e-11,  6.475438099530178e-12, -1.006549660868770e-12,
  1.185617844299882e-13, -1.124436979827363e-14,  8.927645895813412e-16, -6.097289289687503e-17,  3.654313937744097e-18, -1.951585491969971e-19,  9.400084857397676e-21,
 -4.117589211153191e-22,  3.166211808162926e-10, -1.162873672002569e-10,  2.293747866315911e-11, -3.117425914272632e-12,  3.250509676082405e-13, -2.760057825194453e-14,
  1.982042288075975e-15, -1.235488864582247e-16,  6.812986832589302e-18, -3.371917643744240e-19,  1.514885661258988e-20, -6.226359819269491e-22,  3.713313380015234e-09,
 -1.073089945730067e-09,  1.688768174551807e-10, -1.869048488099296e-11,  1.616936844668748e-12, -1.157966929397766e-13,  7.114917734213652e-15, -3.843144998347860e-16,
  1.857295127503058e-17, -8.137863349234801e-19,  3.266369585776976e-20, -1.209652183431561e-21,  5.743063676625708e-08, -1.254713689375752e-08,  1.537025912749216e-09,
 -1.357685477380026e-10,  9.567712503871294e-12, -5.677319185445435e-13,  2.932707235280514e-14, -1.348789634920770e-15,  5.612679141166128e-17, -2.138929342415684e-18,
  7.535216027042816e-20, -2.470180350248735e-21,  8.255710843655463e-07, -1.343729993392066e-07,  1.280015044436641e-08, -9.032185106835581e-10,  5.189152345216000e-11,
 -2.551458614127114e-12,  1.107049460325355e-13, -4.326768318493633e-15,  1.545828336015713e-16, -5.104237665643347e-18,  1.570952607447287e-19, -4.534045596544186e-21,
  9.388125551994098e-06, -1.130560752714548e-06,  8.422817786765271e-08, -4.776629191948988e-09,  2.249703907939122e-10, -9.208285893337739e-12,  3.368076764438027e-13,
 -1.121617230153517e-14,  3.446310298163681e-16, -9.868010343646063e-18,  2.653426580808042e-19, -6.737420568869066e-21,  7.875674221089126e-05, -6.969829645541658e-06,
  4.084928762875589e-07, -1.871410542924256e-08,  7.259627097710626e-10, -2.483480354412683e-11,  7.682477841822950e-13, -2.185409311912205e-14,  5.785834698495181e-16,
 -1.438408205894450e-17,  3.381312207937744e-19, -7.553748702911513e-21,  4.729083133491837e-04, -3.047476270521606e-05,  1.409354433648839e-06, -5.226750018968830e-08,
  1.672989199560409e-09, -4.790051734550436e-11,  1.254416217856522e-12, -3.049875279632313e-14,  6.958436557704744e-16, -1.501650887552967e-17,  3.084265205455232e-19,
 -6.056325913136542e-21,  2.001840247176892e-03, -9.287051569193952e-05,  3.380856225299908e-06, -1.013093816244796e-07,  2.669717810827379e-09, -6.383344069472553e-11,
  1.411907321763007e-12, -2.926779579090224e-14,  5.739991108791723e-16, -1.072289287392515e-17,  1.918948438591751e-19, -3.302032617590037e-21,  5.891649262867955e-03,
 -1.947623803815106e-04,  5.512439853264826e-06, -1.325403418983003e-07,  2.854675037674261e-09, -5.660267351127397e-11,  1.050366750407005e-12, -1.844298683485343e-14,
  3.089692644685452e-16, -4.964529022382016e-18,  7.695393751547694e-20, -1.153119855015179e-21,  1.175833994037713e-02, -2.769633521862724e-04,  5.917216681164174e-06,
 -1.123103723799938e-07,  1.949063437109755e-09, -3.161051432696281e-11,  4.857154121965963e-13, -7.134489911458673e-15,  1.008772030009799e-16, -1.378070372660755e-18,
  1.830152279978937e-20, -2.361213559846022e-22,  1.492401088325175e-02, -2.582075122865072e-04,  3.972279414293772e-06, -5.718736263359396e-08,  7.764478419011447e-10,
 -1.003988017081263e-11,  1.246793326671738e-13, -1.498755304304603e-15,  1.744729037205640e-17, -1.998805822057918e-19,  2.200621418260528e-21, -2.424066539866459e-23,
  9.399564581657529e-03, -1.309819467134834e-04,  1.449023546405772e-06, -1.486409999759890e-08,  1.470305034220324e-10, -1.420845351876738e-12,  1.343914929934275e-14,
 -1.268089336005110e-16,  1.108870702856708e-18, -1.167894185591340e-20,  7.182056878280250e-23, -9.627722401487332e-25,  1.016401256684260e-11, -4.296990239119799e-12,
  9.741150864882296e-13, -1.504504996356550e-13,  1.761978243249519e-14, -1.662426707692396e-15,  1.313770652930189e-16, -8.934903884459818e-18,  5.334575725518276e-19,
 -2.839041428799586e-20,  1.363129298900061e-21, -5.953717617295861e-23,  6.676405864218560e-11, -2.360764501166030e-11,  4.495317088921599e-12, -5.921840969381538e-13,
  6.006652121702960e-14, -4.977007113028565e-15,  3.496901427764691e-16, -2.137557978619175e-17,  1.158188783316861e-18, -5.641892642591551e-20,  2.498530592750618e-21,
 -1.013636077600658e-22,  1.149826793024630e-09, -3.093827085683915e-10,  4.574628735323965e-11, -4.794503585610410e-12,  3.952650693665873e-13, -2.711402692916551e-14,
  1.602618678002475e-15, -8.357768082487283e-17,  3.911936099982910e-18, -1.664638596082402e-19,  6.504660301053394e-21, -2.350307223750632e-22,  2.430216760189072e-08,
 -4.831453569797699e-09,  5.475399916763192e-10, -4.521089813874382e-11,  3.001167219701021e-12, -1.687579513323074e-13,  8.301386119144958e-15, -3.650651843385515e-16,
  1.457715216644052e-17, -5.347039203239031e-19,  1.818073632660856e-20, -5.766665586537508e-22,  4.400232764381516e-07, -6.432220546358281e-08,  5.634419231549590e-09,
 -3.697768173328878e-10,  1.991835079206383e-11, -9.238290447051932e-13,  3.799538313819021e-14, -1.413339395432882e-15,  4.822431813011344e-17, -1.525343862402373e-18,
  4.509124211651525e-20, -1.253048301684537e-21,  5.921486346812827e-06, -6.364164875995439e-07,  4.360529689482093e-08, -2.299172920142801e-09,  1.014746437461844e-10,
 -3.914546322790850e-12,  1.355593832456260e-13, -4.290057893851619e-15,  1.256694918550139e-16, -3.440052623856459e-18,  8.864797279899608e-20, -2.161997965750559e-21,
  5.622713760569985e-05, -4.434840981992113e-06,  2.399805432075699e-07, -1.024621027182455e-08,  3.731576713653516e-10, -1.204672493988067e-11,  3.531123678133375e-13,
 -9.549719312848243e-15,  2.410505843716126e-16, -5.727536894855986e-18,  1.289622442009101e-19, -2.764987238469092e-21,  3.701448636713232e-04, -2.131717311435908e-05,
  9.157388997223224e-07, -3.177872924850663e-08,  9.580249129509738e-10, -2.595164964577793e-11,  6.452907196059323e-13, -1.493870214914585e-14,  3.253547792979389e-16,
 -6.715962926477356e-18,  1.321978060652952e-19, -2.492065116855634e-21,  1.677663165253660e-03, -7.004666418465981e-05,  2.384589944363768e-06, -6.721150589572891e-08,
  1.674913163911588e-09, -3.801605484982162e-11,  8.006461365412011e-13, -1.583855329292170e-14,  2.971292749579310e-16, -5.316877983810298e-18,  9.131279622180674e-20,
 -1.510121754416417e-21,  5.191718712377035e-03, -1.563262605255738e-04,  4.162647958156401e-06, -9.470969198034512e-08,  1.938024272340606e-09, -3.661960218540483e-11,
  6.492366468850365e-13, -1.090814511653761e-14,  1.752950980944284e-16, -2.702296687465874e-18,  4.028593379880832e-20, -5.813766250568923e-22,  1.073731630502152e-02,
 -2.345306168059666e-04,  4.737620052699180e-06, -8.561156562335934e-08,  1.418951397253427e-09, -2.202701038501643e-11,  3.245854273784849e-13, -4.576962202536571e-15,
  6.227734635446172e-17, -8.177828099269823e-19,  1.047672337042520e-20, -1.305464295531908e-22,  1.395067035059251e-02, -2.289773474060164e-04,  3.354433952341067e-06,
 -4.622120880972733e-08,  6.024739988302586e-10, -7.494157811291111e-12,  8.955887341434671e-14, -1.040465565566445e-15,  1.160974838543786e-17, -1.298824414779650e-19,
  1.372151924134477e-21, -1.418640798412316e-23,  8.897745248729404e-03, -1.200652943908963e-04,  1.283885148408280e-06, -1.272256242619920e-08,  1.215705298168810e-10,
 -1.137274384344565e-12,  1.032560084058956e-14, -9.756795144125539e-17,  7.318904599892680e-19, -9.430355026352233e-21,  4.715739702592835e-23, -5.745373867255240e-26,
  1.578388569004951e-12, -6.612904410473794e-13,  1.485919779782296e-13, -2.276756844010710e-14,  2.647533477157041e-15, -2.482214093121216e-16,  1.950585974989925e-17,
 -1.319887940380284e-18,  7.844534214012323e-20, -4.157656167580227e-21,  1.988788021404313e-22, -8.656902307182329e-24,  1.513026877665304e-11, -5.105269804868208e-12,
  9.316752748930815e-13, -1.182460900768559e-13,  1.160818475891379e-14, -9.344613706237495e-16,  6.399370622047452e-17, -3.823171741941427e-18,  2.029367630060722e-19,
 -9.704389970295653e-21,  4.226333047596955e-22, -1.688847895363025e-23,  3.905800589489480e-10, -9.679062001199071e-11,  1.334504673039009e-11, -1.316428501525211e-12,
  1.028896314775918e-13, -6.730050955620640e-15,  3.811249916928113e-16, -1.912005740793790e-17,  8.638828710086939e-19, -3.559232364479389e-20,  1.350166454203228e-21,
 -4.747445386475673e-23,  1.118658263195238e-08, -2.005188407585195e-09,  2.091795073703536e-10, -1.608231920423204e-11,  1.002287856565598e-12, -5.325019602836840e-14,
  2.487669938054914e-15, -1.043423872923345e-16,  3.988469140904347e-18, -1.405013098860418e-19,  4.600882496423288e-21, -1.409089213090885e-22,  2.509163532307033e-07,
 -3.271666326258838e-08,  2.629606708198428e-09, -1.602133992037619e-10,  8.079119139161444e-12, -3.529712724627445e-13,  1.374230612577441e-14, -4.858782989218330e-16,
  1.581287818610777e-17, -4.785094171896504e-19,  1.356924576256043e-20, -3.626053892053666e-22,  3.931123286265626e-06, -3.753089668643854e-07,  2.365110347550573e-08,
 -1.159059580439560e-09,  4.792729870675844e-11, -1.742054466005584e-12,  5.709849574866638e-14, -1.716595350454176e-15,  4.791950874096909e-17, -1.253439823533386e-18,
  3.093913040445736e-20, -7.243549715022046e-22,  4.167118636215487e-05, -2.921030487049885e-06,  1.461745091463661e-07, -5.820068461173084e-09,  1.991205844533242e-10,
 -6.069138285818709e-12,  1.686367209106955e-13, -4.336942526810193e-15,  1.043952773514287e-16, -2.370991156819730e-18,  5.113603097211802e-20, -1.052231303176629e-21,
  2.974348021198004e-04, -1.529066679511265e-05,  6.116189343251630e-07, -1.988472628342637e-08,  5.652305640382512e-10, -1.449919006160152e-11,  3.426177488316340e-13,
 -7.556743806211988e-15,  1.572172132817338e-16, -3.105608973651062e-18,  5.860606812075149e-20, -1.061190802660303e-21,  1.431096572427291e-03, -5.379219912384968e-05,
  1.716764922901179e-06, -4.558491524453526e-08,  1.075709957960654e-09, -2.320241894652198e-11,  4.658678822460231e-13, -8.800109967956312e-15,  1.581092955051613e-16,
 -2.711648558471747e-18,  4.470365936727549e-20, -7.117502731433481e-22,  4.626495267484726e-03, -1.270946338723963e-04,  3.190496823435625e-06, -6.880732798204456e-08,
  1.339640662837008e-09, -2.414908577522394e-11,  4.096739208332821e-13, -6.588148221946890e-15,  1.017633239271384e-16, -1.505618427398798e-18,  2.156987513172655e-20,
 -3.015051846805337e-22,  9.868993233333996e-03, -2.003839889220699e-04,  3.833223811638234e-06, -6.604924873510037e-08,  1.046989247196220e-09, -1.557419118682689e-11,
  2.204224292281736e-13, -2.984285798190190e-15,  3.917523506001739e-17, -4.944641998134826e-19,  6.096128551432264e-21, -7.432153172432294e-23,  1.308513632330967e-02,
 -2.042072995500769e-04,  2.853023742955339e-06, -3.767310709053899e-08,  4.719251146783692e-10, -5.656329892208015e-12,  6.499318201924442e-14, -7.342627755431547e-16,
  7.791203346329624e-18, -8.535435964324071e-20,  9.021651190875251e-22, -7.587941578397091e-24,  8.437103827567950e-03, -1.103734746261858e-04,  1.142175752576742e-06,
 -1.094681838780100e-08,  1.010942969094212e-10, -9.198966407842144e-13,  7.873232275664995e-15, -7.919608126886370e-17,  4.294763652502721e-19, -7.174330050927765e-21,
  7.729039978294506e-23,  1.534600107059583e-24,  2.506851615601150e-13, -1.037998830877873e-13,  2.306136956068711e-14, -3.498149279268990e-15,  4.031981792026035e-16,
 -3.750828336119123e-17,  2.927201598542981e-18, -1.968590387591231e-19,  1.163588141024823e-20, -6.136738896384188e-22,  2.922432348266055e-23, -1.266986815688616e-24,
  3.727114493460563e-12, -1.187065076102699e-12,  2.058514220967299e-13, -2.499632512899397e-14,  2.361091256969333e-15, -1.837350937111883e-16,  1.221056507776035e-17,
 -7.102530113715628e-19,  3.680921109204045e-20, -1.722738792419076e-21,  7.358389956875147e-23, -2.889304152120707e-24,  1.460987119297240e-10, -3.295239676004762e-11,
  4.204308141597702e-12, -3.880077610635101e-13,  2.860449407463798e-14, -1.776173416701697e-15,  9.598693177500546e-17, -4.615491401425399e-18,  2.006316836608940e-19,
 -7.978760972130451e-21,  2.929875297636723e-22, -9.998531879649633e-24,  5.590193930509583e-09, -8.949993581079843e-10,  8.557525326246032e-11, -6.105095030140651e-12,
  3.561937378196914e-13, -1.783395952995316e-14,  7.893473773406794e-16, -3.150699341704396e-17,  1.150440792410286e-18, -3.883987711913343e-20,  1.222472730472571e-21,
 -3.608168921492768e-23,  1.524651310881703e-07, -1.761202076967162e-08,  1.297184810457879e-09, -7.327213963979716e-11,  3.455351840165250e-12, -1.420542687850992e-13,
  5.230239328148149e-15, -1.755903796493066e-16,  5.445082547562103e-18, -1.574750892301675e-19,  4.279172606688038e-21, -1.098442448988431e-22,  2.735653142646454e-06,
 -2.309330583555684e-07,  1.339667316992314e-08, -6.101804940134613e-10,  2.364196986201307e-11, -8.096696611100770e-13,  2.511728983479534e-14, -7.172221557536533e-16,
  1.907604875261528e-17, -4.766717461789053e-19,  1.126606439666054e-20, -2.531096559404593e-22,  3.194941002957092e-05, -1.984813828029997e-06,  9.205753571500380e-08,
 -3.420682425528174e-09,  1.100357210360289e-10, -3.168288506865541e-12,  8.350444361312285e-14, -2.042835167422892e-15,  4.691076318282180e-17, -1.018675668987792e-18,
  2.104541656341598e-20, -4.157058686267844e-22,  2.447380563528419e-04, -1.121789535744238e-05,  4.189675628745608e-07, -1.277702676673802e-08,  3.428884090789280e-10,
 -8.336065783249020e-12,  1.874190844724042e-13, -3.939970533148206e-15,  7.836918031505443e-17, -1.482608983942407e-18,  2.681939202826161e-20, -4.669915040801018e-22,
  1.240302646135825e-03, -4.198526123382920e-05,  1.259461880647727e-06, -3.155298732634118e-08,  7.061237040790094e-10, -1.448592796665077e-11,  2.777685798838626e-13,
 -5.010538469670857e-15,  8.633858754791146e-17, -1.421444776181956e-18,  2.244803896368876e-20, -3.455523439743378e-22,  4.164405373448667e-03, -1.045425511775824e-04,
  2.479049732595259e-06, -5.075940281356236e-08,  9.417477744795807e-10, -1.620726785153868e-11,  2.636993764390564e-13, -4.055350280301824e-15,  6.034718850372220e-17,
 -8.598868930094133e-19,  1.173006135543755e-20, -1.612879001158563e-22,  9.124142140805013e-03, -1.726257180277235e-04,  3.131723972024341e-06, -5.152791763489497e-08,
  7.823064096560497e-10, -1.116002677717291e-11,  1.520385799700267e-13, -1.974179826158458e-15,  2.507189356373011e-17, -3.057343719484674e-19,  3.560244014356198e-21,
 -4.393594373680229e-23,  1.231126288641989e-02, -1.830711348795589e-04,  2.442774668228860e-06, -3.094908427935990e-08,  3.728659859466129e-10, -4.317637537947090e-12,
  4.750866290161905e-14, -5.277070147918257e-16,  5.301021064292577e-18, -5.449334300399496e-20,  6.731661216114634e-22, -3.161063823179067e-24,  8.013089839226776e-03,
 -1.017353534198401e-04,  1.019943110196719e-06, -9.466955228393883e-09,  8.441342650058485e-11, -7.562093922019253e-13,  5.814502536606135e-15, -6.882323988059211e-17,
  2.481712956850956e-19, -2.180581784319453e-21,  1.854892099408403e-22,  3.302588333080093e-24,  4.098591510351525e-14, -1.670732823323051e-14,  3.657675417275687e-15,
 -5.477309604957356e-16,  6.242931825735799e-17, -5.751226877226648e-18,  4.450116289835997e-19, -2.970286089558860e-20,  1.743962315228265e-21, -9.142932155271803e-23,
  4.330838809172357e-24, -1.868601634131243e-25,  1.009761033434784e-12, -2.995843133829729e-13,  4.888671574735000e-14, -5.635152796772053e-15,  5.088113598204185e-16,
 -3.806143504991689e-17,  2.442764375913880e-18, -1.377496862715908e-19,  6.943733134491112e-21, -3.169876004443465e-22,  1.323906500030026e-23, -5.094125446982679e-25,
  6.030416329150820e-11, -1.222337221416164e-11,  1.432698243624660e-12, -1.229898444643890e-13,  8.511065362975024e-15, -4.995630825716810e-16,  2.566418771179108e-17,
 -1.178662894651451e-18,  4.913296279601475e-20, -1.880292685065882e-21,  6.664811351886345e-23, -2.201562553980239e-24,  3.023365261476867e-09, -4.282114363691216e-10,
  3.740269391498748e-11, -2.468976359934316e-12,  1.345369656145149e-13, -6.334263142560020e-15,  2.650879786435904e-16, -1.004984685965255e-17,  3.498780050504840e-19,
 -1.130004151760535e-20,  3.412480390870275e-22, -9.689759627900680e-24,  9.829267427595845e-08, -9.990423663527074e-09,  6.741288343055432e-10, -3.526944757851446e-11,
  1.554466789498984e-12, -6.009294055607751e-14,  2.090993234310575e-15, -6.660770112310803e-17,  1.966603848964719e-18, -5.431376046191358e-20,  1.413105276715648e-21,
 -3.481416103687392e-23,  1.987581889225940e-06, -1.476651061917478e-07,  7.899792141173083e-09, -3.344664284485095e-10,  1.214907860961459e-11, -3.920744200375950e-13,
  1.151467120893696e-14, -3.123003611819795e-16,  7.913717037726716e-18, -1.889040128192187e-19,  4.274016697634668e-21, -9.212617313086075e-23,  2.525979449406792e-05,
 -1.386810439931359e-06,  5.978779261739242e-08, -2.074926433663007e-09,  6.282936371043678e-11, -1.709798876995638e-12,  4.278768598283013e-14, -9.960490752510499e-16,
  2.182826909423967e-17, -4.535433908300479e-19,  8.973809540598232e-21, -1.702362296838493e-22,  2.057156609599770e-04, -8.397437001336560e-06,  2.937589251537556e-07,
 -8.413164460454480e-09,  2.134911786003931e-10, -4.921255824082100e-12,  1.054575576451464e-13, -2.113524226455880e-15,  4.020900923159212e-17, -7.301690629782194e-19,
  1.263874936461692e-20, -2.120220422505960e-22,  1.090359786438817e-03, -3.325192522612117e-05,  9.401084686055581e-07, -2.225317984707848e-08,  4.731389566555709e-10,
 -9.232574035292916e-12,  1.695426120580140e-13, -2.919088623385799e-15,  4.823205030853039e-17, -7.673220451655767e-19,  1.150788075106342e-20, -1.724015030935060e-22,
  3.782373999713901e-03, -8.691302715278207e-05,  1.950664977558395e-06, -3.797575533154424e-08,  6.727098932192799e-10, -1.104854511839459e-11,  1.731043685298817e-13,
 -2.541304660146739e-15,  3.635888208914613e-17, -5.078229273315073e-19,  6.399910612805671e-21, -8.842303855460423e-23,  8.480110287646827e-03, -1.498482412324748e-04,
  2.581719277020466e-06, -4.061564546341368e-08,  5.915463776047505e-10, -8.093039498731720e-12,  1.065149524544097e-13, -1.323920357447175e-15,  1.621657236686311e-17,
 -1.962347633433522e-19,  2.040528886370483e-21, -2.654861454068729e-23,  1.161584561736139e-02, -1.649192579627288e-04,  2.104518883741729e-06, -2.561679955819435e-08,
  2.968105060448655e-10, -3.337203314585234e-12,  3.484853939294210e-14, -3.844861767900378e-16,  3.798042090709470e-18, -2.954915892966454e-20,  5.889041278206581e-22,
 -1.136822227317098e-24,  7.621778984187789e-03, -9.400836530384560e-05,  9.139670463925748e-07, -8.230391216093352e-09,  7.053316837447722e-11, -6.389024941138395e-13,
  3.998779606849067e-15, -6.040351059155902e-17,  3.407998883358522e-19,  8.392341771794424e-21,  3.447039880184242e-22,  3.475902823551859e-24,  6.960215395736388e-15,
 -2.777535184869966e-15,  5.963629226751073e-16, -8.782393249249766e-17,  9.867639923351928e-18, -8.978939139878781e-19,  6.873611506386608e-20, -4.545152624322268e-21,
  2.646757451015956e-22, -1.377532374797267e-23,  6.483016639166105e-25, -2.781090533894638e-26,  3.043180619788643e-13, -8.279447839209890e-14,  1.257699331614725e-14,
 -1.364486310500937e-15,  1.169364208136324e-16, -8.357695628666793e-18,  5.152692404097111e-19, -2.803780558543710e-20,  1.368981931814484e-21, -6.073153390126322e-23,
  2.471861268728652e-24, -9.292329954245371e-26,  2.747244065316265e-11, -4.937241523266278e-12,  5.281683036812975e-13, -4.195287204485311e-14,  2.713258554472898e-15,
 -1.499523194012978e-16,  7.297191773766038e-18, -3.190382124290649e-19,  1.271419360732787e-20, -4.668714747860191e-22,  1.593002049199566e-23, -5.080257881023178e-25,
  1.762631888364237e-09, -2.186857869721618e-10,  1.741411408494078e-11, -1.061134649565221e-12,  5.390982473138377e-14, -2.382659975279772e-15,  9.413058670209464e-17,
 -3.384081908650835e-18,  1.121542314677010e-19, -3.459854514594395e-21,  1.000937242170696e-22, -2.730115641014014e-24,  6.693206480097914e-08, -5.943836508432503e-09,
  3.678269295310884e-10, -1.781218232385049e-11,  7.336790029974613e-13, -2.665794018990932e-14,  8.763669797068606e-16, -2.647617075365546e-17,  7.438672148173222e-19,
 -1.960888944634447e-20,  4.881464721254613e-22, -1.153478517895272e-23,  1.501885304337256e-06, -9.772792665264726e-08,  4.835336315020965e-09, -1.903264831912701e-10,
  6.487780773373371e-12, -1.973136486112743e-13,  5.489387897733297e-15, -1.414446060886086e-16,  3.414468681916073e-18, -7.789260892733740e-20,  1.686629452311674e-21,
 -3.487852516947340e-23,  2.053256843167832e-05, -9.932932917253620e-07,  3.994969400585836e-08, -1.295663096666810e-09,  3.699527587505060e-11, -9.515654981260582e-13,
  2.264315918969557e-14, -5.018998452520633e-16,  1.049163926999135e-17, -2.090261509538755e-19,  3.957272625084592e-21, -7.212285990721144e-23,  1.762597888078588e-04,
 -6.399805020562157e-06,  2.104442327982467e-07, -5.664974853635068e-09,  1.362421510520154e-10, -2.976226557311563e-12,  6.094342870100297e-14, -1.165558121547707e-15,
  2.115093002737110e-17, -3.712890574179909e-19,  6.120380133123312e-21, -9.892325201584434e-23,  9.708674177201347e-04, -2.668323973286056e-05,  7.130452660673370e-07,
 -1.596403513118131e-08,  3.233607449156053e-10, -5.992638402242930e-12,  1.058200109634143e-13, -1.741788350258492e-15,  2.734167009789550e-17, -4.293588371660636e-19,
  6.005777495991504e-21, -8.718762524481134e-23,  3.463284264181799e-03, -7.296300495350638e-05,  1.552914366321169e-06, -2.877646439547778e-08,  4.881340258184268e-10,
 -7.631743159553440e-12,  1.158006771511911e-13, -1.627679110823248e-15,  2.187486193194251e-17, -3.159863867153555e-19,  3.489937977789286e-21, -4.723475150372210e-23,
  7.919150042661569e-03, -1.309945949729191e-04,  2.146196426550180e-06, -3.231852146655437e-08,  4.525237617225229e-10, -5.928895433491871e-12,  7.574838645137549e-14,
 -9.043257873605290e-16,  1.037406693380735e-17, -1.342620695551081e-19,  1.143985262683292e-21, -1.469312575930645e-23,  1.098800164925772e-02, -1.492367753338831e-04,
  1.823546312928724e-06, -2.135976573050125e-08,  2.376254655720258e-10, -2.617114791808733e-12,  2.565637556796672e-14, -2.755220285188680e-16,  3.145721761350189e-18,
 -7.099739500020140e-21,  5.244147093958681e-22, -2.404533854778061e-24,  7.259769329677474e-03, -8.707344269282910e-05,  8.215672431094831e-07, -7.199418819118593e-09,
  5.858575244797450e-11, -5.616139684570734e-13,  2.526105727327106e-15, -4.174163579518847e-17,  9.218178370946628e-19,  2.449909213738023e-20,  4.339247572066854e-22,
 -2.165115163623965e-25,  1.243066543424066e-15, -4.816051830627348e-16,  1.007390292446722e-16, -1.451265311287547e-17,  1.600612872109277e-18, -1.433639335722592e-19,
  1.082714834751922e-20, -7.075957127643278e-22,  4.078612111176833e-23, -2.103806200652207e-24,  9.822983821359876e-26, -4.184441815119630e-27,  1.030539409437725e-13,
 -2.524195884537683e-14,  3.529136668291888e-15, -3.571463954600861e-16,  2.883626449232654e-17, -1.956670818721334e-18,  1.152370319491559e-19, -6.020721852237095e-21,
  2.834803703262794e-22, -1.217211180201219e-23,  4.810540132536872e-25, -1.760969844094141e-26,  1.378994529572062e-11, -2.166031077295451e-12,  2.103930383432264e-13,
 -1.539063561661705e-14,  9.267682143000033e-16, -4.806059132269945e-17,  2.208429473168362e-18, -9.164403575214653e-20,  3.481666545477651e-21, -1.223444856388023e-22,
  4.008127453705848e-24, -1.231020728970039e-25,  1.102634506515566e-09, -1.186027471864303e-10,  8.607685916047495e-12, -4.832193472237979e-13,  2.286505516080869e-14,
 -9.473724321133809e-16,  3.528965894804690e-17, -1.201640378246962e-18,  3.786241357595489e-20, -1.114274887876139e-21,  3.084158070607896e-23, -8.070093828060556e-25,
  4.792456490816332e-08, -3.690820897697162e-09,  2.100333701754995e-10, -9.406667940871133e-12,  3.623556254877388e-13, -1.236991064950656e-14,  3.842015691050262e-16,
 -1.100803651226223e-17,  2.941440600185451e-19, -7.400028194824209e-21,  1.761735235863913e-22, -3.990833802928255e-24,  1.176021442121319e-06, -6.667552743080257e-08,
  3.063996920819688e-09, -1.120875705399820e-10,  3.592462952595769e-12, -1.029373451042987e-13,  2.715003423670316e-15, -6.653136747942833e-17,  1.528467322876618e-18,
 -3.337032598708930e-20,  6.912947624998165e-22, -1.371051152657557e-23,  1.711263491783035e-05, -7.271006292928344e-07,  2.740930767931556e-08, -8.306374462345556e-10,
  2.243011215852078e-11, -5.448271504033582e-13,  1.234545651153453e-14, -2.612970201073736e-16,  5.188648922909767e-18, -9.966264217112415e-20,  1.803226105495176e-21,
 -3.149105546958167e-23,  1.536440802701329e-04, -4.955169641149317e-06,  1.538095758632324e-07, -3.891689681135894e-09,  8.904895301644031e-11, -1.839580291416577e-12,
  3.606730716334997e-14, -6.627025978230473e-16,  1.131378079506361e-17, -1.953039284915246e-19,  3.054880349989780e-21, -4.678876837492901e-23,  8.744431144962835e-04,
 -2.166548516034028e-05,  5.489699240098041e-07, -1.162606713265568e-08,  2.254102489536282e-10, -3.952123998722743e-12,  6.726713439376291e-14, -1.074355663508970e-15,
  1.542620255300314e-17, -2.506935302517427e-19,  3.252251807907604e-21, -4.224292298278313e-23,  3.194265160774098e-03, -6.179887863679508e-05,  1.249870662141167e-06,
 -2.205059310324905e-08,  3.599671559029146e-10, -5.329965998619881e-12,  7.848666287637199e-14, -1.086281086012300e-15,  1.259159266779714e-17, -2.092572793385091e-19,
  2.046845095053253e-21, -1.954548865071557e-23,  7.427217244893035e-03, -1.152616364993346e-04,  1.798201322618744e-06, -2.593597725953844e-08,  3.502504326706494e-10,
 -4.381453210806823e-12,  5.440477660874923e-14, -6.419373618375201e-16,  6.236808586501435e-18, -9.832368325447400e-20,  7.302076647705413e-22, -4.023756395071750e-24,
  1.041869420912283e-02, -1.356128123099329e-04,  1.588415567567828e-06, -1.794546070792916e-08,  1.908741081000550e-10, -2.082660021705022e-12,  1.933995168410020e-14,
 -1.751760588010076e-16,  3.231299379859642e-18,  1.049571289979154e-20,  3.152525314512196e-22, -7.963423207674552e-24,  6.924094875309543e-03, -8.083137546814559e-05,
  7.404375382632390e-07, -6.348936789807425e-09,  4.788618162684366e-11, -5.107473772747935e-13,  1.926060193008444e-15,  5.071069624460624e-18,  2.093877859162422e-18,
  3.937210916438400e-20,  2.407076316451443e-22, -9.766755248413032e-24,  2.375553832722599e-16, -8.824451347784753e-17,  1.781370981831076e-17, -2.492267986598891e-18,
  2.682782362900731e-19, -2.354403669456783e-20,  1.747580884368873e-21, -1.125298934605192e-22,  6.403711459162092e-24, -3.266509125226741e-25,  1.510361316987800e-26,
 -6.378913666145675e-28,  3.951586446583093e-14, -8.530653424621674e-15,  1.085649258489827e-15, -1.015668299544524e-16,  7.669423861013444e-18, -4.909128797016285e-19,
  2.746304464998610e-20, -1.370714281759401e-21,  6.195064135862803e-23, -2.563881861990693e-24,  9.801285080236238e-26, -3.481598242124096e-27,  7.601189724693094e-12,
 -1.027462897561850e-12,  9.034979736919534e-14, -6.061215735036338e-15,  3.388473469121826e-16, -1.644028408603995e-17,  7.114251703135391e-19, -2.794958834080084e-20,
  1.009739129982982e-21, -3.387316925423278e-23,  1.063001523719740e-24, -3.137081404657468e-26,  7.364210661029661e-10, -6.790574224544078e-11,  4.501679439057085e-12,
 -2.323197014935333e-13,  1.023833975394613e-14, -3.972664591051348e-16,  1.394087671301177e-17, -4.493056716350697e-19,  1.344445539753178e-20, -3.771364384019425e-22,
  9.976556275841081e-24, -2.501584240438413e-25,  3.592481073901917e-08, -2.379512797658072e-09,  1.251519159573813e-10, -5.175559946168776e-12,  1.868051105847933e-13,
 -5.989009331294853e-15,  1.757190633972352e-16, -4.779917530112517e-18,  1.213262844504929e-19, -2.914609643439527e-21,  6.634383222922574e-23, -1.439511983656185e-24,
  9.510234163290931e-07, -4.670285370231807e-08,  2.005833162416759e-09, -6.808426640407463e-11,  2.058888662889697e-12, -5.554970535397513e-14,  1.388439827897597e-15,
 -3.249570465778717e-17,  7.075103985662037e-19, -1.482824916313870e-20,  2.942367013583674e-22, -5.572385520567395e-24,  1.458729237437054e-05, -5.423304342185592e-07,
  1.928144239579859e-08, -5.450175666222463e-10,  1.398837296034101e-11, -3.204469300217753e-13,  6.899803389925327e-15, -1.410606881067961e-16,  2.623820460333367e-18,
 -4.903355522986353e-20,  8.545735426612775e-22, -1.394322381895609e-23,  1.360194447487810e-04, -3.889792021911248e-06,  1.145805918640988e-07, -2.719856051543419e-09,
  5.959713526296982e-11, -1.161465020714722e-12,  2.167080064001787e-14, -3.930457368658057e-16,  6.068888771531366e-18, -1.054643485307907e-19,  1.623831708981807e-21,
 -2.090411608778331e-23,  7.957604094232706e-04, -1.777594979253543e-05,  4.287464900714782e-07, -8.573449571356042e-09,  1.603311500360280e-10, -2.650436200946770e-12,
  4.290005318556062e-14, -7.030905043075970e-16,  8.378356306772787e-18, -1.487535306183529e-19,  2.052046684988542e-21, -1.352601689832748e-23,  2.965520056506215e-03,
 -5.276791566009732e-05,  1.016607673694041e-06, -1.705117267035756e-08,  2.699486703889274e-10, -3.772174594909870e-12,  5.268442168926880e-14, -7.893181182445715e-16,
  6.392714764003488e-18, -1.370701092141793e-19,  1.757159772136625e-21,  7.432949210841908e-24,  6.993097046931553e-03, -1.020319124330126e-04,  1.517915874855825e-06,
 -2.096780447357824e-08,  2.743259928884994e-10, -3.271951069928034e-12,  3.873170203615723e-14, -4.934929586545026e-16,  3.212584601960316e-18, -6.903296810942864e-20,
  8.338307143699507e-22,  9.757853460197827e-24,  9.900363073294619e-03, -1.237179613291273e-04,  1.390097050350171e-06, -1.520093357505450e-08,  1.535273179645112e-10,
 -1.665259937139566e-12,  1.595197768368113e-14, -6.415748623530124e-17,  3.723911975131658e-18,  1.289616458027680e-20, -2.950174904170258e-22, -2.184451878534522e-23,
  6.612151241184282e-03, -7.520035825229069e-05,  6.685189100078901e-07, -5.661764158426172e-09,  3.818983825680577e-11, -4.538962693658863e-13,  3.226227085576872e-15,
  9.549291752740778e-17,  3.537498534591001e-18,  3.541617228114648e-20, -5.903653140311680e-22, -3.086013575366200e-23,  4.975137056080587e-17, -1.738253946955465e-17,
  3.341977312268860e-18, -4.496027869272482e-19,  4.687416914389599e-20, -4.006047610633287e-21,  2.908078326721005e-22, -1.837526762324720e-23,  1.028898563536074e-24,
 -5.175596583477990e-26,  2.364205128702990e-27, -9.879808968525775e-29,  1.723574844742248e-14, -3.199639339985853e-15,  3.672195177192757e-16, -3.148462658867452e-17,
  2.208313586834017e-18, -1.325269058273295e-19,  7.003893399223451e-21, -3.322894390051964e-22,  1.434995153129702e-23, -5.700081288433982e-25,  2.099557212688969e-26,
 -7.210949948446755e-28,  4.579702806073182e-12, -5.234952265394291e-13,  4.170359384784181e-14, -2.554797101273052e-15,  1.323696215689200e-16, -5.994674285050844e-18,
  2.437447649611766e-19, -9.048031961598743e-21,  3.101580033763946e-22, -9.913048779099692e-24,  2.973824803363692e-25, -8.415572968487271e-27,  5.224306141145031e-10,
 -4.076273128045514e-11,  2.483529124028361e-12, -1.174300513520107e-13,  4.826357428435025e-15, -1.752814762573087e-16,  5.787755707078009e-18, -1.766511771210604e-19,
  5.012627114066158e-21, -1.339714767603359e-22,  3.385426186776462e-24, -8.122588573273915e-26,  2.807721232183578e-08, -1.583725644289063e-09,  7.766025590234917e-11,
 -2.954477216377813e-12,  1.002705858087863e-13, -3.020387234433126e-15,  8.350298513929506e-17, -2.166601443431237e-18,  5.206775801407439e-20, -1.195017172975379e-21,
  2.608579404911964e-23, -5.388428921298883e-25,  7.918233636117718e-07, -3.343825684382284e-08,  1.354930427517429e-09, -4.248841041772460e-11,  1.218810420409968e-12,
 -3.100983068611296e-14,  7.290668179528467e-16, -1.652944024464629e-17,  3.375909945691861e-19, -6.785767106672304e-21,  1.314398474404889e-22, -2.295819589534483e-24,
  1.268984799358644e-05, -4.108695649072324e-07,  1.389846551912543e-08, -3.646687521815787e-10,  8.958347339848665e-12, -1.941818135722996e-13,  3.901184120411157e-15,
 -7.976541373560949e-17,  1.352731015376899e-18, -2.428176054961697e-20,  4.422886963540312e-22, -5.725775211720630e-24,  1.221076251555448e-04, -3.089088905383148e-06,
  8.697925154201531e-08, -1.927265385905833e-09,  4.077743358026267e-11, -7.545827540858082e-13,  1.289410992536319e-14, -2.485400244345540e-16,  3.266549691756333e-18,
 -5.384729996137043e-20,  1.071474651288033e-21, -5.110477120120977e-24,  7.309216473218445e-04, -1.471758981312858e-05,  3.396717034743832e-07, -6.382485632420411e-09,
  1.161614017446986e-10, -1.831179151876295e-12,  2.627047015930228e-14, -5.055186510398063e-16,  4.428808056163083e-18, -7.067891317996770e-20,  2.052162325536234e-21,
  1.396959191523488e-23,  2.769514846925015e-03, -4.538540768836648e-05,  8.356219297211236e-07, -1.327399325025562e-08,  2.054612340153441e-10, -2.753891037541797e-12,
  3.280897906774577e-14, -6.488959014721915e-16,  2.895191522504805e-18, -4.980260779492150e-20,  2.891977330254598e-21,  4.644426012800200e-23,  6.607761668053470e-03,
 -9.082509117980496e-05,  1.290629238635602e-06, -1.705611061741472e-08,  2.171145533045808e-10, -2.498626365092455e-12,  2.603194173528979e-14, -4.228360764957915e-16,
  1.483826074218002e-18, -2.117651045731960e-20,  1.722155904022354e-21,  3.196404540190491e-23,  9.426633294872273e-03, -1.132874683902941e-04,  1.221391703486555e-06,
 -1.299050094026276e-08,  1.239760286753843e-10, -1.290210455379227e-12,  1.586446384484917e-14,  5.784690962597847e-17,  3.676865202111731e-18, -2.578687285688802e-20,
 -1.862278452964726e-21, -5.225866143015130e-23,  6.321629613048126e-03, -7.011424111159396e-05,  6.039610871664934e-07, -5.117991028590528e-09,  3.017305544466798e-11,
 -3.306514913679920e-13,  7.625591466450192e-15,  2.212521921707409e-16,  3.962649524292773e-18, -2.642811021099312e-20, -2.820031129473887e-21, -7.418029801646191e-23,
  1.179146011459822e-17, -3.760741389911852e-18,  6.764373346937461e-19, -8.635458209778314e-20,  8.632220857299602e-21, -7.127294977587689e-22,  5.027545912484653e-23,
 -3.100972672406295e-24,  1.701082288584328e-25, -8.407675342275486e-27,  3.782740635022968e-28, -1.560096575306198e-29,  8.561570901991727e-15, -1.327199521399271e-15,
  1.366880810083451e-16, -1.064876629944144e-17,  6.898215122439135e-19, -3.859866274230561e-20,  1.917318540411070e-21, -8.606963550894004e-23,  3.535943650560533e-24,
 -1.342606002092028e-25,  4.746672828433901e-27, -1.570552512493082e-28,  2.999794078538363e-12, -2.838973401399243e-13,  2.063199852646211e-14, -1.147686539937174e-15,
  5.510081547593647e-17, -2.326034104293153e-18,  8.865228696626371e-20, -3.106914852623520e-21,  1.008388433643446e-22, -3.065606262334049e-24,  8.779101155290406e-26,
 -2.376878237395432e-27,  3.917464879296050e-10, -2.544296386661485e-11,  1.442542164359370e-12, -6.211085280807018e-14,  2.386828822733640e-15, -8.127448136269808e-17,
  2.514553469732961e-18, -7.295894521789514e-20,  1.959133699933098e-21, -4.979544098605455e-23,  1.206640305739955e-24, -2.752669437229610e-26,  2.279356543329818e-08,
 -1.080958675184028e-09,  5.014257940549985e-11, -1.742207117668250e-12,  5.581702418157385e-14, -1.589567091746150e-15,  4.090336696603411e-17, -1.025941761614470e-18,
  2.327149909702794e-20, -5.039998821742965e-22,  1.085068075956975e-23, -2.062846210507423e-25,  6.769329069744601e-07, -2.434840007687493e-08,  9.443056424663559e-10,
 -2.713628071570877e-11,  7.415702432101302e-13, -1.803912629932660e-14,  3.870064234303251e-16, -8.786438926052306e-18,  1.682829493313993e-19, -3.052360971759265e-21,
  6.523374394969705e-23, -9.095184880195373e-25,  1.124411864608409e-05, -3.150148210278667e-07,  1.026887711467054e-08, -2.479977349503331e-10,  5.852349940636723e-12,
 -1.231592141243083e-13,  2.164305772302238e-15, -4.745168546977309e-17,  7.498713814912826e-19, -1.018868757107659e-20,  2.918167906173063e-22, -1.698901838870638e-24,
  1.110107359669731e-04, -2.475720851403899e-06,  6.731714286588108e-08, -1.380919456713390e-09,  2.827117443350872e-11, -5.183239703171211e-13,  7.164485952650418e-15,
 -1.669779993776986e-16,  2.077609909128996e-18, -1.205914058169979e-20,  1.085286752462969e-21,  3.795129530854342e-24,  6.770421552291866e-04, -1.227756323271613e-05,
  2.731232487793611e-07, -4.787183846260244e-09,  8.477118850609851e-11, -1.356273671978783e-12,  1.383976878229396e-14, -3.869985933536938e-16,  3.579005016655545e-18,
  3.093758298368082e-20,  3.155104514925449e-21,  2.978438362061799e-23,  2.600408035473602e-03, -3.928563637938096e-05,  6.943628517196712e-07, -1.039045480637378e-08,
  1.568362134525724e-10, -2.174781425137010e-12,  1.585330744476514e-14, -5.578986854771564e-16,  3.782341829660564e-18,  1.176464282652983e-19,  5.644152582771485e-21,
  6.568513199393648e-23,  6.263893725380591e-03, -8.126329239959080e-05,  1.105248998274638e-06, -1.395204496306486e-08,  1.724574127976099e-10, -2.010720701047567e-12,
  1.485534935863739e-14, -3.711181400046261e-16,  2.356850916443248e-18,  8.156106259180581e-20,  3.481593842342924e-21,  3.904979566129893e-23,  8.992083605438357e-03,
 -1.041079803946097e-04,  1.076624908121771e-06, -1.119185798076521e-08,  1.021732961990998e-10, -8.782259620015323e-13,  1.886024839687847e-14,  1.411676294789480e-16,
  7.632848636091792e-19, -1.556148178205179e-19, -4.769159728726114e-21, -6.846932016689157e-23,  6.050458077805423e-03, -6.552043546084583e-05,  5.452621218986958e-07,
 -4.675838753233824e-09,  2.595890055612582e-11, -6.079899323014214e-14,  1.525653574888478e-14,  3.038494247917222e-16,  7.230553813548257e-20, -2.170102710901018e-19,
 -6.877405207326048e-21, -9.293173169016102e-23,  3.294722464156541e-18, -9.152344909337224e-19,  1.506599021139135e-19, -1.794096090170400e-20,  1.697898264222846e-21,
 -1.340724638903716e-22,  9.115353830214814e-24, -5.451727295761576e-25,  2.913738490514426e-26, -1.408526865441354e-27,  6.217585097711552e-29, -2.522501675792990e-30,
  4.834435033550608e-15, -6.029299269156440e-16,  5.596118906226383e-17, -3.923130079876315e-18,  2.338057446707187e-19, -1.214415383722756e-20,  5.642364440835030e-22,
 -2.387805701903961e-23,  9.293069033883643e-25, -3.360187997159912e-26,  1.136345100651809e-27, -3.608751050774299e-29,  2.124384041196612e-12, -1.618515008793470e-13,
  1.092126214613033e-14, -5.467567116418836e-16,  2.433626972082611e-17, -9.596659677052059e-19,  3.410309523411807e-20, -1.130461620642195e-21,  3.468659190993843e-23,
 -9.992565434433422e-25,  2.739296634262038e-26, -7.060112434354731e-28,  3.091117213847261e-10, -1.633995948121741e-11,  8.816963463049631e-13, -3.423199888935544e-14,
  1.229992712478202e-15, -3.972894302770911e-17,  1.134756853172767e-18, -3.157166437547809e-20,  8.069903677934808e-22, -1.908540676290225e-23,  4.560234627237152e-25,
 -9.744603739762628e-27,  1.915823644331893e-08, -7.503743655636613e-10,  3.369473242116687e-11, -1.058568895691288e-12,  3.188906539898825e-14, -8.826067110731556e-16,
  2.038408467168988e-17, -5.026101465116670e-19,  1.118608025281586e-20, -2.059996521875009e-22,  4.918156377991899e-24, -8.562816974671509e-26,  5.928381241712883e-07,
 -1.791930489207910e-08,  6.793852033846142e-10, -1.772659703626125e-11,  4.565156509961293e-13, -1.117993618472888e-14,  2.030560296531795e-16, -4.722062131018297e-18,
  9.749422955004620e-20, -1.061804977468240e-21,  3.710202520629907e-23, -5.276664768417045e-25,  1.013153464302406e-05, -2.433467795635651e-07,  7.781462033368253e-09,
 -1.716498869970015e-10,  3.813837034477330e-12, -8.470966079694470e-14,  1.131783417884241e-15, -2.719809041496791e-17,  5.776361421248822e-19,  1.630508667515982e-22,
  2.170458750070843e-22, -3.002366511780422e-24,  1.020898618578867e-04, -1.996512589622927e-06,  5.314428787245981e-08, -1.003626619348387e-09,  1.928370369447029e-11,
 -3.950629364029447e-13,  3.415875197172509e-15, -9.882304070215065e-17,  2.448414285724366e-18,  3.224794744420984e-20,  9.866357699379559e-22, -1.666561736759835e-23,
  6.319680090766586e-04, -1.030126586143684e-05,  2.229689360397444e-07, -3.633230777324953e-09,  6.016414718294563e-11, -1.139255441582419e-12,  4.960342651254088e-15,
 -2.283559928600744e-16,  7.171774063654731e-18,  1.690771089717798e-19,  3.077364989493917e-21, -6.567692531834270e-23,  2.453641626347621e-03, -3.419001245012139e-05,
  5.833515015289021e-07, -8.213366466030180e-09,  1.159734122779648e-10, -1.962492085857701e-12,  2.899894138417786e-15, -3.213803394481243e-16,  1.252203237072699e-17,
  3.683604011089602e-19,  5.434108333955266e-21, -1.397531997480224e-22,  5.955526516566079e-03, -7.304703736281275e-05,  9.531068551744165e-07, -1.149840528547072e-08,
  1.350258616773575e-10, -1.766626406175525e-12,  6.167375784020563e-15, -2.195796610538038e-16,  8.029733576404952e-18,  2.319443650633093e-19,  3.055428481198948e-21,
 -9.875396804594387e-23,  8.592064785098174e-03, -9.600556769469006e-05,  9.516349042276221e-07, -9.671694293254291e-09,  8.944250139274651e-11, -3.820038940132041e-13,
  2.202239122341550e-14,  3.463876899670356e-17, -8.762404122641815e-18, -3.762717072662587e-19, -4.912451277584086e-21,  1.222362366401193e-22,  5.796755192449369e-03,
 -6.137566708803499e-05,  4.916761006815794e-07, -4.247544747281546e-09,  2.905688457610272e-11,  3.984325184605687e-13,  2.220714655082993e-14,  1.222115764323150e-16,
 -1.331648472042173e-17, -5.279392185464227e-19, -6.675078138472801e-21,  1.877501000357338e-22,  1.137212676612499e-18, -2.555919239078569e-19,  3.772858389272543e-20,
 -4.100340249173145e-21,  3.620506233943343e-22, -2.701046870733107e-23,  1.752401532219926e-24, -1.008077471679760e-25,  5.213325468801611e-27, -2.450795572899916e-28,
  1.056333426953392e-29, -4.198434988433500e-31,  3.090269764953483e-15, -2.945591710824543e-16,  2.519558680063198e-17, -1.568149858286868e-18,  8.574363778087495e-20,
 -4.132116989541802e-21,  1.783411725637236e-22, -7.103659527080923e-24,  2.611175238943197e-25, -8.942300841571825e-27,  2.890307960178937e-28, -8.772623481569200e-30,
  1.617894887151055e-12, -9.532157716691468e-14,  6.182363134146471e-15, -2.753197397601873e-16,  1.129435171737471e-17, -4.225507196562215e-19,  1.379843355346130e-20,
 -4.332505726870518e-22,  1.272952204072827e-23, -3.392084516079531e-25,  9.038129299574994e-27, -2.241615946446274e-28,  2.556606087997974e-10, -1.064704482450596e-11,
  5.668533814296695e-13, -1.968412693969928e-14,  6.489374717994810e-16, -2.071182246318907e-17,  5.299448272534437e-19, -1.391794658496524e-20,  3.657151121098828e-22,
 -7.252514782926999e-24,  1.752172389413688e-25, -4.205509926446845e-27,  1.662607189881221e-08, -5.241439232173766e-10,  2.354534865670032e-11, -6.671129758139506e-13,
  1.817355918874494e-14, -5.274793505905188e-16,  1.043934159799647e-17, -2.319672124110255e-19,  6.508936782868078e-21, -7.427541078723986e-23,  1.769343190129527e-24,
 -7.077412604488696e-26,  5.308386679302952e-07, -1.322639959083486e-08,  5.038621282413090e-10, -1.198532404152818e-11,  2.726462542324437e-13, -7.566957882831891e-15,
  1.105232417893844e-16, -1.978328798136574e-18,  7.946328320359546e-20, -1.580358046941769e-22,  3.474209015647581e-24, -1.143274675364820e-24,  9.270910975918318e-06,
 -1.884172154122627e-07,  6.036048222770004e-09, -1.229269501136515e-10,  2.340595224309087e-12, -6.454011941225187e-14,  6.397064121179478e-16, -7.337375152647217e-18,
  6.866162808383208e-19,  3.727451543762957e-21, -1.154711119332685e-22, -1.325486684280725e-23,  9.488448931125350e-05, -1.614862722322061e-06,  4.270353859084706e-08,
 -7.546086352885282e-10,  1.202925439279454e-11, -3.361427068787754e-13,  1.961048798783364e-15,  3.203565460558149e-18,  3.973765064696489e-18,  3.768395682439473e-20,
 -1.279737829592090e-21, -9.199614223914804e-23,  5.940751853814291e-04, -8.677243073147580e-06,  1.844103229043232e-07, -2.848045643673503e-09,  3.821191774036471e-11,
 -1.064746581192540e-12,  2.809829711728568e-15,  1.122421855208436e-16,  1.409264057411439e-17,  1.565010320562474e-19, -5.909022331710868e-21, -3.584840171615343e-22,
  2.325631602718245e-03, -2.988886697987387e-05,  4.946355230497541e-07, -6.670085803525832e-09,  7.698070557573438e-11, -1.942302922127866e-12,  1.691157324258178e-15,
  3.125366831848119e-16,  2.683115429736476e-17,  3.063298918460912e-19, -1.286290968240274e-20, -7.132596145765406e-22,  5.677762563719034e-03, -6.594001985690175e-05,
  8.269443258634232e-07, -9.614072720664065e-09,  1.008603995525167e-10, -1.655105012144556e-12,  4.963612164548505e-15,  1.804721631616128e-16,  1.666655255907628e-17,
  1.699027492829164e-19, -8.766391723125744e-21, -4.428879829374497e-22,  8.222567437981998e-03, -8.883279676663079e-05,  8.440011105814233e-07, -8.273428544695928e-09,
  8.694582573349604e-11,  1.130250425194362e-13,  1.686119610875930e-14, -4.815489474660985e-16, -2.324934047485956e-17, -3.179104591305535e-19,  1.194121606072545e-20,
  6.678399041647956e-22,  5.558808723498673e-03, -5.763744176866801e-05,  4.438523677463722e-07, -3.689868560903462e-09,  4.230424020812617e-11,  9.055241944895729e-13,
  1.658969125603962e-14, -6.315101474776052e-16, -3.329262281778708e-17, -4.213395244141519e-19,  1.772405201163723e-20,  9.449420459405675e-22,  5.059650402770608e-19,
 -8.198974458407550e-20,  1.086971616520069e-20, -1.046154581824304e-21,  8.492605517004044e-23, -5.910985881309179e-24,  3.614083723730386e-25, -1.981931934890797e-26,
  9.838545140145723e-28, -4.464801136521674e-29,  1.868872931688361e-30, -7.240066599758126e-32,  2.222190755544433e-15, -1.499912553291192e-16,  1.248443316594487e-17,
 -6.786250928743759e-19,  3.364958670054956e-20, -1.527649450671031e-21,  6.041700568001380e-23, -2.252307928718747e-24,  7.917094536905388e-26, -2.521640296050344e-27,
  7.768534416472298e-29, -2.299822791600820e-30,  1.318218108647996e-12, -5.654888281139252e-14,  3.732636677854873e-15, -1.476448276136757e-16,  5.370100158250889e-18,
 -2.001303015977317e-19,  5.937639453575092e-21, -1.673377892659769e-22,  5.158119106026601e-24, -1.219016470363714e-25,  2.796183961536572e-27, -8.729673595811879e-29,
  2.208587328607523e-10, -6.908107805237664e-12,  3.811998687927983e-13, -1.203535927907373e-14,  3.362817583736291e-16, -1.154836516156619e-17,  2.725447461642726e-19,
 -5.369201550199426e-21,  1.909358432262059e-22, -3.453421162089095e-24,  2.386999458830583e-26, -2.829318602944152e-27,  1.486154274809870e-08, -3.635820177844310e-10,
  1.697553773391398e-11, -4.489327938781209e-13,  9.715739606252894e-15, -3.334798774081350e-16,  6.518570655515509e-18, -5.925939230103642e-20,  4.305222012778527e-21,
 -7.111442726239097e-23, -1.647255954582755e-24, -7.128606380411542e-26,  4.851746011413502e-07, -9.707276531760775e-09,  3.816457546416317e-10, -8.703318095272129e-12,
  1.448033775865482e-13, -5.298781636352515e-15,  8.942594408948067e-17,  3.882433341347763e-19,  6.220744575009973e-20, -1.212795760783156e-21, -5.689377647552325e-23,
 -1.142470771815659e-24,  8.605252512320491e-06, -1.454855242151554e-07,  4.745646644176093e-09, -9.499382256844751e-11,  1.199822288976613e-12, -4.910902910570687e-14,
  7.482558284804720e-16,  1.459155684300647e-17,  5.752987016309885e-19, -1.454134982404360e-20, -7.871095476468211e-22, -1.067092244180577e-23,  8.905491279660113e-05,
 -1.306676751931539e-06,  3.459020317604104e-08, -6.130662786111339e-10,  5.861922539771308e-12, -2.729471118587732e-13,  3.913726986376434e-15,  1.333439412294104e-16,
  3.309356723811905e-18, -1.048814507405379e-19, -5.646365563536632e-21, -5.718716189319434e-23,  5.621129074893166e-04, -7.329858455880084e-06,  1.532164828136899e-07,
 -2.401320891659386e-09,  1.812276876772403e-11, -9.058917592232570e-13,  1.259301755429846e-14,  5.738984201707006e-16,  1.128914615601068e-17, -4.239511259752457e-19,
 -2.194174867307426e-20, -1.722472790934209e-22,  2.213509089722345e-03, -2.623392396278143e-05,  4.207223865514121e-07, -5.742154023665387e-09,  3.977585951696805e-11,
 -1.694670670390182e-12,  2.303001688672539e-14,  1.182062379594300e-15,  2.044978688984647e-17, -8.725583759177930e-19, -4.313803080172157e-20, -2.624837224563334e-22,
  5.426538406337999e-03, -5.976096732931869e-05,  7.201940482987726e-07, -8.255807447916321e-09,  6.968231813265735e-11, -1.412834288669821e-12,  1.768801930484698e-14,
  7.039198592737945e-16,  1.157663237673903e-17, -5.743477164895498e-19, -2.606425423662925e-20, -9.054130837335936e-23,  7.880145246300331e-03, -8.245397778242472e-05,
  7.531962109959793e-07, -6.848412182367832e-09,  9.169842815678251e-11,  2.660787544301066e-13, -7.740651124406304e-15, -1.253948516100532e-15, -1.838759660157036e-17,
  7.908645080050827e-19,  4.099320240232898e-20,  2.785382581259719e-22,  5.335098353476806e-03, -5.425075189366730e-05,  4.042809693903836e-07, -2.854776272681766e-09,
  6.230705782596999e-11,  9.641290436732991e-13, -1.680817230310449e-14, -1.715505566842267e-15, -2.498331805982381e-17,  1.158676298499812e-18,  5.709635513539941e-20,
  3.109128628039897e-22,  2.961413581991628e-19, -2.880055527920298e-20,  3.699440570554577e-21, -3.014482882886703e-22,  2.205645448689562e-23, -1.429771155860528e-24,
  8.088911391077068e-26, -4.177361747440393e-27,  1.984778278083893e-28, -8.595014389378505e-30,  3.460405816452788e-31, -1.308015753592771e-32,  1.780797330770806e-15,
 -7.543599657113579e-17,  6.770073715362010e-18, -3.230603711228122e-19,  1.367671234166738e-20, -6.146717760108880e-22,  2.251294496351832e-23, -7.278836922128193e-25,
  2.604711280256742e-26, -8.024769583942055e-28,  1.992057232147523e-29, -6.480215689046946e-31,  1.142239971204937e-12, -3.257467535481967e-14,  2.365777392508187e-15,
 -8.730456333040527e-17,  2.494467895226491e-18, -9.864825163981557e-20,  3.019411429282248e-21, -5.725758427923848e-23,  2.033271162350451e-24, -6.758408580191774e-26,
  4.057605415657303e-28, -1.886752558533570e-29,  1.985194548339121e-10, -4.360190333957006e-12,  2.624749900614789e-13, -8.187334263217856e-15,  1.616351562194613e-16,
 -6.234529490051472e-18,  1.891541409316176e-19, -1.266200724165837e-21,  6.054162880023487e-23, -4.171337207477291e-24, -2.965390018819322e-26,  1.300767595452643e-27,
  1.364783430143488e-08, -2.471372580472127e-10,  1.232754866508050e-11, -3.386573534081936e-13,  4.544561801209735e-15, -1.843177670282158e-16,  6.285839030358724e-18,
  2.059591127824452e-20,  1.143763145558731e-22, -1.619010993008201e-22, -1.508435334139937e-24,  1.148421184864924e-25,  4.518363542502708e-07, -7.039747297700929e-09,
  2.880059769174655e-10, -7.110599179431511e-12,  6.209930065434275e-14, -2.854773191245326e-15,  1.181413024188122e-16,  1.193771879385190e-18, -2.630858826741867e-20,
 -3.515436822578779e-21, -2.521085239787571e-23,  3.253056288287183e-24,  8.092392522637906e-06, -1.118211960981270e-07,  3.692104013568594e-09, -8.251047581363796e-11,
  4.381858557334463e-13, -2.487929807637414e-14,  1.290557090439938e-15,  1.833465082633693e-17, -5.158189946302097e-19, -4.227825773855111e-20, -1.841442165947515e-22,
  4.427037776443836e-23,  8.433681025013524e-05, -1.058162614139241e-06,  2.763639653490263e-08, -5.564191839609515e-10,  1.685932858828359e-12, -1.273252253566337e-13,
  8.247894676190045e-15,  1.355245517184246e-16, -4.315061768787296e-18, -2.858162515494565e-19, -5.280426859816086e-22,  3.207858616322563e-22,  5.350677508085327e-04,
 -6.215701575126982e-06,  1.256119030808102e-07, -2.233920622227451e-09,  4.457806554195978e-12, -3.901652577078614e-13,  3.023162752268704e-14,  5.275808862070617e-16,
 -1.831986905718082e-17, -1.077011567607970e-18,  2.349405627738064e-22,  1.263280562696947e-21,  2.114880744564618e-03, -2.313527039721745e-05,  3.546467204754494e-07,
 -5.334761004506787e-09,  1.430655101483768e-11, -7.115743068052936e-13,  5.826409703809646e-14,  1.020327491548726e-15, -3.821454826872056e-17, -2.077515951848145e-18,
  4.133020381562554e-21,  2.515705115040082e-21,  5.198414358851220e-03, -5.437870249978070e-05,  6.269755545071050e-07, -7.336737954465280e-09,  4.737706565894352e-11,
 -7.359609371140349e-13,  3.812415622392516e-14,  5.610830621446631e-16, -2.469446396755835e-17, -1.229785577385038e-18,  5.920301773803925e-21,  1.553950043760326e-21,
  7.561895581748454e-03, -7.673191365739698e-05,  6.799266923175792e-07, -5.361444178892277e-09,  9.212741618735397e-11, -3.699943200236439e-13, -4.460233361502994e-14,
 -1.085694055527631e-15,  3.638251197199077e-17,  1.970125387241850e-18, -2.235785660364118e-21, -2.367251134121420e-21,  5.124372452895078e-03, -5.113534829687781e-05,
  3.765233106379374e-07, -1.742830403644622e-09,  7.341823481751128e-11, -5.204997379884364e-14, -6.673629699620812e-14, -1.436098385979884e-15,  5.236715563317703e-17,
  2.718422557077738e-18, -7.028682379686207e-21, -3.337057150977153e-21,  2.234973165364261e-19, -9.318507749433196e-21,  1.513483710123375e-21, -1.015906060748879e-22,
  6.171194559417210e-24, -3.868261499450906e-25,  2.035448832206525e-26, -9.342867881425740e-28,  4.272085787950549e-29, -1.824327203622962e-30,  6.705685843431200e-32,
 -2.387348103598061e-33,  1.567047265409473e-15, -3.383437891425455e-17,  3.880215875735256e-18, -1.787555025067953e-19,  5.525409202448648e-21, -2.470482667445815e-22,
  1.030336702505635e-23, -2.441962913866296e-25,  6.776621564836249e-27, -3.471326007005359e-28,  7.595601654965732e-30, -7.690872255368054e-34,  1.043948195134020e-12,
 -1.728721097054853e-14,  1.504005849927780e-15, -5.968012851197461e-17,  1.145117366663821e-18, -4.021758882546164e-20,  1.981537190872612e-21, -2.813956440287531e-23,
 -8.561395834575019e-26, -4.408260566866211e-26,  1.262513261498469e-27,  4.421019361301065e-29,  1.847075871713996e-10, -2.617341841619174e-12,  1.764007230300421e-13,
 -6.361976442060793e-15,  7.999767357314189e-17, -2.043427132533855e-18,  1.578168257963360e-19, -1.737850078648536e-21, -8.081260446544353e-23, -2.511580092802093e-24,
  1.392658884799981e-25,  4.529372552475874e-27,  1.283223184669697e-08, -1.637624521023136e-10,  8.605239533470151e-12, -2.871055441046989e-13,  2.392307532742165e-15,
 -3.160235386996218e-17,  6.032272183002153e-18, -6.672094854417418e-20, -4.999858130684418e-21, -6.332959897571976e-23,  6.969354516442246e-24,  1.726470816800189e-25,
  4.277644955322691e-07, -5.063411360369837e-09,  2.072788466790990e-10, -6.411565438927084e-12,  3.507873189171038e-14,  1.711078701290661e-16,  1.213702823640104e-16,
 -1.513816556250615e-18, -1.261757468162898e-19, -6.887153419932458e-22,  1.676075676089298e-22,  3.137834444445024e-24,  7.698043606641609e-06, -8.615189471766332e-08,
  2.733432553809204e-09, -7.767397221320298e-11,  2.764728444627980e-13,  9.041450255892868e-15,  1.359775663278838e-15, -1.941102690010835e-17, -1.602840526066751e-18,
 -2.085626633417249e-21,  2.108566774452601e-21,  3.024444892828464e-23,  8.050454051344154e-05, -8.634397928268007e-07,  2.107461257408124e-08, -5.381687363637452e-10,
  1.307237073020484e-12,  9.167274724941288e-14,  8.714815702082202e-15, -1.396829166523418e-16, -1.106591218922511e-17,  1.658434818735092e-20,  1.457602288340091e-20,
  1.623229663943709e-22,  5.120462323865092e-04, -5.317140379197384e-06,  9.911289270658115e-08, -2.182204253262763e-09,  4.621994061602313e-12,  4.136185656346593e-13,
  3.167756685227159e-14, -5.563142420539038e-16, -4.202055549931956e-17,  1.488941728770480e-19,  5.560243239301343e-20,  4.847547361142690e-22,  2.027613301560422e-03,
 -2.055082654702399e-05,  2.917982193798149e-07, -5.137332374704488e-09,  1.538793170414750e-11,  8.292466158632622e-13,  6.005844624975831e-14, -1.131921132608970e-15,
 -8.116888038111878e-17,  4.217133620832660e-19,  1.080643142354290e-19,  7.285288206057922e-22,  4.990390713017141e-03, -4.970295229735575e-05,  5.431678684616418e-07,
 -6.643489962327545e-09,  4.246230272303617e-11,  2.424693281567251e-13,  3.725883932303869e-14, -7.512377866451136e-16, -4.761054313220317e-17,  3.690779789369939e-19,
  6.444058092730515e-20,  2.378653527953017e-22,  7.265473396020507e-03, -7.152576996683231e-05,  6.239801919810634e-07, -4.011945028000838e-09,  7.249872713686823e-11,
 -1.614267739168957e-12, -4.945504487470472e-14,  9.723818221322416e-16,  7.820121518068620e-17, -3.523127348953453e-19, -1.026697841700994e-19, -7.848740549919101e-22,
  4.925750291796177e-03, -4.818754265658002e-05,  3.623144693941641e-07, -6.726769748289820e-10,  5.443415704009932e-11, -1.866057423392082e-12, -7.095540095635822e-14,
  1.441384882885800e-15,  1.072484393530541e-16, -6.194788030262663e-19, -1.421145086889496e-19, -8.639685176010502e-22,  2.044868732809476e-19, -8.590606547799675e-22,
  6.984990314440498e-22, -4.494475763640404e-23,  1.795949417457928e-24, -1.039105333449734e-25,  6.250695407247427e-27, -2.487019546381492e-28,  8.304268525755587e-30,
 -3.956622903003440e-31,  1.785342196308720e-32, -4.594189049124598e-34,  1.481931947367068e-15, -1.016842869314316e-17,  2.140487594541687e-18, -1.184518083196275e-19,
  2.588888311664766e-21, -6.669943557709591e-23,  5.057053798219796e-24, -1.657832452804410e-25,  1.057335686247093e-28, -1.747216883355499e-29,  7.888991096341535e-30,
 -1.230778167859661e-31,  9.947063205882510e-13, -7.854087031595087e-15,  8.788238286155914e-16, -4.549727436186469e-17,  7.462343720838423e-19, -3.459831214380738e-21,
  1.005022274543821e-21, -4.345075369543865e-23, -4.231372341460622e-25,  2.849624893422369e-26,  1.640441124046875e-27, -4.927161386598944e-29,  1.766053011003307e-10,
 -1.491626419867752e-12,  1.069954233474144e-13, -5.225601262655293e-15,  7.136350331785273e-17,  8.302732470426990e-19,  6.864522979009812e-20, -4.441568338135287e-21,
 -4.489523281514096e-23,  4.439084441847827e-24,  1.239721864242360e-25, -6.315856691784882e-27,  1.229396008802248e-08, -1.080523289110741e-10,  5.391721973865490e-12,
 -2.469853971965794e-13,  2.962120326095367e-15,  7.272800774284856e-17,  2.015350021408168e-18, -2.019985064988482e-19, -1.606481303921778e-21,  2.327433800014561e-22,
  4.028484143286102e-24, -3.163081587019923e-25,  4.103550146755610e-07, -3.702210400550360e-09,  1.342744198938431e-10, -5.687089233070645e-12,  6.192180799959817e-14,
  2.145861821641174e-15,  2.863424877839649e-17, -4.567177354690232e-18, -2.543179198886792e-20,  5.587009510478891e-21,  6.362822338988737e-23, -7.457608324518246e-24,
  7.391404917790300e-06, -6.791364709765960e-08,  1.838851462259850e-09, -7.031463227360934e-11,  7.115819625835838e-13,  2.989340415070266e-14,  2.068279102885849e-16,
 -5.532722588960232e-17, -1.936516406379720e-19,  6.959063234117818e-20,  5.223604051260369e-22, -9.198215603662316e-23,  7.734784165787777e-05, -7.201156259222173e-07,
  1.483412835458557e-08, -4.932234729276451e-10,  4.725914474210827e-12,  2.185114860628578e-13,  7.415442445527058e-16, -3.736164740325669e-16, -6.792125326622556e-19,
  4.762708304591622e-19,  2.264573122962033e-21, -6.254063716185890e-22,  4.922005269547207e-04, -4.626865496230539e-06,  7.375634070488379e-08, -2.008580650160244e-09,
  1.852700537863684e-11,  8.552387596202628e-13,  1.088001878514252e-15, -1.404492791822232e-15, -6.520245482726808e-19,  1.801282121245369e-18,  4.871666596513122e-21,
 -2.353856490550920e-21,  1.949696452354450e-03, -1.845715138340103e-05,  2.323872875770566e-07, -4.695715645648503e-09,  4.246971703692056e-11,  1.640075675853720e-12,
  2.168972631518569e-17, -2.705959743887430e-15,  1.892534047421229e-18,  3.474340978337357e-18,  3.594595622957159e-21, -4.522301964178040e-21,  4.799781816527788e-03,
 -4.566430992573287e-05,  4.678134715813682e-07, -5.886634264654848e-09,  5.377503800195128e-11,  7.413974541566939e-13,  2.177679544398779e-16, -1.613056258366155e-15,
  4.231331343392332e-18,  2.044521954372909e-18, -3.185469542660760e-21, -2.646909797865976e-21,  6.989073247163988e-03, -6.670958956522116e-05,  5.815590652703946e-07,
 -3.160821117742885e-09,  3.185856342598342e-11, -2.231379158078436e-12,  5.401983518582901e-15,  2.522760320242065e-15,  1.264536046581986e-19, -3.320199500605164e-18,
 -5.880950542257456e-21,  4.321789689901381e-21,  4.738762549489158e-03, -4.530985247562394e-05,  3.579896533464985e-07, -1.727712280095959e-10,  5.129022574507841e-12,
 -2.755718879403455e-12,  6.597788572793208e-15,  3.497961751350619e-15, -3.395537600430792e-18, -4.564068920698513e-18, -2.135782049696790e-21,  5.925312844202150e-21,
  2.093466717103792e-19,  2.945075805533750e-21,  2.839426885090836e-22, -2.663899583425959e-23,  7.682748806808453e-25, -1.654413174800524e-26,  1.644840159988273e-27,
 -1.076945368285624e-28,  2.740789522595256e-30, -1.522225842932962e-32,  2.426716840514588e-33, -2.538495901671930e-34,  1.467408648715010e-15,  1.907647262562400e-18,
  9.406641834796981e-19, -8.266747356745431e-20,  2.098823941048983e-21,  5.589248173377522e-25,  7.085209099411296e-25, -1.284878860592252e-25,  2.943644850188439e-27,
  1.003531620142996e-28, -2.772670755432636e-30, -2.173336033255884e-31,  9.741811316534400e-13, -2.803246702718356e-15,  4.052937553548694e-16, -3.322618781965820e-17,
  8.170304350495161e-19,  5.796153936894383e-21, -1.890692528382885e-22, -3.365781916473988e-23,  1.054074426923940e-24,  3.174790448075439e-26, -1.459486534370022e-27,
 -4.677898126903530e-29,  1.719831149371926e-10, -8.654519640437333e-13,  5.185905234270792e-14, -3.904527527601703e-15,  9.423267559221311e-17,  9.893231519781201e-19,
 -4.866860926156502e-20, -3.006659875092772e-21,  1.244576221149032e-22,  2.830903710393052e-24, -1.804716669613729e-25, -3.267702818799217e-27,  1.193054041957673e-08,
 -7.585014442236505e-11,  2.763495611560498e-12, -1.872502191147085e-13,  4.446760339746753e-15,  5.553791686205621e-17, -3.050449017454371e-18, -1.178222215199027e-19,
  6.060843185810315e-21,  1.039274103978372e-22, -8.716956130432991e-24, -9.260209433002586e-26,  3.972904675354027e-07, -2.880862438430952e-09,  7.339357222796229e-11,
 -4.358376026200411e-12,  1.016769421505034e-13,  1.393439912316613e-15, -8.075131399177065e-17, -2.330741452773927e-18,  1.419412148141739e-19,  1.865963795686656e-21,
 -2.004417532755783e-22, -1.161795901634118e-24,  7.144160272888654e-06, -5.633976038349680e-08,  1.082586100314429e-09, -5.438650052856554e-11,  1.239696750442095e-12,
  1.782856289933103e-14, -1.069582049314454e-15, -2.521480012775812e-17,  1.753169792572085e-18,  1.797401224388449e-20, -2.430403334105881e-21, -5.849715237183477e-24,
  7.466947985315530e-05, -6.235106005250735e-07,  9.507094686409167e-09, -3.850825255292871e-10,  8.479308322191954e-12,  1.234721769249451e-13, -7.625707926019177e-15,
 -1.550490305122680e-16,  1.197214473347332e-17,  9.715505182288478e-20, -1.632895331962716e-20,  1.417065586122130e-24,  4.747292760647363e-04, -4.126942071105623e-06,
  5.196601024210949e-08, -1.586563218609667e-09,  3.293871917496392e-11,  4.634902560331904e-13, -2.963467857938054e-14, -5.396430425146091e-16,  4.529678093463633e-17,
  2.941308977479346e-19, -6.093008537226911e-20,  1.211790948953025e-22,  1.879248614808264e-03, -1.680952499849332e-05,  1.811313524315334e-07, -3.777981541283085e-09,
  6.963883212646710e-11,  8.456057761149546e-13, -5.801561021788260e-14, -9.733806684706128e-16,  8.752990756947999e-17,  4.515602980919259e-19, -1.162637938807359e-19,
  4.144627824526503e-22,  4.624184257606591e-03, -4.218867725771359e-05,  4.027870127103176e-07, -4.921587228309888e-09,  6.534417859804047e-11,  2.818098837711540e-13,
 -3.337054613261374e-14, -5.271083642305272e-16,  5.187622398201776e-17,  1.585479192262486e-19, -6.732390374387109e-20,  4.089067533157620e-22,  6.731307571048781e-03,
 -6.220340235582603e-05,  5.453003995694674e-07, -2.978394947510943e-09, -6.194398477462276e-12, -1.356848311717315e-12,  5.984390834953332e-14,  9.131256944943156e-16,
 -8.303054295707131e-17, -4.845134547374379e-19,  1.115011292572933e-19, -3.177565053885935e-22,  4.563234553832800e-03, -4.245680804569597e-05,  3.547042650803047e-07,
 -4.917922564039773e-10, -4.113936359118048e-11, -1.574756022352838e-12,  8.096263537154379e-14,  1.208571257168880e-15, -1.146160067459313e-16, -5.453767244016232e-19,
  1.520639798929580e-19, -6.218250715317354e-22,  2.239195519337296e-19,  4.131325956520059e-21,  3.167796000710516e-23, -1.569921914784786e-23,  6.379833862600257e-25,
 -3.612159918584406e-27, -1.891677193945943e-28, -2.594745531001441e-29,  2.154489819474793e-30, -4.187849890133995e-32, -1.411248454647851e-33,  5.133241197344167e-35,
  1.484615425348733e-15,  6.037476822984664e-18,  1.506948465947724e-19, -4.907218938611778e-20,  2.053929628824380e-21, -1.271797402088743e-23, -1.251619941913894e-24,
 -9.098961737925202e-27,  3.402315349580987e-27, -7.600103027689370e-29, -3.156759497492720e-30,  1.536390275061180e-31,  9.672494230814093e-13, -9.275919115344147e-16,
  8.735138513732710e-17, -1.971564123519172e-17,  8.337599705081364e-19, -5.641763880417350e-21, -5.794763309038758e-22,  5.420270199112375e-24,  1.004841769353069e-24,
 -2.971922428646872e-26, -8.335820806879506e-28,  5.436585994143575e-29,  1.690918253229840e-10, -6.113807363902095e-13,  1.444131186671897e-14, -2.321811990250029e-15,
  9.805423924779569e-17, -6.970681639263592e-19, -7.215954157006087e-20,  1.169403047533940e-21,  9.715304042992776e-23, -3.526575197672958e-24, -6.776490532551955e-26,
  5.835047363545514e-27,  1.165890626513252e-08, -6.146598398386582e-11,  9.650846011864076e-13, -1.119007672172892e-13,  4.677290507378395e-15, -3.429931011113040e-17,
 -3.547129448676914e-18,  7.083725523672954e-20,  4.039802935484168e-21, -1.701604049093013e-22, -2.306102439809267e-24,  2.605163914781164e-25,  3.866509646125782e-07,
 -2.473897422110549e-09,  3.139487600028286e-11, -2.626589223072464e-12,  1.075978034292967e-13, -8.061198125715561e-16, -8.286651596236046e-17,  1.851607933907946e-18,
  8.375135714293504e-20, -3.942916896020217e-21, -3.832962375852543e-23,  5.689790216868817e-24,  6.932488698819329e-06, -4.993510976345311e-08,  5.558303907040223e-10,
 -3.321822174164821e-11,  1.315335091269430e-12, -1.001307259800082e-14, -1.017427758441665e-15,  2.438635560938340e-17,  9.410277836980403e-19, -4.824343150051650e-20,
 -3.381334142595821e-22,  6.651696236210126e-23,  7.230170165138405e-05, -5.635125112917360e-07,  5.747245135482903e-09, -2.402999931442718e-10,  8.988853390147162e-12,
 -6.932471874638362e-14, -6.898070097366836e-15,  1.734639271985294e-16,  5.966763935369683e-18, -3.268690532337310e-19, -1.642044408144827e-21,  4.349679783838491e-22,
  4.589456292755121e-04, -3.777969835922814e-06,  3.626310921445278e-08, -1.026249968536427e-09,  3.470305543014764e-11, -2.709756110815188e-13, -2.587436077186525e-14,
  6.743450446184713e-16,  2.128197697630330e-17, -1.228683629235061e-18, -4.328785184616950e-21,  1.589665993414101e-21,  1.814649277771431e-03, -1.552210484085157e-05,
  1.427821535083655e-07, -2.607790156155580e-09,  7.201088172134344e-11, -5.715297856039996e-13, -4.929168050480863e-14,  1.327029474397073e-15,  3.911015503047580e-17,
 -2.360289058807150e-18, -5.409895211800130e-21,  2.981239809065455e-21,  4.461525386536428e-03, -3.918470958392399e-05,  3.500402631914324e-07, -3.876249795645931e-09,
  6.270614278885223e-11, -5.199621836685810e-13, -2.725157647625707e-14,  7.948762120810471e-16,  2.138034224737576e-17, -1.383017505155682e-18, -4.957344605658936e-22,
  1.678836954721028e-21,  6.490987977577104e-03, -5.798718102424141e-05,  5.083331332812847e-07, -3.213195957253956e-09, -1.841369788022532e-11,  9.803854751757633e-14,
  5.106967662143294e-14, -1.288187430427801e-15, -3.785384666997639e-17,  2.253412153336792e-18,  6.452773872265198e-21, -2.881162717936547e-21,  4.399027158430134e-03,
 -3.965565035307069e-05,  3.441697871593948e-07, -1.292206764022315e-09, -5.254029630115427e-11,  3.799293403638402e-13,  6.789855495109459e-14, -1.783608414688948e-15,
 -5.024255483984083e-17,  3.091850279326834e-18,  5.855359767232427e-21, -3.876489914342543e-21,  2.399933899473342e-19,  3.796897538296398e-21, -9.903153078319953e-23,
 -6.443569897990153e-24,  4.948570321266605e-25, -1.072694024416403e-26, -2.228006305298004e-28,  1.355343137273574e-29,  3.193465347328323e-31, -4.228472663393390e-32,
  1.102451726733250e-33,  2.216889168754656e-35,  1.508197220819141e-15,  5.416641914352026e-18, -2.544615711569030e-19, -1.977982806039419e-20,  1.529317385806790e-21,
 -3.657288747405561e-23, -4.886083485106506e-25,  4.505511235344232e-26,  9.914269791281676e-30, -7.526469867472654e-29,  2.240970498623852e-30,  3.887345316870642e-32,
  9.637415341951349e-13, -9.613604388754587e-16, -7.509874249896539e-17, -7.930846274260162e-18,  6.082541426888066e-19, -1.520062924347461e-20, -1.582498903805820e-22,
  1.842456931628218e-23, -1.420101397608714e-25, -2.279551395901752e-26,  8.080786675346957e-28,  8.093018313389310e-30,  1.667364829590409e-10, -5.822219259404304e-13,
 -4.729929619286283e-15, -9.427102740676976e-16,  7.073430368767460e-17, -1.809062914879246e-18, -1.603241307701969e-20,  2.173782938738809e-21, -2.562972721875990e-23,
 -2.224852988438027e-24,  9.023133005103163e-26,  4.468544391537319e-28,  1.142167376231893e-08, -5.792235144721148e-11,  3.598691564908600e-14, -4.631493265567988e-14,
  3.351458069871184e-15, -8.681302127056241e-17, -6.858670455164510e-19,  1.036846950066086e-19, -1.480564678345527e-21, -9.290524261967315e-23,  4.175236030439279e-24,
  6.160919815771457e-27,  3.770970160313590e-07, -2.321371709227868e-09,  9.380699080347404e-12, -1.120681491069315e-12,  7.679225060628212e-14, -2.000865444705123e-15,
 -1.447787477114118e-17,  2.376849997839708e-18, -3.789880722292421e-20, -1.929900399418278e-21,  9.392026356765227e-23, -9.415640507957407e-26,  6.739592743428580e-06,
 -4.674767982386790e-08,  2.733145930676064e-10, -1.482875661537855e-11,  9.370422646819937e-13, -2.440858094894031e-14, -1.643533761329008e-16,  2.881952285965371e-17,
 -4.935253804919652e-19, -2.170332756984283e-20,  1.124506525778980e-21, -3.177464117062550e-24,  7.012459521804191e-05, -5.267784998886165e-07,  3.656829577851262e-09,
 -1.146629787641082e-10,  6.406585335734716e-12, -1.655423514939929e-13, -1.044403193666775e-15,  1.937947029108341e-16, -3.486997476713063e-18, -1.376501493330635e-19,
  7.496117073700267e-21, -3.147774417492633e-23,  4.443485149508880e-04, -3.528281113341747e-06,  2.701121896487589e-08, -5.408044973093283e-10,  2.483256599875342e-11,
 -6.275869154090550e-13, -3.685226242646163e-15,  7.236565678823643e-16, -1.350179307023388e-17, -4.908857038072152e-19,  2.782675350560250e-20, -1.463771963120149e-22,
  1.754673246383322e-03, -1.448665126599597e-05,  1.178548025290156e-07, -1.597135493258478e-09,  5.216999042314532e-11, -1.241833908986643e-12, -6.457674006644593e-15,
  1.380105238065288e-15, -2.652793600086960e-17, -9.014412850729284e-19,  5.289772003083184e-20, -3.251164439384274e-22,  4.310115393965003e-03, -3.655437138021611e-05,
  3.091095526974224e-07, -2.983289329632088e-09,  4.778298395102017e-11, -8.727564211818564e-13, -2.249026398734018e-15,  7.906045216714393e-16, -1.600108492504845e-17,
 -4.904679594803743e-19,  3.046988852363342e-20, -2.305911145129828e-22,  6.266921969028680e-03, -5.407924382572490e-05,  4.682501025995239e-07, -3.439325629920984e-09,
 -7.517846444594014e-12,  8.255011389935339e-13,  9.400822970687202e-15, -1.348820135677541e-15,  2.531696529857036e-17,  8.777668846194096e-19, -5.078682890811529e-20,
  2.915930452389159e-22,  4.245794263052687e-03, -3.697754932193940e-05,  3.241055280102599e-07, -2.002495890105601e-09, -3.321087552120683e-11,  1.325990476594252e-12,
  1.091347352751040e-14, -1.827978585501557e-15,  3.522464310750906e-17,  1.162203222795175e-18, -6.909034094900503e-20,  4.449260435621685e-22,  2.532737344078226e-19,
  2.812434604312191e-21, -1.364993439382353e-22, -3.977405087692909e-25,  2.587608218033335e-25, -1.144895886058511e-26,  1.352042981973406e-28,  8.361798465796336e-30,
 -3.889565776947237e-31, -6.753470537989285e-34,  6.397254809135540e-34, -2.453020986098045e-35,  1.524800379675209e-15,  2.789801815830054e-18, -3.700906465125804e-19,
 -1.395692876901773e-21,  7.746978271554981e-22, -3.498207399866140e-23,  4.984784447696478e-25,  1.984061208394869e-26, -1.085311936139402e-27,  6.549795567510815e-30,
  1.210630720329407e-30, -4.969462907370809e-32,  9.582941724908590e-13, -1.801025167160774e-15, -1.221370605875437e-16, -6.785718252127865e-19,  3.029960808967827e-19,
 -1.385592262774335e-20,  2.148728323497446e-22,  6.840118293322806e-24, -4.174338814663236e-25,  4.237595434427382e-27,  3.660490233545901e-28, -1.675613012770406e-29,
  1.642837501364859e-10, -6.488639087749785e-13, -1.046271188546380e-14, -1.029972781067451e-16,  3.493145292246359e-17, -1.605864906070221e-18,  2.608704218135422e-20,
  7.261176783792785e-22, -4.770690256369288e-23,  6.017744107202325e-25,  3.536801794729489e-26, -1.779738600112441e-27,  1.118815126740183e-08, -5.907933710328551e-11,
 -2.558449757286835e-13, -6.613907202753965e-15,  1.649008370575412e-15, -7.577990138260329e-17,  1.267087894025959e-18,  3.222692657609940e-20, -2.231703974171321e-21,
  3.176869926631964e-23,  1.460412424338137e-24, -7.945205983217855e-26,  3.679018951579294e-07, -2.282295087009868e-09,  1.977442521372384e-12, -2.114395030563935e-13,
  3.780003813739260e-14, -1.726576437658229e-15,  2.942424188324201e-17,  7.012695032234897e-19, -5.050004518552096e-20,  7.762664358343042e-22,  3.001617609400541e-23,
 -1.740827914871117e-24,  6.556158706007998e-06, -4.505535281907690e-08,  1.691797258814541e-10, -3.719870389269124e-12,  4.635658497454741e-13, -2.088764425721914e-14,
  3.604627352090700e-16,  8.176563401248951e-18, -6.067766094213762e-19,  9.830687810666283e-21,  3.343529931759838e-22, -2.043499431188707e-23,  6.806940324337017e-05,
 -5.015374740517395e-07,  2.786642245523760e-09, -3.842772414974128e-11,  3.207050555053510e-12, -1.407733718742851e-13,  2.447211247404862e-15,  5.333827694572782e-17,
 -4.053753784809689e-18,  6.820410613869571e-20,  2.102965056439244e-21, -1.341776366069942e-22,  4.306347444130739e-04, -3.332350545703613e-06,  2.249211377701923e-08,
 -2.428305369085631e-10,  1.274198321507240e-11, -5.310012721057471e-13,  9.243988579326609e-15,  1.943061330638926e-16, -1.506812924317387e-17,  2.607839884134449e-19,
  7.445316118664390e-21, -4.922313075383536e-22,  1.698508481698544e-03, -1.360817010993096e-05,  1.028817860813933e-07, -9.583674562815704e-10,  2.833967181766627e-11,
 -1.045716642661690e-12,  1.801425447590371e-14,  3.618516685491140e-16, -2.865848392958930e-17,  5.076376276997671e-19,  1.358029541565546e-20, -9.264178546149336e-22,
  4.168633546914078e-03, -3.421300886854801e-05,  2.773294865360711e-07, -2.354982291743035e-09,  3.124098555526661e-11, -7.276743643023961e-13,  1.154274614427460e-14,
  1.951190383862293e-16, -1.646447305685866e-17,  3.028989755379280e-19,  7.294962583987553e-21, -5.249838474767066e-22,  6.057834405684391e-03, -5.049909724358079e-05,
  4.268104560584908e-07, -3.426220710247177e-09,  8.739007121561685e-12,  7.058630579259020e-13, -1.476956462553275e-14, -3.701575081577878e-16,  2.767721473331533e-17,
 -4.836505234064059e-19, -1.328228083395801e-20,  8.937062988252401e-22,  4.102907492421102e-03, -3.448782620354091e-05,  2.977672793286953e-07, -2.322270209882643e-09,
 -7.459407249981991e-12,  1.122410310943986e-12, -2.157777756747930e-14, -4.871637916097193e-16,  3.758968930160966e-17, -6.695146864190805e-19, -1.748227181815091e-20,
  1.206155597347624e-21,  2.623874816955559e-19,  1.755769957049796e-21, -1.232576788270858e-22,  2.142261629465068e-24,  7.431654800360676e-26, -6.695285538300780e-27,
  2.154776822136235e-28, -1.417068847554558e-30, -1.755437050925003e-31,  7.754485838457918e-33, -7.675752255676373e-35, -6.460166964514566e-36,  1.530165586161765e-15,
 -7.547990776044110e-20, -3.330932331506243e-19,  6.175913110628515e-21,  2.212294962176430e-22, -1.982276984843024e-23,  6.472567109804107e-25, -5.585777907247125e-27,
 -4.298197213685111e-28,  2.016526383258547e-29, -2.433455958931785e-31, -1.299719543240876e-32,  9.491754566860890e-13, -2.747297186213495e-15, -1.093115920018322e-16,
  2.273107447794181e-18,  8.601944977368341e-20, -7.700731768327318e-21,  2.549697590064174e-22, -2.512488555250283e-24, -1.502335779919371e-25,  7.476434564265821e-27,
 -1.046548184255051e-28, -3.898194191801499e-30,  1.615235653812696e-10, -7.302052014117561e-13, -9.282822102253489e-15,  2.371186819110955e-16,  9.939691349730140e-18,
 -8.819445868625350e-19,  2.946455899422927e-20, -3.125611366570162e-22, -1.607671676873587e-23,  8.359160550789627e-25, -1.282664867183878e-26, -3.692377491492028e-28,
  1.094773384166371e-08, -6.109849559150626e-11, -2.210456348297012e-13,  9.475608572381214e-15,  4.743558960613988e-16, -4.130242987517802e-17,  1.387334466925995e-18,
 -1.541640168273893e-20, -7.174289954614660e-22,  3.854365615056887e-23, -6.283842174149337e-25, -1.491408569464112e-26,  3.587996797401475e-07, -2.268697020577232e-09,
  2.064887610892580e-12,  1.592542811858502e-13,  1.110609854202969e-14, -9.365489252140840e-16,  3.153740588595748e-17, -3.616752564431460e-19, -1.567530081138318e-20,
  8.634254181061505e-22, -1.468537553453480e-23, -3.000232715747783e-25,  6.378501757148681e-06, -4.378283165943677e-08,  1.569083915751841e-10,  8.683534328983214e-13,
  1.411277854197276e-13, -1.130227329800627e-14,  3.804169407286403e-16, -4.461199851381043e-18, -1.833764875215813e-19,  1.029850518564298e-20, -1.806354898874349e-22,
 -3.276269632025107e-24,  6.610589656120008e-05, -4.804082291768543e-07,  2.551636631692875e-09, -6.170707889745915e-12,  1.035052854128445e-12, -7.617771680879380e-14,
  2.552272685123819e-15, -3.041565076510402e-17, -1.199870039595960e-18,  6.842763256716862e-20, -1.228170100165838e-21, -2.024177471317491e-23,  4.176506953355415e-04,
 -3.161326859109630e-06,  2.049292701972588e-08, -1.108714762829147e-10,  4.540917435750295e-12, -2.885283579646359e-13,  9.546310187063621e-15, -1.150522184069477e-16,
 -4.386233052665109e-18,  2.533084633789764e-19, -4.627754222398473e-21, -7.053422324259349e-23,  1.645658065781710e-03, -1.282483558513981e-05,  9.349334834458311e-08,
 -6.469372307909554e-10,  1.211357476328375e-11, -5.764995469054492e-13,  1.841028272184879e-14, -2.233110272970045e-16, -8.218799307162113e-18,  4.802680089311072e-19,
 -8.905063786463020e-21, -1.267494334655594e-22,  4.036050472670146e-03, -3.209991749414706e-05,  2.516401286263174e-07, -1.955575308769936e-09,  1.963953005771963e-11,
 -4.334997658536562e-13,  1.145029846470852e-14, -1.377048672963300e-16, -4.583418123440475e-18,  2.750895368170065e-19, -5.225706042254624e-21, -6.622640359255405e-23,
  5.862411190389883e-03, -4.724575836618983e-05,  3.869324444793408e-07, -3.194669927257266e-09,  1.891307790084636e-11,  3.090017854883276e-13, -1.570470419842672e-14,
  1.975438301291749e-16,  8.064924549545249e-18, -4.627559709175957e-19,  8.512833444288459e-21,  1.248777033255263e-22,  3.969543108636228e-03, -3.221767682016485e-05,
  2.698261111932721e-07, -2.292679339398264e-09,  9.302927691988238e-12,  5.519118315229062e-13, -2.245463069236520e-14,  2.800301929529882e-16,  1.079355853121467e-17,
 -6.277055325892629e-19,  1.168718684564023e-20,  1.623265278925788e-22,  1.869291885152575e+00,  9.403015989787571e-02, -4.022142505333756e-02,  1.609946020065963e-02,
 -6.354577303419513e-03,  2.511975707213975e-03, -9.857025476789592e-04,  3.719790129235647e-04, -1.267576877665070e-04,  3.367462375994874e-05, -3.262879890034524e-06,
 -2.495719426554067e-06,  1.915090787738312e+00,  6.043377860061799e-02, -2.498339696575825e-02,  9.699584600205358e-03, -3.745130513665486e-03,  1.461816360229886e-03,
 -5.704212205503640e-04,  2.147324424114061e-04, -7.288485527529723e-05,  1.908840845789593e-05, -1.605221182545058e-06, -1.585904774013941e-06,  1.940860768823548e+00,
  4.189978325447401e-02, -1.706228090776820e-02,  6.535048640198304e-03, -2.502101866229659e-03,  9.735528183691645e-04, -3.800363633789471e-04,  1.433169287722656e-04,
 -4.872543431477030e-05,  1.277033347054290e-05, -1.069991113621387e-06, -1.064589807262224e-06,  1.958076160561163e+00,  2.966367904502442e-02, -1.201844336509086e-02,
  4.574870432074365e-03, -1.745563984867821e-03,  6.788594583448292e-04, -2.653527253749944e-04,  1.002573313345663e-04, -3.414741998723766e-05,  8.968497931622983e-06,
 -7.617483038783856e-07, -7.408412400821116e-07,  1.970501127712782e+00,  2.090390617976441e-02, -8.497352526969157e-03,  3.230782219501601e-03, -1.232010826276153e-03,
  4.795092790639219e-04, -1.877231870248019e-04,  7.104433217801278e-05, -2.423414038526148e-05,  6.377469201303053e-06, -5.494650773895538e-07, -5.215449330545413e-07,
  1.979849136178339e+00,  1.435260083838417e-02, -5.912606643504138e-03,  2.256432813513097e-03, -8.620897743124893e-04,  3.361296058806715e-04, -1.318197500853967e-04,
  4.996160002517212e-05, -1.706396645563508e-05,  4.498031355008844e-06, -3.922944562823487e-07, -3.646127826086318e-07,  1.987039936255630e+00,  9.335867674597051e-03,
 -3.961304825884194e-03,  1.527588700273977e-03, -5.865518599995494e-04,  2.293974173303740e-04, -9.015156405668212e-05,  3.421876702733205e-05, -1.170003906729192e-05,
  3.088371150141685e-06, -2.720298360751907e-07, -2.485281735640863e-07,  1.992618903890923e+00,  5.457211540345960e-03, -2.469250889558405e-03,  9.740960522778646e-04,
 -3.779212153843075e-04,  1.485971877547873e-04, -5.857079081906005e-05,  2.226957372980965e-05, -7.622724055406183e-06,  2.014497963438034e-06, -1.788359710780881e-07,
 -1.611776585484247e-07,  1.996930710447846e+00,  2.467614413741638e-03, -1.329044657345975e-03,  5.533122777423232e-04, -2.196435434051055e-04,  8.729702233786076e-05,
 -3.458829643294048e-05,  1.318481018047381e-05, -4.519260775125484e-06,  1.195679326371459e-06, -1.067862816660685e-07, -9.525633330120425e-08,  2.000201844479674e+00,
  2.042635222569935e-04, -4.715088614263859e-04,  2.380755082633015e-04, -1.012430296678312e-04,  4.143643069030842e-05, -1.663213354401102e-05,  6.376775914792762e-06,
 -2.191511530397113e-06,  5.806819424630539e-07, -5.208124008945078e-08, -4.615218454348415e-08,  2.002583661816075e+00, -1.441211570118069e-03,  1.488554747293003e-04,
  1.067514156782213e-05, -1.592202824229948e-05,  8.384608002947378e-06, -3.683257641532644e-06,  1.463956668672650e-06, -5.106623566414680e-07,  1.361381758092567e-07,
 -1.221400804338242e-08, -1.088250731095663e-08,  2.004176293227448e+00, -2.540284875106769e-03,  5.617808399989647e-04, -1.403865730854101e-04,  4.071698895122593e-05,
 -1.355873629269470e-05,  4.917328601709015e-06, -1.800650688829481e-06,  6.067859457370357e-07, -1.596155726024585e-07,  1.446302802454956e-08,  1.247584085790420e-08,
  2.005042567465040e+00, -3.137698488671512e-03,  7.857480024150551e-04, -2.222214806264672e-04,  7.138728687403772e-05, -2.544207915247927e-05,  9.576213593333842e-06,
 -3.569582451266186e-06,  1.212447448646164e-06, -3.199878852022646e-07,  2.898046407710983e-08,  2.510590730684663e-08,  1.987182941891996e+00,  8.534637250336824e-03,
 -2.731863749089449e-03,  7.658832940769653e-04, -2.006450677885712e-04,  5.048654993389646e-05, -1.237621132472007e-05,  2.980531687887535e-06, -7.089385778126628e-07,
  1.671281447926002e-07, -3.905387461130310e-08,  8.645120206706561e-09,  1.991075153069374e+00,  5.946465378961261e-03, -1.902785873111727e-03,  5.279267379755754e-04,
 -1.363872298674576e-04,  3.379136490630251e-05, -8.151710618657458e-06,  1.931744439278081e-06, -4.522355283875806e-07,  1.049827367933695e-07, -2.417608057359318e-08,
  5.284374475973468e-09,  1.993682095034272e+00,  4.225948341091218e-03, -1.367860097445289e-03,  3.788594300689094e-04, -9.727771855785812e-05,  2.391131452130658e-05,
 -5.718773384306818e-06,  1.343392363045651e-06, -3.118207713790079e-07,  7.180109153755900e-08, -1.641141828762963e-08,  3.564687485853484e-09,  1.995622187102458e+00,
  2.952284764273071e-03, -9.802224579512023e-04,  2.730566346678029e-04, -7.006809957518273e-05,  1.716739888734613e-05, -4.087920223105488e-06,  9.556918626823824e-07,
 -2.207632983470635e-07,  5.060090401432434e-08, -1.151745106269773e-08,  2.493083328723328e-09,  1.997133237230414e+00,  1.964266766233901e-03, -6.844240191849343e-04,
  1.935880933940992e-04, -4.993575393877507e-05,  1.224768049582711e-05, -2.913816084131946e-06,  6.799647135615868e-07, -1.567256421368293e-07,  3.584186879681816e-08,
 -8.140890508003076e-09,  1.759133497516748e-09,  1.998336721243486e+00,  1.179844260879216e-03, -4.526330666862822e-04,  1.320880168248679e-04, -3.453713249234447e-05,
  8.525544689031359e-06, -2.034387602131717e-06,  4.753166055506907e-07, -1.095843520506270e-07,  2.505553550734258e-08, -5.688611073220746e-09,  1.228730077206383e-09,
  1.999304021939421e+00,  5.509625007541072e-04, -2.687570130908450e-04,  8.378643293431878e-05, -2.255529806211752e-05,  5.654018064358497e-06, -1.361195149976728e-06,
  3.197509250036919e-07, -7.396957235951115e-08,  1.694997054171415e-08, -3.854081772195358e-09,  8.333159877346229e-10,  2.000080678861273e+00,  4.705575545206695e-05,
 -1.226774190296390e-04,  4.572090692231180e-05, -1.318259686705992e-05,  3.422963872664128e-06, -8.413321557220292e-07,  2.002643362083163e-07, -4.674274431407259e-08,
  1.077811530134976e-08, -2.461800949748009e-09,  5.339679058658364e-10,  2.000697241661067e+00, -3.523270491378095e-04, -7.692586581097948e-06,  1.595022161497763e-05,
 -5.895477061364740e-06,  1.697605325432013e-06, -4.412134014769884e-07,  1.086830748233359e-07, -2.594919783661848e-08,  6.078697279116964e-09, -1.404251186360942e-09,
  3.069956397668455e-10,  2.001174781387373e+00, -6.612601388349107e-04,  8.076947885206076e-05, -6.837959259409089e-06, -3.432044749514796e-07,  3.884526930397926e-07,
 -1.387281822194052e-07,  3.966916785626396e-08, -1.032196082285082e-08,  2.554782785585986e-09, -6.126469956153907e-10,  1.373198762237276e-10,  2.001527934396656e+00,
 -8.895016316685549e-04,  1.458557613945963e-04, -2.354017772895343e-05,  3.712047024710902e-06, -5.647371372168045e-07,  8.090569014031217e-08, -1.032308402299611e-08,
  9.755295740902385e-10,  1.137081454124011e-11, -4.203225053900377e-11,  1.512352875216942e-11,  2.001766677721752e+00, -1.043693415014703e-03,  1.896958452085442e-04,
 -3.475951610203325e-05,  6.429315934939185e-06, -1.202021097838416e-06,  2.274643710829622e-07, -4.362687858248095e-08,  8.491237461214736e-09, -1.678741079403611e-09,
  3.368126727428306e-10, -6.595560044919865e-11,  2.001897422935641e+00, -1.128098266173616e-03,  2.136496210835052e-04, -4.087918013749286e-05,  7.909177697078043e-06,
 -1.548617594157300e-06,  3.070769160225712e-07, -6.169939276581911e-08,  1.256620581296603e-08, -2.594478595831682e-09,  5.419697076093890e-10, -1.098463630884719e-10,
  1.998101316913215e+00,  1.264424005490983e-03, -3.995860193102065e-04,  1.050753078115321e-04, -2.531003737203478e-05,  5.791332627811540e-06, -1.281322947113096e-06,
  2.768672993495550e-07, -5.879004185145384e-08,  1.231708011085796e-08, -2.549560396503186e-09,  5.033164080616736e-10,  1.998765137846245e+00,  8.357412045502989e-04,
 -2.779222903785375e-04,  7.419968203743303e-05, -1.794674922131605e-05,  4.103567617030950e-06, -9.049550121846101e-07,  1.946150046520505e-07, -4.108988017109109e-08,
  8.554510242182231e-09, -1.758908001921827e-09,  3.449950249473261e-10,  1.999235526933641e+00,  5.329606232830411e-04, -1.931998912177204e-04,  5.300158746597034e-05,
 -1.296204085064062e-05,  2.976825811016127e-06, -6.571367936587174e-07,  1.411901133262794e-07, -2.974717372168013e-08,  6.175259689304857e-09, -1.265435098874353e-09,
  2.473561215151455e-10,  1.999599884895569e+00,  2.989928581069257e-04, -1.284190956390135e-04,  3.696221541002124e-05, -9.229295247145777e-06,  2.141649432106982e-06,
 -4.752821126995298e-07,  1.023708172817284e-07, -2.158490501539611e-08,  4.479340973081993e-09, -9.169353423157890e-10,  1.789809311778527e-10,  1.999892517495522e+00,
  1.114380044338877e-04, -7.692194032199943e-05,  2.431715462663757e-05, -6.310410420702406e-06,  1.493776708058131e-06, -3.353132482578832e-07,  7.272076818661476e-08,
 -1.539709607218667e-08,  3.203021472137549e-09, -6.565103400614087e-10,  1.282124589648421e-10,  2.000131335625699e+00, -4.139143968655303e-05, -3.524448186204568e-05,
  1.415201267423892e-05, -3.979417002459795e-06,  9.797207318468198e-07, -2.249516671766450e-07,  4.948541095024305e-08, -1.057681952731246e-08,  2.214510315128145e-09,
 -4.559332227522718e-10,  8.930734173585018e-11,  2.000327090158352e+00, -1.665056252964208e-04, -1.315860621613742e-06,  5.922403320654402e-06, -2.102431380004633e-06,
  5.679603120099526e-07, -1.370028307157845e-07,  3.106049342348892e-08, -6.772824482217290e-09,  1.438028798405137e-09, -2.990802205847038e-10,  5.900498222578326e-11,
  2.000486776118652e+00, -2.684622233178722e-04,  2.620580014761193e-05, -7.229890605518034e-07, -5.934510580166795e-07,  2.383487469788341e-07, -6.689279238416788e-08,
  1.643175128448639e-08, -3.764301726357044e-09,  8.262158238866797e-10, -1.759328257004138e-10,  3.529038008931250e-11,  2.000615169572137e+00, -3.503708550344442e-04,
  4.823311876321119e-05, -6.022189049483880e-06,  6.055461045982086e-07, -2.264428442841000e-08, -1.156438867367937e-08,  4.924603966058448e-09, -1.405131207866042e-09,
  3.478897836890832e-10, -7.992858571115709e-11,  1.684985174304637e-11,  2.000715615591202e+00, -4.144080001648647e-04,  6.540300125619355e-05, -1.014074715439026e-05,
  1.534764506246564e-06, -2.243567553560270e-07,  3.108351781013411e-08, -3.922598106343093e-09,  4.042510549587201e-10, -1.810329076450935e-11, -6.634774693865681e-12,
  2.799596249255669e-12,  2.000790467774785e+00, -4.621041518812583e-04,  7.816219147171996e-05, -1.319444699889867e-05,  2.222232976924317e-06, -3.732767636237650e-07,
  6.250571012838108e-08, -1.042834896096163e-08,  1.732286333766917e-09, -2.862521054721777e-10,  4.697374050237822e-11, -7.461545976396199e-12,  2.000841347229336e+00,
 -4.945129711278018e-04,  8.681760134784108e-05, -1.526264063919302e-05,  2.687111036407075e-06, -4.738272101050041e-07,  8.369110703314811e-08, -1.480852952792430e-08,
  2.625231031272783e-09, -4.663205848415409e-10,  8.292976258276032e-11, -1.433647663143728e-11,  2.000869306025451e+00, -5.123178929709106e-04,  9.156783987384129e-05,
 -1.639655431162632e-05,  2.941736813545944e-06, -5.288492561637579e-07,  9.527339637644570e-08, -1.720113484287021e-08,  3.112581524759205e-09, -5.645200840612767e-10,
  1.025234660621078e-10, -1.808036972344998e-11,  1.999808363510216e+00,  1.421620328156882e-04, -5.983537554019282e-05,  1.683195290874737e-05, -4.103181833164109e-06,
  9.287587247302278e-07, -2.008900272710851e-07,  4.213951157146798e-08, -8.646117100451198e-09,  1.744584788863296e-09, -3.470040929971302e-10,  6.590044233019152e-11,
  1.999948284730734e+00,  5.292189952537131e-05, -3.586868140235053e-05,  1.107967084018168e-05, -2.806065762573169e-06,  6.476639799120088e-07, -1.416311291725889e-07,
  2.989730073359037e-08, -6.155939388884863e-09,  1.244256939763155e-09, -2.476059945870589e-10,  4.700855966616108e-11,  2.000049818359382e+00, -1.173672076865678e-05,
 -1.862316972863169e-05,  6.969171257661217e-06, -1.885565325918384e-06,  4.495571983462242e-07, -1.001533890421676e-07,  2.138688073162791e-08, -4.436580545238931e-09,
  9.011318388610826e-10, -1.798935932004070e-10,  3.421861424114024e-11,  2.000129862551480e+00, -6.265215285073842e-05, -5.113903654366130e-06,  3.766028605019123e-06,
 -1.171990195170068e-06,  2.967787532888743e-07, -6.833047125132397e-08,  1.489075736618700e-08, -3.130815724936968e-09,  6.418549345509958e-10, -1.289815535260475e-10,
  2.464619397364280e-11,  2.000195051851531e+00, -1.040805522327076e-04,  5.832188348138263e-06,  1.181509035404210e-06, -5.986282768318885e-07,  1.745283664692268e-07,
 -4.297087326287846e-08,  9.735065519250263e-09, -2.098661397548478e-09,  4.377244109750346e-10, -8.905566787362418e-11,  1.716666177162963e-11,  2.000248858671458e+00,
 -1.382496129676073e-04,  1.482916053144150e-05, -9.354842505637850e-07, -1.305908884986082e-07,  7.507327560909793e-08, -2.240918640721895e-08,  5.568691522945069e-09,
 -1.267306061230118e-09,  2.738401447986901e-10, -5.710395722485502e-11,  1.119864195617576e-11,  2.000293374663740e+00, -1.665011557025602e-04,  2.224677880561185e-05,
 -2.675879455146913e-06,  2.530974497222224e-07, -6.229783827305332e-09, -5.646876507117232e-09,  2.181476524095659e-09, -5.932513188533577e-10,  1.413190917674783e-10,
 -3.133473490175534e-11,  6.397052009624778e-12,  2.000329966148361e+00, -1.897116101332818e-04,  2.832644525887688e-05, -4.098991071089090e-06,  5.661045291510867e-07,
 -7.240234200989164e-08,  7.964826155237539e-09, -5.628866248332432e-10, -4.833817916349889e-11,  3.442249988151434e-11, -1.059300217331560e-11,  2.539902588372307e-12,
  2.000359569741624e+00, -2.084817015763481e-04,  3.323352723719820e-05, -5.245415964860607e-06,  8.177746154407458e-07, -1.255073879702149e-07,  1.886820934362657e-08,
 -2.757168386507232e-09,  3.865638776800349e-10, -5.074094188285825e-11,  5.902852242531295e-12, -5.227407394262479e-13,  2.000382843888820e+00, -2.232336908211347e-04,
  3.708419528305017e-05, -6.143649292352588e-06,  1.014659565101432e-06, -1.669896277350756e-07,  2.737257690966788e-08, -4.466147468062081e-09,  7.247914197231667e-10,
 -1.168793535738012e-10,  1.869581303084180e-11, -2.894858481603287e-12,  2.000400253412438e+00, -2.342656334871659e-04,  3.996040298242845e-05, -6.813777716460089e-06,
  1.161373517467546e-06, -1.978653858374313e-07,  3.369525495959312e-08, -5.735279517103386e-09,  9.756896982103404e-10, -1.658875838738990e-10,  2.816522216158279e-11,
 -4.648987477309063e-12,  2.000412119387521e+00, -2.417833881332322e-04,  4.191872379899061e-05, -7.269657802747187e-06,  1.261096887389202e-06, -2.188345409615043e-07,
  3.798574979538130e-08, -6.595800803587953e-09,  1.145673141107726e-09, -1.990646466003230e-10,  3.457081185820537e-11, -5.834733573137524e-12,  2.000418650979091e+00,
 -2.459210329614646e-04,  4.299596914259698e-05, -7.520296519491721e-06,  1.315894770518179e-06, -2.303510316701820e-07,  4.034092033953725e-08, -7.067924556530410e-09,
  1.238887694113764e-09, -2.172491580742296e-10,  3.808006023673671e-11, -6.484047517471917e-12,  2.000061924412096e+00, -2.962239714024049e-05, -2.755828302332841e-06,
  1.870424144622626e-06, -5.700558153798434e-07,  1.422092578553604e-07, -3.231127414618515e-08,  6.953258214201993e-09, -1.444042517267475e-09,  2.924514215127007e-10,
 -5.805873001964909e-11,  1.096863383915284e-11,  2.000094179417166e+00, -5.007540988039961e-05,  2.593187900404969e-06,  6.205458019396462e-07, -2.956897491268694e-07,
  8.433129282772863e-08, -2.043398529445971e-08,  4.564758294563851e-09, -9.711115088035038e-10,  1.999542402862685e-10, -4.016844785203714e-11,  7.652306571555134e-12,
  2.000117843944481e+00, -6.507014662329259e-05,  6.501375420238388e-06, -2.895310006493442e-07, -9.660059481834038e-08,  4.247714092681313e-08, -1.187439041021280e-08,
  2.849320845907708e-09, -6.326067774021645e-10,  1.339735521198852e-10, -2.744989820787077e-11,  5.302086765904572e-12,  2.000136655312942e+00, -7.698308356243482e-05,
  9.598281258228272e-06, -1.008807563775051e-06,  6.033821279623208e-08,  9.570150541209609e-09, -5.162069545078019e-09,  1.507582653128265e-09, -3.685271817885077e-10,
  8.263207127441178e-11, -1.757847565430240e-11,  3.482317213130047e-12,  2.000152077851947e+00, -8.674553212173026e-05,  1.213082698272528e-05, -1.595768658105911e-06,
  1.881374386632252e-07, -1.717054974989469e-08,  2.810410363409833e-10,  4.218182839802994e-10, -1.552719146346804e-10,  4.125740139626582e-11, -9.639670310435102e-12,
  2.021614667358223e-12,  2.000164877231121e+00, -9.484451548621579e-05,  1.422820638964212e-05, -2.081027071474063e-06,  2.936093386950320e-07, -3.920125643164611e-08,
  4.757688771517964e-09, -4.696272633629362e-10,  1.951786632041568e-11,  7.403267289508560e-12, -3.154815200750803e-12,  8.303040094491277e-13,  2.000175514519526e+00,
 -1.015733301567786e-04,  1.596824788650336e-05, -2.483028214441102e-06,  3.808589509354085e-07, -5.739951859985510e-08,  8.450286280998005e-09, -1.203895157403747e-09,
  1.632850310821874e-10, -2.040301075225767e-11,  2.164124592003078e-12, -1.455507910453423e-13,  2.000184290926475e+00, -1.071235909121237e-04,  1.740180729512953e-05,
 -2.813825869466279e-06,  4.525687739980613e-07, -7.233871147644193e-08,  1.147799299296688e-08, -1.805240256680496e-09,  2.808882727128509e-10, -4.312236285602920e-11,
  6.504996496889327e-12, -9.411063893438176e-13,  2.000191412998382e+00, -1.116266958948661e-04,  1.856376185519233e-05, -3.081686542059426e-06,  5.105782844943413e-07,
 -8.441194310788773e-08,  1.392248307291547e-08, -2.290281606298538e-09,  3.756553208335812e-10, -6.141261979337518e-11,  9.996328404509271e-12, -1.580404465296265e-12,
  2.000197026001720e+00, -1.151750600295213e-04,  1.947864230828594e-05, -3.292424127599484e-06,  5.561810233806337e-07, -9.389559275770595e-08,  1.584116228854827e-08,
 -2.670696074735918e-09,  4.499233563267584e-10, -7.573558701128950e-11,  1.272830286664533e-11, -2.080305422801938e-12,  2.000201232534383e+00, -1.178339537422379e-04,
  2.016377409224193e-05, -3.450144511672424e-06,  5.902903791648374e-07, -1.009847746051982e-07,  1.727454618014302e-08, -2.954722237479345e-09,  5.053407563018172e-10,
 -8.641683313120478e-11,  1.476446887560402e-11, -2.452684876402702e-12,  2.000204103501493e+00, -1.196484849467964e-04,  2.063113018279885e-05, -3.557684830199290e-06,
  6.135373970151995e-07, -1.058142619044739e-07,  1.825061340359848e-08, -3.148047704216214e-09,  5.430451228728617e-10, -9.368096226264858e-11,  1.614865048603501e-11,
 -2.705729161356222e-12,  2.000205685161340e+00, -1.206480794056806e-04,  2.088851797121600e-05, -3.616894358571141e-06,  6.263332174225002e-07, -1.084718221810284e-07,
  1.878757564847230e-08, -3.254372802109336e-09,  5.637762010504077e-10, -9.767395182666290e-11,  1.690931547148040e-11, -2.844753420982851e-12,  2.000067058636260e+00,
 -3.771209817999845e-05,  4.625820898589738e-06, -4.710232802275670e-07,  2.438294068568318e-08,  5.686200053547317e-09, -2.701648038374418e-09,  7.653716243202959e-10,
 -1.840980409662001e-10,  4.081286030451572e-11, -8.603150674006907e-12,  1.691571753790246e-12,  2.000074809353639e+00, -4.261311572184039e-05,  5.890966766437340e-06,
 -7.627793919750391e-07,  8.758756294414174e-08, -7.471794505684592e-09, -3.694828003373941e-11,  2.365496023497930e-10, -8.076587161227371e-11,  2.086841893039338e-11,
 -4.796056731091132e-12,  9.944861636202729e-13,  2.000080526015623e+00, -4.622663110092167e-05,  6.822179442906619e-06, -9.771604715647224e-07,  1.339505687440615e-07,
 -1.710716129433560e-08,  1.911024308111092e-09, -1.493733711640923e-10, -5.485126567673271e-12,  6.363059497722196e-12, -2.031900152478761e-12,  4.891676335503583e-13,
  2.000085088642575e+00, -4.910988254954971e-05,  7.564240117971305e-06, -1.147772748137356e-06,  1.707997170017683e-07, -2.475530570134880e-08,  3.455222501290658e-09,
 -4.549033751861425e-10,  5.403597851079562e-11, -5.090762636695467e-12,  1.479310637497780e-13,  9.115198287204946e-14,  2.000088841504561e+00, -5.148089147450792e-05,
  8.173825992698231e-06, -1.287778850921507e-06,  2.010065019748616e-07, -3.101817828494036e-08,  4.718391543899294e-09, -7.045662290246369e-10,  1.026222412873161e-10,
 -1.443053670722706e-11,  1.923571996179698e-12, -2.327460108889063e-13,  2.000091964425395e+00, -5.345354758912506e-05,  8.680555703674752e-06, -1.404059875560060e-06,
  2.260725690787817e-07, -3.621066333828225e-08,  5.764757610999238e-09, -9.111980860234814e-10,  1.427993606903488e-10, -2.214711103585171e-11,  3.389351699201212e-12,
 -4.999061095555651e-13,  2.000094565612485e+00, -5.509638745165082e-05,  9.102258385934334e-06, -1.500759028943805e-06,  2.469022884974588e-07, -4.052243837624231e-08,
  6.633015223462954e-09, -1.082533438706287e-09,  1.760893743230322e-10, -2.853630441425297e-11,  4.602122306138822e-12, -7.208033804533333e-13,  2.000096715720615e+00,
 -5.645416467334931e-05,  9.450578836010467e-06, -1.580582889844455e-06,  2.640865400338267e-07, -4.407744707325139e-08,  7.348451582655681e-09, -1.223627198114168e-09,
  2.034870587578344e-10, -3.379146183147713e-11,  5.599041617600863e-12, -9.022839891525598e-13,  2.000098463182859e+00, -5.755755849469233e-05,  9.733501054219497e-06,
 -1.645387419006045e-06,  2.780305467059284e-07, -4.696069627817471e-08,  7.928410841759509e-09, -1.337946551468684e-09,  2.256747367983344e-10, -3.804519668132763e-11,
  6.405594642046064e-12, -1.049043152460833e-12,  2.000099842054976e+00, -5.842814165152202e-05,  9.956639849167225e-06, -1.696477962157007e-06,  2.890193328324674e-07,
 -4.923198057468289e-08,  8.385093305242511e-09, -1.427930401444219e-09,  2.431323596380436e-10, -4.139078614833308e-11,  7.039705799572368e-12, -1.164382915242173e-12,
  2.000100876386218e+00, -5.908114853125514e-05,  1.012396068056365e-05, -1.734776481439039e-06,  2.972542192446249e-07, -5.093353555514364e-08,  8.727116615056893e-09,
 -1.495301428686589e-09,  2.561989211068095e-10, -4.389410920687647e-11,  7.514033700412298e-12, -1.250635067323661e-12,  2.000101582796155e+00, -5.952710719169472e-05,
  1.023820410452621e-05, -1.760920171654564e-06,  3.028743466240515e-07, -5.209455181136939e-08,  8.960436633132364e-09, -1.541250179024031e-09,  2.651086886434977e-10,
 -4.560068978209239e-11,  7.837325081500570e-12, -1.309410677428603e-12,  2.000101972133597e+00, -5.977288982122111e-05,  1.030115872013322e-05, -1.775324819146165e-06,
  3.059704912938608e-07, -5.273406986773476e-08,  9.088937504705459e-09, -1.566552916118356e-09,  2.700143784045194e-10, -4.654019807226584e-11,  8.015279391358509e-12,
 -1.341759315065907e-12,  2.000042168754994e+00, -2.432047227771708e-05,  3.725245135862608e-06, -5.616285387675704e-07,  8.293050653002656e-08, -1.190214584756199e-08,
  1.639066945415115e-09, -2.114052142983770e-10,  2.417783591189714e-11, -2.053635429999899e-12, -9.281173939992691e-15,  5.901438464379966e-14,  2.000044068890170e+00,
 -2.552033358151114e-05,  4.032981556988985e-06, -6.321344776630558e-07,  9.810492133555731e-08, -1.504052601611949e-08,  2.270481479027802e-09, -3.358925425720561e-10,
  4.834357260380590e-11, -6.687419832182495e-12,  8.694776602064687e-13, -1.009061172626887e-13,  2.000045474012856e+00, -2.640745477904377e-05,  4.260315495300786e-06,
 -6.841749370613818e-07,  1.092955938622824e-07, -1.735300670552252e-08,  2.735334121289084e-09, -4.274627170341625e-10,  6.610415463501544e-11, -1.009010264206673e-11,
  1.514219163492613e-12, -2.181455607413375e-13,  2.000046597709917e+00, -2.711680122057431e-05,  4.441975402200565e-06, -7.257327563986010e-07,  1.182262579379759e-07,
 -1.919726314865827e-08,  3.105822051124462e-09, -5.003964475825793e-10,  8.024083183402513e-11, -1.279672467434667e-11,  2.026737252982024e-12, -3.112847940490590e-13,
  2.000047523462824e+00, -2.770112822651117e-05,  4.591540099583861e-06, -7.599301629324566e-07,  1.255712936212482e-07, -2.071326938469629e-08,  3.410207054030591e-09,
 -5.602854683435442e-10,  9.184291216225629e-11, -1.501689407393175e-11,  2.446920625726794e-12, -3.876064898501965e-13,  2.000048294847642e+00, -2.818797464665585e-05,
  4.716099525254170e-06, -7.883977390758137e-07,  1.316829723210284e-07, -2.197415800614814e-08,  3.663258099519269e-09, -6.100524546265777e-10,  1.014798573679826e-10,
 -1.686020773397154e-11,  2.795629186007325e-12, -4.509197105077796e-13,  2.000048938072438e+00, -2.859390389463074e-05,  4.819918745698546e-06, -8.121165599455646e-07,
  1.367732811130570e-07, -2.302394512602233e-08,  3.873865476797545e-09, -6.514569803573788e-10,  1.094945529174707e-10, -1.839266455505837e-11,  3.085426153511584e-12,
 -5.035187590120098e-13,  2.000049470243121e+00, -2.892972719119894e-05,  4.905782047457933e-06, -8.317271715640420e-07,  1.409806447648122e-07, -2.389137617174387e-08,
  4.047835786741270e-09, -6.856484132461843e-10,  1.161109959031323e-10, -1.965738350255278e-11,  3.324520095490787e-12, -5.469027916451507e-13,  2.000049903081960e+00,
 -2.920285339004255e-05,  4.975597704265257e-06, -8.476686344375362e-07,  1.443999557358472e-07, -2.459615844109390e-08,  4.189150259306819e-09, -7.134148651927154e-10,
  1.214827899855765e-10, -2.068393479651950e-11,  3.518540609813444e-12, -5.821000059789870e-13,  2.000050244829496e+00, -2.941849088526416e-05,  5.030707348063632e-06,
 -8.602496609614418e-07,  1.470979400525230e-07, -2.515215059855337e-08,  4.300608773226565e-09, -7.353106229121180e-10,  1.257179714911496e-10, -2.149311739361361e-11,
  3.671447560178283e-12, -6.098336578704473e-13,  2.000050501303928e+00, -2.958031709685022e-05,  5.072058313449351e-06, -8.696882489471882e-07,  1.491217191700059e-07,
 -2.556914004741139e-08,  4.384188777739216e-09, -7.517271740040368e-10,  1.288928480952331e-10, -2.209962232751902e-11,  3.786038001460671e-12, -6.306146286398589e-13,
  2.000050676525556e+00, -2.969087309944499e-05,  5.100305232818160e-06, -8.761350466303547e-07,  1.505038577271284e-07, -2.585389086494681e-08,  4.441256924435662e-09,
 -7.629350885669442e-10,  1.310601594565801e-10, -2.251360335554835e-11,  3.864245142747711e-12, -6.447960197220924e-13,  2.000050773119364e+00, -2.975181801831522e-05,
  5.115875498602880e-06, -8.796884007035940e-07,  1.512656129874814e-07, -2.601081808595439e-08,  4.472705176658642e-09, -7.691109426537987e-10,  1.322543208582090e-10,
 -2.274168572486247e-11,  3.907330273759468e-12, -6.526081863686843e-13,  2.000023198038615e+00, -1.349509388662201e-05,  2.205183061161560e-06, -3.593490482322673e-07,
  5.837877830866095e-08, -9.451461006909497e-09,  1.524249284901524e-09, -2.447339042358199e-10,  3.909577298455680e-11, -6.208782677506786e-12,  9.787131768572376e-13,
 -1.495559162713604e-13,  2.000023668474390e+00, -1.379195304708199e-05,  2.281075949477385e-06, -3.766806059431551e-07,  6.209676978829742e-08, -1.021791137539131e-08,
  1.677949252612112e-09, -2.749378941097602e-10,  4.493988817752571e-11, -7.325733896504302e-12,  1.189845041962101e-12, -1.878615432300836e-13,  2.000024016803343e+00,
 -1.401173950387216e-05,  2.337241313092959e-06, -3.895015600669413e-07,  6.484596586751953e-08, -1.078440578942809e-08,  1.791502482427071e-09, -2.972429894833062e-10,
  4.925381296751646e-11, -8.149875973236006e-12,  1.345562234737994e-12, -2.161020087636893e-13,  2.000024295641887e+00, -1.418766730204861e-05,  2.382184297151224e-06,
 -3.997574211429784e-07,  6.704441007343391e-08, -1.123726488229695e-08,  1.882247874576647e-09, -3.150621306458368e-10,  5.269900033374368e-11, -8.807836755530101e-12,
  1.469839810404615e-12, -2.386337745799513e-13,  2.000024525545508e+00, -1.433271251027686e-05,  2.419228227366678e-06, -4.082085055841290e-07,  6.885550210276848e-08,
 -1.161023389640801e-08,  1.956964760123833e-09, -3.297299463870276e-10,  5.553415026427832e-11, -9.349148874888063e-12,  1.572057392143980e-12, -2.571614252306613e-13,
  2.000024717239884e+00, -1.445364611158572e-05,  2.450107449937092e-06, -4.152516494089886e-07,  7.036453645236010e-08, -1.192092993394094e-08,  2.019192786337998e-09,
 -3.419433582732709e-10,  5.789436704878397e-11, -9.799683287318999e-12,  1.657114501407886e-12, -2.725754531883394e-13,  2.000024877173885e+00, -1.455453928126013e-05,
  2.475864876698980e-06, -4.211255051328437e-07,  7.162281322221489e-08, -1.217994975246204e-08,  2.071061263071327e-09, -3.521216443765553e-10,  5.986093856140590e-11,
 -1.017500704911107e-11,  1.727959521522366e-12, -2.854117707276261e-13,  2.000025009555662e+00, -1.463804867442248e-05,  2.497181118102866e-06, -4.259858313455809e-07,
  7.266381648692866e-08, -1.239421048686854e-08,  2.113960220745695e-09, -3.605385324405333e-10,  6.148693768665433e-11, -1.048528458282308e-11,  1.786517708030613e-12,
 -2.960203421848080e-13,  2.000025117268403e+00, -1.470599450824722e-05,  2.514522528124944e-06, -4.299393607348624e-07,  7.351049247228459e-08, -1.256845265553286e-08,
  2.148842344979190e-09, -3.673816380545767e-10,  6.280874308350669e-11, -1.073748343187890e-11,  1.834108858581294e-12, -3.046410854430108e-13,  2.000025202338628e+00,
 -1.475965618056001e-05,  2.528216916236045e-06, -4.330611217602056e-07,  7.417897219866579e-08, -1.270600896893917e-08,  2.176377430478077e-09, -3.727828720760554e-10,
  6.385193336558590e-11, -1.093650282679162e-11,  1.871661025660506e-12, -3.114427113717643e-13,  2.000025266196979e+00, -1.479993690497904e-05,  2.538495715110451e-06,
 -4.354040864911874e-07,  7.468064503877500e-08, -1.280923258946623e-08,  2.197038423339661e-09, -3.768353807578655e-10,  6.463457095744189e-11, -1.108580248323483e-11,
  1.899829596262418e-12, -3.165443660368974e-13,  2.000025309831934e+00, -1.482746074469400e-05,  2.545518834564673e-06, -4.370048573032447e-07,  7.502338096958431e-08,
 -1.287974957614356e-08,  2.211152141765513e-09, -3.796035320360914e-10,  6.516913800564907e-11, -1.118777330507102e-11,  1.919067496552851e-12, -3.200283904554442e-13,
  2.000025333888976e+00, -1.484263521328736e-05,  2.549390692142698e-06, -4.378873338749577e-07,  7.521231853882913e-08, -1.291862159305217e-08,  2.218931959358524e-09,
 -3.811293489482683e-10,  6.546378324736225e-11, -1.124397608814524e-11,  1.929670387647537e-12, -3.219485331756931e-13,  2.000012121773076e+00, -7.077436420512058e-06,
  1.186949115263304e-06, -1.989449036889791e-07,  3.332462476213226e-08, -5.578476301997271e-09,  9.331873285773354e-10, -1.559943261038908e-10,  2.605659884350850e-11,
 -4.348786554216730e-12,  7.246582707464120e-13, -1.174822547256514e-13,  2.000012238813084e+00, -7.151267096710451e-06,  1.205793863881412e-06, -2.032414866274387e-07,
  3.424483635578679e-08, -5.767865742386229e-09,  9.711046101890856e-10, -1.634334021839110e-10,  2.749362429403030e-11, -4.622988730647381e-12,  7.764051792980606e-13,
 -1.268563886138962e-13,  2.000012325529648e+00, -7.205966832051964e-06,  1.219752638956652e-06, -2.064233962935267e-07,  3.492616975359883e-08, -5.908061508526369e-09,
  9.991669191011478e-10, -1.689378305747861e-10,  2.855670118461910e-11, -4.825793476267048e-12,  8.146699411259392e-13, -1.337867984464109e-13,  2.000012394980672e+00,
 -7.249774183304410e-06,  1.230929992815103e-06, -2.089708645136106e-07,  3.547156277499276e-08, -6.020266877939750e-09,  1.021622842578136e-09, -1.733418425055763e-10,
  2.940711373923397e-11, -4.988001312947941e-12,  8.452699653580534e-13, -1.393281427334768e-13,  2.000012452266179e+00, -7.285906937853807e-06,  1.240147982044226e-06,
 -2.110714895582426e-07,  3.592123047570194e-08, -6.112766084828548e-09,  1.040132462018018e-09, -1.769714296800366e-10,  3.010789191958591e-11, -5.121650066468071e-12,
  8.704790613201469e-13, -1.438926788319957e-13,  2.000012500046799e+00, -7.316043806661622e-06,  1.247835499122031e-06, -2.128231536239682e-07,  3.629615701479849e-08,
 -6.189882107767250e-09,  1.055562116081336e-09, -1.799967265331428e-10,  3.069193299431897e-11, -5.233023035800785e-12,  8.914841456869654e-13, -1.476956151602578e-13,
  2.000012539922001e+00, -7.341193975598039e-06,  1.254250393709393e-06, -2.142847064721640e-07,  3.660895936783132e-08, -6.254214323615953e-09,  1.068432754833655e-09,
 -1.825200441320563e-10,  3.117902086631395e-11, -5.325899085585449e-12,  9.089990816344811e-13, -1.508663932392347e-13,  2.000012572935366e+00, -7.362015900882530e-06,
  1.259560910415414e-06, -2.154945487086877e-07,  3.686787070746419e-08, -6.307459020333649e-09,  1.079084351377204e-09, -1.846081536428306e-10,  3.158206760798573e-11,
 -5.402744611205114e-12,  9.234898128184426e-13, -1.534895035558669e-13,  2.000012599801822e+00, -7.378960675561110e-06,  1.263882313824135e-06, -2.164789895682794e-07,
  3.707853198807445e-08, -6.350778448982434e-09,  1.087749854100776e-09, -1.863068079689726e-10,  3.190992111438121e-11, -5.465249745256992e-12,  9.352756438995245e-13,
 -1.556228479526001e-13,  2.000012621023832e+00, -7.392345335972516e-06,  1.267295616317119e-06, -2.172565207249869e-07,  3.724490811595888e-08, -6.384989553812688e-09,
  1.094593006515603e-09, -1.876481684962796e-10,  3.216880105842582e-11, -5.514602605904731e-12,  9.445810432344320e-13, -1.573071318640104e-13,  2.000012636956090e+00,
 -7.402393683579841e-06,  1.269858007250633e-06, -2.178401963671287e-07,  3.736979817718374e-08, -6.410669081700442e-09,  1.099729410862658e-09, -1.886549415077529e-10,
  3.236309868636645e-11, -5.551642051520306e-12,  9.515644974700358e-13, -1.585710960202458e-13,  2.000012647843655e+00, -7.409260343465085e-06,  1.271608999536514e-06,
 -2.182390359522486e-07,  3.745513615801786e-08, -6.428215533109880e-09,  1.103238943109807e-09, -1.893428162495717e-10,  3.249584823746415e-11, -5.576947719670859e-12,
  9.563355197475766e-13, -1.594346002982659e-13,  2.000012653846560e+00, -7.413046291556679e-06,  1.272574396140823e-06, -2.184589293212517e-07,  3.750218495854103e-08,
 -6.437889125732410e-09,  1.105173760717379e-09, -1.897220373128687e-10,  3.256903094020251e-11, -5.590898082039808e-12,  9.589656148685085e-13, -1.599106116549691e-13,
  2.000006190874231e+00, -3.620717421198643e-06,  6.144056417518349e-07, -1.042453008209504e-07,  1.768467558724114e-08, -2.999684404850901e-09,  5.087335455764895e-10,
 -8.626605748159397e-11,  1.462589293641992e-11, -2.479285800935698e-12,  4.198776958404016e-13, -6.916792681175343e-14,  2.000006220063476e+00, -3.639127333013591e-06,
  6.191008733431921e-07, -1.053149427138517e-07,  1.791357786564152e-08, -3.046756629709617e-09,  5.181501068278086e-10, -8.811200814874710e-11,  1.498218927093166e-11,
 -2.547216107927347e-12,  4.326869640384823e-13, -7.148660364598338e-14,  2.000006241697112e+00, -3.652771552542067e-06,  6.225803050565294e-07, -1.061075235367996e-07,
  1.808317126590141e-08, -3.081628652862231e-09,  5.251253329545588e-10, -8.947923177167289e-11,  1.524605580176235e-11, -2.597518659904284e-12,  4.421712456237961e-13,
 -7.320323445184823e-14,  2.000006259027671e+00, -3.663701658680160e-06,  6.253673820440084e-07, -1.067423409480874e-07,  1.821899594920759e-08, -3.109554818778357e-09,
  5.307107658698965e-10, -9.057395027701123e-11,  1.545731302050204e-11, -2.637788658434704e-12,  4.497633212711765e-13, -7.457727544048069e-14,  2.000006273325337e+00,
 -3.672718842110396e-06,  6.276665306947143e-07, -1.072659874382423e-07,  1.833102721374584e-08, -3.132587418827790e-09,  5.353171439225826e-10, -9.147671850622224e-11,
  1.563151633910268e-11, -2.670993203905469e-12,  4.560229364121351e-13, -7.571009246012607e-14,  2.000006285252683e+00, -3.680241037434212e-06,  6.295843918865570e-07,
 -1.077027692076578e-07,  1.842446910906607e-08, -3.151797155734495e-09,  5.391587608336032e-10, -9.222956555935485e-11,  1.577678198396569e-11, -2.698680467595789e-12,
  4.612421639943966e-13, -7.665457940231777e-14,  2.000006295207991e+00, -3.686519471424289e-06,  6.311850707833208e-07, -1.080672978685695e-07,  1.850245012126571e-08,
 -3.167827714534235e-09,  5.423644491511585e-10, -9.285775984138923e-11,  1.589798965839770e-11, -2.721781278131969e-12,  4.655966157018339e-13, -7.744254000610502e-14,
  2.000006303451105e+00, -3.691718048479660e-06,  6.325103915607141e-07, -1.083691066983959e-07,  1.856701146186935e-08, -3.181099083184651e-09,  5.450182706606557e-10,
 -9.337778906347996e-11,  1.599832345306801e-11, -2.740903030416239e-12,  4.692008861254755e-13, -7.809472806827987e-14,  2.000006310160027e+00, -3.695949049077900e-06,
  6.335890058287766e-07, -1.086147265799239e-07,  1.861955151233342e-08, -3.191898989881513e-09,  5.471778160254035e-10, -9.380094914725958e-11,  1.607996486435839e-11,
 -2.756461872555059e-12,  4.721334895207058e-13, -7.862536324348474e-14,  2.000006315459854e+00, -3.699291382180840e-06,  6.344410497931318e-07, -1.088087474533887e-07,
  1.866105307753366e-08, -3.200429657615699e-09,  5.488835620852761e-10, -9.413517939885196e-11,  1.614444717300485e-11, -2.768750301506918e-12,  4.744496117858365e-13,
 -7.904444033812226e-14,  2.000006319438890e+00, -3.701800748887008e-06,  6.350807375820850e-07, -1.089544093917514e-07,  1.869220993494940e-08, -3.206833840464895e-09,
  5.501640827485127e-10, -9.438608449543656e-11,  1.619285279623483e-11, -2.777974807395195e-12,  4.761882121980273e-13, -7.935901540241010e-14,  2.000006322158143e+00,
 -3.703515632245690e-06,  6.355178896031550e-07, -1.090539509492777e-07,  1.871350141673991e-08, -3.211210168283503e-09,  5.510391200984010e-10, -9.455753681162841e-11,
  1.622592960186929e-11, -2.784278060260777e-12,  4.773762090611268e-13, -7.957396373835945e-14,  2.000006323657454e+00, -3.704461163802692e-06,  6.357589190690733e-07,
 -1.091088340005734e-07,  1.872524054528739e-08, -3.213623049621659e-09,  5.515215662566738e-10, -9.465206509250905e-11,  1.624416595969147e-11, -2.787753225140460e-12,
  4.780311801582378e-13, -7.969246891588296e-14,  2.000003127846875e+00, -1.830799675464166e-06,  3.124159267520546e-07, -5.331031063332882e-08,  9.096510040825079e-09,
 -1.552114541538822e-09,  2.648243623122315e-10, -4.518321427636179e-11,  7.708695097339532e-12, -1.315101272586058e-12,  2.241688309320817e-13, -3.716001530612091e-14,
  2.000003135135364e+00, -1.835396199740028e-06,  3.135877466406713e-07, -5.357716026550148e-08,  9.153592413165616e-09, -1.563848376745698e-09,  2.671707013417767e-10,
 -4.564298527335701e-11,  7.797401672620718e-12, -1.332006888521759e-12,  2.273553419143342e-13, -3.773660377089106e-14,  2.000003140538097e+00, -1.838803424386829e-06,
  3.144563254588148e-07, -5.377494460899543e-08,  9.195898626620516e-09, -1.572544364543430e-09,  2.689094886877885e-10, -4.598368676207587e-11,  7.863131881931782e-12,
 -1.344533019327195e-12,  2.297162452166729e-13, -3.816377992683273e-14,  2.000003144866721e+00, -1.841533240255413e-06,  3.151521893553635e-07, -5.393339353223175e-08,
  9.229789579527875e-09, -1.579510320947838e-09,  2.703022942375892e-10, -4.625658468122484e-11,  7.915778851302968e-12, -1.354565480096082e-12,  2.316070686090719e-13,
 -3.850588783386382e-14,  2.000003148438179e+00, -1.843785539397210e-06,  3.157263095224576e-07, -5.406411696087540e-08,  9.257749343513653e-09, -1.585256987899964e-09,
  2.714512711555015e-10, -4.648170078808472e-11,  7.959206392932247e-12, -1.362840801353547e-12,  2.331666711756420e-13, -3.878805895511379e-14,  2.000003151417793e+00,
 -1.845664588266977e-06,  3.162052736799082e-07, -5.417317099464199e-08,  9.281073709644566e-09, -1.590050793285093e-09,  2.724097084032829e-10, -4.666947975681595e-11,
  7.995430160746910e-12, -1.369743219009972e-12,  2.344674946262651e-13, -3.902340438380185e-14,  2.000003153904936e+00, -1.847233060237725e-06,  3.166050636198020e-07,
 -5.426419598540497e-08,  9.300541595130288e-09, -1.594051892641597e-09,  2.732096395625519e-10, -4.682620027798020e-11,  8.025661857466393e-12, -1.375503718171837e-12,
  2.355530882021933e-13, -3.921980611755517e-14,  2.000003155964438e+00, -1.848531842937964e-06,  3.169361058587297e-07, -5.433956692470616e-08,  9.316661176902381e-09,
 -1.597364774963088e-09,  2.738719642831623e-10, -4.695595880012384e-11,  8.050692051408586e-12, -1.380273005408753e-12,  2.364518659865063e-13, -3.938240688828105e-14,
  2.000003157640709e+00, -1.849588945036706e-06,  3.172055427914585e-07, -5.440091074965910e-08,  9.329780573965831e-09, -1.600061019544063e-09,  2.744109998262620e-10,
 -4.706156161291305e-11,  8.071062329835311e-12, -1.384154324821670e-12,  2.371832937095811e-13, -3.951472987471976e-14,  2.000003158964957e+00, -1.850424050103470e-06,
  3.174183938960263e-07, -5.444937083558485e-08,  9.340144438517559e-09, -1.602190931497775e-09,  2.748368082769188e-10, -4.714498097488034e-11,  8.087153322806564e-12,
 -1.387220237395789e-12,  2.377610521836375e-13, -3.961925123796316e-14,  2.000003159959213e+00, -1.851051052315206e-06,  3.175782023274773e-07, -5.448575427451191e-08,
  9.347925468040272e-09, -1.603790020904535e-09,  2.751564924441088e-10, -4.720760910840313e-11,  8.099233719673557e-12, -1.389521964730452e-12,  2.381947989019843e-13,
 -3.969771894742589e-14,  2.000003160638697e+00, -1.851479550820073e-06,  3.176874159755266e-07, -5.451061867133571e-08,  9.353242976519778e-09, -1.604882821225464e-09,
  2.753749595883499e-10, -4.725040789015626e-11,  8.107489156791413e-12, -1.391094895761019e-12,  2.384912062411584e-13, -3.975134068237187e-14,  2.000003161013349e+00,
 -1.851715814473152e-06,  3.177476334615124e-07, -5.452432817456606e-08,  9.356174882621083e-09, -1.605485354107355e-09,  2.754954143966703e-10, -4.727400547116436e-11,
  8.112040862980225e-12, -1.391962140942993e-12,  2.386546315238156e-13, -3.978090510143043e-14,   0.00143443691394128,  0.000969836868275439,  0.000990273952235882,
  0.000405446305862871,  0.000103488429581718,  1.65055327717967e-05,   1.6086180644879e-06,  9.16835886019769e-08,  2.84685338587723e-09,  4.30250568455655e-11,
  2.61818227910429e-13,  4.46474028190852e-16,  8.58145132860284e-20,  0.000715673032152446,  0.000483785804025621,  0.000494233895298363,  0.000202452810701624,
  5.17096144278288e-05,    8.254358012085e-06,  8.05341061644915e-07,  4.59632254254706e-08,  1.42963364845319e-09,  2.16529921568362e-11,  1.32132699287312e-13,
  2.26182006100888e-16,  4.37252836298416e-20,  0.000357471705670081,  0.000241637123761871,  0.000246882072637703,  0.000101140481042183,  2.58363904975065e-05,
  4.12496035843502e-06,  4.02541731397243e-07,  2.29804081758334e-08,  7.15013202601249e-10,  1.08338241587176e-11,  6.61442790699884e-14,  1.13298168297832e-16,
   2.1922955389488e-20,  0.000178646787163905,  0.000120757294708026,  0.000123381496558502,  5.05470344871637e-05,  1.29126723584681e-05,  2.06168072734653e-06,
  2.01202786347516e-07,  1.14870083064213e-08,  3.57433174287278e-10,  5.41627757558932e-12,  3.30718554036197e-14,  5.66564132708929e-17,  1.09649857599156e-20,
  8.93013691444438e-05,  6.03636316832429e-05,  6.16757748656949e-05,  2.52675255992836e-05,  6.45485420734928e-06,  1.03061360476002e-06,  1.00580449310356e-07,
   5.7423905290597e-09,  1.78685010641138e-10,  2.70771648839422e-12,  1.65337679217817e-14,  2.83254100246714e-17,  5.48219023557809e-21,  4.46452073454841e-05,
  3.01780977452724e-05,   3.0834133784127e-05,  1.26322425011178e-05,   3.2270446905936e-06,  5.15246951208231e-07,  5.02845285464034e-08,  2.87088007203073e-09,
  8.93330716753518e-11,  1.35372210613044e-12,   8.2661032928825e-15,  1.41614762746149e-17,  2.74088584223483e-21,  2.23212378965441e-05,  1.50881237198941e-05,
  1.54161272375162e-05,   6.3157384580701e-06,  1.61342529501313e-06,  2.57608129346036e-07,  2.51407845009671e-08,  1.43535678826719e-09,  4.46639915670304e-11,
  6.76823337430248e-13,  4.13282756932037e-15,   7.0803675812959e-18,  1.37037469230927e-21,  1.11602779407012e-05,   7.5438311117473e-06,  7.70782855251751e-06,
  3.15777319605323e-06,   8.0668820665965e-07,   1.2880018088387e-07,  1.25700154464881e-08,  7.17657034979878e-10,  2.23313368808685e-11,  3.38401788069116e-13,
  2.06635422269777e-15,  3.54008340001396e-18,  6.85168347607315e-22,  5.58005377272041e-06,  3.77185793592632e-06,  3.85385549078863e-06,  1.57886254822333e-06,
  4.03337970993527e-07,  6.43991136351383e-08,  6.28491267121906e-09,  3.58823109851839e-10,  1.11655008848218e-11,  1.69198367921946e-13,  1.03316178238497e-15,
  1.77001564380267e-18,  3.42579184398014e-22,  2.79000559371705e-06,  1.88591457133962e-06,  1.92691304667329e-06,  7.89425256484694e-07,  2.01667449657033e-07,
  3.21993118861325e-08,  3.14243246663362e-09,  1.79410194569428e-10,  5.58270820127754e-12,  8.45985454709043e-14,  5.16577004412492e-16,  8.85001188676235e-19,
  1.71288315055781e-22,  1.39499747454214e-06,  9.42953687557811e-07,  9.63452848362842e-07,  3.94711123189741e-07,  1.00833340524744e-07,   1.6099594619158e-08,
  1.57121025285206e-09,  8.97047561418519e-11,  2.79134349642085e-12,  4.22991122446853e-14,  2.58287523710679e-16,  4.42498921175159e-19,  8.56438345292534e-23
  };
  int offset = -13;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 13;
    if (std::isnan(t)) {
      fill_n(rr+offset, 13, 0.5);
      fill_n(ww+offset, 13, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 13; ++r) {
        ww[offset+r] = aw[13-r-1] / t;
        rr[offset+r] = 1.0 - ax[13-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=13; ++j) {
        const int boxof = it*156+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 6708 + (it - 32) * 13 + 13 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
