/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:52:15 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class AGWindowAlgorithm_ESTest extends AGWindowAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Short short0 = new Short((short)2953);
      assertNotNull(short0);
      assertEquals((short)2953, (short)short0);
      
      Integer integer0 = new Integer(103);
      assertNotNull(integer0);
      assertEquals(103, (int)integer0);
      
      PartialSequence partialSequence0 = new PartialSequence((char[]) null, 0, 0, short0, integer0);
      assertEquals(103, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2953, (short)partialSequence0.getStrand());
      assertNotNull(partialSequence0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertEquals(103, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2953, (short)partialSequence0.getStrand());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(103, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2953, (short)partialSequence0.getStrand());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(103, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2953, (short)partialSequence0.getStrand());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Float float0 = aGWindowAlgorithm0.getAverage();
      assertEquals(103, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2953, (short)partialSequence0.getStrand());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(float0);
      assertEquals(Float.NaN, (float)float0, 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Cannot find the 'token' Tokenization for RNA!?");
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      Float float0 = aGWindowAlgorithm0.getAverage();
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(float0);
      assertEquals(4.347826F, (float)float0, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("}])1@Fg", "m");
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      aGWindowAlgorithm0.getValues((-798), 50000, floatArray0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("j^Phtr2iwDtYs");
      assertEquals(11, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(13, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(11, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(13, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(11, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(13, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(11, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(13, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      float[] floatArray0 = new float[6];
      // Undeclared exception!
      try { 
        aGWindowAlgorithm0.getValues(0, (-5), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -5
         //
         verifyException("uk.ac.sanger.artemis.plot.AGWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      // Undeclared exception!
      try { 
        aGWindowAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      AGWindowAlgorithm aGWindowAlgorithm0 = null;
      try {
        aGWindowAlgorithm0 = new AGWindowAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Joz- ^$d]-(\"INZS+");
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(17, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(17, fastaStreamSequence0.getOtherCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(17, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(17, fastaStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(17, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(17, fastaStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(17, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(17, fastaStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Integer integer0 = aGWindowAlgorithm0.getDefaultStepSize(78);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(17, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(17, fastaStreamSequence0.getOtherCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertNotNull(integer0);
      assertEquals(7, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Joz- ^$d](\"INZS+");
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Integer integer0 = aGWindowAlgorithm0.getDefaultStepSize(0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNull(integer0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Joz- ^$d](\"INZS+");
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      Integer integer0 = aGWindowAlgorithm0.getDefaultMinWindowSize();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(16, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(16, fastaStreamSequence0.length());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Cannot find the 'token' Tokenization for RNA!?");
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Integer integer0 = aGWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(4, rawStreamSequence0.getTCount());
      assertEquals(46, rawStreamSequence0.length());
      assertEquals(40, rawStreamSequence0.getOtherCount());
      assertEquals(2, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Integer integer0 = aGWindowAlgorithm0.getDefaultWindowSize();
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(integer0);
      assertEquals(120, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Reverse GC Frame Plot");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(rawStreamSequence0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      float[] floatArray0 = new float[3];
      aGWindowAlgorithm0.getValues(2, 3294, floatArray0);
      assertArrayEquals(new float[] {0.030367445F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Joz- ^$d](\"INZS+");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      aGWindowAlgorithm0.getAverage();
      assertTrue(aGWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Short short0 = new Short((short)2953);
      Integer integer0 = new Integer(103);
      PartialSequence partialSequence0 = new PartialSequence((char[]) null, 0, 0, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Float float0 = aGWindowAlgorithm0.getMinimumInternal();
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(0.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Joz- ^$d](\"INZS+");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Float float0 = aGWindowAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float0, 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      aGWindowAlgorithm0.getValueCount();
  }
}
