#ifndef SYNTH_H
#define SYNTH_H

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <QtCore/QThread>
#include "voicesynth.h"
#include "model.h"

class Synth : public QThread
{
  Q_OBJECT

  private:
    Model *model;
    double *shbuf[MAX_PARAMS];
    double *modelFilter[2];
    double *a[MAX_POLY], *a1[MAX_POLY], *a2[MAX_POLY], *da[MAX_POLY];
    double *f[2][MAX_POLY];
    double pb, pb1, pb2, dpb, lfo, lfo1, lfo2, dlfo;
    double v1[MAX_POLY], v2[MAX_POLY], v[MAX_POLY], dv[MAX_POLY];
    double logConst;

  public:
    VoiceSynth *voiceSynth[MAX_POLY];

  protected:
    void initSynth();
    void envStep();
    void filterStep(int filterIndex, int harmonicIndex);
    virtual void run();

  public:
    Synth(Model *p_model, QThread *parent=0);
    ~Synth();
};
  
#endif
