!{\src2tex{textfont=tt}}
!!****f* ABINIT/assemblychi0
!! NAME
!! assemblychi0
!!
!! FUNCTION
!! Update the independent particle susceptibility for the contribution
!! of one pair of occupied-unoccupied band, for each frequencies.
!! Compute chi0(G,G'',io)=chi0(G,G'',io)+(rhotwg(G)*rhotwg*(G''))*den(io)
!!
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  npwsigx=number of plane waves for sigma exchange (input variable)
!!  nomega=number of frequencies
!!  rhotwg(npwsigx)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  den(nomega)=denominator of the susceptibility expression
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix in reciprocal space
!!
!! PARENTS
!!      cchi0,cchi0q0
!!
!! CHILDREN
!!      cgerc
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine assemblychi0(npwsigx,nomega,chi0,rhotwg,den)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwsigx
!arrays
 complex,intent(in) :: rhotwg(npwsigx)
 complex,target :: chi0(npwsigx,npwsigx,nomega)
!no_abirules
 complex(kind(0.0_dp)),intent(in) :: den(nomega)

!Local variables-------------------------------
!scalars
 integer :: i,i2,ig,igp,io,npwsigx2
 complex :: dd
 logical,parameter :: vectorialized=.false.
!arrays
 complex,allocatable :: rhotwgs(:)

! *************************************************************************

#ifdef VMS
!DEC$ ATTRIBUTES ALIAS:'CGERC' :: cgerc
#endif

 if(vectorialized) then
!  calculate rhotwg*(G)
   allocate(rhotwgs(npwsigx))
   rhotwgs(:)=conjg(rhotwg(:))
   npwsigx2=npwsigx*npwsigx
!  do i=0, npwsigx*npwsigx*nomega-1
!    io =i/npwsigx2+1
!    ig =(i-(i/npwsigx2)*npwsigx2)/npwsigx+1
!    igp=i-(i/npwsigx2)*npwsigx2-&
!&    ((i-(i/npwsigx2)*npwsigx2)/npwsigx)*npwsigx+1
!    chi0(ig,igp,io)=chi0(ig,igp,io)+&
!&                 rhotwg(ig)*rhotwgs(igp)*den(io)
!  end do
   do ig=1,npwsigx
     do igp=1,npwsigx
       do io=1,nomega
         chi0(ig,igp,io)=chi0(ig,igp,io)+&
&                          rhotwg(ig)*rhotwgs(igp)*den(io)
       end do
     end do
   end do
   deallocate(rhotwgs)
 else
!   m(:,:)=0.0
!   call cher('U',npwsigx,1.0,rhotwg,1,m,npwsigx)
!   do ig=1, npwsigx
!     do igp=1, ig-1
!       m(ig,igp)=conjg(m(igp,ig))
!     end do
!   end do
!   do io=1, nomega
!     chi0(:,:,io)=chi0(:,:,io)+den(io)*m(:,:)
!   end do
   do io=1,nomega
!    dd is single precision needed for cgerc
     dd=den(io)
     call cgerc(npwsigx,npwsigx,dd,rhotwg,1,rhotwg,1,chi0(:,:,io),npwsigx)
   end do
 end if

end subroutine assemblychi0
!!***
