/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_REGISTEREDSIMPLEIDENTITYMANAGEMENTPROFILE_H_
#define OPENDRIM_REGISTEREDSIMPLEIDENTITYMANAGEMENTPROFILE_H_

#include <Instance.h>

const static char* OpenDRIM_RegisteredSimpleIdentityManagementProfile_classnames[] = {"OpenDRIM_RegisteredSimpleIdentityManagementProfile"};
static string OpenDRIM_RegisteredSimpleIdentityManagementProfile_NAMESPACE = _INTEROP_NAMESPACE;

class OpenDRIM_RegisteredSimpleIdentityManagementProfile {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	unsigned short RegisteredOrganization;
	bool RegisteredOrganization_isNULL;
	
	string OtherRegisteredOrganization;
	bool OtherRegisteredOrganization_isNULL;
	
	string RegisteredName;
	bool RegisteredName_isNULL;
	
	string RegisteredVersion;
	bool RegisteredVersion_isNULL;
	
	vector<unsigned short> AdvertiseTypes;
	bool AdvertiseTypes_isNULL;
	
	vector<string> AdvertiseTypeDescriptions;
	bool AdvertiseTypeDescriptions_isNULL;
	
	OpenDRIM_RegisteredSimpleIdentityManagementProfile() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstanceID_isNULL = true;
		RegisteredOrganization_isNULL = true;
		OtherRegisteredOrganization_isNULL = true;
		RegisteredName_isNULL = true;
		RegisteredVersion_isNULL = true;
		AdvertiseTypes_isNULL = true;
		AdvertiseTypeDescriptions_isNULL = true;
	}
	
	~OpenDRIM_RegisteredSimpleIdentityManagementProfile() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getRegisteredOrganization(unsigned short& value) const {
		if (RegisteredOrganization_isNULL==true)
			return NOT_FOUND;
		value = RegisteredOrganization;
		return OK;
	}
	
	int setRegisteredOrganization(const unsigned short& newValue) {
		RegisteredOrganization = newValue;
		RegisteredOrganization_isNULL = false;
		return OK;
	}

	int getOtherRegisteredOrganization(string& value) const {
		if (OtherRegisteredOrganization_isNULL==true)
			return NOT_FOUND;
		value = OtherRegisteredOrganization;
		return OK;
	}
	
	int setOtherRegisteredOrganization(const string& newValue) {
		OtherRegisteredOrganization = newValue;
		OtherRegisteredOrganization_isNULL = false;
		return OK;
	}

	int getRegisteredName(string& value) const {
		if (RegisteredName_isNULL==true)
			return NOT_FOUND;
		value = RegisteredName;
		return OK;
	}
	
	int setRegisteredName(const string& newValue) {
		RegisteredName = newValue;
		RegisteredName_isNULL = false;
		return OK;
	}

	int getRegisteredVersion(string& value) const {
		if (RegisteredVersion_isNULL==true)
			return NOT_FOUND;
		value = RegisteredVersion;
		return OK;
	}
	
	int setRegisteredVersion(const string& newValue) {
		RegisteredVersion = newValue;
		RegisteredVersion_isNULL = false;
		return OK;
	}

	int getAdvertiseTypes(vector<unsigned short>& value) const {
		if (AdvertiseTypes_isNULL==true)
			return NOT_FOUND;
		value = AdvertiseTypes;
		return OK;
	}
	
	int setAdvertiseTypes(const vector<unsigned short>& newValue) {
		AdvertiseTypes = newValue;
		AdvertiseTypes_isNULL = false;
		return OK;
	}

	int getAdvertiseTypeDescriptions(vector<string>& value) const {
		if (AdvertiseTypeDescriptions_isNULL==true)
			return NOT_FOUND;
		value = AdvertiseTypeDescriptions;
		return OK;
	}
	
	int setAdvertiseTypeDescriptions(const vector<string>& newValue) {
		AdvertiseTypeDescriptions = newValue;
		AdvertiseTypeDescriptions_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_REGISTEREDSIMPLEIDENTITYMANAGEMENTPROFILE_H_*/
