#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_ComputerSystemCapabilities.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_ComputerSystemCapabilities provider module";
Name = "Base_Server_OpenDRIM_ComputerSystemCapabilitiesModule";
Location = "cmpiBase_Server_OpenDRIM_ComputerSystemCapabilitiesProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_ComputerSystemCapabilities provider";
Name = "Base_Server_OpenDRIM_ComputerSystemCapabilitiesProvider";
ProviderModuleName = "Base_Server_OpenDRIM_ComputerSystemCapabilitiesModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_ComputerSystemCapabilities provider capabilities";
ProviderModuleName = "Base_Server_OpenDRIM_ComputerSystemCapabilitiesModule";
ProviderName = "Base_Server_OpenDRIM_ComputerSystemCapabilitiesProvider";
ClassName = "OpenDRIM_ComputerSystemCapabilities";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "InstanceID", "ElementName", "ElementNameEditSupported", "MaxElementNameLen", "RequestedStatesSupported", "ElementNameMask", "StateAwareness"};
SupportedMethods = {"CreateGoalSettings"};
CapabilityID = "Base_Server_OpenDRIM_ComputerSystemCapabilities";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_ComputerSystemCapabilities.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_ComputerSystemCapabilities]   
   provider: Base_Server_OpenDRIM_ComputerSystemCapabilitiesProvider
   location: cmpiBase_Server_OpenDRIM_ComputerSystemCapabilitiesProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_ComputerSystemCapabilities.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_ComputerSystemCapabilities-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_ComputerSystemCapabilities.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
