/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchive;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.AbstractRunTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.RunStatusWriter;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.emitter.ReportEmitterExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.internal.presentation.ReportDocumentInfo;
import org.eclipse.birt.report.engine.presentation.ReportDocumentBuilder;

public class RunTask
extends AbstractRunTask
implements IRunTask {
    private String documentName;
    private IDocArchiveWriter archiveWriter;
    private ReportDocumentWriter writer;
    private ReportDocumentBuilder documentBuilder;
    private IArchiveFile archive;

    public RunTask(ReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 1);
        this.executionContext.setFactoryMode(true);
        this.executionContext.setPresentationMode(false);
    }

    @Override
    public void run(String reportDocName) throws EngineException {
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (reportDocName == null || reportDocName.length() == 0) {
                throw new EngineException("Error.ReportDocNameNotSpecifiedError");
            }
            this.documentName = reportDocName;
            this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
    }

    @Override
    public void run(IDocArchiveWriter archive) throws EngineException {
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (archive == null) {
                throw new EngineException("Error.ReportArchiveError");
            }
            this.archiveWriter = archive;
            this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
    }

    private void openArchive() throws IOException {
        if (this.archive != null) {
            this.archiveWriter = new ArchiveWriter(this.archive);
            return;
        }
        File file = new File(this.documentName);
        this.archiveWriter = file.exists() ? (file.isDirectory() ? new FolderArchiveWriter(this.documentName) : new FileArchiveWriter(this.documentName)) : (this.documentName.endsWith("\\") || this.documentName.endsWith("/") ? new FolderArchiveWriter(this.documentName) : new FileArchiveWriter(this.documentName));
    }

    private void openReportDocument() throws EngineException {
        try {
            if (this.archiveWriter == null) {
                this.openArchive();
            }
            String[] exts = this.executionContext.getEngineExtensions();
            this.writer = new ReportDocumentWriter(this.engine, this.archiveWriter, exts);
            this.executionContext.setReportDocWriter(this.writer);
            DocumentDataSource ds = this.executionContext.getDataSource();
            if (ds != null) {
                if (ds.getInstanceID() != null) {
                    this.executionContext.setReportletBookmark(ds.getInstanceID().getComponentID(), ds.getBookmark());
                }
                if (ds.isReportletDocument()) {
                    this.writer.saveReportletDocument(ds.getBookmark(), ds.getInstanceID());
                } else {
                    this.writer.removeReportletDoucment();
                }
            }
        }
        catch (IOException ex) {
            throw new EngineException("Error.ReportArchiveOpenError", ex);
        }
    }

    private void closeReportDocument() {
        this.writer.close();
        this.writer = null;
        this.archive = null;
        this.archiveWriter = null;
        this.documentName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void doRun() throws EngineException {
        block35: {
            block32: {
                block34: {
                    block33: {
                        if (this.progressMonitor != null) {
                            this.progressMonitor.onProgress(1, 1);
                        }
                        this.loadDataSource();
                        this.loadScripts();
                        this.doValidateParameters();
                        design = this.executionContext.getReportDesign();
                        if ("fixed layout".equals(design.getLayoutPreference())) {
                            this.executionContext.setFixedLayout(true);
                            this.setupRenderOption();
                            this.updateRtLFlag();
                        }
                        this.initReportVariable();
                        this.loadDesign();
                        this.prepareDesign();
                        this.startFactory();
                        this.openReportDocument();
                        errList = new ArrayList<String>();
                        try {
                            try {
                                newRunnable = this.writer.saveDesign(this.executionContext.getRunnable(), this.executionContext.getOriginalRunnable());
                                this.executionContext.updateRunnable(newRunnable);
                                this.writer.saveReportIR(this.executionContext.getReport());
                                this.writer.saveParamters(this.inputValues);
                                this.executionContext.openDataEngine();
                                var4_5 = this;
                                synchronized (var4_5) {
                                    if (!this.executionContext.isCanceled()) {
                                        this.documentBuilder = new ReportDocumentBuilder(this.executionContext, this.writer);
                                    }
                                }
                                if (this.documentBuilder != null) {
                                    if (this.pageHandler != null) {
                                        this.documentBuilder.setPageHandler(this.pageHandler);
                                    }
                                    emitter = this.documentBuilder.getContentEmitter();
                                    executor /* !! */  = new ReportExecutor(this.executionContext);
                                    executor /* !! */  = this.createReportExtensionExecutor(executor /* !! */ );
                                    executor /* !! */  = new ReportEmitterExecutor(executor /* !! */ , emitter);
                                    executor /* !! */  = new SuppressDuplciateReportExecutor(executor /* !! */ );
                                    if (this.executionContext.isFixedLayout()) {
                                        executor /* !! */  = new LocalizedReportExecutor(this.executionContext, executor /* !! */ );
                                    }
                                    this.executionContext.setExecutor(executor /* !! */ );
                                    this.initializeContentEmitter(emitter);
                                    this.documentBuilder.build();
                                }
                                this.executionContext.closeDataEngine();
                                break block32;
                            }
                            catch (Throwable t) {
                                errList.add(t.getLocalizedMessage());
                                this.handleFatalExceptions(t);
                                this.documentBuilder = null;
                                this.closeFactory();
                                list = this.executionContext.getAllErrors();
                                if (list == null) break block33;
                                ** for (ex : list)
                            }
                        }
                        catch (Throwable var6_19) {
                            this.documentBuilder = null;
                            this.closeFactory();
                            list = this.executionContext.getAllErrors();
                            if (list == null) break block34;
                            ** for (ex : list)
                        }
lbl-1000:
                        // 1 sources

                        {
                            errList.add(ex.getLocalizedMessage());
                            continue;
                        }
                    }
                    if (!errList.isEmpty()) {
                        statusWriter = new RunStatusWriter(this.archiveWriter);
                        statusWriter.writeRunTaskStatus(errList);
                        statusWriter.close();
                    } else if (this.archiveWriter.exists("/runStatus")) {
                        this.archiveWriter.dropStream("/runStatus");
                    }
                    this.writer.savePersistentObjects(this.executionContext.getGlobalBeans());
                    this.writer.finish();
                    if (this.pageHandler != null && !this.executionContext.isCanceled()) {
                        totalPage = (int)this.executionContext.getTotalPage();
                        docInfo = new ReportDocumentInfo(this.executionContext, totalPage, true);
                        this.pageHandler.onPage(totalPage, true, docInfo);
                    }
                    if (this.progressMonitor != null) {
                        this.progressMonitor.onProgress(2, 1);
                    }
                    this.closeReportDocument();
                    break block35;
lbl-1000:
                    // 1 sources

                    {
                        errList.add(ex.getLocalizedMessage());
                        continue;
                    }
                }
                if (!errList.isEmpty()) {
                    statusWriter = new RunStatusWriter(this.archiveWriter);
                    statusWriter.writeRunTaskStatus(errList);
                    statusWriter.close();
                } else if (this.archiveWriter.exists("/runStatus")) {
                    this.archiveWriter.dropStream("/runStatus");
                }
                this.writer.savePersistentObjects(this.executionContext.getGlobalBeans());
                this.writer.finish();
                if (this.pageHandler != null && !this.executionContext.isCanceled()) {
                    totalPage = (int)this.executionContext.getTotalPage();
                    docInfo = new ReportDocumentInfo(this.executionContext, totalPage, true);
                    this.pageHandler.onPage(totalPage, true, docInfo);
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.onProgress(2, 1);
                }
                this.closeReportDocument();
                throw var6_19;
            }
            this.documentBuilder = null;
            this.closeFactory();
            list = this.executionContext.getAllErrors();
            if (list != null) {
                for (Exception ex : list) {
                    errList.add(ex.getLocalizedMessage());
                }
            }
            if (!errList.isEmpty()) {
                statusWriter = new RunStatusWriter(this.archiveWriter);
                statusWriter.writeRunTaskStatus(errList);
                statusWriter.close();
            } else if (this.archiveWriter.exists("/runStatus")) {
                this.archiveWriter.dropStream("/runStatus");
            }
            this.writer.savePersistentObjects(this.executionContext.getGlobalBeans());
            this.writer.finish();
            if (this.pageHandler != null && !this.executionContext.isCanceled()) {
                totalPage = (int)this.executionContext.getTotalPage();
                docInfo = new ReportDocumentInfo(this.executionContext, totalPage, true);
                this.pageHandler.onPage(totalPage, true, docInfo);
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.onProgress(2, 1);
            }
            this.closeReportDocument();
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void run(FolderArchive fArchive) throws EngineException {
        try {
            this.changeStatusToRunning();
            this.setDataSource((IDocArchiveReader)fArchive);
            this.run((IDocArchiveWriter)fArchive);
        }
        finally {
            this.changeStatusToStopped();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.documentBuilder != null) {
            this.documentBuilder.cancel();
        }
    }

    @Override
    public void setMaxRowsPerQuery(int maxRows) {
        this.executionContext.setMaxRowsPerQuery(maxRows);
    }

    @Override
    public void enableProgressiveViewing(boolean enabled) {
        this.executionContext.enableProgressiveViewing(enabled);
    }

    @Override
    public void setReportDocument(IArchiveFile archive) {
        this.archive = archive;
    }

    @Override
    public void setReportDocument(String name) {
        this.documentName = name;
    }

    @Override
    public void run() throws EngineException {
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
    }
}

