/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.handlers;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public final class PinElementAction
extends SelectionProviderAction
implements IAction {
    public PinElementAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, "Pin");
    }

    public void run() {
        this.getPinnableElements(this.getStructuredSelection(), new DataRequestMonitor<Collection<DeviceThread>>(ImmediateExecutor.getInstance(), null){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                PinElementAction.this.pin((Collection)this.getData());
            }
        });
    }

    protected void pin(Collection<DeviceThread> elements) {
        boolean viewShown = false;
        if (!elements.isEmpty()) {
            for (DeviceThread element : elements) {
                if (DebugUtil.isPinned(element)) {
                    DebugUtil.unpin(element);
                    continue;
                }
                DebugUtil.pin(element);
                if (viewShown) continue;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PinElementAction.this.openDebugView();
                    }
                });
                viewShown = true;
            }
        }
    }

    protected void openDebugView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.debug.ui.DebugView");
        }
        catch (PartInitException e) {
            Activator.log(null, e);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        System.out.printf("[PinElementAction#selectionChanged] %s\n", Thread.currentThread());
        this.getPinnableElements(selection, new DataRequestMonitor<Collection<DeviceThread>>((Executor)DisplayDsfExecutor.getDisplayDsfExecutor((Display)Display.getCurrent()), null){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                System.out.printf("[PinElementAction#selectionChanged#run] %s\n", Thread.currentThread());
                PinElementAction.this.setEnabled(!CoreUtil.isNullOrEmpty((Collection)((Collection)this.getData())));
            }
        });
    }

    private void getPinnableElements(IStructuredSelection selection, DataRequestMonitor<Collection<DeviceThread>> threads) {
        final ConcurrentLinkedQueue<DeviceThread> elements = new ConcurrentLinkedQueue<DeviceThread>();
        if (selection.isEmpty()) {
            threads.done(Collections.emptySet());
        } else {
            int lanes = 0;
            AtomicBoolean canceled = new AtomicBoolean(false);
            final CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), threads);
            for (Object next : selection) {
                if (!(next instanceof IDMVMContext)) continue;
                final IDMContext context = ((IDMVMContext)next).getDMContext();
                if (context instanceof DeviceThread) {
                    elements.add((DeviceThread)context);
                    continue;
                }
                if (context instanceof Lane) {
                    DsfSession.getSession((String)context.getSessionId()).getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            ((Lane)context).toLogicalElement(new DataRequestMonitor<ICudaRuntimeObject>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                                @ConfinedToDsfExecutor(value="fExecutor")
                                protected void handleSuccess() {
                                    if (this.getData() instanceof DeviceThread) {
                                        elements.add((DeviceThread)this.getData());
                                    }
                                    crm.done();
                                }
                            });
                        }
                    });
                    ++lanes;
                    continue;
                }
                threads.done(Collections.emptySet());
                canceled.set(true);
                return;
            }
            if (!canceled.get()) {
                crm.setDoneCount(lanes);
            }
        }
    }
}

