/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.util;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.manifest.AggregateDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.CombinedExpressionOperatorDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FilterExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FunctionExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.result.CustomAggregate;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.CustomExpression;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.CombinedValueExpressionOperator;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.CustomFunction;

public class ExpressionFactory {
    private static final String DOT_SEPARATOR = ".";

    public static CustomExpression createCustomExpression(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        return ExpressionFactory.findCustomFilterDefinition(extensionId, exprId).createExpression();
    }

    public static CustomExpression createCustomExpression(String extensionId, String exprId, ExpressionVariable variable, ExpressionArguments args) throws IllegalArgumentException, OdaException {
        return ExpressionFactory.findCustomFilterDefinition(extensionId, exprId).createExpression(variable, args);
    }

    private static FilterExpressionDefinition findCustomFilterDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        FilterExpressionDefinition filterExprDefn = ResultExtensionExplorer.getInstance().getExtensionFilterDefinition(extensionId, exprId);
        if (filterExprDefn == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.querySpec_NON_DEFINED_CUSTOM_FILTER, (Object)(String.valueOf(extensionId) + DOT_SEPARATOR + exprId)));
        }
        return filterExprDefn;
    }

    public static CustomAggregate createCustomAggregate(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        return ExpressionFactory.findCustomAggregateDefinition(extensionId, exprId).createExpression();
    }

    public static CustomAggregate createCustomAggregate(String extensionId, String exprId, ExpressionVariable variable) throws IllegalArgumentException, OdaException {
        return ExpressionFactory.findCustomAggregateDefinition(extensionId, exprId).createExpression(variable);
    }

    private static AggregateDefinition findCustomAggregateDefinition(String extensionId, String exprId) throws IllegalArgumentException, OdaException {
        AggregateDefinition aggrgExprDefn = ResultExtensionExplorer.getInstance().getExtensionAggregateDefinition(extensionId, exprId);
        if (aggrgExprDefn == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.querySpec_NON_DEFINED_CUSTOM_AGGR, (Object)(String.valueOf(extensionId) + DOT_SEPARATOR + exprId)));
        }
        return aggrgExprDefn;
    }

    public static CombinedValueExpressionOperator getCombinedOperator(String extensionId, String operatorId) throws IllegalArgumentException, OdaException {
        CombinedExpressionOperatorDefinition combinedOpDefn = ResultExtensionExplorer.getInstance().getExtensionCombinedOperatorDefinition(extensionId, operatorId);
        if (combinedOpDefn == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.querySpec_NON_DEFINED_COMBINED_OP, (Object)(String.valueOf(extensionId) + DOT_SEPARATOR + operatorId)));
        }
        return combinedOpDefn.getOperator();
    }

    public static CustomFunction createCustomFunction(String extensionId, String functionId) throws IllegalArgumentException, OdaException {
        return ExpressionFactory.findCustomFunctionDefinition(extensionId, functionId).createExpression();
    }

    private static FunctionExpressionDefinition findCustomFunctionDefinition(String extensionId, String functionId) throws IllegalArgumentException, OdaException {
        FunctionExpressionDefinition functionDefn = ResultExtensionExplorer.getInstance().getExtensionFunctionDefinition(extensionId, functionId);
        if (functionDefn == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.querySpec_NON_DEFINED_CUSTOM_FUNC, (Object)(String.valueOf(extensionId) + DOT_SEPARATOR + functionId)));
        }
        return functionDefn;
    }
}

