/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.xml;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.module.html.DTDMapper;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.xml.XhtmlProcessing;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleHandler
extends DefaultHandler {
    private List _entities = new LinkedList();
    private Map _namespaces = new HashMap();
    private List _processingInsts = new LinkedList();
    private List _messages = new LinkedList();
    private boolean _valid = true;
    private String _root = null;
    private String _dtdURI = null;
    private List _schemas;
    private List _unparsedEntities;
    private int _nErrors = 0;
    private List _notations;
    private Set _attributeVals = new HashSet();
    private static final int MAXERRORS = 2000;
    private boolean _xhtmlFlag = false;
    private HtmlMetadata _htmlMetadata = null;
    private boolean _sigFlag = false;

    public XmlModuleHandler() {
        this._schemas = new LinkedList();
        this._unparsedEntities = new LinkedList();
        this._notations = new LinkedList();
    }

    public void setXhtmlFlag(boolean bl) {
        this._xhtmlFlag = bl;
    }

    public HtmlMetadata getHtmlMetadata() {
        return this._htmlMetadata;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._root == null) {
            this._sigFlag = true;
            this._root = !"".equals(string3) ? string3 : string2;
        }
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string4 = attributes.getLocalName(i);
                String string5 = attributes.getURI(i);
                String string6 = attributes.getValue(i);
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(string5)) {
                    String[] stringArray = new String[2];
                    if ("schemaLocation".equals(string4)) {
                        String[] stringArray2 = string6.split("\\s", 2);
                        stringArray[0] = stringArray2.length > 0 && stringArray2[0] != null ? stringArray2[0].trim() : "";
                        stringArray[1] = stringArray2.length > 1 && stringArray2[1] != null ? stringArray2[1].trim() : "";
                        this._schemas.add(stringArray);
                    }
                    if ("noNamespaceSchemaLocation".equals(string4)) {
                        stringArray[0] = "[None]";
                        stringArray[1] = string6;
                        this._schemas.add(stringArray);
                    }
                }
                this._attributeVals.add(string6);
            }
        }
        if (this._xhtmlFlag) {
            if (this._htmlMetadata == null) {
                this._htmlMetadata = new HtmlMetadata();
            }
            XhtmlProcessing.processElement(string2, string3, attributes, this._htmlMetadata);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this._htmlMetadata != null) {
            this._htmlMetadata.finishPropUnderConstruction();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this._htmlMetadata != null && this._htmlMetadata.getPropUnderConstruction() != null) {
            this._htmlMetadata.addToPropUnderConstruction(cArray, n, n2);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this._namespaces.put(string, string2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this._sigFlag = true;
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray = new String[]{string, string2};
        this._processingInsts.add(stringArray);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        String[] stringArray = new String[]{string, string2, string3};
        this._notations.add(stringArray);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource;
        if (!this._xhtmlFlag && DTDMapper.isXHTMLDTD(string)) {
            this._xhtmlFlag = true;
        }
        if ((inputSource = DTDMapper.publicIDToFile(string)) == null) {
            try {
                inputSource = super.resolveEntity(string, string2);
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        } else {
            inputSource.setSystemId("http://hul.harvard.edu/hul");
        }
        String[] stringArray = new String[]{string, string2};
        this._entities.add(stringArray);
        if (string2.endsWith(".dtd") && this._dtdURI == null) {
            this._dtdURI = string2;
        }
        return inputSource;
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        super.unparsedEntityDecl(string, string2, string3, string4);
        String[] stringArray = new String[]{string == null ? "" : string, string2 == null ? "" : string2, string3 == null ? "" : string3, string4 == null ? "" : string4};
        this._unparsedEntities.add(stringArray);
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        this._messages.add(new InfoMessage(sAXParseException.getMessage()));
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        this._valid = false;
        if (this._nErrors == 2000) {
            this._messages.add(new InfoMessage("Error messages in excess of 2000 not reported"));
        } else if (this._nErrors < 2000) {
            int n = sAXParseException.getLineNumber();
            int n2 = sAXParseException.getColumnNumber();
            this._messages.add(new ErrorMessage(sAXParseException.getMessage().toString(), "Line = " + n + ", Column = " + n2));
        }
        ++this._nErrors;
    }

    public Set getAttributeValues() {
        return this._attributeVals;
    }

    public List getSchemas() {
        return this._schemas;
    }

    public List getUnparsedEntities() {
        return this._unparsedEntities;
    }

    public Map getNamespaces() {
        return this._namespaces;
    }

    public String getDTDURI() {
        return this._dtdURI;
    }

    public List getProcessingInstructions() {
        return this._processingInsts;
    }

    public List getNotations() {
        return this._notations;
    }

    public String getRoot() {
        return this._root;
    }

    public List getMessages() {
        return this._messages;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean getSigFlag() {
        return this._sigFlag;
    }
}

