/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.State;
import edu.harvard.hul.ois.jhove.module.pdf.StringValuedToken;
import edu.harvard.hul.ois.jhove.module.pdf.Tokenizer;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class Literal
extends StringValuedToken {
    private boolean _pdfDocEncoding = true;
    private StringBuffer rawHex = new StringBuffer();
    private StringBuffer buffer = new StringBuffer();
    private boolean haveHi = false;
    private int hi;
    int b1;
    private State _state;
    private boolean _pdfACompliant;
    private int _parenLevel;
    public static char[] PDFDOCENCODING = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u02d8', '\u02c7', '\u02c6', '\u02d9', '\u02dd', '\u02db', '\u02da', '\u02dc', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u2022', '\u2020', '\u2021', '\u2026', '\u2003', '\u2002', '\u0192', '\u2044', '\u2039', '\u203a', '\u2212', '\u2030', '\u201e', '\u201c', '\u201d', '\u2018', '\u2019', '\u201a', '\u2122', '\ufb01', '\ufb02', '\u0141', '\u0152', '\u0160', '\u0178', '\u017d', '\u0131', '\u0142', '\u0153', '\u0161', '\u017e', '\u009f', '\u20ac', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ef', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int BS = 8;
    private static final int HT = 9;
    private static final int FORMFEED = 12;
    private static final int ESC = 27;
    private static final int OPEN_PARENTHESIS = 40;
    private static final int CLOSE_PARENTHESIS = 41;
    private static final int BACKSLASH = 92;
    private static final int FE = 254;
    private static final int FF = 255;

    public void appendHex(int n) throws PdfException {
        if (this._rawBytes == null) {
            this._rawBytes = new Vector(32);
        }
        if (this.haveHi) {
            this._rawBytes.add(new Integer(Literal.hexToInt(this.hi, n)));
            this.haveHi = false;
        } else {
            this.hi = n;
            this.haveHi = true;
        }
    }

    public long processLiteral(Tokenizer tokenizer) throws IOException {
        int n = 0;
        int n2 = 0;
        this._parenLevel = 0;
        this._rawBytes = new Vector(32);
        this._state = State.LITERAL;
        long l = 0L;
        while (true) {
            int n3 = tokenizer.readChar();
            ++l;
            this._rawBytes.add(new Integer(n3));
            if (this._state == State.LITERAL) {
                if (n3 == 254) {
                    this._state = State.LITERAL_FE;
                    continue;
                }
                if (n3 == 41 && --this._parenLevel < 0) {
                    this.setPDFDocEncoding(true);
                    this.setValue(this.buffer.toString());
                    return l;
                }
                if (n3 == 92) {
                    n3 = this.readBackslashSequence(false, tokenizer);
                    if (n3 == 0) continue;
                    if (n3 == 254) {
                        this._state = State.LITERAL_FE;
                        continue;
                    }
                    this.setPDFDocEncoding(true);
                    this.buffer.append(PDFDOCENCODING[n3]);
                    continue;
                }
                if (n3 == 40) {
                    ++this._parenLevel;
                }
                this._state = State.LITERAL_PDF;
                this.setPDFDocEncoding(true);
                this.buffer.append(PDFDOCENCODING[n3]);
                continue;
            }
            if (this._state == State.LITERAL_FE) {
                if (n3 == 255) {
                    this._state = State.LITERAL_UTF16_1;
                    this.setPDFDocEncoding(false);
                    continue;
                }
                if (n3 == 92) {
                    n3 = this.readBackslashSequence(false, tokenizer);
                    if (n3 == 0) continue;
                    if (n3 == 255) {
                        this._state = State.LITERAL_UTF16_1;
                        this.setPDFDocEncoding(false);
                        continue;
                    }
                    this.setPDFDocEncoding(true);
                    this.buffer.append(PDFDOCENCODING[254]);
                    this.buffer.append(PDFDOCENCODING[n3]);
                    continue;
                }
                this._state = State.LITERAL_PDF;
                this.setPDFDocEncoding(true);
                this.buffer.append(PDFDOCENCODING[254]);
                this.buffer.append(PDFDOCENCODING[n3]);
                continue;
            }
            if (this._state == State.LITERAL_PDF) {
                if (n3 == 41 && --this._parenLevel < 0) {
                    this.setValue(this.buffer.toString());
                    return l;
                }
                if (n3 == 92) {
                    n3 = this.readBackslashSequence(false, tokenizer);
                    if (n3 == 0) continue;
                    this.buffer.append(PDFDOCENCODING[n3]);
                    continue;
                }
                this.buffer.append(PDFDOCENCODING[n3]);
                continue;
            }
            if (this._state == State.LITERAL_UTF16_1) {
                if (n3 == 41) {
                    this.setValue(this.buffer.toString());
                    return l;
                }
                if (n3 == 92) {
                    n = this.readBackslashSequence(true, tokenizer);
                    if (n != 0) continue;
                    continue;
                }
                this._state = State.LITERAL_UTF16_2;
                n2 = n3;
                continue;
            }
            if (this._state != State.LITERAL_UTF16_2) continue;
            n = 256 * n2 + n3;
            this._state = State.LITERAL_UTF16_1;
            if (n == 27) {
                this.readUTFLanguageCode(tokenizer);
                continue;
            }
            if (n == 92 && (n = this.readBackslashSequence(false, tokenizer)) == 0) continue;
            this.buffer.append((char)n);
        }
    }

    public void convertHex() throws PdfException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.haveHi) {
            this._rawBytes.add(new Integer(Literal.hexToInt(this.hi, 48)));
        }
        if (this._rawBytes.size() >= 2 && this.rawByte(0) == 254 && this.rawByte(1) == 255) {
            bl = true;
        }
        if (bl) {
            for (int i = 2; i < this._rawBytes.size(); i += 2) {
                stringBuffer.append((char)(this.rawByte(i) * 256 + this.rawByte(i + 1)));
            }
        } else {
            for (int i = 0; i < this._rawBytes.size(); ++i) {
                stringBuffer.append(Tokenizer.PDFDOCENCODING[this.rawByte(i)]);
            }
        }
        this._value = stringBuffer.toString();
    }

    private static int hexToInt(int n, int n2) throws PdfException {
        return 16 * Literal.hexValue(n) + Literal.hexValue(n2);
    }

    private static int hexValue(int n) throws PdfException {
        int n2 = 0;
        if (48 <= n && n <= 57) {
            n2 = n - 48;
        } else if (65 <= n && n <= 70) {
            n2 = n - 55;
        } else if (97 <= n && n <= 102) {
            n2 = n - 87;
        } else {
            throw new PdfMalformedException("Invalid character in hex string");
        }
        return n2;
    }

    private int rawByte(int n) {
        if (n >= this._rawBytes.size()) {
            return 0;
        }
        return (Integer)this._rawBytes.elementAt(n);
    }

    public boolean isPDFDocEncoding() {
        return this._pdfDocEncoding;
    }

    public void setPDFDocEncoding(boolean bl) {
        this._pdfDocEncoding = bl;
    }

    public boolean isDate() {
        return this.parseDate() != null;
    }

    public Date parseDate() {
        int n;
        Calendar calendar;
        int n2;
        int n3;
        char c;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        block32: {
            n9 = 0;
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            c = '?';
            n3 = 0;
            n2 = 0;
            calendar = null;
            String string = this.getValue();
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).length() < 4) {
                return null;
            }
            n = 0;
            int n10 = 0;
            try {
                while (n10 < string.length()) {
                    switch (n) {
                        case 0: {
                            if ("D:".equals(string.substring(n10, n10 + 2))) {
                                n10 += 2;
                            }
                            n = 1;
                            break;
                        }
                        case 1: {
                            n9 = Integer.parseInt(string.substring(n10, n10 + 4));
                            n10 += 4;
                            n = 2;
                            break;
                        }
                        case 2: {
                            n8 = Integer.parseInt(string.substring(n10, n10 + 2));
                            n10 += 2;
                            n = 3;
                            break;
                        }
                        case 3: {
                            n7 = Integer.parseInt(string.substring(n10, n10 + 2));
                            if (n7 < 1 || n7 > 31) {
                                return null;
                            }
                            n10 += 2;
                            n = 4;
                            break;
                        }
                        case 4: {
                            n6 = Integer.parseInt(string.substring(n10, n10 + 2));
                            n10 += 2;
                            n = 5;
                            break;
                        }
                        case 5: {
                            n5 = Integer.parseInt(string.substring(n10, n10 + 2));
                            n10 += 2;
                            n = 6;
                            break;
                        }
                        case 6: {
                            n4 = Integer.parseInt(string.substring(n10, n10 + 2));
                            n10 += 2;
                            n = 7;
                            break;
                        }
                        case 7: {
                            c = string.charAt(n10);
                            if (c != 'Z' && c != '+' && c != '-') {
                                return null;
                            }
                            ++n10;
                            n = 8;
                            break;
                        }
                        case 8: {
                            if (c == '+' || c == '-') {
                                n3 = Integer.parseInt(string.substring(n10, n10 + 2));
                                if (c == '-') {
                                    n3 = -n3;
                                }
                                if (!string.substring(n10 + 2, n10 + 3).equals("'")) {
                                    return null;
                                }
                                n10 += 3;
                            }
                            n = 9;
                            break;
                        }
                        case 9: {
                            if (c == '+' || c == '-') {
                                if (string.charAt(n10) == '\'') {
                                    n2 = Integer.parseInt(string.substring(n10, n10 + 2));
                                }
                                if (c == '-') {
                                    n2 = -n2;
                                }
                                if (!string.substring(n10 + 2, n10 + 3).equals("'")) {
                                    return null;
                                }
                            }
                            break block32;
                        }
                    }
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (n < 2) {
            return null;
        }
        if (c != '?') {
            Cloneable cloneable;
            String string = "GMT";
            if (c == 'Z') {
                string = string + "+0000";
            } else {
                string = string + c;
                cloneable = NumberFormat.getInstance();
                ((NumberFormat)cloneable).setMinimumIntegerDigits(2);
                ((NumberFormat)cloneable).setMaximumIntegerDigits(2);
                string = string + ((NumberFormat)cloneable).format(n3);
                string = string + ((NumberFormat)cloneable).format(n2);
            }
            cloneable = TimeZone.getTimeZone(string);
            calendar = Calendar.getInstance((TimeZone)cloneable);
        } else {
            calendar = Calendar.getInstance();
        }
        calendar.set(n9, n8 - 1, n7, n6, n5, n4);
        return calendar.getTime();
    }

    public boolean isPDFACompliant() {
        return this._pdfACompliant;
    }

    private int readBackslashSequence(boolean bl, Tokenizer tokenizer) throws IOException {
        int n = tokenizer.readChar1(bl);
        if (n >= 48 && n <= 55) {
            int n2 = n - 48;
            for (int i = 0; i < 2; ++i) {
                int n3 = tokenizer.readChar1(bl);
                if (n3 < 48 || n3 > 55) {
                    tokenizer.backupChar();
                    this._pdfACompliant = false;
                    return n2;
                }
                n2 = n2 * 8 + (n3 - 48);
            }
            return n2;
        }
        switch (n) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 104: {
                return 8;
            }
            case 102: {
                return 12;
            }
            case 40: {
                return 40;
            }
            case 41: {
                return 41;
            }
            case 92: {
                return 92;
            }
        }
        return 0;
    }

    private void readUTFLanguageCode(Tokenizer tokenizer) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = tokenizer.readChar1(true)) != 27) {
            stringBuffer.append((char)n);
        }
        tokenizer.addLanguageCode(stringBuffer.toString());
    }
}

