/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetMenuItemUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;

public class VsnetMenuUI
extends VsnetMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic = true;
    private boolean isMouseOver = false;
    private PopupMenuListener popupMenuListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new VsnetMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.menuItem instanceof JMenu) {
            ((JMenu)this.menuItem).setDelay(200);
        }
        crossMenuMnemonic = UIDefaultsLookup.getBoolean("Menu.crossMenuMnemonic");
    }

    @Override
    protected String getPropertyPrefix() {
        return "Menu";
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        int n;
        int n2;
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n2 = jMenuItem.getWidth();
            n = jMenuItem.getHeight();
        } else {
            n2 = jMenuItem.getHeight();
            n = jMenuItem.getWidth();
        }
        Color color3 = this.getPainter().getMenuItemBorderColor();
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n2, n);
        }
        Rectangle rectangle = new Rectangle(0, 0, n2, n);
        if (jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            if (((JMenu)jMenuItem).getPopupMenu().isVisible()) {
                if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
                    this.getPainter().paintMenuItemBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0, false);
                    graphics.setColor(color3);
                    graphics.drawLine(0, 0, n2 - 1, 0);
                    graphics.drawLine(n2 - 1, 0, n2 - 1, n - 1);
                    graphics.drawLine(0, n - 1, 0, 1);
                    graphics.drawLine(0, n - 1, n2 - 1, n - 1);
                } else {
                    this.getPainter().paintMenuItemBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 0, false);
                    graphics.setColor(color3);
                    graphics.drawLine(0, n - 1, n2 - 1, n - 1);
                    graphics.drawLine(n2 - 1, 0, n2 - 1, n);
                    graphics.drawLine(0, n - 1, 0, 1);
                    graphics.drawLine(0, 0, n2 - 1, 0);
                }
            } else {
                this.getPainter().paintMenuItemBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
            }
        } else if (this.isMouseOver() && buttonModel.isEnabled()) {
            this.getPainter().paintMenuItemBackground(jMenuItem, graphics, rectangle, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
        }
        if (this.isDownArrowVisible(jMenuItem.getParent())) {
            graphics.setColor(jMenuItem.isEnabled() ? Color.BLACK : Color.GRAY);
            int n3 = n2 - 9;
            graphics.drawLine(n3 - 2, n / 2 - 1, n3 + 2, n / 2 - 1);
            graphics.drawLine(n3 - 1, n / 2, n3 + 1, n / 2);
            graphics.drawLine(n3, n / 2 + 1, n3, n / 2 + 1);
        }
        graphics.setColor(color2);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null && this.menuItem instanceof JMenu) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
        if (this.popupMenuListener == null) {
            this.popupMenuListener = this.createPopupMenuListener();
        }
        if (this.popupMenuListener != null && this.menuItem instanceof JMenu) {
            ((JMenu)this.menuItem).getPopupMenu().addPopupMenuListener(this.popupMenuListener);
        }
    }

    protected PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.repaint();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.repaint();
            }

            private void repaint() {
                if (VsnetMenuUI.this.menuItem != null) {
                    VsnetMenuUI.this.menuItem.repaint();
                }
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    protected void updateMnemonicBinding() {
        int n = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
        if (nArray == null) {
            nArray = new int[]{8};
        }
        if (n == this.lastMnemonic) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (int n2 : nArray) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n2, false));
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n2, true));
            }
        }
        if (n != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (int n2 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n, n2, false), "selectMenu");
            }
        }
        this.lastMnemonic = n;
    }

    @Override
    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    @Override
    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    @Override
    protected ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null && this.menuItem instanceof JMenu) {
            actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return new MenuHandler();
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    @Override
    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        this.changeListener = null;
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyChangeListener = null;
        if (this.menuListener != null && this.menuItem instanceof JMenu) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.menuListener = null;
        if (this.popupMenuListener != null && this.menuItem instanceof JMenu) {
            ((JMenu)this.menuItem).getPopupMenu().removePopupMenuListener(this.popupMenuListener);
        }
        this.popupMenuListener = null;
    }

    @Override
    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    @Override
    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                return new Dimension(dimension.width, Short.MAX_VALUE);
            }
            return new Dimension(Short.MAX_VALUE, dimension.height);
        }
        return null;
    }

    protected static void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    protected static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i = menuElementArray.length - 1; i >= 0; --i) {
            MenuElement menuElement = menuElementArray[i];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        int n;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            int n2;
            if (jMenuItem.getComponentOrientation().isLeftToRight()) {
                n2 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
                n = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
                rectangle.x = n + n2;
            } else {
                n2 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
                n = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
                rectangle.x = VsnetMenuUI.viewRect.width - (n + n2 + rectangle.width);
            }
        }
        if (!buttonModel.isEnabled()) {
            WindowsGraphicsUtils.paintText((Graphics)graphics, (AbstractButton)jMenuItem, (Rectangle)rectangle, (String)string, (int)0);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isSelected() && jMenuItem instanceof JMenu && !((JMenu)jMenuItem).isTopLevelMenu()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(color);
        }
    }

    protected void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
        this.menuItem.getModel().setRollover(this.isMouseOver);
    }

    protected boolean isMouseOver() {
        return this.isMouseOver;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu() && this.isDownArrowVisible(this.menuItem.getParent())) {
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                dimension.width += 11;
            } else {
                dimension.height += 11;
            }
        }
        return dimension;
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            JPopupMenu jPopupMenu;
            if (!crossMenuMnemonic && (jPopupMenu = VsnetMenuUI.getActivePopupMenu()) != null && jPopupMenu != VsnetMenuUI.this.menuItem.getParent()) {
                return;
            }
            int n = VsnetMenuUI.this.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            if (this.lower((char)n) == this.lower(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu2 = ((JMenu)VsnetMenuUI.this.menuItem).getPopupMenu();
                ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>(Arrays.asList(menuElementArray));
                arrayList.add(jPopupMenu2);
                MenuElement[] menuElementArray2 = jPopupMenu2.getSubElements();
                if (menuElementArray2.length > 0) {
                    arrayList.add(menuElementArray2[0]);
                }
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray3 = new MenuElement[]{};
                menuElementArray3 = arrayList.toArray(menuElementArray3);
                menuSelectionManager.setSelectedPath(menuElementArray3);
                menuKeyEvent.consume();
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            char c = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            for (int i = menuElementArray2.length - 1; i >= 0; --i) {
                if (menuElementArray2[i] != VsnetMenuUI.this.menuItem) continue;
                JPopupMenu jPopupMenu = ((JMenu)VsnetMenuUI.this.menuItem).getPopupMenu();
                if (!jPopupMenu.isVisible()) {
                    return;
                }
                MenuElement[] menuElementArray3 = jPopupMenu.getSubElements();
                MenuElement menuElement = menuElementArray2[menuElementArray2.length - 1];
                int n = -1;
                int n2 = 0;
                int n3 = -1;
                int[] nArray = null;
                for (int j = 0; j < menuElementArray3.length; ++j) {
                    if (!(menuElementArray3[j] instanceof JMenuItem)) continue;
                    int n4 = ((JMenuItem)menuElementArray3[j]).getMnemonic();
                    if (this.lower((char)n4) == this.lower(c)) {
                        if (n2 == 0) {
                            n3 = j;
                            ++n2;
                        } else {
                            if (nArray == null) {
                                nArray = new int[menuElementArray3.length];
                                nArray[0] = n3;
                            }
                            nArray[n2++] = j;
                        }
                    }
                    if (menuElement != menuElementArray3[j]) continue;
                    n = n2 - 1;
                }
                if (n2 != 0) {
                    if (n2 == 1) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray3[n3];
                        if (!(jMenuItem instanceof JMenu)) {
                            menuSelectionManager.clearSelectedPath();
                            jMenuItem.doClick();
                        }
                    } else {
                        MenuElement menuElement2 = null;
                        if (nArray != null) {
                            menuElement2 = menuElementArray3[nArray[(n + 1) % n2]];
                        }
                        MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                        menuElementArray4[menuElementArray.length] = jPopupMenu;
                        menuElementArray4[menuElementArray.length + 1] = menuElement2;
                        menuSelectionManager.setSelectedPath(menuElementArray4);
                    }
                }
                menuKeyEvent.consume();
                return;
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c) {
            return Character.toLowerCase(c);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!(VsnetMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            if (!VsnetMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < VsnetMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < VsnetMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)VsnetMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        VsnetMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        VsnetMenuUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    private class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            if (!(VsnetMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)menuEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.isComponentPartOfCurrentMenu(jMenu)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (!(VsnetMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)VsnetMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.getParent() instanceof JMenuBar || jMenu.getParent() instanceof TopLevelMenuContainer) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = this.getFirstParentMenuElement(jMenu);
                    if (object != null && object instanceof MenuElement) {
                        ArrayList<MenuElement[]> arrayList = new ArrayList<MenuElement[]>();
                        while (object instanceof MenuElement) {
                            arrayList.add(0, (MenuElement[])object);
                            if (object instanceof JPopupMenu) {
                                object = (Container)((JPopupMenu)object).getInvoker();
                                continue;
                            }
                            object = this.getFirstParentMenuElement((Component)object);
                        }
                        MenuElement[] menuElementArray = new MenuElement[arrayList.size() + 1];
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Container container = (Container)arrayList.get(i);
                            menuElementArray[i] = (MenuElement)((Object)container);
                        }
                        menuElementArray[arrayList.size()] = jMenu;
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    } else {
                        MenuElement[] menuElementArray = new MenuElement[]{jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    VsnetMenuUI.appendPath(object, jMenu.getPopupMenu());
                } else {
                    VsnetMenuUI.setupPostTimer(jMenu);
                }
            }
        }

        protected Container getFirstParentMenuElement(Component component) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof MenuElement)) continue;
                return container;
            }
            return null;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!(VsnetMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)VsnetMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!(VsnetMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)VsnetMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        VsnetMenuUI.appendPath(VsnetMenuUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(VsnetMenuUI.this.getPath());
                        VsnetMenuUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                VsnetMenuUI.this.setMouseOver(true);
            }
            VsnetMenuUI.this.menuItem.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            VsnetMenuUI.this.setMouseOver(false);
            VsnetMenuUI.this.menuItem.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!(VsnetMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)VsnetMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                VsnetMenuUI.this.updateMnemonicBinding();
            } else if (string.equals("buttonStyle")) {
                AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
                abstractButton.repaint();
            } else if ("verticalTextPosition".equals(string) || "horizontalTextPosition".equals(string)) {
                AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
                abstractButton.updateUI();
            }
        }
    }

    protected static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;
        private static final long serialVersionUID = 8723756757971612903L;

        PostAction(JMenu jMenu, boolean bl) {
            this.menu = jMenu;
            this.force = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!crossMenuMnemonic && (object = VsnetMenuUI.getActivePopupMenu()) != null && object != this.menu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu()};
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    VsnetMenuUI.appendPath(menuElementArray, this.menu.getPopupMenu());
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

