/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CloseableIterator;

public abstract class AbstractIlluminaPositionFileReader
implements CloseableIterator<PositionInfo> {
    public static final float MAX_POS = 1.0E7f;
    private static Pattern FileNamePattern = Pattern.compile("^s_(\\d+)_(\\d+)(_pos\\.txt|\\.locs|\\.clocs|_pos\\.txt.gz|_pos\\.txt.bz2)$");
    private final File file;
    private final int lane;
    private final int tile;

    public AbstractIlluminaPositionFileReader(File file) {
        this.file = file;
        int[] laneAndTile = this.fileNameToLaneAndTile(file.getName());
        this.lane = laneAndTile[0];
        this.tile = laneAndTile[1];
    }

    public int getTile() {
        return this.tile;
    }

    public int getLane() {
        return this.lane;
    }

    public File getFile() {
        return this.file;
    }

    private int[] fileNameToLaneAndTile(String fileName) {
        String[] tokens = fileName.split(File.pathSeparator);
        Matcher matcher = FileNamePattern.matcher(tokens[tokens.length - 1]);
        if (!matcher.matches()) {
            throw new PicardException("File name not of the right structure: <filePath>/s_<lane>_<tile>(_pos.txt|_pos.txt.gz|_pos.txt.bz2.locs|.clocs).  File name (" + fileName + ")");
        }
        return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))};
    }

    public final PositionInfo next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such cluster, cluster count(" + this.makeExceptionMsg() + ")");
        }
        return this.unsafeNextInfo();
    }

    protected abstract PositionInfo unsafeNextInfo();

    protected abstract String makeExceptionMsg();

    public abstract boolean hasNext();

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class PositionInfo {
        public final float xPos;
        public final float yPos;
        public final int lane;
        public final int tile;
        public final int xQseqCoord;
        public final int yQseqCoord;

        public PositionInfo(float x, float y, int lane, int tile) {
            if (x < 0.0f || y < 0.0f) {
                throw new IllegalArgumentException("X and Y position values must be positive (x,y)=(" + x + ", y) lane(" + lane + ") tile(" + tile + ")");
            }
            if (x > 1.0E7f || y > 1.0E7f) {
                throw new IllegalArgumentException("X and Y position values must be less than 1.0E7 (x,y)=(" + x + ", y) lane(" + lane + ") tile(" + tile + ")");
            }
            this.xPos = x;
            this.yPos = y;
            this.xQseqCoord = this.posToQSeqCoord(x);
            this.yQseqCoord = this.posToQSeqCoord(y);
            this.lane = lane;
            this.tile = tile;
        }

        private int posToQSeqCoord(float pos) {
            return Math.round(pos * 10.0f + 1000.0f);
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != PositionInfo.class) {
                return false;
            }
            if (other == this) {
                return true;
            }
            PositionInfo otherPi = (PositionInfo)other;
            return this.xPos == otherPi.xPos && this.yPos == otherPi.yPos && this.lane == otherPi.lane && this.tile == otherPi.tile && this.xQseqCoord == otherPi.xQseqCoord && this.yQseqCoord == otherPi.yQseqCoord;
        }
    }
}

