/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.TileMetricsOutReader;
import net.sf.picard.util.CollectionUtil;

public class TileMetricsUtil {
    private static final Integer DENSITY_ID_CODE = 100;
    private static final Integer CLUSTER_ID_CODE = 102;
    public static String INTEROP_SUBDIRECTORY_NAME = "InterOp";
    public static String TILE_METRICS_OUT_FILE_NAME = "TileMetricsOut.bin";

    public static File renderTileMetricsFileFromBasecallingDirectory(File illuminaRunDirectory) {
        return new File(new File(illuminaRunDirectory, INTEROP_SUBDIRECTORY_NAME), TILE_METRICS_OUT_FILE_NAME);
    }

    public static Collection<Tile> parseTileMetrics(File tileMetricsOutFile) throws FileNotFoundException {
        Collection<TileMetricsOutReader.IlluminaTileMetrics> metrics = CollectionUtil.makeCollection(new TileMetricsOutReader(tileMetricsOutFile));
        Map<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> locationToMetricsMap = CollectionUtil.partition(metrics, new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, String>(){

            @Override
            public String getPartition(TileMetricsOutReader.IlluminaTileMetrics metric) {
                return TileMetricsUtil.renderMetricLocationKey(metric);
            }
        });
        LinkedList<Tile> tiles = new LinkedList<Tile>();
        for (Map.Entry<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> entry : locationToMetricsMap.entrySet()) {
            Collection<TileMetricsOutReader.IlluminaTileMetrics> tileRecords = entry.getValue();
            Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> codeMetricsMap = CollectionUtil.partition(tileRecords, new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, Integer>(){

                @Override
                public Integer getPartition(TileMetricsOutReader.IlluminaTileMetrics metric) {
                    return metric.getMetricCode();
                }
            });
            Set<Integer> observedCodes = codeMetricsMap.keySet();
            if (!observedCodes.contains(DENSITY_ID_CODE) || !observedCodes.contains(CLUSTER_ID_CODE)) {
                throw new PicardException(String.format("Expected to find cluster and density record codes (%s and %s) in records read for tile location %s (lane:tile), but found only %s.", CLUSTER_ID_CODE, DENSITY_ID_CODE, entry.getKey(), observedCodes));
            }
            TileMetricsOutReader.IlluminaTileMetrics densityRecord = CollectionUtil.getSoleElement(codeMetricsMap.get(DENSITY_ID_CODE));
            TileMetricsOutReader.IlluminaTileMetrics clusterRecord = CollectionUtil.getSoleElement(codeMetricsMap.get(CLUSTER_ID_CODE));
            tiles.add(new Tile(densityRecord.getLaneNumber(), densityRecord.getTileNumber(), densityRecord.getMetricValue(), clusterRecord.getMetricValue()));
        }
        return Collections.unmodifiableCollection(tiles);
    }

    private static String renderMetricLocationKey(TileMetricsOutReader.IlluminaTileMetrics metric) {
        return String.format("%s:%s", metric.getLaneNumber(), metric.getTileNumber());
    }

    public static class Tile {
        private final int lane;
        private final int tile;
        private final float density;
        private final float clusters;

        protected Tile(int lane, int tile, float density, float clusters) {
            this.lane = lane;
            this.tile = tile;
            this.density = density;
            this.clusters = clusters;
        }

        public int getLaneNumber() {
            return this.lane;
        }

        public int getTileNumber() {
            return this.tile;
        }

        public float getClusterDensity() {
            return this.density;
        }

        public float getClusterCount() {
            return this.clusters;
        }
    }
}

