// Copyright (C) 2015 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
es6id: 25.4.5.4
description: >
    `Symbol.toStringTag` property descriptor
info: |
    The initial value of the @@toStringTag property is the String value
    "Promise".

    This property has the attributes { [[Writable]]: false, [[Enumerable]]:
    false, [[Configurable]]: true }.
includes: [propertyHelper.js]
features: [Symbol.toStringTag]
---*/

assert.sameValue(Promise.prototype[Symbol.toStringTag], 'Promise');

verifyNotEnumerable(Promise.prototype, Symbol.toStringTag);
verifyNotWritable(Promise.prototype, Symbol.toStringTag);
verifyConfigurable(Promise.prototype, Symbol.toStringTag);

reportCompare(0, 0);
